import{s as Gt,n as Nt,o as Bt}from"../chunks/scheduler.0b596ca5.js";import{S as xt,i as Et,e as p,s as a,c as i,h as vt,a as m,d as e,b as n,f as Wt,g as o,j as d,k as Ct,l as Qt,m as l,n as r,t as c,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Vt,H as A,E as Yt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as X}from"../chunks/CodeBlock.9f18e41e.js";function Xt(wt){let g,F,_,S,j,z,w,H,J,Jt='<strong>FBNet</strong> is a type of convolutional neural architectures discovered through <a href="https://paperswithcode.com/method/dnas" rel="nofollow">DNAS</a> neural architecture search. It utilises a basic type of image model block inspired by <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetv2</a> that utilises depthwise convolutions and an inverted residual structure (see components).',L,y,yt='The principal building block is the <a href="https://paperswithcode.com/method/fbnet-block" rel="nofollow">FBNet Block</a>.',D,u,q,T,ut="To load a pretrained model:",P,f,K,b,Tt="To load and preprocess the image:",O,U,tt,$,ft="To get the model predictions:",st,I,et,Z,bt="To get the top-5 predictions class names:",lt,k,at,W,Ut="Replace the model name with the variant you want to use, e.g. <code>fbnetc_100</code>. You can find the IDs in the model summaries at the top of this page.",nt,C,$t='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,G,mt,N,It="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",it,B,ot,x,Zt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,rt,E,ct,v,kt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ht,Q,Mt,V,dt,Y,gt,R,jt;return j=new Vt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new A({props:{title:"FBNet",local:"fbnet",headingTag:"h1"}}),u=new A({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2ZibmV0Y18xMDAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;fbnetc_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),G=new A({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZmJuZXRjXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;fbnetc_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new A({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new A({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new X({props:{code:"JTQwbWlzYyU3Qnd1MjAxOWZibmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JGQk5ldCUzQSUyMEhhcmR3YXJlLUF3YXJlJTIwRWZmaWNpZW50JTIwQ29udk5ldCUyMERlc2lnbiUyMHZpYSUyMERpZmZlcmVudGlhYmxlJTIwTmV1cmFsJTIwQXJjaGl0ZWN0dXJlJTIwU2VhcmNoJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQmljaGVuJTIwV3UlMjBhbmQlMjBYaWFvbGlhbmclMjBEYWklMjBhbmQlMjBQZWl6aGFvJTIwWmhhbmclMjBhbmQlMjBZYW5naGFuJTIwV2FuZyUyMGFuZCUyMEZlaSUyMFN1biUyMGFuZCUyMFlpbWluZyUyMFd1JTIwYW5kJTIwWXVhbmRvbmclMjBUaWFuJTIwYW5kJTIwUGV0ZXIlMjBWYWpkYSUyMGFuZCUyMFlhbmdxaW5nJTIwSmlhJTIwYW5kJTIwS3VydCUyMEtldXR6ZXIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE4MTIuMDM0NDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{wu<span class="hljs-symbol">2019f</span>bnet,
      title={FBNet: Hardware-Aware Efficient ConvNet Design via <span class="hljs-keyword">Differentiable </span>Neural Architecture Search}, 
      author={<span class="hljs-keyword">Bichen </span>Wu <span class="hljs-keyword">and </span>Xiaoliang Dai <span class="hljs-keyword">and </span>Peizhao Zhang <span class="hljs-keyword">and </span>Yanghan Wang <span class="hljs-keyword">and </span>Fei Sun <span class="hljs-keyword">and </span>Yiming Wu <span class="hljs-keyword">and </span>Yuandong Tian <span class="hljs-keyword">and </span>Peter Vajda <span class="hljs-keyword">and </span>Yangqing <span class="hljs-keyword">Jia </span><span class="hljs-keyword">and </span>Kurt Keutzer},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1812</span>.<span class="hljs-number">03443</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Y=new Yt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/fbnet.mdx"}}),{c(){g=p("meta"),F=a(),_=p("p"),S=a(),i(j.$$.fragment),z=a(),i(w.$$.fragment),H=a(),J=p("p"),J.innerHTML=Jt,L=a(),y=p("p"),y.innerHTML=yt,D=a(),i(u.$$.fragment),q=a(),T=p("p"),T.textContent=ut,P=a(),i(f.$$.fragment),K=a(),b=p("p"),b.textContent=Tt,O=a(),i(U.$$.fragment),tt=a(),$=p("p"),$.textContent=ft,st=a(),i(I.$$.fragment),et=a(),Z=p("p"),Z.textContent=bt,lt=a(),i(k.$$.fragment),at=a(),W=p("p"),W.innerHTML=Ut,nt=a(),C=p("p"),C.innerHTML=$t,pt=a(),i(G.$$.fragment),mt=a(),N=p("p"),N.textContent=It,it=a(),i(B.$$.fragment),ot=a(),x=p("p"),x.innerHTML=Zt,rt=a(),i(E.$$.fragment),ct=a(),v=p("p"),v.innerHTML=kt,ht=a(),i(Q.$$.fragment),Mt=a(),i(V.$$.fragment),dt=a(),i(Y.$$.fragment),gt=a(),R=p("p"),this.h()},l(t){const s=vt("svelte-u9bgzb",document.head);g=m(s,"META",{name:!0,content:!0}),s.forEach(e),F=n(t),_=m(t,"P",{}),Wt(_).forEach(e),S=n(t),o(j.$$.fragment,t),z=n(t),o(w.$$.fragment,t),H=n(t),J=m(t,"P",{"data-svelte-h":!0}),d(J)!=="svelte-112qqgm"&&(J.innerHTML=Jt),L=n(t),y=m(t,"P",{"data-svelte-h":!0}),d(y)!=="svelte-u55bao"&&(y.innerHTML=yt),D=n(t),o(u.$$.fragment,t),q=n(t),T=m(t,"P",{"data-svelte-h":!0}),d(T)!=="svelte-18ywhxh"&&(T.textContent=ut),P=n(t),o(f.$$.fragment,t),K=n(t),b=m(t,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1c2ipa8"&&(b.textContent=Tt),O=n(t),o(U.$$.fragment,t),tt=n(t),$=m(t,"P",{"data-svelte-h":!0}),d($)!=="svelte-1n9qsq1"&&($.textContent=ft),st=n(t),o(I.$$.fragment,t),et=n(t),Z=m(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-19cnvx1"&&(Z.textContent=bt),lt=n(t),o(k.$$.fragment,t),at=n(t),W=m(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-18ctdhs"&&(W.innerHTML=Ut),nt=n(t),C=m(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1wmi3ea"&&(C.innerHTML=$t),pt=n(t),o(G.$$.fragment,t),mt=n(t),N=m(t,"P",{"data-svelte-h":!0}),d(N)!=="svelte-9sr7nh"&&(N.textContent=It),it=n(t),o(B.$$.fragment,t),ot=n(t),x=m(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-1kguc51"&&(x.innerHTML=Zt),rt=n(t),o(E.$$.fragment,t),ct=n(t),v=m(t,"P",{"data-svelte-h":!0}),d(v)!=="svelte-xtxxu6"&&(v.innerHTML=kt),ht=n(t),o(Q.$$.fragment,t),Mt=n(t),o(V.$$.fragment,t),dt=n(t),o(Y.$$.fragment,t),gt=n(t),R=m(t,"P",{}),Wt(R).forEach(e),this.h()},h(){Ct(g,"name","hf:doc:metadata"),Ct(g,"content",_t)},m(t,s){Qt(document.head,g),l(t,F,s),l(t,_,s),l(t,S,s),r(j,t,s),l(t,z,s),r(w,t,s),l(t,H,s),l(t,J,s),l(t,L,s),l(t,y,s),l(t,D,s),r(u,t,s),l(t,q,s),l(t,T,s),l(t,P,s),r(f,t,s),l(t,K,s),l(t,b,s),l(t,O,s),r(U,t,s),l(t,tt,s),l(t,$,s),l(t,st,s),r(I,t,s),l(t,et,s),l(t,Z,s),l(t,lt,s),r(k,t,s),l(t,at,s),l(t,W,s),l(t,nt,s),l(t,C,s),l(t,pt,s),r(G,t,s),l(t,mt,s),l(t,N,s),l(t,it,s),r(B,t,s),l(t,ot,s),l(t,x,s),l(t,rt,s),r(E,t,s),l(t,ct,s),l(t,v,s),l(t,ht,s),r(Q,t,s),l(t,Mt,s),r(V,t,s),l(t,dt,s),r(Y,t,s),l(t,gt,s),l(t,R,s),jt=!0},p:Nt,i(t){jt||(c(j.$$.fragment,t),c(w.$$.fragment,t),c(u.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c(I.$$.fragment,t),c(k.$$.fragment,t),c(G.$$.fragment,t),c(B.$$.fragment,t),c(E.$$.fragment,t),c(Q.$$.fragment,t),c(V.$$.fragment,t),c(Y.$$.fragment,t),jt=!0)},o(t){h(j.$$.fragment,t),h(w.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(I.$$.fragment,t),h(k.$$.fragment,t),h(G.$$.fragment,t),h(B.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),h(V.$$.fragment,t),h(Y.$$.fragment,t),jt=!1},d(t){t&&(e(F),e(_),e(S),e(z),e(H),e(J),e(L),e(y),e(D),e(q),e(T),e(P),e(K),e(b),e(O),e(tt),e($),e(st),e(et),e(Z),e(lt),e(at),e(W),e(nt),e(C),e(pt),e(mt),e(N),e(it),e(ot),e(x),e(rt),e(ct),e(v),e(ht),e(Mt),e(dt),e(gt),e(R)),e(g),M(j,t),M(w,t),M(u,t),M(f,t),M(U,t),M(I,t),M(k,t),M(G,t),M(B,t),M(E,t),M(Q,t),M(V,t),M(Y,t)}}}const _t='{"title":"FBNet","local":"fbnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Rt(wt){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends xt{constructor(g){super(),Et(this,g,Rt,Xt,Gt,{})}}export{Ht as component};
