import{s as xs,n as Bs,o as Gs}from"../chunks/scheduler.0b596ca5.js";import{S as Ns,i as Es,e as p,s as a,c as i,h as Rs,a as m,d as l,b as n,f as ks,g as o,j as h,k as Ws,l as As,m as e,n as r,t as M,o as c,p as J}from"../chunks/index.d9d53bd3.js";import{C as Qs,H as Y,E as vs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as V}from"../chunks/CodeBlock.9f18e41e.js";function Vs(gs){let w,z,S,H,T,X,g,F,y,ys='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',L,j,js='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',D,d,q,u,ds="To load a pretrained model:",P,b,K,f,us="To load and preprocess the image:",O,U,ss,I,bs="To get the model predictions:",ts,C,ls,$,fs="To get the top-5 predictions class names:",es,Z,as,k,Us="Replace the model name with the variant you want to use, e.g. <code>gluon_resnet101_v1b</code>. You can find the IDs in the model summaries at the top of this page.",ns,W,Is='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ps,x,ms,B,Cs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",is,G,os,N,$s=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,rs,E,Ms,R,Zs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',cs,A,Js,Q,hs,v,ws,_,Ts;return T=new Qs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new Y({props:{title:"(Gluon) ResNet",local:"gluon-resnet",headingTag:"h1"}}),d=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3Jlc25ldDEwMV92MWInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_resnet101_v1b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),x=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25fcmVzbmV0MTAxX3YxYiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_resnet101_v1b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),A=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new V({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZIZVpSUzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCS2FpbWluZyUyMEhlJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWGlhbmd5dSUyMFpoYW5nJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU2hhb3FpbmclMjBSZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBKaWFuJTIwU3VuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JEZWVwJTIwUmVzaWR1YWwlMjBMZWFybmluZyUyMGZvciUyMEltYWdlJTIwUmVjb2duaXRpb24lN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE1MTIuMDMzODUlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNSU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNTEyLjAzMzg1JTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTUxMi4wMzM4NSU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3QldlZCUyQyUyMDE3JTIwQXByJTIwMjAxOSUyMDE3JTNBMjMlM0E0NSUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGSGVaUlMxNS5iaWIlN0QlMkMlMEElMjAlMjBiaWJzb3VyY2UlMjAlM0QlMjAlN0JkYmxwJTIwY29tcHV0ZXIlMjBzY2llbmNlJTIwYmlibGlvZ3JhcGh5JTJDJTIwaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyU3RCUwQSU3RA==",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>HeZRS15,
  author    = {Kaiming He and
               Xiangyu Zhang and
               Shaoqing Ren and
               Jian Sun},
  title     = {Deep Residual Learning <span class="hljs-keyword">for</span> Image Recognition},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.03385</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.03385</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.03385</span>},
  timestamp = {Wed, <span class="hljs-number">17</span> Apr <span class="hljs-number">2019</span> <span class="hljs-number">17</span>:<span class="hljs-number">23</span>:<span class="hljs-number">45</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>HeZRS15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),v=new vs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/gloun-resnet.mdx"}}),{c(){w=p("meta"),z=a(),S=p("p"),H=a(),i(T.$$.fragment),X=a(),i(g.$$.fragment),F=a(),y=p("p"),y.innerHTML=ys,L=a(),j=p("p"),j.innerHTML=js,D=a(),i(d.$$.fragment),q=a(),u=p("p"),u.textContent=ds,P=a(),i(b.$$.fragment),K=a(),f=p("p"),f.textContent=us,O=a(),i(U.$$.fragment),ss=a(),I=p("p"),I.textContent=bs,ts=a(),i(C.$$.fragment),ls=a(),$=p("p"),$.textContent=fs,es=a(),i(Z.$$.fragment),as=a(),k=p("p"),k.innerHTML=Us,ns=a(),W=p("p"),W.innerHTML=Is,ps=a(),i(x.$$.fragment),ms=a(),B=p("p"),B.textContent=Cs,is=a(),i(G.$$.fragment),os=a(),N=p("p"),N.innerHTML=$s,rs=a(),i(E.$$.fragment),Ms=a(),R=p("p"),R.innerHTML=Zs,cs=a(),i(A.$$.fragment),Js=a(),i(Q.$$.fragment),hs=a(),i(v.$$.fragment),ws=a(),_=p("p"),this.h()},l(s){const t=Rs("svelte-u9bgzb",document.head);w=m(t,"META",{name:!0,content:!0}),t.forEach(l),z=n(s),S=m(s,"P",{}),ks(S).forEach(l),H=n(s),o(T.$$.fragment,s),X=n(s),o(g.$$.fragment,s),F=n(s),y=m(s,"P",{"data-svelte-h":!0}),h(y)!=="svelte-p6ybkz"&&(y.innerHTML=ys),L=n(s),j=m(s,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1vag5uc"&&(j.innerHTML=js),D=n(s),o(d.$$.fragment,s),q=n(s),u=m(s,"P",{"data-svelte-h":!0}),h(u)!=="svelte-18ywhxh"&&(u.textContent=ds),P=n(s),o(b.$$.fragment,s),K=n(s),f=m(s,"P",{"data-svelte-h":!0}),h(f)!=="svelte-1c2ipa8"&&(f.textContent=us),O=n(s),o(U.$$.fragment,s),ss=n(s),I=m(s,"P",{"data-svelte-h":!0}),h(I)!=="svelte-1n9qsq1"&&(I.textContent=bs),ts=n(s),o(C.$$.fragment,s),ls=n(s),$=m(s,"P",{"data-svelte-h":!0}),h($)!=="svelte-19cnvx1"&&($.textContent=fs),es=n(s),o(Z.$$.fragment,s),as=n(s),k=m(s,"P",{"data-svelte-h":!0}),h(k)!=="svelte-frqp5b"&&(k.innerHTML=Us),ns=n(s),W=m(s,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1wmi3ea"&&(W.innerHTML=Is),ps=n(s),o(x.$$.fragment,s),ms=n(s),B=m(s,"P",{"data-svelte-h":!0}),h(B)!=="svelte-9sr7nh"&&(B.textContent=Cs),is=n(s),o(G.$$.fragment,s),os=n(s),N=m(s,"P",{"data-svelte-h":!0}),h(N)!=="svelte-1kguc51"&&(N.innerHTML=$s),rs=n(s),o(E.$$.fragment,s),Ms=n(s),R=m(s,"P",{"data-svelte-h":!0}),h(R)!=="svelte-xtxxu6"&&(R.innerHTML=Zs),cs=n(s),o(A.$$.fragment,s),Js=n(s),o(Q.$$.fragment,s),hs=n(s),o(v.$$.fragment,s),ws=n(s),_=m(s,"P",{}),ks(_).forEach(l),this.h()},h(){Ws(w,"name","hf:doc:metadata"),Ws(w,"content",Ss)},m(s,t){As(document.head,w),e(s,z,t),e(s,S,t),e(s,H,t),r(T,s,t),e(s,X,t),r(g,s,t),e(s,F,t),e(s,y,t),e(s,L,t),e(s,j,t),e(s,D,t),r(d,s,t),e(s,q,t),e(s,u,t),e(s,P,t),r(b,s,t),e(s,K,t),e(s,f,t),e(s,O,t),r(U,s,t),e(s,ss,t),e(s,I,t),e(s,ts,t),r(C,s,t),e(s,ls,t),e(s,$,t),e(s,es,t),r(Z,s,t),e(s,as,t),e(s,k,t),e(s,ns,t),e(s,W,t),e(s,ps,t),r(x,s,t),e(s,ms,t),e(s,B,t),e(s,is,t),r(G,s,t),e(s,os,t),e(s,N,t),e(s,rs,t),r(E,s,t),e(s,Ms,t),e(s,R,t),e(s,cs,t),r(A,s,t),e(s,Js,t),r(Q,s,t),e(s,hs,t),r(v,s,t),e(s,ws,t),e(s,_,t),Ts=!0},p:Bs,i(s){Ts||(M(T.$$.fragment,s),M(g.$$.fragment,s),M(d.$$.fragment,s),M(b.$$.fragment,s),M(U.$$.fragment,s),M(C.$$.fragment,s),M(Z.$$.fragment,s),M(x.$$.fragment,s),M(G.$$.fragment,s),M(E.$$.fragment,s),M(A.$$.fragment,s),M(Q.$$.fragment,s),M(v.$$.fragment,s),Ts=!0)},o(s){c(T.$$.fragment,s),c(g.$$.fragment,s),c(d.$$.fragment,s),c(b.$$.fragment,s),c(U.$$.fragment,s),c(C.$$.fragment,s),c(Z.$$.fragment,s),c(x.$$.fragment,s),c(G.$$.fragment,s),c(E.$$.fragment,s),c(A.$$.fragment,s),c(Q.$$.fragment,s),c(v.$$.fragment,s),Ts=!1},d(s){s&&(l(z),l(S),l(H),l(X),l(F),l(y),l(L),l(j),l(D),l(q),l(u),l(P),l(K),l(f),l(O),l(ss),l(I),l(ts),l(ls),l($),l(es),l(as),l(k),l(ns),l(W),l(ps),l(ms),l(B),l(is),l(os),l(N),l(rs),l(Ms),l(R),l(cs),l(Js),l(hs),l(ws),l(_)),l(w),J(T,s),J(g,s),J(d,s),J(b,s),J(U,s),J(C,s),J(Z,s),J(x,s),J(G,s),J(E,s),J(A,s),J(Q,s),J(v,s)}}}const Ss='{"title":"(Gluon) ResNet","local":"gluon-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function _s(gs){return Gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fs extends Ns{constructor(w){super(),Es(this,w,_s,Vs,xs,{})}}export{Fs as component};
