import{s as Wt,n as Nt,o as vt}from"../chunks/scheduler.0b596ca5.js";import{S as Bt,i as kt,e as p,s as a,c as m,h as Et,a as i,d as l,b as n,f as Ct,g as o,j as M,k as Gt,l as Qt,m as e,n as c,t as r,o as h,p as g}from"../chunks/index.d9d53bd3.js";import{C as Xt,H as Y,E as _t}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as R}from"../chunks/CodeBlock.9f18e41e.js";function Rt(dt){let J,H,V,S,u,A,d,F,j,jt='<strong>Xception</strong> is a convolutional neural network architecture that relies solely on <a href="https://paperswithcode.com/method/depthwise-separable-convolution" rel="nofollow">depthwise separable convolution</a> layers.',L,w,wt='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',D,y,P,T,yt="To load a pretrained model:",q,f,K,b,Tt="To load and preprocess the image:",O,U,tt,$,ft="To get the model predictions:",st,I,lt,x,bt="To get the top-5 predictions class names:",et,Z,at,C,Ut="Replace the model name with the variant you want to use, e.g. <code>gluon_xception65</code>. You can find the IDs in the model summaries at the top of this page.",nt,G,$t='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,W,it,N,It="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",mt,v,ot,B,xt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ct,k,rt,E,Zt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ht,Q,gt,X,Mt,_,Jt,z,ut;return u=new Xt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new Y({props:{title:"(Gluon) Xception",local:"gluon-xception",headingTag:"h1"}}),y=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3hjZXB0aW9uNjUnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_xception65&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),v=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25feGNlcHRpb242NSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_xception65&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),k=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),X=new R({props:{code:"JTQwbWlzYyU3QmNob2xsZXQyMDE3eGNlcHRpb24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlhjZXB0aW9uJTNBJTIwRGVlcCUyMExlYXJuaW5nJTIwd2l0aCUyMERlcHRod2lzZSUyMFNlcGFyYWJsZSUyMENvbnZvbHV0aW9ucyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkZyYW4lQzMlQTdvaXMlMjBDaG9sbGV0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxNjEwLjAyMzU3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{chollet2017xception,
      title={Xception: Deep Learning with Depthwise Separable Convolutions}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{François Chollet}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2017}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1610.02357}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),_=new _t({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/gloun-xception.mdx"}}),{c(){J=p("meta"),H=a(),V=p("p"),S=a(),m(u.$$.fragment),A=a(),m(d.$$.fragment),F=a(),j=p("p"),j.innerHTML=jt,L=a(),w=p("p"),w.innerHTML=wt,D=a(),m(y.$$.fragment),P=a(),T=p("p"),T.textContent=yt,q=a(),m(f.$$.fragment),K=a(),b=p("p"),b.textContent=Tt,O=a(),m(U.$$.fragment),tt=a(),$=p("p"),$.textContent=ft,st=a(),m(I.$$.fragment),lt=a(),x=p("p"),x.textContent=bt,et=a(),m(Z.$$.fragment),at=a(),C=p("p"),C.innerHTML=Ut,nt=a(),G=p("p"),G.innerHTML=$t,pt=a(),m(W.$$.fragment),it=a(),N=p("p"),N.textContent=It,mt=a(),m(v.$$.fragment),ot=a(),B=p("p"),B.innerHTML=xt,ct=a(),m(k.$$.fragment),rt=a(),E=p("p"),E.innerHTML=Zt,ht=a(),m(Q.$$.fragment),gt=a(),m(X.$$.fragment),Mt=a(),m(_.$$.fragment),Jt=a(),z=p("p"),this.h()},l(t){const s=Et("svelte-u9bgzb",document.head);J=i(s,"META",{name:!0,content:!0}),s.forEach(l),H=n(t),V=i(t,"P",{}),Ct(V).forEach(l),S=n(t),o(u.$$.fragment,t),A=n(t),o(d.$$.fragment,t),F=n(t),j=i(t,"P",{"data-svelte-h":!0}),M(j)!=="svelte-2dpud"&&(j.innerHTML=jt),L=n(t),w=i(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1vag5uc"&&(w.innerHTML=wt),D=n(t),o(y.$$.fragment,t),P=n(t),T=i(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-18ywhxh"&&(T.textContent=yt),q=n(t),o(f.$$.fragment,t),K=n(t),b=i(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1c2ipa8"&&(b.textContent=Tt),O=n(t),o(U.$$.fragment,t),tt=n(t),$=i(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-1n9qsq1"&&($.textContent=ft),st=n(t),o(I.$$.fragment,t),lt=n(t),x=i(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-19cnvx1"&&(x.textContent=bt),et=n(t),o(Z.$$.fragment,t),at=n(t),C=i(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-zau0t5"&&(C.innerHTML=Ut),nt=n(t),G=i(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1wmi3ea"&&(G.innerHTML=$t),pt=n(t),o(W.$$.fragment,t),it=n(t),N=i(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-9sr7nh"&&(N.textContent=It),mt=n(t),o(v.$$.fragment,t),ot=n(t),B=i(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1kguc51"&&(B.innerHTML=xt),ct=n(t),o(k.$$.fragment,t),rt=n(t),E=i(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-xtxxu6"&&(E.innerHTML=Zt),ht=n(t),o(Q.$$.fragment,t),gt=n(t),o(X.$$.fragment,t),Mt=n(t),o(_.$$.fragment,t),Jt=n(t),z=i(t,"P",{}),Ct(z).forEach(l),this.h()},h(){Gt(J,"name","hf:doc:metadata"),Gt(J,"content",Vt)},m(t,s){Qt(document.head,J),e(t,H,s),e(t,V,s),e(t,S,s),c(u,t,s),e(t,A,s),c(d,t,s),e(t,F,s),e(t,j,s),e(t,L,s),e(t,w,s),e(t,D,s),c(y,t,s),e(t,P,s),e(t,T,s),e(t,q,s),c(f,t,s),e(t,K,s),e(t,b,s),e(t,O,s),c(U,t,s),e(t,tt,s),e(t,$,s),e(t,st,s),c(I,t,s),e(t,lt,s),e(t,x,s),e(t,et,s),c(Z,t,s),e(t,at,s),e(t,C,s),e(t,nt,s),e(t,G,s),e(t,pt,s),c(W,t,s),e(t,it,s),e(t,N,s),e(t,mt,s),c(v,t,s),e(t,ot,s),e(t,B,s),e(t,ct,s),c(k,t,s),e(t,rt,s),e(t,E,s),e(t,ht,s),c(Q,t,s),e(t,gt,s),c(X,t,s),e(t,Mt,s),c(_,t,s),e(t,Jt,s),e(t,z,s),ut=!0},p:Nt,i(t){ut||(r(u.$$.fragment,t),r(d.$$.fragment,t),r(y.$$.fragment,t),r(f.$$.fragment,t),r(U.$$.fragment,t),r(I.$$.fragment,t),r(Z.$$.fragment,t),r(W.$$.fragment,t),r(v.$$.fragment,t),r(k.$$.fragment,t),r(Q.$$.fragment,t),r(X.$$.fragment,t),r(_.$$.fragment,t),ut=!0)},o(t){h(u.$$.fragment,t),h(d.$$.fragment,t),h(y.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(I.$$.fragment,t),h(Z.$$.fragment,t),h(W.$$.fragment,t),h(v.$$.fragment,t),h(k.$$.fragment,t),h(Q.$$.fragment,t),h(X.$$.fragment,t),h(_.$$.fragment,t),ut=!1},d(t){t&&(l(H),l(V),l(S),l(A),l(F),l(j),l(L),l(w),l(D),l(P),l(T),l(q),l(K),l(b),l(O),l(tt),l($),l(st),l(lt),l(x),l(et),l(at),l(C),l(nt),l(G),l(pt),l(it),l(N),l(mt),l(ot),l(B),l(ct),l(rt),l(E),l(ht),l(gt),l(Mt),l(Jt),l(z)),l(J),g(u,t),g(d,t),g(y,t),g(f,t),g(U,t),g(I,t),g(Z,t),g(W,t),g(v,t),g(k,t),g(Q,t),g(X,t),g(_,t)}}}const Vt='{"title":"(Gluon) Xception","local":"gluon-xception","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function zt(dt){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Bt{constructor(J){super(),kt(this,J,zt,Rt,Wt,{})}}export{Ft as component};
