import{s as Lt,n as qt,o as Dt}from"../chunks/scheduler.0b596ca5.js";import{S as Pt,i as Kt,e as p,s as l,c as m,q as F,H as Zt,h as Ot,a as o,d as a,b as n,f as Ct,g as r,j as u,r as A,u as Wt,k as St,l as y,m as e,n as h,t as c,o as g,p as d}from"../chunks/index.d9d53bd3.js";import{C as ts,H as L,E as ss}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as H}from"../chunks/CodeBlock.9f18e41e.js";function as(Bt){let M,q,S,D,J,P,j,K,i,X,Gt="HRNet",$t,Y,vt="High-Resolution Net",xt,O,zt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>n</mi></mrow><annotation encoding="application/x-tex"> n </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal">n</span></span></span></span>',tt,st,Ft='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>n</mi></mrow><annotation encoding="application/x-tex"> n </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal">n</span></span></span></span>',at,et,At='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>n</mi></mrow><annotation encoding="application/x-tex"> n </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal">n</span></span></span></span>',lt,nt,T,it,f,Nt="To load a pretrained model:",pt,b,ot,U,_t="To load and preprocess the image:",mt,I,rt,k,Et="To get the model predictions:",ht,$,ct,x,Rt="To get the top-5 predictions class names:",gt,Z,dt,C,Qt="Replace the model name with the variant you want to use, e.g. <code>hrnet_w18</code>. You can find the IDs in the model summaries at the top of this page.",wt,W,Vt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ut,B,Mt,G,Xt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",yt,v,Jt,N,Yt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,jt,_,Tt,E,Ht='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ft,R,bt,Q,Ut,V,It,z,kt;return J=new ts({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new L({props:{title:"HRNet",local:"hrnet",headingTag:"h1"}}),T=new L({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new H({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2hybmV0X3cxOCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;hrnet_w18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),I=new H({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new H({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new H({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new L({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),v=new H({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaHJuZXRfdzE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;hrnet_w18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),_=new L({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),R=new L({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new H({props:{code:"JTQwbWlzYyU3QnN1bjIwMTloaWdocmVzb2x1dGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCSGlnaC1SZXNvbHV0aW9uJTIwUmVwcmVzZW50YXRpb25zJTIwZm9yJTIwTGFiZWxpbmclMjBQaXhlbHMlMjBhbmQlMjBSZWdpb25zJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCS2UlMjBTdW4lMjBhbmQlMjBZYW5nJTIwWmhhbyUyMGFuZCUyMEJvcnVpJTIwSmlhbmclMjBhbmQlMjBUaWFuaGVuZyUyMENoZW5nJTIwYW5kJTIwQmluJTIwWGlhbyUyMGFuZCUyMERvbmclMjBMaXUlMjBhbmQlMjBZYWRvbmclMjBNdSUyMGFuZCUyMFhpbmdnYW5nJTIwV2FuZyUyMGFuZCUyMFdlbnl1JTIwTGl1JTIwYW5kJTIwSmluZ2RvbmclMjBXYW5nJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA0LjA0NTE0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{sun2019highresolution,
      title={High-Resolution Representations for Labeling Pixels <span class="hljs-keyword">and </span>Regions},
      author={Ke Sun <span class="hljs-keyword">and </span>Yang Zhao <span class="hljs-keyword">and </span><span class="hljs-keyword">Borui </span><span class="hljs-keyword">Jiang </span><span class="hljs-keyword">and </span>Tianheng Cheng <span class="hljs-keyword">and </span><span class="hljs-keyword">Bin </span>Xiao <span class="hljs-keyword">and </span>Dong Liu <span class="hljs-keyword">and </span>Yadong Mu <span class="hljs-keyword">and </span>Xinggang Wang <span class="hljs-keyword">and </span>Wenyu Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Jingdong </span>Wang},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1904</span>.<span class="hljs-number">04514</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),V=new ss({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/hrnet.mdx"}}),{c(){M=p("meta"),q=l(),S=p("p"),D=l(),m(J.$$.fragment),P=l(),m(j.$$.fragment),K=l(),i=p("p"),X=p("strong"),X.textContent=Gt,$t=F(", or "),Y=p("strong"),Y.textContent=vt,xt=F(", is a general purpose convolutional neural network for tasks like semantic segmentation, object detection and image classification. It is able to maintain high resolution representations through the whole process. We start from a high-resolution convolution stream, gradually add high-to-low resolution convolution streams one by one, and connect the multi-resolution streams in parallel. The resulting network consists of several (\\( 4 \\) in the paper) stages and the"),O=new Zt(!1),tt=F("th stage contains"),st=new Zt(!1),at=F(" streams corresponding to"),et=new Zt(!1),lt=F(" resolutions. The authors conduct repeated multi-resolution fusions by exchanging the information across the parallel streams over and over."),nt=l(),m(T.$$.fragment),it=l(),f=p("p"),f.textContent=Nt,pt=l(),m(b.$$.fragment),ot=l(),U=p("p"),U.textContent=_t,mt=l(),m(I.$$.fragment),rt=l(),k=p("p"),k.textContent=Et,ht=l(),m($.$$.fragment),ct=l(),x=p("p"),x.textContent=Rt,gt=l(),m(Z.$$.fragment),dt=l(),C=p("p"),C.innerHTML=Qt,wt=l(),W=p("p"),W.innerHTML=Vt,ut=l(),m(B.$$.fragment),Mt=l(),G=p("p"),G.textContent=Xt,yt=l(),m(v.$$.fragment),Jt=l(),N=p("p"),N.innerHTML=Yt,jt=l(),m(_.$$.fragment),Tt=l(),E=p("p"),E.innerHTML=Ht,ft=l(),m(R.$$.fragment),bt=l(),m(Q.$$.fragment),Ut=l(),m(V.$$.fragment),It=l(),z=p("p"),this.h()},l(t){const s=Ot("svelte-u9bgzb",document.head);M=o(s,"META",{name:!0,content:!0}),s.forEach(a),q=n(t),S=o(t,"P",{}),Ct(S).forEach(a),D=n(t),r(J.$$.fragment,t),P=n(t),r(j.$$.fragment,t),K=n(t),i=o(t,"P",{});var w=Ct(i);X=o(w,"STRONG",{"data-svelte-h":!0}),u(X)!=="svelte-xrpqk9"&&(X.textContent=Gt),$t=A(w,", or "),Y=o(w,"STRONG",{"data-svelte-h":!0}),u(Y)!=="svelte-1tonmeo"&&(Y.textContent=vt),xt=A(w,", is a general purpose convolutional neural network for tasks like semantic segmentation, object detection and image classification. It is able to maintain high resolution representations through the whole process. We start from a high-resolution convolution stream, gradually add high-to-low resolution convolution streams one by one, and connect the multi-resolution streams in parallel. The resulting network consists of several (\\( 4 \\) in the paper) stages and the"),O=Wt(w,!1),tt=A(w,"th stage contains"),st=Wt(w,!1),at=A(w," streams corresponding to"),et=Wt(w,!1),lt=A(w," resolutions. The authors conduct repeated multi-resolution fusions by exchanging the information across the parallel streams over and over."),w.forEach(a),nt=n(t),r(T.$$.fragment,t),it=n(t),f=o(t,"P",{"data-svelte-h":!0}),u(f)!=="svelte-18ywhxh"&&(f.textContent=Nt),pt=n(t),r(b.$$.fragment,t),ot=n(t),U=o(t,"P",{"data-svelte-h":!0}),u(U)!=="svelte-1c2ipa8"&&(U.textContent=_t),mt=n(t),r(I.$$.fragment,t),rt=n(t),k=o(t,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1n9qsq1"&&(k.textContent=Et),ht=n(t),r($.$$.fragment,t),ct=n(t),x=o(t,"P",{"data-svelte-h":!0}),u(x)!=="svelte-19cnvx1"&&(x.textContent=Rt),gt=n(t),r(Z.$$.fragment,t),dt=n(t),C=o(t,"P",{"data-svelte-h":!0}),u(C)!=="svelte-17maku0"&&(C.innerHTML=Qt),wt=n(t),W=o(t,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1wmi3ea"&&(W.innerHTML=Vt),ut=n(t),r(B.$$.fragment,t),Mt=n(t),G=o(t,"P",{"data-svelte-h":!0}),u(G)!=="svelte-9sr7nh"&&(G.textContent=Xt),yt=n(t),r(v.$$.fragment,t),Jt=n(t),N=o(t,"P",{"data-svelte-h":!0}),u(N)!=="svelte-1kguc51"&&(N.innerHTML=Yt),jt=n(t),r(_.$$.fragment,t),Tt=n(t),E=o(t,"P",{"data-svelte-h":!0}),u(E)!=="svelte-xtxxu6"&&(E.innerHTML=Ht),ft=n(t),r(R.$$.fragment,t),bt=n(t),r(Q.$$.fragment,t),Ut=n(t),r(V.$$.fragment,t),It=n(t),z=o(t,"P",{}),Ct(z).forEach(a),this.h()},h(){St(M,"name","hf:doc:metadata"),St(M,"content",es),O.a=tt,st.a=at,et.a=lt},m(t,s){y(document.head,M),e(t,q,s),e(t,S,s),e(t,D,s),h(J,t,s),e(t,P,s),h(j,t,s),e(t,K,s),e(t,i,s),y(i,X),y(i,$t),y(i,Y),y(i,xt),O.m(zt,i),y(i,tt),st.m(Ft,i),y(i,at),et.m(At,i),y(i,lt),e(t,nt,s),h(T,t,s),e(t,it,s),e(t,f,s),e(t,pt,s),h(b,t,s),e(t,ot,s),e(t,U,s),e(t,mt,s),h(I,t,s),e(t,rt,s),e(t,k,s),e(t,ht,s),h($,t,s),e(t,ct,s),e(t,x,s),e(t,gt,s),h(Z,t,s),e(t,dt,s),e(t,C,s),e(t,wt,s),e(t,W,s),e(t,ut,s),h(B,t,s),e(t,Mt,s),e(t,G,s),e(t,yt,s),h(v,t,s),e(t,Jt,s),e(t,N,s),e(t,jt,s),h(_,t,s),e(t,Tt,s),e(t,E,s),e(t,ft,s),h(R,t,s),e(t,bt,s),h(Q,t,s),e(t,Ut,s),h(V,t,s),e(t,It,s),e(t,z,s),kt=!0},p:qt,i(t){kt||(c(J.$$.fragment,t),c(j.$$.fragment,t),c(T.$$.fragment,t),c(b.$$.fragment,t),c(I.$$.fragment,t),c($.$$.fragment,t),c(Z.$$.fragment,t),c(B.$$.fragment,t),c(v.$$.fragment,t),c(_.$$.fragment,t),c(R.$$.fragment,t),c(Q.$$.fragment,t),c(V.$$.fragment,t),kt=!0)},o(t){g(J.$$.fragment,t),g(j.$$.fragment,t),g(T.$$.fragment,t),g(b.$$.fragment,t),g(I.$$.fragment,t),g($.$$.fragment,t),g(Z.$$.fragment,t),g(B.$$.fragment,t),g(v.$$.fragment,t),g(_.$$.fragment,t),g(R.$$.fragment,t),g(Q.$$.fragment,t),g(V.$$.fragment,t),kt=!1},d(t){t&&(a(q),a(S),a(D),a(P),a(K),a(i),a(nt),a(it),a(f),a(pt),a(ot),a(U),a(mt),a(rt),a(k),a(ht),a(ct),a(x),a(gt),a(dt),a(C),a(wt),a(W),a(ut),a(Mt),a(G),a(yt),a(Jt),a(N),a(jt),a(Tt),a(E),a(ft),a(bt),a(Ut),a(It),a(z)),a(M),d(J,t),d(j,t),d(T,t),d(b,t),d(I,t),d($,t),d(Z,t),d(B,t),d(v,t),d(_,t),d(R,t),d(Q,t),d(V,t)}}}const es='{"title":"HRNet","local":"hrnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function ls(Bt){return Dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends Pt{constructor(M){super(),Kt(this,M,ls,as,Lt,{})}}export{ms as component};
