import{s as Ss,n as _s,o as Xs}from"../chunks/scheduler.0b596ca5.js";import{S as Gs,i as Ws,e as M,s as a,c as p,h as Rs,a as h,d as s,b as n,f as Is,g as i,j as u,k as Vs,l as zs,m as l,n as r,t as m,o,p as c}from"../chunks/index.d9d53bd3.js";import{C as Fs,H as d,E as Ds}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as y}from"../chunks/CodeBlock.9f18e41e.js";function Es(ls){let f,_e,Ve,Xe,J,Ge,j,We,g,as="All of the models in <code>timm</code> have consistent mechanisms for obtaining various types of features from the model for tasks besides classification.",Re,U,ze,T,ns="The features from the penultimate model layer can be obtained in several ways without requiring model surgery (although feel free to do surgery). One must first decide if they want pooled or un-pooled features.",Fe,w,De,b,ps="There are three ways to obtain unpooled features. The final, unpooled features are sometimes referred to as the last hidden state. In <code>timm</code> this is up to and including the final normalization layer (in e.g. ViT style models) but does not include pooling / class token selection and final post-pooling layers.",Ee,$,is="Without modifying the network, one can call <code>model.forward_features(input)</code> on any model instead of the usual <code>model(input)</code>. This will bypass the head classifier and global pooling for networks.",Ye,C,rs="If one wants to explicitly modify the network to return unpooled features, they can either create the model without a classifier and pooling, or remove it later. Both paths remove the parameters associated with the classifier from the network.",He,k,Ae,x,Le,Q,ms="Output:",Ke,N,Pe,B,Oe,Z,qe,v,os="Output:",et,I,tt,V,st,S,lt,_,cs="Output:",at,X,nt,G,pt,W,Ms="The last hidden state can be fed back into the head of the model using the <code>forward_head()</code> function.",it,R,rt,z,hs="Output:",mt,F,ot,D,ct,E,us="To modify the network to return pooled features, one can use <code>forward_features()</code> and pool/flatten the result themselves, or modify the network like above but keep pooling intact.",Mt,Y,ht,H,ut,A,ys="Output:",yt,L,dt,K,ft,P,Jt,O,ds="Output:",jt,q,gt,ee,Ut,te,fs="Object detection, segmentation, keypoint, and a variety of dense pixel tasks require access to feature maps from the backbone network at multiple scales. This is often done by modifying the original classification network. Since each network varies quite a bit in structure, it’s not uncommon to see only a few backbones supported in any given obj detection or segmentation library.",Tt,se,Js="<code>timm</code> allows a consistent interface for creating any of the included models as feature backbones that output feature maps for selected levels.",wt,le,js="A feature backbone can be created by adding the argument <code>features_only=True</code> to any <code>create_model</code> call. By default most models with a feature hierarchy will output up to 5 features up to a reduction of 32. However this varies per model, some models have fewer hierarchy levels, and some (like ViT) have a larger number of non-hierarchical feature maps and they default to outputting the last 3. The <code>out_indices</code> arg can be passed to <code>create_model</code> to specify which features you want.",bt,ae,$t,ne,Ct,pe,gs="Output:",kt,ie,xt,re,Qt,me,Us="After a feature backbone has been created, it can be queried to provide channel or resolution reduction information to the downstream heads without requiring static config or hardcoded constants. The <code>.feature_info</code> attribute is a class encapsulating the information about the feature extraction points.",Nt,oe,Bt,ce,Ts="Output:",Zt,Me,vt,he,It,ue,ws="There are two additional creation arguments impacting the output features.",Vt,ye,bs="<li><code>out_indices</code> selects which indices to output</li> <li><code>output_stride</code> limits the feature output stride of the network (also works in classification mode BTW)</li>",St,de,_t,fe,$s="The <code>out_indices</code> argument is supported by all models, but not all models have the same index to feature stride mapping. Look at the code or check feature_info to compare. The out indices generally correspond to the <code>C(i+1)th</code> feature level (a <code>2^(i+1)</code> reduction). For most convnet models, index 0 is the stride 2 features, and index 4 is stride 32. For many ViT or ViT-Conv hybrids there may be many to all features maps of the same shape, or a combination of hierarchical and non-hierarchical feature maps. It is best to look at the <code>feature_info</code> attribute to see the number of features, their corresponding channel count and reduction level.",Xt,Je,Cs="<code>out_indices</code> supports negative indexing, this makes it easy to get the last, penultimate, etc feature map. <code>out_indices=(-2,)</code> would return the penultimate feature map for any model.",Gt,je,Wt,ge,ks="<code>output_stride</code> is achieved by converting layers to use dilated convolutions. Doing so is not always straightforward, some networks only support <code>output_stride=32</code>.",Rt,Ue,zt,Te,xs="Output:",Ft,we,Dt,be,Et,$e,Qs="In addition to using <code>features_only</code> with the model factory, many models support a <code>forward_intermediates()</code> method which provides a flexible mechanism for extracting both the intermediate feature maps and the last hidden state (which can be chained to the head). Additionally this method supports some model specific features such as returning class or distill prefix tokens for some models.",Yt,Ce,Ns="Accompanying the <code>forward_intermediates</code> function is a <code>prune_intermediate_layers</code> function that allows one to prune layers from the model, including both the head, final norm, and/or trailing blocks/stages that are not needed.",Ht,ke,Bs="An <code>indices</code> argument is used for both <code>forward_intermediates()</code> and <code>prune_intermediate_layers()</code> to select the features to return or layers to remove. As with the <code>out_indices</code> for <code>features_only</code> API, <code>indices</code> is model specific and selects which intermediates are returned.",At,xe,Zs="In non-hierarchical block based models such as ViT the indices correspond to the blocks, in models with hierarchical stages they usually correspond to the output of the stem + each hierarchical stage. Both positive (from the start), and negative (relative to the end) indexing works, and <code>None</code> is used to return all intermediates.",Lt,Qe,vs="The <code>prune_intermediate_layers()</code> call returns an indices variable, as negative indices must be converted to absolute (positive) indices when the model is trimmed.",Kt,Ne,Pt,Be,Ot,Ze,qt,ve,es,Ie,ts,Se,ss;return J=new Fs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new d({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h1"}}),U=new d({props:{title:"Penultimate Layer Features (Pre-Classifier Features)",local:"penultimate-layer-features-pre-classifier-features",headingTag:"h2"}}),w=new d({props:{title:"Unpooled",local:"unpooled",headingTag:"h3"}}),k=new d({props:{title:"forward_features()",local:"forwardfeatures",headingTag:"h4"}}),x=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCd4Y2VwdGlvbjQxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW8lMjAlM0QlMjBtKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjk5JTJDJTIwMjk5KSklMEFwcmludChmJ09yaWdpbmFsJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyklMEFvJTIwJTNEJTIwbS5mb3J3YXJkX2ZlYXR1cmVzKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjk5JTJDJTIwMjk5KSklMEFwcmludChmJ1VucG9vbGVkJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;xception41&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">299</span>, <span class="hljs-number">299</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m.forward_features(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">299</span>, <span class="hljs-number">299</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),N=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBVW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjAxMCUyQyUyMDEwJTVEKQ==",highlighted:`Original shape: torch.Size([2, 1000])
Unpooled shape: torch.Size([2, 2048, 10, 10])`,wrap:!1}}),B=new d({props:{title:"Create with no classifier and pooling",local:"create-with-no-classifier-and-pooling",headingTag:"h4"}}),Z=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEMCUyQyUyMGdsb2JhbF9wb29sJTNEJycpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQXByaW50KGYnVW5wb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">0</span>, global_pool=<span class="hljs-string">&#x27;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),I=new y({props:{code:"VW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:"Unpooled shape: torch.Size([2, 2048, 7, 7])",wrap:!1}}),V=new d({props:{title:"Remove it later",local:"remove-it-later",headingTag:"h4"}}),S=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdkZW5zZW5ldDEyMSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidPcmlnaW5hbCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcpJTBBbS5yZXNldF9jbGFzc2lmaWVyKDAlMkMlMjAnJyklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidVbnBvb2xlZCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.reset_classifier(<span class="hljs-number">0</span>, <span class="hljs-string">&#x27;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),X=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBVW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMjQlMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`Original shape: torch.Size([2, 1000])
Unpooled shape: torch.Size([2, 1024, 7, 7])`,wrap:!1}}),G=new d({props:{title:"Chaining unpooled output to classifier",local:"chaining-unpooled-output-to-classifier",headingTag:"h4"}}),R=new y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndml0X21lZGl1bV9wYXRjaDE2X3JlZzFfZ2FwXzI1NiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFvdXRwdXQlMjAlM0QlMjBtb2RlbC5mb3J3YXJkX2ZlYXR1cmVzKHRvcmNoLnJhbmRuKDIlMkMzJTJDMjU2JTJDMjU2KSklMEFwcmludCgnVW5wb29sZWQlMjBvdXRwdXQlMjBzaGFwZSUzQSclMkMlMjBvdXRwdXQuc2hhcGUpJTBBY2xhc3NpZmllZCUyMCUzRCUyMG1vZGVsLmZvcndhcmRfaGVhZChvdXRwdXQpJTBBcHJpbnQoJ0NsYXNzaWZpY2F0aW9uJTIwb3V0cHV0JTIwc2hhcGUlM0EnJTJDJTIwY2xhc3NpZmllZC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;vit_medium_patch16_reg1_gap_256&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.forward_features(torch.randn(<span class="hljs-number">2</span>,<span class="hljs-number">3</span>,<span class="hljs-number">256</span>,<span class="hljs-number">256</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Unpooled output shape:&#x27;</span>, output.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span>classified = model.forward_head(output)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Classification output shape:&#x27;</span>, classified.shape)`,wrap:!1}}),F=new y({props:{code:"VW5wb29sZWQlMjBvdXRwdXQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDI1NyUyQyUyMDUxMiU1RCklMEFDbGFzc2lmaWNhdGlvbiUyMG91dHB1dCUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwMTAwMCU1RCk=",highlighted:`Unpooled output shape: torch.Size([2, 257, 512])
Classification output shape: torch.Size([2, 1000])`,wrap:!1}}),D=new d({props:{title:"Pooled",local:"pooled",headingTag:"h3"}}),Y=new d({props:{title:"Create with no classifier",local:"create-with-no-classifier",headingTag:"h4"}}),H=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEMCklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidQb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Pooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),L=new y({props:{code:"UG9vbGVkJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjAyMDQ4JTVEKQ==",highlighted:"Pooled shape: torch.Size([2, 2048])",wrap:!1}}),K=new d({props:{title:"Remove it later",local:"remove-it-later",headingTag:"h4"}}),P=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdlc2Vfdm92bmV0MTliX2R3JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW8lMjAlM0QlMjBtKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSklMEFwcmludChmJ09yaWdpbmFsJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyklMEFtLnJlc2V0X2NsYXNzaWZpZXIoMCklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidQb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;ese_vovnet19b_dw&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.reset_classifier(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Pooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),q=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBUG9vbGVkJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjAxMDI0JTVEKQ==",highlighted:`Original shape: torch.Size([2, 1000])
Pooled shape: torch.Size([2, 1024])`,wrap:!1}}),ee=new d({props:{title:"Multi-scale Feature Maps (Feature Pyramid)",local:"multi-scale-feature-maps-feature-pyramid",headingTag:"h2"}}),ae=new d({props:{title:"Create a feature map extraction model",local:"create-a-feature-map-extraction-model",headingTag:"h3"}}),ne=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXN0MjZkJyUyQyUyMGZlYXR1cmVzX29ubHklM0RUcnVlJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWZvciUyMHglMjBpbiUyMG8lM0ElMEElMjAlMjAlMjAlMjBwcmludCh4LnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnest26d&#x27;</span>, features_only=<span class="hljs-literal">True</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),ie=new y({props:{code:"dG9yY2guU2l6ZSglNUIyJTJDJTIwNjQlMkMlMjAxMTIlMkMlMjAxMTIlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjU2JTJDJTIwNTYlMkMlMjA1NiU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA1MTIlMkMlMjAyOCUyQyUyMDI4JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMjQlMkMlMjAxNCUyQyUyMDE0JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`torch.Size([2, 64, 112, 112])
torch.Size([2, 256, 56, 56])
torch.Size([2, 512, 28, 28])
torch.Size([2, 1024, 14, 14])
torch.Size([2, 2048, 7, 7])`,wrap:!1}}),re=new d({props:{title:"Query the feature information",local:"query-the-feature-information",headingTag:"h3"}}),oe=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZWduZXR5XzAzMiclMkMlMjBmZWF0dXJlc19vbmx5JTNEVHJ1ZSUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXByaW50KGYnRmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTdCbS5mZWF0dXJlX2luZm8uY2hhbm5lbHMoKSU3RCcpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWZvciUyMHglMjBpbiUyMG8lM0ElMEElMjAlMjAlMjAlMjBwcmludCh4LnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;regnety_032&#x27;</span>, features_only=<span class="hljs-literal">True</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature channels: <span class="hljs-subst">{m.feature_info.channels()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),Me=new y({props:{code:"RmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTVCMzIlMkMlMjA3MiUyQyUyMDIxNiUyQyUyMDU3NiUyQyUyMDE1MTIlNUQlMEF0b3JjaC5TaXplKCU1QjIlMkMlMjAzMiUyQyUyMDExMiUyQyUyMDExMiU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA3MiUyQyUyMDU2JTJDJTIwNTYlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjE2JTJDJTIwMjglMkMlMjAyOCU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA1NzYlMkMlMjAxNCUyQyUyMDE0JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDE1MTIlMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`Feature channels: [32, 72, 216, 576, 1512]
torch.Size([2, 32, 112, 112])
torch.Size([2, 72, 56, 56])
torch.Size([2, 216, 28, 28])
torch.Size([2, 576, 14, 14])
torch.Size([2, 1512, 7, 7])`,wrap:!1}}),he=new d({props:{title:"Select specific feature levels or limit the stride",local:"select-specific-feature-levels-or-limit-the-stride",headingTag:"h3"}}),de=new d({props:{title:"Output index selection",local:"output-index-selection",headingTag:"h4"}}),je=new d({props:{title:"Output stride (feature map dilation)",local:"output-stride-feature-map-dilation",headingTag:"h4"}}),Ue=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdlY2FyZXNuZXQxMDFkJyUyQyUyMGZlYXR1cmVzX29ubHklM0RUcnVlJTJDJTIwb3V0cHV0X3N0cmlkZSUzRDglMkMlMjBvdXRfaW5kaWNlcyUzRCgyJTJDJTIwNCklMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFwcmludChmJ0ZlYXR1cmUlMjBjaGFubmVscyUzQSUyMCU3Qm0uZmVhdHVyZV9pbmZvLmNoYW5uZWxzKCklN0QnKSUwQXByaW50KGYnRmVhdHVyZSUyMHJlZHVjdGlvbiUzQSUyMCU3Qm0uZmVhdHVyZV9pbmZvLnJlZHVjdGlvbigpJTdEJyklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDMyMCUyQyUyMDMyMCkpJTBBZm9yJTIweCUyMGluJTIwbyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHguc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, features_only=<span class="hljs-literal">True</span>, output_stride=<span class="hljs-number">8</span>, out_indices=(<span class="hljs-number">2</span>, <span class="hljs-number">4</span>), pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature channels: <span class="hljs-subst">{m.feature_info.channels()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature reduction: <span class="hljs-subst">{m.feature_info.reduction()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">320</span>, <span class="hljs-number">320</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),we=new y({props:{code:"RmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTVCNTEyJTJDJTIwMjA0OCU1RCUwQUZlYXR1cmUlMjByZWR1Y3Rpb24lM0ElMjAlNUI4JTJDJTIwOCU1RCUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDUxMiUyQyUyMDQwJTJDJTIwNDAlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjA0OCUyQyUyMDQwJTJDJTIwNDAlNUQp",highlighted:`Feature channels: [512, 2048]
Feature reduction: [8, 8]
torch.Size([2, 512, 40, 40])
torch.Size([2, 2048, 40, 40])`,wrap:!1}}),be=new d({props:{title:"Flexible intermediate feature map extraction",local:"flexible-intermediate-feature-map-extraction",headingTag:"h2"}}),Ne=new y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndml0X21lZGl1bV9wYXRjaDE2X3JlZzFfZ2FwXzI1NiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFvdXRwdXQlMkMlMjBpbnRlcm1lZGlhdGVzJTIwJTNEJTIwbW9kZWwuZm9yd2FyZF9pbnRlcm1lZGlhdGVzKHRvcmNoLnJhbmRuKDIlMkMzJTJDMjU2JTJDMjU2KSklMEFmb3IlMjBpJTJDJTIwbyUyMGluJTIwZW51bWVyYXRlKGludGVybWVkaWF0ZXMpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZidGZWF0JTIwaW5kZXglM0ElMjAlN0JpJTdEJTJDJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyk=",highlighted:`model = timm.create_model(<span class="hljs-string">&#x27;vit_medium_patch16_reg1_gap_256&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
output, intermediates = model.forward_intermediates(torch.randn(<span class="hljs-number">2</span>,<span class="hljs-number">3</span>,<span class="hljs-number">256</span>,<span class="hljs-number">256</span>))
<span class="hljs-keyword">for</span> i, o <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(intermediates):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feat index: <span class="hljs-subst">{i}</span>, shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),Be=new y({props:{code:"RmVhdCUyMGluZGV4JTNBJTIwMCUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCklMEFGZWF0JTIwaW5kZXglM0ElMjAxJTJDJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjA1MTIlMkMlMjAxNiUyQyUyMDE2JTVEKSUwQUZlYXQlMjBpbmRleCUzQSUyMDIlMkMlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDUxMiUyQyUyMDE2JTJDJTIwMTYlNUQpJTBBRmVhdCUyMGluZGV4JTNBJTIwMyUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCklMEFGZWF0JTIwaW5kZXglM0ElMjA0JTJDJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjA1MTIlMkMlMjAxNiUyQyUyMDE2JTVEKSUwQUZlYXQlMjBpbmRleCUzQSUyMDUlMkMlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDUxMiUyQyUyMDE2JTJDJTIwMTYlNUQpJTBBRmVhdCUyMGluZGV4JTNBJTIwNiUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCklMEFGZWF0JTIwaW5kZXglM0ElMjA3JTJDJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjA1MTIlMkMlMjAxNiUyQyUyMDE2JTVEKSUwQUZlYXQlMjBpbmRleCUzQSUyMDglMkMlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDUxMiUyQyUyMDE2JTJDJTIwMTYlNUQpJTBBRmVhdCUyMGluZGV4JTNBJTIwOSUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCklMEFGZWF0JTIwaW5kZXglM0ElMjAxMCUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCklMEFGZWF0JTIwaW5kZXglM0ElMjAxMSUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCk=",highlighted:`Feat index: 0, shape: torch.Size([2, 512, 16, 16])
Feat index: 1, shape: torch.Size([2, 512, 16, 16])
Feat index: 2, shape: torch.Size([2, 512, 16, 16])
Feat index: 3, shape: torch.Size([2, 512, 16, 16])
Feat index: 4, shape: torch.Size([2, 512, 16, 16])
Feat index: 5, shape: torch.Size([2, 512, 16, 16])
Feat index: 6, shape: torch.Size([2, 512, 16, 16])
Feat index: 7, shape: torch.Size([2, 512, 16, 16])
Feat index: 8, shape: torch.Size([2, 512, 16, 16])
Feat index: 9, shape: torch.Size([2, 512, 16, 16])
Feat index: 10, shape: torch.Size([2, 512, 16, 16])
Feat index: 11, shape: torch.Size([2, 512, 16, 16])`,wrap:!1}}),Ze=new y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndml0X21lZGl1bV9wYXRjaDE2X3JlZzFfZ2FwXzI1NiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFwcmludCgnT3JpZ2luYWwlMjBwYXJhbXMlM0EnJTJDJTIwc3VtKCU1QnAubnVtZWwoKSUyMGZvciUyMHAlMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSU1RCkpJTBBJTBBaW5kaWNlcyUyMCUzRCUyMG1vZGVsLnBydW5lX2ludGVybWVkaWF0ZV9sYXllcnMoaW5kaWNlcyUzRCgtMiUyQyklMkMlMjBwcnVuZV9oZWFkJTNEVHJ1ZSUyQyUyMHBydW5lX25vcm0lM0RUcnVlKSUyMCUyMCUyMyUyMHBydW5lJTIwaGVhZCUyQyUyMG5vcm0lMkMlMjBsYXN0JTIwYmxvY2slMEFwcmludCgnUHJ1bmVkJTIwcGFyYW1zJTNBJyUyQyUyMHN1bSglNUJwLm51bWVsKCklMjBmb3IlMjBwJTIwaW4lMjBtb2RlbC5wYXJhbWV0ZXJzKCklNUQpKSUwQSUwQWludGVybWVkaWF0ZXMlMjAlM0QlMjBtb2RlbC5mb3J3YXJkX2ludGVybWVkaWF0ZXModG9yY2gucmFuZG4oMiUyQzMlMkMyNTYlMkMyNTYpJTJDJTIwaW5kaWNlcyUzRGluZGljZXMlMkMlMjBpbnRlcm1lZGlhdGVzX29ubHklM0RUcnVlKSUyMCUyMCUyMyUyMHJldHVybiUyMHBlbnVsdGltYXRlJTIwaW50ZXJtZWRpYXRlJTBBZm9yJTIwbyUyMGluJTIwaW50ZXJtZWRpYXRlcyUzQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHByaW50KGYnRmVhdCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcp",highlighted:`model = timm.create_model(<span class="hljs-string">&#x27;vit_medium_patch16_reg1_gap_256&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Original params:&#x27;</span>, <span class="hljs-built_in">sum</span>([p.numel() <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> model.parameters()]))

indices = model.prune_intermediate_layers(indices=(-<span class="hljs-number">2</span>,), prune_head=<span class="hljs-literal">True</span>, prune_norm=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># prune head, norm, last block</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Pruned params:&#x27;</span>, <span class="hljs-built_in">sum</span>([p.numel() <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> model.parameters()]))

intermediates = model.forward_intermediates(torch.randn(<span class="hljs-number">2</span>,<span class="hljs-number">3</span>,<span class="hljs-number">256</span>,<span class="hljs-number">256</span>), indices=indices, intermediates_only=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># return penultimate intermediate</span>
<span class="hljs-keyword">for</span> o <span class="hljs-keyword">in</span> intermediates:    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feat shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),ve=new y({props:{code:"T3JpZ2luYWwlMjBwYXJhbXMlM0ElMjAzODg4MDIzMiUwQVBydW5lZCUyMHBhcmFtcyUzQSUyMDM1MjEyODAwJTBBRmVhdCUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCk=",highlighted:`Original params: 38880232
Pruned params: 35212800
Feat shape: torch.Size([2, 512, 16, 16])`,wrap:!1}}),Ie=new Ds({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/feature_extraction.mdx"}}),{c(){f=M("meta"),_e=a(),Ve=M("p"),Xe=a(),p(J.$$.fragment),Ge=a(),p(j.$$.fragment),We=a(),g=M("p"),g.innerHTML=as,Re=a(),p(U.$$.fragment),ze=a(),T=M("p"),T.textContent=ns,Fe=a(),p(w.$$.fragment),De=a(),b=M("p"),b.innerHTML=ps,Ee=a(),$=M("p"),$.innerHTML=is,Ye=a(),C=M("p"),C.textContent=rs,He=a(),p(k.$$.fragment),Ae=a(),p(x.$$.fragment),Le=a(),Q=M("p"),Q.textContent=ms,Ke=a(),p(N.$$.fragment),Pe=a(),p(B.$$.fragment),Oe=a(),p(Z.$$.fragment),qe=a(),v=M("p"),v.textContent=os,et=a(),p(I.$$.fragment),tt=a(),p(V.$$.fragment),st=a(),p(S.$$.fragment),lt=a(),_=M("p"),_.textContent=cs,at=a(),p(X.$$.fragment),nt=a(),p(G.$$.fragment),pt=a(),W=M("p"),W.innerHTML=Ms,it=a(),p(R.$$.fragment),rt=a(),z=M("p"),z.textContent=hs,mt=a(),p(F.$$.fragment),ot=a(),p(D.$$.fragment),ct=a(),E=M("p"),E.innerHTML=us,Mt=a(),p(Y.$$.fragment),ht=a(),p(H.$$.fragment),ut=a(),A=M("p"),A.textContent=ys,yt=a(),p(L.$$.fragment),dt=a(),p(K.$$.fragment),ft=a(),p(P.$$.fragment),Jt=a(),O=M("p"),O.textContent=ds,jt=a(),p(q.$$.fragment),gt=a(),p(ee.$$.fragment),Ut=a(),te=M("p"),te.textContent=fs,Tt=a(),se=M("p"),se.innerHTML=Js,wt=a(),le=M("p"),le.innerHTML=js,bt=a(),p(ae.$$.fragment),$t=a(),p(ne.$$.fragment),Ct=a(),pe=M("p"),pe.textContent=gs,kt=a(),p(ie.$$.fragment),xt=a(),p(re.$$.fragment),Qt=a(),me=M("p"),me.innerHTML=Us,Nt=a(),p(oe.$$.fragment),Bt=a(),ce=M("p"),ce.textContent=Ts,Zt=a(),p(Me.$$.fragment),vt=a(),p(he.$$.fragment),It=a(),ue=M("p"),ue.textContent=ws,Vt=a(),ye=M("ul"),ye.innerHTML=bs,St=a(),p(de.$$.fragment),_t=a(),fe=M("p"),fe.innerHTML=$s,Xt=a(),Je=M("p"),Je.innerHTML=Cs,Gt=a(),p(je.$$.fragment),Wt=a(),ge=M("p"),ge.innerHTML=ks,Rt=a(),p(Ue.$$.fragment),zt=a(),Te=M("p"),Te.textContent=xs,Ft=a(),p(we.$$.fragment),Dt=a(),p(be.$$.fragment),Et=a(),$e=M("p"),$e.innerHTML=Qs,Yt=a(),Ce=M("p"),Ce.innerHTML=Ns,Ht=a(),ke=M("p"),ke.innerHTML=Bs,At=a(),xe=M("p"),xe.innerHTML=Zs,Lt=a(),Qe=M("p"),Qe.innerHTML=vs,Kt=a(),p(Ne.$$.fragment),Pt=a(),p(Be.$$.fragment),Ot=a(),p(Ze.$$.fragment),qt=a(),p(ve.$$.fragment),es=a(),p(Ie.$$.fragment),ts=a(),Se=M("p"),this.h()},l(e){const t=Rs("svelte-u9bgzb",document.head);f=h(t,"META",{name:!0,content:!0}),t.forEach(s),_e=n(e),Ve=h(e,"P",{}),Is(Ve).forEach(s),Xe=n(e),i(J.$$.fragment,e),Ge=n(e),i(j.$$.fragment,e),We=n(e),g=h(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1w5xc9e"&&(g.innerHTML=as),Re=n(e),i(U.$$.fragment,e),ze=n(e),T=h(e,"P",{"data-svelte-h":!0}),u(T)!=="svelte-1i0y2af"&&(T.textContent=ns),Fe=n(e),i(w.$$.fragment,e),De=n(e),b=h(e,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1ypgfg0"&&(b.innerHTML=ps),Ee=n(e),$=h(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1c1de84"&&($.innerHTML=is),Ye=n(e),C=h(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1c79pr0"&&(C.textContent=rs),He=n(e),i(k.$$.fragment,e),Ae=n(e),i(x.$$.fragment,e),Le=n(e),Q=h(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1wuxk0l"&&(Q.textContent=ms),Ke=n(e),i(N.$$.fragment,e),Pe=n(e),i(B.$$.fragment,e),Oe=n(e),i(Z.$$.fragment,e),qe=n(e),v=h(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1wuxk0l"&&(v.textContent=os),et=n(e),i(I.$$.fragment,e),tt=n(e),i(V.$$.fragment,e),st=n(e),i(S.$$.fragment,e),lt=n(e),_=h(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-1wuxk0l"&&(_.textContent=cs),at=n(e),i(X.$$.fragment,e),nt=n(e),i(G.$$.fragment,e),pt=n(e),W=h(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-tjoshe"&&(W.innerHTML=Ms),it=n(e),i(R.$$.fragment,e),rt=n(e),z=h(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-1wuxk0l"&&(z.textContent=hs),mt=n(e),i(F.$$.fragment,e),ot=n(e),i(D.$$.fragment,e),ct=n(e),E=h(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-jci7dg"&&(E.innerHTML=us),Mt=n(e),i(Y.$$.fragment,e),ht=n(e),i(H.$$.fragment,e),ut=n(e),A=h(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1wuxk0l"&&(A.textContent=ys),yt=n(e),i(L.$$.fragment,e),dt=n(e),i(K.$$.fragment,e),ft=n(e),i(P.$$.fragment,e),Jt=n(e),O=h(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1wuxk0l"&&(O.textContent=ds),jt=n(e),i(q.$$.fragment,e),gt=n(e),i(ee.$$.fragment,e),Ut=n(e),te=h(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-56ounp"&&(te.textContent=fs),Tt=n(e),se=h(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-1j7o0l4"&&(se.innerHTML=Js),wt=n(e),le=h(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-pd3pcg"&&(le.innerHTML=js),bt=n(e),i(ae.$$.fragment,e),$t=n(e),i(ne.$$.fragment,e),Ct=n(e),pe=h(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-1wuxk0l"&&(pe.textContent=gs),kt=n(e),i(ie.$$.fragment,e),xt=n(e),i(re.$$.fragment,e),Qt=n(e),me=h(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-2ryznm"&&(me.innerHTML=Us),Nt=n(e),i(oe.$$.fragment,e),Bt=n(e),ce=h(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-1wuxk0l"&&(ce.textContent=Ts),Zt=n(e),i(Me.$$.fragment,e),vt=n(e),i(he.$$.fragment,e),It=n(e),ue=h(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-18fc4zz"&&(ue.textContent=ws),Vt=n(e),ye=h(e,"UL",{"data-svelte-h":!0}),u(ye)!=="svelte-1c2ig9e"&&(ye.innerHTML=bs),St=n(e),i(de.$$.fragment,e),_t=n(e),fe=h(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-1fuvwot"&&(fe.innerHTML=$s),Xt=n(e),Je=h(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-1s9m3po"&&(Je.innerHTML=Cs),Gt=n(e),i(je.$$.fragment,e),Wt=n(e),ge=h(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-nvrnid"&&(ge.innerHTML=ks),Rt=n(e),i(Ue.$$.fragment,e),zt=n(e),Te=h(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1wuxk0l"&&(Te.textContent=xs),Ft=n(e),i(we.$$.fragment,e),Dt=n(e),i(be.$$.fragment,e),Et=n(e),$e=h(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-11565gi"&&($e.innerHTML=Qs),Yt=n(e),Ce=h(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-8sy4p"&&(Ce.innerHTML=Ns),Ht=n(e),ke=h(e,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-1852v8c"&&(ke.innerHTML=Bs),At=n(e),xe=h(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-f9i0wk"&&(xe.innerHTML=Zs),Lt=n(e),Qe=h(e,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-1wflp2q"&&(Qe.innerHTML=vs),Kt=n(e),i(Ne.$$.fragment,e),Pt=n(e),i(Be.$$.fragment,e),Ot=n(e),i(Ze.$$.fragment,e),qt=n(e),i(ve.$$.fragment,e),es=n(e),i(Ie.$$.fragment,e),ts=n(e),Se=h(e,"P",{}),Is(Se).forEach(s),this.h()},h(){Vs(f,"name","hf:doc:metadata"),Vs(f,"content",Ys)},m(e,t){zs(document.head,f),l(e,_e,t),l(e,Ve,t),l(e,Xe,t),r(J,e,t),l(e,Ge,t),r(j,e,t),l(e,We,t),l(e,g,t),l(e,Re,t),r(U,e,t),l(e,ze,t),l(e,T,t),l(e,Fe,t),r(w,e,t),l(e,De,t),l(e,b,t),l(e,Ee,t),l(e,$,t),l(e,Ye,t),l(e,C,t),l(e,He,t),r(k,e,t),l(e,Ae,t),r(x,e,t),l(e,Le,t),l(e,Q,t),l(e,Ke,t),r(N,e,t),l(e,Pe,t),r(B,e,t),l(e,Oe,t),r(Z,e,t),l(e,qe,t),l(e,v,t),l(e,et,t),r(I,e,t),l(e,tt,t),r(V,e,t),l(e,st,t),r(S,e,t),l(e,lt,t),l(e,_,t),l(e,at,t),r(X,e,t),l(e,nt,t),r(G,e,t),l(e,pt,t),l(e,W,t),l(e,it,t),r(R,e,t),l(e,rt,t),l(e,z,t),l(e,mt,t),r(F,e,t),l(e,ot,t),r(D,e,t),l(e,ct,t),l(e,E,t),l(e,Mt,t),r(Y,e,t),l(e,ht,t),r(H,e,t),l(e,ut,t),l(e,A,t),l(e,yt,t),r(L,e,t),l(e,dt,t),r(K,e,t),l(e,ft,t),r(P,e,t),l(e,Jt,t),l(e,O,t),l(e,jt,t),r(q,e,t),l(e,gt,t),r(ee,e,t),l(e,Ut,t),l(e,te,t),l(e,Tt,t),l(e,se,t),l(e,wt,t),l(e,le,t),l(e,bt,t),r(ae,e,t),l(e,$t,t),r(ne,e,t),l(e,Ct,t),l(e,pe,t),l(e,kt,t),r(ie,e,t),l(e,xt,t),r(re,e,t),l(e,Qt,t),l(e,me,t),l(e,Nt,t),r(oe,e,t),l(e,Bt,t),l(e,ce,t),l(e,Zt,t),r(Me,e,t),l(e,vt,t),r(he,e,t),l(e,It,t),l(e,ue,t),l(e,Vt,t),l(e,ye,t),l(e,St,t),r(de,e,t),l(e,_t,t),l(e,fe,t),l(e,Xt,t),l(e,Je,t),l(e,Gt,t),r(je,e,t),l(e,Wt,t),l(e,ge,t),l(e,Rt,t),r(Ue,e,t),l(e,zt,t),l(e,Te,t),l(e,Ft,t),r(we,e,t),l(e,Dt,t),r(be,e,t),l(e,Et,t),l(e,$e,t),l(e,Yt,t),l(e,Ce,t),l(e,Ht,t),l(e,ke,t),l(e,At,t),l(e,xe,t),l(e,Lt,t),l(e,Qe,t),l(e,Kt,t),r(Ne,e,t),l(e,Pt,t),r(Be,e,t),l(e,Ot,t),r(Ze,e,t),l(e,qt,t),r(ve,e,t),l(e,es,t),r(Ie,e,t),l(e,ts,t),l(e,Se,t),ss=!0},p:_s,i(e){ss||(m(J.$$.fragment,e),m(j.$$.fragment,e),m(U.$$.fragment,e),m(w.$$.fragment,e),m(k.$$.fragment,e),m(x.$$.fragment,e),m(N.$$.fragment,e),m(B.$$.fragment,e),m(Z.$$.fragment,e),m(I.$$.fragment,e),m(V.$$.fragment,e),m(S.$$.fragment,e),m(X.$$.fragment,e),m(G.$$.fragment,e),m(R.$$.fragment,e),m(F.$$.fragment,e),m(D.$$.fragment,e),m(Y.$$.fragment,e),m(H.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(P.$$.fragment,e),m(q.$$.fragment,e),m(ee.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(Me.$$.fragment,e),m(he.$$.fragment,e),m(de.$$.fragment,e),m(je.$$.fragment,e),m(Ue.$$.fragment,e),m(we.$$.fragment,e),m(be.$$.fragment,e),m(Ne.$$.fragment,e),m(Be.$$.fragment,e),m(Ze.$$.fragment,e),m(ve.$$.fragment,e),m(Ie.$$.fragment,e),ss=!0)},o(e){o(J.$$.fragment,e),o(j.$$.fragment,e),o(U.$$.fragment,e),o(w.$$.fragment,e),o(k.$$.fragment,e),o(x.$$.fragment,e),o(N.$$.fragment,e),o(B.$$.fragment,e),o(Z.$$.fragment,e),o(I.$$.fragment,e),o(V.$$.fragment,e),o(S.$$.fragment,e),o(X.$$.fragment,e),o(G.$$.fragment,e),o(R.$$.fragment,e),o(F.$$.fragment,e),o(D.$$.fragment,e),o(Y.$$.fragment,e),o(H.$$.fragment,e),o(L.$$.fragment,e),o(K.$$.fragment,e),o(P.$$.fragment,e),o(q.$$.fragment,e),o(ee.$$.fragment,e),o(ae.$$.fragment,e),o(ne.$$.fragment,e),o(ie.$$.fragment,e),o(re.$$.fragment,e),o(oe.$$.fragment,e),o(Me.$$.fragment,e),o(he.$$.fragment,e),o(de.$$.fragment,e),o(je.$$.fragment,e),o(Ue.$$.fragment,e),o(we.$$.fragment,e),o(be.$$.fragment,e),o(Ne.$$.fragment,e),o(Be.$$.fragment,e),o(Ze.$$.fragment,e),o(ve.$$.fragment,e),o(Ie.$$.fragment,e),ss=!1},d(e){e&&(s(_e),s(Ve),s(Xe),s(Ge),s(We),s(g),s(Re),s(ze),s(T),s(Fe),s(De),s(b),s(Ee),s($),s(Ye),s(C),s(He),s(Ae),s(Le),s(Q),s(Ke),s(Pe),s(Oe),s(qe),s(v),s(et),s(tt),s(st),s(lt),s(_),s(at),s(nt),s(pt),s(W),s(it),s(rt),s(z),s(mt),s(ot),s(ct),s(E),s(Mt),s(ht),s(ut),s(A),s(yt),s(dt),s(ft),s(Jt),s(O),s(jt),s(gt),s(Ut),s(te),s(Tt),s(se),s(wt),s(le),s(bt),s($t),s(Ct),s(pe),s(kt),s(xt),s(Qt),s(me),s(Nt),s(Bt),s(ce),s(Zt),s(vt),s(It),s(ue),s(Vt),s(ye),s(St),s(_t),s(fe),s(Xt),s(Je),s(Gt),s(Wt),s(ge),s(Rt),s(zt),s(Te),s(Ft),s(Dt),s(Et),s($e),s(Yt),s(Ce),s(Ht),s(ke),s(At),s(xe),s(Lt),s(Qe),s(Kt),s(Pt),s(Ot),s(qt),s(es),s(ts),s(Se)),s(f),c(J,e),c(j,e),c(U,e),c(w,e),c(k,e),c(x,e),c(N,e),c(B,e),c(Z,e),c(I,e),c(V,e),c(S,e),c(X,e),c(G,e),c(R,e),c(F,e),c(D,e),c(Y,e),c(H,e),c(L,e),c(K,e),c(P,e),c(q,e),c(ee,e),c(ae,e),c(ne,e),c(ie,e),c(re,e),c(oe,e),c(Me,e),c(he,e),c(de,e),c(je,e),c(Ue,e),c(we,e),c(be,e),c(Ne,e),c(Be,e),c(Ze,e),c(ve,e),c(Ie,e)}}}const Ys='{"title":"Feature Extraction","local":"feature-extraction","sections":[{"title":"Penultimate Layer Features (Pre-Classifier Features)","local":"penultimate-layer-features-pre-classifier-features","sections":[{"title":"Unpooled","local":"unpooled","sections":[{"title":"forward_features()","local":"forwardfeatures","sections":[],"depth":4},{"title":"Create with no classifier and pooling","local":"create-with-no-classifier-and-pooling","sections":[],"depth":4},{"title":"Remove it later","local":"remove-it-later","sections":[],"depth":4},{"title":"Chaining unpooled output to classifier","local":"chaining-unpooled-output-to-classifier","sections":[],"depth":4}],"depth":3},{"title":"Pooled","local":"pooled","sections":[{"title":"Create with no classifier","local":"create-with-no-classifier","sections":[],"depth":4},{"title":"Remove it later","local":"remove-it-later","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Multi-scale Feature Maps (Feature Pyramid)","local":"multi-scale-feature-maps-feature-pyramid","sections":[{"title":"Create a feature map extraction model","local":"create-a-feature-map-extraction-model","sections":[],"depth":3},{"title":"Query the feature information","local":"query-the-feature-information","sections":[],"depth":3},{"title":"Select specific feature levels or limit the stride","local":"select-specific-feature-levels-or-limit-the-stride","sections":[{"title":"Output index selection","local":"output-index-selection","sections":[],"depth":4},{"title":"Output stride (feature map dilation)","local":"output-stride-feature-map-dilation","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Flexible intermediate feature map extraction","local":"flexible-intermediate-feature-map-extraction","sections":[],"depth":2}],"depth":1}';function Hs(ls){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Os extends Gs{constructor(f){super(),Ws(this,f,Hs,Es,Ss,{})}}export{Os as component};
