import{s as Zs,n as ks,o as xs}from"../chunks/scheduler.0b596ca5.js";import{S as Gs,i as Ns,e as p,s as a,c as i,h as Bs,a as m,d as l,b as n,f as Is,g as o,j as y,k as $s,l as Ws,m as e,n as M,t as r,o as c,p as h}from"../chunks/index.d9d53bd3.js";import{C as vs,H as X,E as Es}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as V}from"../chunks/CodeBlock.9f18e41e.js";function As(Js){let J,S,Y,z,j,_,g,H,w,js='<strong>Inception v3</strong> is a convolutional neural network architecture from the Inception family that makes several improvements including using <a href="https://paperswithcode.com/method/label-smoothing" rel="nofollow">Label Smoothing</a>, Factorized 7 x 7 convolutions, and the use of an <a href="https://paperswithcode.com/method/auxiliary-classifier" rel="nofollow">auxiliary classifier</a> to propagate label information lower down the network (along with the use of batch normalization for layers in the sidehead). The key building block is an <a href="https://paperswithcode.com/method/inception-v3-module" rel="nofollow">Inception Module</a>.',F,T,L,d,gs="To load a pretrained model:",D,u,q,U,ws="To load and preprocess the image:",P,b,K,f,Ts="To get the model predictions:",O,C,ss,I,ds="To get the top-5 predictions class names:",ts,$,ls,Z,us="Replace the model name with the variant you want to use, e.g. <code>inception_v3</code>. You can find the IDs in the model summaries at the top of this page.",es,k,Us='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,x,ns,G,bs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,N,is,B,fs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ms,W,os,v,Cs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',Ms,E,rs,A,cs,Q,hs,R,ys;return j=new vs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new X({props:{title:"Inception v3",local:"inception-v3",headingTag:"h1"}}),T=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2luY2VwdGlvbl92MyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),x=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaW5jZXB0aW9uX3YzJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),W=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),A=new V({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZTemVnZWR5VklTVzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFZpbmNlbnQlMjBWYW5ob3Vja2UlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZXJnZXklMjBJb2ZmZSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEpvbmF0aG9uJTIwU2hsZW5zJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWmJpZ25pZXclMjBXb2puYSU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCUmV0aGlua2luZyUyMHRoZSUyMEluY2VwdGlvbiUyMEFyY2hpdGVjdHVyZSUyMGZvciUyMENvbXB1dGVyJTIwVmlzaW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxNTEyLjAwNTY3JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTUlN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTUxMi4wMDU2NyU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE1MTIuMDA1NjclN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAxMyUyMEF1ZyUyMDIwMTglMjAxNiUzQTQ5JTNBMDclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRlN6ZWdlZHlWSVNXMTUuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15,
  author    = {Christian Szegedy and
               Vincent Vanhoucke and
               Sergey Ioffe and
               Jonathon Shlens and
               Zbigniew Wojna},
  title     = {Rethinking the Inception Architecture <span class="hljs-keyword">for</span> Computer Vision},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.00567</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.00567</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.00567</span>},
  timestamp = {Mon, <span class="hljs-number">13</span> Aug <span class="hljs-number">2018</span> <span class="hljs-number">16</span>:<span class="hljs-number">49</span>:<span class="hljs-number">07</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),Q=new Es({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/inception-v3.mdx"}}),{c(){J=p("meta"),S=a(),Y=p("p"),z=a(),i(j.$$.fragment),_=a(),i(g.$$.fragment),H=a(),w=p("p"),w.innerHTML=js,F=a(),i(T.$$.fragment),L=a(),d=p("p"),d.textContent=gs,D=a(),i(u.$$.fragment),q=a(),U=p("p"),U.textContent=ws,P=a(),i(b.$$.fragment),K=a(),f=p("p"),f.textContent=Ts,O=a(),i(C.$$.fragment),ss=a(),I=p("p"),I.textContent=ds,ts=a(),i($.$$.fragment),ls=a(),Z=p("p"),Z.innerHTML=us,es=a(),k=p("p"),k.innerHTML=Us,as=a(),i(x.$$.fragment),ns=a(),G=p("p"),G.textContent=bs,ps=a(),i(N.$$.fragment),is=a(),B=p("p"),B.innerHTML=fs,ms=a(),i(W.$$.fragment),os=a(),v=p("p"),v.innerHTML=Cs,Ms=a(),i(E.$$.fragment),rs=a(),i(A.$$.fragment),cs=a(),i(Q.$$.fragment),hs=a(),R=p("p"),this.h()},l(s){const t=Bs("svelte-u9bgzb",document.head);J=m(t,"META",{name:!0,content:!0}),t.forEach(l),S=n(s),Y=m(s,"P",{}),Is(Y).forEach(l),z=n(s),o(j.$$.fragment,s),_=n(s),o(g.$$.fragment,s),H=n(s),w=m(s,"P",{"data-svelte-h":!0}),y(w)!=="svelte-1oyeygh"&&(w.innerHTML=js),F=n(s),o(T.$$.fragment,s),L=n(s),d=m(s,"P",{"data-svelte-h":!0}),y(d)!=="svelte-18ywhxh"&&(d.textContent=gs),D=n(s),o(u.$$.fragment,s),q=n(s),U=m(s,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1c2ipa8"&&(U.textContent=ws),P=n(s),o(b.$$.fragment,s),K=n(s),f=m(s,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1n9qsq1"&&(f.textContent=Ts),O=n(s),o(C.$$.fragment,s),ss=n(s),I=m(s,"P",{"data-svelte-h":!0}),y(I)!=="svelte-19cnvx1"&&(I.textContent=ds),ts=n(s),o($.$$.fragment,s),ls=n(s),Z=m(s,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-fzq2q9"&&(Z.innerHTML=us),es=n(s),k=m(s,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1wmi3ea"&&(k.innerHTML=Us),as=n(s),o(x.$$.fragment,s),ns=n(s),G=m(s,"P",{"data-svelte-h":!0}),y(G)!=="svelte-9sr7nh"&&(G.textContent=bs),ps=n(s),o(N.$$.fragment,s),is=n(s),B=m(s,"P",{"data-svelte-h":!0}),y(B)!=="svelte-1kguc51"&&(B.innerHTML=fs),ms=n(s),o(W.$$.fragment,s),os=n(s),v=m(s,"P",{"data-svelte-h":!0}),y(v)!=="svelte-xtxxu6"&&(v.innerHTML=Cs),Ms=n(s),o(E.$$.fragment,s),rs=n(s),o(A.$$.fragment,s),cs=n(s),o(Q.$$.fragment,s),hs=n(s),R=m(s,"P",{}),Is(R).forEach(l),this.h()},h(){$s(J,"name","hf:doc:metadata"),$s(J,"content",Qs)},m(s,t){Ws(document.head,J),e(s,S,t),e(s,Y,t),e(s,z,t),M(j,s,t),e(s,_,t),M(g,s,t),e(s,H,t),e(s,w,t),e(s,F,t),M(T,s,t),e(s,L,t),e(s,d,t),e(s,D,t),M(u,s,t),e(s,q,t),e(s,U,t),e(s,P,t),M(b,s,t),e(s,K,t),e(s,f,t),e(s,O,t),M(C,s,t),e(s,ss,t),e(s,I,t),e(s,ts,t),M($,s,t),e(s,ls,t),e(s,Z,t),e(s,es,t),e(s,k,t),e(s,as,t),M(x,s,t),e(s,ns,t),e(s,G,t),e(s,ps,t),M(N,s,t),e(s,is,t),e(s,B,t),e(s,ms,t),M(W,s,t),e(s,os,t),e(s,v,t),e(s,Ms,t),M(E,s,t),e(s,rs,t),M(A,s,t),e(s,cs,t),M(Q,s,t),e(s,hs,t),e(s,R,t),ys=!0},p:ks,i(s){ys||(r(j.$$.fragment,s),r(g.$$.fragment,s),r(T.$$.fragment,s),r(u.$$.fragment,s),r(b.$$.fragment,s),r(C.$$.fragment,s),r($.$$.fragment,s),r(x.$$.fragment,s),r(N.$$.fragment,s),r(W.$$.fragment,s),r(E.$$.fragment,s),r(A.$$.fragment,s),r(Q.$$.fragment,s),ys=!0)},o(s){c(j.$$.fragment,s),c(g.$$.fragment,s),c(T.$$.fragment,s),c(u.$$.fragment,s),c(b.$$.fragment,s),c(C.$$.fragment,s),c($.$$.fragment,s),c(x.$$.fragment,s),c(N.$$.fragment,s),c(W.$$.fragment,s),c(E.$$.fragment,s),c(A.$$.fragment,s),c(Q.$$.fragment,s),ys=!1},d(s){s&&(l(S),l(Y),l(z),l(_),l(H),l(w),l(F),l(L),l(d),l(D),l(q),l(U),l(P),l(K),l(f),l(O),l(ss),l(I),l(ts),l(ls),l(Z),l(es),l(k),l(as),l(ns),l(G),l(ps),l(is),l(B),l(ms),l(os),l(v),l(Ms),l(rs),l(cs),l(hs),l(R)),l(J),h(j,s),h(g,s),h(T,s),h(u,s),h(b,s),h(C,s),h($,s),h(x,s),h(N,s),h(W,s),h(E,s),h(A,s),h(Q,s)}}}const Qs='{"title":"Inception v3","local":"inception-v3","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Vs(Js){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends Gs{constructor(J){super(),Ns(this,J,Vs,As,Zs,{})}}export{zs as component};
