import{s as Zt,n as vt,o as xt}from"../chunks/scheduler.0b596ca5.js";import{S as Wt,i as kt,e as p,s as l,c as i,h as Bt,a as m,d as e,b as n,f as It,g as o,j as g,k as Ct,l as Gt,m as a,n as c,t as r,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Nt,H as R,E as Qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as X}from"../chunks/CodeBlock.9f18e41e.js";function Et(yt){let y,S,_,z,d,H,J,F,u,dt='<strong>Inception-v4</strong> is a convolutional neural network architecture that builds on previous iterations of the Inception family by simplifying the architecture and using more inception modules than <a href="https://paperswithcode.com/method/inception-v3" rel="nofollow">Inception-v3</a>.',A,j,L,w,Jt="To load a pretrained model:",D,f,q,T,ut="To load and preprocess the image:",P,b,K,U,jt="To get the model predictions:",O,$,tt,I,wt="To get the top-5 predictions class names:",st,C,et,Z,ft="Replace the model name with the variant you want to use, e.g. <code>inception_v4</code>. You can find the IDs in the model summaries at the top of this page.",at,v,Tt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,x,nt,W,bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,k,it,B,Ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,G,ot,N,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ct,Q,rt,E,ht,V,Mt,Y,gt;return d=new Nt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new R({props:{title:"Inception v4",local:"inception-v4",headingTag:"h1"}}),j=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2luY2VwdGlvbl92NCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v4&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),x=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaW5jZXB0aW9uX3Y0JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v4&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new X({props:{code:"JTQwbWlzYyU3QnN6ZWdlZHkyMDE2aW5jZXB0aW9udjQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkluY2VwdGlvbi12NCUyQyUyMEluY2VwdGlvbi1SZXNOZXQlMjBhbmQlMjB0aGUlMjBJbXBhY3QlMjBvZiUyMFJlc2lkdWFsJTIwQ29ubmVjdGlvbnMlMjBvbiUyMExlYXJuaW5nJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUyMFNlcmdleSUyMElvZmZlJTIwYW5kJTIwVmluY2VudCUyMFZhbmhvdWNrZSUyMGFuZCUyMEFsZXglMjBBbGVtaSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTYwMi4wNzI2MSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{szegedy2016inceptionv4,
      title={Inception-v4, Inception-ResNet and the Impact of Residual Connections on Learning}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Christian Szegedy and Sergey Ioffe and Vincent Vanhoucke and Alex Alemi}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2016}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1602.07261}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),V=new Qt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/inception-v4.mdx"}}),{c(){y=p("meta"),S=l(),_=p("p"),z=l(),i(d.$$.fragment),H=l(),i(J.$$.fragment),F=l(),u=p("p"),u.innerHTML=dt,A=l(),i(j.$$.fragment),L=l(),w=p("p"),w.textContent=Jt,D=l(),i(f.$$.fragment),q=l(),T=p("p"),T.textContent=ut,P=l(),i(b.$$.fragment),K=l(),U=p("p"),U.textContent=jt,O=l(),i($.$$.fragment),tt=l(),I=p("p"),I.textContent=wt,st=l(),i(C.$$.fragment),et=l(),Z=p("p"),Z.innerHTML=ft,at=l(),v=p("p"),v.innerHTML=Tt,lt=l(),i(x.$$.fragment),nt=l(),W=p("p"),W.textContent=bt,pt=l(),i(k.$$.fragment),it=l(),B=p("p"),B.innerHTML=Ut,mt=l(),i(G.$$.fragment),ot=l(),N=p("p"),N.innerHTML=$t,ct=l(),i(Q.$$.fragment),rt=l(),i(E.$$.fragment),ht=l(),i(V.$$.fragment),Mt=l(),Y=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);y=m(s,"META",{name:!0,content:!0}),s.forEach(e),S=n(t),_=m(t,"P",{}),It(_).forEach(e),z=n(t),o(d.$$.fragment,t),H=n(t),o(J.$$.fragment,t),F=n(t),u=m(t,"P",{"data-svelte-h":!0}),g(u)!=="svelte-884pc9"&&(u.innerHTML=dt),A=n(t),o(j.$$.fragment,t),L=n(t),w=m(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-18ywhxh"&&(w.textContent=Jt),D=n(t),o(f.$$.fragment,t),q=n(t),T=m(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=ut),P=n(t),o(b.$$.fragment,t),K=n(t),U=m(t,"P",{"data-svelte-h":!0}),g(U)!=="svelte-1n9qsq1"&&(U.textContent=jt),O=n(t),o($.$$.fragment,t),tt=n(t),I=m(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=wt),st=n(t),o(C.$$.fragment,t),et=n(t),Z=m(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-r4n0mi"&&(Z.innerHTML=ft),at=n(t),v=m(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-1wmi3ea"&&(v.innerHTML=Tt),lt=n(t),o(x.$$.fragment,t),nt=n(t),W=m(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-9sr7nh"&&(W.textContent=bt),pt=n(t),o(k.$$.fragment,t),it=n(t),B=m(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1kguc51"&&(B.innerHTML=Ut),mt=n(t),o(G.$$.fragment,t),ot=n(t),N=m(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-xtxxu6"&&(N.innerHTML=$t),ct=n(t),o(Q.$$.fragment,t),rt=n(t),o(E.$$.fragment,t),ht=n(t),o(V.$$.fragment,t),Mt=n(t),Y=m(t,"P",{}),It(Y).forEach(e),this.h()},h(){Ct(y,"name","hf:doc:metadata"),Ct(y,"content",Vt)},m(t,s){Gt(document.head,y),a(t,S,s),a(t,_,s),a(t,z,s),c(d,t,s),a(t,H,s),c(J,t,s),a(t,F,s),a(t,u,s),a(t,A,s),c(j,t,s),a(t,L,s),a(t,w,s),a(t,D,s),c(f,t,s),a(t,q,s),a(t,T,s),a(t,P,s),c(b,t,s),a(t,K,s),a(t,U,s),a(t,O,s),c($,t,s),a(t,tt,s),a(t,I,s),a(t,st,s),c(C,t,s),a(t,et,s),a(t,Z,s),a(t,at,s),a(t,v,s),a(t,lt,s),c(x,t,s),a(t,nt,s),a(t,W,s),a(t,pt,s),c(k,t,s),a(t,it,s),a(t,B,s),a(t,mt,s),c(G,t,s),a(t,ot,s),a(t,N,s),a(t,ct,s),c(Q,t,s),a(t,rt,s),c(E,t,s),a(t,ht,s),c(V,t,s),a(t,Mt,s),a(t,Y,s),gt=!0},p:vt,i(t){gt||(r(d.$$.fragment,t),r(J.$$.fragment,t),r(j.$$.fragment,t),r(f.$$.fragment,t),r(b.$$.fragment,t),r($.$$.fragment,t),r(C.$$.fragment,t),r(x.$$.fragment,t),r(k.$$.fragment,t),r(G.$$.fragment,t),r(Q.$$.fragment,t),r(E.$$.fragment,t),r(V.$$.fragment,t),gt=!0)},o(t){h(d.$$.fragment,t),h(J.$$.fragment,t),h(j.$$.fragment,t),h(f.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(C.$$.fragment,t),h(x.$$.fragment,t),h(k.$$.fragment,t),h(G.$$.fragment,t),h(Q.$$.fragment,t),h(E.$$.fragment,t),h(V.$$.fragment,t),gt=!1},d(t){t&&(e(S),e(_),e(z),e(H),e(F),e(u),e(A),e(L),e(w),e(D),e(q),e(T),e(P),e(K),e(U),e(O),e(tt),e(I),e(st),e(et),e(Z),e(at),e(v),e(lt),e(nt),e(W),e(pt),e(it),e(B),e(mt),e(ot),e(N),e(ct),e(rt),e(ht),e(Mt),e(Y)),e(y),M(d,t),M(J,t),M(j,t),M(f,t),M(b,t),M($,t),M(C,t),M(x,t),M(k,t),M(G,t),M(Q,t),M(E,t),M(V,t)}}}const Vt='{"title":"Inception v4","local":"inception-v4","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xt(yt){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Wt{constructor(y){super(),kt(this,y,Xt,Et,Zt,{})}}export{zt as component};
