import{s as kt,n as Wt,o as Zt}from"../chunks/scheduler.0b596ca5.js";import{S as xt,i as Nt,e as p,s as a,c as m,h as Gt,a as i,d as e,b as n,f as Ct,g as o,j as y,k as It,l as Bt,m as l,n as r,t as c,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Et,H as S,E as Qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as X}from"../chunks/CodeBlock.9f18e41e.js";function Vt(gt){let g,z,_,Y,d,F,w,H,J,dt='<strong>SE ResNet</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',A,j,L,u,wt="To load a pretrained model:",q,f,D,T,Jt="To load and preprocess the image:",P,b,K,U,jt="To get the model predictions:",O,$,tt,C,ut="To get the top-5 predictions class names:",st,I,et,k,ft="Replace the model name with the variant you want to use, e.g. <code>legacy_seresnet101</code>. You can find the IDs in the model summaries at the top of this page.",lt,W,Tt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,Z,nt,x,bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,N,mt,G,Ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,B,ot,E,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,Q,ct,V,ht,R,Mt,v,yt;return d=new Et({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new S({props:{title:"(Legacy) SE-ResNet",local:"legacy-se-resnet",headingTag:"h1"}}),j=new S({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2xlZ2FjeV9zZXJlc25ldDEwMSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_seresnet101&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new S({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbGVnYWN5X3NlcmVzbmV0MTAxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_seresnet101&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new S({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new S({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new X({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),R=new Qt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/legacy-se-resnet.mdx"}}),{c(){g=p("meta"),z=a(),_=p("p"),Y=a(),m(d.$$.fragment),F=a(),m(w.$$.fragment),H=a(),J=p("p"),J.innerHTML=dt,A=a(),m(j.$$.fragment),L=a(),u=p("p"),u.textContent=wt,q=a(),m(f.$$.fragment),D=a(),T=p("p"),T.textContent=Jt,P=a(),m(b.$$.fragment),K=a(),U=p("p"),U.textContent=jt,O=a(),m($.$$.fragment),tt=a(),C=p("p"),C.textContent=ut,st=a(),m(I.$$.fragment),et=a(),k=p("p"),k.innerHTML=ft,lt=a(),W=p("p"),W.innerHTML=Tt,at=a(),m(Z.$$.fragment),nt=a(),x=p("p"),x.textContent=bt,pt=a(),m(N.$$.fragment),mt=a(),G=p("p"),G.innerHTML=Ut,it=a(),m(B.$$.fragment),ot=a(),E=p("p"),E.innerHTML=$t,rt=a(),m(Q.$$.fragment),ct=a(),m(V.$$.fragment),ht=a(),m(R.$$.fragment),Mt=a(),v=p("p"),this.h()},l(t){const s=Gt("svelte-u9bgzb",document.head);g=i(s,"META",{name:!0,content:!0}),s.forEach(e),z=n(t),_=i(t,"P",{}),Ct(_).forEach(e),Y=n(t),o(d.$$.fragment,t),F=n(t),o(w.$$.fragment,t),H=n(t),J=i(t,"P",{"data-svelte-h":!0}),y(J)!=="svelte-1b8qp0g"&&(J.innerHTML=dt),A=n(t),o(j.$$.fragment,t),L=n(t),u=i(t,"P",{"data-svelte-h":!0}),y(u)!=="svelte-18ywhxh"&&(u.textContent=wt),q=n(t),o(f.$$.fragment,t),D=n(t),T=i(t,"P",{"data-svelte-h":!0}),y(T)!=="svelte-1c2ipa8"&&(T.textContent=Jt),P=n(t),o(b.$$.fragment,t),K=n(t),U=i(t,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1n9qsq1"&&(U.textContent=jt),O=n(t),o($.$$.fragment,t),tt=n(t),C=i(t,"P",{"data-svelte-h":!0}),y(C)!=="svelte-19cnvx1"&&(C.textContent=ut),st=n(t),o(I.$$.fragment,t),et=n(t),k=i(t,"P",{"data-svelte-h":!0}),y(k)!=="svelte-ez0uq1"&&(k.innerHTML=ft),lt=n(t),W=i(t,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1wmi3ea"&&(W.innerHTML=Tt),at=n(t),o(Z.$$.fragment,t),nt=n(t),x=i(t,"P",{"data-svelte-h":!0}),y(x)!=="svelte-9sr7nh"&&(x.textContent=bt),pt=n(t),o(N.$$.fragment,t),mt=n(t),G=i(t,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1kguc51"&&(G.innerHTML=Ut),it=n(t),o(B.$$.fragment,t),ot=n(t),E=i(t,"P",{"data-svelte-h":!0}),y(E)!=="svelte-xtxxu6"&&(E.innerHTML=$t),rt=n(t),o(Q.$$.fragment,t),ct=n(t),o(V.$$.fragment,t),ht=n(t),o(R.$$.fragment,t),Mt=n(t),v=i(t,"P",{}),Ct(v).forEach(e),this.h()},h(){It(g,"name","hf:doc:metadata"),It(g,"content",Rt)},m(t,s){Bt(document.head,g),l(t,z,s),l(t,_,s),l(t,Y,s),r(d,t,s),l(t,F,s),r(w,t,s),l(t,H,s),l(t,J,s),l(t,A,s),r(j,t,s),l(t,L,s),l(t,u,s),l(t,q,s),r(f,t,s),l(t,D,s),l(t,T,s),l(t,P,s),r(b,t,s),l(t,K,s),l(t,U,s),l(t,O,s),r($,t,s),l(t,tt,s),l(t,C,s),l(t,st,s),r(I,t,s),l(t,et,s),l(t,k,s),l(t,lt,s),l(t,W,s),l(t,at,s),r(Z,t,s),l(t,nt,s),l(t,x,s),l(t,pt,s),r(N,t,s),l(t,mt,s),l(t,G,s),l(t,it,s),r(B,t,s),l(t,ot,s),l(t,E,s),l(t,rt,s),r(Q,t,s),l(t,ct,s),r(V,t,s),l(t,ht,s),r(R,t,s),l(t,Mt,s),l(t,v,s),yt=!0},p:Wt,i(t){yt||(c(d.$$.fragment,t),c(w.$$.fragment,t),c(j.$$.fragment,t),c(f.$$.fragment,t),c(b.$$.fragment,t),c($.$$.fragment,t),c(I.$$.fragment,t),c(Z.$$.fragment,t),c(N.$$.fragment,t),c(B.$$.fragment,t),c(Q.$$.fragment,t),c(V.$$.fragment,t),c(R.$$.fragment,t),yt=!0)},o(t){h(d.$$.fragment,t),h(w.$$.fragment,t),h(j.$$.fragment,t),h(f.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(I.$$.fragment,t),h(Z.$$.fragment,t),h(N.$$.fragment,t),h(B.$$.fragment,t),h(Q.$$.fragment,t),h(V.$$.fragment,t),h(R.$$.fragment,t),yt=!1},d(t){t&&(e(z),e(_),e(Y),e(F),e(H),e(J),e(A),e(L),e(u),e(q),e(D),e(T),e(P),e(K),e(U),e(O),e(tt),e(C),e(st),e(et),e(k),e(lt),e(W),e(at),e(nt),e(x),e(pt),e(mt),e(G),e(it),e(ot),e(E),e(rt),e(ct),e(ht),e(Mt),e(v)),e(g),M(d,t),M(w,t),M(j,t),M(f,t),M(b,t),M($,t),M(I,t),M(Z,t),M(N,t),M(B,t),M(Q,t),M(V,t),M(R,t)}}}const Rt='{"title":"(Legacy) SE-ResNet","local":"legacy-se-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xt(gt){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends xt{constructor(g){super(),Nt(this,g,Xt,Vt,kt,{})}}export{Yt as component};
