import{s as It,n as Zt,o as Wt}from"../chunks/scheduler.0b596ca5.js";import{S as Gt,i as vt,e as p,s as a,c as m,h as kt,a as i,d as l,b as n,f as xt,g as o,j as g,k as Ct,l as Nt,m as e,n as c,t as r,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Bt,H as Y,E as Qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as V}from"../chunks/CodeBlock.9f18e41e.js";function Et(jt){let j,A,R,S,d,z,y,H,w,dt='<strong>MixNet</strong> is a type of convolutional neural network discovered via AutoML that utilises <a href="https://paperswithcode.com/method/mixconv" rel="nofollow">MixConvs</a> instead of regular <a href="https://paperswithcode.com/method/depthwise-convolution" rel="nofollow">depthwise convolutions</a>.',F,u,L,J,yt="To load a pretrained model:",D,f,q,T,wt="To load and preprocess the image:",K,b,P,U,ut="To get the model predictions:",O,$,tt,x,Jt="To get the top-5 predictions class names:",st,C,lt,I,ft="Replace the model name with the variant you want to use, e.g. <code>mixnet_l</code>. You can find the IDs in the model summaries at the top of this page.",et,Z,Tt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,W,nt,G,bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,v,mt,k,Ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,N,ot,B,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ct,Q,rt,E,ht,_,Mt,X,gt;return d=new Bt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new Y({props:{title:"MixNet",local:"mixnet",headingTag:"h1"}}),u=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21peG5ldF9sJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),v=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbWl4bmV0X2wnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new V({props:{code:"JTQwbWlzYyU3QnRhbjIwMTltaXhjb252JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JNaXhDb252JTNBJTIwTWl4ZWQlMjBEZXB0aHdpc2UlMjBDb252b2x1dGlvbmFsJTIwS2VybmVscyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qk1pbmd4aW5nJTIwVGFuJTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MDcuMDk1OTUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2019mixconv,
      title={MixConv: Mixed Depthwise Convolutional Kernels}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1907.09595}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),_=new Qt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/mixnet.mdx"}}),{c(){j=p("meta"),A=a(),R=p("p"),S=a(),m(d.$$.fragment),z=a(),m(y.$$.fragment),H=a(),w=p("p"),w.innerHTML=dt,F=a(),m(u.$$.fragment),L=a(),J=p("p"),J.textContent=yt,D=a(),m(f.$$.fragment),q=a(),T=p("p"),T.textContent=wt,K=a(),m(b.$$.fragment),P=a(),U=p("p"),U.textContent=ut,O=a(),m($.$$.fragment),tt=a(),x=p("p"),x.textContent=Jt,st=a(),m(C.$$.fragment),lt=a(),I=p("p"),I.innerHTML=ft,et=a(),Z=p("p"),Z.innerHTML=Tt,at=a(),m(W.$$.fragment),nt=a(),G=p("p"),G.textContent=bt,pt=a(),m(v.$$.fragment),mt=a(),k=p("p"),k.innerHTML=Ut,it=a(),m(N.$$.fragment),ot=a(),B=p("p"),B.innerHTML=$t,ct=a(),m(Q.$$.fragment),rt=a(),m(E.$$.fragment),ht=a(),m(_.$$.fragment),Mt=a(),X=p("p"),this.h()},l(t){const s=kt("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(l),A=n(t),R=i(t,"P",{}),xt(R).forEach(l),S=n(t),o(d.$$.fragment,t),z=n(t),o(y.$$.fragment,t),H=n(t),w=i(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-ipcg9j"&&(w.innerHTML=dt),F=n(t),o(u.$$.fragment,t),L=n(t),J=i(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-18ywhxh"&&(J.textContent=yt),D=n(t),o(f.$$.fragment,t),q=n(t),T=i(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=wt),K=n(t),o(b.$$.fragment,t),P=n(t),U=i(t,"P",{"data-svelte-h":!0}),g(U)!=="svelte-1n9qsq1"&&(U.textContent=ut),O=n(t),o($.$$.fragment,t),tt=n(t),x=i(t,"P",{"data-svelte-h":!0}),g(x)!=="svelte-19cnvx1"&&(x.textContent=Jt),st=n(t),o(C.$$.fragment,t),lt=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-o2qdri"&&(I.innerHTML=ft),et=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=Tt),at=n(t),o(W.$$.fragment,t),nt=n(t),G=i(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-9sr7nh"&&(G.textContent=bt),pt=n(t),o(v.$$.fragment,t),mt=n(t),k=i(t,"P",{"data-svelte-h":!0}),g(k)!=="svelte-1kguc51"&&(k.innerHTML=Ut),it=n(t),o(N.$$.fragment,t),ot=n(t),B=i(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-xtxxu6"&&(B.innerHTML=$t),ct=n(t),o(Q.$$.fragment,t),rt=n(t),o(E.$$.fragment,t),ht=n(t),o(_.$$.fragment,t),Mt=n(t),X=i(t,"P",{}),xt(X).forEach(l),this.h()},h(){Ct(j,"name","hf:doc:metadata"),Ct(j,"content",_t)},m(t,s){Nt(document.head,j),e(t,A,s),e(t,R,s),e(t,S,s),c(d,t,s),e(t,z,s),c(y,t,s),e(t,H,s),e(t,w,s),e(t,F,s),c(u,t,s),e(t,L,s),e(t,J,s),e(t,D,s),c(f,t,s),e(t,q,s),e(t,T,s),e(t,K,s),c(b,t,s),e(t,P,s),e(t,U,s),e(t,O,s),c($,t,s),e(t,tt,s),e(t,x,s),e(t,st,s),c(C,t,s),e(t,lt,s),e(t,I,s),e(t,et,s),e(t,Z,s),e(t,at,s),c(W,t,s),e(t,nt,s),e(t,G,s),e(t,pt,s),c(v,t,s),e(t,mt,s),e(t,k,s),e(t,it,s),c(N,t,s),e(t,ot,s),e(t,B,s),e(t,ct,s),c(Q,t,s),e(t,rt,s),c(E,t,s),e(t,ht,s),c(_,t,s),e(t,Mt,s),e(t,X,s),gt=!0},p:Zt,i(t){gt||(r(d.$$.fragment,t),r(y.$$.fragment,t),r(u.$$.fragment,t),r(f.$$.fragment,t),r(b.$$.fragment,t),r($.$$.fragment,t),r(C.$$.fragment,t),r(W.$$.fragment,t),r(v.$$.fragment,t),r(N.$$.fragment,t),r(Q.$$.fragment,t),r(E.$$.fragment,t),r(_.$$.fragment,t),gt=!0)},o(t){h(d.$$.fragment,t),h(y.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(C.$$.fragment,t),h(W.$$.fragment,t),h(v.$$.fragment,t),h(N.$$.fragment,t),h(Q.$$.fragment,t),h(E.$$.fragment,t),h(_.$$.fragment,t),gt=!1},d(t){t&&(l(A),l(R),l(S),l(z),l(H),l(w),l(F),l(L),l(J),l(D),l(q),l(T),l(K),l(P),l(U),l(O),l(tt),l(x),l(st),l(lt),l(I),l(et),l(Z),l(at),l(nt),l(G),l(pt),l(mt),l(k),l(it),l(ot),l(B),l(ct),l(rt),l(ht),l(Mt),l(X)),l(j),M(d,t),M(y,t),M(u,t),M(f,t),M(b,t),M($,t),M(C,t),M(W,t),M(v,t),M(N,t),M(Q,t),M(E,t),M(_,t)}}}const _t='{"title":"MixNet","local":"mixnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Vt(jt){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends Gt{constructor(j){super(),vt(this,j,Vt,Et,It,{})}}export{St as component};
