import{s as $s,n as ks,o as Ws}from"../chunks/scheduler.0b596ca5.js";import{S as xs,i as Bs,e as p,s as a,c as i,h as Ns,a as m,d as l,b as n,f as Is,g as M,j as h,k as Zs,l as Gs,m as e,n as o,t as r,o as c,p as y}from"../chunks/index.d9d53bd3.js";import{C as Es,H as V,E as Qs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as R}from"../chunks/CodeBlock.9f18e41e.js";function vs(Js){let J,X,S,_,j,z,w,H,g,js='<strong>MobileNetV2</strong> is a convolutional neural network architecture that seeks to perform well on mobile devices. It is based on an <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">inverted residual structure</a> where the residual connections are between the bottleneck layers.  The intermediate expansion layer uses lightweight depthwise convolutions to filter features as a source of non-linearity. As a whole, the architecture of MobileNetV2 contains the initial fully convolution layer with 32 filters, followed by 19 residual bottleneck layers.',F,T,D,d,ws="To load a pretrained model:",L,U,q,b,gs="To load and preprocess the image:",P,u,K,f,Ts="To get the model predictions:",O,C,ss,I,ds="To get the top-5 predictions class names:",ts,Z,ls,$,Us="Replace the model name with the variant you want to use, e.g. <code>mobilenetv2_100</code>. You can find the IDs in the model summaries at the top of this page.",es,k,bs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,W,ns,x,us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,B,is,N,fs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ms,G,Ms,E,Cs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',os,Q,rs,v,cs,A,ys,Y,hs;return j=new Es({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new V({props:{title:"MobileNet v2",local:"mobilenet-v2",headingTag:"h1"}}),T=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),U=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21vYmlsZW5ldHYyXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv2_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),u=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djJfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv2_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new R({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTgwMS0wNDM4MSUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3Qk1hcmslMjBTYW5kbGVyJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQW5kcmV3JTIwRy4lMjBIb3dhcmQlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNZW5nbG9uZyUyMFpodSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFuZHJleSUyMFpobW9naW5vdiUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMExpYW5nJTdCLSU3RENoaWVoJTIwQ2hlbiU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCSW52ZXJ0ZWQlMjBSZXNpZHVhbHMlMjBhbmQlMjBMaW5lYXIlMjBCb3R0bGVuZWNrcyUzQSUyME1vYmlsZSUyME5ldHdvcmtzJTIwZm9yJTIwQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZXRlY3Rpb24lMjBhbmQlMjBTZWdtZW50YXRpb24lN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE4MDEuMDQzODElN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxOCU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxODAxLjA0MzgxJTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTgwMS4wNDM4MSU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3QlR1ZSUyQyUyMDEyJTIwSmFuJTIwMjAyMSUyMDE1JTNBMzAlM0EwNiUyMCUyQjAxMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGYWJzLTE4MDEtMDQzODEuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1801</span>-<span class="hljs-number">04381</span>,
  author    = {Mark Sandler and
               Andrew G. Howard and
               Menglong Zhu and
               Andrey Zhmoginov and
               Liang{-}Chieh Chen},
  title     = {Inverted Residuals and Linear Bottlenecks: Mobile Networks <span class="hljs-keyword">for</span> Classification,
               Detection and Segmentation},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1801.04381</span>},
  year      = {<span class="hljs-number">2018</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1801.04381</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1801.04381</span>},
  timestamp = {Tue, <span class="hljs-number">12</span> Jan <span class="hljs-number">2021</span> <span class="hljs-number">15</span>:<span class="hljs-number">30</span>:<span class="hljs-number">06</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1801</span>-<span class="hljs-number">04381</span>.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),A=new Qs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/mobilenet-v2.mdx"}}),{c(){J=p("meta"),X=a(),S=p("p"),_=a(),i(j.$$.fragment),z=a(),i(w.$$.fragment),H=a(),g=p("p"),g.innerHTML=js,F=a(),i(T.$$.fragment),D=a(),d=p("p"),d.textContent=ws,L=a(),i(U.$$.fragment),q=a(),b=p("p"),b.textContent=gs,P=a(),i(u.$$.fragment),K=a(),f=p("p"),f.textContent=Ts,O=a(),i(C.$$.fragment),ss=a(),I=p("p"),I.textContent=ds,ts=a(),i(Z.$$.fragment),ls=a(),$=p("p"),$.innerHTML=Us,es=a(),k=p("p"),k.innerHTML=bs,as=a(),i(W.$$.fragment),ns=a(),x=p("p"),x.textContent=us,ps=a(),i(B.$$.fragment),is=a(),N=p("p"),N.innerHTML=fs,ms=a(),i(G.$$.fragment),Ms=a(),E=p("p"),E.innerHTML=Cs,os=a(),i(Q.$$.fragment),rs=a(),i(v.$$.fragment),cs=a(),i(A.$$.fragment),ys=a(),Y=p("p"),this.h()},l(s){const t=Ns("svelte-u9bgzb",document.head);J=m(t,"META",{name:!0,content:!0}),t.forEach(l),X=n(s),S=m(s,"P",{}),Is(S).forEach(l),_=n(s),M(j.$$.fragment,s),z=n(s),M(w.$$.fragment,s),H=n(s),g=m(s,"P",{"data-svelte-h":!0}),h(g)!=="svelte-fgcsw6"&&(g.innerHTML=js),F=n(s),M(T.$$.fragment,s),D=n(s),d=m(s,"P",{"data-svelte-h":!0}),h(d)!=="svelte-18ywhxh"&&(d.textContent=ws),L=n(s),M(U.$$.fragment,s),q=n(s),b=m(s,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1c2ipa8"&&(b.textContent=gs),P=n(s),M(u.$$.fragment,s),K=n(s),f=m(s,"P",{"data-svelte-h":!0}),h(f)!=="svelte-1n9qsq1"&&(f.textContent=Ts),O=n(s),M(C.$$.fragment,s),ss=n(s),I=m(s,"P",{"data-svelte-h":!0}),h(I)!=="svelte-19cnvx1"&&(I.textContent=ds),ts=n(s),M(Z.$$.fragment,s),ls=n(s),$=m(s,"P",{"data-svelte-h":!0}),h($)!=="svelte-11s0yt3"&&($.innerHTML=Us),es=n(s),k=m(s,"P",{"data-svelte-h":!0}),h(k)!=="svelte-1wmi3ea"&&(k.innerHTML=bs),as=n(s),M(W.$$.fragment,s),ns=n(s),x=m(s,"P",{"data-svelte-h":!0}),h(x)!=="svelte-9sr7nh"&&(x.textContent=us),ps=n(s),M(B.$$.fragment,s),is=n(s),N=m(s,"P",{"data-svelte-h":!0}),h(N)!=="svelte-1kguc51"&&(N.innerHTML=fs),ms=n(s),M(G.$$.fragment,s),Ms=n(s),E=m(s,"P",{"data-svelte-h":!0}),h(E)!=="svelte-xtxxu6"&&(E.innerHTML=Cs),os=n(s),M(Q.$$.fragment,s),rs=n(s),M(v.$$.fragment,s),cs=n(s),M(A.$$.fragment,s),ys=n(s),Y=m(s,"P",{}),Is(Y).forEach(l),this.h()},h(){Zs(J,"name","hf:doc:metadata"),Zs(J,"content",As)},m(s,t){Gs(document.head,J),e(s,X,t),e(s,S,t),e(s,_,t),o(j,s,t),e(s,z,t),o(w,s,t),e(s,H,t),e(s,g,t),e(s,F,t),o(T,s,t),e(s,D,t),e(s,d,t),e(s,L,t),o(U,s,t),e(s,q,t),e(s,b,t),e(s,P,t),o(u,s,t),e(s,K,t),e(s,f,t),e(s,O,t),o(C,s,t),e(s,ss,t),e(s,I,t),e(s,ts,t),o(Z,s,t),e(s,ls,t),e(s,$,t),e(s,es,t),e(s,k,t),e(s,as,t),o(W,s,t),e(s,ns,t),e(s,x,t),e(s,ps,t),o(B,s,t),e(s,is,t),e(s,N,t),e(s,ms,t),o(G,s,t),e(s,Ms,t),e(s,E,t),e(s,os,t),o(Q,s,t),e(s,rs,t),o(v,s,t),e(s,cs,t),o(A,s,t),e(s,ys,t),e(s,Y,t),hs=!0},p:ks,i(s){hs||(r(j.$$.fragment,s),r(w.$$.fragment,s),r(T.$$.fragment,s),r(U.$$.fragment,s),r(u.$$.fragment,s),r(C.$$.fragment,s),r(Z.$$.fragment,s),r(W.$$.fragment,s),r(B.$$.fragment,s),r(G.$$.fragment,s),r(Q.$$.fragment,s),r(v.$$.fragment,s),r(A.$$.fragment,s),hs=!0)},o(s){c(j.$$.fragment,s),c(w.$$.fragment,s),c(T.$$.fragment,s),c(U.$$.fragment,s),c(u.$$.fragment,s),c(C.$$.fragment,s),c(Z.$$.fragment,s),c(W.$$.fragment,s),c(B.$$.fragment,s),c(G.$$.fragment,s),c(Q.$$.fragment,s),c(v.$$.fragment,s),c(A.$$.fragment,s),hs=!1},d(s){s&&(l(X),l(S),l(_),l(z),l(H),l(g),l(F),l(D),l(d),l(L),l(q),l(b),l(P),l(K),l(f),l(O),l(ss),l(I),l(ts),l(ls),l($),l(es),l(k),l(as),l(ns),l(x),l(ps),l(is),l(N),l(ms),l(Ms),l(E),l(os),l(rs),l(cs),l(ys),l(Y)),l(J),y(j,s),y(w,s),y(T,s),y(U,s),y(u,s),y(C,s),y(Z,s),y(W,s),y(B,s),y(G,s),y(Q,s),y(v,s),y(A,s)}}}const As='{"title":"MobileNet v2","local":"mobilenet-v2","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Rs(Js){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends xs{constructor(J){super(),Bs(this,J,Rs,vs,$s,{})}}export{_s as component};
