import{s as kt,n as xt,o as Gt}from"../chunks/scheduler.0b596ca5.js";import{S as It,i as Wt,e as p,s as a,c as m,h as Nt,a as i,d as l,b as n,f as Ct,g as o,j as g,k as Zt,l as Bt,m as e,n as r,t as c,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as vt,H as R,E as Qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as V}from"../chunks/CodeBlock.9f18e41e.js";function Et(jt){let j,_,Y,S,y,z,d,F,u,yt="<strong>NASNet</strong> is a type of convolutional neural network discovered through neural architecture search. The building blocks consist of normal and reduction cells.",H,J,L,w,dt="To load a pretrained model:",q,f,D,b,ut="To load and preprocess the image:",P,T,K,U,Jt="To get the model predictions:",O,$,tt,C,wt="To get the top-5 predictions class names:",st,Z,lt,k,ft="Replace the model name with the variant you want to use, e.g. <code>nasnetalarge</code>. You can find the IDs in the model summaries at the top of this page.",et,x,bt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,G,nt,I,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,W,mt,N,Ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,B,ot,v,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,Q,ct,E,ht,X,Mt,A,gt;return y=new vt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new R({props:{title:"NASNet",local:"nasnet",headingTag:"h1"}}),J=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ25hc25ldGFsYXJnZSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;nasnetalarge&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),T=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),G=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),W=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbmFzbmV0YWxhcmdlJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;nasnetalarge&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new V({props:{code:"JTQwbWlzYyU3QnpvcGgyMDE4bGVhcm5pbmclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkxlYXJuaW5nJTIwVHJhbnNmZXJhYmxlJTIwQXJjaGl0ZWN0dXJlcyUyMGZvciUyMFNjYWxhYmxlJTIwSW1hZ2UlMjBSZWNvZ25pdGlvbiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkJhcnJldCUyMFpvcGglMjBhbmQlMjBWaWpheSUyMFZhc3VkZXZhbiUyMGFuZCUyMEpvbmF0aG9uJTIwU2hsZW5zJTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDcwMTIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{zoph2018learning,
      title={Learning Transferable Architectures for <span class="hljs-keyword">Scalable </span>Image Recognition},
      author={<span class="hljs-keyword">Barret </span>Zoph <span class="hljs-keyword">and </span>Vijay Vasudevan <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathon </span><span class="hljs-keyword">Shlens </span><span class="hljs-keyword">and </span>Quoc V. Le},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1707</span>.<span class="hljs-number">07012</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),X=new Qt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/nasnet.mdx"}}),{c(){j=p("meta"),_=a(),Y=p("p"),S=a(),m(y.$$.fragment),z=a(),m(d.$$.fragment),F=a(),u=p("p"),u.innerHTML=yt,H=a(),m(J.$$.fragment),L=a(),w=p("p"),w.textContent=dt,q=a(),m(f.$$.fragment),D=a(),b=p("p"),b.textContent=ut,P=a(),m(T.$$.fragment),K=a(),U=p("p"),U.textContent=Jt,O=a(),m($.$$.fragment),tt=a(),C=p("p"),C.textContent=wt,st=a(),m(Z.$$.fragment),lt=a(),k=p("p"),k.innerHTML=ft,et=a(),x=p("p"),x.innerHTML=bt,at=a(),m(G.$$.fragment),nt=a(),I=p("p"),I.textContent=Tt,pt=a(),m(W.$$.fragment),mt=a(),N=p("p"),N.innerHTML=Ut,it=a(),m(B.$$.fragment),ot=a(),v=p("p"),v.innerHTML=$t,rt=a(),m(Q.$$.fragment),ct=a(),m(E.$$.fragment),ht=a(),m(X.$$.fragment),Mt=a(),A=p("p"),this.h()},l(t){const s=Nt("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(l),_=n(t),Y=i(t,"P",{}),Ct(Y).forEach(l),S=n(t),o(y.$$.fragment,t),z=n(t),o(d.$$.fragment,t),F=n(t),u=i(t,"P",{"data-svelte-h":!0}),g(u)!=="svelte-1u56z5m"&&(u.innerHTML=yt),H=n(t),o(J.$$.fragment,t),L=n(t),w=i(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-18ywhxh"&&(w.textContent=dt),q=n(t),o(f.$$.fragment,t),D=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1c2ipa8"&&(b.textContent=ut),P=n(t),o(T.$$.fragment,t),K=n(t),U=i(t,"P",{"data-svelte-h":!0}),g(U)!=="svelte-1n9qsq1"&&(U.textContent=Jt),O=n(t),o($.$$.fragment,t),tt=n(t),C=i(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-19cnvx1"&&(C.textContent=wt),st=n(t),o(Z.$$.fragment,t),lt=n(t),k=i(t,"P",{"data-svelte-h":!0}),g(k)!=="svelte-qu63rt"&&(k.innerHTML=ft),et=n(t),x=i(t,"P",{"data-svelte-h":!0}),g(x)!=="svelte-1wmi3ea"&&(x.innerHTML=bt),at=n(t),o(G.$$.fragment,t),nt=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-9sr7nh"&&(I.textContent=Tt),pt=n(t),o(W.$$.fragment,t),mt=n(t),N=i(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1kguc51"&&(N.innerHTML=Ut),it=n(t),o(B.$$.fragment,t),ot=n(t),v=i(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-xtxxu6"&&(v.innerHTML=$t),rt=n(t),o(Q.$$.fragment,t),ct=n(t),o(E.$$.fragment,t),ht=n(t),o(X.$$.fragment,t),Mt=n(t),A=i(t,"P",{}),Ct(A).forEach(l),this.h()},h(){Zt(j,"name","hf:doc:metadata"),Zt(j,"content",Xt)},m(t,s){Bt(document.head,j),e(t,_,s),e(t,Y,s),e(t,S,s),r(y,t,s),e(t,z,s),r(d,t,s),e(t,F,s),e(t,u,s),e(t,H,s),r(J,t,s),e(t,L,s),e(t,w,s),e(t,q,s),r(f,t,s),e(t,D,s),e(t,b,s),e(t,P,s),r(T,t,s),e(t,K,s),e(t,U,s),e(t,O,s),r($,t,s),e(t,tt,s),e(t,C,s),e(t,st,s),r(Z,t,s),e(t,lt,s),e(t,k,s),e(t,et,s),e(t,x,s),e(t,at,s),r(G,t,s),e(t,nt,s),e(t,I,s),e(t,pt,s),r(W,t,s),e(t,mt,s),e(t,N,s),e(t,it,s),r(B,t,s),e(t,ot,s),e(t,v,s),e(t,rt,s),r(Q,t,s),e(t,ct,s),r(E,t,s),e(t,ht,s),r(X,t,s),e(t,Mt,s),e(t,A,s),gt=!0},p:xt,i(t){gt||(c(y.$$.fragment,t),c(d.$$.fragment,t),c(J.$$.fragment,t),c(f.$$.fragment,t),c(T.$$.fragment,t),c($.$$.fragment,t),c(Z.$$.fragment,t),c(G.$$.fragment,t),c(W.$$.fragment,t),c(B.$$.fragment,t),c(Q.$$.fragment,t),c(E.$$.fragment,t),c(X.$$.fragment,t),gt=!0)},o(t){h(y.$$.fragment,t),h(d.$$.fragment,t),h(J.$$.fragment,t),h(f.$$.fragment,t),h(T.$$.fragment,t),h($.$$.fragment,t),h(Z.$$.fragment,t),h(G.$$.fragment,t),h(W.$$.fragment,t),h(B.$$.fragment,t),h(Q.$$.fragment,t),h(E.$$.fragment,t),h(X.$$.fragment,t),gt=!1},d(t){t&&(l(_),l(Y),l(S),l(z),l(F),l(u),l(H),l(L),l(w),l(q),l(D),l(b),l(P),l(K),l(U),l(O),l(tt),l(C),l(st),l(lt),l(k),l(et),l(x),l(at),l(nt),l(I),l(pt),l(mt),l(N),l(it),l(ot),l(v),l(rt),l(ct),l(ht),l(Mt),l(A)),l(j),M(y,t),M(d,t),M(J,t),M(f,t),M(T,t),M($,t),M(Z,t),M(G,t),M(W,t),M(B,t),M(Q,t),M(E,t),M(X,t)}}}const Xt='{"title":"NASNet","local":"nasnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Vt(jt){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends It{constructor(j){super(),Wt(this,j,Vt,Et,kt,{})}}export{St as component};
