import{s as Et,n as Qt,o as Xt}from"../chunks/scheduler.0b596ca5.js";import{S as Rt,i as Vt,e as i,s as a,c as m,h as Yt,a as p,d as s,b as n,f as Gt,g as o,j as r,k as _t,l as At,m as l,n as c,t as h,o as M,p as d}from"../chunks/index.d9d53bd3.js";import{C as St,H as z,E as zt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as Y}from"../chunks/CodeBlock.9f18e41e.js";function Ht(wt){let g,H,A,F,u,L,j,q,f,Tt=`<strong>Noisy Student Training</strong> is a semi-supervised learning approach. It extends the idea of self-training
and distillation with the use of equal-or-larger student models and noise added to the student during learning. It has three main steps:`,P,y,bt="<li>train a teacher model on labeled images</li> <li>use the teacher to generate pseudo labels on unlabeled images</li> <li>train a student model on the combination of labeled images and pseudo labeled images.</li>",D,J,Ut="The algorithm is iterated a few times by treating the student as a teacher to relabel the unlabeled data and training a new student.",K,w,$t="Noisy Student Training seeks to improve on self-training and distillation in two ways. First, it makes the student larger than, or at least equal to, the teacher so the student can better learn from a larger dataset. Second, it adds noise to the student so the noised student is forced to learn harder from the pseudo labels. To noise the student, it uses input noise such as RandAugment data augmentation, and model noise such as dropout and stochastic depth during training.",O,T,tt,b,xt="To load a pretrained model:",et,U,st,$,Zt="To load and preprocess the image:",lt,x,at,Z,Ct="To get the model predictions:",nt,C,it,I,It="To get the top-5 predictions class names:",pt,W,mt,N,Wt="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_b0_ns</code>. You can find the IDs in the model summaries at the top of this page.",ot,k,Nt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',rt,v,ct,B,kt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ht,G,Mt,_,vt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,dt,E,gt,Q,Bt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ut,X,jt,R,ft,V,yt,S,Jt;return u=new St({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new z({props:{title:"Noisy Student (EfficientNet)",local:"noisy-student-efficientnet",headingTag:"h1"}}),T=new z({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),U=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9iMF9ucyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ns&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),x=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),W=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),v=new z({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2IwX25zJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ns&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new z({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),X=new z({props:{title:"Citation",local:"citation",headingTag:"h2"}}),R=new Y({props:{code:"JTQwbWlzYyU3QnhpZTIwMjBzZWxmdHJhaW5pbmclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlNlbGYtdHJhaW5pbmclMjB3aXRoJTIwTm9pc3klMjBTdHVkZW50JTIwaW1wcm92ZXMlMjBJbWFnZU5ldCUyMGNsYXNzaWZpY2F0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCUWl6aGUlMjBYaWUlMjBhbmQlMjBNaW5oLVRoYW5nJTIwTHVvbmclMjBhbmQlMjBFZHVhcmQlMjBIb3Z5JTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MTEuMDQyNTIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5MRyU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{xie2020selftraining,
      title={Self-training with Noisy Student improves ImageNet classification}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Qizhe Xie and Minh-Thang Luong and Eduard Hovy and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1911.04252}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`,wrap:!1}}),V=new zt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/noisy-student.mdx"}}),{c(){g=i("meta"),H=a(),A=i("p"),F=a(),m(u.$$.fragment),L=a(),m(j.$$.fragment),q=a(),f=i("p"),f.innerHTML=Tt,P=a(),y=i("ol"),y.innerHTML=bt,D=a(),J=i("p"),J.textContent=Ut,K=a(),w=i("p"),w.textContent=$t,O=a(),m(T.$$.fragment),tt=a(),b=i("p"),b.textContent=xt,et=a(),m(U.$$.fragment),st=a(),$=i("p"),$.textContent=Zt,lt=a(),m(x.$$.fragment),at=a(),Z=i("p"),Z.textContent=Ct,nt=a(),m(C.$$.fragment),it=a(),I=i("p"),I.textContent=It,pt=a(),m(W.$$.fragment),mt=a(),N=i("p"),N.innerHTML=Wt,ot=a(),k=i("p"),k.innerHTML=Nt,rt=a(),m(v.$$.fragment),ct=a(),B=i("p"),B.textContent=kt,ht=a(),m(G.$$.fragment),Mt=a(),_=i("p"),_.innerHTML=vt,dt=a(),m(E.$$.fragment),gt=a(),Q=i("p"),Q.innerHTML=Bt,ut=a(),m(X.$$.fragment),jt=a(),m(R.$$.fragment),ft=a(),m(V.$$.fragment),yt=a(),S=i("p"),this.h()},l(t){const e=Yt("svelte-u9bgzb",document.head);g=p(e,"META",{name:!0,content:!0}),e.forEach(s),H=n(t),A=p(t,"P",{}),Gt(A).forEach(s),F=n(t),o(u.$$.fragment,t),L=n(t),o(j.$$.fragment,t),q=n(t),f=p(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-zn3ycx"&&(f.innerHTML=Tt),P=n(t),y=p(t,"OL",{"data-svelte-h":!0}),r(y)!=="svelte-1nvijn1"&&(y.innerHTML=bt),D=n(t),J=p(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-5ws6hn"&&(J.textContent=Ut),K=n(t),w=p(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1w0q41v"&&(w.textContent=$t),O=n(t),o(T.$$.fragment,t),tt=n(t),b=p(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-18ywhxh"&&(b.textContent=xt),et=n(t),o(U.$$.fragment,t),st=n(t),$=p(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1c2ipa8"&&($.textContent=Zt),lt=n(t),o(x.$$.fragment,t),at=n(t),Z=p(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1n9qsq1"&&(Z.textContent=Ct),nt=n(t),o(C.$$.fragment,t),it=n(t),I=p(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-19cnvx1"&&(I.textContent=It),pt=n(t),o(W.$$.fragment,t),mt=n(t),N=p(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-12tmaxg"&&(N.innerHTML=Wt),ot=n(t),k=p(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1wmi3ea"&&(k.innerHTML=Nt),rt=n(t),o(v.$$.fragment,t),ct=n(t),B=p(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-9sr7nh"&&(B.textContent=kt),ht=n(t),o(G.$$.fragment,t),Mt=n(t),_=p(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1kguc51"&&(_.innerHTML=vt),dt=n(t),o(E.$$.fragment,t),gt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-xtxxu6"&&(Q.innerHTML=Bt),ut=n(t),o(X.$$.fragment,t),jt=n(t),o(R.$$.fragment,t),ft=n(t),o(V.$$.fragment,t),yt=n(t),S=p(t,"P",{}),Gt(S).forEach(s),this.h()},h(){_t(g,"name","hf:doc:metadata"),_t(g,"content",Ft)},m(t,e){At(document.head,g),l(t,H,e),l(t,A,e),l(t,F,e),c(u,t,e),l(t,L,e),c(j,t,e),l(t,q,e),l(t,f,e),l(t,P,e),l(t,y,e),l(t,D,e),l(t,J,e),l(t,K,e),l(t,w,e),l(t,O,e),c(T,t,e),l(t,tt,e),l(t,b,e),l(t,et,e),c(U,t,e),l(t,st,e),l(t,$,e),l(t,lt,e),c(x,t,e),l(t,at,e),l(t,Z,e),l(t,nt,e),c(C,t,e),l(t,it,e),l(t,I,e),l(t,pt,e),c(W,t,e),l(t,mt,e),l(t,N,e),l(t,ot,e),l(t,k,e),l(t,rt,e),c(v,t,e),l(t,ct,e),l(t,B,e),l(t,ht,e),c(G,t,e),l(t,Mt,e),l(t,_,e),l(t,dt,e),c(E,t,e),l(t,gt,e),l(t,Q,e),l(t,ut,e),c(X,t,e),l(t,jt,e),c(R,t,e),l(t,ft,e),c(V,t,e),l(t,yt,e),l(t,S,e),Jt=!0},p:Qt,i(t){Jt||(h(u.$$.fragment,t),h(j.$$.fragment,t),h(T.$$.fragment,t),h(U.$$.fragment,t),h(x.$$.fragment,t),h(C.$$.fragment,t),h(W.$$.fragment,t),h(v.$$.fragment,t),h(G.$$.fragment,t),h(E.$$.fragment,t),h(X.$$.fragment,t),h(R.$$.fragment,t),h(V.$$.fragment,t),Jt=!0)},o(t){M(u.$$.fragment,t),M(j.$$.fragment,t),M(T.$$.fragment,t),M(U.$$.fragment,t),M(x.$$.fragment,t),M(C.$$.fragment,t),M(W.$$.fragment,t),M(v.$$.fragment,t),M(G.$$.fragment,t),M(E.$$.fragment,t),M(X.$$.fragment,t),M(R.$$.fragment,t),M(V.$$.fragment,t),Jt=!1},d(t){t&&(s(H),s(A),s(F),s(L),s(q),s(f),s(P),s(y),s(D),s(J),s(K),s(w),s(O),s(tt),s(b),s(et),s(st),s($),s(lt),s(at),s(Z),s(nt),s(it),s(I),s(pt),s(mt),s(N),s(ot),s(k),s(rt),s(ct),s(B),s(ht),s(Mt),s(_),s(dt),s(gt),s(Q),s(ut),s(jt),s(ft),s(yt),s(S)),s(g),d(u,t),d(j,t),d(T,t),d(U,t),d(x,t),d(C,t),d(W,t),d(v,t),d(G,t),d(E,t),d(X,t),d(R,t),d(V,t)}}}const Ft='{"title":"Noisy Student (EfficientNet)","local":"noisy-student-efficientnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Lt(wt){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends Rt{constructor(g){super(),Vt(this,g,Lt,Ht,Et,{})}}export{Ot as component};
