import{s as Cs,n as Bs,o as Ws}from"../chunks/scheduler.0b596ca5.js";import{S as Ns,i as Is,e as p,s as a,c as m,h as xs,a as i,d as l,b as n,f as Zs,g as o,j,k as ks,l as Gs,m as e,n as r,t as c,o as M,p as h}from"../chunks/index.d9d53bd3.js";import{C as Es,H as S,E as Qs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as Y}from"../chunks/CodeBlock.9f18e41e.js";function Xs(gs){let g,_,v,R,d,z,y,H,u,ds="<strong>Progressive Neural Architecture Search</strong>, or <strong>PNAS</strong>, is a method for learning the structure of convolutional neural networks (CNNs). It uses a sequential model-based optimization (SMBO) strategy, where we search the space of cell structures, starting with simple (shallow) models and progressing to complex ones, pruning out unpromising structures as we go.",F,w,L,J,ys="To load a pretrained model:",P,f,q,T,us="To load and preprocess the image:",D,b,K,U,ws="To get the model predictions:",O,$,ss,Z,Js="To get the top-5 predictions class names:",ts,k,ls,C,fs="Replace the model name with the variant you want to use, e.g. <code>pnasnet5large</code>. You can find the IDs in the model summaries at the top of this page.",es,B,Ts='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,W,ns,N,bs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,I,ms,x,Us=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,is,G,os,E,$s='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rs,Q,cs,X,Ms,A,hs,V,js;return d=new Es({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new S({props:{title:"PNASNet",local:"pnasnet",headingTag:"h1"}}),w=new S({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3BuYXNuZXQ1bGFyZ2UnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;pnasnet5large&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new S({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),I=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncG5hc25ldDVsYXJnZSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;pnasnet5large&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new S({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new S({props:{title:"Citation",local:"citation",headingTag:"h2"}}),X=new Y({props:{code:"JTQwbWlzYyU3QmxpdTIwMThwcm9ncmVzc2l2ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCUHJvZ3Jlc3NpdmUlMjBOZXVyYWwlMjBBcmNoaXRlY3R1cmUlMjBTZWFyY2glN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JDaGVueGklMjBMaXUlMjBhbmQlMjBCYXJyZXQlMjBab3BoJTIwYW5kJTIwTWF4aW0lMjBOZXVtYW5uJTIwYW5kJTIwSm9uYXRob24lMjBTaGxlbnMlMjBhbmQlMjBXZWklMjBIdWElMjBhbmQlMjBMaS1KaWElMjBMaSUyMGFuZCUyMExpJTIwRmVpLUZlaSUyMGFuZCUyMEFsYW4lMjBZdWlsbGUlMjBhbmQlMjBKb25hdGhhbiUyMEh1YW5nJTIwYW5kJTIwS2V2aW4lMjBNdXJwaHklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MTIuMDA1NTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{liu2018progressive,
      title={Progressive Neural Architecture Search}, 
      author={Chenxi Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Barret </span>Zoph <span class="hljs-keyword">and </span>Maxim Neumann <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathon </span><span class="hljs-keyword">Shlens </span><span class="hljs-keyword">and </span>Wei Hua <span class="hljs-keyword">and </span>Li-<span class="hljs-keyword">Jia </span>Li <span class="hljs-keyword">and </span>Li Fei-Fei <span class="hljs-keyword">and </span>Alan Yuille <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathan </span>Huang <span class="hljs-keyword">and </span>Kevin Murphy},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1712</span>.<span class="hljs-number">00559</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),A=new Qs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/pnasnet.mdx"}}),{c(){g=p("meta"),_=a(),v=p("p"),R=a(),m(d.$$.fragment),z=a(),m(y.$$.fragment),H=a(),u=p("p"),u.innerHTML=ds,F=a(),m(w.$$.fragment),L=a(),J=p("p"),J.textContent=ys,P=a(),m(f.$$.fragment),q=a(),T=p("p"),T.textContent=us,D=a(),m(b.$$.fragment),K=a(),U=p("p"),U.textContent=ws,O=a(),m($.$$.fragment),ss=a(),Z=p("p"),Z.textContent=Js,ts=a(),m(k.$$.fragment),ls=a(),C=p("p"),C.innerHTML=fs,es=a(),B=p("p"),B.innerHTML=Ts,as=a(),m(W.$$.fragment),ns=a(),N=p("p"),N.textContent=bs,ps=a(),m(I.$$.fragment),ms=a(),x=p("p"),x.innerHTML=Us,is=a(),m(G.$$.fragment),os=a(),E=p("p"),E.innerHTML=$s,rs=a(),m(Q.$$.fragment),cs=a(),m(X.$$.fragment),Ms=a(),m(A.$$.fragment),hs=a(),V=p("p"),this.h()},l(s){const t=xs("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(l),_=n(s),v=i(s,"P",{}),Zs(v).forEach(l),R=n(s),o(d.$$.fragment,s),z=n(s),o(y.$$.fragment,s),H=n(s),u=i(s,"P",{"data-svelte-h":!0}),j(u)!=="svelte-1wxq1ps"&&(u.innerHTML=ds),F=n(s),o(w.$$.fragment,s),L=n(s),J=i(s,"P",{"data-svelte-h":!0}),j(J)!=="svelte-18ywhxh"&&(J.textContent=ys),P=n(s),o(f.$$.fragment,s),q=n(s),T=i(s,"P",{"data-svelte-h":!0}),j(T)!=="svelte-1c2ipa8"&&(T.textContent=us),D=n(s),o(b.$$.fragment,s),K=n(s),U=i(s,"P",{"data-svelte-h":!0}),j(U)!=="svelte-1n9qsq1"&&(U.textContent=ws),O=n(s),o($.$$.fragment,s),ss=n(s),Z=i(s,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-19cnvx1"&&(Z.textContent=Js),ts=n(s),o(k.$$.fragment,s),ls=n(s),C=i(s,"P",{"data-svelte-h":!0}),j(C)!=="svelte-1ym24x9"&&(C.innerHTML=fs),es=n(s),B=i(s,"P",{"data-svelte-h":!0}),j(B)!=="svelte-1wmi3ea"&&(B.innerHTML=Ts),as=n(s),o(W.$$.fragment,s),ns=n(s),N=i(s,"P",{"data-svelte-h":!0}),j(N)!=="svelte-9sr7nh"&&(N.textContent=bs),ps=n(s),o(I.$$.fragment,s),ms=n(s),x=i(s,"P",{"data-svelte-h":!0}),j(x)!=="svelte-1kguc51"&&(x.innerHTML=Us),is=n(s),o(G.$$.fragment,s),os=n(s),E=i(s,"P",{"data-svelte-h":!0}),j(E)!=="svelte-xtxxu6"&&(E.innerHTML=$s),rs=n(s),o(Q.$$.fragment,s),cs=n(s),o(X.$$.fragment,s),Ms=n(s),o(A.$$.fragment,s),hs=n(s),V=i(s,"P",{}),Zs(V).forEach(l),this.h()},h(){ks(g,"name","hf:doc:metadata"),ks(g,"content",As)},m(s,t){Gs(document.head,g),e(s,_,t),e(s,v,t),e(s,R,t),r(d,s,t),e(s,z,t),r(y,s,t),e(s,H,t),e(s,u,t),e(s,F,t),r(w,s,t),e(s,L,t),e(s,J,t),e(s,P,t),r(f,s,t),e(s,q,t),e(s,T,t),e(s,D,t),r(b,s,t),e(s,K,t),e(s,U,t),e(s,O,t),r($,s,t),e(s,ss,t),e(s,Z,t),e(s,ts,t),r(k,s,t),e(s,ls,t),e(s,C,t),e(s,es,t),e(s,B,t),e(s,as,t),r(W,s,t),e(s,ns,t),e(s,N,t),e(s,ps,t),r(I,s,t),e(s,ms,t),e(s,x,t),e(s,is,t),r(G,s,t),e(s,os,t),e(s,E,t),e(s,rs,t),r(Q,s,t),e(s,cs,t),r(X,s,t),e(s,Ms,t),r(A,s,t),e(s,hs,t),e(s,V,t),js=!0},p:Bs,i(s){js||(c(d.$$.fragment,s),c(y.$$.fragment,s),c(w.$$.fragment,s),c(f.$$.fragment,s),c(b.$$.fragment,s),c($.$$.fragment,s),c(k.$$.fragment,s),c(W.$$.fragment,s),c(I.$$.fragment,s),c(G.$$.fragment,s),c(Q.$$.fragment,s),c(X.$$.fragment,s),c(A.$$.fragment,s),js=!0)},o(s){M(d.$$.fragment,s),M(y.$$.fragment,s),M(w.$$.fragment,s),M(f.$$.fragment,s),M(b.$$.fragment,s),M($.$$.fragment,s),M(k.$$.fragment,s),M(W.$$.fragment,s),M(I.$$.fragment,s),M(G.$$.fragment,s),M(Q.$$.fragment,s),M(X.$$.fragment,s),M(A.$$.fragment,s),js=!1},d(s){s&&(l(_),l(v),l(R),l(z),l(H),l(u),l(F),l(L),l(J),l(P),l(q),l(T),l(D),l(K),l(U),l(O),l(ss),l(Z),l(ts),l(ls),l(C),l(es),l(B),l(as),l(ns),l(N),l(ps),l(ms),l(x),l(is),l(os),l(E),l(rs),l(cs),l(Ms),l(hs),l(V)),l(g),h(d,s),h(y,s),h(w,s),h(f,s),h(b,s),h($,s),h(k,s),h(W,s),h(I,s),h(G,s),h(Q,s),h(X,s),h(A,s)}}}const As='{"title":"PNASNet","local":"pnasnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Ys(gs){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends Ns{constructor(g){super(),Is(this,g,Ys,Xs,Cs,{})}}export{Rs as component};
