import{s as Ns,n as Zs,o as Ws}from"../chunks/scheduler.0b596ca5.js";import{S as ks,i as Bs,e as p,s as e,c as m,h as Cs,a as i,d as l,b as n,f as $s,g as o,j as g,k as xs,l as Gs,m as a,n as r,t as M,o as c,p as h}from"../chunks/index.d9d53bd3.js";import{C as Es,H as S,E as Qs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as Y}from"../chunks/CodeBlock.9f18e41e.js";function vs(Js){let J,_,V,z,y,H,j,A,d,ys='<strong>Res2NeXt</strong> is an image model that employs a variation on <a href="https://paperswithcode.com/method/resnext" rel="nofollow">ResNeXt</a> bottleneck residual blocks. The motivation is to be able to represent features at multiple scales. This is achieved through a novel building block for CNNs that constructs hierarchical residual-like connections within one single residual block. This represents multi-scale features at a granular level and increases the range of receptive fields for each network layer.',F,u,L,T,js="To load a pretrained model:",D,w,P,b,ds="To load and preprocess the image:",q,f,K,U,us="To get the model predictions:",O,I,ss,$,Ts="To get the top-5 predictions class names:",ts,x,ls,N,ws="Replace the model name with the variant you want to use, e.g. <code>res2next50</code>. You can find the IDs in the model summaries at the top of this page.",as,Z,bs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',es,W,ns,k,fs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,B,ms,C,Us=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,is,G,os,E,Is='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rs,Q,Ms,v,cs,R,hs,X,gs;return y=new Es({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new S({props:{title:"Res2NeXt",local:"res2next",headingTag:"h1"}}),u=new S({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),w=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JlczJuZXh0NTAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;res2next50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new S({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzMm5leHQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;res2next50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new S({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new S({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new Y({props:{code:"JTQwYXJ0aWNsZSU3Qkdhb18yMDIxJTJDJTBBJTIwJTIwJTIwdGl0bGUlM0QlN0JSZXMyTmV0JTNBJTIwQSUyME5ldyUyME11bHRpLVNjYWxlJTIwQmFja2JvbmUlMjBBcmNoaXRlY3R1cmUlN0QlMkMlMEElMjAlMjAlMjB2b2x1bWUlM0QlN0I0MyU3RCUyQyUwQSUyMCUyMCUyMElTU04lM0QlN0IxOTM5LTM1MzklN0QlMkMlMEElMjAlMjAlMjB1cmwlM0QlN0JodHRwJTNBJTJGJTJGZHguZG9pLm9yZyUyRjEwLjExMDklMkZUUEFNSS4yMDE5LjI5Mzg3NTglN0QlMkMlMEElMjAlMjAlMjBET0klM0QlN0IxMC4xMTA5JTJGdHBhbWkuMjAxOS4yOTM4NzU4JTdEJTJDJTBBJTIwJTIwJTIwbnVtYmVyJTNEJTdCMiU3RCUyQyUwQSUyMCUyMCUyMGpvdXJuYWwlM0QlN0JJRUVFJTIwVHJhbnNhY3Rpb25zJTIwb24lMjBQYXR0ZXJuJTIwQW5hbHlzaXMlMjBhbmQlMjBNYWNoaW5lJTIwSW50ZWxsaWdlbmNlJTdEJTJDJTBBJTIwJTIwJTIwcHVibGlzaGVyJTNEJTdCSW5zdGl0dXRlJTIwb2YlMjBFbGVjdHJpY2FsJTIwYW5kJTIwRWxlY3Ryb25pY3MlMjBFbmdpbmVlcnMlMjAoSUVFRSklN0QlMkMlMEElMjAlMjAlMjBhdXRob3IlM0QlN0JHYW8lMkMlMjBTaGFuZy1IdWElMjBhbmQlMjBDaGVuZyUyQyUyME1pbmctTWluZyUyMGFuZCUyMFpoYW8lMkMlMjBLYWklMjBhbmQlMjBaaGFuZyUyQyUyMFhpbi1ZdSUyMGFuZCUyMFlhbmclMkMlMjBNaW5nLUhzdWFuJTIwYW5kJTIwVG9yciUyQyUyMFBoaWxpcCU3RCUyQyUwQSUyMCUyMCUyMHllYXIlM0QlN0IyMDIxJTdEJTJDJTBBJTIwJTIwJTIwbW9udGglM0QlN0JGZWIlN0QlMkMlMEElMjAlMjAlMjBwYWdlcyUzRCU3QjY1MiVFMiU4MCU5MzY2MiU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{Gao_2021,
   title={Res2Net: A New Multi-Scale Backbone Architecture}</span><span class="language-xml">,
   volume=</span><span class="hljs-template-variable">{43}</span><span class="language-xml">,
   ISSN=</span><span class="hljs-template-variable">{1939-3539}</span><span class="language-xml">,
   url=</span><span class="hljs-template-variable">{http://dx.doi.org/10.1109/TPAMI.2019.2938758}</span><span class="language-xml">,
   DOI=</span><span class="hljs-template-variable">{10.1109/tpami.2019.2938758}</span><span class="language-xml">,
   number=</span><span class="hljs-template-variable">{2}</span><span class="language-xml">,
   journal=</span><span class="hljs-template-variable">{IEEE Transactions on Pattern Analysis and Machine Intelligence}</span><span class="language-xml">,
   publisher=</span><span class="hljs-template-variable">{Institute of Electrical and Electronics Engineers (IEEE)}</span><span class="language-xml">,
   author=</span><span class="hljs-template-variable">{Gao, Shang-Hua and Cheng, Ming-Ming and Zhao, Kai and Zhang, Xin-Yu and Yang, Ming-Hsuan and Torr, Philip}</span><span class="language-xml">,
   year=</span><span class="hljs-template-variable">{2021}</span><span class="language-xml">,
   month=</span><span class="hljs-template-variable">{Feb}</span><span class="language-xml">,
   pages=</span><span class="hljs-template-variable">{652–662}</span><span class="language-xml">
}</span>`,wrap:!1}}),R=new Qs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/res2next.mdx"}}),{c(){J=p("meta"),_=e(),V=p("p"),z=e(),m(y.$$.fragment),H=e(),m(j.$$.fragment),A=e(),d=p("p"),d.innerHTML=ys,F=e(),m(u.$$.fragment),L=e(),T=p("p"),T.textContent=js,D=e(),m(w.$$.fragment),P=e(),b=p("p"),b.textContent=ds,q=e(),m(f.$$.fragment),K=e(),U=p("p"),U.textContent=us,O=e(),m(I.$$.fragment),ss=e(),$=p("p"),$.textContent=Ts,ts=e(),m(x.$$.fragment),ls=e(),N=p("p"),N.innerHTML=ws,as=e(),Z=p("p"),Z.innerHTML=bs,es=e(),m(W.$$.fragment),ns=e(),k=p("p"),k.textContent=fs,ps=e(),m(B.$$.fragment),ms=e(),C=p("p"),C.innerHTML=Us,is=e(),m(G.$$.fragment),os=e(),E=p("p"),E.innerHTML=Is,rs=e(),m(Q.$$.fragment),Ms=e(),m(v.$$.fragment),cs=e(),m(R.$$.fragment),hs=e(),X=p("p"),this.h()},l(s){const t=Cs("svelte-u9bgzb",document.head);J=i(t,"META",{name:!0,content:!0}),t.forEach(l),_=n(s),V=i(s,"P",{}),$s(V).forEach(l),z=n(s),o(y.$$.fragment,s),H=n(s),o(j.$$.fragment,s),A=n(s),d=i(s,"P",{"data-svelte-h":!0}),g(d)!=="svelte-ayu0xr"&&(d.innerHTML=ys),F=n(s),o(u.$$.fragment,s),L=n(s),T=i(s,"P",{"data-svelte-h":!0}),g(T)!=="svelte-18ywhxh"&&(T.textContent=js),D=n(s),o(w.$$.fragment,s),P=n(s),b=i(s,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1c2ipa8"&&(b.textContent=ds),q=n(s),o(f.$$.fragment,s),K=n(s),U=i(s,"P",{"data-svelte-h":!0}),g(U)!=="svelte-1n9qsq1"&&(U.textContent=us),O=n(s),o(I.$$.fragment,s),ss=n(s),$=i(s,"P",{"data-svelte-h":!0}),g($)!=="svelte-19cnvx1"&&($.textContent=Ts),ts=n(s),o(x.$$.fragment,s),ls=n(s),N=i(s,"P",{"data-svelte-h":!0}),g(N)!=="svelte-199rhg"&&(N.innerHTML=ws),as=n(s),Z=i(s,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=bs),es=n(s),o(W.$$.fragment,s),ns=n(s),k=i(s,"P",{"data-svelte-h":!0}),g(k)!=="svelte-9sr7nh"&&(k.textContent=fs),ps=n(s),o(B.$$.fragment,s),ms=n(s),C=i(s,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1kguc51"&&(C.innerHTML=Us),is=n(s),o(G.$$.fragment,s),os=n(s),E=i(s,"P",{"data-svelte-h":!0}),g(E)!=="svelte-xtxxu6"&&(E.innerHTML=Is),rs=n(s),o(Q.$$.fragment,s),Ms=n(s),o(v.$$.fragment,s),cs=n(s),o(R.$$.fragment,s),hs=n(s),X=i(s,"P",{}),$s(X).forEach(l),this.h()},h(){xs(J,"name","hf:doc:metadata"),xs(J,"content",Rs)},m(s,t){Gs(document.head,J),a(s,_,t),a(s,V,t),a(s,z,t),r(y,s,t),a(s,H,t),r(j,s,t),a(s,A,t),a(s,d,t),a(s,F,t),r(u,s,t),a(s,L,t),a(s,T,t),a(s,D,t),r(w,s,t),a(s,P,t),a(s,b,t),a(s,q,t),r(f,s,t),a(s,K,t),a(s,U,t),a(s,O,t),r(I,s,t),a(s,ss,t),a(s,$,t),a(s,ts,t),r(x,s,t),a(s,ls,t),a(s,N,t),a(s,as,t),a(s,Z,t),a(s,es,t),r(W,s,t),a(s,ns,t),a(s,k,t),a(s,ps,t),r(B,s,t),a(s,ms,t),a(s,C,t),a(s,is,t),r(G,s,t),a(s,os,t),a(s,E,t),a(s,rs,t),r(Q,s,t),a(s,Ms,t),r(v,s,t),a(s,cs,t),r(R,s,t),a(s,hs,t),a(s,X,t),gs=!0},p:Zs,i(s){gs||(M(y.$$.fragment,s),M(j.$$.fragment,s),M(u.$$.fragment,s),M(w.$$.fragment,s),M(f.$$.fragment,s),M(I.$$.fragment,s),M(x.$$.fragment,s),M(W.$$.fragment,s),M(B.$$.fragment,s),M(G.$$.fragment,s),M(Q.$$.fragment,s),M(v.$$.fragment,s),M(R.$$.fragment,s),gs=!0)},o(s){c(y.$$.fragment,s),c(j.$$.fragment,s),c(u.$$.fragment,s),c(w.$$.fragment,s),c(f.$$.fragment,s),c(I.$$.fragment,s),c(x.$$.fragment,s),c(W.$$.fragment,s),c(B.$$.fragment,s),c(G.$$.fragment,s),c(Q.$$.fragment,s),c(v.$$.fragment,s),c(R.$$.fragment,s),gs=!1},d(s){s&&(l(_),l(V),l(z),l(H),l(A),l(d),l(F),l(L),l(T),l(D),l(P),l(b),l(q),l(K),l(U),l(O),l(ss),l($),l(ts),l(ls),l(N),l(as),l(Z),l(es),l(ns),l(k),l(ps),l(ms),l(C),l(is),l(os),l(E),l(rs),l(Ms),l(cs),l(hs),l(X)),l(J),h(y,s),h(j,s),h(u,s),h(w,s),h(f,s),h(I,s),h(x,s),h(W,s),h(B,s),h(G,s),h(Q,s),h(v,s),h(R,s)}}}const Rs='{"title":"Res2NeXt","local":"res2next","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Ys(Js){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends ks{constructor(J){super(),Bs(this,J,Ys,vs,Ns,{})}}export{zs as component};
