import{s as Zs,n as Ws,o as ks}from"../chunks/scheduler.0b596ca5.js";import{S as xs,i as Bs,e as p,s as a,c as m,h as Gs,a as i,d as l,b as n,f as $s,g as o,j as h,k as Cs,l as Ns,m as e,n as r,t as M,o as c,p as J}from"../chunks/index.d9d53bd3.js";import{C as Rs,H as v,E as Es}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as V}from"../chunks/CodeBlock.9f18e41e.js";function Qs(ws){let w,z,S,H,y,_,T,X,g,ys='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',F,j,D,d,Ts="To load a pretrained model:",L,u,q,b,gs="To load and preprocess the image:",K,f,P,U,js="To get the model predictions:",O,I,ss,$,ds="To get the top-5 predictions class names:",ts,C,ls,Z,us="Replace the model name with the variant you want to use, e.g. <code>resnet18</code>. You can find the IDs in the model summaries at the top of this page.",es,W,bs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,k,ns,x,fs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,B,ms,G,Us=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,is,N,os,R,Is='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rs,E,Ms,Q,cs,A,Js,Y,hs;return y=new Rs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new v({props:{title:"ResNet",local:"resnet",headingTag:"h1"}}),j=new v({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new v({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV0MTgnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new v({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new v({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new V({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZIZVpSUzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCS2FpbWluZyUyMEhlJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWGlhbmd5dSUyMFpoYW5nJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU2hhb3FpbmclMjBSZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBKaWFuJTIwU3VuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JEZWVwJTIwUmVzaWR1YWwlMjBMZWFybmluZyUyMGZvciUyMEltYWdlJTIwUmVjb2duaXRpb24lN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE1MTIuMDMzODUlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNSU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNTEyLjAzMzg1JTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTUxMi4wMzM4NSU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3QldlZCUyQyUyMDE3JTIwQXByJTIwMjAxOSUyMDE3JTNBMjMlM0E0NSUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGSGVaUlMxNS5iaWIlN0QlMkMlMEElMjAlMjBiaWJzb3VyY2UlMjAlM0QlMjAlN0JkYmxwJTIwY29tcHV0ZXIlMjBzY2llbmNlJTIwYmlibGlvZ3JhcGh5JTJDJTIwaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyU3RCUwQSU3RA==",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>HeZRS15,
  author    = {Kaiming He and
               Xiangyu Zhang and
               Shaoqing Ren and
               Jian Sun},
  title     = {Deep Residual Learning <span class="hljs-keyword">for</span> Image Recognition},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.03385</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.03385</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.03385</span>},
  timestamp = {Wed, <span class="hljs-number">17</span> Apr <span class="hljs-number">2019</span> <span class="hljs-number">17</span>:<span class="hljs-number">23</span>:<span class="hljs-number">45</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>HeZRS15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),A=new Es({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/resnet.mdx"}}),{c(){w=p("meta"),z=a(),S=p("p"),H=a(),m(y.$$.fragment),_=a(),m(T.$$.fragment),X=a(),g=p("p"),g.innerHTML=ys,F=a(),m(j.$$.fragment),D=a(),d=p("p"),d.textContent=Ts,L=a(),m(u.$$.fragment),q=a(),b=p("p"),b.textContent=gs,K=a(),m(f.$$.fragment),P=a(),U=p("p"),U.textContent=js,O=a(),m(I.$$.fragment),ss=a(),$=p("p"),$.textContent=ds,ts=a(),m(C.$$.fragment),ls=a(),Z=p("p"),Z.innerHTML=us,es=a(),W=p("p"),W.innerHTML=bs,as=a(),m(k.$$.fragment),ns=a(),x=p("p"),x.textContent=fs,ps=a(),m(B.$$.fragment),ms=a(),G=p("p"),G.innerHTML=Us,is=a(),m(N.$$.fragment),os=a(),R=p("p"),R.innerHTML=Is,rs=a(),m(E.$$.fragment),Ms=a(),m(Q.$$.fragment),cs=a(),m(A.$$.fragment),Js=a(),Y=p("p"),this.h()},l(s){const t=Gs("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(l),z=n(s),S=i(s,"P",{}),$s(S).forEach(l),H=n(s),o(y.$$.fragment,s),_=n(s),o(T.$$.fragment,s),X=n(s),g=i(s,"P",{"data-svelte-h":!0}),h(g)!=="svelte-p6ybkz"&&(g.innerHTML=ys),F=n(s),o(j.$$.fragment,s),D=n(s),d=i(s,"P",{"data-svelte-h":!0}),h(d)!=="svelte-18ywhxh"&&(d.textContent=Ts),L=n(s),o(u.$$.fragment,s),q=n(s),b=i(s,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1c2ipa8"&&(b.textContent=gs),K=n(s),o(f.$$.fragment,s),P=n(s),U=i(s,"P",{"data-svelte-h":!0}),h(U)!=="svelte-1n9qsq1"&&(U.textContent=js),O=n(s),o(I.$$.fragment,s),ss=n(s),$=i(s,"P",{"data-svelte-h":!0}),h($)!=="svelte-19cnvx1"&&($.textContent=ds),ts=n(s),o(C.$$.fragment,s),ls=n(s),Z=i(s,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-f9b41k"&&(Z.innerHTML=us),es=n(s),W=i(s,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1wmi3ea"&&(W.innerHTML=bs),as=n(s),o(k.$$.fragment,s),ns=n(s),x=i(s,"P",{"data-svelte-h":!0}),h(x)!=="svelte-9sr7nh"&&(x.textContent=fs),ps=n(s),o(B.$$.fragment,s),ms=n(s),G=i(s,"P",{"data-svelte-h":!0}),h(G)!=="svelte-1kguc51"&&(G.innerHTML=Us),is=n(s),o(N.$$.fragment,s),os=n(s),R=i(s,"P",{"data-svelte-h":!0}),h(R)!=="svelte-xtxxu6"&&(R.innerHTML=Is),rs=n(s),o(E.$$.fragment,s),Ms=n(s),o(Q.$$.fragment,s),cs=n(s),o(A.$$.fragment,s),Js=n(s),Y=i(s,"P",{}),$s(Y).forEach(l),this.h()},h(){Cs(w,"name","hf:doc:metadata"),Cs(w,"content",As)},m(s,t){Ns(document.head,w),e(s,z,t),e(s,S,t),e(s,H,t),r(y,s,t),e(s,_,t),r(T,s,t),e(s,X,t),e(s,g,t),e(s,F,t),r(j,s,t),e(s,D,t),e(s,d,t),e(s,L,t),r(u,s,t),e(s,q,t),e(s,b,t),e(s,K,t),r(f,s,t),e(s,P,t),e(s,U,t),e(s,O,t),r(I,s,t),e(s,ss,t),e(s,$,t),e(s,ts,t),r(C,s,t),e(s,ls,t),e(s,Z,t),e(s,es,t),e(s,W,t),e(s,as,t),r(k,s,t),e(s,ns,t),e(s,x,t),e(s,ps,t),r(B,s,t),e(s,ms,t),e(s,G,t),e(s,is,t),r(N,s,t),e(s,os,t),e(s,R,t),e(s,rs,t),r(E,s,t),e(s,Ms,t),r(Q,s,t),e(s,cs,t),r(A,s,t),e(s,Js,t),e(s,Y,t),hs=!0},p:Ws,i(s){hs||(M(y.$$.fragment,s),M(T.$$.fragment,s),M(j.$$.fragment,s),M(u.$$.fragment,s),M(f.$$.fragment,s),M(I.$$.fragment,s),M(C.$$.fragment,s),M(k.$$.fragment,s),M(B.$$.fragment,s),M(N.$$.fragment,s),M(E.$$.fragment,s),M(Q.$$.fragment,s),M(A.$$.fragment,s),hs=!0)},o(s){c(y.$$.fragment,s),c(T.$$.fragment,s),c(j.$$.fragment,s),c(u.$$.fragment,s),c(f.$$.fragment,s),c(I.$$.fragment,s),c(C.$$.fragment,s),c(k.$$.fragment,s),c(B.$$.fragment,s),c(N.$$.fragment,s),c(E.$$.fragment,s),c(Q.$$.fragment,s),c(A.$$.fragment,s),hs=!1},d(s){s&&(l(z),l(S),l(H),l(_),l(X),l(g),l(F),l(D),l(d),l(L),l(q),l(b),l(K),l(P),l(U),l(O),l(ss),l($),l(ts),l(ls),l(Z),l(es),l(W),l(as),l(ns),l(x),l(ps),l(ms),l(G),l(is),l(os),l(R),l(rs),l(Ms),l(cs),l(Js),l(Y)),l(w),J(y,s),J(T,s),J(j,s),J(u,s),J(f,s),J(I,s),J(C,s),J(k,s),J(B,s),J(N,s),J(E,s),J(Q,s),J(A,s)}}}const As='{"title":"ResNet","local":"resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Vs(ws){return ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends xs{constructor(w){super(),Bs(this,w,Vs,Qs,Zs,{})}}export{Hs as component};
