import{s as Ct,n as Wt,o as kt}from"../chunks/scheduler.0b596ca5.js";import{S as Nt,i as xt,e as p,s as l,c as i,h as Bt,a as m,d as e,b as n,f as It,g as o,j as g,k as Zt,l as Gt,m as a,n as r,t as h,o as c,p as M}from"../chunks/index.d9d53bd3.js";import{C as vt,H as X,E as Et}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as R}from"../chunks/CodeBlock.9f18e41e.js";function Qt(dt){let d,z,V,S,y,H,J,F,w,yt='<strong>ResNet-D</strong> is a modification on the <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> architecture that utilises an <a href="https://paperswithcode.com/method/average-pooling" rel="nofollow">average pooling</a> tweak for downsampling. The motivation is that in the unmodified ResNet, the <a href="https://paperswithcode.com/method/1x1-convolution" rel="nofollow">1×1 convolution</a> for the downsampling block ignores 3/4 of input feature maps, so this is modified so no information will be ignored',A,j,L,u,Jt="To load a pretrained model:",D,T,q,f,wt="To load and preprocess the image:",P,b,K,U,jt="To get the model predictions:",O,$,tt,I,ut="To get the top-5 predictions class names:",st,Z,et,C,Tt="Replace the model name with the variant you want to use, e.g. <code>resnet101d</code>. You can find the IDs in the model summaries at the top of this page.",at,W,ft='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,k,nt,N,bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,x,it,B,Ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,G,ot,v,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,E,ht,Q,ct,Y,Mt,_,gt;return y=new vt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new X({props:{title:"ResNet-D",local:"resnet-d",headingTag:"h1"}}),j=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDEwMWQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),x=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV0MTAxZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new R({props:{code:"JTQwbWlzYyU3QmhlMjAxOGJhZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCQmFnJTIwb2YlMjBUcmlja3MlMjBmb3IlMjBJbWFnZSUyMENsYXNzaWZpY2F0aW9uJTIwd2l0aCUyMENvbnZvbHV0aW9uYWwlMjBOZXVyYWwlMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QlRvbmclMjBIZSUyMGFuZCUyMFpoaSUyMFpoYW5nJTIwYW5kJTIwSGFuZyUyMFpoYW5nJTIwYW5kJTIwWmhvbmd5dWUlMjBaaGFuZyUyMGFuZCUyMEp1bnl1YW4lMjBYaWUlMjBhbmQlMjBNdSUyMExpJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTglN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxODEyLjAxMTg3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{he<span class="hljs-symbol">2018b</span>ag,
      title={<span class="hljs-keyword">Bag </span>of Tricks for Image Classification with Convolutional Neural Networks}, 
      author={Tong He <span class="hljs-keyword">and </span>Zhi Zhang <span class="hljs-keyword">and </span>Hang Zhang <span class="hljs-keyword">and </span>Zhongyue Zhang <span class="hljs-keyword">and </span><span class="hljs-keyword">Junyuan </span>Xie <span class="hljs-keyword">and </span>Mu Li},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1812</span>.<span class="hljs-number">01187</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Y=new Et({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/resnet-d.mdx"}}),{c(){d=p("meta"),z=l(),V=p("p"),S=l(),i(y.$$.fragment),H=l(),i(J.$$.fragment),F=l(),w=p("p"),w.innerHTML=yt,A=l(),i(j.$$.fragment),L=l(),u=p("p"),u.textContent=Jt,D=l(),i(T.$$.fragment),q=l(),f=p("p"),f.textContent=wt,P=l(),i(b.$$.fragment),K=l(),U=p("p"),U.textContent=jt,O=l(),i($.$$.fragment),tt=l(),I=p("p"),I.textContent=ut,st=l(),i(Z.$$.fragment),et=l(),C=p("p"),C.innerHTML=Tt,at=l(),W=p("p"),W.innerHTML=ft,lt=l(),i(k.$$.fragment),nt=l(),N=p("p"),N.textContent=bt,pt=l(),i(x.$$.fragment),it=l(),B=p("p"),B.innerHTML=Ut,mt=l(),i(G.$$.fragment),ot=l(),v=p("p"),v.innerHTML=$t,rt=l(),i(E.$$.fragment),ht=l(),i(Q.$$.fragment),ct=l(),i(Y.$$.fragment),Mt=l(),_=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);d=m(s,"META",{name:!0,content:!0}),s.forEach(e),z=n(t),V=m(t,"P",{}),It(V).forEach(e),S=n(t),o(y.$$.fragment,t),H=n(t),o(J.$$.fragment,t),F=n(t),w=m(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-8lziuy"&&(w.innerHTML=yt),A=n(t),o(j.$$.fragment,t),L=n(t),u=m(t,"P",{"data-svelte-h":!0}),g(u)!=="svelte-18ywhxh"&&(u.textContent=Jt),D=n(t),o(T.$$.fragment,t),q=n(t),f=m(t,"P",{"data-svelte-h":!0}),g(f)!=="svelte-1c2ipa8"&&(f.textContent=wt),P=n(t),o(b.$$.fragment,t),K=n(t),U=m(t,"P",{"data-svelte-h":!0}),g(U)!=="svelte-1n9qsq1"&&(U.textContent=jt),O=n(t),o($.$$.fragment,t),tt=n(t),I=m(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=ut),st=n(t),o(Z.$$.fragment,t),et=n(t),C=m(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1iogwu7"&&(C.innerHTML=Tt),at=n(t),W=m(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-1wmi3ea"&&(W.innerHTML=ft),lt=n(t),o(k.$$.fragment,t),nt=n(t),N=m(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-9sr7nh"&&(N.textContent=bt),pt=n(t),o(x.$$.fragment,t),it=n(t),B=m(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1kguc51"&&(B.innerHTML=Ut),mt=n(t),o(G.$$.fragment,t),ot=n(t),v=m(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-xtxxu6"&&(v.innerHTML=$t),rt=n(t),o(E.$$.fragment,t),ht=n(t),o(Q.$$.fragment,t),ct=n(t),o(Y.$$.fragment,t),Mt=n(t),_=m(t,"P",{}),It(_).forEach(e),this.h()},h(){Zt(d,"name","hf:doc:metadata"),Zt(d,"content",Yt)},m(t,s){Gt(document.head,d),a(t,z,s),a(t,V,s),a(t,S,s),r(y,t,s),a(t,H,s),r(J,t,s),a(t,F,s),a(t,w,s),a(t,A,s),r(j,t,s),a(t,L,s),a(t,u,s),a(t,D,s),r(T,t,s),a(t,q,s),a(t,f,s),a(t,P,s),r(b,t,s),a(t,K,s),a(t,U,s),a(t,O,s),r($,t,s),a(t,tt,s),a(t,I,s),a(t,st,s),r(Z,t,s),a(t,et,s),a(t,C,s),a(t,at,s),a(t,W,s),a(t,lt,s),r(k,t,s),a(t,nt,s),a(t,N,s),a(t,pt,s),r(x,t,s),a(t,it,s),a(t,B,s),a(t,mt,s),r(G,t,s),a(t,ot,s),a(t,v,s),a(t,rt,s),r(E,t,s),a(t,ht,s),r(Q,t,s),a(t,ct,s),r(Y,t,s),a(t,Mt,s),a(t,_,s),gt=!0},p:Wt,i(t){gt||(h(y.$$.fragment,t),h(J.$$.fragment,t),h(j.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(Z.$$.fragment,t),h(k.$$.fragment,t),h(x.$$.fragment,t),h(G.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),h(Y.$$.fragment,t),gt=!0)},o(t){c(y.$$.fragment,t),c(J.$$.fragment,t),c(j.$$.fragment,t),c(T.$$.fragment,t),c(b.$$.fragment,t),c($.$$.fragment,t),c(Z.$$.fragment,t),c(k.$$.fragment,t),c(x.$$.fragment,t),c(G.$$.fragment,t),c(E.$$.fragment,t),c(Q.$$.fragment,t),c(Y.$$.fragment,t),gt=!1},d(t){t&&(e(z),e(V),e(S),e(H),e(F),e(w),e(A),e(L),e(u),e(D),e(q),e(f),e(P),e(K),e(U),e(O),e(tt),e(I),e(st),e(et),e(C),e(at),e(W),e(lt),e(nt),e(N),e(pt),e(it),e(B),e(mt),e(ot),e(v),e(rt),e(ht),e(ct),e(Mt),e(_)),e(d),M(y,t),M(J,t),M(j,t),M(T,t),M(b,t),M($,t),M(Z,t),M(k,t),M(x,t),M(G,t),M(E,t),M(Q,t),M(Y,t)}}}const Yt='{"title":"ResNet-D","local":"resnet-d","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Rt(dt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends Nt{constructor(d){super(),xt(this,d,Rt,Qt,Ct,{})}}export{St as component};
