import{s as Ct,n as It,o as Wt}from"../chunks/scheduler.0b596ca5.js";import{S as kt,i as Bt,e as p,s as a,c as m,h as Nt,a as i,d as l,b as n,f as Zt,g as o,j as g,k as xt,l as Gt,m as e,n as r,t as c,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as vt,H as _,E as Et}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as Q}from"../chunks/CodeBlock.9f18e41e.js";function Xt(jt){let j,A,V,z,d,H,J,S,y,dt='<strong>Rank Expansion Networks</strong> (ReXNets) follow a set of new design principles for designing bottlenecks in image classification models. Authors refine each layer by 1) expanding the input channel size of the convolution layer and 2) replacing the <a href="https://www.paperswithcode.com/method/relu6" rel="nofollow">ReLU6s</a>.',F,w,L,u,Jt="To load a pretrained model:",D,f,q,b,yt="To load and preprocess the image:",P,T,K,U,wt="To get the model predictions:",O,$,tt,Z,ut="To get the top-5 predictions class names:",st,x,lt,C,ft="Replace the model name with the variant you want to use, e.g. <code>rexnet_100</code>. You can find the IDs in the model summaries at the top of this page.",et,I,bt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,W,nt,k,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,B,mt,N,Ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,G,ot,v,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,E,ct,X,ht,R,Mt,Y,gt;return d=new vt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new _({props:{title:"RexNet",local:"rexnet",headingTag:"h1"}}),w=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JleG5ldF8xMDAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;rexnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),T=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmV4bmV0XzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;rexnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),X=new Q({props:{code:"JTQwbWlzYyU3QmhhbjIwMjByZXhuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlJlWE5ldCUzQSUyMERpbWluaXNoaW5nJTIwUmVwcmVzZW50YXRpb25hbCUyMEJvdHRsZW5lY2slMjBvbiUyMENvbnZvbHV0aW9uYWwlMjBOZXVyYWwlMjBOZXR3b3JrJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRG9uZ3lvb24lMjBIYW4lMjBhbmQlMjBTYW5nZG9vJTIwWXVuJTIwYW5kJTIwQnllb25naG8lMjBIZW8lMjBhbmQlMjBZb3VuZ0pvb24lMjBZb28lN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjIwMDcuMDA5OTIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{han2020rexnet,
      title={ReXNet: Diminishing Representational Bottleneck on Convolutional Neural Network}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Dongyoon Han and Sangdoo Yun and Byeongho Heo and YoungJoon Yoo}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2007.00992}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),R=new Et({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/rexnet.mdx"}}),{c(){j=p("meta"),A=a(),V=p("p"),z=a(),m(d.$$.fragment),H=a(),m(J.$$.fragment),S=a(),y=p("p"),y.innerHTML=dt,F=a(),m(w.$$.fragment),L=a(),u=p("p"),u.textContent=Jt,D=a(),m(f.$$.fragment),q=a(),b=p("p"),b.textContent=yt,P=a(),m(T.$$.fragment),K=a(),U=p("p"),U.textContent=wt,O=a(),m($.$$.fragment),tt=a(),Z=p("p"),Z.textContent=ut,st=a(),m(x.$$.fragment),lt=a(),C=p("p"),C.innerHTML=ft,et=a(),I=p("p"),I.innerHTML=bt,at=a(),m(W.$$.fragment),nt=a(),k=p("p"),k.textContent=Tt,pt=a(),m(B.$$.fragment),mt=a(),N=p("p"),N.innerHTML=Ut,it=a(),m(G.$$.fragment),ot=a(),v=p("p"),v.innerHTML=$t,rt=a(),m(E.$$.fragment),ct=a(),m(X.$$.fragment),ht=a(),m(R.$$.fragment),Mt=a(),Y=p("p"),this.h()},l(t){const s=Nt("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(l),A=n(t),V=i(t,"P",{}),Zt(V).forEach(l),z=n(t),o(d.$$.fragment,t),H=n(t),o(J.$$.fragment,t),S=n(t),y=i(t,"P",{"data-svelte-h":!0}),g(y)!=="svelte-1inhb52"&&(y.innerHTML=dt),F=n(t),o(w.$$.fragment,t),L=n(t),u=i(t,"P",{"data-svelte-h":!0}),g(u)!=="svelte-18ywhxh"&&(u.textContent=Jt),D=n(t),o(f.$$.fragment,t),q=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1c2ipa8"&&(b.textContent=yt),P=n(t),o(T.$$.fragment,t),K=n(t),U=i(t,"P",{"data-svelte-h":!0}),g(U)!=="svelte-1n9qsq1"&&(U.textContent=wt),O=n(t),o($.$$.fragment,t),tt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-19cnvx1"&&(Z.textContent=ut),st=n(t),o(x.$$.fragment,t),lt=n(t),C=i(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-kmyudm"&&(C.innerHTML=ft),et=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-1wmi3ea"&&(I.innerHTML=bt),at=n(t),o(W.$$.fragment,t),nt=n(t),k=i(t,"P",{"data-svelte-h":!0}),g(k)!=="svelte-9sr7nh"&&(k.textContent=Tt),pt=n(t),o(B.$$.fragment,t),mt=n(t),N=i(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1kguc51"&&(N.innerHTML=Ut),it=n(t),o(G.$$.fragment,t),ot=n(t),v=i(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-xtxxu6"&&(v.innerHTML=$t),rt=n(t),o(E.$$.fragment,t),ct=n(t),o(X.$$.fragment,t),ht=n(t),o(R.$$.fragment,t),Mt=n(t),Y=i(t,"P",{}),Zt(Y).forEach(l),this.h()},h(){xt(j,"name","hf:doc:metadata"),xt(j,"content",Rt)},m(t,s){Gt(document.head,j),e(t,A,s),e(t,V,s),e(t,z,s),r(d,t,s),e(t,H,s),r(J,t,s),e(t,S,s),e(t,y,s),e(t,F,s),r(w,t,s),e(t,L,s),e(t,u,s),e(t,D,s),r(f,t,s),e(t,q,s),e(t,b,s),e(t,P,s),r(T,t,s),e(t,K,s),e(t,U,s),e(t,O,s),r($,t,s),e(t,tt,s),e(t,Z,s),e(t,st,s),r(x,t,s),e(t,lt,s),e(t,C,s),e(t,et,s),e(t,I,s),e(t,at,s),r(W,t,s),e(t,nt,s),e(t,k,s),e(t,pt,s),r(B,t,s),e(t,mt,s),e(t,N,s),e(t,it,s),r(G,t,s),e(t,ot,s),e(t,v,s),e(t,rt,s),r(E,t,s),e(t,ct,s),r(X,t,s),e(t,ht,s),r(R,t,s),e(t,Mt,s),e(t,Y,s),gt=!0},p:It,i(t){gt||(c(d.$$.fragment,t),c(J.$$.fragment,t),c(w.$$.fragment,t),c(f.$$.fragment,t),c(T.$$.fragment,t),c($.$$.fragment,t),c(x.$$.fragment,t),c(W.$$.fragment,t),c(B.$$.fragment,t),c(G.$$.fragment,t),c(E.$$.fragment,t),c(X.$$.fragment,t),c(R.$$.fragment,t),gt=!0)},o(t){h(d.$$.fragment,t),h(J.$$.fragment,t),h(w.$$.fragment,t),h(f.$$.fragment,t),h(T.$$.fragment,t),h($.$$.fragment,t),h(x.$$.fragment,t),h(W.$$.fragment,t),h(B.$$.fragment,t),h(G.$$.fragment,t),h(E.$$.fragment,t),h(X.$$.fragment,t),h(R.$$.fragment,t),gt=!1},d(t){t&&(l(A),l(V),l(z),l(H),l(S),l(y),l(F),l(L),l(u),l(D),l(q),l(b),l(P),l(K),l(U),l(O),l(tt),l(Z),l(st),l(lt),l(C),l(et),l(I),l(at),l(nt),l(k),l(pt),l(mt),l(N),l(it),l(ot),l(v),l(rt),l(ct),l(ht),l(Mt),l(Y)),l(j),M(d,t),M(J,t),M(w,t),M(f,t),M(T,t),M($,t),M(x,t),M(W,t),M(B,t),M(G,t),M(E,t),M(X,t),M(R,t)}}}const Rt='{"title":"RexNet","local":"rexnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qt(jt){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends kt{constructor(j){super(),Bt(this,j,Qt,Xt,Ct,{})}}export{zt as component};
