import{s as Cs,n as ks,o as xs}from"../chunks/scheduler.0b596ca5.js";import{S as Zs,i as Ns,e as p,s as e,c as m,h as Gs,a as i,d as l,b as n,f as $s,g as o,j as J,k as Ws,l as Bs,m as a,n as c,t as r,o as M,p as h}from"../chunks/index.d9d53bd3.js";import{C as Es,H as z,E as Qs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as S}from"../chunks/CodeBlock.9f18e41e.js";function Rs(gs){let g,_,V,X,T,H,y,F,d,Ts="<strong>SelecSLS</strong> uses novel selective long and short range skip connections to improve the information flow allowing for a drastically faster network without compromising accuracy.",A,j,D,w,ys="To load a pretrained model:",L,u,P,b,ds="To load and preprocess the image:",q,f,K,U,js="To get the model predictions:",O,I,ss,$,ws="To get the top-5 predictions class names:",ts,W,ls,C,us="Replace the model name with the variant you want to use, e.g. <code>selecsls42b</code>. You can find the IDs in the model summaries at the top of this page.",as,k,bs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',es,x,ns,Z,fs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,N,ms,G,Us=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,is,B,os,E,Is='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',cs,Q,rs,R,Ms,v,hs,Y,Js;return T=new Es({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new z({props:{title:"SelecSLS",local:"selecsls",headingTag:"h1"}}),j=new z({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new S({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NlbGVjc2xzNDJiJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;selecsls42b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new S({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),W=new S({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),x=new z({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new S({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2VsZWNzbHM0MmInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;selecsls42b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new z({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new z({props:{title:"Citation",local:"citation",headingTag:"h2"}}),R=new S({props:{code:"JTQwYXJ0aWNsZSU3Qk1laHRhXzIwMjAlMkMlMEElMjAlMjAlMjB0aXRsZSUzRCU3QlhOZWN0JTdEJTJDJTBBJTIwJTIwJTIwdm9sdW1lJTNEJTdCMzklN0QlMkMlMEElMjAlMjAlMjBJU1NOJTNEJTdCMTU1Ny03MzY4JTdEJTJDJTBBJTIwJTIwJTIwdXJsJTNEJTdCaHR0cCUzQSUyRiUyRmR4LmRvaS5vcmclMkYxMC4xMTQ1JTJGMzM4NjU2OS4zMzkyNDEwJTdEJTJDJTBBJTIwJTIwJTIwRE9JJTNEJTdCMTAuMTE0NSUyRjMzODY1NjkuMzM5MjQxMCU3RCUyQyUwQSUyMCUyMCUyMG51bWJlciUzRCU3QjQlN0QlMkMlMEElMjAlMjAlMjBqb3VybmFsJTNEJTdCQUNNJTIwVHJhbnNhY3Rpb25zJTIwb24lMjBHcmFwaGljcyU3RCUyQyUwQSUyMCUyMCUyMHB1Ymxpc2hlciUzRCU3QkFzc29jaWF0aW9uJTIwZm9yJTIwQ29tcHV0aW5nJTIwTWFjaGluZXJ5JTIwKEFDTSklN0QlMkMlMEElMjAlMjAlMjBhdXRob3IlM0QlN0JNZWh0YSUyQyUyMER1c2h5YW50JTIwYW5kJTIwU290bnljaGVua28lMkMlMjBPbGVrc2FuZHIlMjBhbmQlMjBNdWVsbGVyJTJDJTIwRnJhbnppc2thJTIwYW5kJTIwWHUlMkMlMjBXZWlwZW5nJTIwYW5kJTIwRWxnaGFyaWIlMkMlMjBNb2hhbWVkJTIwYW5kJTIwRnVhJTJDJTIwUGFzY2FsJTIwYW5kJTIwU2VpZGVsJTJDJTIwSGFucy1QZXRlciUyMGFuZCUyMFJob2RpbiUyQyUyMEhlbGdlJTIwYW5kJTIwUG9ucy1Nb2xsJTJDJTIwR2VyYXJkJTIwYW5kJTIwVGhlb2JhbHQlMkMlMjBDaHJpc3RpYW4lN0QlMkMlMEElMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMG1vbnRoJTNEJTdCSnVsJTdEJTBBJTdE",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{Mehta_2020,
   title={XNect}</span><span class="language-xml">,
   volume=</span><span class="hljs-template-variable">{39}</span><span class="language-xml">,
   ISSN=</span><span class="hljs-template-variable">{1557-7368}</span><span class="language-xml">,
   url=</span><span class="hljs-template-variable">{http://dx.doi.org/10.1145/3386569.3392410}</span><span class="language-xml">,
   DOI=</span><span class="hljs-template-variable">{10.1145/3386569.3392410}</span><span class="language-xml">,
   number=</span><span class="hljs-template-variable">{4}</span><span class="language-xml">,
   journal=</span><span class="hljs-template-variable">{ACM Transactions on Graphics}</span><span class="language-xml">,
   publisher=</span><span class="hljs-template-variable">{Association for Computing Machinery (ACM)}</span><span class="language-xml">,
   author=</span><span class="hljs-template-variable">{Mehta, Dushyant and Sotnychenko, Oleksandr and Mueller, Franziska and Xu, Weipeng and Elgharib, Mohamed and Fua, Pascal and Seidel, Hans-Peter and Rhodin, Helge and Pons-Moll, Gerard and Theobalt, Christian}</span><span class="language-xml">,
   year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
   month=</span><span class="hljs-template-variable">{Jul}</span><span class="language-xml">
}</span>`,wrap:!1}}),v=new Qs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/selecsls.mdx"}}),{c(){g=p("meta"),_=e(),V=p("p"),X=e(),m(T.$$.fragment),H=e(),m(y.$$.fragment),F=e(),d=p("p"),d.innerHTML=Ts,A=e(),m(j.$$.fragment),D=e(),w=p("p"),w.textContent=ys,L=e(),m(u.$$.fragment),P=e(),b=p("p"),b.textContent=ds,q=e(),m(f.$$.fragment),K=e(),U=p("p"),U.textContent=js,O=e(),m(I.$$.fragment),ss=e(),$=p("p"),$.textContent=ws,ts=e(),m(W.$$.fragment),ls=e(),C=p("p"),C.innerHTML=us,as=e(),k=p("p"),k.innerHTML=bs,es=e(),m(x.$$.fragment),ns=e(),Z=p("p"),Z.textContent=fs,ps=e(),m(N.$$.fragment),ms=e(),G=p("p"),G.innerHTML=Us,is=e(),m(B.$$.fragment),os=e(),E=p("p"),E.innerHTML=Is,cs=e(),m(Q.$$.fragment),rs=e(),m(R.$$.fragment),Ms=e(),m(v.$$.fragment),hs=e(),Y=p("p"),this.h()},l(s){const t=Gs("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(l),_=n(s),V=i(s,"P",{}),$s(V).forEach(l),X=n(s),o(T.$$.fragment,s),H=n(s),o(y.$$.fragment,s),F=n(s),d=i(s,"P",{"data-svelte-h":!0}),J(d)!=="svelte-4n5lf1"&&(d.innerHTML=Ts),A=n(s),o(j.$$.fragment,s),D=n(s),w=i(s,"P",{"data-svelte-h":!0}),J(w)!=="svelte-18ywhxh"&&(w.textContent=ys),L=n(s),o(u.$$.fragment,s),P=n(s),b=i(s,"P",{"data-svelte-h":!0}),J(b)!=="svelte-1c2ipa8"&&(b.textContent=ds),q=n(s),o(f.$$.fragment,s),K=n(s),U=i(s,"P",{"data-svelte-h":!0}),J(U)!=="svelte-1n9qsq1"&&(U.textContent=js),O=n(s),o(I.$$.fragment,s),ss=n(s),$=i(s,"P",{"data-svelte-h":!0}),J($)!=="svelte-19cnvx1"&&($.textContent=ws),ts=n(s),o(W.$$.fragment,s),ls=n(s),C=i(s,"P",{"data-svelte-h":!0}),J(C)!=="svelte-1y4pu0a"&&(C.innerHTML=us),as=n(s),k=i(s,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1wmi3ea"&&(k.innerHTML=bs),es=n(s),o(x.$$.fragment,s),ns=n(s),Z=i(s,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-9sr7nh"&&(Z.textContent=fs),ps=n(s),o(N.$$.fragment,s),ms=n(s),G=i(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-1kguc51"&&(G.innerHTML=Us),is=n(s),o(B.$$.fragment,s),os=n(s),E=i(s,"P",{"data-svelte-h":!0}),J(E)!=="svelte-xtxxu6"&&(E.innerHTML=Is),cs=n(s),o(Q.$$.fragment,s),rs=n(s),o(R.$$.fragment,s),Ms=n(s),o(v.$$.fragment,s),hs=n(s),Y=i(s,"P",{}),$s(Y).forEach(l),this.h()},h(){Ws(g,"name","hf:doc:metadata"),Ws(g,"content",vs)},m(s,t){Bs(document.head,g),a(s,_,t),a(s,V,t),a(s,X,t),c(T,s,t),a(s,H,t),c(y,s,t),a(s,F,t),a(s,d,t),a(s,A,t),c(j,s,t),a(s,D,t),a(s,w,t),a(s,L,t),c(u,s,t),a(s,P,t),a(s,b,t),a(s,q,t),c(f,s,t),a(s,K,t),a(s,U,t),a(s,O,t),c(I,s,t),a(s,ss,t),a(s,$,t),a(s,ts,t),c(W,s,t),a(s,ls,t),a(s,C,t),a(s,as,t),a(s,k,t),a(s,es,t),c(x,s,t),a(s,ns,t),a(s,Z,t),a(s,ps,t),c(N,s,t),a(s,ms,t),a(s,G,t),a(s,is,t),c(B,s,t),a(s,os,t),a(s,E,t),a(s,cs,t),c(Q,s,t),a(s,rs,t),c(R,s,t),a(s,Ms,t),c(v,s,t),a(s,hs,t),a(s,Y,t),Js=!0},p:ks,i(s){Js||(r(T.$$.fragment,s),r(y.$$.fragment,s),r(j.$$.fragment,s),r(u.$$.fragment,s),r(f.$$.fragment,s),r(I.$$.fragment,s),r(W.$$.fragment,s),r(x.$$.fragment,s),r(N.$$.fragment,s),r(B.$$.fragment,s),r(Q.$$.fragment,s),r(R.$$.fragment,s),r(v.$$.fragment,s),Js=!0)},o(s){M(T.$$.fragment,s),M(y.$$.fragment,s),M(j.$$.fragment,s),M(u.$$.fragment,s),M(f.$$.fragment,s),M(I.$$.fragment,s),M(W.$$.fragment,s),M(x.$$.fragment,s),M(N.$$.fragment,s),M(B.$$.fragment,s),M(Q.$$.fragment,s),M(R.$$.fragment,s),M(v.$$.fragment,s),Js=!1},d(s){s&&(l(_),l(V),l(X),l(H),l(F),l(d),l(A),l(D),l(w),l(L),l(P),l(b),l(q),l(K),l(U),l(O),l(ss),l($),l(ts),l(ls),l(C),l(as),l(k),l(es),l(ns),l(Z),l(ps),l(ms),l(G),l(is),l(os),l(E),l(cs),l(rs),l(Ms),l(hs),l(Y)),l(g),h(T,s),h(y,s),h(j,s),h(u,s),h(f,s),h(I,s),h(W,s),h(x,s),h(N,s),h(B,s),h(Q,s),h(R,s),h(v,s)}}}const vs='{"title":"SelecSLS","local":"selecsls","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Ss(gs){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends Zs{constructor(g){super(),Ns(this,g,Ss,Rs,Cs,{})}}export{Xs as component};
