import{s as Zt,n as Wt,o as kt}from"../chunks/scheduler.0b596ca5.js";import{S as Ct,i as Nt,e as p,s as a,c as i,h as Gt,a as m,d as e,b as n,f as It,g as o,j as M,k as xt,l as vt,m as l,n as r,t as c,o as h,p as g}from"../chunks/index.d9d53bd3.js";import{C as Bt,H as Y,E as Et}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as X}from"../chunks/CodeBlock.9f18e41e.js";function Qt(Jt){let J,S,_,z,d,A,w,H,y,dt='<strong>SK ResNeXt</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnext" rel="nofollow">ResNeXt</a> that employs a <a href="https://paperswithcode.com/method/selective-kernel" rel="nofollow">Selective Kernel</a> unit. In general, all the large kernel convolutions in the original bottleneck blocks in ResNext are replaced by the proposed <a href="https://paperswithcode.com/method/selective-kernel-convolution" rel="nofollow">SK convolutions</a>, enabling the network to choose appropriate receptive field sizes in an adaptive manner.',F,j,L,u,wt="To load a pretrained model:",K,T,D,f,yt="To load and preprocess the image:",q,b,P,U,jt="To get the model predictions:",O,$,tt,I,ut="To get the top-5 predictions class names:",st,x,et,Z,Tt="Replace the model name with the variant you want to use, e.g. <code>skresnext50_32x4d</code>. You can find the IDs in the model summaries at the top of this page.",lt,W,ft='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,k,nt,C,bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,N,it,G,Ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,v,ot,B,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,E,ct,Q,ht,V,gt,R,Mt;return d=new Bt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new Y({props:{title:"SK-ResNeXt",local:"sk-resnext",headingTag:"h1"}}),j=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NrcmVzbmV4dDUwXzMyeDRkJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnext50_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2tyZXNuZXh0NTBfMzJ4NGQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnext50_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),v=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new X({props:{code:"JTQwbWlzYyU3QmxpMjAxOXNlbGVjdGl2ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCU2VsZWN0aXZlJTIwS2VybmVsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JYaWFuZyUyMExpJTIwYW5kJTIwV2VuaGFpJTIwV2FuZyUyMGFuZCUyMFhpYW9saW4lMjBIdSUyMGFuZCUyMEppYW4lMjBZYW5nJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTAzLjA2NTg2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{li2019selective,
      title={Selective Kernel Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Xiang Li and Wenhai Wang and Xiaolin Hu and Jian Yang}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1903.06586}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),V=new Et({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/skresnext.mdx"}}),{c(){J=p("meta"),S=a(),_=p("p"),z=a(),i(d.$$.fragment),A=a(),i(w.$$.fragment),H=a(),y=p("p"),y.innerHTML=dt,F=a(),i(j.$$.fragment),L=a(),u=p("p"),u.textContent=wt,K=a(),i(T.$$.fragment),D=a(),f=p("p"),f.textContent=yt,q=a(),i(b.$$.fragment),P=a(),U=p("p"),U.textContent=jt,O=a(),i($.$$.fragment),tt=a(),I=p("p"),I.textContent=ut,st=a(),i(x.$$.fragment),et=a(),Z=p("p"),Z.innerHTML=Tt,lt=a(),W=p("p"),W.innerHTML=ft,at=a(),i(k.$$.fragment),nt=a(),C=p("p"),C.textContent=bt,pt=a(),i(N.$$.fragment),it=a(),G=p("p"),G.innerHTML=Ut,mt=a(),i(v.$$.fragment),ot=a(),B=p("p"),B.innerHTML=$t,rt=a(),i(E.$$.fragment),ct=a(),i(Q.$$.fragment),ht=a(),i(V.$$.fragment),gt=a(),R=p("p"),this.h()},l(t){const s=Gt("svelte-u9bgzb",document.head);J=m(s,"META",{name:!0,content:!0}),s.forEach(e),S=n(t),_=m(t,"P",{}),It(_).forEach(e),z=n(t),o(d.$$.fragment,t),A=n(t),o(w.$$.fragment,t),H=n(t),y=m(t,"P",{"data-svelte-h":!0}),M(y)!=="svelte-1kqotlt"&&(y.innerHTML=dt),F=n(t),o(j.$$.fragment,t),L=n(t),u=m(t,"P",{"data-svelte-h":!0}),M(u)!=="svelte-18ywhxh"&&(u.textContent=wt),K=n(t),o(T.$$.fragment,t),D=n(t),f=m(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1c2ipa8"&&(f.textContent=yt),q=n(t),o(b.$$.fragment,t),P=n(t),U=m(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1n9qsq1"&&(U.textContent=jt),O=n(t),o($.$$.fragment,t),tt=n(t),I=m(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-19cnvx1"&&(I.textContent=ut),st=n(t),o(x.$$.fragment,t),et=n(t),Z=m(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-44hawi"&&(Z.innerHTML=Tt),lt=n(t),W=m(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1wmi3ea"&&(W.innerHTML=ft),at=n(t),o(k.$$.fragment,t),nt=n(t),C=m(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-9sr7nh"&&(C.textContent=bt),pt=n(t),o(N.$$.fragment,t),it=n(t),G=m(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1kguc51"&&(G.innerHTML=Ut),mt=n(t),o(v.$$.fragment,t),ot=n(t),B=m(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-xtxxu6"&&(B.innerHTML=$t),rt=n(t),o(E.$$.fragment,t),ct=n(t),o(Q.$$.fragment,t),ht=n(t),o(V.$$.fragment,t),gt=n(t),R=m(t,"P",{}),It(R).forEach(e),this.h()},h(){xt(J,"name","hf:doc:metadata"),xt(J,"content",Vt)},m(t,s){vt(document.head,J),l(t,S,s),l(t,_,s),l(t,z,s),r(d,t,s),l(t,A,s),r(w,t,s),l(t,H,s),l(t,y,s),l(t,F,s),r(j,t,s),l(t,L,s),l(t,u,s),l(t,K,s),r(T,t,s),l(t,D,s),l(t,f,s),l(t,q,s),r(b,t,s),l(t,P,s),l(t,U,s),l(t,O,s),r($,t,s),l(t,tt,s),l(t,I,s),l(t,st,s),r(x,t,s),l(t,et,s),l(t,Z,s),l(t,lt,s),l(t,W,s),l(t,at,s),r(k,t,s),l(t,nt,s),l(t,C,s),l(t,pt,s),r(N,t,s),l(t,it,s),l(t,G,s),l(t,mt,s),r(v,t,s),l(t,ot,s),l(t,B,s),l(t,rt,s),r(E,t,s),l(t,ct,s),r(Q,t,s),l(t,ht,s),r(V,t,s),l(t,gt,s),l(t,R,s),Mt=!0},p:Wt,i(t){Mt||(c(d.$$.fragment,t),c(w.$$.fragment,t),c(j.$$.fragment,t),c(T.$$.fragment,t),c(b.$$.fragment,t),c($.$$.fragment,t),c(x.$$.fragment,t),c(k.$$.fragment,t),c(N.$$.fragment,t),c(v.$$.fragment,t),c(E.$$.fragment,t),c(Q.$$.fragment,t),c(V.$$.fragment,t),Mt=!0)},o(t){h(d.$$.fragment,t),h(w.$$.fragment,t),h(j.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(x.$$.fragment,t),h(k.$$.fragment,t),h(N.$$.fragment,t),h(v.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),h(V.$$.fragment,t),Mt=!1},d(t){t&&(e(S),e(_),e(z),e(A),e(H),e(y),e(F),e(L),e(u),e(K),e(D),e(f),e(q),e(P),e(U),e(O),e(tt),e(I),e(st),e(et),e(Z),e(lt),e(W),e(at),e(nt),e(C),e(pt),e(it),e(G),e(mt),e(ot),e(B),e(rt),e(ct),e(ht),e(gt),e(R)),e(J),g(d,t),g(w,t),g(j,t),g(T,t),g(b,t),g($,t),g(x,t),g(k,t),g(N,t),g(v,t),g(E,t),g(Q,t),g(V,t)}}}const Vt='{"title":"SK-ResNeXt","local":"sk-resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xt(Jt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Ct{constructor(J){super(),Nt(this,J,Xt,Qt,Zt,{})}}export{zt as component};
