import{s as Ws,n as Cs,o as Zs}from"../chunks/scheduler.0b596ca5.js";import{S as Gs,i as Ns,e as p,s as e,c as i,h as Bs,a as m,d as a,b as n,f as $s,g as o,j as J,k as ks,l as xs,m as l,n as r,t as c,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Es,H as V,E as vs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as Q}from"../chunks/CodeBlock.9f18e41e.js";function Rs(gs){let g,z,Y,S,w,H,y,A,d,ws="<strong>Single-Path NAS</strong> is a novel differentiable NAS method for designing hardware-efficient ConvNets in less than 4 hours.",F,j,L,T,ys="To load a pretrained model:",D,u,P,f,ds="To load and preprocess the image:",q,b,K,U,js="To get the model predictions:",O,I,ss,$,Ts="To get the top-5 predictions class names:",ts,k,as,W,us="Replace the model name with the variant you want to use, e.g. <code>spnasnet_100</code>. You can find the IDs in the model summaries at the top of this page.",ls,C,fs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',es,Z,ns,G,bs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,N,is,B,Us=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ms,x,os,E,Is='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rs,v,cs,R,hs,X,Ms,_,Js;return w=new Es({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new V({props:{title:"SPNASNet",local:"spnasnet",headingTag:"h1"}}),j=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NwbmFzbmV0XzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;spnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc3BuYXNuZXRfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;spnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),R=new Q({props:{code:"JTQwbWlzYyU3QnN0YW1vdWxpczIwMTlzaW5nbGVwYXRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTaW5nbGUtUGF0aCUyME5BUyUzQSUyMERlc2lnbmluZyUyMEhhcmR3YXJlLUVmZmljaWVudCUyMENvbnZOZXRzJTIwaW4lMjBsZXNzJTIwdGhhbiUyMDQlMjBIb3VycyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkRpbWl0cmlvcyUyMFN0YW1vdWxpcyUyMGFuZCUyMFJ1aXpob3UlMjBEaW5nJTIwYW5kJTIwRGklMjBXYW5nJTIwYW5kJTIwRGltaXRyaW9zJTIwTHltYmVyb3BvdWxvcyUyMGFuZCUyMEJvZGhpJTIwUHJpeWFudGhhJTIwYW5kJTIwSmllJTIwTGl1JTIwYW5kJTIwRGlhbmElMjBNYXJjdWxlc2N1JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA0LjAyODc3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`@misc{stamoulis2019singlepath,
      title={Single-Path NAS: Designing Hardware-Efficient ConvNets in less than <span class="hljs-number">4</span> Hours}, 
      author={<span class="hljs-keyword">Dimitrios </span>Stamoulis <span class="hljs-keyword">and </span>Ruizhou <span class="hljs-keyword">Ding </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Di </span>Wang <span class="hljs-keyword">and </span><span class="hljs-keyword">Dimitrios </span>Lymberopoulos <span class="hljs-keyword">and </span><span class="hljs-keyword">Bodhi </span>Priyantha <span class="hljs-keyword">and </span><span class="hljs-keyword">Jie </span>Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Diana </span>Marculescu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1904</span>.<span class="hljs-number">02877</span>},
      archivePrefix={arXiv},
      primaryClass={cs.LG}
}`,wrap:!1}}),X=new vs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/spnasnet.mdx"}}),{c(){g=p("meta"),z=e(),Y=p("p"),S=e(),i(w.$$.fragment),H=e(),i(y.$$.fragment),A=e(),d=p("p"),d.innerHTML=ws,F=e(),i(j.$$.fragment),L=e(),T=p("p"),T.textContent=ys,D=e(),i(u.$$.fragment),P=e(),f=p("p"),f.textContent=ds,q=e(),i(b.$$.fragment),K=e(),U=p("p"),U.textContent=js,O=e(),i(I.$$.fragment),ss=e(),$=p("p"),$.textContent=Ts,ts=e(),i(k.$$.fragment),as=e(),W=p("p"),W.innerHTML=us,ls=e(),C=p("p"),C.innerHTML=fs,es=e(),i(Z.$$.fragment),ns=e(),G=p("p"),G.textContent=bs,ps=e(),i(N.$$.fragment),is=e(),B=p("p"),B.innerHTML=Us,ms=e(),i(x.$$.fragment),os=e(),E=p("p"),E.innerHTML=Is,rs=e(),i(v.$$.fragment),cs=e(),i(R.$$.fragment),hs=e(),i(X.$$.fragment),Ms=e(),_=p("p"),this.h()},l(s){const t=Bs("svelte-u9bgzb",document.head);g=m(t,"META",{name:!0,content:!0}),t.forEach(a),z=n(s),Y=m(s,"P",{}),$s(Y).forEach(a),S=n(s),o(w.$$.fragment,s),H=n(s),o(y.$$.fragment,s),A=n(s),d=m(s,"P",{"data-svelte-h":!0}),J(d)!=="svelte-15s7q8i"&&(d.innerHTML=ws),F=n(s),o(j.$$.fragment,s),L=n(s),T=m(s,"P",{"data-svelte-h":!0}),J(T)!=="svelte-18ywhxh"&&(T.textContent=ys),D=n(s),o(u.$$.fragment,s),P=n(s),f=m(s,"P",{"data-svelte-h":!0}),J(f)!=="svelte-1c2ipa8"&&(f.textContent=ds),q=n(s),o(b.$$.fragment,s),K=n(s),U=m(s,"P",{"data-svelte-h":!0}),J(U)!=="svelte-1n9qsq1"&&(U.textContent=js),O=n(s),o(I.$$.fragment,s),ss=n(s),$=m(s,"P",{"data-svelte-h":!0}),J($)!=="svelte-19cnvx1"&&($.textContent=Ts),ts=n(s),o(k.$$.fragment,s),as=n(s),W=m(s,"P",{"data-svelte-h":!0}),J(W)!=="svelte-d1japu"&&(W.innerHTML=us),ls=n(s),C=m(s,"P",{"data-svelte-h":!0}),J(C)!=="svelte-1wmi3ea"&&(C.innerHTML=fs),es=n(s),o(Z.$$.fragment,s),ns=n(s),G=m(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-9sr7nh"&&(G.textContent=bs),ps=n(s),o(N.$$.fragment,s),is=n(s),B=m(s,"P",{"data-svelte-h":!0}),J(B)!=="svelte-1kguc51"&&(B.innerHTML=Us),ms=n(s),o(x.$$.fragment,s),os=n(s),E=m(s,"P",{"data-svelte-h":!0}),J(E)!=="svelte-xtxxu6"&&(E.innerHTML=Is),rs=n(s),o(v.$$.fragment,s),cs=n(s),o(R.$$.fragment,s),hs=n(s),o(X.$$.fragment,s),Ms=n(s),_=m(s,"P",{}),$s(_).forEach(a),this.h()},h(){ks(g,"name","hf:doc:metadata"),ks(g,"content",Xs)},m(s,t){xs(document.head,g),l(s,z,t),l(s,Y,t),l(s,S,t),r(w,s,t),l(s,H,t),r(y,s,t),l(s,A,t),l(s,d,t),l(s,F,t),r(j,s,t),l(s,L,t),l(s,T,t),l(s,D,t),r(u,s,t),l(s,P,t),l(s,f,t),l(s,q,t),r(b,s,t),l(s,K,t),l(s,U,t),l(s,O,t),r(I,s,t),l(s,ss,t),l(s,$,t),l(s,ts,t),r(k,s,t),l(s,as,t),l(s,W,t),l(s,ls,t),l(s,C,t),l(s,es,t),r(Z,s,t),l(s,ns,t),l(s,G,t),l(s,ps,t),r(N,s,t),l(s,is,t),l(s,B,t),l(s,ms,t),r(x,s,t),l(s,os,t),l(s,E,t),l(s,rs,t),r(v,s,t),l(s,cs,t),r(R,s,t),l(s,hs,t),r(X,s,t),l(s,Ms,t),l(s,_,t),Js=!0},p:Cs,i(s){Js||(c(w.$$.fragment,s),c(y.$$.fragment,s),c(j.$$.fragment,s),c(u.$$.fragment,s),c(b.$$.fragment,s),c(I.$$.fragment,s),c(k.$$.fragment,s),c(Z.$$.fragment,s),c(N.$$.fragment,s),c(x.$$.fragment,s),c(v.$$.fragment,s),c(R.$$.fragment,s),c(X.$$.fragment,s),Js=!0)},o(s){h(w.$$.fragment,s),h(y.$$.fragment,s),h(j.$$.fragment,s),h(u.$$.fragment,s),h(b.$$.fragment,s),h(I.$$.fragment,s),h(k.$$.fragment,s),h(Z.$$.fragment,s),h(N.$$.fragment,s),h(x.$$.fragment,s),h(v.$$.fragment,s),h(R.$$.fragment,s),h(X.$$.fragment,s),Js=!1},d(s){s&&(a(z),a(Y),a(S),a(H),a(A),a(d),a(F),a(L),a(T),a(D),a(P),a(f),a(q),a(K),a(U),a(O),a(ss),a($),a(ts),a(as),a(W),a(ls),a(C),a(es),a(ns),a(G),a(ps),a(is),a(B),a(ms),a(os),a(E),a(rs),a(cs),a(hs),a(Ms),a(_)),a(g),M(w,s),M(y,s),M(j,s),M(u,s),M(b,s),M(I,s),M(k,s),M(Z,s),M(N,s),M(x,s),M(v,s),M(R,s),M(X,s)}}}const Xs='{"title":"SPNASNet","local":"spnasnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qs(gs){return Zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ss extends Gs{constructor(g){super(),Ns(this,g,Qs,Rs,Ws,{})}}export{Ss as component};
