import{s as vs,n as As,o as Ws}from"../chunks/scheduler.0b596ca5.js";import{S as Rs,i as Qs,e as p,s as a,c as m,h as Es,a as i,d as t,b as n,f as Bs,g as M,j as h,k as Gs,l as Ys,m as e,n as o,t as r,o as c,p as y}from"../chunks/index.d9d53bd3.js";import{C as Xs,H as V,E as Ss}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as X}from"../chunks/CodeBlock.9f18e41e.js";function _s(Us){let g,z,S,F,J,H,j,L,d,ws='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',D,U,us="The model in this collection utilises semi-supervised learning to improve the performance of the model. The approach brings important gains to standard architectures for image, video and fine-grained classification.",P,w,Ts="Please note the CC-BY-NC 4.0 license on theses weights, non-commercial use only.",q,u,K,T,bs="To load a pretrained model:",O,b,ss,f,fs="To load and preprocess the image:",ls,C,ts,I,Cs="To get the model predictions:",es,$,as,x,Is="To get the top-5 predictions class names:",ns,N,ps,k,$s="Replace the model name with the variant you want to use, e.g. <code>ssl_resnet18</code>. You can find the IDs in the model summaries at the top of this page.",is,Z,xs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ms,B,Ms,G,Ns="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",os,v,rs,A,ks=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,cs,W,ys,R,Zs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',hs,Q,gs,E,Js,Y,js,_,ds;return J=new Xs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new V({props:{title:"SSL ResNet",local:"ssl-resnet",headingTag:"h1"}}),u=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NzbF9yZXNuZXQxOCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ssl_resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),C=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),N=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),v=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc3NsX3Jlc25ldDE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ssl_resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),W=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new X({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTkwNS0wMDU0NiUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3QkkuJTIwWmVraSUyMFlhbG5peiUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEhlcnYlN0IlNUMnJTdCZSU3RCU3RCUyMEolN0IlNUMnJTdCZSU3RCU3RGdvdSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEthbiUyMENoZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNYW5vaGFyJTIwUGFsdXJpJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGhydXYlMjBNYWhhamFuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JCaWxsaW9uLXNjYWxlJTIwc2VtaS1zdXBlcnZpc2VkJTIwbGVhcm5pbmclMjBmb3IlMjBpbWFnZSUyMGNsYXNzaWZpY2F0aW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxOTA1LjAwNTQ2JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTklN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTkwNS4wMDU0NiU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE5MDUuMDA1NDYlN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAyOCUyMFNlcCUyMDIwMjAlMjAwOCUzQTE5JTNBMzclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRmFicy0xOTA1LTAwNTQ2LmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{DBLP:journals/corr/abs-1905-00546,
  author    = {I. Zeki Yalniz and
               Herv{\\&#x27;{e}</span><span class="language-xml">} J</span><span class="hljs-template-variable">{\\&#x27;{e}</span><span class="language-xml">}gou and
               Kan Chen and
               Manohar Paluri and
               Dhruv Mahajan},
  title     = </span><span class="hljs-template-variable">{Billion-scale semi-supervised learning for image classification}</span><span class="language-xml">,
  journal   = </span><span class="hljs-template-variable">{CoRR}</span><span class="language-xml">,
  volume    = </span><span class="hljs-template-variable">{abs/1905.00546}</span><span class="language-xml">,
  year      = </span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
  url       = </span><span class="hljs-template-variable">{http://arxiv.org/abs/1905.00546}</span><span class="language-xml">,
  archivePrefix = </span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
  eprint    = </span><span class="hljs-template-variable">{1905.00546}</span><span class="language-xml">,
  timestamp = </span><span class="hljs-template-variable">{Mon, 28 <span class="hljs-keyword">Sep</span> 2020 08:19:37 +0200}</span><span class="language-xml">,
  biburl    = </span><span class="hljs-template-variable">{https://dblp.org/rec/journals/corr/abs-1905-00546.bib}</span><span class="language-xml">,
  bibsource = </span><span class="hljs-template-variable">{dblp computer science bibliography, https://dblp.org}</span><span class="language-xml">
}</span>`,wrap:!1}}),Y=new Ss({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/ssl-resnet.mdx"}}),{c(){g=p("meta"),z=a(),S=p("p"),F=a(),m(J.$$.fragment),H=a(),m(j.$$.fragment),L=a(),d=p("p"),d.innerHTML=ws,D=a(),U=p("p"),U.textContent=us,P=a(),w=p("p"),w.textContent=Ts,q=a(),m(u.$$.fragment),K=a(),T=p("p"),T.textContent=bs,O=a(),m(b.$$.fragment),ss=a(),f=p("p"),f.textContent=fs,ls=a(),m(C.$$.fragment),ts=a(),I=p("p"),I.textContent=Cs,es=a(),m($.$$.fragment),as=a(),x=p("p"),x.textContent=Is,ns=a(),m(N.$$.fragment),ps=a(),k=p("p"),k.innerHTML=$s,is=a(),Z=p("p"),Z.innerHTML=xs,ms=a(),m(B.$$.fragment),Ms=a(),G=p("p"),G.textContent=Ns,os=a(),m(v.$$.fragment),rs=a(),A=p("p"),A.innerHTML=ks,cs=a(),m(W.$$.fragment),ys=a(),R=p("p"),R.innerHTML=Zs,hs=a(),m(Q.$$.fragment),gs=a(),m(E.$$.fragment),Js=a(),m(Y.$$.fragment),js=a(),_=p("p"),this.h()},l(s){const l=Es("svelte-u9bgzb",document.head);g=i(l,"META",{name:!0,content:!0}),l.forEach(t),z=n(s),S=i(s,"P",{}),Bs(S).forEach(t),F=n(s),M(J.$$.fragment,s),H=n(s),M(j.$$.fragment,s),L=n(s),d=i(s,"P",{"data-svelte-h":!0}),h(d)!=="svelte-p6ybkz"&&(d.innerHTML=ws),D=n(s),U=i(s,"P",{"data-svelte-h":!0}),h(U)!=="svelte-l5six6"&&(U.textContent=us),P=n(s),w=i(s,"P",{"data-svelte-h":!0}),h(w)!=="svelte-ye38bd"&&(w.textContent=Ts),q=n(s),M(u.$$.fragment,s),K=n(s),T=i(s,"P",{"data-svelte-h":!0}),h(T)!=="svelte-18ywhxh"&&(T.textContent=bs),O=n(s),M(b.$$.fragment,s),ss=n(s),f=i(s,"P",{"data-svelte-h":!0}),h(f)!=="svelte-1c2ipa8"&&(f.textContent=fs),ls=n(s),M(C.$$.fragment,s),ts=n(s),I=i(s,"P",{"data-svelte-h":!0}),h(I)!=="svelte-1n9qsq1"&&(I.textContent=Cs),es=n(s),M($.$$.fragment,s),as=n(s),x=i(s,"P",{"data-svelte-h":!0}),h(x)!=="svelte-19cnvx1"&&(x.textContent=Is),ns=n(s),M(N.$$.fragment,s),ps=n(s),k=i(s,"P",{"data-svelte-h":!0}),h(k)!=="svelte-a6rqz1"&&(k.innerHTML=$s),is=n(s),Z=i(s,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=xs),ms=n(s),M(B.$$.fragment,s),Ms=n(s),G=i(s,"P",{"data-svelte-h":!0}),h(G)!=="svelte-9sr7nh"&&(G.textContent=Ns),os=n(s),M(v.$$.fragment,s),rs=n(s),A=i(s,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1kguc51"&&(A.innerHTML=ks),cs=n(s),M(W.$$.fragment,s),ys=n(s),R=i(s,"P",{"data-svelte-h":!0}),h(R)!=="svelte-xtxxu6"&&(R.innerHTML=Zs),hs=n(s),M(Q.$$.fragment,s),gs=n(s),M(E.$$.fragment,s),Js=n(s),M(Y.$$.fragment,s),js=n(s),_=i(s,"P",{}),Bs(_).forEach(t),this.h()},h(){Gs(g,"name","hf:doc:metadata"),Gs(g,"content",Vs)},m(s,l){Ys(document.head,g),e(s,z,l),e(s,S,l),e(s,F,l),o(J,s,l),e(s,H,l),o(j,s,l),e(s,L,l),e(s,d,l),e(s,D,l),e(s,U,l),e(s,P,l),e(s,w,l),e(s,q,l),o(u,s,l),e(s,K,l),e(s,T,l),e(s,O,l),o(b,s,l),e(s,ss,l),e(s,f,l),e(s,ls,l),o(C,s,l),e(s,ts,l),e(s,I,l),e(s,es,l),o($,s,l),e(s,as,l),e(s,x,l),e(s,ns,l),o(N,s,l),e(s,ps,l),e(s,k,l),e(s,is,l),e(s,Z,l),e(s,ms,l),o(B,s,l),e(s,Ms,l),e(s,G,l),e(s,os,l),o(v,s,l),e(s,rs,l),e(s,A,l),e(s,cs,l),o(W,s,l),e(s,ys,l),e(s,R,l),e(s,hs,l),o(Q,s,l),e(s,gs,l),o(E,s,l),e(s,Js,l),o(Y,s,l),e(s,js,l),e(s,_,l),ds=!0},p:As,i(s){ds||(r(J.$$.fragment,s),r(j.$$.fragment,s),r(u.$$.fragment,s),r(b.$$.fragment,s),r(C.$$.fragment,s),r($.$$.fragment,s),r(N.$$.fragment,s),r(B.$$.fragment,s),r(v.$$.fragment,s),r(W.$$.fragment,s),r(Q.$$.fragment,s),r(E.$$.fragment,s),r(Y.$$.fragment,s),ds=!0)},o(s){c(J.$$.fragment,s),c(j.$$.fragment,s),c(u.$$.fragment,s),c(b.$$.fragment,s),c(C.$$.fragment,s),c($.$$.fragment,s),c(N.$$.fragment,s),c(B.$$.fragment,s),c(v.$$.fragment,s),c(W.$$.fragment,s),c(Q.$$.fragment,s),c(E.$$.fragment,s),c(Y.$$.fragment,s),ds=!1},d(s){s&&(t(z),t(S),t(F),t(H),t(L),t(d),t(D),t(U),t(P),t(w),t(q),t(K),t(T),t(O),t(ss),t(f),t(ls),t(ts),t(I),t(es),t(as),t(x),t(ns),t(ps),t(k),t(is),t(Z),t(ms),t(Ms),t(G),t(os),t(rs),t(A),t(cs),t(ys),t(R),t(hs),t(gs),t(Js),t(js),t(_)),t(g),y(J,s),y(j,s),y(u,s),y(b,s),y(C,s),y($,s),y(N,s),y(B,s),y(v,s),y(W,s),y(Q,s),y(E,s),y(Y,s)}}}const Vs='{"title":"SSL ResNet","local":"ssl-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function zs(Us){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ps extends Rs{constructor(g){super(),Qs(this,g,zs,_s,vs,{})}}export{Ps as component};
