import{s as Bs,n as vs,o as As}from"../chunks/scheduler.0b596ca5.js";import{S as Rs,i as Qs,e as p,s as a,c as m,h as Es,a as i,d as l,b as n,f as Ws,g as M,j as y,k as Gs,l as Ys,m as e,n as o,t as r,o as c,p as h}from"../chunks/index.d9d53bd3.js";import{C as Ss,H as _,E as Xs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as S}from"../chunks/CodeBlock.9f18e41e.js";function Vs(ws){let g,z,X,H,J,F,j,L,d,Us='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',D,w,us="The models in this collection utilise semi-weakly supervised learning to improve the performance of the model. The approach brings important gains to standard architectures for image, video and fine-grained classification.",P,U,Ts="Please note the CC-BY-NC 4.0 license on theses weights, non-commercial use only.",q,u,K,T,bs="To load a pretrained model:",O,b,ss,f,fs="To load and preprocess the image:",ts,C,ls,I,Cs="To get the model predictions:",es,$,as,N,Is="To get the top-5 predictions class names:",ns,x,ps,k,$s="Replace the model name with the variant you want to use, e.g. <code>swsl_resnet18</code>. You can find the IDs in the model summaries at the top of this page.",is,Z,Ns='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ms,W,Ms,G,xs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",os,B,rs,v,ks=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,cs,A,hs,R,Zs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ys,Q,gs,E,Js,Y,js,V,ds;return J=new Ss({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new _({props:{title:"SWSL ResNet",local:"swsl-resnet",headingTag:"h1"}}),u=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new S({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3N3c2xfcmVzbmV0MTgnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;swsl_resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),C=new S({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new S({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new S({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc3dzbF9yZXNuZXQxOCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;swsl_resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),A=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new S({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTkwNS0wMDU0NiUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3QkkuJTIwWmVraSUyMFlhbG5peiUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEhlcnYlN0IlNUMnJTdCZSU3RCU3RCUyMEolN0IlNUMnJTdCZSU3RCU3RGdvdSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEthbiUyMENoZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNYW5vaGFyJTIwUGFsdXJpJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGhydXYlMjBNYWhhamFuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JCaWxsaW9uLXNjYWxlJTIwc2VtaS1zdXBlcnZpc2VkJTIwbGVhcm5pbmclMjBmb3IlMjBpbWFnZSUyMGNsYXNzaWZpY2F0aW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxOTA1LjAwNTQ2JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTklN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTkwNS4wMDU0NiU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE5MDUuMDA1NDYlN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAyOCUyMFNlcCUyMDIwMjAlMjAwOCUzQTE5JTNBMzclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRmFicy0xOTA1LTAwNTQ2LmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{DBLP:journals/corr/abs-1905-00546,
  author    = {I. Zeki Yalniz and
               Herv{\\&#x27;{e}</span><span class="language-xml">} J</span><span class="hljs-template-variable">{\\&#x27;{e}</span><span class="language-xml">}gou and
               Kan Chen and
               Manohar Paluri and
               Dhruv Mahajan},
  title     = </span><span class="hljs-template-variable">{Billion-scale semi-supervised learning for image classification}</span><span class="language-xml">,
  journal   = </span><span class="hljs-template-variable">{CoRR}</span><span class="language-xml">,
  volume    = </span><span class="hljs-template-variable">{abs/1905.00546}</span><span class="language-xml">,
  year      = </span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
  url       = </span><span class="hljs-template-variable">{http://arxiv.org/abs/1905.00546}</span><span class="language-xml">,
  archivePrefix = </span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
  eprint    = </span><span class="hljs-template-variable">{1905.00546}</span><span class="language-xml">,
  timestamp = </span><span class="hljs-template-variable">{Mon, 28 <span class="hljs-keyword">Sep</span> 2020 08:19:37 +0200}</span><span class="language-xml">,
  biburl    = </span><span class="hljs-template-variable">{https://dblp.org/rec/journals/corr/abs-1905-00546.bib}</span><span class="language-xml">,
  bibsource = </span><span class="hljs-template-variable">{dblp computer science bibliography, https://dblp.org}</span><span class="language-xml">
}</span>`,wrap:!1}}),Y=new Xs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/swsl-resnet.mdx"}}),{c(){g=p("meta"),z=a(),X=p("p"),H=a(),m(J.$$.fragment),F=a(),m(j.$$.fragment),L=a(),d=p("p"),d.innerHTML=Us,D=a(),w=p("p"),w.textContent=us,P=a(),U=p("p"),U.textContent=Ts,q=a(),m(u.$$.fragment),K=a(),T=p("p"),T.textContent=bs,O=a(),m(b.$$.fragment),ss=a(),f=p("p"),f.textContent=fs,ts=a(),m(C.$$.fragment),ls=a(),I=p("p"),I.textContent=Cs,es=a(),m($.$$.fragment),as=a(),N=p("p"),N.textContent=Is,ns=a(),m(x.$$.fragment),ps=a(),k=p("p"),k.innerHTML=$s,is=a(),Z=p("p"),Z.innerHTML=Ns,ms=a(),m(W.$$.fragment),Ms=a(),G=p("p"),G.textContent=xs,os=a(),m(B.$$.fragment),rs=a(),v=p("p"),v.innerHTML=ks,cs=a(),m(A.$$.fragment),hs=a(),R=p("p"),R.innerHTML=Zs,ys=a(),m(Q.$$.fragment),gs=a(),m(E.$$.fragment),Js=a(),m(Y.$$.fragment),js=a(),V=p("p"),this.h()},l(s){const t=Es("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(l),z=n(s),X=i(s,"P",{}),Ws(X).forEach(l),H=n(s),M(J.$$.fragment,s),F=n(s),M(j.$$.fragment,s),L=n(s),d=i(s,"P",{"data-svelte-h":!0}),y(d)!=="svelte-p6ybkz"&&(d.innerHTML=Us),D=n(s),w=i(s,"P",{"data-svelte-h":!0}),y(w)!=="svelte-ya6jib"&&(w.textContent=us),P=n(s),U=i(s,"P",{"data-svelte-h":!0}),y(U)!=="svelte-ye38bd"&&(U.textContent=Ts),q=n(s),M(u.$$.fragment,s),K=n(s),T=i(s,"P",{"data-svelte-h":!0}),y(T)!=="svelte-18ywhxh"&&(T.textContent=bs),O=n(s),M(b.$$.fragment,s),ss=n(s),f=i(s,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1c2ipa8"&&(f.textContent=fs),ts=n(s),M(C.$$.fragment,s),ls=n(s),I=i(s,"P",{"data-svelte-h":!0}),y(I)!=="svelte-1n9qsq1"&&(I.textContent=Cs),es=n(s),M($.$$.fragment,s),as=n(s),N=i(s,"P",{"data-svelte-h":!0}),y(N)!=="svelte-19cnvx1"&&(N.textContent=Is),ns=n(s),M(x.$$.fragment,s),ps=n(s),k=i(s,"P",{"data-svelte-h":!0}),y(k)!=="svelte-6if2n8"&&(k.innerHTML=$s),is=n(s),Z=i(s,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=Ns),ms=n(s),M(W.$$.fragment,s),Ms=n(s),G=i(s,"P",{"data-svelte-h":!0}),y(G)!=="svelte-9sr7nh"&&(G.textContent=xs),os=n(s),M(B.$$.fragment,s),rs=n(s),v=i(s,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1kguc51"&&(v.innerHTML=ks),cs=n(s),M(A.$$.fragment,s),hs=n(s),R=i(s,"P",{"data-svelte-h":!0}),y(R)!=="svelte-xtxxu6"&&(R.innerHTML=Zs),ys=n(s),M(Q.$$.fragment,s),gs=n(s),M(E.$$.fragment,s),Js=n(s),M(Y.$$.fragment,s),js=n(s),V=i(s,"P",{}),Ws(V).forEach(l),this.h()},h(){Gs(g,"name","hf:doc:metadata"),Gs(g,"content",_s)},m(s,t){Ys(document.head,g),e(s,z,t),e(s,X,t),e(s,H,t),o(J,s,t),e(s,F,t),o(j,s,t),e(s,L,t),e(s,d,t),e(s,D,t),e(s,w,t),e(s,P,t),e(s,U,t),e(s,q,t),o(u,s,t),e(s,K,t),e(s,T,t),e(s,O,t),o(b,s,t),e(s,ss,t),e(s,f,t),e(s,ts,t),o(C,s,t),e(s,ls,t),e(s,I,t),e(s,es,t),o($,s,t),e(s,as,t),e(s,N,t),e(s,ns,t),o(x,s,t),e(s,ps,t),e(s,k,t),e(s,is,t),e(s,Z,t),e(s,ms,t),o(W,s,t),e(s,Ms,t),e(s,G,t),e(s,os,t),o(B,s,t),e(s,rs,t),e(s,v,t),e(s,cs,t),o(A,s,t),e(s,hs,t),e(s,R,t),e(s,ys,t),o(Q,s,t),e(s,gs,t),o(E,s,t),e(s,Js,t),o(Y,s,t),e(s,js,t),e(s,V,t),ds=!0},p:vs,i(s){ds||(r(J.$$.fragment,s),r(j.$$.fragment,s),r(u.$$.fragment,s),r(b.$$.fragment,s),r(C.$$.fragment,s),r($.$$.fragment,s),r(x.$$.fragment,s),r(W.$$.fragment,s),r(B.$$.fragment,s),r(A.$$.fragment,s),r(Q.$$.fragment,s),r(E.$$.fragment,s),r(Y.$$.fragment,s),ds=!0)},o(s){c(J.$$.fragment,s),c(j.$$.fragment,s),c(u.$$.fragment,s),c(b.$$.fragment,s),c(C.$$.fragment,s),c($.$$.fragment,s),c(x.$$.fragment,s),c(W.$$.fragment,s),c(B.$$.fragment,s),c(A.$$.fragment,s),c(Q.$$.fragment,s),c(E.$$.fragment,s),c(Y.$$.fragment,s),ds=!1},d(s){s&&(l(z),l(X),l(H),l(F),l(L),l(d),l(D),l(w),l(P),l(U),l(q),l(K),l(T),l(O),l(ss),l(f),l(ts),l(ls),l(I),l(es),l(as),l(N),l(ns),l(ps),l(k),l(is),l(Z),l(ms),l(Ms),l(G),l(os),l(rs),l(v),l(cs),l(hs),l(R),l(ys),l(gs),l(Js),l(js),l(V)),l(g),h(J,s),h(j,s),h(u,s),h(b,s),h(C,s),h($,s),h(x,s),h(W,s),h(B,s),h(A,s),h(Q,s),h(E,s),h(Y,s)}}}const _s='{"title":"SWSL ResNet","local":"swsl-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function zs(ws){return As(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ps extends Rs{constructor(g){super(),Qs(this,g,zs,Vs,Bs,{})}}export{Ps as component};
