import{s as Ot,n as ts,o as ss}from"../chunks/scheduler.0b596ca5.js";import{S as es,i as as,e as p,s as l,c as M,q as F,H as ls,h as ns,a as i,d as e,b as n,f as Wt,g as r,r as L,j as o,u as ps,k as D,l as J,m as a,n as c,t as h,o as y,p as g}from"../chunks/index.d9d53bd3.js";import{C as is,H as O,E as ms}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as P}from"../chunks/CodeBlock.9f18e41e.js";function os(Bt){let j,tt,q,st,u,et,T,at,m,kt,V,Rt="ResNeXt",vt,w,Qt="building block",Zt,U,Et="ResNet",At,H,_t="cardinality",Gt,lt,Kt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>C</mi></mrow><annotation encoding="application/x-tex"> C </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">C</span></span></span></span>',nt,pt,f,Yt="The models in this collection utilise semi-weakly supervised learning to improve the performance of the model. The approach brings important gains to standard architectures for image, video and fine-grained classification.",it,b,Xt="Please note the CC-BY-NC 4.0 license on theses weights, non-commercial use only.",mt,C,ot,x,St="To load a pretrained model:",Mt,I,rt,$,zt="To load and preprocess the image:",ct,N,ht,k,Vt="To get the model predictions:",yt,v,gt,Z,Ht="To get the top-5 predictions class names:",dt,A,Jt,G,Ft="Replace the model name with the variant you want to use, e.g. <code>swsl_resnext101_32x16d</code>. You can find the IDs in the model summaries at the top of this page.",jt,W,Lt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',wt,B,Ut,R,Dt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ut,Q,Tt,E,Pt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ft,_,bt,Y,qt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',Ct,X,xt,S,It,z,$t,K,Nt;return u=new is({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new O({props:{title:"SWSL ResNeXt",local:"swsl-resnext",headingTag:"h1"}}),C=new O({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),I=new P({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3N3c2xfcmVzbmV4dDEwMV8zMngxNmQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;swsl_resnext101_32x16d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),N=new P({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),v=new P({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),A=new P({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new O({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),Q=new P({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc3dzbF9yZXNuZXh0MTAxXzMyeDE2ZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;swsl_resnext101_32x16d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),_=new O({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),X=new O({props:{title:"Citation",local:"citation",headingTag:"h2"}}),S=new P({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTkwNS0wMDU0NiUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3QkkuJTIwWmVraSUyMFlhbG5peiUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEhlcnYlN0IlNUMnJTdCZSU3RCU3RCUyMEolN0IlNUMnJTdCZSU3RCU3RGdvdSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEthbiUyMENoZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNYW5vaGFyJTIwUGFsdXJpJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGhydXYlMjBNYWhhamFuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JCaWxsaW9uLXNjYWxlJTIwc2VtaS1zdXBlcnZpc2VkJTIwbGVhcm5pbmclMjBmb3IlMjBpbWFnZSUyMGNsYXNzaWZpY2F0aW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxOTA1LjAwNTQ2JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTklN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTkwNS4wMDU0NiU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE5MDUuMDA1NDYlN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAyOCUyMFNlcCUyMDIwMjAlMjAwOCUzQTE5JTNBMzclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRmFicy0xOTA1LTAwNTQ2LmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{DBLP:journals/corr/abs-1905-00546,
  author    = {I. Zeki Yalniz and
               Herv{\\&#x27;{e}</span><span class="language-xml">} J</span><span class="hljs-template-variable">{\\&#x27;{e}</span><span class="language-xml">}gou and
               Kan Chen and
               Manohar Paluri and
               Dhruv Mahajan},
  title     = </span><span class="hljs-template-variable">{Billion-scale semi-supervised learning for image classification}</span><span class="language-xml">,
  journal   = </span><span class="hljs-template-variable">{CoRR}</span><span class="language-xml">,
  volume    = </span><span class="hljs-template-variable">{abs/1905.00546}</span><span class="language-xml">,
  year      = </span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
  url       = </span><span class="hljs-template-variable">{http://arxiv.org/abs/1905.00546}</span><span class="language-xml">,
  archivePrefix = </span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
  eprint    = </span><span class="hljs-template-variable">{1905.00546}</span><span class="language-xml">,
  timestamp = </span><span class="hljs-template-variable">{Mon, 28 <span class="hljs-keyword">Sep</span> 2020 08:19:37 +0200}</span><span class="language-xml">,
  biburl    = </span><span class="hljs-template-variable">{https://dblp.org/rec/journals/corr/abs-1905-00546.bib}</span><span class="language-xml">,
  bibsource = </span><span class="hljs-template-variable">{dblp computer science bibliography, https://dblp.org}</span><span class="language-xml">
}</span>`,wrap:!1}}),z=new ms({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/swsl-resnext.mdx"}}),{c(){j=p("meta"),tt=l(),q=p("p"),st=l(),M(u.$$.fragment),et=l(),M(T.$$.fragment),at=l(),m=p("p"),kt=F("A "),V=p("strong"),V.textContent=Rt,vt=F(" repeats a "),w=p("a"),w.textContent=Qt,Zt=F(" that aggregates a set of transformations with the same topology. Compared to a "),U=p("a"),U.textContent=Et,At=F(", it exposes a new dimension,  "),H=p("em"),H.textContent=_t,Gt=F(" (the size of the set of transformations)"),lt=new ls(!1),nt=F(", as an essential factor in addition to the dimensions of depth and width."),pt=l(),f=p("p"),f.textContent=Yt,it=l(),b=p("p"),b.textContent=Xt,mt=l(),M(C.$$.fragment),ot=l(),x=p("p"),x.textContent=St,Mt=l(),M(I.$$.fragment),rt=l(),$=p("p"),$.textContent=zt,ct=l(),M(N.$$.fragment),ht=l(),k=p("p"),k.textContent=Vt,yt=l(),M(v.$$.fragment),gt=l(),Z=p("p"),Z.textContent=Ht,dt=l(),M(A.$$.fragment),Jt=l(),G=p("p"),G.innerHTML=Ft,jt=l(),W=p("p"),W.innerHTML=Lt,wt=l(),M(B.$$.fragment),Ut=l(),R=p("p"),R.textContent=Dt,ut=l(),M(Q.$$.fragment),Tt=l(),E=p("p"),E.innerHTML=Pt,ft=l(),M(_.$$.fragment),bt=l(),Y=p("p"),Y.innerHTML=qt,Ct=l(),M(X.$$.fragment),xt=l(),M(S.$$.fragment),It=l(),M(z.$$.fragment),$t=l(),K=p("p"),this.h()},l(t){const s=ns("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(e),tt=n(t),q=i(t,"P",{}),Wt(q).forEach(e),st=n(t),r(u.$$.fragment,t),et=n(t),r(T.$$.fragment,t),at=n(t),m=i(t,"P",{});var d=Wt(m);kt=L(d,"A "),V=i(d,"STRONG",{"data-svelte-h":!0}),o(V)!=="svelte-ixiuf7"&&(V.textContent=Rt),vt=L(d," repeats a "),w=i(d,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(w)!=="svelte-60xv13"&&(w.textContent=Qt),Zt=L(d," that aggregates a set of transformations with the same topology. Compared to a "),U=i(d,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(U)!=="svelte-1fowv03"&&(U.textContent=Et),At=L(d,", it exposes a new dimension,  "),H=i(d,"EM",{"data-svelte-h":!0}),o(H)!=="svelte-47b3di"&&(H.textContent=_t),Gt=L(d," (the size of the set of transformations)"),lt=ps(d,!1),nt=L(d,", as an essential factor in addition to the dimensions of depth and width."),d.forEach(e),pt=n(t),f=i(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1tlji93"&&(f.textContent=Yt),it=n(t),b=i(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-ye38bd"&&(b.textContent=Xt),mt=n(t),r(C.$$.fragment,t),ot=n(t),x=i(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-18ywhxh"&&(x.textContent=St),Mt=n(t),r(I.$$.fragment,t),rt=n(t),$=i(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-1c2ipa8"&&($.textContent=zt),ct=n(t),r(N.$$.fragment,t),ht=n(t),k=i(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1n9qsq1"&&(k.textContent=Vt),yt=n(t),r(v.$$.fragment,t),gt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-19cnvx1"&&(Z.textContent=Ht),dt=n(t),r(A.$$.fragment,t),Jt=n(t),G=i(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-q7859c"&&(G.innerHTML=Ft),jt=n(t),W=i(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1wmi3ea"&&(W.innerHTML=Lt),wt=n(t),r(B.$$.fragment,t),Ut=n(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-9sr7nh"&&(R.textContent=Dt),ut=n(t),r(Q.$$.fragment,t),Tt=n(t),E=i(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1kguc51"&&(E.innerHTML=Pt),ft=n(t),r(_.$$.fragment,t),bt=n(t),Y=i(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-xtxxu6"&&(Y.innerHTML=qt),Ct=n(t),r(X.$$.fragment,t),xt=n(t),r(S.$$.fragment,t),It=n(t),r(z.$$.fragment,t),$t=n(t),K=i(t,"P",{}),Wt(K).forEach(e),this.h()},h(){D(j,"name","hf:doc:metadata"),D(j,"content",Ms),D(w,"href","https://paperswithcode.com/method/resnext-block"),D(w,"rel","nofollow"),D(U,"href","https://paperswithcode.com/method/resnet"),D(U,"rel","nofollow"),lt.a=nt},m(t,s){J(document.head,j),a(t,tt,s),a(t,q,s),a(t,st,s),c(u,t,s),a(t,et,s),c(T,t,s),a(t,at,s),a(t,m,s),J(m,kt),J(m,V),J(m,vt),J(m,w),J(m,Zt),J(m,U),J(m,At),J(m,H),J(m,Gt),lt.m(Kt,m),J(m,nt),a(t,pt,s),a(t,f,s),a(t,it,s),a(t,b,s),a(t,mt,s),c(C,t,s),a(t,ot,s),a(t,x,s),a(t,Mt,s),c(I,t,s),a(t,rt,s),a(t,$,s),a(t,ct,s),c(N,t,s),a(t,ht,s),a(t,k,s),a(t,yt,s),c(v,t,s),a(t,gt,s),a(t,Z,s),a(t,dt,s),c(A,t,s),a(t,Jt,s),a(t,G,s),a(t,jt,s),a(t,W,s),a(t,wt,s),c(B,t,s),a(t,Ut,s),a(t,R,s),a(t,ut,s),c(Q,t,s),a(t,Tt,s),a(t,E,s),a(t,ft,s),c(_,t,s),a(t,bt,s),a(t,Y,s),a(t,Ct,s),c(X,t,s),a(t,xt,s),c(S,t,s),a(t,It,s),c(z,t,s),a(t,$t,s),a(t,K,s),Nt=!0},p:ts,i(t){Nt||(h(u.$$.fragment,t),h(T.$$.fragment,t),h(C.$$.fragment,t),h(I.$$.fragment,t),h(N.$$.fragment,t),h(v.$$.fragment,t),h(A.$$.fragment,t),h(B.$$.fragment,t),h(Q.$$.fragment,t),h(_.$$.fragment,t),h(X.$$.fragment,t),h(S.$$.fragment,t),h(z.$$.fragment,t),Nt=!0)},o(t){y(u.$$.fragment,t),y(T.$$.fragment,t),y(C.$$.fragment,t),y(I.$$.fragment,t),y(N.$$.fragment,t),y(v.$$.fragment,t),y(A.$$.fragment,t),y(B.$$.fragment,t),y(Q.$$.fragment,t),y(_.$$.fragment,t),y(X.$$.fragment,t),y(S.$$.fragment,t),y(z.$$.fragment,t),Nt=!1},d(t){t&&(e(tt),e(q),e(st),e(et),e(at),e(m),e(pt),e(f),e(it),e(b),e(mt),e(ot),e(x),e(Mt),e(rt),e($),e(ct),e(ht),e(k),e(yt),e(gt),e(Z),e(dt),e(Jt),e(G),e(jt),e(W),e(wt),e(Ut),e(R),e(ut),e(Tt),e(E),e(ft),e(bt),e(Y),e(Ct),e(xt),e(It),e($t),e(K)),e(j),g(u,t),g(T,t),g(C,t),g(I,t),g(N,t),g(v,t),g(A,t),g(B,t),g(Q,t),g(_,t),g(X,t),g(S,t),g(z,t)}}}const Ms='{"title":"SWSL ResNeXt","local":"swsl-resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function rs(Bt){return ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends es{constructor(j){super(),as(this,j,rs,os,Ot,{})}}export{ds as component};
