import{s as Gt,n as Nt,o as Bt}from"../chunks/scheduler.0b596ca5.js";import{S as Wt,i as vt,e as p,s as a,c as m,h as Et,a as i,d as l,b as n,f as kt,g as o,j as y,k as xt,l as At,m as e,n as M,t as r,o as c,p as h}from"../chunks/index.d9d53bd3.js";import{C as Qt,H as S,E as Vt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as Y}from"../chunks/CodeBlock.9f18e41e.js";function Yt(jt){let J,_,R,z,w,H,j,F,T,Tt='<strong>Inception v3</strong> is a convolutional neural network architecture from the Inception family that makes several improvements including using <a href="https://paperswithcode.com/method/label-smoothing" rel="nofollow">Label Smoothing</a>, Factorized 7 x 7 convolutions, and the use of an <a href="https://paperswithcode.com/method/auxiliary-classifier" rel="nofollow">auxiliary classifier</a> to propagate label information lower down the network (along with the use of batch normalization for layers in the sidehead). The key building block is an <a href="https://paperswithcode.com/method/inception-v3-module" rel="nofollow">Inception Module</a>.',L,g,gt='The weights from this model were ported from <a href="https://github.com/tensorflow/models" rel="nofollow">Tensorflow/Models</a>.',D,d,q,u,dt="To load a pretrained model:",P,U,K,f,ut="To load and preprocess the image:",O,b,tt,C,Ut="To get the model predictions:",st,I,lt,$,ft="To get the top-5 predictions class names:",et,Z,at,k,bt="Replace the model name with the variant you want to use, e.g. <code>tf_inception_v3</code>. You can find the IDs in the model summaries at the top of this page.",nt,x,Ct='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,G,it,N,It="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",mt,B,ot,W,$t=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Mt,v,rt,E,Zt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ct,A,ht,Q,yt,V,Jt,X,wt;return w=new Qt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new S({props:{title:"(Tensorflow) Inception v3",local:"tensorflow-inception-v3",headingTag:"h1"}}),d=new S({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),U=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2luY2VwdGlvbl92MyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),G=new S({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfaW5jZXB0aW9uX3YzJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),v=new S({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),A=new S({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new Y({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZTemVnZWR5VklTVzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFZpbmNlbnQlMjBWYW5ob3Vja2UlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZXJnZXklMjBJb2ZmZSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEpvbmF0aG9uJTIwU2hsZW5zJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWmJpZ25pZXclMjBXb2puYSU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCUmV0aGlua2luZyUyMHRoZSUyMEluY2VwdGlvbiUyMEFyY2hpdGVjdHVyZSUyMGZvciUyMENvbXB1dGVyJTIwVmlzaW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxNTEyLjAwNTY3JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTUlN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTUxMi4wMDU2NyU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE1MTIuMDA1NjclN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAxMyUyMEF1ZyUyMDIwMTglMjAxNiUzQTQ5JTNBMDclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRlN6ZWdlZHlWSVNXMTUuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15,
  author    = {Christian Szegedy and
               Vincent Vanhoucke and
               Sergey Ioffe and
               Jonathon Shlens and
               Zbigniew Wojna},
  title     = {Rethinking the Inception Architecture <span class="hljs-keyword">for</span> Computer Vision},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.00567</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.00567</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.00567</span>},
  timestamp = {Mon, <span class="hljs-number">13</span> Aug <span class="hljs-number">2018</span> <span class="hljs-number">16</span>:<span class="hljs-number">49</span>:<span class="hljs-number">07</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),V=new Vt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/tf-inception-v3.mdx"}}),{c(){J=p("meta"),_=a(),R=p("p"),z=a(),m(w.$$.fragment),H=a(),m(j.$$.fragment),F=a(),T=p("p"),T.innerHTML=Tt,L=a(),g=p("p"),g.innerHTML=gt,D=a(),m(d.$$.fragment),q=a(),u=p("p"),u.textContent=dt,P=a(),m(U.$$.fragment),K=a(),f=p("p"),f.textContent=ut,O=a(),m(b.$$.fragment),tt=a(),C=p("p"),C.textContent=Ut,st=a(),m(I.$$.fragment),lt=a(),$=p("p"),$.textContent=ft,et=a(),m(Z.$$.fragment),at=a(),k=p("p"),k.innerHTML=bt,nt=a(),x=p("p"),x.innerHTML=Ct,pt=a(),m(G.$$.fragment),it=a(),N=p("p"),N.textContent=It,mt=a(),m(B.$$.fragment),ot=a(),W=p("p"),W.innerHTML=$t,Mt=a(),m(v.$$.fragment),rt=a(),E=p("p"),E.innerHTML=Zt,ct=a(),m(A.$$.fragment),ht=a(),m(Q.$$.fragment),yt=a(),m(V.$$.fragment),Jt=a(),X=p("p"),this.h()},l(t){const s=Et("svelte-u9bgzb",document.head);J=i(s,"META",{name:!0,content:!0}),s.forEach(l),_=n(t),R=i(t,"P",{}),kt(R).forEach(l),z=n(t),o(w.$$.fragment,t),H=n(t),o(j.$$.fragment,t),F=n(t),T=i(t,"P",{"data-svelte-h":!0}),y(T)!=="svelte-1oyeygh"&&(T.innerHTML=Tt),L=n(t),g=i(t,"P",{"data-svelte-h":!0}),y(g)!=="svelte-1nh6o5x"&&(g.innerHTML=gt),D=n(t),o(d.$$.fragment,t),q=n(t),u=i(t,"P",{"data-svelte-h":!0}),y(u)!=="svelte-18ywhxh"&&(u.textContent=dt),P=n(t),o(U.$$.fragment,t),K=n(t),f=i(t,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1c2ipa8"&&(f.textContent=ut),O=n(t),o(b.$$.fragment,t),tt=n(t),C=i(t,"P",{"data-svelte-h":!0}),y(C)!=="svelte-1n9qsq1"&&(C.textContent=Ut),st=n(t),o(I.$$.fragment,t),lt=n(t),$=i(t,"P",{"data-svelte-h":!0}),y($)!=="svelte-19cnvx1"&&($.textContent=ft),et=n(t),o(Z.$$.fragment,t),at=n(t),k=i(t,"P",{"data-svelte-h":!0}),y(k)!=="svelte-vmg3qi"&&(k.innerHTML=bt),nt=n(t),x=i(t,"P",{"data-svelte-h":!0}),y(x)!=="svelte-1wmi3ea"&&(x.innerHTML=Ct),pt=n(t),o(G.$$.fragment,t),it=n(t),N=i(t,"P",{"data-svelte-h":!0}),y(N)!=="svelte-9sr7nh"&&(N.textContent=It),mt=n(t),o(B.$$.fragment,t),ot=n(t),W=i(t,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1kguc51"&&(W.innerHTML=$t),Mt=n(t),o(v.$$.fragment,t),rt=n(t),E=i(t,"P",{"data-svelte-h":!0}),y(E)!=="svelte-xtxxu6"&&(E.innerHTML=Zt),ct=n(t),o(A.$$.fragment,t),ht=n(t),o(Q.$$.fragment,t),yt=n(t),o(V.$$.fragment,t),Jt=n(t),X=i(t,"P",{}),kt(X).forEach(l),this.h()},h(){xt(J,"name","hf:doc:metadata"),xt(J,"content",Rt)},m(t,s){At(document.head,J),e(t,_,s),e(t,R,s),e(t,z,s),M(w,t,s),e(t,H,s),M(j,t,s),e(t,F,s),e(t,T,s),e(t,L,s),e(t,g,s),e(t,D,s),M(d,t,s),e(t,q,s),e(t,u,s),e(t,P,s),M(U,t,s),e(t,K,s),e(t,f,s),e(t,O,s),M(b,t,s),e(t,tt,s),e(t,C,s),e(t,st,s),M(I,t,s),e(t,lt,s),e(t,$,s),e(t,et,s),M(Z,t,s),e(t,at,s),e(t,k,s),e(t,nt,s),e(t,x,s),e(t,pt,s),M(G,t,s),e(t,it,s),e(t,N,s),e(t,mt,s),M(B,t,s),e(t,ot,s),e(t,W,s),e(t,Mt,s),M(v,t,s),e(t,rt,s),e(t,E,s),e(t,ct,s),M(A,t,s),e(t,ht,s),M(Q,t,s),e(t,yt,s),M(V,t,s),e(t,Jt,s),e(t,X,s),wt=!0},p:Nt,i(t){wt||(r(w.$$.fragment,t),r(j.$$.fragment,t),r(d.$$.fragment,t),r(U.$$.fragment,t),r(b.$$.fragment,t),r(I.$$.fragment,t),r(Z.$$.fragment,t),r(G.$$.fragment,t),r(B.$$.fragment,t),r(v.$$.fragment,t),r(A.$$.fragment,t),r(Q.$$.fragment,t),r(V.$$.fragment,t),wt=!0)},o(t){c(w.$$.fragment,t),c(j.$$.fragment,t),c(d.$$.fragment,t),c(U.$$.fragment,t),c(b.$$.fragment,t),c(I.$$.fragment,t),c(Z.$$.fragment,t),c(G.$$.fragment,t),c(B.$$.fragment,t),c(v.$$.fragment,t),c(A.$$.fragment,t),c(Q.$$.fragment,t),c(V.$$.fragment,t),wt=!1},d(t){t&&(l(_),l(R),l(z),l(H),l(F),l(T),l(L),l(g),l(D),l(q),l(u),l(P),l(K),l(f),l(O),l(tt),l(C),l(st),l(lt),l($),l(et),l(at),l(k),l(nt),l(x),l(pt),l(it),l(N),l(mt),l(ot),l(W),l(Mt),l(rt),l(E),l(ct),l(ht),l(yt),l(Jt),l(X)),l(J),h(w,t),h(j,t),h(d,t),h(U,t),h(b,t),h(I,t),h(Z,t),h(G,t),h(B,t),h(v,t),h(A,t),h(Q,t),h(V,t)}}}const Rt='{"title":"(Tensorflow) Inception v3","local":"tensorflow-inception-v3","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xt(jt){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Wt{constructor(J){super(),vt(this,J,Xt,Yt,Gt,{})}}export{Ft as component};
