import{s as Wt,n as vt,o as kt}from"../chunks/scheduler.0b596ca5.js";import{S as Nt,i as Bt,e as p,s as a,c as i,h as Qt,a as m,d as l,b as n,f as Zt,g as o,j as g,k as Gt,l as _t,m as e,n as r,t as c,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Et,H as A,E as Vt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as R}from"../chunks/CodeBlock.9f18e41e.js";function Rt(wt){let d,S,X,z,j,H,w,F,y,yt='<strong>MixNet</strong> is a type of convolutional neural network discovered via AutoML that utilises <a href="https://paperswithcode.com/method/mixconv" rel="nofollow">MixConvs</a> instead of regular <a href="https://paperswithcode.com/method/depthwise-convolution" rel="nofollow">depthwise convolutions</a>.',L,f,ft='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',D,u,P,J,ut="To load a pretrained model:",K,T,q,b,Jt="To load and preprocess the image:",O,U,tt,$,Tt="To get the model predictions:",st,x,lt,C,bt="To get the top-5 predictions class names:",et,I,at,Z,Ut="Replace the model name with the variant you want to use, e.g. <code>tf_mixnet_l</code>. You can find the IDs in the model summaries at the top of this page.",nt,G,$t='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,W,mt,v,xt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",it,k,ot,N,Ct=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,rt,B,ct,Q,It='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ht,_,Mt,E,gt,V,dt,Y,jt;return j=new Et({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new A({props:{title:"(Tensorflow) MixNet",local:"tensorflow-mixnet",headingTag:"h1"}}),u=new A({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX21peG5ldF9sJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),x=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new A({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfbWl4bmV0X2wnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new A({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),_=new A({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new R({props:{code:"JTQwbWlzYyU3QnRhbjIwMTltaXhjb252JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JNaXhDb252JTNBJTIwTWl4ZWQlMjBEZXB0aHdpc2UlMjBDb252b2x1dGlvbmFsJTIwS2VybmVscyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qk1pbmd4aW5nJTIwVGFuJTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MDcuMDk1OTUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2019mixconv,
      title={MixConv: Mixed Depthwise Convolutional Kernels}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1907.09595}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),V=new Vt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/tf-mixnet.mdx"}}),{c(){d=p("meta"),S=a(),X=p("p"),z=a(),i(j.$$.fragment),H=a(),i(w.$$.fragment),F=a(),y=p("p"),y.innerHTML=yt,L=a(),f=p("p"),f.innerHTML=ft,D=a(),i(u.$$.fragment),P=a(),J=p("p"),J.textContent=ut,K=a(),i(T.$$.fragment),q=a(),b=p("p"),b.textContent=Jt,O=a(),i(U.$$.fragment),tt=a(),$=p("p"),$.textContent=Tt,st=a(),i(x.$$.fragment),lt=a(),C=p("p"),C.textContent=bt,et=a(),i(I.$$.fragment),at=a(),Z=p("p"),Z.innerHTML=Ut,nt=a(),G=p("p"),G.innerHTML=$t,pt=a(),i(W.$$.fragment),mt=a(),v=p("p"),v.textContent=xt,it=a(),i(k.$$.fragment),ot=a(),N=p("p"),N.innerHTML=Ct,rt=a(),i(B.$$.fragment),ct=a(),Q=p("p"),Q.innerHTML=It,ht=a(),i(_.$$.fragment),Mt=a(),i(E.$$.fragment),gt=a(),i(V.$$.fragment),dt=a(),Y=p("p"),this.h()},l(t){const s=Qt("svelte-u9bgzb",document.head);d=m(s,"META",{name:!0,content:!0}),s.forEach(l),S=n(t),X=m(t,"P",{}),Zt(X).forEach(l),z=n(t),o(j.$$.fragment,t),H=n(t),o(w.$$.fragment,t),F=n(t),y=m(t,"P",{"data-svelte-h":!0}),g(y)!=="svelte-ipcg9j"&&(y.innerHTML=yt),L=n(t),f=m(t,"P",{"data-svelte-h":!0}),g(f)!=="svelte-k8hpf1"&&(f.innerHTML=ft),D=n(t),o(u.$$.fragment,t),P=n(t),J=m(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-18ywhxh"&&(J.textContent=ut),K=n(t),o(T.$$.fragment,t),q=n(t),b=m(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1c2ipa8"&&(b.textContent=Jt),O=n(t),o(U.$$.fragment,t),tt=n(t),$=m(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-1n9qsq1"&&($.textContent=Tt),st=n(t),o(x.$$.fragment,t),lt=n(t),C=m(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-19cnvx1"&&(C.textContent=bt),et=n(t),o(I.$$.fragment,t),at=n(t),Z=m(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-148p09n"&&(Z.innerHTML=Ut),nt=n(t),G=m(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1wmi3ea"&&(G.innerHTML=$t),pt=n(t),o(W.$$.fragment,t),mt=n(t),v=m(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-9sr7nh"&&(v.textContent=xt),it=n(t),o(k.$$.fragment,t),ot=n(t),N=m(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1kguc51"&&(N.innerHTML=Ct),rt=n(t),o(B.$$.fragment,t),ct=n(t),Q=m(t,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-xtxxu6"&&(Q.innerHTML=It),ht=n(t),o(_.$$.fragment,t),Mt=n(t),o(E.$$.fragment,t),gt=n(t),o(V.$$.fragment,t),dt=n(t),Y=m(t,"P",{}),Zt(Y).forEach(l),this.h()},h(){Gt(d,"name","hf:doc:metadata"),Gt(d,"content",Xt)},m(t,s){_t(document.head,d),e(t,S,s),e(t,X,s),e(t,z,s),r(j,t,s),e(t,H,s),r(w,t,s),e(t,F,s),e(t,y,s),e(t,L,s),e(t,f,s),e(t,D,s),r(u,t,s),e(t,P,s),e(t,J,s),e(t,K,s),r(T,t,s),e(t,q,s),e(t,b,s),e(t,O,s),r(U,t,s),e(t,tt,s),e(t,$,s),e(t,st,s),r(x,t,s),e(t,lt,s),e(t,C,s),e(t,et,s),r(I,t,s),e(t,at,s),e(t,Z,s),e(t,nt,s),e(t,G,s),e(t,pt,s),r(W,t,s),e(t,mt,s),e(t,v,s),e(t,it,s),r(k,t,s),e(t,ot,s),e(t,N,s),e(t,rt,s),r(B,t,s),e(t,ct,s),e(t,Q,s),e(t,ht,s),r(_,t,s),e(t,Mt,s),r(E,t,s),e(t,gt,s),r(V,t,s),e(t,dt,s),e(t,Y,s),jt=!0},p:vt,i(t){jt||(c(j.$$.fragment,t),c(w.$$.fragment,t),c(u.$$.fragment,t),c(T.$$.fragment,t),c(U.$$.fragment,t),c(x.$$.fragment,t),c(I.$$.fragment,t),c(W.$$.fragment,t),c(k.$$.fragment,t),c(B.$$.fragment,t),c(_.$$.fragment,t),c(E.$$.fragment,t),c(V.$$.fragment,t),jt=!0)},o(t){h(j.$$.fragment,t),h(w.$$.fragment,t),h(u.$$.fragment,t),h(T.$$.fragment,t),h(U.$$.fragment,t),h(x.$$.fragment,t),h(I.$$.fragment,t),h(W.$$.fragment,t),h(k.$$.fragment,t),h(B.$$.fragment,t),h(_.$$.fragment,t),h(E.$$.fragment,t),h(V.$$.fragment,t),jt=!1},d(t){t&&(l(S),l(X),l(z),l(H),l(F),l(y),l(L),l(f),l(D),l(P),l(J),l(K),l(q),l(b),l(O),l(tt),l($),l(st),l(lt),l(C),l(et),l(at),l(Z),l(nt),l(G),l(pt),l(mt),l(v),l(it),l(ot),l(N),l(rt),l(ct),l(Q),l(ht),l(Mt),l(gt),l(dt),l(Y)),l(d),M(j,t),M(w,t),M(u,t),M(T,t),M(U,t),M(x,t),M(I,t),M(W,t),M(k,t),M(B,t),M(_,t),M(E,t),M(V,t)}}}const Xt='{"title":"(Tensorflow) MixNet","local":"tensorflow-mixnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Yt(wt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Nt{constructor(d){super(),Bt(this,d,Yt,Rt,Wt,{})}}export{Ft as component};
