import{s as Bl,n as Nl,o as Wl}from"../chunks/scheduler.0b596ca5.js";import{S as Gl,i as xl,e as M,s as a,c as m,h as El,a as p,d as t,b as n,f as kl,g as i,j as h,k as $l,l as Ql,m as e,n as o,t as j,o as r,p as y}from"../chunks/index.d9d53bd3.js";import{C as vl,H as X,E as Yl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as R}from"../chunks/CodeBlock.9f18e41e.js";function Rl(wl){let c,S,V,H,J,z,w,F,d,dl='<strong>MobileNetV3</strong> is a convolutional neural network that is designed for mobile phone CPUs. The network design includes the use of a <a href="https://paperswithcode.com/method/hard-swish" rel="nofollow">hard swish activation</a> and <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation</a> modules in the <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">MBConv blocks</a>.',D,T,Tl='The weights from this model were ported from <a href="https://github.com/tensorflow/models" rel="nofollow">Tensorflow/Models</a>.',L,U,q,g,Ul="To load a pretrained model:",P,b,K,u,gl="To load and preprocess the image:",O,f,ll,C,bl="To get the model predictions:",sl,I,tl,A,ul="To get the top-5 predictions class names:",el,Z,al,k,fl="Replace the model name with the variant you want to use, e.g. <code>tf_mobilenetv3_large_075</code>. You can find the IDs in the model summaries at the top of this page.",nl,$,Cl='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Ml,B,pl,N,Il="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ml,W,il,G,Al=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ol,x,jl,E,Zl='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rl,Q,yl,v,hl,Y,cl,_,Jl;return J=new vl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new X({props:{title:"(Tensorflow) MobileNet v3",local:"tensorflow-mobilenet-v3",headingTag:"h1"}}),U=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX21vYmlsZW5ldHYzX2xhcmdlXzA3NSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mobilenetv3_large_075&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),W=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfbW9iaWxlbmV0djNfbGFyZ2VfMDc1JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mobilenetv3_large_075&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new R({props:{code:"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",highlighted:`<span class="hljs-comment">@article{DBLP:journals/corr/abs-1905-02244,</span>
  author    = {Andrew Howard <span class="hljs-keyword">and</span>
               Mark Sandler <span class="hljs-keyword">and</span>
               Grace Chu <span class="hljs-keyword">and</span>
               Liang{-}Chieh Chen <span class="hljs-keyword">and</span>
               Bo Chen <span class="hljs-keyword">and</span>
               Mingxing Tan <span class="hljs-keyword">and</span>
               Weijun Wang <span class="hljs-keyword">and</span>
               Yukun Zhu <span class="hljs-keyword">and</span>
               Ruoming Pang <span class="hljs-keyword">and</span>
               Vijay Vasudevan <span class="hljs-keyword">and</span>
               Quoc V. Le <span class="hljs-keyword">and</span>
               Hartwig Adam},
  title     = {Searching for MobileNetV3},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1905</span>.<span class="hljs-number">02244</span>},
  year      = {<span class="hljs-number">2019</span>},
  url       = {http:<span class="hljs-comment">//arxiv.org/abs/1905.02244},</span>
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1905</span>.<span class="hljs-number">02244</span>},
  timestamp = {Tue, <span class="hljs-number">12</span> Jan <span class="hljs-number">2021</span> <span class="hljs-number">15</span>:<span class="hljs-number">30</span>:<span class="hljs-number">06</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-comment">//dblp.org/rec/journals/corr/abs-1905-02244.bib},</span>
  bibsource = {dblp computer science bibliography, https:<span class="hljs-comment">//dblp.org}</span>
}`,wrap:!1}}),Y=new Yl({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/tf-mobilenet-v3.mdx"}}),{c(){c=M("meta"),S=a(),V=M("p"),H=a(),m(J.$$.fragment),z=a(),m(w.$$.fragment),F=a(),d=M("p"),d.innerHTML=dl,D=a(),T=M("p"),T.innerHTML=Tl,L=a(),m(U.$$.fragment),q=a(),g=M("p"),g.textContent=Ul,P=a(),m(b.$$.fragment),K=a(),u=M("p"),u.textContent=gl,O=a(),m(f.$$.fragment),ll=a(),C=M("p"),C.textContent=bl,sl=a(),m(I.$$.fragment),tl=a(),A=M("p"),A.textContent=ul,el=a(),m(Z.$$.fragment),al=a(),k=M("p"),k.innerHTML=fl,nl=a(),$=M("p"),$.innerHTML=Cl,Ml=a(),m(B.$$.fragment),pl=a(),N=M("p"),N.textContent=Il,ml=a(),m(W.$$.fragment),il=a(),G=M("p"),G.innerHTML=Al,ol=a(),m(x.$$.fragment),jl=a(),E=M("p"),E.innerHTML=Zl,rl=a(),m(Q.$$.fragment),yl=a(),m(v.$$.fragment),hl=a(),m(Y.$$.fragment),cl=a(),_=M("p"),this.h()},l(l){const s=El("svelte-u9bgzb",document.head);c=p(s,"META",{name:!0,content:!0}),s.forEach(t),S=n(l),V=p(l,"P",{}),kl(V).forEach(t),H=n(l),i(J.$$.fragment,l),z=n(l),i(w.$$.fragment,l),F=n(l),d=p(l,"P",{"data-svelte-h":!0}),h(d)!=="svelte-1xpy3t9"&&(d.innerHTML=dl),D=n(l),T=p(l,"P",{"data-svelte-h":!0}),h(T)!=="svelte-1nh6o5x"&&(T.innerHTML=Tl),L=n(l),i(U.$$.fragment,l),q=n(l),g=p(l,"P",{"data-svelte-h":!0}),h(g)!=="svelte-18ywhxh"&&(g.textContent=Ul),P=n(l),i(b.$$.fragment,l),K=n(l),u=p(l,"P",{"data-svelte-h":!0}),h(u)!=="svelte-1c2ipa8"&&(u.textContent=gl),O=n(l),i(f.$$.fragment,l),ll=n(l),C=p(l,"P",{"data-svelte-h":!0}),h(C)!=="svelte-1n9qsq1"&&(C.textContent=bl),sl=n(l),i(I.$$.fragment,l),tl=n(l),A=p(l,"P",{"data-svelte-h":!0}),h(A)!=="svelte-19cnvx1"&&(A.textContent=ul),el=n(l),i(Z.$$.fragment,l),al=n(l),k=p(l,"P",{"data-svelte-h":!0}),h(k)!=="svelte-1urwpdk"&&(k.innerHTML=fl),nl=n(l),$=p(l,"P",{"data-svelte-h":!0}),h($)!=="svelte-1wmi3ea"&&($.innerHTML=Cl),Ml=n(l),i(B.$$.fragment,l),pl=n(l),N=p(l,"P",{"data-svelte-h":!0}),h(N)!=="svelte-9sr7nh"&&(N.textContent=Il),ml=n(l),i(W.$$.fragment,l),il=n(l),G=p(l,"P",{"data-svelte-h":!0}),h(G)!=="svelte-1kguc51"&&(G.innerHTML=Al),ol=n(l),i(x.$$.fragment,l),jl=n(l),E=p(l,"P",{"data-svelte-h":!0}),h(E)!=="svelte-xtxxu6"&&(E.innerHTML=Zl),rl=n(l),i(Q.$$.fragment,l),yl=n(l),i(v.$$.fragment,l),hl=n(l),i(Y.$$.fragment,l),cl=n(l),_=p(l,"P",{}),kl(_).forEach(t),this.h()},h(){$l(c,"name","hf:doc:metadata"),$l(c,"content",Vl)},m(l,s){Ql(document.head,c),e(l,S,s),e(l,V,s),e(l,H,s),o(J,l,s),e(l,z,s),o(w,l,s),e(l,F,s),e(l,d,s),e(l,D,s),e(l,T,s),e(l,L,s),o(U,l,s),e(l,q,s),e(l,g,s),e(l,P,s),o(b,l,s),e(l,K,s),e(l,u,s),e(l,O,s),o(f,l,s),e(l,ll,s),e(l,C,s),e(l,sl,s),o(I,l,s),e(l,tl,s),e(l,A,s),e(l,el,s),o(Z,l,s),e(l,al,s),e(l,k,s),e(l,nl,s),e(l,$,s),e(l,Ml,s),o(B,l,s),e(l,pl,s),e(l,N,s),e(l,ml,s),o(W,l,s),e(l,il,s),e(l,G,s),e(l,ol,s),o(x,l,s),e(l,jl,s),e(l,E,s),e(l,rl,s),o(Q,l,s),e(l,yl,s),o(v,l,s),e(l,hl,s),o(Y,l,s),e(l,cl,s),e(l,_,s),Jl=!0},p:Nl,i(l){Jl||(j(J.$$.fragment,l),j(w.$$.fragment,l),j(U.$$.fragment,l),j(b.$$.fragment,l),j(f.$$.fragment,l),j(I.$$.fragment,l),j(Z.$$.fragment,l),j(B.$$.fragment,l),j(W.$$.fragment,l),j(x.$$.fragment,l),j(Q.$$.fragment,l),j(v.$$.fragment,l),j(Y.$$.fragment,l),Jl=!0)},o(l){r(J.$$.fragment,l),r(w.$$.fragment,l),r(U.$$.fragment,l),r(b.$$.fragment,l),r(f.$$.fragment,l),r(I.$$.fragment,l),r(Z.$$.fragment,l),r(B.$$.fragment,l),r(W.$$.fragment,l),r(x.$$.fragment,l),r(Q.$$.fragment,l),r(v.$$.fragment,l),r(Y.$$.fragment,l),Jl=!1},d(l){l&&(t(S),t(V),t(H),t(z),t(F),t(d),t(D),t(T),t(L),t(q),t(g),t(P),t(K),t(u),t(O),t(ll),t(C),t(sl),t(tl),t(A),t(el),t(al),t(k),t(nl),t($),t(Ml),t(pl),t(N),t(ml),t(il),t(G),t(ol),t(jl),t(E),t(rl),t(yl),t(hl),t(cl),t(_)),t(c),y(J,l),y(w,l),y(U,l),y(b,l),y(f,l),y(I,l),y(Z,l),y(B,l),y(W,l),y(x,l),y(Q,l),y(v,l),y(Y,l)}}}const Vl='{"title":"(Tensorflow) MobileNet v3","local":"tensorflow-mobilenet-v3","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function _l(wl){return Wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fl extends Gl{constructor(c){super(),xl(this,c,_l,Rl,Bl,{})}}export{Fl as component};
