import{s as Ct,n as kt,o as Gt}from"../chunks/scheduler.0b596ca5.js";import{S as Bt,i as Nt,e as p,s as l,c as i,h as Wt,a as m,d as e,b as n,f as It,g as o,j as d,k as Zt,l as xt,m as a,n as r,t as c,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Et,H as X,E as Rt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as V}from"../chunks/CodeBlock.9f18e41e.js";function vt(gt){let g,z,_,S,y,H,J,F,w,yt='A <strong>TResNet</strong> is a variant on a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that aim to boost accuracy while maintaining GPU training and inference efficiency.  They contain several design tricks including a SpaceToDepth stem, <a href="https://paperswithcode.com/method/anti-alias-downsampling" rel="nofollow">Anti-Alias downsampling</a>, In-Place Activated BatchNorm, Blocks selection and <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation layers</a>.',A,j,L,T,Jt="To load a pretrained model:",P,u,D,f,wt="To load and preprocess the image:",q,b,K,U,jt="To get the model predictions:",O,$,tt,I,Tt="To get the top-5 predictions class names:",st,Z,et,C,ut="Replace the model name with the variant you want to use, e.g. <code>tresnet_l</code>. You can find the IDs in the model summaries at the top of this page.",at,k,ft='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,G,nt,B,bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,N,it,W,Ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,x,ot,E,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,R,ct,v,ht,Q,Mt,Y,dt;return y=new Et({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new X({props:{title:"TResNet",local:"tresnet",headingTag:"h1"}}),j=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RyZXNuZXRfbCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tresnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),G=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndHJlc25ldF9sJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tresnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),R=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new V({props:{code:"JTQwbWlzYyU3QnJpZG5pazIwMjB0cmVzbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JUUmVzTmV0JTNBJTIwSGlnaCUyMFBlcmZvcm1hbmNlJTIwR1BVLURlZGljYXRlZCUyMEFyY2hpdGVjdHVyZSU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QlRhbCUyMFJpZG5payUyMGFuZCUyMEh1c3NhbSUyMExhd2VuJTIwYW5kJTIwQXNhZiUyME5veSUyMGFuZCUyMEVtYW51ZWwlMjBCZW4lMjBCYXJ1Y2glMjBhbmQlMjBHaWxhZCUyMFNoYXJpciUyMGFuZCUyMEl0YW1hciUyMEZyaWVkbWFuJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDAzLjEzNjMwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{ridnik2020tresnet,
      title={TResNet: High Performance GPU-Dedicated Architecture}, 
      author={Tal Ridnik <span class="hljs-keyword">and </span>Hussam Lawen <span class="hljs-keyword">and </span>Asaf Noy <span class="hljs-keyword">and </span>Emanuel <span class="hljs-keyword">Ben </span><span class="hljs-keyword">Baruch </span><span class="hljs-keyword">and </span>Gilad <span class="hljs-keyword">Sharir </span><span class="hljs-keyword">and </span>Itamar Friedman},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">2003</span>.<span class="hljs-number">13630</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Q=new Rt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/tresnet.mdx"}}),{c(){g=p("meta"),z=l(),_=p("p"),S=l(),i(y.$$.fragment),H=l(),i(J.$$.fragment),F=l(),w=p("p"),w.innerHTML=yt,A=l(),i(j.$$.fragment),L=l(),T=p("p"),T.textContent=Jt,P=l(),i(u.$$.fragment),D=l(),f=p("p"),f.textContent=wt,q=l(),i(b.$$.fragment),K=l(),U=p("p"),U.textContent=jt,O=l(),i($.$$.fragment),tt=l(),I=p("p"),I.textContent=Tt,st=l(),i(Z.$$.fragment),et=l(),C=p("p"),C.innerHTML=ut,at=l(),k=p("p"),k.innerHTML=ft,lt=l(),i(G.$$.fragment),nt=l(),B=p("p"),B.textContent=bt,pt=l(),i(N.$$.fragment),it=l(),W=p("p"),W.innerHTML=Ut,mt=l(),i(x.$$.fragment),ot=l(),E=p("p"),E.innerHTML=$t,rt=l(),i(R.$$.fragment),ct=l(),i(v.$$.fragment),ht=l(),i(Q.$$.fragment),Mt=l(),Y=p("p"),this.h()},l(t){const s=Wt("svelte-u9bgzb",document.head);g=m(s,"META",{name:!0,content:!0}),s.forEach(e),z=n(t),_=m(t,"P",{}),It(_).forEach(e),S=n(t),o(y.$$.fragment,t),H=n(t),o(J.$$.fragment,t),F=n(t),w=m(t,"P",{"data-svelte-h":!0}),d(w)!=="svelte-15ptpxo"&&(w.innerHTML=yt),A=n(t),o(j.$$.fragment,t),L=n(t),T=m(t,"P",{"data-svelte-h":!0}),d(T)!=="svelte-18ywhxh"&&(T.textContent=Jt),P=n(t),o(u.$$.fragment,t),D=n(t),f=m(t,"P",{"data-svelte-h":!0}),d(f)!=="svelte-1c2ipa8"&&(f.textContent=wt),q=n(t),o(b.$$.fragment,t),K=n(t),U=m(t,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1n9qsq1"&&(U.textContent=jt),O=n(t),o($.$$.fragment,t),tt=n(t),I=m(t,"P",{"data-svelte-h":!0}),d(I)!=="svelte-19cnvx1"&&(I.textContent=Tt),st=n(t),o(Z.$$.fragment,t),et=n(t),C=m(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-rdmov8"&&(C.innerHTML=ut),at=n(t),k=m(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1wmi3ea"&&(k.innerHTML=ft),lt=n(t),o(G.$$.fragment,t),nt=n(t),B=m(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-9sr7nh"&&(B.textContent=bt),pt=n(t),o(N.$$.fragment,t),it=n(t),W=m(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1kguc51"&&(W.innerHTML=Ut),mt=n(t),o(x.$$.fragment,t),ot=n(t),E=m(t,"P",{"data-svelte-h":!0}),d(E)!=="svelte-xtxxu6"&&(E.innerHTML=$t),rt=n(t),o(R.$$.fragment,t),ct=n(t),o(v.$$.fragment,t),ht=n(t),o(Q.$$.fragment,t),Mt=n(t),Y=m(t,"P",{}),It(Y).forEach(e),this.h()},h(){Zt(g,"name","hf:doc:metadata"),Zt(g,"content",Qt)},m(t,s){xt(document.head,g),a(t,z,s),a(t,_,s),a(t,S,s),r(y,t,s),a(t,H,s),r(J,t,s),a(t,F,s),a(t,w,s),a(t,A,s),r(j,t,s),a(t,L,s),a(t,T,s),a(t,P,s),r(u,t,s),a(t,D,s),a(t,f,s),a(t,q,s),r(b,t,s),a(t,K,s),a(t,U,s),a(t,O,s),r($,t,s),a(t,tt,s),a(t,I,s),a(t,st,s),r(Z,t,s),a(t,et,s),a(t,C,s),a(t,at,s),a(t,k,s),a(t,lt,s),r(G,t,s),a(t,nt,s),a(t,B,s),a(t,pt,s),r(N,t,s),a(t,it,s),a(t,W,s),a(t,mt,s),r(x,t,s),a(t,ot,s),a(t,E,s),a(t,rt,s),r(R,t,s),a(t,ct,s),r(v,t,s),a(t,ht,s),r(Q,t,s),a(t,Mt,s),a(t,Y,s),dt=!0},p:kt,i(t){dt||(c(y.$$.fragment,t),c(J.$$.fragment,t),c(j.$$.fragment,t),c(u.$$.fragment,t),c(b.$$.fragment,t),c($.$$.fragment,t),c(Z.$$.fragment,t),c(G.$$.fragment,t),c(N.$$.fragment,t),c(x.$$.fragment,t),c(R.$$.fragment,t),c(v.$$.fragment,t),c(Q.$$.fragment,t),dt=!0)},o(t){h(y.$$.fragment,t),h(J.$$.fragment,t),h(j.$$.fragment,t),h(u.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(Z.$$.fragment,t),h(G.$$.fragment,t),h(N.$$.fragment,t),h(x.$$.fragment,t),h(R.$$.fragment,t),h(v.$$.fragment,t),h(Q.$$.fragment,t),dt=!1},d(t){t&&(e(z),e(_),e(S),e(H),e(F),e(w),e(A),e(L),e(T),e(P),e(D),e(f),e(q),e(K),e(U),e(O),e(tt),e(I),e(st),e(et),e(C),e(at),e(k),e(lt),e(nt),e(B),e(pt),e(it),e(W),e(mt),e(ot),e(E),e(rt),e(ct),e(ht),e(Mt),e(Y)),e(g),M(y,t),M(J,t),M(j,t),M(u,t),M(b,t),M($,t),M(Z,t),M(G,t),M(N,t),M(x,t),M(R,t),M(v,t),M(Q,t)}}}const Qt='{"title":"TResNet","local":"tresnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Vt(gt){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends Bt{constructor(g){super(),Nt(this,g,Vt,vt,Ct,{})}}export{St as component};
