import{s as Zs,n as ks,o as Ws}from"../chunks/scheduler.0b596ca5.js";import{S as xs,i as Ns,e as p,s as a,c as i,h as Bs,a as m,d as e,b as n,f as $s,g as o,j as y,k as Is,l as Rs,m as l,n as r,t as M,o as c,p as h}from"../chunks/index.d9d53bd3.js";import{C as Gs,H as X,E as Es}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as v}from"../chunks/CodeBlock.9f18e41e.js";function Qs(js){let j,Y,V,z,J,S,d,H,g,Js='<strong>Wide Residual Networks</strong> are a variant on <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNets</a> where we decrease depth and increase the width of residual networks. This is achieved through the use of <a href="https://paperswithcode.com/method/wide-residual-block" rel="nofollow">wide residual blocks</a>.',F,w,L,T,ds="To load a pretrained model:",D,u,q,b,gs="To load and preprocess the image:",P,U,K,f,ws="To get the model predictions:",O,C,ss,$,Ts="To get the top-5 predictions class names:",ts,I,es,Z,us="Replace the model name with the variant you want to use, e.g. <code>wide_resnet101_2</code>. You can find the IDs in the model summaries at the top of this page.",ls,k,bs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,W,ns,x,Us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,N,is,B,fs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ms,R,os,G,Cs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rs,E,Ms,Q,cs,A,hs,_,ys;return J=new Gs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new X({props:{title:"Wide ResNet",local:"wide-resnet",headingTag:"h1"}}),w=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3dpZGVfcmVzbmV0MTAxXzInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;wide_resnet101_2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnd2lkZV9yZXNuZXQxMDFfMiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;wide_resnet101_2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),R=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new v({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZaYWdvcnV5a29LMTYlMkMlMEElMjAlMjBhdXRob3IlMjAlMjAlMjAlMjAlM0QlMjAlN0JTZXJnZXklMjBaYWdvcnV5a28lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBOaWtvcyUyMEtvbW9kYWtpcyU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCV2lkZSUyMFJlc2lkdWFsJTIwTmV0d29ya3MlN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE2MDUuMDcxNDYlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNiU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNjA1LjA3MTQ2JTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTYwNS4wNzE0NiU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3Qk1vbiUyQyUyMDEzJTIwQXVnJTIwMjAxOCUyMDE2JTNBNDYlM0E0MiUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGWmFnb3J1eWtvSzE2LmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>ZagoruykoK16,
  author    = {Sergey Zagoruyko and
               Nikos Komodakis},
  title     = {Wide Residual Networks},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1605.07146</span>},
  year      = {<span class="hljs-number">2016</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1605.07146</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1605.07146</span>},
  timestamp = {Mon, <span class="hljs-number">13</span> Aug <span class="hljs-number">2018</span> <span class="hljs-number">16</span>:<span class="hljs-number">46</span>:<span class="hljs-number">42</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>ZagoruykoK16.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),A=new Es({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/wide-resnet.mdx"}}),{c(){j=p("meta"),Y=a(),V=p("p"),z=a(),i(J.$$.fragment),S=a(),i(d.$$.fragment),H=a(),g=p("p"),g.innerHTML=Js,F=a(),i(w.$$.fragment),L=a(),T=p("p"),T.textContent=ds,D=a(),i(u.$$.fragment),q=a(),b=p("p"),b.textContent=gs,P=a(),i(U.$$.fragment),K=a(),f=p("p"),f.textContent=ws,O=a(),i(C.$$.fragment),ss=a(),$=p("p"),$.textContent=Ts,ts=a(),i(I.$$.fragment),es=a(),Z=p("p"),Z.innerHTML=us,ls=a(),k=p("p"),k.innerHTML=bs,as=a(),i(W.$$.fragment),ns=a(),x=p("p"),x.textContent=Us,ps=a(),i(N.$$.fragment),is=a(),B=p("p"),B.innerHTML=fs,ms=a(),i(R.$$.fragment),os=a(),G=p("p"),G.innerHTML=Cs,rs=a(),i(E.$$.fragment),Ms=a(),i(Q.$$.fragment),cs=a(),i(A.$$.fragment),hs=a(),_=p("p"),this.h()},l(s){const t=Bs("svelte-u9bgzb",document.head);j=m(t,"META",{name:!0,content:!0}),t.forEach(e),Y=n(s),V=m(s,"P",{}),$s(V).forEach(e),z=n(s),o(J.$$.fragment,s),S=n(s),o(d.$$.fragment,s),H=n(s),g=m(s,"P",{"data-svelte-h":!0}),y(g)!=="svelte-k7y9u3"&&(g.innerHTML=Js),F=n(s),o(w.$$.fragment,s),L=n(s),T=m(s,"P",{"data-svelte-h":!0}),y(T)!=="svelte-18ywhxh"&&(T.textContent=ds),D=n(s),o(u.$$.fragment,s),q=n(s),b=m(s,"P",{"data-svelte-h":!0}),y(b)!=="svelte-1c2ipa8"&&(b.textContent=gs),P=n(s),o(U.$$.fragment,s),K=n(s),f=m(s,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1n9qsq1"&&(f.textContent=ws),O=n(s),o(C.$$.fragment,s),ss=n(s),$=m(s,"P",{"data-svelte-h":!0}),y($)!=="svelte-19cnvx1"&&($.textContent=Ts),ts=n(s),o(I.$$.fragment,s),es=n(s),Z=m(s,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-1x7kcxy"&&(Z.innerHTML=us),ls=n(s),k=m(s,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1wmi3ea"&&(k.innerHTML=bs),as=n(s),o(W.$$.fragment,s),ns=n(s),x=m(s,"P",{"data-svelte-h":!0}),y(x)!=="svelte-9sr7nh"&&(x.textContent=Us),ps=n(s),o(N.$$.fragment,s),is=n(s),B=m(s,"P",{"data-svelte-h":!0}),y(B)!=="svelte-1kguc51"&&(B.innerHTML=fs),ms=n(s),o(R.$$.fragment,s),os=n(s),G=m(s,"P",{"data-svelte-h":!0}),y(G)!=="svelte-xtxxu6"&&(G.innerHTML=Cs),rs=n(s),o(E.$$.fragment,s),Ms=n(s),o(Q.$$.fragment,s),cs=n(s),o(A.$$.fragment,s),hs=n(s),_=m(s,"P",{}),$s(_).forEach(e),this.h()},h(){Is(j,"name","hf:doc:metadata"),Is(j,"content",As)},m(s,t){Rs(document.head,j),l(s,Y,t),l(s,V,t),l(s,z,t),r(J,s,t),l(s,S,t),r(d,s,t),l(s,H,t),l(s,g,t),l(s,F,t),r(w,s,t),l(s,L,t),l(s,T,t),l(s,D,t),r(u,s,t),l(s,q,t),l(s,b,t),l(s,P,t),r(U,s,t),l(s,K,t),l(s,f,t),l(s,O,t),r(C,s,t),l(s,ss,t),l(s,$,t),l(s,ts,t),r(I,s,t),l(s,es,t),l(s,Z,t),l(s,ls,t),l(s,k,t),l(s,as,t),r(W,s,t),l(s,ns,t),l(s,x,t),l(s,ps,t),r(N,s,t),l(s,is,t),l(s,B,t),l(s,ms,t),r(R,s,t),l(s,os,t),l(s,G,t),l(s,rs,t),r(E,s,t),l(s,Ms,t),r(Q,s,t),l(s,cs,t),r(A,s,t),l(s,hs,t),l(s,_,t),ys=!0},p:ks,i(s){ys||(M(J.$$.fragment,s),M(d.$$.fragment,s),M(w.$$.fragment,s),M(u.$$.fragment,s),M(U.$$.fragment,s),M(C.$$.fragment,s),M(I.$$.fragment,s),M(W.$$.fragment,s),M(N.$$.fragment,s),M(R.$$.fragment,s),M(E.$$.fragment,s),M(Q.$$.fragment,s),M(A.$$.fragment,s),ys=!0)},o(s){c(J.$$.fragment,s),c(d.$$.fragment,s),c(w.$$.fragment,s),c(u.$$.fragment,s),c(U.$$.fragment,s),c(C.$$.fragment,s),c(I.$$.fragment,s),c(W.$$.fragment,s),c(N.$$.fragment,s),c(R.$$.fragment,s),c(E.$$.fragment,s),c(Q.$$.fragment,s),c(A.$$.fragment,s),ys=!1},d(s){s&&(e(Y),e(V),e(z),e(S),e(H),e(g),e(F),e(L),e(T),e(D),e(q),e(b),e(P),e(K),e(f),e(O),e(ss),e($),e(ts),e(es),e(Z),e(ls),e(k),e(as),e(ns),e(x),e(ps),e(is),e(B),e(ms),e(os),e(G),e(rs),e(Ms),e(cs),e(hs),e(_)),e(j),h(J,s),h(d,s),h(w,s),h(u,s),h(U,s),h(C,s),h(I,s),h(W,s),h(N,s),h(R,s),h(E,s),h(Q,s),h(A,s)}}}const As='{"title":"Wide ResNet","local":"wide-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function vs(js){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends xs{constructor(j){super(),Ns(this,j,vs,Qs,Zs,{})}}export{zs as component};
