import{s as Wt,n as Nt,o as kt}from"../chunks/scheduler.0b596ca5.js";import{S as vt,i as Bt,e as p,s as a,c as m,h as Et,a as i,d as l,b as n,f as Zt,g as o,j as g,k as Gt,l as _t,m as e,n as c,t as r,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Qt,H as A,E as Xt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as V}from"../chunks/CodeBlock.9f18e41e.js";function Vt(dt){let j,H,R,S,y,z,d,F,w,wt='<strong>Xception</strong> is a convolutional neural network architecture that relies solely on <a href="https://paperswithcode.com/method/depthwise-separable-convolution" rel="nofollow">depthwise separable convolution layers</a>.',L,J,Jt='The weights from this model were ported from <a href="https://github.com/tensorflow/models" rel="nofollow">Tensorflow/Models</a>.',D,u,P,f,ut="To load a pretrained model:",q,T,K,b,ft="To load and preprocess the image:",O,U,tt,$,Tt="To get the model predictions:",st,C,lt,x,bt="To get the top-5 predictions class names:",et,I,at,Z,Ut="Replace the model name with the variant you want to use, e.g. <code>xception</code>. You can find the IDs in the model summaries at the top of this page.",nt,G,$t='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,W,it,N,Ct="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",mt,k,ot,v,xt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ct,B,rt,E,It='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ht,_,Mt,Q,gt,X,jt,Y,yt;return y=new Qt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new A({props:{title:"Xception",local:"xception",headingTag:"h1"}}),u=new A({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3hjZXB0aW9uJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;xception&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new A({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgneGNlcHRpb24nJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;xception&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new A({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),_=new A({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new V({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZaYWdvcnV5a29LMTYlMkMlMEElNDBtaXNjJTdCY2hvbGxldDIwMTd4Y2VwdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCWGNlcHRpb24lM0ElMjBEZWVwJTIwTGVhcm5pbmclMjB3aXRoJTIwRGVwdGh3aXNlJTIwU2VwYXJhYmxlJTIwQ29udm9sdXRpb25zJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRnJhbiVDMyVBN29pcyUyMENob2xsZXQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE2MTAuMDIzNTclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="hljs-variable">@article</span>{<span class="hljs-variable constant_">DBLP</span><span class="hljs-symbol">:journals/corr/ZagoruykoK16</span>,
<span class="hljs-variable">@misc</span>{chollet2017xception,
      title={<span class="hljs-title class_">Xception</span>: <span class="hljs-title class_">Deep</span> <span class="hljs-title class_">Learning</span> with <span class="hljs-title class_">Depthwise</span> <span class="hljs-title class_">Separable</span> <span class="hljs-title class_">Convolutions</span>}, 
      author={<span class="hljs-title class_">Fran</span>çois <span class="hljs-title class_">Chollet</span>},
      year={<span class="hljs-number">2017</span>},
      eprint={<span class="hljs-number">1610.02357</span>},
      archivePrefix={arXiv},
      primaryClass={cs.<span class="hljs-variable constant_">CV</span>}
}`,wrap:!1}}),X=new Xt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/xception.mdx"}}),{c(){j=p("meta"),H=a(),R=p("p"),S=a(),m(y.$$.fragment),z=a(),m(d.$$.fragment),F=a(),w=p("p"),w.innerHTML=wt,L=a(),J=p("p"),J.innerHTML=Jt,D=a(),m(u.$$.fragment),P=a(),f=p("p"),f.textContent=ut,q=a(),m(T.$$.fragment),K=a(),b=p("p"),b.textContent=ft,O=a(),m(U.$$.fragment),tt=a(),$=p("p"),$.textContent=Tt,st=a(),m(C.$$.fragment),lt=a(),x=p("p"),x.textContent=bt,et=a(),m(I.$$.fragment),at=a(),Z=p("p"),Z.innerHTML=Ut,nt=a(),G=p("p"),G.innerHTML=$t,pt=a(),m(W.$$.fragment),it=a(),N=p("p"),N.textContent=Ct,mt=a(),m(k.$$.fragment),ot=a(),v=p("p"),v.innerHTML=xt,ct=a(),m(B.$$.fragment),rt=a(),E=p("p"),E.innerHTML=It,ht=a(),m(_.$$.fragment),Mt=a(),m(Q.$$.fragment),gt=a(),m(X.$$.fragment),jt=a(),Y=p("p"),this.h()},l(t){const s=Et("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(l),H=n(t),R=i(t,"P",{}),Zt(R).forEach(l),S=n(t),o(y.$$.fragment,t),z=n(t),o(d.$$.fragment,t),F=n(t),w=i(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-s14d2h"&&(w.innerHTML=wt),L=n(t),J=i(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-1nh6o5x"&&(J.innerHTML=Jt),D=n(t),o(u.$$.fragment,t),P=n(t),f=i(t,"P",{"data-svelte-h":!0}),g(f)!=="svelte-18ywhxh"&&(f.textContent=ut),q=n(t),o(T.$$.fragment,t),K=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1c2ipa8"&&(b.textContent=ft),O=n(t),o(U.$$.fragment,t),tt=n(t),$=i(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-1n9qsq1"&&($.textContent=Tt),st=n(t),o(C.$$.fragment,t),lt=n(t),x=i(t,"P",{"data-svelte-h":!0}),g(x)!=="svelte-19cnvx1"&&(x.textContent=bt),et=n(t),o(I.$$.fragment,t),at=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-11ggpx2"&&(Z.innerHTML=Ut),nt=n(t),G=i(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1wmi3ea"&&(G.innerHTML=$t),pt=n(t),o(W.$$.fragment,t),it=n(t),N=i(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-9sr7nh"&&(N.textContent=Ct),mt=n(t),o(k.$$.fragment,t),ot=n(t),v=i(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-1kguc51"&&(v.innerHTML=xt),ct=n(t),o(B.$$.fragment,t),rt=n(t),E=i(t,"P",{"data-svelte-h":!0}),g(E)!=="svelte-xtxxu6"&&(E.innerHTML=It),ht=n(t),o(_.$$.fragment,t),Mt=n(t),o(Q.$$.fragment,t),gt=n(t),o(X.$$.fragment,t),jt=n(t),Y=i(t,"P",{}),Zt(Y).forEach(l),this.h()},h(){Gt(j,"name","hf:doc:metadata"),Gt(j,"content",Rt)},m(t,s){_t(document.head,j),e(t,H,s),e(t,R,s),e(t,S,s),c(y,t,s),e(t,z,s),c(d,t,s),e(t,F,s),e(t,w,s),e(t,L,s),e(t,J,s),e(t,D,s),c(u,t,s),e(t,P,s),e(t,f,s),e(t,q,s),c(T,t,s),e(t,K,s),e(t,b,s),e(t,O,s),c(U,t,s),e(t,tt,s),e(t,$,s),e(t,st,s),c(C,t,s),e(t,lt,s),e(t,x,s),e(t,et,s),c(I,t,s),e(t,at,s),e(t,Z,s),e(t,nt,s),e(t,G,s),e(t,pt,s),c(W,t,s),e(t,it,s),e(t,N,s),e(t,mt,s),c(k,t,s),e(t,ot,s),e(t,v,s),e(t,ct,s),c(B,t,s),e(t,rt,s),e(t,E,s),e(t,ht,s),c(_,t,s),e(t,Mt,s),c(Q,t,s),e(t,gt,s),c(X,t,s),e(t,jt,s),e(t,Y,s),yt=!0},p:Nt,i(t){yt||(r(y.$$.fragment,t),r(d.$$.fragment,t),r(u.$$.fragment,t),r(T.$$.fragment,t),r(U.$$.fragment,t),r(C.$$.fragment,t),r(I.$$.fragment,t),r(W.$$.fragment,t),r(k.$$.fragment,t),r(B.$$.fragment,t),r(_.$$.fragment,t),r(Q.$$.fragment,t),r(X.$$.fragment,t),yt=!0)},o(t){h(y.$$.fragment,t),h(d.$$.fragment,t),h(u.$$.fragment,t),h(T.$$.fragment,t),h(U.$$.fragment,t),h(C.$$.fragment,t),h(I.$$.fragment,t),h(W.$$.fragment,t),h(k.$$.fragment,t),h(B.$$.fragment,t),h(_.$$.fragment,t),h(Q.$$.fragment,t),h(X.$$.fragment,t),yt=!1},d(t){t&&(l(H),l(R),l(S),l(z),l(F),l(w),l(L),l(J),l(D),l(P),l(f),l(q),l(K),l(b),l(O),l(tt),l($),l(st),l(lt),l(x),l(et),l(at),l(Z),l(nt),l(G),l(pt),l(it),l(N),l(mt),l(ot),l(v),l(ct),l(rt),l(E),l(ht),l(Mt),l(gt),l(jt),l(Y)),l(j),M(y,t),M(d,t),M(u,t),M(T,t),M(U,t),M(C,t),M(I,t),M(W,t),M(k,t),M(B,t),M(_,t),M(Q,t),M(X,t)}}}const Rt='{"title":"Xception","local":"xception","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Yt(dt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends vt{constructor(j){super(),Bt(this,j,Yt,Vt,Wt,{})}}export{Ft as component};
