import{s as is,n as ls,o as ss}from"../chunks/scheduler.0b596ca5.js";import{S as ms,i as ps,e as a,s as r,c as d,h as ds,a as o,d as i,b as n,f as m,g as c,j as l,k as v,l as t,m as p,n as g,t as u,o as f,p as h}from"../chunks/index.d9d53bd3.js";import{C as cs,H as j,E as gs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{D as b}from"../chunks/Docstring.25e8062b.js";function us(vi){let Q,vo,ao,bo,be,_o,_e,yo,ye,bi="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",xo,xe,$o,$e,wo,_,we,yr,Tt,_i="Create an optimizer instance via timm registry.",xr,At,yi=`Creates and configures an optimizer with appropriate parameter groups and settings.
Supports automatic parameter group creation for weight decay and layer-wise learning
rates, as well as custom parameter grouping.`,$r,zt,xi="Examples:",wr,oo,ro,Ce,Le,Cr,Dt,$i="optimizer = create_optimizer_v2(model, ‘adamw’, lr=1e-3)",Lr,no,io,Te,Ae,Tr,Pt,wi=`optimizer = create_optimizer_v2(
…     model, ‘sgd’, lr=0.1, momentum=0.9, weight_decay=1e-4
… )`,Ar,lo,so,ze,De,zr,It,Ci=`optimizer = create_optimizer_v2(
…     model, ‘adam’, lr=1e-3, layer_decay=0.7
… )`,Dr,mo,po,Pe,Ie,Pr,Mt,Li=`def group_fn(model):
…     return [
…         {‘params’: model.backbone.parameters(), ‘lr’: 1e-4},
…         {‘params’: model.head.parameters(), ‘lr’: 1e-3}
…     ]
optimizer = create_optimizer_v2(
…     model, ‘sgd’, param_group_fn=group_fn
… )`,Ir,kt,Ti=`Note:
Parameter group handling precedence:`,Mr,qt,Ai="<li>If param_group_fn is provided, it will be used exclusively</li> <li>If layer_decay is provided, layer-wise groups will be created</li> <li>If weight_decay &gt; 0 and filter_bias_and_bn is True, weight decay groups will be created</li> <li>Otherwise, all parameters will be in a single group</li>",Co,y,Me,kr,Et,zi="List available optimizer names, optionally filtered.",qr,Ot,Di=`List all registered optimizers, with optional filtering using wildcard patterns.
Optimizers can be filtered using include and exclude patterns, and can optionally
return descriptions with each optimizer name.`,Er,Ft,Pi="Examples:",Or,Nt,Ii=`<blockquote><blockquote><p>list_optimizers()
[‘adam’, ‘adamw’, ‘sgd’, …]</p></blockquote></blockquote>`,Fr,Ht,Mi=`<blockquote><blockquote><p>list_optimizers([‘la<em>’, ‘nla</em>’])  # List lamb &amp; lars
[‘lamb’, ‘lambc’, ‘larc’, ‘lars’, ‘nlarc’, ‘nlars’]</p></blockquote></blockquote>`,Nr,St,ki=`<blockquote><blockquote><p>list_optimizers(’<em>adam</em>’, exclude_filters=[‘bnb<em>’, ‘fused</em>’])  # Exclude bnb &amp; apex adam optimizers
[‘adam’, ‘adamax’, ‘adamp’, ‘adamw’, ‘nadam’, ‘nadamw’, ‘radam’]</p></blockquote></blockquote>`,Hr,Bt,qi=`<blockquote><blockquote><p>list_optimizers(with_description=True)  # Get descriptions
[(‘adabelief’, ‘Adapts learning rate based on gradient prediction error’),
(‘adadelta’, ‘torch.optim Adadelta, Adapts learning rates based on running windows of gradients’),
(‘adafactor’, ‘Memory-efficient implementation of Adam with factored gradients’),
…]</p></blockquote></blockquote>`,Lo,L,ke,Sr,Gt,Ei="Get optimizer class by name with option to bind default arguments.",Br,Rt,Oi=`Retrieves the optimizer class or a partial function with default arguments bound.
This allows direct instantiation of optimizers with their default configurations
without going through the full factory.`,Gr,Vt,Fi="Examples:",Rr,co,go,qe,Ee,Vr,Ut,Ni=`SGD = get_optimizer_class(‘sgd’)  # nesterov=True bound
opt = SGD(model.parameters(), lr=0.1, momentum=0.9)`,Ur,uo,fo,Oe,Fe,Wr,Wt,Hi=`SGD = get_optimizer_class(‘sgd’)
opt = SGD(model.parameters(), lr=1e-3, momentum=0.9)`,To,Ne,Ao,T,He,jr,jt,Si="Implements AdaBelief algorithm. Modified from Adam in PyTorch",Qr,Qt,Bi="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",Kr,Kt,Gi=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,Zr,Zt,Ri='<li>link to train_script: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',Xr,Z,Se,Jr,Xt,Vi="Performs a single optimization step.",zo,w,Be,Yr,Jt,Ui="Implements Adafactor algorithm.",en,Yt,Wi=`This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,tn,ea,ji=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,an,ta,Qi=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,on,aa,Ki=`Ags:
params: iterable of parameters to optimize or dicts defining parameter groups
lr: external learning rate
eps: regularization constants for square gradient and parameter scale respectively
eps_scale: regularization constants for parameter scale respectively
clip_threshold: threshold of root-mean-square of final gradient update
decay_rate: coefficient used to compute running averages of square gradient
beta1: coefficient used for computing running averages of gradient
weight_decay: weight decay
scale_parameter: if True, learning rate is scaled by root-mean-square of parameter
warmup_init: time-dependent learning rate computation depends on whether warm-up initialization is being used`,rn,X,Ge,nn,oa,Zi="Performs a single optimization step.",Do,G,Re,ln,ra,Xi="PyTorch implementation of BigVision’s Adafactor variant with both single and multi tensor implementations.",sn,na,Ji='Adapted from <a href="https://github.com/google-research/big_vision" rel="nofollow">https://github.com/google-research/big_vision</a> by Ross Wightman',Po,A,Ve,mn,ia,Yi="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",pn,J,Ue,dn,la,el="Gets all parameters in all param_groups with gradients",cn,Y,We,gn,sa,tl="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",un,ee,je,fn,ma,al="Performs a single optimization step.",hn,te,Qe,vn,pa,ol="Zeros out the accumulated hessian traces.",Io,Ke,Ze,Mo,q,Xe,bn,da,rl="Implements a pytorch variant of Adan.",_n,ca,nl=`Adan was proposed in Adan: Adaptive Nesterov Momentum Algorithm for Faster Optimizing Deep Models
<a href="https://arxiv.org/abs/2208.06677" rel="nofollow">https://arxiv.org/abs/2208.06677</a>`,yn,ae,Je,xn,ga,il="Performs a single optimization step.",ko,R,Ye,$n,ua,ll='ADOPT: Modified Adam Can Converge with Any β2 with the Optimal Rate: <a href="https://arxiv.org/abs/2411.02853" rel="nofollow">https://arxiv.org/abs/2411.02853</a>',wn,oe,et,Cn,fa,sl="Perform a single optimization step.",qo,I,tt,Ln,ha,ml=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,Tn,va,pl="LAMB was proposed in:",An,ba,dl='<li>Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:  <a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a></li> <li>On the Convergence of Adam and Beyond: <a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a></li>',zn,re,at,Dn,_a,cl="Performs a single optimization step.",Eo,E,ot,Pn,ya,gl="LaProp Optimizer",In,xa,ul='Paper: LaProp: Separating Momentum and Adaptivity in Adam, <a href="https://arxiv.org/abs/2002.04839" rel="nofollow">https://arxiv.org/abs/2002.04839</a>',Mn,ne,rt,kn,$a,fl="Performs a single optimization step.",Oo,O,nt,qn,wa,hl="LARS for PyTorch",En,Ca,vl='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',On,ie,it,Fn,La,bl="Performs a single optimization step.",Fo,V,lt,Nn,Ta,_l="Implements Lion algorithm.",Hn,le,st,Sn,Aa,yl="Performs a single optimization step.",No,mt,pt,Ho,C,dt,Bn,za,xl=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,Gn,Da,$l='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',Rn,Pa,wl=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,Vn,Ia,Cl=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,Un,Ma,Ll="On sparse problems both weight_decay and momentum should be set to 0.",Wn,se,ct,jn,ka,Tl="Performs a single optimization step.",So,F,gt,Qn,qa,Al="MARS Optimizer",Kn,Ea,zl=`Paper: MARS: Unleashing the Power of Variance Reduction for Training Large Models
<a href="https://arxiv.org/abs/2411.10438" rel="nofollow">https://arxiv.org/abs/2411.10438</a>`,Zn,me,ut,Xn,Oa,Dl="Performs a single optimization step.",Bo,z,ft,Jn,Fa,Pl="Implements NAdamW algorithm.",Yn,Na,Il=`See Table 1 in <a href="https://arxiv.org/abs/1910.05446" rel="nofollow">https://arxiv.org/abs/1910.05446</a> for the implementation of
the NAdam algorithm (there is also a comment in the code which highlights
the only difference of NAdamW and AdamW).`,ei,Ha,Ml="For further details regarding the algorithm we refer to",ti,Sa,kl='<li>Decoupled Weight Decay Regularization: <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a></li> <li>On the Convergence of Adam and Beyond: <a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a></li>',ai,pe,ht,oi,Ba,ql="Performs a single optimization step.",Go,U,vt,ri,Ga,El="Implements Novograd algorithm.",ni,de,bt,ii,Ra,Ol="Performs a single optimization step.",Ro,x,_t,li,Va,Fl="Implements RMSprop algorithm (TensorFlow style epsilon)",si,Ua,Nl=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,mi,Wa,Hl="Noteworthy changes include:",pi,ja,Sl="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",di,Qa,Bl=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,ci,Ka,Gl=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,gi,ce,yt,ui,Za,Rl="Performs a single optimization step.",Vo,xt,$t,Uo,K,wt,fi,ge,Ct,hi,Xa,Vl="Performs a single optimization step.",Wo,Lt,jo,ho,Qo;return be=new cs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),_e=new j({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),xe=new j({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),$e=new j({props:{title:"Factory functions",local:"timm.optim.create_optimizer_v2",headingTag:"h3"}}),we=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:": typing.Union[torch.nn.modules.module.Module, collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": typing.Optional[float] = None"},{name:"layer_decay_min_scale",val:": float = 0.0"},{name:"layer_decay_no_opt_scale",val:": typing.Optional[float] = None"},{name:"param_group_fn",val:": typing.Optional[typing.Callable[[torch.nn.modules.module.Module], typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]]] = None"},{name:"**kwargs",val:": typing.Any"}],parametersDescription:[{anchor:"timm.optim.create_optimizer_v2.model_or_params",description:`<strong>model_or_params</strong> &#x2014; A PyTorch model or an iterable of parameters/parameter groups.
If a model is provided, parameters will be automatically extracted and grouped
based on the other arguments.`,name:"model_or_params"},{anchor:"timm.optim.create_optimizer_v2.opt",description:`<strong>opt</strong> &#x2014; Name of the optimizer to create (e.g., &#x2018;adam&#x2019;, &#x2018;adamw&#x2019;, &#x2018;sgd&#x2019;).
Use list_optimizers() to see available options.`,name:"opt"},{anchor:"timm.optim.create_optimizer_v2.lr",description:"<strong>lr</strong> &#x2014; Learning rate. If None, will use the optimizer&#x2019;s default.",name:"lr"},{anchor:"timm.optim.create_optimizer_v2.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Weight decay factor. Will be used to create param groups if model_or_params is a model.",name:"weight_decay"},{anchor:"timm.optim.create_optimizer_v2.momentum",description:`<strong>momentum</strong> &#x2014; Momentum factor for optimizers that support it. Only used if the
chosen optimizer accepts a momentum parameter.`,name:"momentum"},{anchor:"timm.optim.create_optimizer_v2.foreach",description:`<strong>foreach</strong> &#x2014; Enable/disable foreach (multi-tensor) implementation if available.
If None, will use optimizer-specific defaults.`,name:"foreach"},{anchor:"timm.optim.create_optimizer_v2.filter_bias_and_bn",description:`<strong>filter_bias_and_bn</strong> &#x2014; If True, bias, norm layer parameters (all 1d params) will not have
weight decay applied. Only used when model_or_params is a model and
weight_decay &gt; 0.`,name:"filter_bias_and_bn"},{anchor:"timm.optim.create_optimizer_v2.layer_decay",description:`<strong>layer_decay</strong> &#x2014; Optional layer-wise learning rate decay factor. If provided,
learning rates will be scaled by layer_decay^(max_depth - layer_depth).
Only used when model_or_params is a model.`,name:"layer_decay"},{anchor:"timm.optim.create_optimizer_v2.param_group_fn",description:`<strong>param_group_fn</strong> &#x2014; Optional function to create custom parameter groups.
If provided, other parameter grouping options will be ignored.`,name:"param_group_fn"},{anchor:"timm.optim.create_optimizer_v2.*kwargs",description:"*<strong>*kwargs</strong> &#x2014; Additional optimizer-specific arguments (e.g., betas for Adam).",name:"*kwargs"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L1140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Configured optimizer instance.</p>
`}}),Le=new j({props:{title:"Basic usage with a model",local:"basic-usage-with-a-model",headingTag:"h1"}}),Ae=new j({props:{title:"SGD with momentum and weight decay",local:"sgd-with-momentum-and-weight-decay",headingTag:"h1"}}),De=new j({props:{title:"Adam with layer-wise learning rate decay",local:"adam-with-layer-wise-learning-rate-decay",headingTag:"h1"}}),Ie=new j({props:{title:"Custom parameter groups",local:"custom-parameter-groups",headingTag:"h1"}}),Me=new b({props:{name:"timm.optim.list_optimizers",anchor:"timm.optim.list_optimizers",parameters:[{name:"filter",val:": typing.Union[str, typing.List[str]] = ''"},{name:"exclude_filters",val:": typing.Optional[typing.List[str]] = None"},{name:"with_description",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.list_optimizers.filter",description:`<strong>filter</strong> &#x2014; Wildcard style filter string or list of filter strings
(e.g., &#x2018;adam<em>&#x2019; for all Adam variants, or [&#x2018;adam</em>&#x2019;, &#x2018;*8bit&#x2019;] for
Adam variants and 8-bit optimizers). Empty string means no filtering.`,name:"filter"},{anchor:"timm.optim.list_optimizers.exclude_filters",description:`<strong>exclude_filters</strong> &#x2014; Optional list of wildcard patterns to exclude. For example,
[&#x2019;<em>8bit&#x2019;, &#x2018;fused</em>&#x2019;] would exclude 8-bit and fused implementations.`,name:"exclude_filters"},{anchor:"timm.optim.list_optimizers.with_description",description:`<strong>with_description</strong> &#x2014; If True, returns tuples of (name, description) instead of
just names. Descriptions provide brief explanations of optimizer characteristics.`,name:"with_description"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L1043",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of optimizer names as strings (e.g., [‘adam’, ‘adamw’, …])
If with_description is True:
List of tuples of (name, description) (e.g., [(‘adam’, ‘Adaptive Moment…’), …])</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If with_description is False</p>
`}}),ke=new b({props:{name:"timm.optim.get_optimizer_class",anchor:"timm.optim.get_optimizer_class",parameters:[{name:"name",val:": str"},{name:"bind_defaults",val:": bool = True"}],parametersDescription:[{anchor:"timm.optim.get_optimizer_class.name",description:"<strong>name</strong> &#x2014; Name of the optimizer to retrieve (e.g., &#x2018;adam&#x2019;, &#x2018;sgd&#x2019;)",name:"name"},{anchor:"timm.optim.get_optimizer_class.bind_defaults",description:`<strong>bind_defaults</strong> &#x2014; If True, returns a partial function with default arguments from OptimInfo bound.
If False, returns the raw optimizer class.`,name:"bind_defaults"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L1103",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The optimizer class (e.g., torch.optim.Adam)
If bind_defaults is True:
A partial function with default arguments bound</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If bind_defaults is False</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If optimizer name is not found in registry</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Ee=new j({props:{title:"Get SGD with nesterov momentum default",local:"get-sgd-with-nesterov-momentum-default",headingTag:"h1"}}),Fe=new j({props:{title:"Get raw optimizer class",local:"get-raw-optimizer-class",headingTag:"h1"}}),Ne=new j({props:{title:"Optimizer Classes",local:"timm.optim.AdaBelief",headingTag:"h3"}}),He=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L6"}}),Se=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L106"}}),Be=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": typing.Optional[float] = None"},{name:"eps",val:": float = 1e-30"},{name:"eps_scale",val:": float = 0.001"},{name:"clip_threshold",val:": float = 1.0"},{name:"decay_rate",val:": float = -0.8"},{name:"betas",val:": typing.Optional[typing.Tuple[float, float]] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"scale_parameter",val:": bool = True"},{name:"warmup_init",val:": bool = False"},{name:"min_dim_size_to_factor",val:": int = 16"},{name:"caution",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L21"}}),Ge=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L127"}}),Re=new b({props:{name:"class timm.optim.AdafactorBigVision",anchor:"timm.optim.AdafactorBigVision",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 1.0"},{name:"min_dim_size_to_factor",val:": int = 16"},{name:"decay_rate",val:": float = 0.8"},{name:"decay_offset",val:": int = 0"},{name:"beta2_cap",val:": float = 0.999"},{name:"momentum",val:": typing.Optional[float] = 0.9"},{name:"momentum_dtype",val:": typing.Union[str, torch.dtype] = torch.bfloat16"},{name:"eps",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"clipping_threshold",val:": typing.Optional[float] = None"},{name:"unscaled_wd",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor_bv.py#L53"}}),Ve=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L9"}}),Ue=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L74"}}),We=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L90"}}),je=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L118"}}),Qe=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L81"}}),Ze=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamp.py#L43"}}),Xe=new b({props:{name:"class timm.optim.Adan",anchor:"timm.optim.Adan",parameters:[{name:"params",val:""},{name:"lr",val:": float = 0.001"},{name:"betas",val:": typing.Tuple[float, float, float] = (0.98, 0.92, 0.99)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.0"},{name:"no_prox",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"timm.optim.Adan.params",description:"<strong>params</strong> &#x2014; Iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Adan.lr",description:"<strong>lr</strong> &#x2014; Learning rate.",name:"lr"},{anchor:"timm.optim.Adan.betas",description:"<strong>betas</strong> &#x2014; Coefficients used for first- and second-order moments.",name:"betas"},{anchor:"timm.optim.Adan.eps",description:"<strong>eps</strong> &#x2014; Term added to the denominator to improve numerical stability.",name:"eps"},{anchor:"timm.optim.Adan.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Decoupled weight decay (L2 penalty)",name:"weight_decay"},{anchor:"timm.optim.Adan.no_prox",description:"<strong>no_prox</strong> &#x2014; How to perform the weight decay",name:"no_prox"},{anchor:"timm.optim.Adan.caution",description:"<strong>caution</strong> &#x2014; Enable caution from &#x2018;Cautious Optimizers&#x2019;",name:"caution"},{anchor:"timm.optim.Adan.foreach",description:"<strong>foreach</strong> &#x2014; If True would use torch._foreach implementation. Faster but uses slightly more memory.",name:"foreach"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adan.py#L46"}}),Je=new b({props:{name:"step",anchor:"timm.optim.Adan.step",parameters:[{name:"closure",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adan.py#L117"}}),Ye=new b({props:{name:"class timm.optim.Adopt",anchor:"timm.optim.Adopt",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": typing.Union[float, torch.Tensor] = 0.001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.9999)"},{name:"eps",val:": float = 1e-06"},{name:"clip_exp",val:": typing.Optional[float] = 0.333"},{name:"weight_decay",val:": float = 0.0"},{name:"decoupled",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = False"},{name:"maximize",val:": bool = False"},{name:"capturable",val:": bool = False"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adopt.py#L59"}}),et=new b({props:{name:"step",anchor:"timm.optim.Adopt.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adopt.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adopt.py#L188"}}),tt=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.001"},{name:"bias_correction",val:": bool = True"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.01"},{name:"grad_averaging",val:": bool = True"},{name:"max_grad_norm",val:": typing.Optional[float] = 1.0"},{name:"trust_clip",val:": bool = False"},{name:"always_adapt",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"decoupled_decay",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> &#x2014; Iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> &#x2014; Learning rate",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:"<strong>betas</strong> &#x2014; Coefficients used for computing running averages of gradient and its norm.",name:"betas"},{anchor:"timm.optim.Lamb.eps",description:"<strong>eps</strong> &#x2014; Term added to the denominator to improve numerical stability.",name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Weight decay",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:"<strong>grad_averaging</strong> &#x2014; Whether apply (1-beta2) to grad when calculating running averages of gradient.",name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> &#x2014; Value used to clip global grad norm.",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> &#x2014; Enable LAMBC trust ratio clipping.",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:"<strong>always_adapt</strong> &#x2014; Apply adaptive learning rate to 0.0 weight decay parameter.",name:"always_adapt"},{anchor:"timm.optim.Lamb.caution",description:"<strong>caution</strong> &#x2014; Apply caution.",name:"caution"},{anchor:"timm.optim.Lamb.decoupled",description:"<strong>decoupled</strong> &#x2014; apply decoupled weight decay",name:"decoupled"},{anchor:"timm.optim.Lamb.corrected_weight_decay",description:"<strong>corrected_weight_decay</strong> &#x2014; apply corrected weight decay (lr**2 / max_lr) when using decoupled_decay",name:"corrected_weight_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L67"}}),at=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L147"}}),ot=new b({props:{name:"class timm.optim.LaProp",anchor:"timm.optim.LaProp",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.0004"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-15"},{name:"weight_decay",val:": float = 0.0"},{name:"caution",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/laprop.py#L27"}}),rt=new b({props:{name:"step",anchor:"timm.optim.LaProp.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.LaProp.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/laprop.py#L66"}}),nt=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L17"}}),it=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L75"}}),lt=new b({props:{name:"class timm.optim.Lion",anchor:"timm.optim.Lion",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.0001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.99)"},{name:"weight_decay",val:": float = 0.0"},{name:"caution",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lion.py#L31"}}),st=new b({props:{name:"step",anchor:"timm.optim.Lion.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lion.step.closure",description:"<strong>closure</strong> &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lion.py#L81",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the loss.</p>
`}}),pt=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lookahead.py#L15"}}),dt=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": typing.Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L24"}}),ct=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": typing.Optional[typing.Callable[[], float]] = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L90"}}),gt=new b({props:{name:"class timm.optim.Mars",anchor:"timm.optim.Mars",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.003"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.99)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.0"},{name:"gamma",val:": float = 0.025"},{name:"mars_type",val:": str = 'adamw'"},{name:"optimize_1d",val:": bool = False"},{name:"lr_1d_factor",val:": float = 1.0"},{name:"betas_1d",val:": typing.Optional[typing.Tuple[float, float]] = None"},{name:"caution",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/mars.py#L91"}}),ut=new b({props:{name:"step",anchor:"timm.optim.Mars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Mars.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/mars.py#L141"}}),ft=new b({props:{name:"class timm.optim.NAdamW",anchor:"timm.optim.NAdamW",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.01"},{name:"caution",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"capturable",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.NAdamW.params",description:"<strong>params</strong> &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.NAdamW.lr",description:"<strong>lr</strong> &#x2014; learning rate",name:"lr"},{anchor:"timm.optim.NAdamW.betas",description:"<strong>betas</strong> &#x2014; coefficients used for computing running averages of gradient and its square",name:"betas"},{anchor:"timm.optim.NAdamW.eps",description:"<strong>eps</strong> &#x2014; term added to the denominator to improve numerical stability",name:"eps"},{anchor:"timm.optim.NAdamW.weight_decay",description:"<strong>weight_decay</strong> &#x2014; weight decay coefficient",name:"weight_decay"},{anchor:"timm.optim.NAdamW.caution",description:"<strong>caution</strong> &#x2014; enable caution",name:"caution"},{anchor:"timm.optim.NAdamW.corrected_weight_decay",description:"<strong>corrected_weight_decay</strong> &#x2014; apply corrected weight decay (lr**2 / max_lr)",name:"corrected_weight_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadamw.py#L21"}}),ht=new b({props:{name:"step",anchor:"timm.optim.NAdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NAdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadamw.py#L89"}}),vt=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.grad_averaging",description:"<strong>grad_averaging</strong> &#x2014; gradient averaging",name:"grad_averaging"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L13"}}),bt=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L66"}}),_t=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.01"},{name:"alpha",val:": float = 0.9"},{name:"eps",val:": float = 1e-10"},{name:"weight_decay",val:": float = 0"},{name:"momentum",val:": float = 0.0"},{name:"centered",val:": bool = False"},{name:"decoupled_decay",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"lr_in_momentum",val:": bool = True"},{name:"caution",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:"<strong>params</strong> &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> &#x2014; learning rate",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> &#x2014; momentum factor",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> &#x2014; smoothing (decay) constant",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:"<strong>eps</strong> &#x2014; term added to the denominator to improve numerical stability",name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:"<strong>centered</strong> &#x2014; if <code>True</code>, compute the centered RMSProp, the gradient is normalized by an estimation of its variance",name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.corrected_weight_decay",description:"<strong>corrected_weight_decay</strong> &#x2014; apply corrected weight decay (lr**2 / max_lr) when decoupled_decay is True",name:"corrected_weight_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:"<strong>lr_in_momentum</strong> &#x2014; learning rate scaling is included in the momentum buffer update as per defaults in Tensorflow",name:"lr_in_momentum"},{anchor:"timm.optim.RMSpropTF.caution",description:"<strong>caution</strong> &#x2014; apply caution",name:"caution"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L20"}}),yt=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L98"}}),$t=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdp.py#L19"}}),wt=new b({props:{name:"class timm.optim.SGDW",anchor:"timm.optim.SGDW",parameters:[{name:"params",val:": typing.Union[collections.abc.Iterable[torch.Tensor], collections.abc.Iterable[dict[str, typing.Any]], collections.abc.Iterable[tuple[str, torch.Tensor]]]"},{name:"lr",val:": float = 0.001"},{name:"momentum",val:": float = 0.0"},{name:"dampening",val:": float = 0.0"},{name:"weight_decay",val:": float = 0.0"},{name:"nesterov",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"corrected_weight_decay",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdw.py#L25"}}),Ct=new b({props:{name:"step",anchor:"timm.optim.SGDW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.SGDW.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdw.py#L94"}}),Lt=new gs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/optimizers.mdx"}}),{c(){Q=a("meta"),vo=r(),ao=a("p"),bo=r(),d(be.$$.fragment),_o=r(),d(_e.$$.fragment),yo=r(),ye=a("p"),ye.innerHTML=bi,xo=r(),d(xe.$$.fragment),$o=r(),d($e.$$.fragment),wo=r(),_=a("div"),d(we.$$.fragment),yr=r(),Tt=a("p"),Tt.textContent=_i,xr=r(),At=a("p"),At.textContent=yi,$r=r(),zt=a("p"),zt.textContent=xi,wr=r(),oo=a("blockquote"),ro=a("blockquote"),Ce=a("blockquote"),d(Le.$$.fragment),Cr=r(),Dt=a("p"),Dt.textContent=$i,Lr=r(),no=a("blockquote"),io=a("blockquote"),Te=a("blockquote"),d(Ae.$$.fragment),Tr=r(),Pt=a("p"),Pt.textContent=wi,Ar=r(),lo=a("blockquote"),so=a("blockquote"),ze=a("blockquote"),d(De.$$.fragment),zr=r(),It=a("p"),It.textContent=Ci,Dr=r(),mo=a("blockquote"),po=a("blockquote"),Pe=a("blockquote"),d(Ie.$$.fragment),Pr=r(),Mt=a("p"),Mt.textContent=Li,Ir=r(),kt=a("p"),kt.textContent=Ti,Mr=r(),qt=a("ol"),qt.innerHTML=Ai,Co=r(),y=a("div"),d(Me.$$.fragment),kr=r(),Et=a("p"),Et.textContent=zi,qr=r(),Ot=a("p"),Ot.textContent=Di,Er=r(),Ft=a("p"),Ft.textContent=Pi,Or=r(),Nt=a("blockquote"),Nt.innerHTML=Ii,Fr=r(),Ht=a("blockquote"),Ht.innerHTML=Mi,Nr=r(),St=a("blockquote"),St.innerHTML=ki,Hr=r(),Bt=a("blockquote"),Bt.innerHTML=qi,Lo=r(),L=a("div"),d(ke.$$.fragment),Sr=r(),Gt=a("p"),Gt.textContent=Ei,Br=r(),Rt=a("p"),Rt.textContent=Oi,Gr=r(),Vt=a("p"),Vt.textContent=Fi,Rr=r(),co=a("blockquote"),go=a("blockquote"),qe=a("blockquote"),d(Ee.$$.fragment),Vr=r(),Ut=a("p"),Ut.textContent=Ni,Ur=r(),uo=a("blockquote"),fo=a("blockquote"),Oe=a("blockquote"),d(Fe.$$.fragment),Wr=r(),Wt=a("p"),Wt.textContent=Hi,To=r(),d(Ne.$$.fragment),Ao=r(),T=a("div"),d(He.$$.fragment),jr=r(),jt=a("p"),jt.textContent=Si,Qr=r(),Qt=a("p"),Qt.textContent=Bi,Kr=r(),Kt=a("p"),Kt.innerHTML=Gi,Zr=r(),Zt=a("ul"),Zt.innerHTML=Ri,Xr=r(),Z=a("div"),d(Se.$$.fragment),Jr=r(),Xt=a("p"),Xt.textContent=Vi,zo=r(),w=a("div"),d(Be.$$.fragment),Yr=r(),Jt=a("p"),Jt.textContent=Ui,en=r(),Yt=a("p"),Yt.innerHTML=Wi,tn=r(),ea=a("p"),ea.innerHTML=ji,an=r(),ta=a("p"),ta.innerHTML=Qi,on=r(),aa=a("p"),aa.textContent=Ki,rn=r(),X=a("div"),d(Ge.$$.fragment),nn=r(),oa=a("p"),oa.textContent=Zi,Do=r(),G=a("div"),d(Re.$$.fragment),ln=r(),ra=a("p"),ra.textContent=Xi,sn=r(),na=a("p"),na.innerHTML=Ji,Po=r(),A=a("div"),d(Ve.$$.fragment),mn=r(),ia=a("p"),ia.textContent=Yi,pn=r(),J=a("div"),d(Ue.$$.fragment),dn=r(),la=a("p"),la.textContent=el,cn=r(),Y=a("div"),d(We.$$.fragment),gn=r(),sa=a("p"),sa.textContent=tl,un=r(),ee=a("div"),d(je.$$.fragment),fn=r(),ma=a("p"),ma.textContent=al,hn=r(),te=a("div"),d(Qe.$$.fragment),vn=r(),pa=a("p"),pa.textContent=ol,Io=r(),Ke=a("div"),d(Ze.$$.fragment),Mo=r(),q=a("div"),d(Xe.$$.fragment),bn=r(),da=a("p"),da.textContent=rl,_n=r(),ca=a("p"),ca.innerHTML=nl,yn=r(),ae=a("div"),d(Je.$$.fragment),xn=r(),ga=a("p"),ga.textContent=il,ko=r(),R=a("div"),d(Ye.$$.fragment),$n=r(),ua=a("p"),ua.innerHTML=ll,wn=r(),oe=a("div"),d(et.$$.fragment),Cn=r(),fa=a("p"),fa.textContent=sl,qo=r(),I=a("div"),d(tt.$$.fragment),Ln=r(),ha=a("p"),ha.innerHTML=ml,Tn=r(),va=a("p"),va.textContent=pl,An=r(),ba=a("ul"),ba.innerHTML=dl,zn=r(),re=a("div"),d(at.$$.fragment),Dn=r(),_a=a("p"),_a.textContent=cl,Eo=r(),E=a("div"),d(ot.$$.fragment),Pn=r(),ya=a("p"),ya.textContent=gl,In=r(),xa=a("p"),xa.innerHTML=ul,Mn=r(),ne=a("div"),d(rt.$$.fragment),kn=r(),$a=a("p"),$a.textContent=fl,Oo=r(),O=a("div"),d(nt.$$.fragment),qn=r(),wa=a("p"),wa.textContent=hl,En=r(),Ca=a("p"),Ca.innerHTML=vl,On=r(),ie=a("div"),d(it.$$.fragment),Fn=r(),La=a("p"),La.textContent=bl,Fo=r(),V=a("div"),d(lt.$$.fragment),Nn=r(),Ta=a("p"),Ta.textContent=_l,Hn=r(),le=a("div"),d(st.$$.fragment),Sn=r(),Aa=a("p"),Aa.textContent=yl,No=r(),mt=a("div"),d(pt.$$.fragment),Ho=r(),C=a("div"),d(dt.$$.fragment),Bn=r(),za=a("p"),za.textContent=xl,Gn=r(),Da=a("p"),Da.innerHTML=$l,Rn=r(),Pa=a("p"),Pa.textContent=wl,Vn=r(),Ia=a("p"),Ia.textContent=Cl,Un=r(),Ma=a("p"),Ma.textContent=Ll,Wn=r(),se=a("div"),d(ct.$$.fragment),jn=r(),ka=a("p"),ka.textContent=Tl,So=r(),F=a("div"),d(gt.$$.fragment),Qn=r(),qa=a("p"),qa.textContent=Al,Kn=r(),Ea=a("p"),Ea.innerHTML=zl,Zn=r(),me=a("div"),d(ut.$$.fragment),Xn=r(),Oa=a("p"),Oa.textContent=Dl,Bo=r(),z=a("div"),d(ft.$$.fragment),Jn=r(),Fa=a("p"),Fa.textContent=Pl,Yn=r(),Na=a("p"),Na.innerHTML=Il,ei=r(),Ha=a("p"),Ha.textContent=Ml,ti=r(),Sa=a("ul"),Sa.innerHTML=kl,ai=r(),pe=a("div"),d(ht.$$.fragment),oi=r(),Ba=a("p"),Ba.textContent=ql,Go=r(),U=a("div"),d(vt.$$.fragment),ri=r(),Ga=a("p"),Ga.textContent=El,ni=r(),de=a("div"),d(bt.$$.fragment),ii=r(),Ra=a("p"),Ra.textContent=Ol,Ro=r(),x=a("div"),d(_t.$$.fragment),li=r(),Va=a("p"),Va.textContent=Fl,si=r(),Ua=a("p"),Ua.textContent=Nl,mi=r(),Wa=a("p"),Wa.textContent=Hl,pi=r(),ja=a("ol"),ja.innerHTML=Sl,di=r(),Qa=a("p"),Qa.innerHTML=Bl,ci=r(),Ka=a("p"),Ka.innerHTML=Gl,gi=r(),ce=a("div"),d(yt.$$.fragment),ui=r(),Za=a("p"),Za.textContent=Rl,Vo=r(),xt=a("div"),d($t.$$.fragment),Uo=r(),K=a("div"),d(wt.$$.fragment),fi=r(),ge=a("div"),d(Ct.$$.fragment),hi=r(),Xa=a("p"),Xa.textContent=Vl,Wo=r(),d(Lt.$$.fragment),jo=r(),ho=a("p"),this.h()},l(e){const s=ds("svelte-u9bgzb",document.head);Q=o(s,"META",{name:!0,content:!0}),s.forEach(i),vo=n(e),ao=o(e,"P",{}),m(ao).forEach(i),bo=n(e),c(be.$$.fragment,e),_o=n(e),c(_e.$$.fragment,e),yo=n(e),ye=o(e,"P",{"data-svelte-h":!0}),l(ye)!=="svelte-1c6qm22"&&(ye.innerHTML=bi),xo=n(e),c(xe.$$.fragment,e),$o=n(e),c($e.$$.fragment,e),wo=n(e),_=o(e,"DIV",{class:!0});var $=m(_);c(we.$$.fragment,$),yr=n($),Tt=o($,"P",{"data-svelte-h":!0}),l(Tt)!=="svelte-1330e7"&&(Tt.textContent=_i),xr=n($),At=o($,"P",{"data-svelte-h":!0}),l(At)!=="svelte-9cjiwr"&&(At.textContent=yi),$r=n($),zt=o($,"P",{"data-svelte-h":!0}),l(zt)!=="svelte-kvfsh7"&&(zt.textContent=xi),wr=n($),oo=o($,"BLOCKQUOTE",{});var Ul=m(oo);ro=o(Ul,"BLOCKQUOTE",{});var Wl=m(ro);Ce=o(Wl,"BLOCKQUOTE",{});var Ko=m(Ce);c(Le.$$.fragment,Ko),Cr=n(Ko),Dt=o(Ko,"P",{"data-svelte-h":!0}),l(Dt)!=="svelte-180ncmf"&&(Dt.textContent=$i),Ko.forEach(i),Wl.forEach(i),Ul.forEach(i),Lr=n($),no=o($,"BLOCKQUOTE",{});var jl=m(no);io=o(jl,"BLOCKQUOTE",{});var Ql=m(io);Te=o(Ql,"BLOCKQUOTE",{});var Zo=m(Te);c(Ae.$$.fragment,Zo),Tr=n(Zo),Pt=o(Zo,"P",{"data-svelte-h":!0}),l(Pt)!=="svelte-6yrpk7"&&(Pt.textContent=wi),Zo.forEach(i),Ql.forEach(i),jl.forEach(i),Ar=n($),lo=o($,"BLOCKQUOTE",{});var Kl=m(lo);so=o(Kl,"BLOCKQUOTE",{});var Zl=m(so);ze=o(Zl,"BLOCKQUOTE",{});var Xo=m(ze);c(De.$$.fragment,Xo),zr=n(Xo),It=o(Xo,"P",{"data-svelte-h":!0}),l(It)!=="svelte-1vmtu70"&&(It.textContent=Ci),Xo.forEach(i),Zl.forEach(i),Kl.forEach(i),Dr=n($),mo=o($,"BLOCKQUOTE",{});var Xl=m(mo);po=o(Xl,"BLOCKQUOTE",{});var Jl=m(po);Pe=o(Jl,"BLOCKQUOTE",{});var Jo=m(Pe);c(Ie.$$.fragment,Jo),Pr=n(Jo),Mt=o(Jo,"P",{"data-svelte-h":!0}),l(Mt)!=="svelte-15ovmpe"&&(Mt.textContent=Li),Jo.forEach(i),Jl.forEach(i),Xl.forEach(i),Ir=n($),kt=o($,"P",{"data-svelte-h":!0}),l(kt)!=="svelte-sgpn75"&&(kt.textContent=Ti),Mr=n($),qt=o($,"OL",{"data-svelte-h":!0}),l(qt)!=="svelte-psaz57"&&(qt.innerHTML=Ai),$.forEach(i),Co=n(e),y=o(e,"DIV",{class:!0});var D=m(y);c(Me.$$.fragment,D),kr=n(D),Et=o(D,"P",{"data-svelte-h":!0}),l(Et)!=="svelte-1h2sspw"&&(Et.textContent=zi),qr=n(D),Ot=o(D,"P",{"data-svelte-h":!0}),l(Ot)!=="svelte-1tapwxe"&&(Ot.textContent=Di),Er=n(D),Ft=o(D,"P",{"data-svelte-h":!0}),l(Ft)!=="svelte-kvfsh7"&&(Ft.textContent=Pi),Or=n(D),Nt=o(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Nt)!=="svelte-m875zf"&&(Nt.innerHTML=Ii),Fr=n(D),Ht=o(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Ht)!=="svelte-1mioyvo"&&(Ht.innerHTML=Mi),Nr=n(D),St=o(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(St)!=="svelte-ji9gfr"&&(St.innerHTML=ki),Hr=n(D),Bt=o(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Bt)!=="svelte-tvmm3x"&&(Bt.innerHTML=qi),D.forEach(i),Lo=n(e),L=o(e,"DIV",{class:!0});var N=m(L);c(ke.$$.fragment,N),Sr=n(N),Gt=o(N,"P",{"data-svelte-h":!0}),l(Gt)!=="svelte-1rcjgrx"&&(Gt.textContent=Ei),Br=n(N),Rt=o(N,"P",{"data-svelte-h":!0}),l(Rt)!=="svelte-13jhmtj"&&(Rt.textContent=Oi),Gr=n(N),Vt=o(N,"P",{"data-svelte-h":!0}),l(Vt)!=="svelte-kvfsh7"&&(Vt.textContent=Fi),Rr=n(N),co=o(N,"BLOCKQUOTE",{});var Yl=m(co);go=o(Yl,"BLOCKQUOTE",{});var es=m(go);qe=o(es,"BLOCKQUOTE",{});var Yo=m(qe);c(Ee.$$.fragment,Yo),Vr=n(Yo),Ut=o(Yo,"P",{"data-svelte-h":!0}),l(Ut)!=="svelte-1en25gb"&&(Ut.textContent=Ni),Yo.forEach(i),es.forEach(i),Yl.forEach(i),Ur=n(N),uo=o(N,"BLOCKQUOTE",{});var ts=m(uo);fo=o(ts,"BLOCKQUOTE",{});var as=m(fo);Oe=o(as,"BLOCKQUOTE",{});var er=m(Oe);c(Fe.$$.fragment,er),Wr=n(er),Wt=o(er,"P",{"data-svelte-h":!0}),l(Wt)!=="svelte-gfx8y2"&&(Wt.textContent=Hi),er.forEach(i),as.forEach(i),ts.forEach(i),N.forEach(i),To=n(e),c(Ne.$$.fragment,e),Ao=n(e),T=o(e,"DIV",{class:!0});var H=m(T);c(He.$$.fragment,H),jr=n(H),jt=o(H,"P",{"data-svelte-h":!0}),l(jt)!=="svelte-1hnunr4"&&(jt.textContent=Si),Qr=n(H),Qt=o(H,"P",{"data-svelte-h":!0}),l(Qt)!=="svelte-1cjb7xo"&&(Qt.textContent=Bi),Kr=n(H),Kt=o(H,"P",{"data-svelte-h":!0}),l(Kt)!=="svelte-1347q2l"&&(Kt.innerHTML=Gi),Zr=n(H),Zt=o(H,"UL",{"data-svelte-h":!0}),l(Zt)!=="svelte-4wdkvs"&&(Zt.innerHTML=Ri),Xr=n(H),Z=o(H,"DIV",{class:!0});var tr=m(Z);c(Se.$$.fragment,tr),Jr=n(tr),Xt=o(tr,"P",{"data-svelte-h":!0}),l(Xt)!=="svelte-1gr03w4"&&(Xt.textContent=Vi),tr.forEach(i),H.forEach(i),zo=n(e),w=o(e,"DIV",{class:!0});var M=m(w);c(Be.$$.fragment,M),Yr=n(M),Jt=o(M,"P",{"data-svelte-h":!0}),l(Jt)!=="svelte-1j9mkxe"&&(Jt.textContent=Ui),en=n(M),Yt=o(M,"P",{"data-svelte-h":!0}),l(Yt)!=="svelte-1xvyiun"&&(Yt.innerHTML=Wi),tn=n(M),ea=o(M,"P",{"data-svelte-h":!0}),l(ea)!=="svelte-1i7ubkr"&&(ea.innerHTML=ji),an=n(M),ta=o(M,"P",{"data-svelte-h":!0}),l(ta)!=="svelte-96f97i"&&(ta.innerHTML=Qi),on=n(M),aa=o(M,"P",{"data-svelte-h":!0}),l(aa)!=="svelte-1q67fqp"&&(aa.textContent=Ki),rn=n(M),X=o(M,"DIV",{class:!0});var ar=m(X);c(Ge.$$.fragment,ar),nn=n(ar),oa=o(ar,"P",{"data-svelte-h":!0}),l(oa)!=="svelte-1gr03w4"&&(oa.textContent=Zi),ar.forEach(i),M.forEach(i),Do=n(e),G=o(e,"DIV",{class:!0});var Ja=m(G);c(Re.$$.fragment,Ja),ln=n(Ja),ra=o(Ja,"P",{"data-svelte-h":!0}),l(ra)!=="svelte-19t8yzj"&&(ra.textContent=Xi),sn=n(Ja),na=o(Ja,"P",{"data-svelte-h":!0}),l(na)!=="svelte-aajaln"&&(na.innerHTML=Ji),Ja.forEach(i),Po=n(e),A=o(e,"DIV",{class:!0});var S=m(A);c(Ve.$$.fragment,S),mn=n(S),ia=o(S,"P",{"data-svelte-h":!0}),l(ia)!=="svelte-1cuo0rh"&&(ia.textContent=Yi),pn=n(S),J=o(S,"DIV",{class:!0});var or=m(J);c(Ue.$$.fragment,or),dn=n(or),la=o(or,"P",{"data-svelte-h":!0}),l(la)!=="svelte-1jz1hl7"&&(la.textContent=el),or.forEach(i),cn=n(S),Y=o(S,"DIV",{class:!0});var rr=m(Y);c(We.$$.fragment,rr),gn=n(rr),sa=o(rr,"P",{"data-svelte-h":!0}),l(sa)!=="svelte-1y1oyzd"&&(sa.textContent=tl),rr.forEach(i),un=n(S),ee=o(S,"DIV",{class:!0});var nr=m(ee);c(je.$$.fragment,nr),fn=n(nr),ma=o(nr,"P",{"data-svelte-h":!0}),l(ma)!=="svelte-1gr03w4"&&(ma.textContent=al),nr.forEach(i),hn=n(S),te=o(S,"DIV",{class:!0});var ir=m(te);c(Qe.$$.fragment,ir),vn=n(ir),pa=o(ir,"P",{"data-svelte-h":!0}),l(pa)!=="svelte-1dbbmmp"&&(pa.textContent=ol),ir.forEach(i),S.forEach(i),Io=n(e),Ke=o(e,"DIV",{class:!0});var os=m(Ke);c(Ze.$$.fragment,os),os.forEach(i),Mo=n(e),q=o(e,"DIV",{class:!0});var ue=m(q);c(Xe.$$.fragment,ue),bn=n(ue),da=o(ue,"P",{"data-svelte-h":!0}),l(da)!=="svelte-1vdc41k"&&(da.textContent=rl),_n=n(ue),ca=o(ue,"P",{"data-svelte-h":!0}),l(ca)!=="svelte-1vkysjq"&&(ca.innerHTML=nl),yn=n(ue),ae=o(ue,"DIV",{class:!0});var lr=m(ae);c(Je.$$.fragment,lr),xn=n(lr),ga=o(lr,"P",{"data-svelte-h":!0}),l(ga)!=="svelte-1gr03w4"&&(ga.textContent=il),lr.forEach(i),ue.forEach(i),ko=n(e),R=o(e,"DIV",{class:!0});var Ya=m(R);c(Ye.$$.fragment,Ya),$n=n(Ya),ua=o(Ya,"P",{"data-svelte-h":!0}),l(ua)!=="svelte-bxurot"&&(ua.innerHTML=ll),wn=n(Ya),oe=o(Ya,"DIV",{class:!0});var sr=m(oe);c(et.$$.fragment,sr),Cn=n(sr),fa=o(sr,"P",{"data-svelte-h":!0}),l(fa)!=="svelte-1siu6mf"&&(fa.textContent=sl),sr.forEach(i),Ya.forEach(i),qo=n(e),I=o(e,"DIV",{class:!0});var W=m(I);c(tt.$$.fragment,W),Ln=n(W),ha=o(W,"P",{"data-svelte-h":!0}),l(ha)!=="svelte-d5zqgn"&&(ha.innerHTML=ml),Tn=n(W),va=o(W,"P",{"data-svelte-h":!0}),l(va)!=="svelte-9itjiu"&&(va.textContent=pl),An=n(W),ba=o(W,"UL",{"data-svelte-h":!0}),l(ba)!=="svelte-ylo4gl"&&(ba.innerHTML=dl),zn=n(W),re=o(W,"DIV",{class:!0});var mr=m(re);c(at.$$.fragment,mr),Dn=n(mr),_a=o(mr,"P",{"data-svelte-h":!0}),l(_a)!=="svelte-1gr03w4"&&(_a.textContent=cl),mr.forEach(i),W.forEach(i),Eo=n(e),E=o(e,"DIV",{class:!0});var fe=m(E);c(ot.$$.fragment,fe),Pn=n(fe),ya=o(fe,"P",{"data-svelte-h":!0}),l(ya)!=="svelte-1ky75u7"&&(ya.textContent=gl),In=n(fe),xa=o(fe,"P",{"data-svelte-h":!0}),l(xa)!=="svelte-ee3cwp"&&(xa.innerHTML=ul),Mn=n(fe),ne=o(fe,"DIV",{class:!0});var pr=m(ne);c(rt.$$.fragment,pr),kn=n(pr),$a=o(pr,"P",{"data-svelte-h":!0}),l($a)!=="svelte-1gr03w4"&&($a.textContent=fl),pr.forEach(i),fe.forEach(i),Oo=n(e),O=o(e,"DIV",{class:!0});var he=m(O);c(nt.$$.fragment,he),qn=n(he),wa=o(he,"P",{"data-svelte-h":!0}),l(wa)!=="svelte-vzcsb8"&&(wa.textContent=hl),En=n(he),Ca=o(he,"P",{"data-svelte-h":!0}),l(Ca)!=="svelte-euart9"&&(Ca.innerHTML=vl),On=n(he),ie=o(he,"DIV",{class:!0});var dr=m(ie);c(it.$$.fragment,dr),Fn=n(dr),La=o(dr,"P",{"data-svelte-h":!0}),l(La)!=="svelte-1gr03w4"&&(La.textContent=bl),dr.forEach(i),he.forEach(i),Fo=n(e),V=o(e,"DIV",{class:!0});var eo=m(V);c(lt.$$.fragment,eo),Nn=n(eo),Ta=o(eo,"P",{"data-svelte-h":!0}),l(Ta)!=="svelte-pwyp7b"&&(Ta.textContent=_l),Hn=n(eo),le=o(eo,"DIV",{class:!0});var cr=m(le);c(st.$$.fragment,cr),Sn=n(cr),Aa=o(cr,"P",{"data-svelte-h":!0}),l(Aa)!=="svelte-1gr03w4"&&(Aa.textContent=yl),cr.forEach(i),eo.forEach(i),No=n(e),mt=o(e,"DIV",{class:!0});var rs=m(mt);c(pt.$$.fragment,rs),rs.forEach(i),Ho=n(e),C=o(e,"DIV",{class:!0});var k=m(C);c(dt.$$.fragment,k),Bn=n(k),za=o(k,"P",{"data-svelte-h":!0}),l(za)!=="svelte-wmmdpx"&&(za.textContent=xl),Gn=n(k),Da=o(k,"P",{"data-svelte-h":!0}),l(Da)!=="svelte-12dyngi"&&(Da.innerHTML=$l),Rn=n(k),Pa=o(k,"P",{"data-svelte-h":!0}),l(Pa)!=="svelte-qjjdis"&&(Pa.textContent=wl),Vn=n(k),Ia=o(k,"P",{"data-svelte-h":!0}),l(Ia)!=="svelte-rosfou"&&(Ia.textContent=Cl),Un=n(k),Ma=o(k,"P",{"data-svelte-h":!0}),l(Ma)!=="svelte-hlwvkn"&&(Ma.textContent=Ll),Wn=n(k),se=o(k,"DIV",{class:!0});var gr=m(se);c(ct.$$.fragment,gr),jn=n(gr),ka=o(gr,"P",{"data-svelte-h":!0}),l(ka)!=="svelte-1gr03w4"&&(ka.textContent=Tl),gr.forEach(i),k.forEach(i),So=n(e),F=o(e,"DIV",{class:!0});var ve=m(F);c(gt.$$.fragment,ve),Qn=n(ve),qa=o(ve,"P",{"data-svelte-h":!0}),l(qa)!=="svelte-yn9hq2"&&(qa.textContent=Al),Kn=n(ve),Ea=o(ve,"P",{"data-svelte-h":!0}),l(Ea)!=="svelte-1l0d0b"&&(Ea.innerHTML=zl),Zn=n(ve),me=o(ve,"DIV",{class:!0});var ur=m(me);c(ut.$$.fragment,ur),Xn=n(ur),Oa=o(ur,"P",{"data-svelte-h":!0}),l(Oa)!=="svelte-1gr03w4"&&(Oa.textContent=Dl),ur.forEach(i),ve.forEach(i),Bo=n(e),z=o(e,"DIV",{class:!0});var B=m(z);c(ft.$$.fragment,B),Jn=n(B),Fa=o(B,"P",{"data-svelte-h":!0}),l(Fa)!=="svelte-3mtxcr"&&(Fa.textContent=Pl),Yn=n(B),Na=o(B,"P",{"data-svelte-h":!0}),l(Na)!=="svelte-1kok3gr"&&(Na.innerHTML=Il),ei=n(B),Ha=o(B,"P",{"data-svelte-h":!0}),l(Ha)!=="svelte-1usqxsj"&&(Ha.textContent=Ml),ti=n(B),Sa=o(B,"UL",{"data-svelte-h":!0}),l(Sa)!=="svelte-xfb8g2"&&(Sa.innerHTML=kl),ai=n(B),pe=o(B,"DIV",{class:!0});var fr=m(pe);c(ht.$$.fragment,fr),oi=n(fr),Ba=o(fr,"P",{"data-svelte-h":!0}),l(Ba)!=="svelte-1gr03w4"&&(Ba.textContent=ql),fr.forEach(i),B.forEach(i),Go=n(e),U=o(e,"DIV",{class:!0});var to=m(U);c(vt.$$.fragment,to),ri=n(to),Ga=o(to,"P",{"data-svelte-h":!0}),l(Ga)!=="svelte-5vv99d"&&(Ga.textContent=El),ni=n(to),de=o(to,"DIV",{class:!0});var hr=m(de);c(bt.$$.fragment,hr),ii=n(hr),Ra=o(hr,"P",{"data-svelte-h":!0}),l(Ra)!=="svelte-1gr03w4"&&(Ra.textContent=Ol),hr.forEach(i),to.forEach(i),Ro=n(e),x=o(e,"DIV",{class:!0});var P=m(x);c(_t.$$.fragment,P),li=n(P),Va=o(P,"P",{"data-svelte-h":!0}),l(Va)!=="svelte-1tqv0s5"&&(Va.textContent=Fl),si=n(P),Ua=o(P,"P",{"data-svelte-h":!0}),l(Ua)!=="svelte-g10xv4"&&(Ua.textContent=Nl),mi=n(P),Wa=o(P,"P",{"data-svelte-h":!0}),l(Wa)!=="svelte-1acg3vg"&&(Wa.textContent=Hl),pi=n(P),ja=o(P,"OL",{"data-svelte-h":!0}),l(ja)!=="svelte-15y6o6y"&&(ja.innerHTML=Sl),di=n(P),Qa=o(P,"P",{"data-svelte-h":!0}),l(Qa)!=="svelte-1yvkj2h"&&(Qa.innerHTML=Bl),ci=n(P),Ka=o(P,"P",{"data-svelte-h":!0}),l(Ka)!=="svelte-53x1ow"&&(Ka.innerHTML=Gl),gi=n(P),ce=o(P,"DIV",{class:!0});var vr=m(ce);c(yt.$$.fragment,vr),ui=n(vr),Za=o(vr,"P",{"data-svelte-h":!0}),l(Za)!=="svelte-1gr03w4"&&(Za.textContent=Rl),vr.forEach(i),P.forEach(i),Vo=n(e),xt=o(e,"DIV",{class:!0});var ns=m(xt);c($t.$$.fragment,ns),ns.forEach(i),Uo=n(e),K=o(e,"DIV",{class:!0});var br=m(K);c(wt.$$.fragment,br),fi=n(br),ge=o(br,"DIV",{class:!0});var _r=m(ge);c(Ct.$$.fragment,_r),hi=n(_r),Xa=o(_r,"P",{"data-svelte-h":!0}),l(Xa)!=="svelte-1gr03w4"&&(Xa.textContent=Vl),_r.forEach(i),br.forEach(i),Wo=n(e),c(Lt.$$.fragment,e),jo=n(e),ho=o(e,"P",{}),m(ho).forEach(i),this.h()},h(){v(Q,"name","hf:doc:metadata"),v(Q,"content",fs),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,Q),p(e,vo,s),p(e,ao,s),p(e,bo,s),g(be,e,s),p(e,_o,s),g(_e,e,s),p(e,yo,s),p(e,ye,s),p(e,xo,s),g(xe,e,s),p(e,$o,s),g($e,e,s),p(e,wo,s),p(e,_,s),g(we,_,null),t(_,yr),t(_,Tt),t(_,xr),t(_,At),t(_,$r),t(_,zt),t(_,wr),t(_,oo),t(oo,ro),t(ro,Ce),g(Le,Ce,null),t(Ce,Cr),t(Ce,Dt),t(_,Lr),t(_,no),t(no,io),t(io,Te),g(Ae,Te,null),t(Te,Tr),t(Te,Pt),t(_,Ar),t(_,lo),t(lo,so),t(so,ze),g(De,ze,null),t(ze,zr),t(ze,It),t(_,Dr),t(_,mo),t(mo,po),t(po,Pe),g(Ie,Pe,null),t(Pe,Pr),t(Pe,Mt),t(_,Ir),t(_,kt),t(_,Mr),t(_,qt),p(e,Co,s),p(e,y,s),g(Me,y,null),t(y,kr),t(y,Et),t(y,qr),t(y,Ot),t(y,Er),t(y,Ft),t(y,Or),t(y,Nt),t(y,Fr),t(y,Ht),t(y,Nr),t(y,St),t(y,Hr),t(y,Bt),p(e,Lo,s),p(e,L,s),g(ke,L,null),t(L,Sr),t(L,Gt),t(L,Br),t(L,Rt),t(L,Gr),t(L,Vt),t(L,Rr),t(L,co),t(co,go),t(go,qe),g(Ee,qe,null),t(qe,Vr),t(qe,Ut),t(L,Ur),t(L,uo),t(uo,fo),t(fo,Oe),g(Fe,Oe,null),t(Oe,Wr),t(Oe,Wt),p(e,To,s),g(Ne,e,s),p(e,Ao,s),p(e,T,s),g(He,T,null),t(T,jr),t(T,jt),t(T,Qr),t(T,Qt),t(T,Kr),t(T,Kt),t(T,Zr),t(T,Zt),t(T,Xr),t(T,Z),g(Se,Z,null),t(Z,Jr),t(Z,Xt),p(e,zo,s),p(e,w,s),g(Be,w,null),t(w,Yr),t(w,Jt),t(w,en),t(w,Yt),t(w,tn),t(w,ea),t(w,an),t(w,ta),t(w,on),t(w,aa),t(w,rn),t(w,X),g(Ge,X,null),t(X,nn),t(X,oa),p(e,Do,s),p(e,G,s),g(Re,G,null),t(G,ln),t(G,ra),t(G,sn),t(G,na),p(e,Po,s),p(e,A,s),g(Ve,A,null),t(A,mn),t(A,ia),t(A,pn),t(A,J),g(Ue,J,null),t(J,dn),t(J,la),t(A,cn),t(A,Y),g(We,Y,null),t(Y,gn),t(Y,sa),t(A,un),t(A,ee),g(je,ee,null),t(ee,fn),t(ee,ma),t(A,hn),t(A,te),g(Qe,te,null),t(te,vn),t(te,pa),p(e,Io,s),p(e,Ke,s),g(Ze,Ke,null),p(e,Mo,s),p(e,q,s),g(Xe,q,null),t(q,bn),t(q,da),t(q,_n),t(q,ca),t(q,yn),t(q,ae),g(Je,ae,null),t(ae,xn),t(ae,ga),p(e,ko,s),p(e,R,s),g(Ye,R,null),t(R,$n),t(R,ua),t(R,wn),t(R,oe),g(et,oe,null),t(oe,Cn),t(oe,fa),p(e,qo,s),p(e,I,s),g(tt,I,null),t(I,Ln),t(I,ha),t(I,Tn),t(I,va),t(I,An),t(I,ba),t(I,zn),t(I,re),g(at,re,null),t(re,Dn),t(re,_a),p(e,Eo,s),p(e,E,s),g(ot,E,null),t(E,Pn),t(E,ya),t(E,In),t(E,xa),t(E,Mn),t(E,ne),g(rt,ne,null),t(ne,kn),t(ne,$a),p(e,Oo,s),p(e,O,s),g(nt,O,null),t(O,qn),t(O,wa),t(O,En),t(O,Ca),t(O,On),t(O,ie),g(it,ie,null),t(ie,Fn),t(ie,La),p(e,Fo,s),p(e,V,s),g(lt,V,null),t(V,Nn),t(V,Ta),t(V,Hn),t(V,le),g(st,le,null),t(le,Sn),t(le,Aa),p(e,No,s),p(e,mt,s),g(pt,mt,null),p(e,Ho,s),p(e,C,s),g(dt,C,null),t(C,Bn),t(C,za),t(C,Gn),t(C,Da),t(C,Rn),t(C,Pa),t(C,Vn),t(C,Ia),t(C,Un),t(C,Ma),t(C,Wn),t(C,se),g(ct,se,null),t(se,jn),t(se,ka),p(e,So,s),p(e,F,s),g(gt,F,null),t(F,Qn),t(F,qa),t(F,Kn),t(F,Ea),t(F,Zn),t(F,me),g(ut,me,null),t(me,Xn),t(me,Oa),p(e,Bo,s),p(e,z,s),g(ft,z,null),t(z,Jn),t(z,Fa),t(z,Yn),t(z,Na),t(z,ei),t(z,Ha),t(z,ti),t(z,Sa),t(z,ai),t(z,pe),g(ht,pe,null),t(pe,oi),t(pe,Ba),p(e,Go,s),p(e,U,s),g(vt,U,null),t(U,ri),t(U,Ga),t(U,ni),t(U,de),g(bt,de,null),t(de,ii),t(de,Ra),p(e,Ro,s),p(e,x,s),g(_t,x,null),t(x,li),t(x,Va),t(x,si),t(x,Ua),t(x,mi),t(x,Wa),t(x,pi),t(x,ja),t(x,di),t(x,Qa),t(x,ci),t(x,Ka),t(x,gi),t(x,ce),g(yt,ce,null),t(ce,ui),t(ce,Za),p(e,Vo,s),p(e,xt,s),g($t,xt,null),p(e,Uo,s),p(e,K,s),g(wt,K,null),t(K,fi),t(K,ge),g(Ct,ge,null),t(ge,hi),t(ge,Xa),p(e,Wo,s),g(Lt,e,s),p(e,jo,s),p(e,ho,s),Qo=!0},p:ls,i(e){Qo||(u(be.$$.fragment,e),u(_e.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(we.$$.fragment,e),u(Le.$$.fragment,e),u(Ae.$$.fragment,e),u(De.$$.fragment,e),u(Ie.$$.fragment,e),u(Me.$$.fragment,e),u(ke.$$.fragment,e),u(Ee.$$.fragment,e),u(Fe.$$.fragment,e),u(Ne.$$.fragment,e),u(He.$$.fragment,e),u(Se.$$.fragment,e),u(Be.$$.fragment,e),u(Ge.$$.fragment,e),u(Re.$$.fragment,e),u(Ve.$$.fragment,e),u(Ue.$$.fragment,e),u(We.$$.fragment,e),u(je.$$.fragment,e),u(Qe.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Je.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(ot.$$.fragment,e),u(rt.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),u(lt.$$.fragment,e),u(st.$$.fragment,e),u(pt.$$.fragment,e),u(dt.$$.fragment,e),u(ct.$$.fragment,e),u(gt.$$.fragment,e),u(ut.$$.fragment,e),u(ft.$$.fragment,e),u(ht.$$.fragment,e),u(vt.$$.fragment,e),u(bt.$$.fragment,e),u(_t.$$.fragment,e),u(yt.$$.fragment,e),u($t.$$.fragment,e),u(wt.$$.fragment,e),u(Ct.$$.fragment,e),u(Lt.$$.fragment,e),Qo=!0)},o(e){f(be.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(we.$$.fragment,e),f(Le.$$.fragment,e),f(Ae.$$.fragment,e),f(De.$$.fragment,e),f(Ie.$$.fragment,e),f(Me.$$.fragment,e),f(ke.$$.fragment,e),f(Ee.$$.fragment,e),f(Fe.$$.fragment,e),f(Ne.$$.fragment,e),f(He.$$.fragment,e),f(Se.$$.fragment,e),f(Be.$$.fragment,e),f(Ge.$$.fragment,e),f(Re.$$.fragment,e),f(Ve.$$.fragment,e),f(Ue.$$.fragment,e),f(We.$$.fragment,e),f(je.$$.fragment,e),f(Qe.$$.fragment,e),f(Ze.$$.fragment,e),f(Xe.$$.fragment,e),f(Je.$$.fragment,e),f(Ye.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(ot.$$.fragment,e),f(rt.$$.fragment,e),f(nt.$$.fragment,e),f(it.$$.fragment,e),f(lt.$$.fragment,e),f(st.$$.fragment,e),f(pt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(gt.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(ht.$$.fragment,e),f(vt.$$.fragment,e),f(bt.$$.fragment,e),f(_t.$$.fragment,e),f(yt.$$.fragment,e),f($t.$$.fragment,e),f(wt.$$.fragment,e),f(Ct.$$.fragment,e),f(Lt.$$.fragment,e),Qo=!1},d(e){e&&(i(vo),i(ao),i(bo),i(_o),i(yo),i(ye),i(xo),i($o),i(wo),i(_),i(Co),i(y),i(Lo),i(L),i(To),i(Ao),i(T),i(zo),i(w),i(Do),i(G),i(Po),i(A),i(Io),i(Ke),i(Mo),i(q),i(ko),i(R),i(qo),i(I),i(Eo),i(E),i(Oo),i(O),i(Fo),i(V),i(No),i(mt),i(Ho),i(C),i(So),i(F),i(Bo),i(z),i(Go),i(U),i(Ro),i(x),i(Vo),i(xt),i(Uo),i(K),i(Wo),i(jo),i(ho)),i(Q),h(be,e),h(_e,e),h(xe,e),h($e,e),h(we),h(Le),h(Ae),h(De),h(Ie),h(Me),h(ke),h(Ee),h(Fe),h(Ne,e),h(He),h(Se),h(Be),h(Ge),h(Re),h(Ve),h(Ue),h(We),h(je),h(Qe),h(Ze),h(Xe),h(Je),h(Ye),h(et),h(tt),h(at),h(ot),h(rt),h(nt),h(it),h(lt),h(st),h(pt),h(dt),h(ct),h(gt),h(ut),h(ft),h(ht),h(vt),h(bt),h(_t),h(yt),h($t),h(wt),h(Ct),h(Lt,e)}}}const fs='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizers","local":"optimizers","sections":[{"title":"Factory functions","local":"timm.optim.create_optimizer_v2","sections":[],"depth":3}],"depth":2}],"depth":1}';function hs(vi){return ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xs extends ms{constructor(Q){super(),ps(this,Q,hs,us,is,{})}}export{xs as component};
