import{s as kt,n as Bt,o as Gt}from"../chunks/scheduler.0b596ca5.js";import{S as vt,i as Nt,e as p,s as a,c as m,h as Et,a as i,d as e,b as n,f as xt,g as o,j as g,k as Ct,l as _t,m as l,n as r,t as c,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Qt,H,E as Yt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as X}from"../chunks/CodeBlock.9f18e41e.js";function Xt(wt){let J,z,V,F,d,S,w,A,y,yt="<strong>AdvProp</strong> is an adversarial training scheme which treats adversarial examples as additional examples, to prevent overfitting. Key to the method is the usage of a separate auxiliary batch norm for adversarial examples, as they have different underlying distributions to normal examples.",L,T,Tt='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',P,f,q,j,ft="To load a pretrained model:",D,u,K,b,jt="To load and preprocess the image:",O,U,tt,I,ut="To get the model predictions:",st,$,et,W,bt="To get the top-5 predictions class names:",lt,Z,at,x,Ut="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_b0_ap</code>. You can find the IDs in the model summaries at the top of this page.",nt,C,It='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,k,it,B,$t="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",mt,G,ot,v,Wt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,rt,N,ct,E,Zt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ht,_,Mt,Q,gt,Y,Jt,R,dt;return d=new Qt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new H({props:{title:"AdvProp (EfficientNet)",local:"advprop-efficientnet",headingTag:"h1"}}),f=new H({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9iMF9hcCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ap&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new H({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2IwX2FwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ap&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new H({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),_=new H({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new X({props:{code:"JTQwbWlzYyU3QnhpZTIwMjBhZHZlcnNhcmlhbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCQWR2ZXJzYXJpYWwlMjBFeGFtcGxlcyUyMEltcHJvdmUlMjBJbWFnZSUyMFJlY29nbml0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2loYW5nJTIwWGllJTIwYW5kJTIwTWluZ3hpbmclMjBUYW4lMjBhbmQlMjBCb3FpbmclMjBHb25nJTIwYW5kJTIwSmlhbmclMjBXYW5nJTIwYW5kJTIwQWxhbiUyMFl1aWxsZSUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTExLjA5NjY1JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{xie2020adversarial,
      title={Adversarial Examples Improve Image Recognition}, 
      author={Cihang Xie <span class="hljs-keyword">and </span>Mingxing Tan <span class="hljs-keyword">and </span><span class="hljs-keyword">Boqing </span>Gong <span class="hljs-keyword">and </span><span class="hljs-keyword">Jiang </span>Wang <span class="hljs-keyword">and </span>Alan Yuille <span class="hljs-keyword">and </span>Quoc V. Le},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">1911</span>.<span class="hljs-number">09665</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Y=new Yt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/advprop.mdx"}}),{c(){J=p("meta"),z=a(),V=p("p"),F=a(),m(d.$$.fragment),S=a(),m(w.$$.fragment),A=a(),y=p("p"),y.innerHTML=yt,L=a(),T=p("p"),T.innerHTML=Tt,P=a(),m(f.$$.fragment),q=a(),j=p("p"),j.textContent=ft,D=a(),m(u.$$.fragment),K=a(),b=p("p"),b.textContent=jt,O=a(),m(U.$$.fragment),tt=a(),I=p("p"),I.textContent=ut,st=a(),m($.$$.fragment),et=a(),W=p("p"),W.textContent=bt,lt=a(),m(Z.$$.fragment),at=a(),x=p("p"),x.innerHTML=Ut,nt=a(),C=p("p"),C.innerHTML=It,pt=a(),m(k.$$.fragment),it=a(),B=p("p"),B.textContent=$t,mt=a(),m(G.$$.fragment),ot=a(),v=p("p"),v.innerHTML=Wt,rt=a(),m(N.$$.fragment),ct=a(),E=p("p"),E.innerHTML=Zt,ht=a(),m(_.$$.fragment),Mt=a(),m(Q.$$.fragment),gt=a(),m(Y.$$.fragment),Jt=a(),R=p("p"),this.h()},l(t){const s=Et("svelte-u9bgzb",document.head);J=i(s,"META",{name:!0,content:!0}),s.forEach(e),z=n(t),V=i(t,"P",{}),xt(V).forEach(e),F=n(t),o(d.$$.fragment,t),S=n(t),o(w.$$.fragment,t),A=n(t),y=i(t,"P",{"data-svelte-h":!0}),g(y)!=="svelte-1x6a5c1"&&(y.innerHTML=yt),L=n(t),T=i(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-k8hpf1"&&(T.innerHTML=Tt),P=n(t),o(f.$$.fragment,t),q=n(t),j=i(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-18ywhxh"&&(j.textContent=ft),D=n(t),o(u.$$.fragment,t),K=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1c2ipa8"&&(b.textContent=jt),O=n(t),o(U.$$.fragment,t),tt=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-1n9qsq1"&&(I.textContent=ut),st=n(t),o($.$$.fragment,t),et=n(t),W=i(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-19cnvx1"&&(W.textContent=bt),lt=n(t),o(Z.$$.fragment,t),at=n(t),x=i(t,"P",{"data-svelte-h":!0}),g(x)!=="svelte-m13wpe"&&(x.innerHTML=Ut),nt=n(t),C=i(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1wmi3ea"&&(C.innerHTML=It),pt=n(t),o(k.$$.fragment,t),it=n(t),B=i(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-9sr7nh"&&(B.textContent=$t),mt=n(t),o(G.$$.fragment,t),ot=n(t),v=i(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-1kguc51"&&(v.innerHTML=Wt),rt=n(t),o(N.$$.fragment,t),ct=n(t),E=i(t,"P",{"data-svelte-h":!0}),g(E)!=="svelte-xtxxu6"&&(E.innerHTML=Zt),ht=n(t),o(_.$$.fragment,t),Mt=n(t),o(Q.$$.fragment,t),gt=n(t),o(Y.$$.fragment,t),Jt=n(t),R=i(t,"P",{}),xt(R).forEach(e),this.h()},h(){Ct(J,"name","hf:doc:metadata"),Ct(J,"content",Vt)},m(t,s){_t(document.head,J),l(t,z,s),l(t,V,s),l(t,F,s),r(d,t,s),l(t,S,s),r(w,t,s),l(t,A,s),l(t,y,s),l(t,L,s),l(t,T,s),l(t,P,s),r(f,t,s),l(t,q,s),l(t,j,s),l(t,D,s),r(u,t,s),l(t,K,s),l(t,b,s),l(t,O,s),r(U,t,s),l(t,tt,s),l(t,I,s),l(t,st,s),r($,t,s),l(t,et,s),l(t,W,s),l(t,lt,s),r(Z,t,s),l(t,at,s),l(t,x,s),l(t,nt,s),l(t,C,s),l(t,pt,s),r(k,t,s),l(t,it,s),l(t,B,s),l(t,mt,s),r(G,t,s),l(t,ot,s),l(t,v,s),l(t,rt,s),r(N,t,s),l(t,ct,s),l(t,E,s),l(t,ht,s),r(_,t,s),l(t,Mt,s),r(Q,t,s),l(t,gt,s),r(Y,t,s),l(t,Jt,s),l(t,R,s),dt=!0},p:Bt,i(t){dt||(c(d.$$.fragment,t),c(w.$$.fragment,t),c(f.$$.fragment,t),c(u.$$.fragment,t),c(U.$$.fragment,t),c($.$$.fragment,t),c(Z.$$.fragment,t),c(k.$$.fragment,t),c(G.$$.fragment,t),c(N.$$.fragment,t),c(_.$$.fragment,t),c(Q.$$.fragment,t),c(Y.$$.fragment,t),dt=!0)},o(t){h(d.$$.fragment,t),h(w.$$.fragment,t),h(f.$$.fragment,t),h(u.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(Z.$$.fragment,t),h(k.$$.fragment,t),h(G.$$.fragment,t),h(N.$$.fragment,t),h(_.$$.fragment,t),h(Q.$$.fragment,t),h(Y.$$.fragment,t),dt=!1},d(t){t&&(e(z),e(V),e(F),e(S),e(A),e(y),e(L),e(T),e(P),e(q),e(j),e(D),e(K),e(b),e(O),e(tt),e(I),e(st),e(et),e(W),e(lt),e(at),e(x),e(nt),e(C),e(pt),e(it),e(B),e(mt),e(ot),e(v),e(rt),e(ct),e(E),e(ht),e(Mt),e(gt),e(Jt),e(R)),e(J),M(d,t),M(w,t),M(f,t),M(u,t),M(U,t),M($,t),M(Z,t),M(k,t),M(G,t),M(N,t),M(_,t),M(Q,t),M(Y,t)}}}const Vt='{"title":"AdvProp (EfficientNet)","local":"advprop-efficientnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Rt(wt){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends vt{constructor(J){super(),Nt(this,J,Rt,Xt,kt,{})}}export{At as component};
