# Data[[timm.data.create_dataset]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>timm.data.create_dataset</name><anchor>timm.data.create_dataset</anchor><source>https://github.com/huggingface/pytorch-image-models/blob/main/timm/data/dataset_factory.py#L63</source><parameters>[{"name": "name", "val": ": str"}, {"name": "root", "val": ": typing.Optional[str] = None"}, {"name": "split", "val": ": str = 'validation'"}, {"name": "search_split", "val": ": bool = True"}, {"name": "class_map", "val": ": dict = None"}, {"name": "load_bytes", "val": ": bool = False"}, {"name": "is_training", "val": ": bool = False"}, {"name": "download", "val": ": bool = False"}, {"name": "batch_size", "val": ": int = 1"}, {"name": "num_samples", "val": ": typing.Optional[int] = None"}, {"name": "seed", "val": ": int = 42"}, {"name": "repeats", "val": ": int = 0"}, {"name": "input_img_mode", "val": ": str = 'RGB'"}, {"name": "trust_remote_code", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **name** -- Dataset name, empty is okay for folder based datasets
- **root** -- Root folder of dataset (All)
- **split** -- Dataset split (All)
- **search_split** -- Search for split specific child fold from root so one can specify
  `imagenet/` instead of `/imagenet/val`, etc on cmd line / config. (Folder, Torch)
- **class_map** -- Specify class -> index mapping via text file or dict (Folder)
- **load_bytes** -- Load data, return images as undecoded bytes (Folder)
- **download** -- Download dataset if not present and supported (HFIDS, TFDS, Torch)
- **is_training** -- Create dataset in train mode, this is different from the split.
  For Iterable / TDFS it enables shuffle, ignored for other datasets. (TFDS, WDS, HFIDS)
- **batch_size** -- Batch size hint for iterable datasets (TFDS, WDS, HFIDS)
- **seed** -- Seed for iterable datasets (TFDS, WDS, HFIDS)
- **repeats** -- Dataset repeats per iteration i.e. epoch (TFDS, WDS, HFIDS)
- **input_img_mode** -- Input image color conversion mode e.g. 'RGB', 'L' (folder, TFDS, WDS, HFDS, HFIDS)
- **trust_remote_code** -- Trust remote code in Hugging Face Datasets if True (HFDS, HFIDS)
- ****kwargs** -- Other args to pass through to underlying Dataset and/or Reader classes</paramsdesc><paramgroups>0</paramgroups><retdesc>Dataset object</retdesc></docstring>
Dataset factory method

In parentheses after each arg are the type of dataset supported for each arg, one of:
* Folder - default, timm folder (or tar) based ImageDataset
* Torch - torchvision based datasets
* HFDS - Hugging Face Datasets
* HFIDS - Hugging Face Datasets Iterable (streaming mode, with IterableDataset)
* TFDS - Tensorflow-datasets wrapper in IterabeDataset interface via IterableImageDataset
* WDS - Webdataset
* All - any of the above






</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>timm.data.create_loader</name><anchor>timm.data.create_loader</anchor><source>https://github.com/huggingface/pytorch-image-models/blob/main/timm/data/loader.py#L200</source><parameters>[{"name": "dataset", "val": ": typing.Union[timm.data.dataset.ImageDataset, timm.data.dataset.IterableImageDataset]"}, {"name": "input_size", "val": ": typing.Union[int, typing.Tuple[int, int], typing.Tuple[int, int, int]]"}, {"name": "batch_size", "val": ": int"}, {"name": "is_training", "val": ": bool = False"}, {"name": "no_aug", "val": ": bool = False"}, {"name": "re_prob", "val": ": float = 0.0"}, {"name": "re_mode", "val": ": str = 'const'"}, {"name": "re_count", "val": ": int = 1"}, {"name": "re_split", "val": ": bool = False"}, {"name": "train_crop_mode", "val": ": typing.Optional[str] = None"}, {"name": "scale", "val": ": typing.Optional[typing.Tuple[float, float]] = None"}, {"name": "ratio", "val": ": typing.Optional[typing.Tuple[float, float]] = None"}, {"name": "hflip", "val": ": float = 0.5"}, {"name": "vflip", "val": ": float = 0.0"}, {"name": "color_jitter", "val": ": float = 0.4"}, {"name": "color_jitter_prob", "val": ": typing.Optional[float] = None"}, {"name": "grayscale_prob", "val": ": float = 0.0"}, {"name": "gaussian_blur_prob", "val": ": float = 0.0"}, {"name": "auto_augment", "val": ": typing.Optional[str] = None"}, {"name": "num_aug_repeats", "val": ": int = 0"}, {"name": "num_aug_splits", "val": ": int = 0"}, {"name": "interpolation", "val": ": str = 'bilinear'"}, {"name": "mean", "val": ": typing.Tuple[float, ...] = (0.485, 0.456, 0.406)"}, {"name": "std", "val": ": typing.Tuple[float, ...] = (0.229, 0.224, 0.225)"}, {"name": "num_workers", "val": ": int = 1"}, {"name": "distributed", "val": ": bool = False"}, {"name": "crop_pct", "val": ": typing.Optional[float] = None"}, {"name": "crop_mode", "val": ": typing.Optional[str] = None"}, {"name": "crop_border_pixels", "val": ": typing.Optional[int] = None"}, {"name": "collate_fn", "val": ": typing.Optional[typing.Callable] = None"}, {"name": "pin_memory", "val": ": bool = False"}, {"name": "fp16", "val": ": bool = False"}, {"name": "img_dtype", "val": ": dtype = torch.float32"}, {"name": "device", "val": ": device = device(type='cuda')"}, {"name": "use_prefetcher", "val": ": bool = True"}, {"name": "use_multi_epochs_loader", "val": ": bool = False"}, {"name": "persistent_workers", "val": ": bool = True"}, {"name": "worker_seeding", "val": ": str = 'all'"}, {"name": "tf_preprocessing", "val": ": bool = False"}]</parameters><paramsdesc>- **dataset** -- The image dataset to load.
- **input_size** -- Target input size (channels, height, width) tuple or size scalar.
- **batch_size** -- Number of samples in a batch.
- **is_training** -- Return training (random) transforms.
- **no_aug** -- Disable augmentation for training (useful for debug).
- **re_prob** -- Random erasing probability.
- **re_mode** -- Random erasing fill mode.
- **re_count** -- Number of random erasing regions.
- **re_split** -- Control split of random erasing across batch size.
- **scale** -- Random resize scale range (crop area, < 1.0 => zoom in).
- **ratio** -- Random aspect ratio range (crop ratio for RRC, ratio adjustment factor for RKR).
- **hflip** -- Horizontal flip probability.
- **vflip** -- Vertical flip probability.
- **color_jitter** -- Random color jitter component factors (brightness, contrast, saturation, hue).
  Scalar is applied as (scalar,) * 3 (no hue).
- **color_jitter_prob** -- Apply color jitter with this probability if not None (for SimlCLR-like aug
- **grayscale_prob** -- Probability of converting image to grayscale (for SimCLR-like aug).
- **gaussian_blur_prob** -- Probability of applying gaussian blur (for SimCLR-like aug).
- **auto_augment** -- Auto augment configuration string (see auto_augment.py).
- **num_aug_repeats** -- Enable special sampler to repeat same augmentation across distributed GPUs.
- **num_aug_splits** -- Enable mode where augmentations can be split across the batch.
- **interpolation** -- Image interpolation mode.
- **mean** -- Image normalization mean.
- **std** -- Image normalization standard deviation.
- **num_workers** -- Num worker processes per DataLoader.
- **distributed** -- Enable dataloading for distributed training.
- **crop_pct** -- Inference crop percentage (output size / resize size).
- **crop_mode** -- Inference crop mode. One of ['squash', 'border', 'center']. Defaults to 'center' when None.
- **crop_border_pixels** -- Inference crop border of specified # pixels around edge of original image.
- **collate_fn** -- Override default collate_fn.
- **pin_memory** -- Pin memory for device transfer.
- **fp16** -- Deprecated argument for half-precision input dtype. Use img_dtype.
- **img_dtype** -- Data type for input image.
- **device** -- Device to transfer inputs and targets to.
- **use_prefetcher** -- Use efficient pre-fetcher to load samples onto device.
- **use_multi_epochs_loader** --
- **persistent_workers** -- Enable persistent worker processes.
- **worker_seeding** -- Control worker random seeding at init.
- **tf_preprocessing** -- Use TF 1.0 inference preprocessing for testing model ports.</paramsdesc><paramgroups>0</paramgroups><retdesc>DataLoader</retdesc></docstring>







</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>timm.data.create_transform</name><anchor>timm.data.create_transform</anchor><source>https://github.com/huggingface/pytorch-image-models/blob/main/timm/data/transforms_factory.py#L377</source><parameters>[{"name": "input_size", "val": ": typing.Union[int, typing.Tuple[int, int], typing.Tuple[int, int, int]] = 224"}, {"name": "is_training", "val": ": bool = False"}, {"name": "no_aug", "val": ": bool = False"}, {"name": "train_crop_mode", "val": ": typing.Optional[str] = None"}, {"name": "scale", "val": ": typing.Optional[typing.Tuple[float, float]] = None"}, {"name": "ratio", "val": ": typing.Optional[typing.Tuple[float, float]] = None"}, {"name": "hflip", "val": ": float = 0.5"}, {"name": "vflip", "val": ": float = 0.0"}, {"name": "color_jitter", "val": ": typing.Union[float, typing.Tuple[float, ...]] = 0.4"}, {"name": "color_jitter_prob", "val": ": typing.Optional[float] = None"}, {"name": "grayscale_prob", "val": ": float = 0.0"}, {"name": "gaussian_blur_prob", "val": ": float = 0.0"}, {"name": "auto_augment", "val": ": typing.Optional[str] = None"}, {"name": "interpolation", "val": ": str = 'bilinear'"}, {"name": "mean", "val": ": typing.Tuple[float, ...] = (0.485, 0.456, 0.406)"}, {"name": "std", "val": ": typing.Tuple[float, ...] = (0.229, 0.224, 0.225)"}, {"name": "re_prob", "val": ": float = 0.0"}, {"name": "re_mode", "val": ": str = 'const'"}, {"name": "re_count", "val": ": int = 1"}, {"name": "re_num_splits", "val": ": int = 0"}, {"name": "crop_pct", "val": ": typing.Optional[float] = None"}, {"name": "crop_mode", "val": ": typing.Optional[str] = None"}, {"name": "crop_border_pixels", "val": ": typing.Optional[int] = None"}, {"name": "tf_preprocessing", "val": ": bool = False"}, {"name": "use_prefetcher", "val": ": bool = False"}, {"name": "normalize", "val": ": bool = True"}, {"name": "separate", "val": ": bool = False"}, {"name": "naflex", "val": ": bool = False"}, {"name": "patch_size", "val": ": typing.Union[int, typing.Tuple[int, int]] = 16"}, {"name": "max_seq_len", "val": ": int = 576"}, {"name": "patchify", "val": ": bool = False"}]</parameters><paramsdesc>- **input_size** -- Target input size (channels, height, width) tuple or size scalar.
- **is_training** -- Return training (random) transforms.
- **no_aug** -- Disable augmentation for training (useful for debug).
- **train_crop_mode** -- Training random crop mode ('rrc', 'rkrc', 'rkrr').
- **scale** -- Random resize scale range (crop area, < 1.0 => zoom in).
- **ratio** -- Random aspect ratio range (crop ratio for RRC, ratio adjustment factor for RKR).
- **hflip** -- Horizontal flip probability.
- **vflip** -- Vertical flip probability.
- **color_jitter** -- Random color jitter component factors (brightness, contrast, saturation, hue).
  Scalar is applied as (scalar,) * 3 (no hue).
- **color_jitter_prob** -- Apply color jitter with this probability if not None (for SimlCLR-like aug).
- **grayscale_prob** -- Probability of converting image to grayscale (for SimCLR-like aug).
- **gaussian_blur_prob** -- Probability of applying gaussian blur (for SimCLR-like aug).
- **auto_augment** -- Auto augment configuration string (see auto_augment.py).
- **interpolation** -- Image interpolation mode.
- **mean** -- Image normalization mean.
- **std** -- Image normalization standard deviation.
- **re_prob** -- Random erasing probability.
- **re_mode** -- Random erasing fill mode.
- **re_count** -- Number of random erasing regions.
- **re_num_splits** -- Control split of random erasing across batch size.
- **crop_pct** -- Inference crop percentage (output size / resize size).
- **crop_mode** -- Inference crop mode. One of ['squash', 'border', 'center']. Defaults to 'center' when None.
- **crop_border_pixels** -- Inference crop border of specified # pixels around edge of original image.
- **tf_preprocessing** -- Use TF 1.0 inference preprocessing for testing model ports
- **use_prefetcher** -- Pre-fetcher enabled. Do not convert image to tensor or normalize.
- **normalize** -- Normalization tensor output w/ provided mean/std (if prefetcher not used).
- **separate** -- Output transforms in 3-stage tuple.</paramsdesc><paramgroups>0</paramgroups><retdesc>Composed transforms or tuple thereof</retdesc></docstring>







</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>timm.data.resolve_data_config</name><anchor>timm.data.resolve_data_config</anchor><source>https://github.com/huggingface/pytorch-image-models/blob/main/timm/data/config.py#L8</source><parameters>[{"name": "args", "val": " = None"}, {"name": "pretrained_cfg", "val": " = None"}, {"name": "model", "val": " = None"}, {"name": "use_test_size", "val": " = False"}, {"name": "verbose", "val": " = False"}]</parameters></docstring>


</div>

<EditOnGithub source="https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/data.mdx" />