# Models[[timm.create_model]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>timm.create_model</name><anchor>timm.create_model</anchor><source>https://github.com/huggingface/pytorch-image-models/blob/main/timm/models/_factory.py#L44</source><parameters>[{"name": "model_name", "val": ": str"}, {"name": "pretrained", "val": ": bool = False"}, {"name": "pretrained_cfg", "val": ": typing.Union[str, typing.Dict[str, typing.Any], timm.models._pretrained.PretrainedCfg, NoneType] = None"}, {"name": "pretrained_cfg_overlay", "val": ": typing.Optional[typing.Dict[str, typing.Any]] = None"}, {"name": "checkpoint_path", "val": ": typing.Union[str, pathlib.Path, NoneType] = None"}, {"name": "cache_dir", "val": ": typing.Union[str, pathlib.Path, NoneType] = None"}, {"name": "scriptable", "val": ": typing.Optional[bool] = None"}, {"name": "exportable", "val": ": typing.Optional[bool] = None"}, {"name": "no_jit", "val": ": typing.Optional[bool] = None"}, {"name": "**kwargs", "val": ": typing.Any"}]</parameters><paramsdesc>- **model_name** -- Name of model to instantiate.
- **pretrained** -- If set to *True*, load pretrained ImageNet-1k weights.
- **pretrained_cfg** -- Pass in an external pretrained_cfg for model.
- **pretrained_cfg_overlay** -- Replace key-values in base pretrained_cfg with these.
- **checkpoint_path** -- Path of checkpoint to load _after_ the model is initialized.
- **cache_dir** -- Override model cache dir for Hugging Face Hub and Torch checkpoints.
- **scriptable** -- Set layer config so that model is jit scriptable (not working for all models yet).
- **exportable** -- Set layer config so that model is traceable / ONNX exportable (not fully impl/obeyed yet).
- **no_jit** -- Set layer config so that model doesn't utilize jit scripted layers (so far activations only).</paramsdesc><paramgroups>0</paramgroups></docstring>
Create a model.

Lookup model's entrypoint function and pass relevant args to create a new model.

Tip:
**kwargs will be passed through entrypoint fn to `timm.models.build_model_with_cfg()`
and then the model class __init__(). kwargs values set to None are pruned before passing.



Keyword Args:
drop_rate (float): Classifier dropout rate for training.
drop_path_rate (float): Stochastic depth drop rate for training.
global_pool (str): Classifier global pooling type.

<ExampleCodeBlock anchor="timm.create_model.example">

Example:

```py
>>> from timm import create_model

>>> # Create a MobileNetV3-Large model with no pretrained weights.
>>> model = create_model('mobilenetv3_large_100')

>>> # Create a MobileNetV3-Large model with pretrained weights.
>>> model = create_model('mobilenetv3_large_100', pretrained=True)
>>> model.num_classes
1000

>>> # Create a MobileNetV3-Large model with pretrained weights and a new head with 10 classes.
>>> model = create_model('mobilenetv3_large_100', pretrained=True, num_classes=10)
>>> model.num_classes
10

>>> # Create a Dinov2 small model with pretrained weights and save weights in a custom directory.
>>> model = create_model('vit_small_patch14_dinov2.lvd142m', pretrained=True, cache_dir="/data/my-models")
>>> # Data will be stored at */data/my-models/models--timm--vit_small_patch14_dinov2.lvd142m/*
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>timm.list_models</name><anchor>timm.list_models</anchor><source>https://github.com/huggingface/pytorch-image-models/blob/main/timm/models/_registry.py#L185</source><parameters>[{"name": "filter", "val": ": typing.Union[str, typing.List[str]] = ''"}, {"name": "module", "val": ": typing.Union[str, typing.List[str]] = ''"}, {"name": "pretrained", "val": ": bool = False"}, {"name": "exclude_filters", "val": ": typing.Union[str, typing.List[str]] = ''"}, {"name": "name_matches_cfg", "val": ": bool = False"}, {"name": "include_tags", "val": ": typing.Optional[bool] = None"}]</parameters><paramsdesc>- **filter** - Wildcard filter string that works with fnmatch --
- **module** - Limit model selection to a specific submodule (ie 'vision_transformer') --
- **pretrained** - Include only models with valid pretrained weights if True --
- **exclude_filters** - Wildcard filters to exclude models after including them with filter --
- **name_matches_cfg** - Include only models w/ model_name matching default_cfg name (excludes some aliases) --
- **include_tags** - Include pretrained tags in model names (model.tag). If None, defaults --
  set to True when pretrained=True else False (default: None)</paramsdesc><paramgroups>0</paramgroups><retdesc>models - The sorted list of models</retdesc></docstring>
Return list of available model names, sorted alphabetically





Example:
model_list('gluon_resnet*') -- returns all models starting with 'gluon_resnet'
model_list('*resnext*, 'resnet') -- returns all models with 'resnext' in 'resnet' module


</div>

<EditOnGithub source="https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/models.mdx" />