import{s as wt,n as Tt,o as bt}from"../chunks/scheduler.c57aa7ef.js";import{S as $t,i as _t,g as i,s,r as d,A as vt,h as o,f as l,c as n,j as Mt,u as m,x as r,k as gt,y as Jt,a,v as p,d as f,t as h,w as u}from"../chunks/index.c50cb18e.js";import{C as y}from"../chunks/CodeBlock.34f0a53d.js";import{H as M}from"../chunks/Heading.c7d7e0e7.js";function Ut(Ne){let c,ne,ae,ie,g,oe,w,Se="If you encounter any issue when using PEFT, please check the following list of common issues and their solutions.",re,T,de,b,Ae="Examples often rely on the most recent package versions, so please ensure they’re up-to-date. In particular, check the following package versions:",me,$,qe="<li><code>peft</code></li> <li><code>transformers</code></li> <li><code>accelerate</code></li> <li><code>torch</code></li>",pe,_,De="In general, you can update the package version by running this command inside your Python environment:",fe,v,he,J,Ke="Installing PEFT from source is useful for keeping up with the latest developments:",ue,U,ce,Z,ye,k,Oe='This error probably occurred because the model was loaded with <code>torch_dtype=torch.float16</code> and then used in an automatic mixed precision (AMP) context, e.g. by setting <code>fp16=True</code> in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from 🤗 Transformers. The reason is that when using AMP, trainable weights should never use fp16. To make this work without loading the whole model in fp32, add the following to your code:',Me,C,ge,j,et='Alternatively, you can use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.cast_mixed_precision_params">cast_mixed_precision_params()</a> function to correctly cast the weights:',we,x,Te,B,be,W,tt='There can be several reasons for getting a poor result from a loaded PEFT model which are listed below. If you’re still unable to troubleshoot the problem, see if anyone else had a similar <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> on GitHub, and if you can’t find any, open a new issue.',$e,H,lt="When opening an issue, it helps a lot if you provide a minimal code example that reproduces the issue. Also, please report if the loaded model performs at the same level as the model did before fine-tuning, if it performs at a random level, or if it is only slightly worse than expected. This information helps us identify the problem more quickly.",_e,I,ve,R,at="If your model outputs are not exactly the same as previous runs, there could be an issue with random elements. For example:",Je,G,st='<li>please ensure it is in <code>.eval()</code> mode, which is important, for instance, if the model uses dropout</li> <li>if you use <a href="https://huggingface.co/docs/transformers/main/en/model_doc/phi#transformers.PhiForCausalLM.generate" rel="nofollow">generate</a> on a language model, there could be random sampling, so obtaining the same result requires setting a random seed</li> <li>if you used quantization and merged the weights, small deviations are expected due to rounding errors</li>',Ue,L,Ze,F,nt='Please ensure that you load the model correctly. A common error is trying to load a <em>trained</em> model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> which is incorrect. Instead, the loading code should look like this:',ke,P,Ce,V,je,E,it="For some tasks, it is important to correctly configure <code>modules_to_save</code> in the config to account for randomly initialized layers.",xe,X,ot="As an example, this is necessary if you use LoRA to fine-tune a language model for sequence classification because 🤗 Transformers adds a randomly initialized classification head on top of the model. If you do not add this layer to <code>modules_to_save</code>, the classification head won’t be saved. The next time you load the model, you’ll get a <em>different</em> randomly initialized classification head, resulting in completely different results.",Be,Y,rt="PEFT tries to correctly guess the <code>modules_to_save</code> if you provide the <code>task_type</code> argument in the config. This should work for transformers models that follow the standard naming scheme. It is always a good idea to double check though because we can’t guarantee all models follow the naming scheme.",We,z,dt="When you load a transformers model that has randomly initialized layers, you should see a warning along the lines of:",He,Q,Ie,N,mt="The mentioned layers should be added to <code>modules_to_save</code> in the config to avoid the described problem.",Re,S,Ge,A,pt="For many language fine-tuning tasks, extending the model’s vocabulary is necessary since new tokens are being introduced. This requires extending the embedding layer to account for the new tokens and also storing the embedding layer in addition to the adapter weights when saving the adapter.",Le,q,ft="Save the embedding layer by adding it to the <code>target_modules</code> of the config. The embedding layer name must follow the standard naming scheme from Transformers. For example, the Mistral config could look like this:",Fe,D,Pe,K,ht='Once added to <code>target_modules</code>, PEFT automatically stores the embedding layer when saving the adapter if the model has the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.get_input_embeddings" rel="nofollow">get_input_embeddings</a> and <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.get_output_embeddings" rel="nofollow">get_output_embeddings</a>. This is generally the case for Transformers models.',Ve,O,ut="If the model’s embedding layer doesn’t follow the Transformer’s naming scheme, you can still save it by manually passing <code>save_embedding_layers=True</code> when saving the adapter:",Ee,ee,Xe,te,ct="For inference, load the base model first and resize it the same way you did before you trained the model. After you’ve resized the base model, you can load the PEFT checkpoint.",Ye,le,yt='For a complete example, please check out <a href="https://github.com/huggingface/peft/blob/main/examples/causal_language_modeling/peft_lora_clm_with_additional_tokens.ipynb" rel="nofollow">this notebook</a>.',ze,se,Qe;return g=new M({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h1"}}),T=new M({props:{title:"Examples don’t work",local:"examples-dont-work",headingTag:"h2"}}),v=new y({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjAlM0NwYWNrYWdlX25hbWUlM0U=",highlighted:"python -m pip install -U &lt;package_name&gt;",wrap:!1}}),U=new y({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZwZWZ0",highlighted:"python -m pip install git+https://github.com/huggingface/peft",wrap:!1}}),Z=new M({props:{title:"ValueError: Attempting to unscale FP16 gradients",local:"valueerror-attempting-to-unscale-fp16-gradients",headingTag:"h2"}}),C=new y({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKC4uLiklMEElMEElMjMlMjBhZGQlMjB0aGlzJTNBJTBBZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLmRhdGElMjAlM0QlMjBwYXJhbS5kYXRhLmZsb2F0KCklMEElMEElMjMlMjBwcm9jZWVkJTIwYXMlMjB1c3VhbCUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEcGVmdF9tb2RlbCUyQyUyMGZwMTYlM0RUcnVlJTJDJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`peft_model = get_peft_model(...)

<span class="hljs-comment"># add this:</span>
<span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
    <span class="hljs-keyword">if</span> param.requires_grad:
        param.data = param.data.<span class="hljs-built_in">float</span>()

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),x=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBjYXN0X21peGVkX3ByZWNpc2lvbl9wYXJhbXMlMEElMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoLi4uKSUwQWNhc3RfbWl4ZWRfcHJlY2lzaW9uX3BhcmFtcyhwZWZ0X21vZGVsJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQSUyMyUyMHByb2NlZWQlMjBhcyUyMHVzdWFsJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0RwZWZ0X21vZGVsJTJDJTIwZnAxNiUzRFRydWUlMkMlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> cast_mixed_precision_params

peft_model = get_peft_model(...)
cast_mixed_precision_params(peft_model, dtype=torch.float16)

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),B=new M({props:{title:"Bad results from a loaded PEFT model",local:"bad-results-from-a-loaded-peft-model",headingTag:"h2"}}),I=new M({props:{title:"Random deviations",local:"random-deviations",headingTag:"h3"}}),L=new M({props:{title:"Incorrectly loaded model",local:"incorrectly-loaded-model",headingTag:"h3"}}),P=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMHRvJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyQyUyMHVzZSUyMHRoZSUyMHNhbWUlMjBjb2RlJTIwYXMlMjB3aGVuJTIweW91JTIwdHJhaW5lZCUyMGl0JTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

base_model = ...  <span class="hljs-comment"># to load the base model, use the same code as when you trained it</span>
config = PeftConfig.from_pretrained(peft_model_id)
peft_model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),V=new M({props:{title:"Randomly initialized layers",local:"randomly-initialized-layers",headingTag:"h3"}}),Q=new y({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMCUzQ01PREVMJTNFJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwJTNDSUQlM0UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJTNDTEFZRVJfTkFNRVMlM0UlNUQuJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`<span class="hljs-keyword">Some</span> weights <span class="hljs-keyword">of</span> &lt;MODEL&gt; were <span class="hljs-keyword">not</span> initialized <span class="hljs-keyword">from</span> the model <span class="hljs-keyword">checkpoint</span> at &lt;ID&gt; <span class="hljs-keyword">and</span> are newly initialized: [&lt;LAYER_NAMES&gt;].
You should probably TRAIN this model <span class="hljs-keyword">on</span> a down-stream task <span class="hljs-keyword">to</span> be able <span class="hljs-keyword">to</span> use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.`,wrap:!1}}),S=new M({props:{title:"Extending the vocabulary",local:"extending-the-vocabulary",headingTag:"h3"}}),D=new y({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmVtYmVkX3Rva2VucyUyMiUyQyUyMCUyMmxtX2hlYWQlMjIlMkMlMjAlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),ee=new y({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbCguLi4pJTBBJTIzJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUwQW1vZGVsLnNhdmVfYWRhcHRlciglMjJteV9hZGFwdGVyJTIyJTJDJTIwc2F2ZV9lbWJlZGRpbmdfbGF5ZXJzJTNEVHJ1ZSk=",highlighted:`model = get_peft_model(...)
<span class="hljs-comment"># train the model</span>
model.save_adapter(<span class="hljs-string">&quot;my_adapter&quot;</span>, save_embedding_layers=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=i("meta"),ne=s(),ae=i("p"),ie=s(),d(g.$$.fragment),oe=s(),w=i("p"),w.textContent=Se,re=s(),d(T.$$.fragment),de=s(),b=i("p"),b.textContent=Ae,me=s(),$=i("ul"),$.innerHTML=qe,pe=s(),_=i("p"),_.textContent=De,fe=s(),d(v.$$.fragment),he=s(),J=i("p"),J.textContent=Ke,ue=s(),d(U.$$.fragment),ce=s(),d(Z.$$.fragment),ye=s(),k=i("p"),k.innerHTML=Oe,Me=s(),d(C.$$.fragment),ge=s(),j=i("p"),j.innerHTML=et,we=s(),d(x.$$.fragment),Te=s(),d(B.$$.fragment),be=s(),W=i("p"),W.innerHTML=tt,$e=s(),H=i("p"),H.textContent=lt,_e=s(),d(I.$$.fragment),ve=s(),R=i("p"),R.textContent=at,Je=s(),G=i("ol"),G.innerHTML=st,Ue=s(),d(L.$$.fragment),Ze=s(),F=i("p"),F.innerHTML=nt,ke=s(),d(P.$$.fragment),Ce=s(),d(V.$$.fragment),je=s(),E=i("p"),E.innerHTML=it,xe=s(),X=i("p"),X.innerHTML=ot,Be=s(),Y=i("p"),Y.innerHTML=rt,We=s(),z=i("p"),z.textContent=dt,He=s(),d(Q.$$.fragment),Ie=s(),N=i("p"),N.innerHTML=mt,Re=s(),d(S.$$.fragment),Ge=s(),A=i("p"),A.textContent=pt,Le=s(),q=i("p"),q.innerHTML=ft,Fe=s(),d(D.$$.fragment),Pe=s(),K=i("p"),K.innerHTML=ht,Ve=s(),O=i("p"),O.innerHTML=ut,Ee=s(),d(ee.$$.fragment),Xe=s(),te=i("p"),te.textContent=ct,Ye=s(),le=i("p"),le.innerHTML=yt,ze=s(),se=i("p"),this.h()},l(e){const t=vt("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(l),ne=n(e),ae=o(e,"P",{}),Mt(ae).forEach(l),ie=n(e),m(g.$$.fragment,e),oe=n(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-wwms7a"&&(w.textContent=Se),re=n(e),m(T.$$.fragment,e),de=n(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-18nlz3r"&&(b.textContent=Ae),me=n(e),$=o(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-ccv654"&&($.innerHTML=qe),pe=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1cuqjyb"&&(_.textContent=De),fe=n(e),m(v.$$.fragment,e),he=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-h5ykrw"&&(J.textContent=Ke),ue=n(e),m(U.$$.fragment,e),ce=n(e),m(Z.$$.fragment,e),ye=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-oa0e54"&&(k.innerHTML=Oe),Me=n(e),m(C.$$.fragment,e),ge=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-p7trz1"&&(j.innerHTML=et),we=n(e),m(x.$$.fragment,e),Te=n(e),m(B.$$.fragment,e),be=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-ns8zue"&&(W.innerHTML=tt),$e=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-lfc2ft"&&(H.textContent=lt),_e=n(e),m(I.$$.fragment,e),ve=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-16feh"&&(R.textContent=at),Je=n(e),G=o(e,"OL",{"data-svelte-h":!0}),r(G)!=="svelte-8qf94s"&&(G.innerHTML=st),Ue=n(e),m(L.$$.fragment,e),Ze=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-q1qqrd"&&(F.innerHTML=nt),ke=n(e),m(P.$$.fragment,e),Ce=n(e),m(V.$$.fragment,e),je=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-5heszj"&&(E.innerHTML=it),xe=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-c4824l"&&(X.innerHTML=ot),Be=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1ou3c35"&&(Y.innerHTML=rt),We=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1g4txs2"&&(z.textContent=dt),He=n(e),m(Q.$$.fragment,e),Ie=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1fbeum6"&&(N.innerHTML=mt),Re=n(e),m(S.$$.fragment,e),Ge=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-15igmai"&&(A.textContent=pt),Le=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1cgzlph"&&(q.innerHTML=ft),Fe=n(e),m(D.$$.fragment,e),Pe=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-kwgcwv"&&(K.innerHTML=ht),Ve=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-ucua6z"&&(O.innerHTML=ut),Ee=n(e),m(ee.$$.fragment,e),Xe=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-nkv7o7"&&(te.textContent=ct),Ye=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-a0ibfa"&&(le.innerHTML=yt),ze=n(e),se=o(e,"P",{}),Mt(se).forEach(l),this.h()},h(){gt(c,"name","hf:doc:metadata"),gt(c,"content",Zt)},m(e,t){Jt(document.head,c),a(e,ne,t),a(e,ae,t),a(e,ie,t),p(g,e,t),a(e,oe,t),a(e,w,t),a(e,re,t),p(T,e,t),a(e,de,t),a(e,b,t),a(e,me,t),a(e,$,t),a(e,pe,t),a(e,_,t),a(e,fe,t),p(v,e,t),a(e,he,t),a(e,J,t),a(e,ue,t),p(U,e,t),a(e,ce,t),p(Z,e,t),a(e,ye,t),a(e,k,t),a(e,Me,t),p(C,e,t),a(e,ge,t),a(e,j,t),a(e,we,t),p(x,e,t),a(e,Te,t),p(B,e,t),a(e,be,t),a(e,W,t),a(e,$e,t),a(e,H,t),a(e,_e,t),p(I,e,t),a(e,ve,t),a(e,R,t),a(e,Je,t),a(e,G,t),a(e,Ue,t),p(L,e,t),a(e,Ze,t),a(e,F,t),a(e,ke,t),p(P,e,t),a(e,Ce,t),p(V,e,t),a(e,je,t),a(e,E,t),a(e,xe,t),a(e,X,t),a(e,Be,t),a(e,Y,t),a(e,We,t),a(e,z,t),a(e,He,t),p(Q,e,t),a(e,Ie,t),a(e,N,t),a(e,Re,t),p(S,e,t),a(e,Ge,t),a(e,A,t),a(e,Le,t),a(e,q,t),a(e,Fe,t),p(D,e,t),a(e,Pe,t),a(e,K,t),a(e,Ve,t),a(e,O,t),a(e,Ee,t),p(ee,e,t),a(e,Xe,t),a(e,te,t),a(e,Ye,t),a(e,le,t),a(e,ze,t),a(e,se,t),Qe=!0},p:Tt,i(e){Qe||(f(g.$$.fragment,e),f(T.$$.fragment,e),f(v.$$.fragment,e),f(U.$$.fragment,e),f(Z.$$.fragment,e),f(C.$$.fragment,e),f(x.$$.fragment,e),f(B.$$.fragment,e),f(I.$$.fragment,e),f(L.$$.fragment,e),f(P.$$.fragment,e),f(V.$$.fragment,e),f(Q.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(ee.$$.fragment,e),Qe=!0)},o(e){h(g.$$.fragment,e),h(T.$$.fragment,e),h(v.$$.fragment,e),h(U.$$.fragment,e),h(Z.$$.fragment,e),h(C.$$.fragment,e),h(x.$$.fragment,e),h(B.$$.fragment,e),h(I.$$.fragment,e),h(L.$$.fragment,e),h(P.$$.fragment,e),h(V.$$.fragment,e),h(Q.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),Qe=!1},d(e){e&&(l(ne),l(ae),l(ie),l(oe),l(w),l(re),l(de),l(b),l(me),l($),l(pe),l(_),l(fe),l(he),l(J),l(ue),l(ce),l(ye),l(k),l(Me),l(ge),l(j),l(we),l(Te),l(be),l(W),l($e),l(H),l(_e),l(ve),l(R),l(Je),l(G),l(Ue),l(Ze),l(F),l(ke),l(Ce),l(je),l(E),l(xe),l(X),l(Be),l(Y),l(We),l(z),l(He),l(Ie),l(N),l(Re),l(Ge),l(A),l(Le),l(q),l(Fe),l(Pe),l(K),l(Ve),l(O),l(Ee),l(Xe),l(te),l(Ye),l(le),l(ze),l(se)),l(c),u(g,e),u(T,e),u(v,e),u(U,e),u(Z,e),u(C,e),u(x,e),u(B,e),u(I,e),u(L,e),u(P,e),u(V,e),u(Q,e),u(S,e),u(D,e),u(ee,e)}}}const Zt='{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Examples don’t work","local":"examples-dont-work","sections":[],"depth":2},{"title":"ValueError: Attempting to unscale FP16 gradients","local":"valueerror-attempting-to-unscale-fp16-gradients","sections":[],"depth":2},{"title":"Bad results from a loaded PEFT model","local":"bad-results-from-a-loaded-peft-model","sections":[{"title":"Random deviations","local":"random-deviations","sections":[],"depth":3},{"title":"Incorrectly loaded model","local":"incorrectly-loaded-model","sections":[],"depth":3},{"title":"Randomly initialized layers","local":"randomly-initialized-layers","sections":[],"depth":3},{"title":"Extending the vocabulary","local":"extending-the-vocabulary","sections":[],"depth":3}],"depth":2}],"depth":1}';function kt(Ne){return bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends $t{constructor(c){super(),_t(this,c,kt,Ut,wt,{})}}export{Wt as component};
