import{s as Ie,o as ge,n as ul}from"../chunks/scheduler.c57aa7ef.js";import{S as _e,i as ke,g as c,s as p,r as d,A as Ze,h as u,f as t,c as o,j as je,u as y,x as U,k as ee,y as Be,a as s,v as J,d as T,t as h,w}from"../chunks/index.c50cb18e.js";import{T as Ce}from"../chunks/Tip.9268b0ca.js";import{C as I}from"../chunks/CodeBlock.34f0a53d.js";import{H as ml}from"../chunks/Heading.c7d7e0e7.js";import{H as Ge,a as te}from"../chunks/HfOption.189bbdfa.js";function We(g){let a,b='Some familiarity with the general process of training a causal language model would be really helpful and allow you to focus on the soft prompting methods. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/language_modeling" rel="nofollow">Causal language modeling</a> guide first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!';return{c(){a=c("p"),a.innerHTML=b},l(M){a=u(M,"P",{"data-svelte-h":!0}),U(a)!=="svelte-f4q9mt"&&(a.innerHTML=b)},m(M,r){s(M,a,r)},p:ul,d(M){M&&t(a)}}}function Ve(g){let a,b='Call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of trainable parameters of <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!';return{c(){a=c("p"),a.innerHTML=b},l(M){a=u(M,"P",{"data-svelte-h":!0}),U(a)!=="svelte-1f9ty5f"&&(a.innerHTML=b)},m(M,r){s(M,a,r)},p:ul,d(M){M&&t(a)}}}function $e(g){let a,b='<a href="../conceptual_guides/prompting#p-tuning">P-tuning</a> adds a trainable embedding tensor where the prompt tokens can be added anywhere in the input sequence. Create a <a href="/docs/peft/main/en/package_reference/p_tuning#peft.PromptEncoderConfig">PromptEncoderConfig</a> with the task type, the number of virtual tokens to add and learn, and the hidden size of the encoder for learning the prompt parameters.',M,r,m;return r=new I({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcm9tcHRFbmNvZGVyQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMFByb21wdEVuY29kZXJDb25maWcodGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTIwbnVtX3ZpcnR1YWxfdG9rZW5zJTNEMjAlMkMlMjBlbmNvZGVyX2hpZGRlbl9zaXplJTNEMTI4KSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMzAwJTJDMjg4JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwNTU5JTJDNTE0JTJDODgwJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC4wNTM2NjkzNTAxMzQxNzMzOCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PromptEncoderConfig, get_peft_model

peft_config = PromptEncoderConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>, num_virtual_tokens=<span class="hljs-number">20</span>, encoder_hidden_size=<span class="hljs-number">128</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 300,288 || all params: 559,514,880 || trainable%: 0.05366935013417338&quot;</span>`,wrap:!1}}),{c(){a=c("p"),a.innerHTML=b,M=p(),d(r.$$.fragment)},l(i){a=u(i,"P",{"data-svelte-h":!0}),U(a)!=="svelte-1xwh8g2"&&(a.innerHTML=b),M=o(i),y(r.$$.fragment,i)},m(i,n){s(i,a,n),s(i,M,n),J(r,i,n),m=!0},p:ul,i(i){m||(T(r.$$.fragment,i),m=!0)},o(i){h(r.$$.fragment,i),m=!1},d(i){i&&(t(a),t(M)),w(r,i)}}}function Xe(g){let a,b='<a href="../conceptual_guides/prompting#prefix-tuning">Prefix tuning</a> adds task-specific parameters in all of the model layers, which are optimized by a separate feed-forward network. Create a <a href="/docs/peft/main/en/package_reference/prefix_tuning#peft.PrefixTuningConfig">PrefixTuningConfig</a> with the task type and number of virtual tokens to add and learn.',M,r,m;return r=new I({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcmVmaXhUdW5pbmdDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwUHJlZml4VHVuaW5nQ29uZmlnKHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUyMG51bV92aXJ0dWFsX3Rva2VucyUzRDIwKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwOTgzJTJDMDQwJTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwNTYwJTJDMTk3JTJDNjMyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC4xNzU0ODA5Mjc0MTY3MDE0JTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PrefixTuningConfig, get_peft_model

peft_config = PrefixTuningConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>, num_virtual_tokens=<span class="hljs-number">20</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 983,040 || all params: 560,197,632 || trainable%: 0.1754809274167014&quot;</span>`,wrap:!1}}),{c(){a=c("p"),a.innerHTML=b,M=p(),d(r.$$.fragment)},l(i){a=u(i,"P",{"data-svelte-h":!0}),U(a)!=="svelte-sqvmle"&&(a.innerHTML=b),M=o(i),y(r.$$.fragment,i)},m(i,n){s(i,a,n),s(i,M,n),J(r,i,n),m=!0},p:ul,i(i){m||(T(r.$$.fragment,i),m=!0)},o(i){h(r.$$.fragment,i),m=!1},d(i){i&&(t(a),t(M)),w(r,i)}}}function Re(g){let a,b='<a href="../conceptual_guides/prompting#prompt-tuning">Prompt tuning</a> formulates all tasks as a <em>generation</em> task and it adds a task-specific prompt to the input which is updated independently. The <code>prompt_tuning_init_text</code> parameter specifies how to finetune the model (in this case, it is classifying whether tweets are complaints or not). For the best results, the <code>prompt_tuning_init_text</code> should have the same number of tokens that should be predicted. To do this, you can set <code>num_virtual_tokens</code> to the number of tokens of the <code>prompt_tuning_init_text</code>.',M,r,m='Create a <a href="/docs/peft/main/en/package_reference/prompt_tuning#peft.PromptTuningConfig">PromptTuningConfig</a> with the task type, the initial prompt tuning text to train the model with, the number of virtual tokens to add and learn, and a tokenizer.',i,n,j;return n=new I({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcm9tcHRUdW5pbmdDb25maWclMkMlMjBQcm9tcHRUdW5pbmdJbml0JTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFwcm9tcHRfdHVuaW5nX2luaXRfdGV4dCUyMCUzRCUyMCUyMkNsYXNzaWZ5JTIwaWYlMjB0aGUlMjB0d2VldCUyMGlzJTIwYSUyMGNvbXBsYWludCUyMG9yJTIwbm8lMjBjb21wbGFpbnQuJTVDbiUyMiUwQXBlZnRfY29uZmlnJTIwJTNEJTIwUHJvbXB0VHVuaW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90dW5pbmdfaW5pdCUzRFByb21wdFR1bmluZ0luaXQuVEVYVCUyQyUwQSUyMCUyMCUyMCUyMG51bV92aXJ0dWFsX3Rva2VucyUzRGxlbih0b2tlbml6ZXIocHJvbXB0X3R1bmluZ19pbml0X3RleHQpJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90dW5pbmdfaW5pdF90ZXh0JTNEcHJvbXB0X3R1bmluZ19pbml0X3RleHQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfbmFtZV9vcl9wYXRoJTNEJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwOCUyQzE5MiUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDU1OSUyQzIyMiUyQzc4NCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuMDAxNDY0ODkwMjQzMDk4NTM1OCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PromptTuningConfig, PromptTuningInit, get_peft_model

prompt_tuning_init_text = <span class="hljs-string">&quot;Classify if the tweet is a complaint or no complaint.\\n&quot;</span>
peft_config = PromptTuningConfig(
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
    prompt_tuning_init=PromptTuningInit.TEXT,
    num_virtual_tokens=<span class="hljs-built_in">len</span>(tokenizer(prompt_tuning_init_text)[<span class="hljs-string">&quot;input_ids&quot;</span>]),
    prompt_tuning_init_text=prompt_tuning_init_text,
    tokenizer_name_or_path=<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>,
)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 8,192 || all params: 559,222,784 || trainable%: 0.0014648902430985358&quot;</span>`,wrap:!1}}),{c(){a=c("p"),a.innerHTML=b,M=p(),r=c("p"),r.innerHTML=m,i=p(),d(n.$$.fragment)},l(f){a=u(f,"P",{"data-svelte-h":!0}),U(a)!=="svelte-1vtqt32"&&(a.innerHTML=b),M=o(f),r=u(f,"P",{"data-svelte-h":!0}),U(r)!=="svelte-sm7geg"&&(r.innerHTML=m),i=o(f),y(n.$$.fragment,f)},m(f,C){s(f,a,C),s(f,M,C),s(f,r,C),s(f,i,C),J(n,f,C),j=!0},p:ul,i(f){j||(T(n.$$.fragment,f),j=!0)},o(f){h(n.$$.fragment,f),j=!1},d(f){f&&(t(a),t(M),t(r),t(i)),w(n,f)}}}function Ne(g){let a,b,M,r,m,i;return a=new te({props:{id:"configurations",option:"p-tuning",$$slots:{default:[$e]},$$scope:{ctx:g}}}),M=new te({props:{id:"configurations",option:"prefix tuning",$$slots:{default:[Xe]},$$scope:{ctx:g}}}),m=new te({props:{id:"configurations",option:"prompt tuning",$$slots:{default:[Re]},$$scope:{ctx:g}}}),{c(){d(a.$$.fragment),b=p(),d(M.$$.fragment),r=p(),d(m.$$.fragment)},l(n){y(a.$$.fragment,n),b=o(n),y(M.$$.fragment,n),r=o(n),y(m.$$.fragment,n)},m(n,j){J(a,n,j),s(n,b,j),J(M,n,j),s(n,r,j),J(m,n,j),i=!0},p(n,j){const f={};j&2&&(f.$$scope={dirty:j,ctx:n}),a.$set(f);const C={};j&2&&(C.$$scope={dirty:j,ctx:n}),M.$set(C);const cl={};j&2&&(cl.$$scope={dirty:j,ctx:n}),m.$set(cl)},i(n){i||(T(a.$$.fragment,n),T(M.$$.fragment,n),T(m.$$.fragment,n),i=!0)},o(n){h(a.$$.fragment,n),h(M.$$.fragment,n),h(m.$$.fragment,n),i=!1},d(n){n&&(t(b),t(r)),w(a,n),w(M,n),w(m,n)}}}function ze(g){let a,b,M,r,m,i,n,j="A prompt can describe a task or provide an example of a task you want the model to learn. Instead of manually creating these prompts, soft prompting methods add learnable parameters to the input embeddings that can be optimized for a specific task while keeping the pretrained model’s parameters frozen. This makes it both faster and easier to finetune large language models (LLMs) for new downstream tasks.",f,C,cl='The PEFT library supports several types of prompting methods (p-tuning, prefix tuning, prompt tuning) and you can learn more about how these methods work conceptually in the <a href="../conceptual_guides/prompting">Soft prompts</a> guide. If you’re interested in applying these methods to other tasks and use cases, take a look at our <a href="https://huggingface.co/spaces/PEFT/soft-prompting" rel="nofollow">notebook collection</a>!',yl,G,se="This guide will show you how to train a causal language model - with a soft prompting method - to <em>generate a classification</em> for whether a tweet is a complaint or not.",Jl,_,Tl,W,ae="Before you begin, make sure you have all the necessary libraries installed.",hl,V,wl,$,fl,X,ne='For this guide, you’ll use the <code>twitter_complaints</code> subset of the <a href="https://huggingface.co/datasets/ought/raft" rel="nofollow">RAFT</a> dataset. The <code>twitter_complaints</code> subset contains tweets labeled as <code>complaint</code> and <code>no complaint</code> and you can check out the <a href="https://huggingface.co/datasets/ought/raft/viewer/twitter_complaints" rel="nofollow">dataset viewer</a> for a better idea of what the data looks like.',Ul,R,pe='Use the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function to load the dataset and create a new <code>text_label</code> column so it is easier to understand what the <code>Label</code> values, <code>1</code> and <code>2</code> mean.',bl,N,jl,z,oe="Load a tokenizer, define the padding token to use, and determine the maximum length of the tokenized label.",Cl,v,Il,E,ie="Create a preprocessing function that tokenizes the tweet text and labels, pad the inputs and labels in each batch, create an attention mask, and truncate sequences to the <code>max_length</code>. Then convert the <code>input_ids</code>, <code>attention_mask</code>, and <code>labels</code> to PyTorch tensors.",gl,Q,_l,F,Me='Apply the preprocessing function to the entire dataset with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> function, and remove the unprocessed columns because the model won’t need them.',kl,Y,Zl,x,re='Finally, create a training and evaluation <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>. You can set <code>pin_memory=True</code> to speed up the data transfer to the GPU during training if the samples in your dataset are on a CPU.',Bl,A,Gl,H,Wl,q,me='Now let’s load a pretrained model to use as the base model for the soft prompt method. This guide uses the <a href="https://huggingface.co/bigscience/bloomz-560m" rel="nofollow">bigscience/bloomz-560m</a> model, but you can use any causal language model you want.',Vl,S,$l,L,Xl,P,ce='For any PEFT method, you’ll need to create a configuration which contains all the parameters that specify how the PEFT method should be applied. Once the configuration is setup, pass it to the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Rl,k,Nl,Z,zl,D,vl,K,de="Set up an optimizer and learning rate scheduler.",El,O,Ql,ll,ue="Move the model to the GPU and create a training loop that reports the loss and perplexity for each epoch.",Fl,el,Yl,tl,xl,sl,ye='Once training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',Al,al,Hl,nl,Je="If you check the model file size in the repository, you’ll see that it is a lot smaller than a full sized model!",ql,B,Te='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/PEFT-hub-screenshot.png"/> <figcaption class="text-center">For example, the adapter weights for a opt-350m model stored on the Hub are only ~6MB compared to the full model size which can be ~700MB.</figcaption>',Sl,pl,Ll,ol,he="Let’s load the model for inference and test it out on a tweet!",Pl,il,Dl,Ml,we='Call the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/phi#transformers.PhiForCausalLM.generate" rel="nofollow">generate</a> method to generate the predicted classification label.',Kl,rl,Ol,dl,le;return m=new ml({props:{title:"Prompt-based methods",local:"prompt-based-methods",headingTag:"h1"}}),_=new Ce({props:{$$slots:{default:[We]},$$scope:{ctx:g}}}),V=new I({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcGVmdCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRz",highlighted:"pip install -q peft transformers datasets",wrap:!1}}),$=new ml({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),N=new I({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyb3VnaHQlMkZyYWZ0JTIyJTJDJTIwJTIydHdpdHRlcl9jb21wbGFpbnRzJTIyKSUwQSUwQWNsYXNzZXMlMjAlM0QlMjAlNUJrLnJlcGxhY2UoJTIyXyUyMiUyQyUyMCUyMiUyMCUyMiklMjBmb3IlMjBrJTIwaW4lMjBkcyU1QiUyMnRyYWluJTIyJTVELmZlYXR1cmVzJTVCJTIyTGFiZWwlMjIlNUQubmFtZXMlNUQlMEFkcyUyMCUzRCUyMGRzLm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwJTdCJTIydGV4dF9sYWJlbCUyMiUzQSUyMCU1QmNsYXNzZXMlNUJsYWJlbCU1RCUyMGZvciUyMGxhYmVsJTIwaW4lMjB4JTVCJTIyTGFiZWwlMjIlNUQlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSklMEFkcyU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCUwQSU3QiUyMlR3ZWV0JTIwdGV4dCUyMiUzQSUyMCUyMiU0MEhNUkNjdXN0b21lcnMlMjBObyUyMHRoaXMlMjBpcyUyMG15JTIwZmlyc3QlMjBqb2IlMjIlMkMlMjAlMjJJRCUyMiUzQSUyMDAlMkMlMjAlMjJMYWJlbCUyMiUzQSUyMDIlMkMlMjAlMjJ0ZXh0X2xhYmVsJTIyJTNBJTIwJTIybm8lMjBjb21wbGFpbnQlMjIlN0Q=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;ought/raft&quot;</span>, <span class="hljs-string">&quot;twitter_complaints&quot;</span>)

classes = [k.replace(<span class="hljs-string">&quot;_&quot;</span>, <span class="hljs-string">&quot; &quot;</span>) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;Label&quot;</span>].names]
ds = ds.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;text_label&quot;</span>: [classes[label] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> x[<span class="hljs-string">&quot;Label&quot;</span>]]},
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
)
ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;Tweet text&quot;</span>: <span class="hljs-string">&quot;@HMRCcustomers No this is my first job&quot;</span>, <span class="hljs-string">&quot;ID&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;Label&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;text_label&quot;</span>: <span class="hljs-string">&quot;no complaint&quot;</span>}`,wrap:!1}}),v=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBaWYlMjB0b2tlbml6ZXIucGFkX3Rva2VuX2lkJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyLnBhZF90b2tlbl9pZCUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMEF0YXJnZXRfbWF4X2xlbmd0aCUyMCUzRCUyMG1heCglNUJsZW4odG9rZW5pemVyKGNsYXNzX2xhYmVsKSU1QiUyMmlucHV0X2lkcyUyMiU1RCklMjBmb3IlMjBjbGFzc19sYWJlbCUyMGluJTIwY2xhc3NlcyU1RCklMEFwcmludCh0YXJnZXRfbWF4X2xlbmd0aCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-keyword">if</span> tokenizer.pad_token_id <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    tokenizer.pad_token_id = tokenizer.eos_token_id
target_max_length = <span class="hljs-built_in">max</span>([<span class="hljs-built_in">len</span>(tokenizer(class_label)[<span class="hljs-string">&quot;input_ids&quot;</span>]) <span class="hljs-keyword">for</span> class_label <span class="hljs-keyword">in</span> classes])
<span class="hljs-built_in">print</span>(target_max_length)`,wrap:!1}}),Q=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

max_length = <span class="hljs-number">64</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples, text_column=<span class="hljs-string">&quot;Tweet text&quot;</span>, label_column=<span class="hljs-string">&quot;text_label&quot;</span></span>):
    batch_size = <span class="hljs-built_in">len</span>(examples[text_column])
    inputs = [<span class="hljs-string">f&quot;<span class="hljs-subst">{text_column}</span> : <span class="hljs-subst">{x}</span> Label : &quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[text_column]]
    targets = [<span class="hljs-built_in">str</span>(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[label_column]]
    model_inputs = tokenizer(inputs)
    labels = tokenizer(targets)
    classes = [k.replace(<span class="hljs-string">&quot;_&quot;</span>, <span class="hljs-string">&quot; &quot;</span>) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;Label&quot;</span>].names]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size):
        sample_input_ids = model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i]
        label_input_ids = labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i]
        model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = [tokenizer.pad_token_id] * (
            max_length - <span class="hljs-built_in">len</span>(sample_input_ids)
        ) + sample_input_ids
        model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i] = [<span class="hljs-number">0</span>] * (max_length - <span class="hljs-built_in">len</span>(sample_input_ids)) + model_inputs[
            <span class="hljs-string">&quot;attention_mask&quot;</span>
        ][i]
        labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = [-<span class="hljs-number">100</span>] * (max_length - <span class="hljs-built_in">len</span>(sample_input_ids)) + label_input_ids
        model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = torch.tensor(model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i][:max_length])
        model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i] = torch.tensor(model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i][:max_length])
        labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = torch.tensor(labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i][:max_length])
    model_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels[<span class="hljs-string">&quot;input_ids&quot;</span>]
    <span class="hljs-keyword">return</span> model_inputs`,wrap:!1}}),Y=new I({props:{code:"cHJvY2Vzc2VkX2RzJTIwJTNEJTIwZHMubWFwKCUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3NfZnVuY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV9jb2x1bW5zJTNEZHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXMlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Zyb21fY2FjaGVfZmlsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZGVzYyUzRCUyMlJ1bm5pbmclMjB0b2tlbml6ZXIlMjBvbiUyMGRhdGFzZXQlMjIlMkMlMEEp",highlighted:`processed_ds = ds.<span class="hljs-built_in">map</span>(
    preprocess_function,
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
    remove_columns=ds[<span class="hljs-string">&quot;train&quot;</span>].column_names,
    load_from_cache_file=<span class="hljs-literal">False</span>,
    desc=<span class="hljs-string">&quot;Running tokenizer on dataset&quot;</span>,
)`,wrap:!1}}),A=new I({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGRlZmF1bHRfZGF0YV9jb2xsYXRvciUwQSUwQXRyYWluX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydHJhaW4lMjIlNUQlMEFldmFsX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydGVzdCUyMiU1RCUwQSUwQWJhdGNoX3NpemUlMjAlM0QlMjAxNiUwQSUwQXRyYWluX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKHRyYWluX2RzJTJDJTIwc2h1ZmZsZSUzRFRydWUlMkMlMjBjb2xsYXRlX2ZuJTNEZGVmYXVsdF9kYXRhX2NvbGxhdG9yJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBwaW5fbWVtb3J5JTNEVHJ1ZSklMEFldmFsX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKGV2YWxfZHMlMkMlMjBjb2xsYXRlX2ZuJTNEZGVmYXVsdF9kYXRhX2NvbGxhdG9yJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBwaW5fbWVtb3J5JTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> default_data_collator

train_ds = processed_ds[<span class="hljs-string">&quot;train&quot;</span>]
eval_ds = processed_ds[<span class="hljs-string">&quot;test&quot;</span>]

batch_size = <span class="hljs-number">16</span>

train_dataloader = DataLoader(train_ds, shuffle=<span class="hljs-literal">True</span>, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)
eval_dataloader = DataLoader(eval_ds, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)`,wrap:!1}}),H=new ml({props:{title:"Model",local:"model",headingTag:"h2"}}),S=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)`,wrap:!1}}),L=new ml({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),k=new Ce({props:{$$slots:{default:[Ve]},$$scope:{ctx:g}}}),Z=new Ge({props:{id:"configurations",options:["p-tuning","prefix tuning","prompt tuning"],$$slots:{default:[Ne]},$$scope:{ctx:g}}}),D=new ml({props:{title:"Training",local:"training",headingTag:"h3"}}),O=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9saW5lYXJfc2NoZWR1bGVfd2l0aF93YXJtdXAlMEElMEFsciUyMCUzRCUyMDNlLTIlMEFudW1fZXBvY2hzJTIwJTNEJTIwNTAlMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjB0b3JjaC5vcHRpbS5BZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRGxyKSUwQWxyX3NjaGVkdWxlciUyMCUzRCUyMGdldF9saW5lYXJfc2NoZWR1bGVfd2l0aF93YXJtdXAoJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dhcm11cF9zdGVwcyUzRDAlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0QobGVuKHRyYWluX2RhdGFsb2FkZXIpJTIwKiUyMG51bV9lcG9jaHMpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_linear_schedule_with_warmup

lr = <span class="hljs-number">3e-2</span>
num_epochs = <span class="hljs-number">50</span>

optimizer = torch.optim.AdamW(model.parameters(), lr=lr)
lr_scheduler = get_linear_schedule_with_warmup(
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * num_epochs),
)`,wrap:!1}}),el=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

device = <span class="hljs-string">&quot;cuda&quot;</span>
model = model.to(device)

<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    model.train()
    total_loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(train_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        total_loss += loss.detach().<span class="hljs-built_in">float</span>()
        loss.backward()
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()

    model.<span class="hljs-built_in">eval</span>()
    eval_loss = <span class="hljs-number">0</span>
    eval_preds = []
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        <span class="hljs-keyword">with</span> torch.no_grad():
            outputs = model(**batch)
        loss = outputs.loss
        eval_loss += loss.detach().<span class="hljs-built_in">float</span>()
        eval_preds.extend(
            tokenizer.batch_decode(torch.argmax(outputs.logits, -<span class="hljs-number">1</span>).detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)
        )

    eval_epoch_loss = eval_loss / <span class="hljs-built_in">len</span>(eval_dataloader)
    eval_ppl = torch.exp(eval_epoch_loss)
    train_epoch_loss = total_loss / <span class="hljs-built_in">len</span>(train_dataloader)
    train_ppl = torch.exp(train_epoch_loss)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{epoch=}</span>: <span class="hljs-subst">{train_ppl=}</span> <span class="hljs-subst">{train_epoch_loss=}</span> <span class="hljs-subst">{eval_ppl=}</span> <span class="hljs-subst">{eval_epoch_loss=}</span>&quot;</span>)`,wrap:!1}}),tl=new ml({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),al=new I({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBYWNjb3VudCUyMCUzRCUyMCUzQ3lvdXItaGYtYWNjb3VudC1uYW1lJTNFJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMGYlMjIlN0JhY2NvdW50JTdEJTJGYmxvb216LTU2MC1tLXBlZnQtbWV0aG9kJTIyJTBBbW9kZWwucHVzaF90b19odWIocGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

account = &lt;your-hf-account-name&gt;
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/bloomz-560-m-peft-method&quot;</span>
model.push_to_hub(peft_model_id)`,wrap:!1}}),pl=new ml({props:{title:"Inference",local:"inference",headingTag:"h2"}}),il=new I({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBdXRvUGVmdE1vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9QZWZ0TW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIycGVmdF9tb2RlbF9pZCUyMikudG8oJTIyY3VkYSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaSUyMCUzRCUyMDE1JTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGYnJTdCdGV4dF9jb2x1bW4lN0QlMjAlM0ElMjAlN0JkcyU1QiUyMnRlc3QlMjIlNUQlNUJpJTVEJTVCJTIyVHdlZXQlMjB0ZXh0JTIyJTVEJTdEJTIwTGFiZWwlMjAlM0ElMjAnJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChkcyU1QiUyMnRlc3QlMjIlNUQlNUJpJTVEJTVCJTIyVHdlZXQlMjB0ZXh0JTIyJTVEKSUwQSUyMiU0ME5ZVHN1cHBvcnQlMjBpJTIwaGF2ZSUyMGNvbXBsYWluZWQlMjBhJTIwZG96ZW4lMjB0aW1lcyUyMCUyNmFtcCUzQiUyMHlldCUyMG15JTIwcGFwZXJzJTIwYXJlJTIwc3RpbGwlMjB0aHJvd24lMjBGQVIlMjBmcm9tJTIwbXklMjBkb29yLiUyMFdoeSUyMGlzJTIwdGhpcyUyMHNvJTIwaGFyZCUyMHRvJTIwcmVzb2x2ZSUzRiUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AutoPeftModelForCausalLM

model = AutoPeftModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;peft_model_id&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

i = <span class="hljs-number">15</span>
inputs = tokenizer(<span class="hljs-string">f&#x27;<span class="hljs-subst">{text_column}</span> : <span class="hljs-subst">{ds[<span class="hljs-string">&quot;test&quot;</span>][i][<span class="hljs-string">&quot;Tweet text&quot;</span>]}</span> Label : &#x27;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(ds[<span class="hljs-string">&quot;test&quot;</span>][i][<span class="hljs-string">&quot;Tweet text&quot;</span>])
<span class="hljs-string">&quot;@NYTsupport i have complained a dozen times &amp;amp; yet my papers are still thrown FAR from my door. Why is this so hard to resolve?&quot;</span>`,wrap:!1}}),rl=new I({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMjIlNUInVHdlZXQlMjB0ZXh0JTIwJTNBJTIwJTQwTllUc3VwcG9ydCUyMGklMjBoYXZlJTIwY29tcGxhaW5lZCUyMGElMjBkb3plbiUyMHRpbWVzJTIwJTI2YW1wJTNCJTIweWV0JTIwbXklMjBwYXBlcnMlMjBhcmUlMjBzdGlsbCUyMHRocm93biUyMEZBUiUyMGZyb20lMjBteSUyMGRvb3IuJTIwV2h5JTIwaXMlMjB0aGlzJTIwc28lMjBoYXJkJTIwdG8lMjByZXNvbHZlJTNGJTIwTGFiZWwlMjAlM0ElMjBjb21wbGFpbnQnJTVEJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
    outputs = model.generate(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">10</span>)
    <span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-string">&quot;[&#x27;Tweet text : @NYTsupport i have complained a dozen times &amp;amp; yet my papers are still thrown FAR from my door. Why is this so hard to resolve? Label : complaint&#x27;]&quot;</span>`,wrap:!1}}),{c(){a=c("meta"),b=p(),M=c("p"),r=p(),d(m.$$.fragment),i=p(),n=c("p"),n.textContent=j,f=p(),C=c("p"),C.innerHTML=cl,yl=p(),G=c("p"),G.innerHTML=se,Jl=p(),d(_.$$.fragment),Tl=p(),W=c("p"),W.textContent=ae,hl=p(),d(V.$$.fragment),wl=p(),d($.$$.fragment),fl=p(),X=c("p"),X.innerHTML=ne,Ul=p(),R=c("p"),R.innerHTML=pe,bl=p(),d(N.$$.fragment),jl=p(),z=c("p"),z.textContent=oe,Cl=p(),d(v.$$.fragment),Il=p(),E=c("p"),E.innerHTML=ie,gl=p(),d(Q.$$.fragment),_l=p(),F=c("p"),F.innerHTML=Me,kl=p(),d(Y.$$.fragment),Zl=p(),x=c("p"),x.innerHTML=re,Bl=p(),d(A.$$.fragment),Gl=p(),d(H.$$.fragment),Wl=p(),q=c("p"),q.innerHTML=me,Vl=p(),d(S.$$.fragment),$l=p(),d(L.$$.fragment),Xl=p(),P=c("p"),P.innerHTML=ce,Rl=p(),d(k.$$.fragment),Nl=p(),d(Z.$$.fragment),zl=p(),d(D.$$.fragment),vl=p(),K=c("p"),K.textContent=de,El=p(),d(O.$$.fragment),Ql=p(),ll=c("p"),ll.textContent=ue,Fl=p(),d(el.$$.fragment),Yl=p(),d(tl.$$.fragment),xl=p(),sl=c("p"),sl.innerHTML=ye,Al=p(),d(al.$$.fragment),Hl=p(),nl=c("p"),nl.textContent=Je,ql=p(),B=c("div"),B.innerHTML=Te,Sl=p(),d(pl.$$.fragment),Ll=p(),ol=c("p"),ol.textContent=he,Pl=p(),d(il.$$.fragment),Dl=p(),Ml=c("p"),Ml.innerHTML=we,Kl=p(),d(rl.$$.fragment),Ol=p(),dl=c("p"),this.h()},l(l){const e=Ze("svelte-u9bgzb",document.head);a=u(e,"META",{name:!0,content:!0}),e.forEach(t),b=o(l),M=u(l,"P",{}),je(M).forEach(t),r=o(l),y(m.$$.fragment,l),i=o(l),n=u(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-1nma30k"&&(n.textContent=j),f=o(l),C=u(l,"P",{"data-svelte-h":!0}),U(C)!=="svelte-qxepz2"&&(C.innerHTML=cl),yl=o(l),G=u(l,"P",{"data-svelte-h":!0}),U(G)!=="svelte-10gyoze"&&(G.innerHTML=se),Jl=o(l),y(_.$$.fragment,l),Tl=o(l),W=u(l,"P",{"data-svelte-h":!0}),U(W)!=="svelte-1rdzhb1"&&(W.textContent=ae),hl=o(l),y(V.$$.fragment,l),wl=o(l),y($.$$.fragment,l),fl=o(l),X=u(l,"P",{"data-svelte-h":!0}),U(X)!=="svelte-b49pm"&&(X.innerHTML=ne),Ul=o(l),R=u(l,"P",{"data-svelte-h":!0}),U(R)!=="svelte-5j9yqq"&&(R.innerHTML=pe),bl=o(l),y(N.$$.fragment,l),jl=o(l),z=u(l,"P",{"data-svelte-h":!0}),U(z)!=="svelte-gjlxro"&&(z.textContent=oe),Cl=o(l),y(v.$$.fragment,l),Il=o(l),E=u(l,"P",{"data-svelte-h":!0}),U(E)!=="svelte-s6tghk"&&(E.innerHTML=ie),gl=o(l),y(Q.$$.fragment,l),_l=o(l),F=u(l,"P",{"data-svelte-h":!0}),U(F)!=="svelte-fdx4gc"&&(F.innerHTML=Me),kl=o(l),y(Y.$$.fragment,l),Zl=o(l),x=u(l,"P",{"data-svelte-h":!0}),U(x)!=="svelte-zejkx4"&&(x.innerHTML=re),Bl=o(l),y(A.$$.fragment,l),Gl=o(l),y(H.$$.fragment,l),Wl=o(l),q=u(l,"P",{"data-svelte-h":!0}),U(q)!=="svelte-bbm736"&&(q.innerHTML=me),Vl=o(l),y(S.$$.fragment,l),$l=o(l),y(L.$$.fragment,l),Xl=o(l),P=u(l,"P",{"data-svelte-h":!0}),U(P)!=="svelte-y2bm59"&&(P.innerHTML=ce),Rl=o(l),y(k.$$.fragment,l),Nl=o(l),y(Z.$$.fragment,l),zl=o(l),y(D.$$.fragment,l),vl=o(l),K=u(l,"P",{"data-svelte-h":!0}),U(K)!=="svelte-tlkvop"&&(K.textContent=de),El=o(l),y(O.$$.fragment,l),Ql=o(l),ll=u(l,"P",{"data-svelte-h":!0}),U(ll)!=="svelte-bqhytl"&&(ll.textContent=ue),Fl=o(l),y(el.$$.fragment,l),Yl=o(l),y(tl.$$.fragment,l),xl=o(l),sl=u(l,"P",{"data-svelte-h":!0}),U(sl)!=="svelte-vaxac6"&&(sl.innerHTML=ye),Al=o(l),y(al.$$.fragment,l),Hl=o(l),nl=u(l,"P",{"data-svelte-h":!0}),U(nl)!=="svelte-b4rki0"&&(nl.textContent=Je),ql=o(l),B=u(l,"DIV",{class:!0,"data-svelte-h":!0}),U(B)!=="svelte-i5cvgh"&&(B.innerHTML=Te),Sl=o(l),y(pl.$$.fragment,l),Ll=o(l),ol=u(l,"P",{"data-svelte-h":!0}),U(ol)!=="svelte-19ver11"&&(ol.textContent=he),Pl=o(l),y(il.$$.fragment,l),Dl=o(l),Ml=u(l,"P",{"data-svelte-h":!0}),U(Ml)!=="svelte-1dzfu9a"&&(Ml.innerHTML=we),Kl=o(l),y(rl.$$.fragment,l),Ol=o(l),dl=u(l,"P",{}),je(dl).forEach(t),this.h()},h(){ee(a,"name","hf:doc:metadata"),ee(a,"content",ve),ee(B,"class","flex flex-col justify-center")},m(l,e){Be(document.head,a),s(l,b,e),s(l,M,e),s(l,r,e),J(m,l,e),s(l,i,e),s(l,n,e),s(l,f,e),s(l,C,e),s(l,yl,e),s(l,G,e),s(l,Jl,e),J(_,l,e),s(l,Tl,e),s(l,W,e),s(l,hl,e),J(V,l,e),s(l,wl,e),J($,l,e),s(l,fl,e),s(l,X,e),s(l,Ul,e),s(l,R,e),s(l,bl,e),J(N,l,e),s(l,jl,e),s(l,z,e),s(l,Cl,e),J(v,l,e),s(l,Il,e),s(l,E,e),s(l,gl,e),J(Q,l,e),s(l,_l,e),s(l,F,e),s(l,kl,e),J(Y,l,e),s(l,Zl,e),s(l,x,e),s(l,Bl,e),J(A,l,e),s(l,Gl,e),J(H,l,e),s(l,Wl,e),s(l,q,e),s(l,Vl,e),J(S,l,e),s(l,$l,e),J(L,l,e),s(l,Xl,e),s(l,P,e),s(l,Rl,e),J(k,l,e),s(l,Nl,e),J(Z,l,e),s(l,zl,e),J(D,l,e),s(l,vl,e),s(l,K,e),s(l,El,e),J(O,l,e),s(l,Ql,e),s(l,ll,e),s(l,Fl,e),J(el,l,e),s(l,Yl,e),J(tl,l,e),s(l,xl,e),s(l,sl,e),s(l,Al,e),J(al,l,e),s(l,Hl,e),s(l,nl,e),s(l,ql,e),s(l,B,e),s(l,Sl,e),J(pl,l,e),s(l,Ll,e),s(l,ol,e),s(l,Pl,e),J(il,l,e),s(l,Dl,e),s(l,Ml,e),s(l,Kl,e),J(rl,l,e),s(l,Ol,e),s(l,dl,e),le=!0},p(l,[e]){const fe={};e&2&&(fe.$$scope={dirty:e,ctx:l}),_.$set(fe);const Ue={};e&2&&(Ue.$$scope={dirty:e,ctx:l}),k.$set(Ue);const be={};e&2&&(be.$$scope={dirty:e,ctx:l}),Z.$set(be)},i(l){le||(T(m.$$.fragment,l),T(_.$$.fragment,l),T(V.$$.fragment,l),T($.$$.fragment,l),T(N.$$.fragment,l),T(v.$$.fragment,l),T(Q.$$.fragment,l),T(Y.$$.fragment,l),T(A.$$.fragment,l),T(H.$$.fragment,l),T(S.$$.fragment,l),T(L.$$.fragment,l),T(k.$$.fragment,l),T(Z.$$.fragment,l),T(D.$$.fragment,l),T(O.$$.fragment,l),T(el.$$.fragment,l),T(tl.$$.fragment,l),T(al.$$.fragment,l),T(pl.$$.fragment,l),T(il.$$.fragment,l),T(rl.$$.fragment,l),le=!0)},o(l){h(m.$$.fragment,l),h(_.$$.fragment,l),h(V.$$.fragment,l),h($.$$.fragment,l),h(N.$$.fragment,l),h(v.$$.fragment,l),h(Q.$$.fragment,l),h(Y.$$.fragment,l),h(A.$$.fragment,l),h(H.$$.fragment,l),h(S.$$.fragment,l),h(L.$$.fragment,l),h(k.$$.fragment,l),h(Z.$$.fragment,l),h(D.$$.fragment,l),h(O.$$.fragment,l),h(el.$$.fragment,l),h(tl.$$.fragment,l),h(al.$$.fragment,l),h(pl.$$.fragment,l),h(il.$$.fragment,l),h(rl.$$.fragment,l),le=!1},d(l){l&&(t(b),t(M),t(r),t(i),t(n),t(f),t(C),t(yl),t(G),t(Jl),t(Tl),t(W),t(hl),t(wl),t(fl),t(X),t(Ul),t(R),t(bl),t(jl),t(z),t(Cl),t(Il),t(E),t(gl),t(_l),t(F),t(kl),t(Zl),t(x),t(Bl),t(Gl),t(Wl),t(q),t(Vl),t($l),t(Xl),t(P),t(Rl),t(Nl),t(zl),t(vl),t(K),t(El),t(Ql),t(ll),t(Fl),t(Yl),t(xl),t(sl),t(Al),t(Hl),t(nl),t(ql),t(B),t(Sl),t(Ll),t(ol),t(Pl),t(Dl),t(Ml),t(Kl),t(Ol),t(dl)),t(a),w(m,l),w(_,l),w(V,l),w($,l),w(N,l),w(v,l),w(Q,l),w(Y,l),w(A,l),w(H,l),w(S,l),w(L,l),w(k,l),w(Z,l),w(D,l),w(O,l),w(el,l),w(tl,l),w(al,l),w(pl,l),w(il,l),w(rl,l)}}}const ve='{"title":"Prompt-based methods","local":"prompt-based-methods","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Ee(g){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qe extends _e{constructor(a){super(),ke(this,a,Ee,ze,Ie,{})}}export{qe as component};
