import{s as rt,n as ot,o as it}from"../chunks/scheduler.c57aa7ef.js";import{S as pt,i as ft,g as r,s,r as p,A as dt,h as o,f as a,c as n,j as nt,u as f,x as i,k as Fe,y as mt,a as l,v as d,d as m,t as u,w as c}from"../chunks/index.c50cb18e.js";import{C as h}from"../chunks/CodeBlock.34f0a53d.js";import{H as xe}from"../chunks/Heading.c7d7e0e7.js";function ut(Re){let M,O,D,ee,w,te,g,Ee='PEFT’s practical benefits extends to other Hugging Face libraries like <a href="https://hf.co/docs/diffusers" rel="nofollow">Diffusers</a> and <a href="https://hf.co/docs/transformers" rel="nofollow">Transformers</a>. One of the main benefits of PEFT is that an adapter file generated by a PEFT method is a lot smaller than the original model, which makes it super easy to manage and use multiple adapters. You can use one pretrained base model for multiple tasks by simply loading a new adapter finetuned for the task you’re solving. Or you can combine multiple adapters with a text-to-image diffusion model to create new effects.',ae,T,Xe="This tutorial will show you how PEFT can help you manage adapters in Diffusers and Transformers.",le,j,se,J,Ie="Diffusers is a generative AI library for creating images and videos from text or images with diffusion models. LoRA is an especially popular training method for diffusion models because you can very quickly train and share diffusion models to generate images in new styles. To make it easier to use and try multiple LoRA models, Diffusers uses the PEFT library to help manage different adapters for inference.",ne,Z,Ye='For example, load a base model and then load the <a href="https://huggingface.co/artificialguybr/3DRedmond-V1" rel="nofollow">artificialguybr/3DRedmond-V1</a> adapter for inference with the <a href="https://huggingface.co/docs/diffusers/v0.24.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights" rel="nofollow"><code>load_lora_weights</code></a> method. The <code>adapter_name</code> argument in the loading method is enabled by PEFT and allows you to set a name for the adapter so it is easier to reference.',re,_,oe,y,Ve='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/test-lora-diffusers.png"/>',ie,$,qe='Now let’s try another cool LoRA model, <a href="https://huggingface.co/ostris/super-cereal-sdxl-lora" rel="nofollow">ostris/super-cereal-sdxl-lora</a>. All you need to do is load and name this new adapter with <code>adapter_name</code>, and use the <a href="https://huggingface.co/docs/diffusers/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters" rel="nofollow"><code>set_adapters</code></a> method to set it as the currently active adapter.',pe,k,fe,b,Ae='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/test-lora-diffusers-2.png"/>',de,W,Ne='Finally, you can call the <a href="https://huggingface.co/docs/diffusers/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.disable_lora" rel="nofollow"><code>disable_lora</code></a> method to restore the base model.',me,v,ue,U,Pe='Learn more about how PEFT supports Diffusers in the <a href="https://huggingface.co/docs/diffusers/tutorials/using_peft_for_inference" rel="nofollow">Inference with PEFT</a> tutorial.',ce,B,he,C,Se='🤗 <a href="https://hf.co/docs/transformers" rel="nofollow">Transformers</a> is a collection of pretrained models for all types of tasks in all modalities. You can load these models for training or inference. Many of the models are large language models (LLMs), so it makes sense to integrate PEFT with Transformers to manage and train adapters.',Me,G,Qe="Load a base pretrained model to train.",ye,L,be,H,ze='Next, add an adapter configuration to specify how to adapt the model parameters. Call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> method to add the configuration to the base model.',we,F,ge,x,De='Now you can train the model with Transformer’s <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class or whichever training framework you prefer.',Te,R,Ke='To use the newly trained model for inference, the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModel" rel="nofollow">AutoModel</a> class uses PEFT on the backend to load the adapter weights and configuration file into a base pretrained model.',je,E,Je,X,Oe='Alternatively, you can use transformers <a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">Pipelines</a> to load the model for conveniently running inference:',Ze,I,_e,Y,et='If you’re interested in comparing or using more than one adapter, you can call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> method to add the adapter configuration to the base model. The only requirement is the adapter type must be the same (you can’t mix a LoRA and LoHa adapter).',$e,V,ke,q,tt='Call <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> again to attach a new adapter to the base model.',We,A,ve,N,at='Then you can use <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.set_adapter">set_adapter()</a> to set the currently active adapter.',Ue,P,Be,S,lt='To disable the adapter, call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.disable_adapter">disable_adapter()</a> method.',Ce,Q,Ge,z,st='If you’re curious, check out the <a href="https://huggingface.co/docs/transformers/main/peft" rel="nofollow">Load and train adapters with PEFT</a> tutorial to learn more.',Le,K,He;return w=new xe({props:{title:"PEFT integrations",local:"peft-integrations",headingTag:"h1"}}),j=new xe({props:{title:"Diffusers",local:"diffusers",headingTag:"h2"}}),_=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIycGVmdC1pbnRlcm5hbC10ZXN0aW5nJTJGYXJ0aWZpY2lhbGd1eWJyX18zRFJlZG1vbmQtVjElMjIlMkMlMjAlMEElMjAlMjAlMjAlMjB3ZWlnaHRfbmFtZSUzRCUyMjNEUmVkbW9uZC0zRFJlbmRlclN0eWxlLTNEUmVuZGVyQUYuc2FmZXRlbnNvcnMlMjIlMkMlMjAlMEElMjAlMjAlMjAlMjBhZGFwdGVyX25hbWUlM0QlMjIzZCUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnN1c2hpJTIwcm9sbHMlMjBzaGFwZWQlMjBsaWtlJTIwa2F3YWlpJTIwY2F0JTIwZmFjZXMlMjIpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(
    <span class="hljs-string">&quot;peft-internal-testing/artificialguybr__3DRedmond-V1&quot;</span>, 
    weight_name=<span class="hljs-string">&quot;3DRedmond-3DRenderStyle-3DRenderAF.safetensors&quot;</span>, 
    adapter_name=<span class="hljs-string">&quot;3d&quot;</span>
)
image = pipeline(<span class="hljs-string">&quot;sushi rolls shaped like kawaii cat faces&quot;</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),k=new h({props:{code:"cGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIyb3N0cmlzJTJGc3VwZXItY2VyZWFsLXNkeGwtbG9yYSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHdlaWdodF9uYW1lJTNEJTIyY2VyZWFsX2JveF9zZHhsX3YxLnNhZmV0ZW5zb3JzJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEJTIyY2VyZWFsJTIyJTBBKSUwQXBpcGVsaW5lLnNldF9hZGFwdGVycyglMjJjZXJlYWwlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJzdXNoaSUyMHJvbGxzJTIwc2hhcGVkJTIwbGlrZSUyMGthd2FpaSUyMGNhdCUyMGZhY2VzJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`pipeline.load_lora_weights(
    <span class="hljs-string">&quot;ostris/super-cereal-sdxl-lora&quot;</span>, 
    weight_name=<span class="hljs-string">&quot;cereal_box_sdxl_v1.safetensors&quot;</span>, 
    adapter_name=<span class="hljs-string">&quot;cereal&quot;</span>
)
pipeline.set_adapters(<span class="hljs-string">&quot;cereal&quot;</span>)
image = pipeline(<span class="hljs-string">&quot;sushi rolls shaped like kawaii cat faces&quot;</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),v=new h({props:{code:"cGlwZWxpbmUuZGlzYWJsZV9sb3JhKCk=",highlighted:"pipeline.disable_lora()",wrap:!1}}),B=new xe({props:{title:"Transformers",local:"transformers",headingTag:"h2"}}),L=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)`,wrap:!1}}),F=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjElMkMlMEElMjAlMjAlMjAlMjByJTNENjQlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUwQSklMEFtb2RlbC5hZGRfYWRhcHRlcihwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)
model.add_adapter(peft_config)`,wrap:!1}}),E=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIycGVmdC1pbnRlcm5hbC10ZXN0aW5nJTJGb3B0LTM1MG0tbG9yYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;peft-internal-testing/opt-350m-lora&quot;</span>)`,wrap:!1}}),I=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWwlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjAlMjJwZWZ0LWludGVybmFsLXRlc3RpbmclMkZvcHQtMzUwbS1sb3JhJTIyKSUwQXByaW50KG1vZGVsKCUyMkhlbGxvJTIwV29ybGQlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;peft-internal-testing/opt-350m-lora&quot;</span>)
<span class="hljs-built_in">print</span>(model(<span class="hljs-string">&quot;Hello World&quot;</span>))`,wrap:!1}}),V=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZ18xJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl8xJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
model.add_adapter(lora_config_1, adapter_name=<span class="hljs-string">&quot;adapter_1&quot;</span>)`,wrap:!1}}),A=new h({props:{code:"bW9kZWwuYWRkX2FkYXB0ZXIobG9yYV9jb25maWdfMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXJfMiUyMik=",highlighted:'model.add_adapter(lora_config_2, adapter_name=<span class="hljs-string">&quot;adapter_2&quot;</span>)',wrap:!1}}),P=new h({props:{code:"bW9kZWwuc2V0X2FkYXB0ZXIoJTIyYWRhcHRlcl8xJTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0X2Rpc2FibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`model.set_adapter(<span class="hljs-string">&quot;adapter_1&quot;</span>)
output = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_disabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),Q=new h({props:{code:"bW9kZWwuZGlzYWJsZV9hZGFwdGVyKCk=",highlighted:"model.disable_adapter()",wrap:!1}}),{c(){M=r("meta"),O=s(),D=r("p"),ee=s(),p(w.$$.fragment),te=s(),g=r("p"),g.innerHTML=Ee,ae=s(),T=r("p"),T.textContent=Xe,le=s(),p(j.$$.fragment),se=s(),J=r("p"),J.textContent=Ie,ne=s(),Z=r("p"),Z.innerHTML=Ye,re=s(),p(_.$$.fragment),oe=s(),y=r("div"),y.innerHTML=Ve,ie=s(),$=r("p"),$.innerHTML=qe,pe=s(),p(k.$$.fragment),fe=s(),b=r("div"),b.innerHTML=Ae,de=s(),W=r("p"),W.innerHTML=Ne,me=s(),p(v.$$.fragment),ue=s(),U=r("p"),U.innerHTML=Pe,ce=s(),p(B.$$.fragment),he=s(),C=r("p"),C.innerHTML=Se,Me=s(),G=r("p"),G.textContent=Qe,ye=s(),p(L.$$.fragment),be=s(),H=r("p"),H.innerHTML=ze,we=s(),p(F.$$.fragment),ge=s(),x=r("p"),x.innerHTML=De,Te=s(),R=r("p"),R.innerHTML=Ke,je=s(),p(E.$$.fragment),Je=s(),X=r("p"),X.innerHTML=Oe,Ze=s(),p(I.$$.fragment),_e=s(),Y=r("p"),Y.innerHTML=et,$e=s(),p(V.$$.fragment),ke=s(),q=r("p"),q.innerHTML=tt,We=s(),p(A.$$.fragment),ve=s(),N=r("p"),N.innerHTML=at,Ue=s(),p(P.$$.fragment),Be=s(),S=r("p"),S.innerHTML=lt,Ce=s(),p(Q.$$.fragment),Ge=s(),z=r("p"),z.innerHTML=st,Le=s(),K=r("p"),this.h()},l(e){const t=dt("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(a),O=n(e),D=o(e,"P",{}),nt(D).forEach(a),ee=n(e),f(w.$$.fragment,e),te=n(e),g=o(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-a6a8i"&&(g.innerHTML=Ee),ae=n(e),T=o(e,"P",{"data-svelte-h":!0}),i(T)!=="svelte-4mutq9"&&(T.textContent=Xe),le=n(e),f(j.$$.fragment,e),se=n(e),J=o(e,"P",{"data-svelte-h":!0}),i(J)!=="svelte-d4l0h1"&&(J.textContent=Ie),ne=n(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-rcmzt6"&&(Z.innerHTML=Ye),re=n(e),f(_.$$.fragment,e),oe=n(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),i(y)!=="svelte-1cw2tql"&&(y.innerHTML=Ve),ie=n(e),$=o(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-4vggr3"&&($.innerHTML=qe),pe=n(e),f(k.$$.fragment,e),fe=n(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),i(b)!=="svelte-pvy16"&&(b.innerHTML=Ae),de=n(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-dtlzi"&&(W.innerHTML=Ne),me=n(e),f(v.$$.fragment,e),ue=n(e),U=o(e,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1nfye23"&&(U.innerHTML=Pe),ce=n(e),f(B.$$.fragment,e),he=n(e),C=o(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1b1b0a9"&&(C.innerHTML=Se),Me=n(e),G=o(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-luca6i"&&(G.textContent=Qe),ye=n(e),f(L.$$.fragment,e),be=n(e),H=o(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-ycm3gd"&&(H.innerHTML=ze),we=n(e),f(F.$$.fragment,e),ge=n(e),x=o(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-rsm0q6"&&(x.innerHTML=De),Te=n(e),R=o(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-11qdvon"&&(R.innerHTML=Ke),je=n(e),f(E.$$.fragment,e),Je=n(e),X=o(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1xfm1"&&(X.innerHTML=Oe),Ze=n(e),f(I.$$.fragment,e),_e=n(e),Y=o(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1vwya0n"&&(Y.innerHTML=et),$e=n(e),f(V.$$.fragment,e),ke=n(e),q=o(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1pcj5p1"&&(q.innerHTML=tt),We=n(e),f(A.$$.fragment,e),ve=n(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-ug4ykr"&&(N.innerHTML=at),Ue=n(e),f(P.$$.fragment,e),Be=n(e),S=o(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-163n7v0"&&(S.innerHTML=lt),Ce=n(e),f(Q.$$.fragment,e),Ge=n(e),z=o(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1o6emrm"&&(z.innerHTML=st),Le=n(e),K=o(e,"P",{}),nt(K).forEach(a),this.h()},h(){Fe(M,"name","hf:doc:metadata"),Fe(M,"content",ct),Fe(y,"class","flex justify-center"),Fe(b,"class","flex justify-center")},m(e,t){mt(document.head,M),l(e,O,t),l(e,D,t),l(e,ee,t),d(w,e,t),l(e,te,t),l(e,g,t),l(e,ae,t),l(e,T,t),l(e,le,t),d(j,e,t),l(e,se,t),l(e,J,t),l(e,ne,t),l(e,Z,t),l(e,re,t),d(_,e,t),l(e,oe,t),l(e,y,t),l(e,ie,t),l(e,$,t),l(e,pe,t),d(k,e,t),l(e,fe,t),l(e,b,t),l(e,de,t),l(e,W,t),l(e,me,t),d(v,e,t),l(e,ue,t),l(e,U,t),l(e,ce,t),d(B,e,t),l(e,he,t),l(e,C,t),l(e,Me,t),l(e,G,t),l(e,ye,t),d(L,e,t),l(e,be,t),l(e,H,t),l(e,we,t),d(F,e,t),l(e,ge,t),l(e,x,t),l(e,Te,t),l(e,R,t),l(e,je,t),d(E,e,t),l(e,Je,t),l(e,X,t),l(e,Ze,t),d(I,e,t),l(e,_e,t),l(e,Y,t),l(e,$e,t),d(V,e,t),l(e,ke,t),l(e,q,t),l(e,We,t),d(A,e,t),l(e,ve,t),l(e,N,t),l(e,Ue,t),d(P,e,t),l(e,Be,t),l(e,S,t),l(e,Ce,t),d(Q,e,t),l(e,Ge,t),l(e,z,t),l(e,Le,t),l(e,K,t),He=!0},p:ot,i(e){He||(m(w.$$.fragment,e),m(j.$$.fragment,e),m(_.$$.fragment,e),m(k.$$.fragment,e),m(v.$$.fragment,e),m(B.$$.fragment,e),m(L.$$.fragment,e),m(F.$$.fragment,e),m(E.$$.fragment,e),m(I.$$.fragment,e),m(V.$$.fragment,e),m(A.$$.fragment,e),m(P.$$.fragment,e),m(Q.$$.fragment,e),He=!0)},o(e){u(w.$$.fragment,e),u(j.$$.fragment,e),u(_.$$.fragment,e),u(k.$$.fragment,e),u(v.$$.fragment,e),u(B.$$.fragment,e),u(L.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(I.$$.fragment,e),u(V.$$.fragment,e),u(A.$$.fragment,e),u(P.$$.fragment,e),u(Q.$$.fragment,e),He=!1},d(e){e&&(a(O),a(D),a(ee),a(te),a(g),a(ae),a(T),a(le),a(se),a(J),a(ne),a(Z),a(re),a(oe),a(y),a(ie),a($),a(pe),a(fe),a(b),a(de),a(W),a(me),a(ue),a(U),a(ce),a(he),a(C),a(Me),a(G),a(ye),a(be),a(H),a(we),a(ge),a(x),a(Te),a(R),a(je),a(Je),a(X),a(Ze),a(_e),a(Y),a($e),a(ke),a(q),a(We),a(ve),a(N),a(Ue),a(Be),a(S),a(Ce),a(Ge),a(z),a(Le),a(K)),a(M),c(w,e),c(j,e),c(_,e),c(k,e),c(v,e),c(B,e),c(L,e),c(F,e),c(E,e),c(I,e),c(V,e),c(A,e),c(P,e),c(Q,e)}}}const ct='{"title":"PEFT integrations","local":"peft-integrations","sections":[{"title":"Diffusers","local":"diffusers","sections":[],"depth":2},{"title":"Transformers","local":"transformers","sections":[],"depth":2}],"depth":1}';function ht(Re){return it(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gt extends pt{constructor(M){super(),ft(this,M,ht,ut,rt,{})}}export{gt as component};
