import{s as Ae,n as Ce,o as He}from"../chunks/scheduler.69131cc3.js";import{S as Ee,i as ze,g as r,s as o,r as z,A as Se,h as l,f as i,c as a,j as xe,u as S,x as s,k as Le,y as ke,a as n,v as k,d as N,t as D,w as O}from"../chunks/index.e1f30d73.js";import{H as j}from"../chunks/Heading.0aab6758.js";function Ne(he){let d,q,H,I,h,G,m,me=`The release of new kinds of hardware led to the emergence of new training paradigms that better utilize them. Currently, this is in the form of training
in 8-bit precision using packages such as <a href="https://github.com/NVIDIA/TransformerEngine" rel="nofollow">TransformersEngine</a> (TE) or <a href="https://github.com/Azure/MS-AMP/tree/main" rel="nofollow">MS-AMP</a>.`,U,c,ce='For an introduction to the topics discussed today, we recommend reviewing the <a href="../usage_guides/low_precision_training.md">low-precision usage guide</a> as this documentation will reference it regularly.',B,f,R,p,fe="Below is a quick chart from the MS-AMP documentation showing the different bit-precisions for each solution during training:",W,u,pe="<thead><tr><th>Optimization Level</th> <th>Computation(GEMM)</th> <th>Comm</th> <th>Weight</th> <th>Master Weight</th> <th>Weight Gradient</th> <th>Optimizer States</th></tr></thead> <tbody><tr><td>FP16 AMP</td> <td>FP16</td> <td>FP32</td> <td>FP32</td> <td>N/A</td> <td>FP32</td> <td>FP32+FP32</td></tr> <tr><td>Nvidia TE</td> <td>FP8</td> <td>FP32</td> <td>FP32</td> <td>N/A</td> <td>FP32</td> <td>FP32+FP32</td></tr> <tr><td>MS-AMP O1</td> <td>FP8</td> <td>FP8</td> <td>FP16</td> <td>N/A</td> <td>FP8</td> <td>FP32+FP32</td></tr> <tr><td>MS-AMP O2</td> <td>FP8</td> <td>FP8</td> <td>FP16</td> <td>N/A</td> <td>FP8</td> <td>FP8+FP16</td></tr> <tr><td>MS-AMP O3</td> <td>FP8</td> <td>FP8</td> <td>FP8</td> <td>FP16</td> <td>FP8</td> <td>FP8+FP16</td></tr></tbody>",K,g,Q,P,ue="<code>TransformersEngine</code> is the first solution to trying to train in 8-bit floating point. It works by using drop-in replacement layers for certain ones in a model that utilize their FP8-engine to reduce the number of bits (such as 32 to 8) without degrading the final accuracy of the model.",V,w,ge="Specifically, 🤗 Accelerate will find and replace the following layers with <code>TransformersEngine</code> versions:",Y,v,Pe="<li><code>nn.LayerNorm</code> for <code>te.LayerNorm</code></li> <li><code>nn.Linear</code> for <code>te.Linear</code></li>",J,y,we="As a result we wind up with a model that has most of its layers in BF16, while some layers are in FP8 reducing some of the memory.",X,M,ve=`Anecdotally, we have noticed that performance gains don’t really start showing when using <code>TransformerEngine</code> until a large majority of the layers
in the model are made up of those two layers to replace. As a result, only larger models have shown performance improvements when the number of parameters is around and upwards of a few billion.`,Z,F,ye="The <code>TransformerEngine</code> can receive many different arguments that customize how it performs FP8 calculations and what they do. A full list of the arguments is available below:",ee,T,Me="<li><code>margin</code>: The margin to use for the gradient scaling.</li> <li><code>interval</code>: The interval to use for how often the scaling factor is recomputed.</li> <li><code>fp8_format``: The format to use for the FP8 recipe. Must be one of </code>E4M3<code>or</code>HYBRID`.</li> <li><code>amax_history_len</code>: The length of the history to use for the scaling factor computation</li> <li><code>amax_compute_algo</code>: The algorithm to use for the scaling factor computation. Must be one of <code>max</code> or <code>most_recent</code>.</li> <li><code>override_linear_precision</code>: Whether or not to execute <code>fprop</code>, <code>dgrad</code>, and <code>wgrad</code> GEMMS in higher precision.</li>",te,b,Fe='You can customize each of these as part of <a href="/docs/accelerate/main/en/package_reference/kwargs#accelerate.utils.FP8RecipeKwargs">utils.FP8RecipeKwargs</a> to help optimize performance of your models.',ie,_,Te="If we notice in the chart mentioned earlier, TE simply casts the computation layers into FP8, while everything else is in FP32. As a result this winds up utilizing the most memory but does so with the benefit of guaranteeing the least amount of loss in end accuracy during training.",ne,$,oe,x,be="MS-AMP takes a different approach to <code>TransformersEngine</code> by providing three different optimization levels to convert more operations in FP8 or FP16.",ae,L,_e="<li><p>The base optimization level (<code>O1</code>), passes communications of the weights (such as in DDP) in FP8, stores the weights of the model in FP16, and leaves the optimizer states in FP32. The main benefit of this optimization level is that we can reduce the communication bandwidth by essentially half. Additionally, more GPU memory is saved due to 1/2 of everything being cast in FP8, and the weights being cast to FP16. Notably, both the optimizer states remain in FP32.</p></li> <li><p>The second optimization level (<code>O2</code>) improves upon this by also reducing the precision of the optimizer states. One is in FP8 while the other is in FP16. Generally it’s been shown that this will only provide a net-gain of no degraded end accuracy, increased training speed, and reduced memory as now every state is either in FP16 or FP8.</p></li> <li><p>Finally, MS-AMP has a third optimization level (<code>O3</code>) which helps during DDP scenarios such as DeepSpeed. The weights of the model in memory are fully cast to FP8, and the master weights are now stored in FP16. This fully reduces memory by the highest factor as now not only is almost everything in FP8, only two states are left in FP16. Currently, only DeepSpeed versions up through 0.9.2 are supported, so this capability is not included in the 🤗 Accelerate integration</p></li>",re,A,le,C,$e="More experiments need to be performed but it’s been noted that combining both MS-AMP and TransformersEngine can lead to the highest throughput by relying on NVIDIA’s optimized FP8 operators and utilizing how MS-AMP reduces the memory overhead.",se,E,de;return h=new j({props:{title:"Low Precision Training Methods",local:"low-precision-training-methods",headingTag:"h1"}}),f=new j({props:{title:"A Quick Chart",local:"a-quick-chart",headingTag:"h2"}}),g=new j({props:{title:"TransformersEngine",local:"transformersengine",headingTag:"h2"}}),$=new j({props:{title:"MS-AMP",local:"ms-amp",headingTag:"h2"}}),A=new j({props:{title:"Combining the two",local:"combining-the-two",headingTag:"h2"}}),{c(){d=r("meta"),q=o(),H=r("p"),I=o(),z(h.$$.fragment),G=o(),m=r("p"),m.innerHTML=me,U=o(),c=r("p"),c.innerHTML=ce,B=o(),z(f.$$.fragment),R=o(),p=r("p"),p.textContent=fe,W=o(),u=r("table"),u.innerHTML=pe,K=o(),z(g.$$.fragment),Q=o(),P=r("p"),P.innerHTML=ue,V=o(),w=r("p"),w.innerHTML=ge,Y=o(),v=r("ul"),v.innerHTML=Pe,J=o(),y=r("p"),y.textContent=we,X=o(),M=r("p"),M.innerHTML=ve,Z=o(),F=r("p"),F.innerHTML=ye,ee=o(),T=r("ul"),T.innerHTML=Me,te=o(),b=r("p"),b.innerHTML=Fe,ie=o(),_=r("p"),_.textContent=Te,ne=o(),z($.$$.fragment),oe=o(),x=r("p"),x.innerHTML=be,ae=o(),L=r("ul"),L.innerHTML=_e,re=o(),z(A.$$.fragment),le=o(),C=r("p"),C.textContent=$e,se=o(),E=r("p"),this.h()},l(e){const t=Se("svelte-u9bgzb",document.head);d=l(t,"META",{name:!0,content:!0}),t.forEach(i),q=a(e),H=l(e,"P",{}),xe(H).forEach(i),I=a(e),S(h.$$.fragment,e),G=a(e),m=l(e,"P",{"data-svelte-h":!0}),s(m)!=="svelte-aypt7s"&&(m.innerHTML=me),U=a(e),c=l(e,"P",{"data-svelte-h":!0}),s(c)!=="svelte-pi85p1"&&(c.innerHTML=ce),B=a(e),S(f.$$.fragment,e),R=a(e),p=l(e,"P",{"data-svelte-h":!0}),s(p)!=="svelte-exttfl"&&(p.textContent=fe),W=a(e),u=l(e,"TABLE",{"data-svelte-h":!0}),s(u)!=="svelte-1i0vsc4"&&(u.innerHTML=pe),K=a(e),S(g.$$.fragment,e),Q=a(e),P=l(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-11uhqfp"&&(P.innerHTML=ue),V=a(e),w=l(e,"P",{"data-svelte-h":!0}),s(w)!=="svelte-j7fjbc"&&(w.innerHTML=ge),Y=a(e),v=l(e,"UL",{"data-svelte-h":!0}),s(v)!=="svelte-skm64u"&&(v.innerHTML=Pe),J=a(e),y=l(e,"P",{"data-svelte-h":!0}),s(y)!=="svelte-j7rttk"&&(y.textContent=we),X=a(e),M=l(e,"P",{"data-svelte-h":!0}),s(M)!=="svelte-1jj2y1j"&&(M.innerHTML=ve),Z=a(e),F=l(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-14x2a3p"&&(F.innerHTML=ye),ee=a(e),T=l(e,"UL",{"data-svelte-h":!0}),s(T)!=="svelte-1w7auuv"&&(T.innerHTML=Me),te=a(e),b=l(e,"P",{"data-svelte-h":!0}),s(b)!=="svelte-8miud8"&&(b.innerHTML=Fe),ie=a(e),_=l(e,"P",{"data-svelte-h":!0}),s(_)!=="svelte-1fdva09"&&(_.textContent=Te),ne=a(e),S($.$$.fragment,e),oe=a(e),x=l(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-wkik4f"&&(x.innerHTML=be),ae=a(e),L=l(e,"UL",{"data-svelte-h":!0}),s(L)!=="svelte-1700yv9"&&(L.innerHTML=_e),re=a(e),S(A.$$.fragment,e),le=a(e),C=l(e,"P",{"data-svelte-h":!0}),s(C)!=="svelte-1nx3yqq"&&(C.textContent=$e),se=a(e),E=l(e,"P",{}),xe(E).forEach(i),this.h()},h(){Le(d,"name","hf:doc:metadata"),Le(d,"content",De)},m(e,t){ke(document.head,d),n(e,q,t),n(e,H,t),n(e,I,t),k(h,e,t),n(e,G,t),n(e,m,t),n(e,U,t),n(e,c,t),n(e,B,t),k(f,e,t),n(e,R,t),n(e,p,t),n(e,W,t),n(e,u,t),n(e,K,t),k(g,e,t),n(e,Q,t),n(e,P,t),n(e,V,t),n(e,w,t),n(e,Y,t),n(e,v,t),n(e,J,t),n(e,y,t),n(e,X,t),n(e,M,t),n(e,Z,t),n(e,F,t),n(e,ee,t),n(e,T,t),n(e,te,t),n(e,b,t),n(e,ie,t),n(e,_,t),n(e,ne,t),k($,e,t),n(e,oe,t),n(e,x,t),n(e,ae,t),n(e,L,t),n(e,re,t),k(A,e,t),n(e,le,t),n(e,C,t),n(e,se,t),n(e,E,t),de=!0},p:Ce,i(e){de||(N(h.$$.fragment,e),N(f.$$.fragment,e),N(g.$$.fragment,e),N($.$$.fragment,e),N(A.$$.fragment,e),de=!0)},o(e){D(h.$$.fragment,e),D(f.$$.fragment,e),D(g.$$.fragment,e),D($.$$.fragment,e),D(A.$$.fragment,e),de=!1},d(e){e&&(i(q),i(H),i(I),i(G),i(m),i(U),i(c),i(B),i(R),i(p),i(W),i(u),i(K),i(Q),i(P),i(V),i(w),i(Y),i(v),i(J),i(y),i(X),i(M),i(Z),i(F),i(ee),i(T),i(te),i(b),i(ie),i(_),i(ne),i(oe),i(x),i(ae),i(L),i(re),i(le),i(C),i(se),i(E)),i(d),O(h,e),O(f,e),O(g,e),O($,e),O(A,e)}}}const De='{"title":"Low Precision Training Methods","local":"low-precision-training-methods","sections":[{"title":"A Quick Chart","local":"a-quick-chart","sections":[],"depth":2},{"title":"TransformersEngine","local":"transformersengine","sections":[],"depth":2},{"title":"MS-AMP","local":"ms-amp","sections":[],"depth":2},{"title":"Combining the two","local":"combining-the-two","sections":[],"depth":2}],"depth":1}';function Oe(he){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ge extends Ee{constructor(d){super(),ze(this,d,Oe,Ne,Ae,{})}}export{Ge as component};
