import{s as _e,o as Xe,n as Re}from"../chunks/scheduler.924d507e.js";import{S as Ze,i as ke,g as d,s as a,r as p,A as Ge,h as y,f as t,c as n,j as ge,u as o,x as m,k as Ie,y as Be,a as s,v as i,d as M,t as r,w as c}from"../chunks/index.0ece89e8.js";import{T as Ve}from"../chunks/Tip.a5ce8f1d.js";import{C as u}from"../chunks/CodeBlock.d01ac312.js";import{D as xe}from"../chunks/DocNotebookDropdown.44b969cf.js";import{H as Ml}from"../chunks/Heading.c9bff43c.js";function ve(dl){let h,b='💡 Read <a href="https://arxiv.org/abs/2101.00190" rel="nofollow">Prefix-Tuning: Optimizing Continuous Prompts for Generation</a> to learn more about prefix tuning.';return{c(){h=d("p"),h.innerHTML=b},l(J){h=y(J,"P",{"data-svelte-h":!0}),m(h)!=="svelte-pk9gid"&&(h.innerHTML=b)},m(J,rl){s(J,h,rl)},p:Re,d(J){J&&t(h)}}}function We(dl){let h,b,J,rl,T,yl,w,ml,j,ae="Prefix tuning is an additive method where only a sequence of continuous task-specific vectors is attached to the beginning of the input, or <em>prefix</em>. Only the prefix parameters are optimized and added to the hidden states in every layer of the model. The tokens of the input sequence can still attend to the prefix as <em>virtual tokens</em>. As a result, prefix tuning stores 1000x fewer parameters than a fully finetuned model, which means you can use one large language model for many tasks.",hl,U,ul,f,ne='This guide will show you how to apply prefix tuning to train a <a href="https://huggingface.co/t5-large" rel="nofollow"><code>t5-large</code></a> model on the <code>sentences_allagree</code> subset of the <a href="https://huggingface.co/datasets/financial_phrasebank" rel="nofollow">financial_phrasebank</a> dataset.',Jl,C,pe="Before you begin, make sure you have all the necessary libraries installed:",Ul,g,bl,I,Tl,_,oe="Start by defining the model and tokenizer, text and label columns, and some hyperparameters so it’ll be easier to start training faster later. Set the environment variable <code>TOKENIZERS_PARALLELSIM</code> to <code>false</code> to disable the fast Rust-based tokenizer which processes data in parallel by default so you can use multiprocessing in Python.",wl,X,jl,R,fl,Z,ie='For this guide, you’ll train on the <code>sentences_allagree</code> subset of the <a href="https://huggingface.co/datasets/financial_phrasebank" rel="nofollow"><code>financial_phrasebank</code></a> dataset. This dataset contains financial news categorized by sentiment.',Cl,k,Me='Use 🤗 <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">Datasets</a> <a href="https://huggingface.co/docs/datasets/v2.15.0/en/package_reference/main_classes#datasets.Dataset.train_test_split" rel="nofollow">train_test_split</a> function to create a training and validation split and convert the <code>label</code> value to the more readable <code>text_label</code>. All of the changes can be applied with the <a href="https://huggingface.co/docs/datasets/v2.15.0/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> function:',gl,G,Il,B,_l,V,re="Initialize a tokenizer, and create a function to pad and truncate the <code>model_inputs</code> and <code>labels</code>:",Xl,x,Rl,v,ce='Use the <a href="https://huggingface.co/docs/datasets/v2.15.0/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> function to apply the <code>preprocess_function</code> to the dataset. You can remove the unprocessed columns since the model doesn’t need them anymore:',Zl,W,kl,Q,de='Create a <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a> from the <code>train</code> and <code>eval</code> datasets. Set <code>pin_memory=True</code> to speed up the data transfer to the GPU during training if the samples in your dataset are on a CPU.',Gl,$,Bl,Y,Vl,N,ye='Now you can setup your model and make sure it is ready for training. Specify the task in <a href="/docs/peft/v0.7.1/en/package_reference/prefix_tuning#peft.PrefixTuningConfig">PrefixTuningConfig</a>, create the base <code>t5-large</code> model from <a href="https://huggingface.co/docs/transformers/v4.36.0/en/model_doc/auto#transformers.AutoModelForSeq2SeqLM" rel="nofollow">AutoModelForSeq2SeqLM</a>, and then wrap the model and configuration in a <a href="/docs/peft/v0.7.1/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>. Feel free to print the <a href="/docs/peft/v0.7.1/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>’s parameters and compare it to fully training all the model parameters to see how much more efficient it is!',xl,F,vl,E,me="Setup the optimizer and learning rate scheduler:",Wl,A,Ql,S,he="Move the model to the GPU, and then write a training loop to begin!",$l,z,Yl,H,ue="Let’s see how well the model performs on the validation set:",Nl,q,Fl,L,Je="97% accuracy in just a few minutes; pretty good!",El,P,Al,D,Ue="You can store and share your model on the Hub if you’d like. Login to your Hugging Face account and enter your token when prompted:",Sl,K,zl,O,be='Upload the model to a specifc model repository on the Hub with the <a href="https://huggingface.co/docs/transformers/v4.36.0/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> function:',Hl,ll,ql,el,Te="If you check the model file size in the repository, you’ll see that it is only 3.93MB! 🤏",Ll,tl,Pl,sl,we="Once the model has been uploaded to the Hub, anyone can easily use it for inference. Load the configuration and model:",Dl,al,Kl,nl,je="Get and tokenize some text about financial news:",Ol,pl,le,ol,fe="Put the model on a GPU and <em>generate</em> the predicted text sentiment:",ee,il,te,cl,se;return T=new Ml({props:{title:"Prefix tuning for conditional generation",local:"prefix-tuning-for-conditional-generation",headingTag:"h1"}}),w=new xe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/peft_doc/en/seq2seq-prefix-tuning.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/peft_doc/en/pytorch/seq2seq-prefix-tuning.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/peft_doc/en/tensorflow/seq2seq-prefix-tuning.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/peft_doc/en/seq2seq-prefix-tuning.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/peft_doc/en/pytorch/seq2seq-prefix-tuning.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/peft_doc/en/tensorflow/seq2seq-prefix-tuning.ipynb"}]}}),U=new Ve({props:{$$slots:{default:[ve]},$$scope:{ctx:dl}}}),g=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHBlZnQlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cw==",highlighted:"!pip install -q peft transformers datasets",wrap:!1}}),I=new Ml({props:{title:"Setup",local:"setup",headingTag:"h2"}}),X=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMkMlMjBkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjBnZXRfbGluZWFyX3NjaGVkdWxlX3dpdGhfd2FybXVwJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9jb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUyQyUyMGdldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QlMkMlMjBQcmVmaXhUdW5pbmdDb25maWclMkMlMjBUYXNrVHlwZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhJTIwaW1wb3J0JTIwRGF0YUxvYWRlciUwQWZyb20lMjB0cWRtJTIwaW1wb3J0JTIwdHFkbSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEElMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTBBb3MuZW52aXJvbiU1QiUyMkNVREFfVklTSUJMRV9ERVZJQ0VTJTIyJTVEJTIwJTNEJTIwJTIyMyUyMiUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9uYW1lX29yX3BhdGglMjAlM0QlMjAlMjJ0NS1sYXJnZSUyMiUwQXRva2VuaXplcl9uYW1lX29yX3BhdGglMjAlM0QlMjAlMjJ0NS1sYXJnZSUyMiUwQSUwQXRleHRfY29sdW1uJTIwJTNEJTIwJTIyc2VudGVuY2UlMjIlMEFsYWJlbF9jb2x1bW4lMjAlM0QlMjAlMjJ0ZXh0X2xhYmVsJTIyJTBBbWF4X2xlbmd0aCUyMCUzRCUyMDEyOCUwQWxyJTIwJTNEJTIwMWUtMiUwQW51bV9lcG9jaHMlMjAlM0QlMjA1JTBBYmF0Y2hfc2l6ZSUyMCUzRCUyMDg=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM, default_data_collator, get_linear_schedule_with_warmup
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_config, get_peft_model, get_peft_model_state_dict, PrefixTuningConfig, TaskType
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>
os.environ[<span class="hljs-string">&quot;CUDA_VISIBLE_DEVICES&quot;</span>] = <span class="hljs-string">&quot;3&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_name_or_path = <span class="hljs-string">&quot;t5-large&quot;</span>
tokenizer_name_or_path = <span class="hljs-string">&quot;t5-large&quot;</span>

text_column = <span class="hljs-string">&quot;sentence&quot;</span>
label_column = <span class="hljs-string">&quot;text_label&quot;</span>
max_length = <span class="hljs-number">128</span>
lr = <span class="hljs-number">1e-2</span>
num_epochs = <span class="hljs-number">5</span>
batch_size = <span class="hljs-number">8</span>`,wrap:!1}}),R=new Ml({props:{title:"Load dataset",local:"load-dataset",headingTag:"h2"}}),G=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmaW5hbmNpYWxfcGhyYXNlYmFuayUyMiUyQyUyMCUyMnNlbnRlbmNlc19hbGxhZ3JlZSUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELnRyYWluX3Rlc3Rfc3BsaXQodGVzdF9zaXplJTNEMC4xKSUwQWRhdGFzZXQlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlMEFkZWwlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUwQSUwQWNsYXNzZXMlMjAlM0QlMjBkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQuZmVhdHVyZXMlNUIlMjJsYWJlbCUyMiU1RC5uYW1lcyUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwJTdCJTIydGV4dF9sYWJlbCUyMiUzQSUyMCU1QmNsYXNzZXMlNUJsYWJlbCU1RCUyMGZvciUyMGxhYmVsJTIwaW4lMjB4JTVCJTIybGFiZWwlMjIlNUQlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSklMEElMEFkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVEJTBBJTdCJTIyc2VudGVuY2UlMjIlM0ElMjAlMjJQcm9maXQlMjBiZWZvcmUlMjB0YXhlcyUyMHdhcyUyMEVVUiUyMDQuMCUyMG1uJTIwJTJDJTIwZG93biUyMGZyb20lMjBFVVIlMjA0LjklMjBtbiUyMC4lMjIlMkMlMjAlMjJsYWJlbCUyMiUzQSUyMDAlMkMlMjAlMjJ0ZXh0X2xhYmVsJTIyJTNBJTIwJTIybmVnYXRpdmUlMjIlN0Q=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;financial_phrasebank&quot;</span>, <span class="hljs-string">&quot;sentences_allagree&quot;</span>)
dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=<span class="hljs-number">0.1</span>)
dataset[<span class="hljs-string">&quot;validation&quot;</span>] = dataset[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-keyword">del</span> dataset[<span class="hljs-string">&quot;test&quot;</span>]

classes = dataset[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
dataset = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;text_label&quot;</span>: [classes[label] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> x[<span class="hljs-string">&quot;label&quot;</span>]]},
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
)

dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;sentence&quot;</span>: <span class="hljs-string">&quot;Profit before taxes was EUR 4.0 mn , down from EUR 4.9 mn .&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;text_label&quot;</span>: <span class="hljs-string">&quot;negative&quot;</span>}`,wrap:!1}}),B=new Ml({props:{title:"Preprocess dataset",local:"preprocess-dataset",headingTag:"h2"}}),x=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZV9vcl9wYXRoKSUwQSUwQSUwQWRlZiUyMHByZXByb2Nlc3NfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwZXhhbXBsZXMlNUJ0ZXh0X2NvbHVtbiU1RCUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjBleGFtcGxlcyU1QmxhYmVsX2NvbHVtbiU1RCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplcihpbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEbWF4X2xlbmd0aCUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMHRva2VuaXplcih0YXJnZXRzJTJDJTIwbWF4X2xlbmd0aCUzRDIlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjBsYWJlbHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbHMlNUJsYWJlbHMlMjAlM0QlM0QlMjB0b2tlbml6ZXIucGFkX3Rva2VuX2lkJTVEJTIwJTNEJTIwLTEwMCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1vZGVsX2lucHV0cw==",highlighted:`tokenizer = AutoTokenizer.from_pretrained(model_name_or_path)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    inputs = examples[text_column]
    targets = examples[label_column]
    model_inputs = tokenizer(inputs, max_length=max_length, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = tokenizer(targets, max_length=<span class="hljs-number">2</span>, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = labels[<span class="hljs-string">&quot;input_ids&quot;</span>]
    labels[labels == tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
    model_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels
    <span class="hljs-keyword">return</span> model_inputs`,wrap:!1}}),W=new u({props:{code:"cHJvY2Vzc2VkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19mdW5jdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoZWQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Byb2MlM0QxJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX2NvbHVtbnMlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQuY29sdW1uX25hbWVzJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9mcm9tX2NhY2hlX2ZpbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2MlM0QlMjJSdW5uaW5nJTIwdG9rZW5pemVyJTIwb24lMjBkYXRhc2V0JTIyJTJDJTBBKQ==",highlighted:`processed_datasets = dataset.<span class="hljs-built_in">map</span>(
    preprocess_function,
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
    remove_columns=dataset[<span class="hljs-string">&quot;train&quot;</span>].column_names,
    load_from_cache_file=<span class="hljs-literal">False</span>,
    desc=<span class="hljs-string">&quot;Running tokenizer on dataset&quot;</span>,
)`,wrap:!1}}),$=new u({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMHByb2Nlc3NlZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTBBZXZhbF9kYXRhc2V0JTIwJTNEJTIwcHJvY2Vzc2VkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCUwQSUwQXRyYWluX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKCUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGNvbGxhdGVfZm4lM0RkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMHBpbl9tZW1vcnklM0RUcnVlJTBBKSUwQWV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZXZhbF9kYXRhc2V0JTJDJTIwY29sbGF0ZV9mbiUzRGRlZmF1bHRfZGF0YV9jb2xsYXRvciUyQyUyMGJhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTIwcGluX21lbW9yeSUzRFRydWUp",highlighted:`train_dataset = processed_datasets[<span class="hljs-string">&quot;train&quot;</span>]
eval_dataset = processed_datasets[<span class="hljs-string">&quot;validation&quot;</span>]

train_dataloader = DataLoader(
    train_dataset, shuffle=<span class="hljs-literal">True</span>, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>
)
eval_dataloader = DataLoader(eval_dataset, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)`,wrap:!1}}),Y=new Ml({props:{title:"Train model",local:"train-model",headingTag:"h2"}}),F=new u({props:{code:"cGVmdF9jb25maWclMjAlM0QlMjBQcmVmaXhUdW5pbmdDb25maWcodGFza190eXBlJTNEVGFza1R5cGUuU0VRXzJfU0VRX0xNJTJDJTIwaW5mZXJlbmNlX21vZGUlM0RGYWxzZSUyQyUyMG51bV92aXJ0dWFsX3Rva2VucyUzRDIwKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lX29yX3BhdGgpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMHBlZnRfY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA5ODMwNDAlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA3Mzg2NTExMzYlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjEzMzA4NTgzMDY1NjU5ODM1JTIy",highlighted:`peft_config = PrefixTuningConfig(task_type=TaskType.SEQ_2_SEQ_LM, inference_mode=<span class="hljs-literal">False</span>, num_virtual_tokens=<span class="hljs-number">20</span>)

model = AutoModelForSeq2SeqLM.from_pretrained(model_name_or_path)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 983040 || all params: 738651136 || trainable%: 0.13308583065659835&quot;</span>`,wrap:!1}}),A=new u({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0RsciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfbGluZWFyX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBudW1fZXBvY2hzKSUyQyUwQSk=",highlighted:`optimizer = torch.optim.AdamW(model.parameters(), lr=lr)
lr_scheduler = get_linear_schedule_with_warmup(
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * num_epochs),
)`,wrap:!1}}),z=new u({props:{code:"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",highlighted:`model = model.to(device)

<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    model.train()
    total_loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(train_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        total_loss += loss.detach().<span class="hljs-built_in">float</span>()
        loss.backward()
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()

    model.<span class="hljs-built_in">eval</span>()
    eval_loss = <span class="hljs-number">0</span>
    eval_preds = []
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        <span class="hljs-keyword">with</span> torch.no_grad():
            outputs = model(**batch)
        loss = outputs.loss
        eval_loss += loss.detach().<span class="hljs-built_in">float</span>()
        eval_preds.extend(
            tokenizer.batch_decode(torch.argmax(outputs.logits, -<span class="hljs-number">1</span>).detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)
        )

    eval_epoch_loss = eval_loss / <span class="hljs-built_in">len</span>(eval_dataloader)
    eval_ppl = torch.exp(eval_epoch_loss)
    train_epoch_loss = total_loss / <span class="hljs-built_in">len</span>(train_dataloader)
    train_ppl = torch.exp(train_epoch_loss)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{epoch=}</span>: <span class="hljs-subst">{train_ppl=}</span> <span class="hljs-subst">{train_epoch_loss=}</span> <span class="hljs-subst">{eval_ppl=}</span> <span class="hljs-subst">{eval_epoch_loss=}</span>&quot;</span>)`,wrap:!1}}),q=new u({props:{code:"Y29ycmVjdCUyMCUzRCUyMDAlMEF0b3RhbCUyMCUzRCUyMDAlMEFmb3IlMjBwcmVkJTJDJTIwdHJ1ZSUyMGluJTIwemlwKGV2YWxfcHJlZHMlMkMlMjBkYXRhc2V0JTVCJTIydmFsaWRhdGlvbiUyMiU1RCU1QiUyMnRleHRfbGFiZWwlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwcmVkLnN0cmlwKCklMjAlM0QlM0QlMjB0cnVlLnN0cmlwKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb3JyZWN0JTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMHRvdGFsJTIwJTJCJTNEJTIwMSUwQWFjY3VyYWN5JTIwJTNEJTIwY29ycmVjdCUyMCUyRiUyMHRvdGFsJTIwKiUyMDEwMCUwQXByaW50KGYlMjIlN0JhY2N1cmFjeSUzRCU3RCUyMCUyNSUyMG9uJTIwdGhlJTIwZXZhbHVhdGlvbiUyMGRhdGFzZXQlMjIpJTBBcHJpbnQoZiUyMiU3QmV2YWxfcHJlZHMlNUIlM0ExMCU1RCUzRCU3RCUyMiklMEFwcmludChmJTIyJTdCZGF0YXNldCU1Qid2YWxpZGF0aW9uJyU1RCU1Qid0ZXh0X2xhYmVsJyU1RCU1QiUzQTEwJTVEJTNEJTdEJTIyKSUwQSUyMmFjY3VyYWN5JTNEOTcuMzU2ODI4MTkzODMyNiUyMCUyNSUyMG9uJTIwdGhlJTIwZXZhbHVhdGlvbiUyMGRhdGFzZXQlMjIlMEElMjJldmFsX3ByZWRzJTVCJTNBMTAlNUQlM0QlNUInbmV1dHJhbCclMkMlMjAncG9zaXRpdmUnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ3Bvc2l0aXZlJyUyQyUyMCduZXV0cmFsJyUyQyUyMCduZWdhdGl2ZSclMkMlMjAnbmVnYXRpdmUnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ25ldXRyYWwnJTVEJTIyJTBBJTIyZGF0YXNldCU1Qid2YWxpZGF0aW9uJyU1RCU1Qid0ZXh0X2xhYmVsJyU1RCU1QiUzQTEwJTVEJTNEJTVCJ25ldXRyYWwnJTJDJTIwJ3Bvc2l0aXZlJyUyQyUyMCduZXV0cmFsJyUyQyUyMCdwb3NpdGl2ZSclMkMlMjAnbmV1dHJhbCclMkMlMjAnbmVnYXRpdmUnJTJDJTIwJ25lZ2F0aXZlJyUyQyUyMCduZXV0cmFsJyUyQyUyMCduZXV0cmFsJyUyQyUyMCduZXV0cmFsJyU1RCUyMg==",highlighted:`correct = <span class="hljs-number">0</span>
total = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> pred, true <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(eval_preds, dataset[<span class="hljs-string">&quot;validation&quot;</span>][<span class="hljs-string">&quot;text_label&quot;</span>]):
    <span class="hljs-keyword">if</span> pred.strip() == true.strip():
        correct += <span class="hljs-number">1</span>
    total += <span class="hljs-number">1</span>
accuracy = correct / total * <span class="hljs-number">100</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{accuracy=}</span> % on the evaluation dataset&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{eval_preds[:<span class="hljs-number">10</span>]=}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{dataset[<span class="hljs-string">&#x27;validation&#x27;</span>][<span class="hljs-string">&#x27;text_label&#x27;</span>][:<span class="hljs-number">10</span>]=}</span>&quot;</span>)
<span class="hljs-string">&quot;accuracy=97.3568281938326 % on the evaluation dataset&quot;</span>
<span class="hljs-string">&quot;eval_preds[:10]=[&#x27;neutral&#x27;, &#x27;positive&#x27;, &#x27;neutral&#x27;, &#x27;positive&#x27;, &#x27;neutral&#x27;, &#x27;negative&#x27;, &#x27;negative&#x27;, &#x27;neutral&#x27;, &#x27;neutral&#x27;, &#x27;neutral&#x27;]&quot;</span>
<span class="hljs-string">&quot;dataset[&#x27;validation&#x27;][&#x27;text_label&#x27;][:10]=[&#x27;neutral&#x27;, &#x27;positive&#x27;, &#x27;neutral&#x27;, &#x27;positive&#x27;, &#x27;neutral&#x27;, &#x27;negative&#x27;, &#x27;negative&#x27;, &#x27;neutral&#x27;, &#x27;neutral&#x27;, &#x27;neutral&#x27;]&quot;</span>`,wrap:!1}}),P=new Ml({props:{title:"Share model",local:"share-model",headingTag:"h2"}}),K=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),ll=new u({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMnlvdXItbmFtZSUyRnQ1LWxhcmdlX1BSRUZJWF9UVU5JTkdfU0VRMlNFUSUyMiUwQW1vZGVsLnB1c2hfdG9faHViKCUyMnlvdXItbmFtZSUyRnQ1LWxhcmdlX1BSRUZJWF9UVU5JTkdfU0VRMlNFUSUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSk=",highlighted:`peft_model_id = <span class="hljs-string">&quot;your-name/t5-large_PREFIX_TUNING_SEQ2SEQ&quot;</span>
model.push_to_hub(<span class="hljs-string">&quot;your-name/t5-large_PREFIX_TUNING_SEQ2SEQ&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)`,wrap:!1}}),tl=new Ml({props:{title:"Inference",local:"inference",headingTag:"h2"}}),al=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMnN0ZXZobGl1JTJGdDUtbGFyZ2VfUFJFRklYX1RVTklOR19TRVEyU0VRJTIyJTBBJTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoY29uZmlnLmJhc2VfbW9kZWxfbmFtZV9vcl9wYXRoKSUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

peft_model_id = <span class="hljs-string">&quot;stevhliu/t5-large_PREFIX_TUNING_SEQ2SEQ&quot;</span>

config = PeftConfig.from_pretrained(peft_model_id)
model = AutoModelForSeq2SeqLM.from_pretrained(config.base_model_name_or_path)
model = PeftModel.from_pretrained(model, peft_model_id)`,wrap:!1}}),pl=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMlRoZSUyMExpdGh1YW5pYW4lMjBiZWVyJTIwbWFya2V0JTIwbWFkZSUyMHVwJTIwMTQuNDElMjBtaWxsaW9uJTIwbGl0ZXJzJTIwaW4lMjBKYW51YXJ5JTIwJTJDJTIwYSUyMHJpc2UlMjBvZiUyMDAuOCUyMHBlcmNlbnQlMjBmcm9tJTIwdGhlJTIweWVhci1lYXJsaWVyJTIwZmlndXJlJTIwJTJDJTIwdGhlJTIwTGl0aHVhbmlhbiUyMEJyZXdlcnMlMjAnJTIwQXNzb2NpYXRpb24lMjByZXBvcnRpbmclMjBjaXRpbmclMjB0aGUlMjByZXN1bHRzJTIwZnJvbSUyMGl0cyUyMG1lbWJlcnMlMjAuJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSk=",highlighted:`inputs = tokenizer(
    <span class="hljs-string">&quot;The Lithuanian beer market made up 14.41 million liters in January , a rise of 0.8 percent from the year-earlier figure , the Lithuanian Brewers &#x27; Association reporting citing the results from its members .&quot;</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)`,wrap:!1}}),il=new u({props:{code:"bW9kZWwudG8oZGV2aWNlKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGlucHV0cy5pdGVtcygpJTdEJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0X2lkcyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzLmRldGFjaCgpLmNwdSgpLm51bXB5KCklMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJTIycG9zaXRpdmUlMjIlNUQ=",highlighted:`model.to(device)

<span class="hljs-keyword">with</span> torch.no_grad():
    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
    outputs = model.generate(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">10</span>)
    <span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;positive&quot;</span>]`,wrap:!1}}),{c(){h=d("meta"),b=a(),J=d("p"),rl=a(),p(T.$$.fragment),yl=a(),p(w.$$.fragment),ml=a(),j=d("p"),j.innerHTML=ae,hl=a(),p(U.$$.fragment),ul=a(),f=d("p"),f.innerHTML=ne,Jl=a(),C=d("p"),C.textContent=pe,Ul=a(),p(g.$$.fragment),bl=a(),p(I.$$.fragment),Tl=a(),_=d("p"),_.innerHTML=oe,wl=a(),p(X.$$.fragment),jl=a(),p(R.$$.fragment),fl=a(),Z=d("p"),Z.innerHTML=ie,Cl=a(),k=d("p"),k.innerHTML=Me,gl=a(),p(G.$$.fragment),Il=a(),p(B.$$.fragment),_l=a(),V=d("p"),V.innerHTML=re,Xl=a(),p(x.$$.fragment),Rl=a(),v=d("p"),v.innerHTML=ce,Zl=a(),p(W.$$.fragment),kl=a(),Q=d("p"),Q.innerHTML=de,Gl=a(),p($.$$.fragment),Bl=a(),p(Y.$$.fragment),Vl=a(),N=d("p"),N.innerHTML=ye,xl=a(),p(F.$$.fragment),vl=a(),E=d("p"),E.textContent=me,Wl=a(),p(A.$$.fragment),Ql=a(),S=d("p"),S.textContent=he,$l=a(),p(z.$$.fragment),Yl=a(),H=d("p"),H.textContent=ue,Nl=a(),p(q.$$.fragment),Fl=a(),L=d("p"),L.textContent=Je,El=a(),p(P.$$.fragment),Al=a(),D=d("p"),D.textContent=Ue,Sl=a(),p(K.$$.fragment),zl=a(),O=d("p"),O.innerHTML=be,Hl=a(),p(ll.$$.fragment),ql=a(),el=d("p"),el.textContent=Te,Ll=a(),p(tl.$$.fragment),Pl=a(),sl=d("p"),sl.textContent=we,Dl=a(),p(al.$$.fragment),Kl=a(),nl=d("p"),nl.textContent=je,Ol=a(),p(pl.$$.fragment),le=a(),ol=d("p"),ol.innerHTML=fe,ee=a(),p(il.$$.fragment),te=a(),cl=d("p"),this.h()},l(l){const e=Ge("svelte-u9bgzb",document.head);h=y(e,"META",{name:!0,content:!0}),e.forEach(t),b=n(l),J=y(l,"P",{}),ge(J).forEach(t),rl=n(l),o(T.$$.fragment,l),yl=n(l),o(w.$$.fragment,l),ml=n(l),j=y(l,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1vuqwet"&&(j.innerHTML=ae),hl=n(l),o(U.$$.fragment,l),ul=n(l),f=y(l,"P",{"data-svelte-h":!0}),m(f)!=="svelte-sx5yd3"&&(f.innerHTML=ne),Jl=n(l),C=y(l,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1c9nexd"&&(C.textContent=pe),Ul=n(l),o(g.$$.fragment,l),bl=n(l),o(I.$$.fragment,l),Tl=n(l),_=y(l,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1wwdjpw"&&(_.innerHTML=oe),wl=n(l),o(X.$$.fragment,l),jl=n(l),o(R.$$.fragment,l),fl=n(l),Z=y(l,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-vrfskg"&&(Z.innerHTML=ie),Cl=n(l),k=y(l,"P",{"data-svelte-h":!0}),m(k)!=="svelte-17av7d0"&&(k.innerHTML=Me),gl=n(l),o(G.$$.fragment,l),Il=n(l),o(B.$$.fragment,l),_l=n(l),V=y(l,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1gopa5"&&(V.innerHTML=re),Xl=n(l),o(x.$$.fragment,l),Rl=n(l),v=y(l,"P",{"data-svelte-h":!0}),m(v)!=="svelte-34xv1u"&&(v.innerHTML=ce),Zl=n(l),o(W.$$.fragment,l),kl=n(l),Q=y(l,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-j9si42"&&(Q.innerHTML=de),Gl=n(l),o($.$$.fragment,l),Bl=n(l),o(Y.$$.fragment,l),Vl=n(l),N=y(l,"P",{"data-svelte-h":!0}),m(N)!=="svelte-exeta3"&&(N.innerHTML=ye),xl=n(l),o(F.$$.fragment,l),vl=n(l),E=y(l,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1sjv5nb"&&(E.textContent=me),Wl=n(l),o(A.$$.fragment,l),Ql=n(l),S=y(l,"P",{"data-svelte-h":!0}),m(S)!=="svelte-12zfigq"&&(S.textContent=he),$l=n(l),o(z.$$.fragment,l),Yl=n(l),H=y(l,"P",{"data-svelte-h":!0}),m(H)!=="svelte-j4kbo3"&&(H.textContent=ue),Nl=n(l),o(q.$$.fragment,l),Fl=n(l),L=y(l,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1w41xzs"&&(L.textContent=Je),El=n(l),o(P.$$.fragment,l),Al=n(l),D=y(l,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1afj4t"&&(D.textContent=Ue),Sl=n(l),o(K.$$.fragment,l),zl=n(l),O=y(l,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1gjsaqf"&&(O.innerHTML=be),Hl=n(l),o(ll.$$.fragment,l),ql=n(l),el=y(l,"P",{"data-svelte-h":!0}),m(el)!=="svelte-1dg45c0"&&(el.textContent=Te),Ll=n(l),o(tl.$$.fragment,l),Pl=n(l),sl=y(l,"P",{"data-svelte-h":!0}),m(sl)!=="svelte-19d9n1k"&&(sl.textContent=we),Dl=n(l),o(al.$$.fragment,l),Kl=n(l),nl=y(l,"P",{"data-svelte-h":!0}),m(nl)!=="svelte-1t4ak78"&&(nl.textContent=je),Ol=n(l),o(pl.$$.fragment,l),le=n(l),ol=y(l,"P",{"data-svelte-h":!0}),m(ol)!=="svelte-1kl7nk7"&&(ol.innerHTML=fe),ee=n(l),o(il.$$.fragment,l),te=n(l),cl=y(l,"P",{}),ge(cl).forEach(t),this.h()},h(){Ie(h,"name","hf:doc:metadata"),Ie(h,"content",Qe)},m(l,e){Be(document.head,h),s(l,b,e),s(l,J,e),s(l,rl,e),i(T,l,e),s(l,yl,e),i(w,l,e),s(l,ml,e),s(l,j,e),s(l,hl,e),i(U,l,e),s(l,ul,e),s(l,f,e),s(l,Jl,e),s(l,C,e),s(l,Ul,e),i(g,l,e),s(l,bl,e),i(I,l,e),s(l,Tl,e),s(l,_,e),s(l,wl,e),i(X,l,e),s(l,jl,e),i(R,l,e),s(l,fl,e),s(l,Z,e),s(l,Cl,e),s(l,k,e),s(l,gl,e),i(G,l,e),s(l,Il,e),i(B,l,e),s(l,_l,e),s(l,V,e),s(l,Xl,e),i(x,l,e),s(l,Rl,e),s(l,v,e),s(l,Zl,e),i(W,l,e),s(l,kl,e),s(l,Q,e),s(l,Gl,e),i($,l,e),s(l,Bl,e),i(Y,l,e),s(l,Vl,e),s(l,N,e),s(l,xl,e),i(F,l,e),s(l,vl,e),s(l,E,e),s(l,Wl,e),i(A,l,e),s(l,Ql,e),s(l,S,e),s(l,$l,e),i(z,l,e),s(l,Yl,e),s(l,H,e),s(l,Nl,e),i(q,l,e),s(l,Fl,e),s(l,L,e),s(l,El,e),i(P,l,e),s(l,Al,e),s(l,D,e),s(l,Sl,e),i(K,l,e),s(l,zl,e),s(l,O,e),s(l,Hl,e),i(ll,l,e),s(l,ql,e),s(l,el,e),s(l,Ll,e),i(tl,l,e),s(l,Pl,e),s(l,sl,e),s(l,Dl,e),i(al,l,e),s(l,Kl,e),s(l,nl,e),s(l,Ol,e),i(pl,l,e),s(l,le,e),s(l,ol,e),s(l,ee,e),i(il,l,e),s(l,te,e),s(l,cl,e),se=!0},p(l,[e]){const Ce={};e&2&&(Ce.$$scope={dirty:e,ctx:l}),U.$set(Ce)},i(l){se||(M(T.$$.fragment,l),M(w.$$.fragment,l),M(U.$$.fragment,l),M(g.$$.fragment,l),M(I.$$.fragment,l),M(X.$$.fragment,l),M(R.$$.fragment,l),M(G.$$.fragment,l),M(B.$$.fragment,l),M(x.$$.fragment,l),M(W.$$.fragment,l),M($.$$.fragment,l),M(Y.$$.fragment,l),M(F.$$.fragment,l),M(A.$$.fragment,l),M(z.$$.fragment,l),M(q.$$.fragment,l),M(P.$$.fragment,l),M(K.$$.fragment,l),M(ll.$$.fragment,l),M(tl.$$.fragment,l),M(al.$$.fragment,l),M(pl.$$.fragment,l),M(il.$$.fragment,l),se=!0)},o(l){r(T.$$.fragment,l),r(w.$$.fragment,l),r(U.$$.fragment,l),r(g.$$.fragment,l),r(I.$$.fragment,l),r(X.$$.fragment,l),r(R.$$.fragment,l),r(G.$$.fragment,l),r(B.$$.fragment,l),r(x.$$.fragment,l),r(W.$$.fragment,l),r($.$$.fragment,l),r(Y.$$.fragment,l),r(F.$$.fragment,l),r(A.$$.fragment,l),r(z.$$.fragment,l),r(q.$$.fragment,l),r(P.$$.fragment,l),r(K.$$.fragment,l),r(ll.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(pl.$$.fragment,l),r(il.$$.fragment,l),se=!1},d(l){l&&(t(b),t(J),t(rl),t(yl),t(ml),t(j),t(hl),t(ul),t(f),t(Jl),t(C),t(Ul),t(bl),t(Tl),t(_),t(wl),t(jl),t(fl),t(Z),t(Cl),t(k),t(gl),t(Il),t(_l),t(V),t(Xl),t(Rl),t(v),t(Zl),t(kl),t(Q),t(Gl),t(Bl),t(Vl),t(N),t(xl),t(vl),t(E),t(Wl),t(Ql),t(S),t($l),t(Yl),t(H),t(Nl),t(Fl),t(L),t(El),t(Al),t(D),t(Sl),t(zl),t(O),t(Hl),t(ql),t(el),t(Ll),t(Pl),t(sl),t(Dl),t(Kl),t(nl),t(Ol),t(le),t(ol),t(ee),t(te),t(cl)),t(h),c(T,l),c(w,l),c(U,l),c(g,l),c(I,l),c(X,l),c(R,l),c(G,l),c(B,l),c(x,l),c(W,l),c($,l),c(Y,l),c(F,l),c(A,l),c(z,l),c(q,l),c(P,l),c(K,l),c(ll,l),c(tl,l),c(al,l),c(pl,l),c(il,l)}}}const Qe='{"title":"Prefix tuning for conditional generation","local":"prefix-tuning-for-conditional-generation","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Load dataset","local":"load-dataset","sections":[],"depth":2},{"title":"Preprocess dataset","local":"preprocess-dataset","sections":[],"depth":2},{"title":"Train model","local":"train-model","sections":[],"depth":2},{"title":"Share model","local":"share-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function $e(dl){return Xe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ze extends Ze{constructor(h){super(),ke(this,h,$e,We,_e,{})}}export{ze as component};
