import{s as at,n as lt,o as nt}from"../chunks/scheduler.924d507e.js";import{S as ot,i as st,g as o,s as l,r as F,A as rt,h as s,f as i,c as n,j as it,u as W,x as r,k as He,y as dt,a,v as G,d as Q,t as X,w as E}from"../chunks/index.0ece89e8.js";import{C as mt}from"../chunks/CodeBlock.d01ac312.js";import{H as S}from"../chunks/Heading.c9bff43c.js";function ft(ke){let d,D,Y,N,f,K,p,Pe=`This conceptual guide gives a brief overview of <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">LoRA</a>, a technique that accelerates
the fine-tuning of large models while consuming less memory.`,O,h,Je=`To make fine-tuning more efficient, LoRA’s approach is to represent the weight updates with two smaller
matrices (called <strong>update matrices</strong>) through low-rank decomposition. These new matrices can be trained to adapt to the
new data while keeping the overall number of changes low. The original weight matrix remains frozen and doesn’t receive
any further adjustments. To produce the final results, both the original and the adapted weights are combined.`,ee,u,ze="This approach has a number of advantages:",te,c,Ie="<li>LoRA makes fine-tuning more efficient by drastically reducing the number of trainable parameters.</li> <li>The original pre-trained weights are kept frozen, which means you can have multiple lightweight and portable LoRA models for various downstream tasks built on top of them.</li> <li>LoRA is orthogonal to many other parameter-efficient methods and can be combined with many of them.</li> <li>Performance of models fine-tuned using LoRA is comparable to the performance of fully fine-tuned models.</li> <li>LoRA does not add any inference latency because adapter weights can be merged with the base model.</li>",ie,g,Ue=`In principle, LoRA can be applied to any subset of weight matrices in a neural network to reduce the number of trainable
parameters. However, for simplicity and further parameter efficiency, in Transformer models LoRA is typically applied to
attention blocks only. The resulting number of trainable parameters in a LoRA model depends on the size of the low-rank
update matrices, which is determined mainly by the rank <code>r</code> and the shape of the original weight matrix.`,ae,w,le,b,je='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA model. To eliminate latency, use the <a href="/docs/peft/v0.7.1/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model which allows you to effectively use the newly merged model as a standalone model.',ne,m,qe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',oe,T,Be="This works because during training, the smaller weight matrices (<em>A</em> and <em>B</em> in the diagram above) are separate. But once training is complete, the weights can actually be merged into a new weight matrix that is identical.",se,_,re,L,Ze=`Use <a href="/docs/peft/v0.7.1/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> to merge the LoRa layers into the base model while retaining the PeftModel.
This will help in later unmerging, deleting, loading different adapters and so on.`,de,y,Fe=`Use <a href="/docs/peft/v0.7.1/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to unmerge the LoRa layers from the base model while retaining the PeftModel.
This will help in later merging, deleting, loading different adapters and so on.`,me,v,We=`Use <a href="/docs/peft/v0.7.1/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to get back the base model without the merging of the active lora modules.
This will help when you want to get back the pretrained base model in some applications when you want to reset the model to its original state.
For example, in Stable Diffusion WebUi, when the user wants to infer with base model post trying out LoRAs.`,fe,M,Ge='Use <a href="/docs/peft/v0.7.1/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete an existing adapter.',pe,x,Qe='Use <a href="/docs/peft/v0.7.1/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> to combine multiple LoRAs into a new adapter based on the user provided weighing scheme.',he,$,ue,R,Xe="As with other methods supported by PEFT, to fine-tune a model using LoRA, you need to:",ce,A,Ee="<li>Instantiate a base model.</li> <li>Create a configuration (<code>LoraConfig</code>) where you define LoRA-specific parameters.</li> <li>Wrap the base model with <code>get_peft_model()</code> to get a trainable <code>PeftModel</code>.</li> <li>Train the <code>PeftModel</code> as you normally would train the base model.</li>",ge,C,Se="<code>LoraConfig</code> allows you to control how LoRA is applied to the base model through the following parameters:",we,H,Ye="<li><code>r</code>: the rank of the update matrices, expressed in <code>int</code>. Lower rank results in smaller update matrices with fewer trainable parameters.</li> <li><code>target_modules</code>: The modules (for example, attention blocks) to apply the LoRA update matrices.</li> <li><code>alpha</code>: LoRA scaling factor.</li> <li><code>bias</code>: Specifies if the <code>bias</code> parameters should be trained. Can be <code>&#39;none&#39;</code>, <code>&#39;all&#39;</code> or <code>&#39;lora_only&#39;</code>.</li> <li><code>modules_to_save</code>: List of modules apart from LoRA layers to be set as trainable and saved in the final checkpoint. These typically include model’s custom head that is randomly initialized for the fine-tuning task.</li> <li><code>layers_to_transform</code>: List of layers to be transformed by LoRA. If not specified, all layers in <code>target_modules</code> are transformed.</li> <li><code>layers_pattern</code>: Pattern to match layer names in <code>target_modules</code>, if <code>layers_to_transform</code> is specified. By default <code>PeftModel</code> will look at common layer pattern (<code>layers</code>, <code>h</code>, <code>blocks</code>, etc.), use it for exotic and custom models.</li> <li><code>rank_pattern</code>: The mapping from layer names or regexp expression to ranks which are different from the default rank specified by <code>r</code>.</li> <li><code>alpha_pattern</code>: The mapping from layer names or regexp expression to alphas which are different from the default alpha specified by <code>lora_alpha</code>.</li>",be,k,Te,P,Ve="For an example of LoRA method application to various downstream tasks, please refer to the following guides:",_e,J,De='<li><a href="../task_guides/image_classification_lora">Image classification using LoRA</a></li> <li><a href="../task_guides/semantic_segmentation_lora">Semantic segmentation</a></li>',Le,z,Ne=`While the original paper focuses on language models, the technique can be applied to any dense layers in deep learning
models. As such, you can leverage this technique with diffusion models. See <a href="../task_guides/task_guides/dreambooth_lora">Dreambooth fine-tuning with LoRA</a> task guide for an example.`,ye,I,ve,U,Ke='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> of the <code>LoraConfig</code>. By default, PEFT initializes LoRA weights the same way as the <a href="https://github.com/microsoft/LoRA" rel="nofollow">reference implementation</a>, i.e. using Kaiming-uniform for weight A and initializing weight B as zeros, resulting in an identity transform.',Me,j,Oe='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this results in initializing weight A with a Gaussian distribution (weight B is still zeros). This corresponds to the way that <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">diffusers</a> initializes LoRA weights.',xe,q,et='When quantizing the base model, e.g. for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve the performance with quantization. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use this option, <em>do not</em> quantize the base model. Instead, proceed as follows:',$e,B,Re,Z,tt="Finally, there is also an option to set <code>initialize_lora_weights=False</code>. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform. This is useful for debugging and testing purposes and should not be used otherwise.",Ae,V,Ce;return f=new S({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),w=new S({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),_=new S({props:{title:"Utils for LoRA",local:"utils-for-lora",headingTag:"h2"}}),$=new S({props:{title:"Common LoRA parameters in PEFT",local:"common-lora-parameters-in-peft",headingTag:"h2"}}),k=new S({props:{title:"LoRA examples",local:"lora-examples",headingTag:"h2"}}),I=new S({props:{title:"Initialization options",local:"initialization-options",headingTag:"h2"}}),B=new mt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb2Z0UUNvbmZpZyUyQyUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoLi4uKSUyMCUyMCUyMyUyMGRvbid0JTIwcXVhbnRpemUlMjBoZXJlJTBBbG9mdHFfY29uZmlnJTIwJTNEJTIwTG9mdFFDb25maWcobG9mdHFfYml0cyUzRDQlMkMlMjAuLi4pJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2V0JTIwNGJpdCUyMHF1YW50aXphdGlvbiUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjBpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmxvZnRxJTIyJTJDJTIwbG9mdHFfY29uZmlnJTNEbG9mdHFfY29uZmlnKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwbG9yYV9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoftQConfig, LoraConfig, get_peft_model

base_model = AutoModelForCausalLM.from_pretrained(...)  <span class="hljs-comment"># don&#x27;t quantize here</span>
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>, ...)           <span class="hljs-comment"># set 4bit quantization</span>
lora_config = LoraConfig(..., init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>, loftq_config=loftq_config)
peft_model = get_peft_model(base_model, lora_config)`,wrap:!1}}),{c(){d=o("meta"),D=l(),Y=o("p"),N=l(),F(f.$$.fragment),K=l(),p=o("p"),p.innerHTML=Pe,O=l(),h=o("p"),h.innerHTML=Je,ee=l(),u=o("p"),u.textContent=ze,te=l(),c=o("ul"),c.innerHTML=Ie,ie=l(),g=o("p"),g.innerHTML=Ue,ae=l(),F(w.$$.fragment),le=l(),b=o("p"),b.innerHTML=je,ne=l(),m=o("div"),m.innerHTML=qe,oe=l(),T=o("p"),T.innerHTML=Be,se=l(),F(_.$$.fragment),re=l(),L=o("p"),L.innerHTML=Ze,de=l(),y=o("p"),y.innerHTML=Fe,me=l(),v=o("p"),v.innerHTML=We,fe=l(),M=o("p"),M.innerHTML=Ge,pe=l(),x=o("p"),x.innerHTML=Qe,he=l(),F($.$$.fragment),ue=l(),R=o("p"),R.textContent=Xe,ce=l(),A=o("ol"),A.innerHTML=Ee,ge=l(),C=o("p"),C.innerHTML=Se,we=l(),H=o("ul"),H.innerHTML=Ye,be=l(),F(k.$$.fragment),Te=l(),P=o("p"),P.textContent=Ve,_e=l(),J=o("ul"),J.innerHTML=De,Le=l(),z=o("p"),z.innerHTML=Ne,ye=l(),F(I.$$.fragment),ve=l(),U=o("p"),U.innerHTML=Ke,Me=l(),j=o("p"),j.innerHTML=Oe,xe=l(),q=o("p"),q.innerHTML=et,$e=l(),F(B.$$.fragment),Re=l(),Z=o("p"),Z.innerHTML=tt,Ae=l(),V=o("p"),this.h()},l(e){const t=rt("svelte-u9bgzb",document.head);d=s(t,"META",{name:!0,content:!0}),t.forEach(i),D=n(e),Y=s(e,"P",{}),it(Y).forEach(i),N=n(e),W(f.$$.fragment,e),K=n(e),p=s(e,"P",{"data-svelte-h":!0}),r(p)!=="svelte-10j2kq5"&&(p.innerHTML=Pe),O=n(e),h=s(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-yvfnx3"&&(h.innerHTML=Je),ee=n(e),u=s(e,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1usho35"&&(u.textContent=ze),te=n(e),c=s(e,"UL",{"data-svelte-h":!0}),r(c)!=="svelte-b91w2n"&&(c.innerHTML=Ie),ie=n(e),g=s(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1pnerbz"&&(g.innerHTML=Ue),ae=n(e),W(w.$$.fragment,e),le=n(e),b=s(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1otojyg"&&(b.innerHTML=je),ne=n(e),m=s(e,"DIV",{class:!0,"data-svelte-h":!0}),r(m)!=="svelte-1f6iuw5"&&(m.innerHTML=qe),oe=n(e),T=s(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-6quaur"&&(T.innerHTML=Be),se=n(e),W(_.$$.fragment,e),re=n(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-jbapul"&&(L.innerHTML=Ze),de=n(e),y=s(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-13r8r95"&&(y.innerHTML=Fe),me=n(e),v=s(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-boq3l2"&&(v.innerHTML=We),fe=n(e),M=s(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1ekxn8i"&&(M.innerHTML=Ge),pe=n(e),x=s(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1fxymju"&&(x.innerHTML=Qe),he=n(e),W($.$$.fragment,e),ue=n(e),R=s(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-kdwy7m"&&(R.textContent=Xe),ce=n(e),A=s(e,"OL",{"data-svelte-h":!0}),r(A)!=="svelte-yij1ed"&&(A.innerHTML=Ee),ge=n(e),C=s(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-ezuo7y"&&(C.innerHTML=Se),we=n(e),H=s(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-vpooj9"&&(H.innerHTML=Ye),be=n(e),W(k.$$.fragment,e),Te=n(e),P=s(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-aryync"&&(P.textContent=Ve),_e=n(e),J=s(e,"UL",{"data-svelte-h":!0}),r(J)!=="svelte-19vcsei"&&(J.innerHTML=De),Le=n(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1moq18d"&&(z.innerHTML=Ne),ye=n(e),W(I.$$.fragment,e),ve=n(e),U=s(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1uqxl8x"&&(U.innerHTML=Ke),Me=n(e),j=s(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-hcpclp"&&(j.innerHTML=Oe),xe=n(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-158barj"&&(q.innerHTML=et),$e=n(e),W(B.$$.fragment,e),Re=n(e),Z=s(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1q0vckg"&&(Z.innerHTML=tt),Ae=n(e),V=s(e,"P",{}),it(V).forEach(i),this.h()},h(){He(d,"name","hf:doc:metadata"),He(d,"content",pt),He(m,"class","flex justify-center")},m(e,t){dt(document.head,d),a(e,D,t),a(e,Y,t),a(e,N,t),G(f,e,t),a(e,K,t),a(e,p,t),a(e,O,t),a(e,h,t),a(e,ee,t),a(e,u,t),a(e,te,t),a(e,c,t),a(e,ie,t),a(e,g,t),a(e,ae,t),G(w,e,t),a(e,le,t),a(e,b,t),a(e,ne,t),a(e,m,t),a(e,oe,t),a(e,T,t),a(e,se,t),G(_,e,t),a(e,re,t),a(e,L,t),a(e,de,t),a(e,y,t),a(e,me,t),a(e,v,t),a(e,fe,t),a(e,M,t),a(e,pe,t),a(e,x,t),a(e,he,t),G($,e,t),a(e,ue,t),a(e,R,t),a(e,ce,t),a(e,A,t),a(e,ge,t),a(e,C,t),a(e,we,t),a(e,H,t),a(e,be,t),G(k,e,t),a(e,Te,t),a(e,P,t),a(e,_e,t),a(e,J,t),a(e,Le,t),a(e,z,t),a(e,ye,t),G(I,e,t),a(e,ve,t),a(e,U,t),a(e,Me,t),a(e,j,t),a(e,xe,t),a(e,q,t),a(e,$e,t),G(B,e,t),a(e,Re,t),a(e,Z,t),a(e,Ae,t),a(e,V,t),Ce=!0},p:lt,i(e){Ce||(Q(f.$$.fragment,e),Q(w.$$.fragment,e),Q(_.$$.fragment,e),Q($.$$.fragment,e),Q(k.$$.fragment,e),Q(I.$$.fragment,e),Q(B.$$.fragment,e),Ce=!0)},o(e){X(f.$$.fragment,e),X(w.$$.fragment,e),X(_.$$.fragment,e),X($.$$.fragment,e),X(k.$$.fragment,e),X(I.$$.fragment,e),X(B.$$.fragment,e),Ce=!1},d(e){e&&(i(D),i(Y),i(N),i(K),i(p),i(O),i(h),i(ee),i(u),i(te),i(c),i(ie),i(g),i(ae),i(le),i(b),i(ne),i(m),i(oe),i(T),i(se),i(re),i(L),i(de),i(y),i(me),i(v),i(fe),i(M),i(pe),i(x),i(he),i(ue),i(R),i(ce),i(A),i(ge),i(C),i(we),i(H),i(be),i(Te),i(P),i(_e),i(J),i(Le),i(z),i(ye),i(ve),i(U),i(Me),i(j),i(xe),i(q),i($e),i(Re),i(Z),i(Ae),i(V)),i(d),E(f,e),E(w,e),E(_,e),E($,e),E(k,e),E(I,e),E(B,e)}}}const pt='{"title":"LoRA","local":"lora","sections":[{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Utils for LoRA","local":"utils-for-lora","sections":[],"depth":2},{"title":"Common LoRA parameters in PEFT","local":"common-lora-parameters-in-peft","sections":[],"depth":2},{"title":"LoRA examples","local":"lora-examples","sections":[],"depth":2},{"title":"Initialization options","local":"initialization-options","sections":[],"depth":2}],"depth":1}';function ht(ke){return nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bt extends ot{constructor(d){super(),st(this,d,ht,ft,at,{})}}export{bt as component};
