import{s as za,o as Za,n as va}from"../chunks/scheduler.37c15a92.js";import{S as _a,i as Qa,g as a,s as n,r,A as Ba,h as i,f as l,c as p,j as Va,u as c,x as M,k as pp,y as Wa,a as t,v as y,d as J,t as o,w as m}from"../chunks/index.2bf4358c.js";import{T as Ra}from"../chunks/Tip.363c041f.js";import{Y as Na}from"../chunks/Youtube.1e50a667.js";import{C as j}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Xa}from"../chunks/CourseFloatingBanner.33a4139d.js";import{H as yl}from"../chunks/Heading.8ada512a.js";function Aa(Jl){let T,d=`<strong>Далее</strong> если вы протестируете две версии предыдущих нормализаторов на строке, содержащей символ Unicode <code>u&quot;\\u0085&quot;</code>, то наверняка заметите, что эти два нормализатора не совсем эквивалентны.<br/>
Чтобы не усложнять версию с <code>normalizers.Sequence</code>, мы не включили в нее Regex-замены, которые требует <code>BertNormalizer</code>, когда аргумент <code>clean_text</code> установлен в <code>True</code>, что является поведением по умолчанию. Но не волнуйтесь: можно получить точно такую же нормализацию без использования удобного <code>BertNormalizer</code>, добавив два <code>normalizers.Replace</code> в последовательность нормализаторов.`;return{c(){T=a("p"),T.innerHTML=d},l(u){T=i(u,"P",{"data-svelte-h":!0}),M(T)!=="svelte-kju4cm"&&(T.innerHTML=d)},m(u,rl){t(u,T,rl)},p:va,d(u){u&&l(T)}}}function Ea(Jl){let T,d,u,rl,k,ol,$,ml,b,ap="Как мы уже видели в предыдущих разделах, токенизация состоит из нескольких этапов:",jl,w,ip="<li>Нормализация (любая необходимая очистка текста, например, удаление пробелов или подчеркиваний, нормализация Unicode и т. д.)</li> <li>Предварительная токенизация (разделение входного текста на слова).</li> <li>Прогон входных данных через модель (использование предварительно токенизированных слов для создания последовательности токенов)</li> <li>Постобработка (добавление специальных токенов токенизатора, генерация маски внимания и идентификаторов типов токенов)</li>",Tl,C,Mp="В качестве напоминания вот еще один взгляд на общий процесс:",ul,f,rp='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',fl,g,cp='Библиотека 🤗 Tokenizers была создана для того, чтобы предоставить несколько вариантов каждого из этих шагов, которые вы можете смешивать и сочетать между собой. В этом разделе мы рассмотрим, как можно создать токенизатор с нуля, а не обучать новый токенизатор на основе старого, как мы делали в <a href="/course/chapter6/2">разделе 2</a>. После этого вы сможете создать любой токенизатор, который только сможете придумать!',Ul,h,dl,x,yp="Точнее, библиотека построена вокруг центрального класса <code>Tokenizer</code>, а строительные блоки сгруппированы в подмодули:",kl,I,Jp='<li><code>normalizers</code> содержит все возможные типы нормализаторов текста <code>Normalizer</code>, которые вы можете использовать (полный список <a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.normalizers" rel="nofollow">здесь</a>).</li> <li><code>pre_tokenizers</code> содержит все возможные типы предварительных токенизаторов <code>PreTokenizer</code>, которые вы можете использовать (полный список <a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.pre_tokenizers" rel="nofollow">здесь</a>).</li> <li><code>models</code> содержит различные типы моделей <code>Model</code>, которые вы можете использовать, такие как <code>BPE</code>, <code>WordPiece</code> и <code>Unigram</code> (полный список <a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.models" rel="nofollow">здесь</a>).</li> <li><code>trainers</code> содержит все различные типы <code>Trainer</code>, которые вы можете использовать для обучения модели на корпусе (по одному на каждый тип модели; полный список <a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.trainers" rel="nofollow">здесь</a>).</li> <li><code>post_processors</code> содержит различные типы постпроцессоров <code>PostProcessor</code>, которые вы можете использовать (полный список <a href="https://huggingface.co/docs/tokenizers/python/latest/api/reference.html#module-tokenizers.processors" rel="nofollow">здесь</a>).</li> <li><code>decoders</code> содержит различные типы декодеров <code>Decoder</code>, которые вы можете использовать для декодирования результатов токенизации (полный список <a href="https://huggingface.co/docs/tokenizers/python/latest/components.html#decoders" rel="nofollow">здесь</a>).</li>',$l,V,op='Весь список блоков вы можете найти <a href="https://huggingface.co/docs/tokenizers/python/latest/components.html" rel="nofollow">здесь</a>.',bl,z,wl,Z,mp='Для обучения нашего нового токенизатора мы будем использовать небольшой корпус текстов (чтобы примеры выполнялись быстро). Шаги по сбору корпуса аналогичны тем, что мы делали в <a href="/course/chapter6/2">начале этой главы</a>, но на этот раз мы будем использовать набор данных <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a>:',Cl,v,gl,_,jp="Функция <code>get_training_corpus()</code> - это генератор, который выдает батч из 1000 текстов, которые мы будем использовать для обучения токенизатора.",hl,Q,Tp="🤗 Токенизаторы также можно обучать непосредственно на текстовых файлах. Вот как мы можем сгенерировать текстовый файл, содержащий все тексты/входы из WikiText-2, который мы можем использовать локально:",xl,B,Il,W,up="Далее мы покажем вам, как блок за блоком построить собственные токенизаторы BERT, GPT-2 и XLNet. Это даст нам пример каждого из трех основных алгоритмов токенизации: WordPiece, BPE и Unigram. Начнем с BERT!",Vl,R,zl,N,fp="Чтобы создать токенизатор с помощью библиотеки 🤗 Tokenizers, мы начнем с инстанцирования объектов <code>Tokenizer</code> и <code>model</code>, затем установим для их атрибутов <code>normalizer</code>, <code>pre_tokenizer</code>, <code>post_processor</code> и <code>decoder</code> нужные нам значения.",Zl,X,Up="Для этого примера мы создадим <code>Tokenizer</code> с моделью WordPiece:",vl,A,_l,E,dp="Мы должны указать <code>unk_token</code>, чтобы модель знала, что возвращать, когда она встречает символы, которых раньше не видела. Другие аргументы, которые мы можем задать здесь, включают <code>vocab</code> нашей модели (мы собираемся обучать модель, поэтому нам не нужно его задавать) и <code>max_input_chars_per_word</code>, который определяет максимальную длину для каждого слова (слова длиннее переданного значения будут разбиты на части).",Ql,G,kp="Первым шагом токенизации является нормализация, поэтому начнем с нее. Поскольку BERT широко используется, существует <code>BertNormalizer</code> с классическими параметрами, которые мы можем установить для BERT: <code>lowercase</code> и <code>strip_accents</code>, которые не требуют пояснений; <code>clean_text</code> для удаления всех управляющих символов и замены повторяющихся пробелов на один; и <code>handle_chinese_chars</code>, который расставляет пробелы вокруг китайских символов. Чтобы повторить токенизатор <code>bert-base-uncased</code>, мы можем просто установить этот нормализатор:",Bl,q,Wl,L,$p="Однако, как правило, при создании нового токенизатора у вас не будет доступа к такому удобному нормализатору, уже реализованному в библиотеке 🤗 Tokenizers, поэтому давайте посмотрим, как создать нормализатор BERT вручную. Библиотека предоставляет нормализатор <code>Lowercase</code> и нормализатор <code>StripAccents</code>, и вы можете комбинировать несколько нормализаторов с помощью <code>Sequence</code>:",Rl,H,Nl,S,bp="Мы также используем нормализатор Unicode <code>NFD</code>, поскольку в противном случае нормализатор <code>StripAccents</code> не сможет правильно распознать акцентированные символы и, следовательно, не удалит их.",Xl,D,wp="Как мы уже видели ранее, мы можем использовать метод <code>normalize_str()</code> нормализатора, чтобы проверить, как он влияет на данный текст:",Al,P,El,Y,Gl,U,ql,F,Cp="Далее следует этап предварительной токенизации. Опять же, есть готовый <code>BertPreTokenizer</code>, который мы можем использовать:",Ll,K,Hl,O,gp="Или мы можем создать его с нуля:",Sl,ee,Dl,se,hp="Обратите внимание, что токенизатор <code>Whitespace</code> разделяет пробельные символы и все символы, которые не являются буквами, цифрами или символом подчеркивания, поэтому технически он разделяет пробельные символы и знаки пунктуации:",Pl,le,Yl,te,Fl,ne,xp="Если вы хотите выполнять разделение только по пробельным символам, то вместо этого следует использовать предварительный токенизатор <code>WhitespaceSplit</code>:",Kl,pe,Ol,ae,et,ie,Ip="Как и в случае с нормализаторами, вы можете использовать <code>Sequence</code> для комбинирования нескольких предварительных токенизаторов:",st,Me,lt,re,tt,ce,Vp="Следующий шаг в конвейере токенизации - обработка входных данных с помощью модели. Мы уже указали нашу модель в инициализации, но нам все еще нужно обучить ее, для чего потребуется <code>WordPieceTrainer</code>. Главное, что нужно помнить при инстанцировании тренера в 🤗 Tokenizers, это то, что вам нужно передать ему все специальные токены, которые вы собираетесь использовать - иначе он не добавит их в словарь, поскольку их нет в обучающем корпусе:",nt,ye,pt,Je,zp="Помимо указания <code>vocab_size</code> и <code>special_tokens</code>, мы можем задать <code>min_frequency</code> (количество раз, которое должен встретиться токен, чтобы быть включенным в словарь) или изменить <code>continuing_subword_prefix</code> (если мы хотим использовать что-то отличное от <code>##</code>).",at,oe,Zp="Чтобы обучить нашу модель с помощью итератора, который мы определили ранее, достаточно выполнить эту команду:",it,me,Mt,je,vp="Мы также можем использовать текстовые файлы для обучения нашего токенизатора, что будет выглядеть следующим образом (предварительно мы повторно инициализируем модель с пустым <code>WordPiece</code>):",rt,Te,ct,ue,_p="В обоих случаях мы можем проверить работу токенизатора на тексте, вызвав метод <code>encode()</code>:",yt,fe,Jt,Ue,ot,de,Qp="Полученное <code>encoding</code> представляет собой <code>Encoding</code>, которое содержит все необходимые результаты работы токенизатора в разных атрибутах: <code>ids</code>, <code>type_ids</code>, <code>tokens</code>, <code>offsets</code>, <code>attention_mask</code>, <code>special_tokens_mask</code> и <code>overflowing</code>.",mt,ke,Bp="Последний шаг в конвейере токенизации - постобработка. Нам нужно добавить токен <code>[CLS]</code> в начале и токен <code>[SEP]</code> в конце (или после каждого предложения, если у нас есть пара предложений). Для этого мы будем использовать <code>TemplateProcessor</code>, но сначала нам нужно узнать идентификаторы токенов <code>[CLS]</code> и <code>[SEP]</code> в словаре:",jt,$e,Tt,be,ut,we,Wp="Чтобы написать шаблон для <code>TemplateProcessor</code>, мы должны указать, как обрабатывать одно предложение и пару предложений. Для обоих случаев мы указываем специальные токены, которые мы хотим использовать; первое (или одиночное) предложение представлено <code>$A</code>, а второе предложение (если кодируется пара) представлено <code>$B</code>. Для каждого из них (специальных токенов и предложений) мы также указываем соответствующий идентификатор типа токена (token type ID) после двоеточия.",ft,Ce,Rp="Таким образом, классический шаблон BERT определяется следующим образом:",Ut,ge,dt,he,Np="Обратите внимание, что нам нужно передать идентификаторы специальных токенов, чтобы токенизатор мог правильно преобразовать их в их идентификаторы.",kt,xe,Xp="Как только это будет добавлено, вернемся к нашему предыдущему примеру:",$t,Ie,bt,Ve,wt,ze,Ap="И на паре предложений мы получаем правильный результат:",Ct,Ze,gt,ve,ht,_e,Ep="Мы почти закончили создание этого токенизатора с нуля - остался последний шаг - добавить декодер:",xt,Qe,It,Be,Gp="Давайте проверим его на нашем предыдущем <code>encoding</code>:",Vt,We,zt,Re,Zt,Ne,qp="Отлично! Мы можем сохранить наш токенизатор в единственном JSON-файле следующим образом:",vt,Xe,_t,Ae,Lp="Затем мы можем загрузить этот файл в объект <code>Tokenizer</code> с помощью метода <code>from_file()</code>:",Qt,Ee,Bt,Ge,Hp="Чтобы использовать этот токенизатор в 🤗 Transformers, мы должны обернуть его в <code>PreTrainedTokenizerFast</code>. Мы можем использовать либо общий класс, либо, если наш токенизатор соответствует существующей модели, использовать этот класс (здесь <code>BertTokenizerFast</code>). Если вы используете этот урок для создания нового токенизатора, вам придется использовать первый вариант.",Wt,qe,Sp="Чтобы обернуть токенизатор в <code>PreTrainedTokenizerFast</code>, мы можем либо передать собранный нами токенизатор как <code>tokenizer_object</code>, либо передать сохраненный файл токенизатора как <code>tokenizer_file</code>. Главное помнить, что нам придется вручную задавать все специальные токены, поскольку класс не может определить из объекта <code>tokenizer</code>, какой токен является токеном маски, токеном <code>[CLS]</code> и т. д.:",Rt,Le,Nt,He,Dp="Если вы используете определенный класс токенизатора (например, <code>BertTokenizerFast</code>), вам нужно будет указать только специальные токены, которые отличаются от токенов по умолчанию (здесь их нет):",Xt,Se,At,De,Pp="Затем вы можете использовать этот токенизатор, как и любой другой токенизатор 🤗 Transformers. Вы можете сохранить его с помощью метода <code>save_pretrained()</code> или загрузить на хаб с помощью метода <code>push_to_hub()</code>.",Et,Pe,Yp="Теперь, когда мы рассмотрели, как создать токенизатор WordPiece, давайте сделаем то же самое для токенизатора BPE. Мы будем двигаться немного быстрее, поскольку вы знаете все шаги, и подчеркнем только различия.",Gt,Ye,qt,Fe,Fp="Теперь давайте создадим токенизатор GPT-2. Как и в случае с токенизатором BERT, мы начнем с инициализации <code>Tokenizer</code> с моделью BPE:",Lt,Ke,Ht,Oe,Kp="Также, как и в случае с BERT, мы могли бы инициализировать эту модель словарем, если бы он у нас был (в этом случае нам нужно было бы передать <code>vocab</code> и <code>merges</code>), но поскольку мы будем обучать с нуля, нам не нужно этого делать. Нам также не нужно указывать <code>unk_token</code>, потому что GPT-2 использует byte-level BPE, который не требует этого.",St,es,Op="GPT-2 не использует нормализатор, поэтому мы пропускаем этот шаг и переходим непосредственно к предварительной токенизации:",Dt,ss,Pt,ls,ea="Опция, которую мы добавили к <code>ByteLevel</code>, заключается в том, чтобы не добавлять пробел в начале предложения (в противном случае это происходит по умолчанию). Мы можем посмотреть на предварительную токенизацию примера текста, как было показано ранее:",Yt,ts,Ft,ns,Kt,ps,sa="Далее следует модель, которую нужно обучить. Для GPT-2 единственным специальным токеном является токен конца текста:",Ot,as,en,is,la="Как и в случае с <code>WordPieceTrainer</code>, а также <code>vocab_size</code> и <code>special_tokens</code>, мы можем указать <code>min_frequency</code>, если хотим, или если у нас есть суффикс конца слова (например, <code>&lt;/w&gt;</code>), мы можем задать его с помощью <code>end_of_word_suffix</code>.",sn,Ms,ta="Этот токенизатор также может быть обучен на текстовых файлах:",ln,rs,tn,cs,na="Давайте посмотрим на пример токенизации текста:",nn,ys,pn,Js,an,os,pa="Мы применяем постобработку на уровне байтов для токенизатора GPT-2 следующим образом:",Mn,ms,rn,js,aa="Опция <code>trim_offsets = False</code> указывает постпроцессору, что мы должны оставить смещения токенов, начинающихся с ‘Ġ’, как есть: таким образом, начало смещения будет указывать на пробел перед словом, а не на первый символ слова (поскольку пробел технически является частью токена). Давайте посмотрим на результат с текстом, который мы только что закодировали, где <code>&#39;Ġtest&#39;</code> - это токен с индексом 4:",cn,Ts,yn,us,Jn,fs,ia="Наконец, мы добавляем декодер на уровне байтов:",on,Us,mn,ds,Ma="и мы сможем перепроверить, правильно ли он работает:",jn,ks,Tn,$s,un,bs,ra="Отлично! Теперь, когда мы закончили, мы можем сохранить токенизатор, как раньше, и обернуть его в <code>PreTrainedTokenizerFast</code> или <code>GPT2TokenizerFast</code>, если мы хотим использовать его в 🤗 Transformers:",fn,ws,Un,Cs,ca="или:",dn,gs,kn,hs,ya="В качестве последнего примера мы покажем вам, как создать токенизатор Unigram с нуля.",$n,xs,bn,Is,Ja="Теперь давайте построим токенизатор XLNet. Как и в предыдущих токенизаторах, мы начнем с инициализации <code>Tokenizer</code> с моделью Unigram:",wn,Vs,Cn,zs,oa="Опять же, мы могли бы инициализировать эту модель словарем, если бы он у нас был.",gn,Zs,ma="Для нормализации XLNet использует несколько замен (которые пришли из SentencePiece):",hn,vs,xn,_s,ja="Он заменяет <code>“</code> и <code>”</code> with <code>”</code> и любую последовательность из двух или более пробелов на один пробел, а также удаляет ударения в токенезируемых текстах.",In,Qs,Ta="Предварительный токенизатор, который должен использоваться для любого токенизатора SentencePiece, - это <code>Metaspace</code>:",Vn,Bs,zn,Ws,ua="Мы можем посмотреть на предварительную токенизацию примера текста, как было показано ранее:",Zn,Rs,vn,Ns,_n,Xs,fa="Далее следует модель, которую нужно обучить. В XLNet довольно много специальных токенов:",Qn,As,Bn,Es,Ua="Очень важный аргумент, который не стоит забывать для <code>UnigramTrainer</code> - это <code>unk_token</code>. Мы также можем передавать другие аргументы, специфичные для алгоритма Unigram, такие как <code>shrinking_factor</code> для каждого шага удаления токенов (по умолчанию 0.75) или <code>max_piece_length</code> для указания максимальной длины данного токена (по умолчанию 16).",Wn,Gs,da="Этот токенизатор также может быть обучен на текстовых файлах:",Rn,qs,Nn,Ls,ka="Давайте посмотрим на токенизацию примера текста:",Xn,Hs,An,Ss,En,Ds,$a="Особенностью XLNet является то, что он помещает токен <code>&lt;cls&gt;</code> в конец предложения с идентификатором типа 2 (чтобы отличить его от других токенов). В результате он помещается слева. Мы можем разобраться со всеми специальными токенами и идентификаторами типов токенов с помощью шаблона, как в BERT, но сначала нам нужно получить идентификаторы токенов <code>&lt;cls&gt;</code> и <code>&lt;sep&gt;</code>:",Gn,Ps,qn,Ys,Ln,Fs,ba="Шаблон выглядит следующим образом:",Hn,Ks,Sn,Os,wa="И мы можем проверить, как это работает, закодировав пару предложений:",Dn,el,Pn,sl,Yn,ll,Ca="Наконец, мы добавляем декодер <code>Metaspace</code>:",Fn,tl,Kn,nl,ga="и мы закончили работу с этим токенизатором! Мы можем сохранить токенизатор, как и раньше, и обернуть его в <code>PreTrainedTokenizerFast</code> или <code>XLNetTokenizerFast</code>, если мы хотим использовать его в 🤗 Transformers. При использовании <code>PreTrainedTokenizerFast</code> следует обратить внимание на то, что помимо специальных токенов, нам нужно указать библиотеке 🤗 Transformers на то, чтобы они располагались слева:",On,pl,ep,al,ha="Или альтернативно:",sp,il,lp,Ml,xa="Теперь, когда вы увидели, как различные блоки используются для создания существующих токенизаторов, вы должны быть в состоянии написать любой токенизатор, который вы хотите, с помощью библиотеки 🤗 Tokenizers и использовать его в 🤗 Transformers.",tp,cl,np;return k=new yl({props:{title:"Создание токенизатора, блок за блоком",local:"building-a-tokenizer-block-by-block",headingTag:"h1"}}),$=new Xa({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"}]}}),h=new Na({props:{id:"MR8tZm5ViWU"}}),z=new yl({props:{title:"Получение корпуса текста",local:"acquiring-a-corpus",headingTag:"h2"}}),v=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),B=new j({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),R=new yl({props:{title:"Создание токенизатора WordPiece с нуля",local:"building-a-wordpiece-tokenizer-from-scratch",headingTag:"h2"}}),A=new j({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),q=new j({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),H=new j({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),P=new j({props:{code:"cHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(tokenizer.normalizer.normalize_str(<span class="hljs-string">&quot;Héllò hôw are ü?&quot;</span>))',wrap:!1}}),Y=new j({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),U=new Ra({props:{$$slots:{default:[Aa]},$$scope:{ctx:Jl}}}),K=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),ee=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),le=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),te=new j({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),pe=new j({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ae=new j({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),Me=new j({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),re=new j({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ye=new j({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),me=new j({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),Te=new j({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),fe=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ue=new j({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),$e=new j({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),be=new j({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),ge=new j({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),Ie=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ve=new j({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),Ze=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),ve=new j({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),Qe=new j({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),We=new j({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Re=new j({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjI=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span>',wrap:!1}}),Xe=new j({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ee=new j({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Le=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMCVEMCU5MiUyMCVEMCVCQSVEMCVCMCVEMSU4NyVEMCVCNSVEMSU4MSVEMSU4MiVEMCVCMiVEMCVCNSUyMCVEMCVCMCVEMCVCQiVEMSU4QyVEMSU4MiVEMCVCNSVEMSU4MCVEMCVCRCVEMCVCMCVEMSU4MiVEMCVCOCVEMCVCMiVEMSU4QiUyMCVEMCVCQyVEMCVCRSVEMCVCNiVEMCVCRCVEMCVCRSUyMCVEMCVCNyVEMCVCMCVEMCVCMyVEMSU4MCVEMSU4MyVEMCVCNyVEMCVCOCVEMSU4MiVEMSU4QyUyMCVEMCVCOCVEMCVCNyUyMCVEMSU4NCVEMCVCMCVEMCVCOSVEMCVCQiVEMCVCMCUyMCVEMSU4MiVEMCVCRSVEMCVCQSVEMCVCNSVEMCVCRCVEMCVCOCVEMCVCNyVEMCVCMCVEMSU4MiVEMCVCRSVEMSU4MCVEMCVCMC4lMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlNUJQQUQlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlNUJDTFMlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlNUJTRVAlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTVCTUFTSyU1RCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # В качестве альтернативы можно загрузить из файла токенизатора.</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),Se=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Ye=new yl({props:{title:"Создание токенизатора BPE с нуля",local:"building-a-bpe-tokenizer-from-scratch",headingTag:"h2"}}),Ke=new j({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),ss=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),ts=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),ns=new j({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),as=new j({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),rs=new j({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),ys=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Js=new j({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),ms=new j({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),Ts=new j({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),us=new j({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),Us=new j({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),ks=new j({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),$s=new j({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>',wrap:!1}}),ws=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),gs=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),xs=new yl({props:{title:"Создание токенизатора Unigram с нуля",local:"building-a-unigram-tokenizer-from-scratch",headingTag:"h2"}}),Vs=new j({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),vs=new j({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),Bs=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),Rs=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),Ns=new j({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),As=new j({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),qs=new j({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Hs=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ss=new j({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ps=new j({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Ys=new j({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),Ks=new j({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),el=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),sl=new j({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),tl=new j({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),pl=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),il=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),{c(){T=a("meta"),d=n(),u=a("p"),rl=n(),r(k.$$.fragment),ol=n(),r($.$$.fragment),ml=n(),b=a("p"),b.textContent=ap,jl=n(),w=a("ul"),w.innerHTML=ip,Tl=n(),C=a("p"),C.textContent=Mp,ul=n(),f=a("div"),f.innerHTML=rp,fl=n(),g=a("p"),g.innerHTML=cp,Ul=n(),r(h.$$.fragment),dl=n(),x=a("p"),x.innerHTML=yp,kl=n(),I=a("ul"),I.innerHTML=Jp,$l=n(),V=a("p"),V.innerHTML=op,bl=n(),r(z.$$.fragment),wl=n(),Z=a("p"),Z.innerHTML=mp,Cl=n(),r(v.$$.fragment),gl=n(),_=a("p"),_.innerHTML=jp,hl=n(),Q=a("p"),Q.textContent=Tp,xl=n(),r(B.$$.fragment),Il=n(),W=a("p"),W.textContent=up,Vl=n(),r(R.$$.fragment),zl=n(),N=a("p"),N.innerHTML=fp,Zl=n(),X=a("p"),X.innerHTML=Up,vl=n(),r(A.$$.fragment),_l=n(),E=a("p"),E.innerHTML=dp,Ql=n(),G=a("p"),G.innerHTML=kp,Bl=n(),r(q.$$.fragment),Wl=n(),L=a("p"),L.innerHTML=$p,Rl=n(),r(H.$$.fragment),Nl=n(),S=a("p"),S.innerHTML=bp,Xl=n(),D=a("p"),D.innerHTML=wp,Al=n(),r(P.$$.fragment),El=n(),r(Y.$$.fragment),Gl=n(),r(U.$$.fragment),ql=n(),F=a("p"),F.innerHTML=Cp,Ll=n(),r(K.$$.fragment),Hl=n(),O=a("p"),O.textContent=gp,Sl=n(),r(ee.$$.fragment),Dl=n(),se=a("p"),se.innerHTML=hp,Pl=n(),r(le.$$.fragment),Yl=n(),r(te.$$.fragment),Fl=n(),ne=a("p"),ne.innerHTML=xp,Kl=n(),r(pe.$$.fragment),Ol=n(),r(ae.$$.fragment),et=n(),ie=a("p"),ie.innerHTML=Ip,st=n(),r(Me.$$.fragment),lt=n(),r(re.$$.fragment),tt=n(),ce=a("p"),ce.innerHTML=Vp,nt=n(),r(ye.$$.fragment),pt=n(),Je=a("p"),Je.innerHTML=zp,at=n(),oe=a("p"),oe.textContent=Zp,it=n(),r(me.$$.fragment),Mt=n(),je=a("p"),je.innerHTML=vp,rt=n(),r(Te.$$.fragment),ct=n(),ue=a("p"),ue.innerHTML=_p,yt=n(),r(fe.$$.fragment),Jt=n(),r(Ue.$$.fragment),ot=n(),de=a("p"),de.innerHTML=Qp,mt=n(),ke=a("p"),ke.innerHTML=Bp,jt=n(),r($e.$$.fragment),Tt=n(),r(be.$$.fragment),ut=n(),we=a("p"),we.innerHTML=Wp,ft=n(),Ce=a("p"),Ce.textContent=Rp,Ut=n(),r(ge.$$.fragment),dt=n(),he=a("p"),he.textContent=Np,kt=n(),xe=a("p"),xe.textContent=Xp,$t=n(),r(Ie.$$.fragment),bt=n(),r(Ve.$$.fragment),wt=n(),ze=a("p"),ze.textContent=Ap,Ct=n(),r(Ze.$$.fragment),gt=n(),r(ve.$$.fragment),ht=n(),_e=a("p"),_e.textContent=Ep,xt=n(),r(Qe.$$.fragment),It=n(),Be=a("p"),Be.innerHTML=Gp,Vt=n(),r(We.$$.fragment),zt=n(),r(Re.$$.fragment),Zt=n(),Ne=a("p"),Ne.textContent=qp,vt=n(),r(Xe.$$.fragment),_t=n(),Ae=a("p"),Ae.innerHTML=Lp,Qt=n(),r(Ee.$$.fragment),Bt=n(),Ge=a("p"),Ge.innerHTML=Hp,Wt=n(),qe=a("p"),qe.innerHTML=Sp,Rt=n(),r(Le.$$.fragment),Nt=n(),He=a("p"),He.innerHTML=Dp,Xt=n(),r(Se.$$.fragment),At=n(),De=a("p"),De.innerHTML=Pp,Et=n(),Pe=a("p"),Pe.textContent=Yp,Gt=n(),r(Ye.$$.fragment),qt=n(),Fe=a("p"),Fe.innerHTML=Fp,Lt=n(),r(Ke.$$.fragment),Ht=n(),Oe=a("p"),Oe.innerHTML=Kp,St=n(),es=a("p"),es.textContent=Op,Dt=n(),r(ss.$$.fragment),Pt=n(),ls=a("p"),ls.innerHTML=ea,Yt=n(),r(ts.$$.fragment),Ft=n(),r(ns.$$.fragment),Kt=n(),ps=a("p"),ps.textContent=sa,Ot=n(),r(as.$$.fragment),en=n(),is=a("p"),is.innerHTML=la,sn=n(),Ms=a("p"),Ms.textContent=ta,ln=n(),r(rs.$$.fragment),tn=n(),cs=a("p"),cs.textContent=na,nn=n(),r(ys.$$.fragment),pn=n(),r(Js.$$.fragment),an=n(),os=a("p"),os.textContent=pa,Mn=n(),r(ms.$$.fragment),rn=n(),js=a("p"),js.innerHTML=aa,cn=n(),r(Ts.$$.fragment),yn=n(),r(us.$$.fragment),Jn=n(),fs=a("p"),fs.textContent=ia,on=n(),r(Us.$$.fragment),mn=n(),ds=a("p"),ds.textContent=Ma,jn=n(),r(ks.$$.fragment),Tn=n(),r($s.$$.fragment),un=n(),bs=a("p"),bs.innerHTML=ra,fn=n(),r(ws.$$.fragment),Un=n(),Cs=a("p"),Cs.textContent=ca,dn=n(),r(gs.$$.fragment),kn=n(),hs=a("p"),hs.textContent=ya,$n=n(),r(xs.$$.fragment),bn=n(),Is=a("p"),Is.innerHTML=Ja,wn=n(),r(Vs.$$.fragment),Cn=n(),zs=a("p"),zs.textContent=oa,gn=n(),Zs=a("p"),Zs.textContent=ma,hn=n(),r(vs.$$.fragment),xn=n(),_s=a("p"),_s.innerHTML=ja,In=n(),Qs=a("p"),Qs.innerHTML=Ta,Vn=n(),r(Bs.$$.fragment),zn=n(),Ws=a("p"),Ws.textContent=ua,Zn=n(),r(Rs.$$.fragment),vn=n(),r(Ns.$$.fragment),_n=n(),Xs=a("p"),Xs.textContent=fa,Qn=n(),r(As.$$.fragment),Bn=n(),Es=a("p"),Es.innerHTML=Ua,Wn=n(),Gs=a("p"),Gs.textContent=da,Rn=n(),r(qs.$$.fragment),Nn=n(),Ls=a("p"),Ls.textContent=ka,Xn=n(),r(Hs.$$.fragment),An=n(),r(Ss.$$.fragment),En=n(),Ds=a("p"),Ds.innerHTML=$a,Gn=n(),r(Ps.$$.fragment),qn=n(),r(Ys.$$.fragment),Ln=n(),Fs=a("p"),Fs.textContent=ba,Hn=n(),r(Ks.$$.fragment),Sn=n(),Os=a("p"),Os.textContent=wa,Dn=n(),r(el.$$.fragment),Pn=n(),r(sl.$$.fragment),Yn=n(),ll=a("p"),ll.innerHTML=Ca,Fn=n(),r(tl.$$.fragment),Kn=n(),nl=a("p"),nl.innerHTML=ga,On=n(),r(pl.$$.fragment),ep=n(),al=a("p"),al.textContent=ha,sp=n(),r(il.$$.fragment),lp=n(),Ml=a("p"),Ml.textContent=xa,tp=n(),cl=a("p"),this.h()},l(e){const s=Ba("svelte-u9bgzb",document.head);T=i(s,"META",{name:!0,content:!0}),s.forEach(l),d=p(e),u=i(e,"P",{}),Va(u).forEach(l),rl=p(e),c(k.$$.fragment,e),ol=p(e),c($.$$.fragment,e),ml=p(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-b5kklz"&&(b.textContent=ap),jl=p(e),w=i(e,"UL",{"data-svelte-h":!0}),M(w)!=="svelte-1sajjkb"&&(w.innerHTML=ip),Tl=p(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-31tofb"&&(C.textContent=Mp),ul=p(e),f=i(e,"DIV",{class:!0,"data-svelte-h":!0}),M(f)!=="svelte-oxfng3"&&(f.innerHTML=rp),fl=p(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-15py1e8"&&(g.innerHTML=cp),Ul=p(e),c(h.$$.fragment,e),dl=p(e),x=i(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1jjcw0i"&&(x.innerHTML=yp),kl=p(e),I=i(e,"UL",{"data-svelte-h":!0}),M(I)!=="svelte-15yeq7j"&&(I.innerHTML=Jp),$l=p(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1d9w17d"&&(V.innerHTML=op),bl=p(e),c(z.$$.fragment,e),wl=p(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-14kxipg"&&(Z.innerHTML=mp),Cl=p(e),c(v.$$.fragment,e),gl=p(e),_=i(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1gsy8ta"&&(_.innerHTML=jp),hl=p(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1wtem0y"&&(Q.textContent=Tp),xl=p(e),c(B.$$.fragment,e),Il=p(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-gnegz7"&&(W.textContent=up),Vl=p(e),c(R.$$.fragment,e),zl=p(e),N=i(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-rdvi8a"&&(N.innerHTML=fp),Zl=p(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-17zu5lc"&&(X.innerHTML=Up),vl=p(e),c(A.$$.fragment,e),_l=p(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1uc1t5u"&&(E.innerHTML=dp),Ql=p(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-14au9ct"&&(G.innerHTML=kp),Bl=p(e),c(q.$$.fragment,e),Wl=p(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-13vk9t1"&&(L.innerHTML=$p),Rl=p(e),c(H.$$.fragment,e),Nl=p(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-eabqpa"&&(S.innerHTML=bp),Xl=p(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1cmtqtp"&&(D.innerHTML=wp),Al=p(e),c(P.$$.fragment,e),El=p(e),c(Y.$$.fragment,e),Gl=p(e),c(U.$$.fragment,e),ql=p(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1x52eyd"&&(F.innerHTML=Cp),Ll=p(e),c(K.$$.fragment,e),Hl=p(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-gv0viq"&&(O.textContent=gp),Sl=p(e),c(ee.$$.fragment,e),Dl=p(e),se=i(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-iy2ywz"&&(se.innerHTML=hp),Pl=p(e),c(le.$$.fragment,e),Yl=p(e),c(te.$$.fragment,e),Fl=p(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1hk0h2e"&&(ne.innerHTML=xp),Kl=p(e),c(pe.$$.fragment,e),Ol=p(e),c(ae.$$.fragment,e),et=p(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-1be6pgh"&&(ie.innerHTML=Ip),st=p(e),c(Me.$$.fragment,e),lt=p(e),c(re.$$.fragment,e),tt=p(e),ce=i(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-ornxe5"&&(ce.innerHTML=Vp),nt=p(e),c(ye.$$.fragment,e),pt=p(e),Je=i(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-14vfm6y"&&(Je.innerHTML=zp),at=p(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-93abaw"&&(oe.textContent=Zp),it=p(e),c(me.$$.fragment,e),Mt=p(e),je=i(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-y1gxvq"&&(je.innerHTML=vp),rt=p(e),c(Te.$$.fragment,e),ct=p(e),ue=i(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-19sql22"&&(ue.innerHTML=_p),yt=p(e),c(fe.$$.fragment,e),Jt=p(e),c(Ue.$$.fragment,e),ot=p(e),de=i(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-kyltif"&&(de.innerHTML=Qp),mt=p(e),ke=i(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-1e0xtn8"&&(ke.innerHTML=Bp),jt=p(e),c($e.$$.fragment,e),Tt=p(e),c(be.$$.fragment,e),ut=p(e),we=i(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1nd2ny2"&&(we.innerHTML=Wp),ft=p(e),Ce=i(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-na8mx0"&&(Ce.textContent=Rp),Ut=p(e),c(ge.$$.fragment,e),dt=p(e),he=i(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-rveu42"&&(he.textContent=Np),kt=p(e),xe=i(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-8cfq99"&&(xe.textContent=Xp),$t=p(e),c(Ie.$$.fragment,e),bt=p(e),c(Ve.$$.fragment,e),wt=p(e),ze=i(e,"P",{"data-svelte-h":!0}),M(ze)!=="svelte-utpzay"&&(ze.textContent=Ap),Ct=p(e),c(Ze.$$.fragment,e),gt=p(e),c(ve.$$.fragment,e),ht=p(e),_e=i(e,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-7ww78z"&&(_e.textContent=Ep),xt=p(e),c(Qe.$$.fragment,e),It=p(e),Be=i(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-106lhsb"&&(Be.innerHTML=Gp),Vt=p(e),c(We.$$.fragment,e),zt=p(e),c(Re.$$.fragment,e),Zt=p(e),Ne=i(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-189m9gi"&&(Ne.textContent=qp),vt=p(e),c(Xe.$$.fragment,e),_t=p(e),Ae=i(e,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-pm7hiy"&&(Ae.innerHTML=Lp),Qt=p(e),c(Ee.$$.fragment,e),Bt=p(e),Ge=i(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-1cpidft"&&(Ge.innerHTML=Hp),Wt=p(e),qe=i(e,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-1dxzktr"&&(qe.innerHTML=Sp),Rt=p(e),c(Le.$$.fragment,e),Nt=p(e),He=i(e,"P",{"data-svelte-h":!0}),M(He)!=="svelte-ttz8i2"&&(He.innerHTML=Dp),Xt=p(e),c(Se.$$.fragment,e),At=p(e),De=i(e,"P",{"data-svelte-h":!0}),M(De)!=="svelte-1ij2bkd"&&(De.innerHTML=Pp),Et=p(e),Pe=i(e,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-1x7u3bt"&&(Pe.textContent=Yp),Gt=p(e),c(Ye.$$.fragment,e),qt=p(e),Fe=i(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-ms4jk9"&&(Fe.innerHTML=Fp),Lt=p(e),c(Ke.$$.fragment,e),Ht=p(e),Oe=i(e,"P",{"data-svelte-h":!0}),M(Oe)!=="svelte-1efr97x"&&(Oe.innerHTML=Kp),St=p(e),es=i(e,"P",{"data-svelte-h":!0}),M(es)!=="svelte-zmu7y2"&&(es.textContent=Op),Dt=p(e),c(ss.$$.fragment,e),Pt=p(e),ls=i(e,"P",{"data-svelte-h":!0}),M(ls)!=="svelte-1cizskw"&&(ls.innerHTML=ea),Yt=p(e),c(ts.$$.fragment,e),Ft=p(e),c(ns.$$.fragment,e),Kt=p(e),ps=i(e,"P",{"data-svelte-h":!0}),M(ps)!=="svelte-1a0orcp"&&(ps.textContent=sa),Ot=p(e),c(as.$$.fragment,e),en=p(e),is=i(e,"P",{"data-svelte-h":!0}),M(is)!=="svelte-1p9vr1i"&&(is.innerHTML=la),sn=p(e),Ms=i(e,"P",{"data-svelte-h":!0}),M(Ms)!=="svelte-u4s8kx"&&(Ms.textContent=ta),ln=p(e),c(rs.$$.fragment,e),tn=p(e),cs=i(e,"P",{"data-svelte-h":!0}),M(cs)!=="svelte-cmzjwq"&&(cs.textContent=na),nn=p(e),c(ys.$$.fragment,e),pn=p(e),c(Js.$$.fragment,e),an=p(e),os=i(e,"P",{"data-svelte-h":!0}),M(os)!=="svelte-1gd6jqz"&&(os.textContent=pa),Mn=p(e),c(ms.$$.fragment,e),rn=p(e),js=i(e,"P",{"data-svelte-h":!0}),M(js)!=="svelte-1g95bkh"&&(js.innerHTML=aa),cn=p(e),c(Ts.$$.fragment,e),yn=p(e),c(us.$$.fragment,e),Jn=p(e),fs=i(e,"P",{"data-svelte-h":!0}),M(fs)!=="svelte-eerktk"&&(fs.textContent=ia),on=p(e),c(Us.$$.fragment,e),mn=p(e),ds=i(e,"P",{"data-svelte-h":!0}),M(ds)!=="svelte-yra0gn"&&(ds.textContent=Ma),jn=p(e),c(ks.$$.fragment,e),Tn=p(e),c($s.$$.fragment,e),un=p(e),bs=i(e,"P",{"data-svelte-h":!0}),M(bs)!=="svelte-ka6eer"&&(bs.innerHTML=ra),fn=p(e),c(ws.$$.fragment,e),Un=p(e),Cs=i(e,"P",{"data-svelte-h":!0}),M(Cs)!=="svelte-1cmlt11"&&(Cs.textContent=ca),dn=p(e),c(gs.$$.fragment,e),kn=p(e),hs=i(e,"P",{"data-svelte-h":!0}),M(hs)!=="svelte-upbbw9"&&(hs.textContent=ya),$n=p(e),c(xs.$$.fragment,e),bn=p(e),Is=i(e,"P",{"data-svelte-h":!0}),M(Is)!=="svelte-gprlmq"&&(Is.innerHTML=Ja),wn=p(e),c(Vs.$$.fragment,e),Cn=p(e),zs=i(e,"P",{"data-svelte-h":!0}),M(zs)!=="svelte-1yy918s"&&(zs.textContent=oa),gn=p(e),Zs=i(e,"P",{"data-svelte-h":!0}),M(Zs)!=="svelte-1n71160"&&(Zs.textContent=ma),hn=p(e),c(vs.$$.fragment,e),xn=p(e),_s=i(e,"P",{"data-svelte-h":!0}),M(_s)!=="svelte-197ybm4"&&(_s.innerHTML=ja),In=p(e),Qs=i(e,"P",{"data-svelte-h":!0}),M(Qs)!=="svelte-f4i3wg"&&(Qs.innerHTML=Ta),Vn=p(e),c(Bs.$$.fragment,e),zn=p(e),Ws=i(e,"P",{"data-svelte-h":!0}),M(Ws)!=="svelte-xj6oo"&&(Ws.textContent=ua),Zn=p(e),c(Rs.$$.fragment,e),vn=p(e),c(Ns.$$.fragment,e),_n=p(e),Xs=i(e,"P",{"data-svelte-h":!0}),M(Xs)!=="svelte-1tjrbj7"&&(Xs.textContent=fa),Qn=p(e),c(As.$$.fragment,e),Bn=p(e),Es=i(e,"P",{"data-svelte-h":!0}),M(Es)!=="svelte-z62fgj"&&(Es.innerHTML=Ua),Wn=p(e),Gs=i(e,"P",{"data-svelte-h":!0}),M(Gs)!=="svelte-u4s8kx"&&(Gs.textContent=da),Rn=p(e),c(qs.$$.fragment,e),Nn=p(e),Ls=i(e,"P",{"data-svelte-h":!0}),M(Ls)!=="svelte-1gxe1cq"&&(Ls.textContent=ka),Xn=p(e),c(Hs.$$.fragment,e),An=p(e),c(Ss.$$.fragment,e),En=p(e),Ds=i(e,"P",{"data-svelte-h":!0}),M(Ds)!=="svelte-hd4plk"&&(Ds.innerHTML=$a),Gn=p(e),c(Ps.$$.fragment,e),qn=p(e),c(Ys.$$.fragment,e),Ln=p(e),Fs=i(e,"P",{"data-svelte-h":!0}),M(Fs)!=="svelte-1b1rase"&&(Fs.textContent=ba),Hn=p(e),c(Ks.$$.fragment,e),Sn=p(e),Os=i(e,"P",{"data-svelte-h":!0}),M(Os)!=="svelte-45g554"&&(Os.textContent=wa),Dn=p(e),c(el.$$.fragment,e),Pn=p(e),c(sl.$$.fragment,e),Yn=p(e),ll=i(e,"P",{"data-svelte-h":!0}),M(ll)!=="svelte-1b0rt28"&&(ll.innerHTML=Ca),Fn=p(e),c(tl.$$.fragment,e),Kn=p(e),nl=i(e,"P",{"data-svelte-h":!0}),M(nl)!=="svelte-tmcl78"&&(nl.innerHTML=ga),On=p(e),c(pl.$$.fragment,e),ep=p(e),al=i(e,"P",{"data-svelte-h":!0}),M(al)!=="svelte-b94jpj"&&(al.textContent=ha),sp=p(e),c(il.$$.fragment,e),lp=p(e),Ml=i(e,"P",{"data-svelte-h":!0}),M(Ml)!=="svelte-15vwsr5"&&(Ml.textContent=xa),tp=p(e),cl=i(e,"P",{}),Va(cl).forEach(l),this.h()},h(){pp(T,"name","hf:doc:metadata"),pp(T,"content",Ga),pp(f,"class","flex justify-center")},m(e,s){Wa(document.head,T),t(e,d,s),t(e,u,s),t(e,rl,s),y(k,e,s),t(e,ol,s),y($,e,s),t(e,ml,s),t(e,b,s),t(e,jl,s),t(e,w,s),t(e,Tl,s),t(e,C,s),t(e,ul,s),t(e,f,s),t(e,fl,s),t(e,g,s),t(e,Ul,s),y(h,e,s),t(e,dl,s),t(e,x,s),t(e,kl,s),t(e,I,s),t(e,$l,s),t(e,V,s),t(e,bl,s),y(z,e,s),t(e,wl,s),t(e,Z,s),t(e,Cl,s),y(v,e,s),t(e,gl,s),t(e,_,s),t(e,hl,s),t(e,Q,s),t(e,xl,s),y(B,e,s),t(e,Il,s),t(e,W,s),t(e,Vl,s),y(R,e,s),t(e,zl,s),t(e,N,s),t(e,Zl,s),t(e,X,s),t(e,vl,s),y(A,e,s),t(e,_l,s),t(e,E,s),t(e,Ql,s),t(e,G,s),t(e,Bl,s),y(q,e,s),t(e,Wl,s),t(e,L,s),t(e,Rl,s),y(H,e,s),t(e,Nl,s),t(e,S,s),t(e,Xl,s),t(e,D,s),t(e,Al,s),y(P,e,s),t(e,El,s),y(Y,e,s),t(e,Gl,s),y(U,e,s),t(e,ql,s),t(e,F,s),t(e,Ll,s),y(K,e,s),t(e,Hl,s),t(e,O,s),t(e,Sl,s),y(ee,e,s),t(e,Dl,s),t(e,se,s),t(e,Pl,s),y(le,e,s),t(e,Yl,s),y(te,e,s),t(e,Fl,s),t(e,ne,s),t(e,Kl,s),y(pe,e,s),t(e,Ol,s),y(ae,e,s),t(e,et,s),t(e,ie,s),t(e,st,s),y(Me,e,s),t(e,lt,s),y(re,e,s),t(e,tt,s),t(e,ce,s),t(e,nt,s),y(ye,e,s),t(e,pt,s),t(e,Je,s),t(e,at,s),t(e,oe,s),t(e,it,s),y(me,e,s),t(e,Mt,s),t(e,je,s),t(e,rt,s),y(Te,e,s),t(e,ct,s),t(e,ue,s),t(e,yt,s),y(fe,e,s),t(e,Jt,s),y(Ue,e,s),t(e,ot,s),t(e,de,s),t(e,mt,s),t(e,ke,s),t(e,jt,s),y($e,e,s),t(e,Tt,s),y(be,e,s),t(e,ut,s),t(e,we,s),t(e,ft,s),t(e,Ce,s),t(e,Ut,s),y(ge,e,s),t(e,dt,s),t(e,he,s),t(e,kt,s),t(e,xe,s),t(e,$t,s),y(Ie,e,s),t(e,bt,s),y(Ve,e,s),t(e,wt,s),t(e,ze,s),t(e,Ct,s),y(Ze,e,s),t(e,gt,s),y(ve,e,s),t(e,ht,s),t(e,_e,s),t(e,xt,s),y(Qe,e,s),t(e,It,s),t(e,Be,s),t(e,Vt,s),y(We,e,s),t(e,zt,s),y(Re,e,s),t(e,Zt,s),t(e,Ne,s),t(e,vt,s),y(Xe,e,s),t(e,_t,s),t(e,Ae,s),t(e,Qt,s),y(Ee,e,s),t(e,Bt,s),t(e,Ge,s),t(e,Wt,s),t(e,qe,s),t(e,Rt,s),y(Le,e,s),t(e,Nt,s),t(e,He,s),t(e,Xt,s),y(Se,e,s),t(e,At,s),t(e,De,s),t(e,Et,s),t(e,Pe,s),t(e,Gt,s),y(Ye,e,s),t(e,qt,s),t(e,Fe,s),t(e,Lt,s),y(Ke,e,s),t(e,Ht,s),t(e,Oe,s),t(e,St,s),t(e,es,s),t(e,Dt,s),y(ss,e,s),t(e,Pt,s),t(e,ls,s),t(e,Yt,s),y(ts,e,s),t(e,Ft,s),y(ns,e,s),t(e,Kt,s),t(e,ps,s),t(e,Ot,s),y(as,e,s),t(e,en,s),t(e,is,s),t(e,sn,s),t(e,Ms,s),t(e,ln,s),y(rs,e,s),t(e,tn,s),t(e,cs,s),t(e,nn,s),y(ys,e,s),t(e,pn,s),y(Js,e,s),t(e,an,s),t(e,os,s),t(e,Mn,s),y(ms,e,s),t(e,rn,s),t(e,js,s),t(e,cn,s),y(Ts,e,s),t(e,yn,s),y(us,e,s),t(e,Jn,s),t(e,fs,s),t(e,on,s),y(Us,e,s),t(e,mn,s),t(e,ds,s),t(e,jn,s),y(ks,e,s),t(e,Tn,s),y($s,e,s),t(e,un,s),t(e,bs,s),t(e,fn,s),y(ws,e,s),t(e,Un,s),t(e,Cs,s),t(e,dn,s),y(gs,e,s),t(e,kn,s),t(e,hs,s),t(e,$n,s),y(xs,e,s),t(e,bn,s),t(e,Is,s),t(e,wn,s),y(Vs,e,s),t(e,Cn,s),t(e,zs,s),t(e,gn,s),t(e,Zs,s),t(e,hn,s),y(vs,e,s),t(e,xn,s),t(e,_s,s),t(e,In,s),t(e,Qs,s),t(e,Vn,s),y(Bs,e,s),t(e,zn,s),t(e,Ws,s),t(e,Zn,s),y(Rs,e,s),t(e,vn,s),y(Ns,e,s),t(e,_n,s),t(e,Xs,s),t(e,Qn,s),y(As,e,s),t(e,Bn,s),t(e,Es,s),t(e,Wn,s),t(e,Gs,s),t(e,Rn,s),y(qs,e,s),t(e,Nn,s),t(e,Ls,s),t(e,Xn,s),y(Hs,e,s),t(e,An,s),y(Ss,e,s),t(e,En,s),t(e,Ds,s),t(e,Gn,s),y(Ps,e,s),t(e,qn,s),y(Ys,e,s),t(e,Ln,s),t(e,Fs,s),t(e,Hn,s),y(Ks,e,s),t(e,Sn,s),t(e,Os,s),t(e,Dn,s),y(el,e,s),t(e,Pn,s),y(sl,e,s),t(e,Yn,s),t(e,ll,s),t(e,Fn,s),y(tl,e,s),t(e,Kn,s),t(e,nl,s),t(e,On,s),y(pl,e,s),t(e,ep,s),t(e,al,s),t(e,sp,s),y(il,e,s),t(e,lp,s),t(e,Ml,s),t(e,tp,s),t(e,cl,s),np=!0},p(e,[s]){const Ia={};s&2&&(Ia.$$scope={dirty:s,ctx:e}),U.$set(Ia)},i(e){np||(J(k.$$.fragment,e),J($.$$.fragment,e),J(h.$$.fragment,e),J(z.$$.fragment,e),J(v.$$.fragment,e),J(B.$$.fragment,e),J(R.$$.fragment,e),J(A.$$.fragment,e),J(q.$$.fragment,e),J(H.$$.fragment,e),J(P.$$.fragment,e),J(Y.$$.fragment,e),J(U.$$.fragment,e),J(K.$$.fragment,e),J(ee.$$.fragment,e),J(le.$$.fragment,e),J(te.$$.fragment,e),J(pe.$$.fragment,e),J(ae.$$.fragment,e),J(Me.$$.fragment,e),J(re.$$.fragment,e),J(ye.$$.fragment,e),J(me.$$.fragment,e),J(Te.$$.fragment,e),J(fe.$$.fragment,e),J(Ue.$$.fragment,e),J($e.$$.fragment,e),J(be.$$.fragment,e),J(ge.$$.fragment,e),J(Ie.$$.fragment,e),J(Ve.$$.fragment,e),J(Ze.$$.fragment,e),J(ve.$$.fragment,e),J(Qe.$$.fragment,e),J(We.$$.fragment,e),J(Re.$$.fragment,e),J(Xe.$$.fragment,e),J(Ee.$$.fragment,e),J(Le.$$.fragment,e),J(Se.$$.fragment,e),J(Ye.$$.fragment,e),J(Ke.$$.fragment,e),J(ss.$$.fragment,e),J(ts.$$.fragment,e),J(ns.$$.fragment,e),J(as.$$.fragment,e),J(rs.$$.fragment,e),J(ys.$$.fragment,e),J(Js.$$.fragment,e),J(ms.$$.fragment,e),J(Ts.$$.fragment,e),J(us.$$.fragment,e),J(Us.$$.fragment,e),J(ks.$$.fragment,e),J($s.$$.fragment,e),J(ws.$$.fragment,e),J(gs.$$.fragment,e),J(xs.$$.fragment,e),J(Vs.$$.fragment,e),J(vs.$$.fragment,e),J(Bs.$$.fragment,e),J(Rs.$$.fragment,e),J(Ns.$$.fragment,e),J(As.$$.fragment,e),J(qs.$$.fragment,e),J(Hs.$$.fragment,e),J(Ss.$$.fragment,e),J(Ps.$$.fragment,e),J(Ys.$$.fragment,e),J(Ks.$$.fragment,e),J(el.$$.fragment,e),J(sl.$$.fragment,e),J(tl.$$.fragment,e),J(pl.$$.fragment,e),J(il.$$.fragment,e),np=!0)},o(e){o(k.$$.fragment,e),o($.$$.fragment,e),o(h.$$.fragment,e),o(z.$$.fragment,e),o(v.$$.fragment,e),o(B.$$.fragment,e),o(R.$$.fragment,e),o(A.$$.fragment,e),o(q.$$.fragment,e),o(H.$$.fragment,e),o(P.$$.fragment,e),o(Y.$$.fragment,e),o(U.$$.fragment,e),o(K.$$.fragment,e),o(ee.$$.fragment,e),o(le.$$.fragment,e),o(te.$$.fragment,e),o(pe.$$.fragment,e),o(ae.$$.fragment,e),o(Me.$$.fragment,e),o(re.$$.fragment,e),o(ye.$$.fragment,e),o(me.$$.fragment,e),o(Te.$$.fragment,e),o(fe.$$.fragment,e),o(Ue.$$.fragment,e),o($e.$$.fragment,e),o(be.$$.fragment,e),o(ge.$$.fragment,e),o(Ie.$$.fragment,e),o(Ve.$$.fragment,e),o(Ze.$$.fragment,e),o(ve.$$.fragment,e),o(Qe.$$.fragment,e),o(We.$$.fragment,e),o(Re.$$.fragment,e),o(Xe.$$.fragment,e),o(Ee.$$.fragment,e),o(Le.$$.fragment,e),o(Se.$$.fragment,e),o(Ye.$$.fragment,e),o(Ke.$$.fragment,e),o(ss.$$.fragment,e),o(ts.$$.fragment,e),o(ns.$$.fragment,e),o(as.$$.fragment,e),o(rs.$$.fragment,e),o(ys.$$.fragment,e),o(Js.$$.fragment,e),o(ms.$$.fragment,e),o(Ts.$$.fragment,e),o(us.$$.fragment,e),o(Us.$$.fragment,e),o(ks.$$.fragment,e),o($s.$$.fragment,e),o(ws.$$.fragment,e),o(gs.$$.fragment,e),o(xs.$$.fragment,e),o(Vs.$$.fragment,e),o(vs.$$.fragment,e),o(Bs.$$.fragment,e),o(Rs.$$.fragment,e),o(Ns.$$.fragment,e),o(As.$$.fragment,e),o(qs.$$.fragment,e),o(Hs.$$.fragment,e),o(Ss.$$.fragment,e),o(Ps.$$.fragment,e),o(Ys.$$.fragment,e),o(Ks.$$.fragment,e),o(el.$$.fragment,e),o(sl.$$.fragment,e),o(tl.$$.fragment,e),o(pl.$$.fragment,e),o(il.$$.fragment,e),np=!1},d(e){e&&(l(d),l(u),l(rl),l(ol),l(ml),l(b),l(jl),l(w),l(Tl),l(C),l(ul),l(f),l(fl),l(g),l(Ul),l(dl),l(x),l(kl),l(I),l($l),l(V),l(bl),l(wl),l(Z),l(Cl),l(gl),l(_),l(hl),l(Q),l(xl),l(Il),l(W),l(Vl),l(zl),l(N),l(Zl),l(X),l(vl),l(_l),l(E),l(Ql),l(G),l(Bl),l(Wl),l(L),l(Rl),l(Nl),l(S),l(Xl),l(D),l(Al),l(El),l(Gl),l(ql),l(F),l(Ll),l(Hl),l(O),l(Sl),l(Dl),l(se),l(Pl),l(Yl),l(Fl),l(ne),l(Kl),l(Ol),l(et),l(ie),l(st),l(lt),l(tt),l(ce),l(nt),l(pt),l(Je),l(at),l(oe),l(it),l(Mt),l(je),l(rt),l(ct),l(ue),l(yt),l(Jt),l(ot),l(de),l(mt),l(ke),l(jt),l(Tt),l(ut),l(we),l(ft),l(Ce),l(Ut),l(dt),l(he),l(kt),l(xe),l($t),l(bt),l(wt),l(ze),l(Ct),l(gt),l(ht),l(_e),l(xt),l(It),l(Be),l(Vt),l(zt),l(Zt),l(Ne),l(vt),l(_t),l(Ae),l(Qt),l(Bt),l(Ge),l(Wt),l(qe),l(Rt),l(Nt),l(He),l(Xt),l(At),l(De),l(Et),l(Pe),l(Gt),l(qt),l(Fe),l(Lt),l(Ht),l(Oe),l(St),l(es),l(Dt),l(Pt),l(ls),l(Yt),l(Ft),l(Kt),l(ps),l(Ot),l(en),l(is),l(sn),l(Ms),l(ln),l(tn),l(cs),l(nn),l(pn),l(an),l(os),l(Mn),l(rn),l(js),l(cn),l(yn),l(Jn),l(fs),l(on),l(mn),l(ds),l(jn),l(Tn),l(un),l(bs),l(fn),l(Un),l(Cs),l(dn),l(kn),l(hs),l($n),l(bn),l(Is),l(wn),l(Cn),l(zs),l(gn),l(Zs),l(hn),l(xn),l(_s),l(In),l(Qs),l(Vn),l(zn),l(Ws),l(Zn),l(vn),l(_n),l(Xs),l(Qn),l(Bn),l(Es),l(Wn),l(Gs),l(Rn),l(Nn),l(Ls),l(Xn),l(An),l(En),l(Ds),l(Gn),l(qn),l(Ln),l(Fs),l(Hn),l(Sn),l(Os),l(Dn),l(Pn),l(Yn),l(ll),l(Fn),l(Kn),l(nl),l(On),l(ep),l(al),l(sp),l(lp),l(Ml),l(tp),l(cl)),l(T),m(k,e),m($,e),m(h,e),m(z,e),m(v,e),m(B,e),m(R,e),m(A,e),m(q,e),m(H,e),m(P,e),m(Y,e),m(U,e),m(K,e),m(ee,e),m(le,e),m(te,e),m(pe,e),m(ae,e),m(Me,e),m(re,e),m(ye,e),m(me,e),m(Te,e),m(fe,e),m(Ue,e),m($e,e),m(be,e),m(ge,e),m(Ie,e),m(Ve,e),m(Ze,e),m(ve,e),m(Qe,e),m(We,e),m(Re,e),m(Xe,e),m(Ee,e),m(Le,e),m(Se,e),m(Ye,e),m(Ke,e),m(ss,e),m(ts,e),m(ns,e),m(as,e),m(rs,e),m(ys,e),m(Js,e),m(ms,e),m(Ts,e),m(us,e),m(Us,e),m(ks,e),m($s,e),m(ws,e),m(gs,e),m(xs,e),m(Vs,e),m(vs,e),m(Bs,e),m(Rs,e),m(Ns,e),m(As,e),m(qs,e),m(Hs,e),m(Ss,e),m(Ps,e),m(Ys,e),m(Ks,e),m(el,e),m(sl,e),m(tl,e),m(pl,e),m(il,e)}}}const Ga='{"title":"Создание токенизатора, блок за блоком","local":"building-a-tokenizer-block-by-block","sections":[{"title":"Получение корпуса текста","local":"acquiring-a-corpus","sections":[],"depth":2},{"title":"Создание токенизатора WordPiece с нуля","local":"building-a-wordpiece-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Создание токенизатора BPE с нуля","local":"building-a-bpe-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Создание токенизатора Unigram с нуля","local":"building-a-unigram-tokenizer-from-scratch","sections":[],"depth":2}],"depth":1}';function qa(Jl){return Za(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ka extends _a{constructor(T){super(),Qa(this,T,qa,Ea,za,{})}}export{Ka as component};
