import{s as L,f as K,n as O,o as D}from"../chunks/scheduler.f7e1785c.js";import{S as ee,i as te,g as p,s as n,r as $,A as ae,h as c,f as a,c as i,j as N,u as J,x as E,k as r,y as le,a as l,v as T,d as U,t as G,w as _}from"../chunks/index.9f8f0838.js";import{C as Y}from"../chunks/CodeBlock.4baef5d7.js";import{H as se,E as ne}from"../chunks/getInferenceSnippets.ba5f4cd0.js";function ie(S){let o,k,j,B,m,C,d,X=`In this final section on audio classification, we’ll build a <a href="https://gradio.app" rel="nofollow">Gradio</a> demo to showcase the music
classification model that we just trained on the <a href="https://huggingface.co/datasets/marsyas/gtzan" rel="nofollow">GTZAN</a> dataset. The first
thing to do is load up the fine-tuned checkpoint using the <code>pipeline()</code> class - this is very familiar now from the section
on <a href="classification_models">pre-trained models</a>. You can change the <code>model_id</code> to the namespace of your fine-tuned model
on the Hugging Face Hub:`,I,u,x,f,q=`Secondly, we’ll define a function that takes the filepath for an audio input and passes it through the pipeline. Here,
the pipeline automatically takes care of loading the audio file, resampling it to the correct sampling rate, and running
inference with the model. We take the models predictions of <code>preds</code> and format them as a dictionary object to be displayed on the
output:`,R,h,W,w,z="Finally, we launch the Gradio demo using the function we’ve just defined:",v,M,Z,y,F="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",H,s,P,Q,g,A,b,V;return m=new se({props:{title:"Build a demo with Gradio",local:"build-a-demo-with-gradio",headingTag:"h1"}}),u=new Y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzYW5jaGl0LWdhbmRoaSUyRmRpc3RpbGh1YmVydC1maW5ldHVuZWQtZ3R6YW4lMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model_id = <span class="hljs-string">&quot;sanchit-gandhi/distilhubert-finetuned-gtzan&quot;</span>
pipe = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model_id)`,wrap:!1}}),h=new Y({props:{code:"ZGVmJTIwY2xhc3NpZnlfYXVkaW8oZmlsZXBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZHMlMjAlM0QlMjBwaXBlKGZpbGVwYXRoKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBwJTIwaW4lMjBwcmVkcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlNUJwJTVCJTIybGFiZWwlMjIlNUQlNUQlMjAlM0QlMjBwJTVCJTIyc2NvcmUlMjIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_audio</span>(<span class="hljs-params">filepath</span>):
    preds = pipe(filepath)
    outputs = {}
    <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> preds:
        outputs[p[<span class="hljs-string">&quot;label&quot;</span>]] = p[<span class="hljs-string">&quot;score&quot;</span>]
    <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),M=new Y({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RjbGFzc2lmeV9hdWRpbyUyQyUyMGlucHV0cyUzRGdyLkF1ZGlvKHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMjBvdXRwdXRzJTNEZ3Iub3V0cHV0cy5MYWJlbCgpJTBBKSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Interface(
    fn=classify_audio, inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>), outputs=gr.outputs.Label()
)
demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),g=new ne({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter4/demo.mdx"}}),{c(){o=p("meta"),k=n(),j=p("p"),B=n(),$(m.$$.fragment),C=n(),d=p("p"),d.innerHTML=X,I=n(),$(u.$$.fragment),x=n(),f=p("p"),f.innerHTML=q,R=n(),$(h.$$.fragment),W=n(),w=p("p"),w.textContent=z,v=n(),$(M.$$.fragment),Z=n(),y=p("p"),y.textContent=F,H=n(),s=p("iframe"),Q=n(),$(g.$$.fragment),A=n(),b=p("p"),this.h()},l(e){const t=ae("svelte-u9bgzb",document.head);o=c(t,"META",{name:!0,content:!0}),t.forEach(a),k=i(e),j=c(e,"P",{}),N(j).forEach(a),B=i(e),J(m.$$.fragment,e),C=i(e),d=c(e,"P",{"data-svelte-h":!0}),E(d)!=="svelte-1r0764x"&&(d.innerHTML=X),I=i(e),J(u.$$.fragment,e),x=i(e),f=c(e,"P",{"data-svelte-h":!0}),E(f)!=="svelte-1o13rj8"&&(f.innerHTML=q),R=i(e),J(h.$$.fragment,e),W=i(e),w=c(e,"P",{"data-svelte-h":!0}),E(w)!=="svelte-rqn9c6"&&(w.textContent=z),v=i(e),J(M.$$.fragment,e),Z=i(e),y=c(e,"P",{"data-svelte-h":!0}),E(y)!=="svelte-10sf4ix"&&(y.textContent=F),H=i(e),s=c(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),N(s).forEach(a),Q=i(e),J(g.$$.fragment,e),A=i(e),b=c(e,"P",{}),N(b).forEach(a),this.h()},h(){r(o,"name","hf:doc:metadata"),r(o,"content",oe),K(s.src,P="https://course-demos-song-classifier.hf.space")||r(s,"src",P),r(s,"frameborder","0"),r(s,"height","450"),r(s,"title","Gradio app"),r(s,"class","container p-0 flex-grow space-iframe"),r(s,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(s,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){le(document.head,o),l(e,k,t),l(e,j,t),l(e,B,t),T(m,e,t),l(e,C,t),l(e,d,t),l(e,I,t),T(u,e,t),l(e,x,t),l(e,f,t),l(e,R,t),T(h,e,t),l(e,W,t),l(e,w,t),l(e,v,t),T(M,e,t),l(e,Z,t),l(e,y,t),l(e,H,t),l(e,s,t),l(e,Q,t),T(g,e,t),l(e,A,t),l(e,b,t),V=!0},p:O,i(e){V||(U(m.$$.fragment,e),U(u.$$.fragment,e),U(h.$$.fragment,e),U(M.$$.fragment,e),U(g.$$.fragment,e),V=!0)},o(e){G(m.$$.fragment,e),G(u.$$.fragment,e),G(h.$$.fragment,e),G(M.$$.fragment,e),G(g.$$.fragment,e),V=!1},d(e){e&&(a(k),a(j),a(B),a(C),a(d),a(I),a(x),a(f),a(R),a(W),a(w),a(v),a(Z),a(y),a(H),a(s),a(Q),a(A),a(b)),a(o),_(m,e),_(u,e),_(h,e),_(M,e),_(g,e)}}}const oe='{"title":"Build a demo with Gradio","local":"build-a-demo-with-gradio","sections":[],"depth":1}';function re(S){return D(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ue extends ee{constructor(o){super(),te(this,o,re,ie,L,{})}}export{ue as component};
