import{s as Xt,o as Nt}from"../chunks/scheduler.f7e1785c.js";import{S as Vt,i as qt,g as i,s as l,r as p,A as Yt,h as o,f as a,c as n,j as Ht,u as m,x as r,k as rt,y as zt,a as s,v as M,d as u,t as h,w as d,m as Et,n as Qt}from"../chunks/index.9f8f0838.js";import{T as Ft}from"../chunks/Tip.4575d9cf.js";import{C as y}from"../chunks/CodeBlock.4baef5d7.js";import{H as ot,E as St}from"../chunks/getInferenceSnippets.ba5f4cd0.js";function Lt(ue){let c;return{c(){c=Et(`💡 Some background on resampling: If an audio signal has been sampled at 8 kHz, so that it has 8000 sample readings per
second, we know that the audio does not contain any frequencies over 4 kHz. This is guaranteed by the Nyquist sampling
theorem. Because of this, we can be certain that in between the sampling points the original continuous signal always
makes a smooth curve. Upsampling to a higher sampling rate is then a matter of calculating additional sample values that go in between
the existing ones, by approximating this curve. Downsampling, however, requires that we first filter out any frequencies
that would be higher than the new Nyquist limit, before estimating the new sample points. In other words, you can't
downsample by a factor 2x by simply throwing away every other sample — this will create distortions in the signal called
aliases. Doing resampling correctly is tricky and best left to well-tested libraries such as librosa or 🤗 Datasets.`)},l(f){c=Qt(f,`💡 Some background on resampling: If an audio signal has been sampled at 8 kHz, so that it has 8000 sample readings per
second, we know that the audio does not contain any frequencies over 4 kHz. This is guaranteed by the Nyquist sampling
theorem. Because of this, we can be certain that in between the sampling points the original continuous signal always
makes a smooth curve. Upsampling to a higher sampling rate is then a matter of calculating additional sample values that go in between
the existing ones, by approximating this curve. Downsampling, however, requires that we first filter out any frequencies
that would be higher than the new Nyquist limit, before estimating the new sample points. In other words, you can't
downsample by a factor 2x by simply throwing away every other sample — this will create distortions in the signal called
aliases. Doing resampling correctly is tricky and best left to well-tested libraries such as librosa or 🤗 Datasets.`)},m(f,T){s(f,c,T)},d(f){f&&a(c)}}}function Dt(ue){let c,f,T,he,J,de,U,pt=`Loading a dataset with 🤗 Datasets is just half of the fun. If you plan to use it either for training a model, or for running
inference, you will need to pre-process the data first. In general, this will involve the following steps:`,ce,g,mt="<li>Resampling the audio data</li> <li>Filtering the dataset</li> <li>Converting audio data to model’s expected input</li>",ye,b,fe,I,Mt=`The <code>load_dataset</code> function downloads audio examples with the sampling rate that they were published with. This is not
always the sampling rate expected by a model you plan to train, or use for inference. If there’s a discrepancy between
the sampling rates, you can resample the audio to the model’s expected sampling rate.`,we,C,ut=`Most of the available pretrained models have been pretrained on audio datasets at a sampling rate of 16 kHz.
When we explored MINDS-14 dataset, you may have noticed that it is sampled at 8 kHz, which means we will likely need
to upsample it.`,je,A,ht=`To do so, use 🤗 Datasets’ <code>cast_column</code> method. This operation does not change the audio in-place, but rather signals
to datasets to resample the audio examples on the fly when they are loaded. The following code will set the sampling
rate to 16kHz:`,Te,x,Je,$,dt="Re-load the first audio example in the MINDS-14 dataset, and check that it has been resampled to the desired <code>sampling rate</code>:",Ue,v,ge,k,ct="<strong>Output:</strong>",be,_,Ie,B,yt=`You may notice that the array values are now also different. This is because we’ve now got twice the number of amplitude values for
every one that we had before.`,Ce,w,Ae,R,xe,Z,ft=`You may need to filter the data based on some criteria. One of the common cases involves limiting the audio examples to a
certain duration. For instance, we might want to filter out any examples longer than 20s to prevent out-of-memory errors
when training a model.`,$e,G,wt=`We can do this by using the  🤗 Datasets’ <code>filter</code> method and passing a function with filtering logic to it. Let’s start by writing a
function that indicates which examples to keep and which to discard. This function, <code>is_audio_length_in_range</code>,
returns <code>True</code> if a sample is shorter than 20s, and <code>False</code> if it is longer than 20s.`,ve,W,ke,H,jt=`The filtering function can be applied to a dataset’s column but we do not have a column with audio track duration in this
dataset. However, we can create one, filter based on the values in that column, and then remove it.`,_e,X,Be,N,Tt="<strong>Output:</strong>",Re,V,Ze,q,Jt="We can verify that dataset has been filtered down from 654 examples to 624.",Ge,Y,We,z,Ut=`One of the most challenging aspects of working with audio datasets is preparing the data in the right format for model
training. As you saw, the raw audio data comes as an array of sample values. However, pre-trained models, whether you use them
for inference, or want to fine-tune them for your task, expect the raw data to be converted into input features. The
requirements for the input features may vary from one model to another — they depend on the model’s architecture, and the data it was
pre-trained with. The good news is, for every supported audio model, 🤗 Transformers offer a feature extractor class
that can convert raw audio data into the input features the model expects.`,He,E,gt=`So what does a feature extractor do with the raw audio data? Let’s take a look at <a href="https://huggingface.co/papers/2212.04356" rel="nofollow">Whisper</a>’s
feature extractor to understand some common feature extraction transformations. Whisper is a pre-trained model for
automatic speech recognition (ASR) published in September 2022 by Alec Radford et al. from OpenAI.`,Xe,Q,bt=`First, the Whisper feature extractor pads/truncates a batch of audio examples such that all
examples have an input length of 30s. Examples shorter than this are padded to 30s by appending zeros to the end of the
sequence (zeros in an audio signal correspond to no signal or silence). Examples longer than 30s are truncated to 30s.
Since all elements in the batch are padded/truncated to a maximum length in the input space, there is no need for an attention
mask. Whisper is unique in this regard, most other audio models require an attention mask that details
where sequences have been padded, and thus where they should be ignored in the self-attention mechanism. Whisper is
trained to operate without an attention mask and infer directly from the speech signals where to ignore the inputs.`,Ne,F,It=`The second operation that the Whisper feature extractor performs is converting the padded audio arrays to log-mel spectrograms.
As you recall, these spectrograms describe how the frequencies of a signal change over time, expressed on the mel scale
and measured in decibels (the log part) to make the frequencies and amplitudes more representative of human hearing.`,Ve,S,Ct=`All these transformations can be applied to your raw audio data with a couple of lines of code. Let’s go ahead and load
the feature extractor from the pre-trained Whisper checkpoint to have ready for our audio data:`,qe,L,Ye,D,At="Next, you can write a function to pre-process a single audio example by passing it through the <code>feature_extractor</code>.",ze,P,Ee,O,xt="We can apply the data preparation function to all of our training examples using 🤗 Datasets’ map method:",Qe,K,Fe,ee,$t="<strong>Output:</strong>",Se,te,Le,ae,vt="As easy as that, we now have log-mel spectrograms as <code>input_features</code> in the dataset.",De,se,kt="Let’s visualize it for one of the examples in the <code>minds</code> dataset:",Pe,le,Oe,j,_t='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',Ke,ne,Bt="Now you can see what the audio input to the Whisper model looks like after preprocessing.",et,ie,Rt=`The model’s feature extractor class takes care of transforming raw audio data to the format that the model expects. However,
many tasks involving audio are multimodal, e.g. speech recognition. In such cases 🤗 Transformers also offer model-specific
tokenizers to process the text inputs. For a deep dive into tokenizers, please refer to our <a href="https://huggingface.co/course/chapter2/4" rel="nofollow">NLP course</a>.`,tt,oe,Zt=`You can load the feature extractor and tokenizer for Whisper and other multimodal models separately, or you can load both via
a so-called processor. To make things even simpler, use <code>AutoProcessor</code> to load a model’s feature extractor and processor from a
checkpoint, like this:`,at,re,st,pe,Gt=`Here we have illustrated the fundamental data preparation steps. Of course, custom data may require more complex preprocessing.
In this case, you can extend the function <code>prepare_dataset</code> to perform any sort of custom data transformations. With 🤗 Datasets,
if you can write it as a Python function, you can <a href="https://huggingface.co/docs/datasets/audio_process" rel="nofollow">apply it</a> to your dataset!`,lt,me,nt,Me,it;return J=new ot({props:{title:"Preprocessing an audio dataset",local:"preprocessing-an-audio-dataset",headingTag:"h1"}}),b=new ot({props:{title:"Resampling the audio data",local:"resampling-the-audio-data",headingTag:"h2"}}),x=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),v=new y({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]',wrap:!1}}),_=new y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}`,wrap:!1}}),w=new Ft({props:{$$slots:{default:[Lt]},$$scope:{ctx:ue}}}),R=new ot({props:{title:"Filtering the dataset",local:"filtering-the-dataset",headingTag:"h2"}}),W=new y({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`,wrap:!1}}),X=new y({props:{code:"JTIzJTIwdXNlJTIwbGlicm9zYSUyMHRvJTIwZ2V0JTIwZXhhbXBsZSdzJTIwZHVyYXRpb24lMjBmcm9tJTIwdGhlJTIwYXVkaW8lMjBmaWxlJTBBbmV3X2NvbHVtbiUyMCUzRCUyMCU1QmxpYnJvc2EuZ2V0X2R1cmF0aW9uKHBhdGglM0R4KSUyMGZvciUyMHglMjBpbiUyMG1pbmRzJTVCJTIycGF0aCUyMiU1RCU1RCUwQW1pbmRzJTIwJTNEJTIwbWluZHMuYWRkX2NvbHVtbiglMjJkdXJhdGlvbiUyMiUyQyUyMG5ld19jb2x1bW4pJTBBJTBBJTIzJTIwdXNlJTIwJUYwJTlGJUE0JTk3JTIwRGF0YXNldHMnJTIwJTYwZmlsdGVyJTYwJTIwbWV0aG9kJTIwdG8lMjBhcHBseSUyMHRoZSUyMGZpbHRlcmluZyUyMGZ1bmN0aW9uJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5maWx0ZXIoaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlJTJDJTIwaW5wdXRfY29sdW1ucyUzRCU1QiUyMmR1cmF0aW9uJTIyJTVEKSUwQSUwQSUyMyUyMHJlbW92ZSUyMHRoZSUyMHRlbXBvcmFyeSUyMGhlbHBlciUyMGNvbHVtbiUwQW1pbmRzJTIwJTNEJTIwbWluZHMucmVtb3ZlX2NvbHVtbnMoJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBbWluZHM=",highlighted:`<span class="hljs-comment"># use librosa to get example&#x27;s duration from the audio file</span>
new_column = [librosa.get_duration(path=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># use 🤗 Datasets&#x27; \`filter\` method to apply the filtering function</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># remove the temporary helper column</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`,wrap:!1}}),V=new y({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>',wrap:!1}}),Y=new ot({props:{title:"Pre-processing audio data",local:"pre-processing-audio-data",headingTag:"h2"}}),L=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),P=new y({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`,wrap:!1}}),K=new y({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`,wrap:!1}}),te=new y({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),le=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`,wrap:!1}}),re=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),me=new St({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter1/preprocessing.mdx"}}),{c(){c=i("meta"),f=l(),T=i("p"),he=l(),p(J.$$.fragment),de=l(),U=i("p"),U.textContent=pt,ce=l(),g=i("ul"),g.innerHTML=mt,ye=l(),p(b.$$.fragment),fe=l(),I=i("p"),I.innerHTML=Mt,we=l(),C=i("p"),C.textContent=ut,je=l(),A=i("p"),A.innerHTML=ht,Te=l(),p(x.$$.fragment),Je=l(),$=i("p"),$.innerHTML=dt,Ue=l(),p(v.$$.fragment),ge=l(),k=i("p"),k.innerHTML=ct,be=l(),p(_.$$.fragment),Ie=l(),B=i("p"),B.textContent=yt,Ce=l(),p(w.$$.fragment),Ae=l(),p(R.$$.fragment),xe=l(),Z=i("p"),Z.textContent=ft,$e=l(),G=i("p"),G.innerHTML=wt,ve=l(),p(W.$$.fragment),ke=l(),H=i("p"),H.textContent=jt,_e=l(),p(X.$$.fragment),Be=l(),N=i("p"),N.innerHTML=Tt,Re=l(),p(V.$$.fragment),Ze=l(),q=i("p"),q.textContent=Jt,Ge=l(),p(Y.$$.fragment),We=l(),z=i("p"),z.textContent=Ut,He=l(),E=i("p"),E.innerHTML=gt,Xe=l(),Q=i("p"),Q.textContent=bt,Ne=l(),F=i("p"),F.textContent=It,Ve=l(),S=i("p"),S.textContent=Ct,qe=l(),p(L.$$.fragment),Ye=l(),D=i("p"),D.innerHTML=At,ze=l(),p(P.$$.fragment),Ee=l(),O=i("p"),O.textContent=xt,Qe=l(),p(K.$$.fragment),Fe=l(),ee=i("p"),ee.innerHTML=$t,Se=l(),p(te.$$.fragment),Le=l(),ae=i("p"),ae.innerHTML=vt,De=l(),se=i("p"),se.innerHTML=kt,Pe=l(),p(le.$$.fragment),Oe=l(),j=i("div"),j.innerHTML=_t,Ke=l(),ne=i("p"),ne.textContent=Bt,et=l(),ie=i("p"),ie.innerHTML=Rt,tt=l(),oe=i("p"),oe.innerHTML=Zt,at=l(),p(re.$$.fragment),st=l(),pe=i("p"),pe.innerHTML=Gt,lt=l(),p(me.$$.fragment),nt=l(),Me=i("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),f=n(e),T=o(e,"P",{}),Ht(T).forEach(a),he=n(e),m(J.$$.fragment,e),de=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1b3xnqq"&&(U.textContent=pt),ce=n(e),g=o(e,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-1anvx2"&&(g.innerHTML=mt),ye=n(e),m(b.$$.fragment,e),fe=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-47dy14"&&(I.innerHTML=Mt),we=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1c2c4da"&&(C.textContent=ut),je=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-x7frc7"&&(A.innerHTML=ht),Te=n(e),m(x.$$.fragment,e),Je=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-96ugis"&&($.innerHTML=dt),Ue=n(e),m(v.$$.fragment,e),ge=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1mvdyro"&&(k.innerHTML=ct),be=n(e),m(_.$$.fragment,e),Ie=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-hnb1k"&&(B.textContent=yt),Ce=n(e),m(w.$$.fragment,e),Ae=n(e),m(R.$$.fragment,e),xe=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-s6y06a"&&(Z.textContent=ft),$e=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1szy3nk"&&(G.innerHTML=wt),ve=n(e),m(W.$$.fragment,e),ke=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1btp9dp"&&(H.textContent=jt),_e=n(e),m(X.$$.fragment,e),Be=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1mvdyro"&&(N.innerHTML=Tt),Re=n(e),m(V.$$.fragment,e),Ze=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ipsrxo"&&(q.textContent=Jt),Ge=n(e),m(Y.$$.fragment,e),We=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-jbw2e0"&&(z.textContent=Ut),He=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1jndbwe"&&(E.innerHTML=gt),Xe=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1y8nv8f"&&(Q.textContent=bt),Ne=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1ys9rww"&&(F.textContent=It),Ve=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-n9ngno"&&(S.textContent=Ct),qe=n(e),m(L.$$.fragment,e),Ye=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-kd1gw8"&&(D.innerHTML=At),ze=n(e),m(P.$$.fragment,e),Ee=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-6ixft2"&&(O.textContent=xt),Qe=n(e),m(K.$$.fragment,e),Fe=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1mvdyro"&&(ee.innerHTML=$t),Se=n(e),m(te.$$.fragment,e),Le=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-14djzfz"&&(ae.innerHTML=vt),De=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1478ups"&&(se.innerHTML=kt),Pe=n(e),m(le.$$.fragment,e),Oe=n(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-csckl"&&(j.innerHTML=_t),Ke=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-pj9vlt"&&(ne.textContent=Bt),et=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1x1eerf"&&(ie.innerHTML=Rt),tt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-ngi3x1"&&(oe.innerHTML=Zt),at=n(e),m(re.$$.fragment,e),st=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-gvmmsi"&&(pe.innerHTML=Gt),lt=n(e),m(me.$$.fragment,e),nt=n(e),Me=o(e,"P",{}),Ht(Me).forEach(a),this.h()},h(){rt(c,"name","hf:doc:metadata"),rt(c,"content",Pt),rt(j,"class","flex justify-center")},m(e,t){zt(document.head,c),s(e,f,t),s(e,T,t),s(e,he,t),M(J,e,t),s(e,de,t),s(e,U,t),s(e,ce,t),s(e,g,t),s(e,ye,t),M(b,e,t),s(e,fe,t),s(e,I,t),s(e,we,t),s(e,C,t),s(e,je,t),s(e,A,t),s(e,Te,t),M(x,e,t),s(e,Je,t),s(e,$,t),s(e,Ue,t),M(v,e,t),s(e,ge,t),s(e,k,t),s(e,be,t),M(_,e,t),s(e,Ie,t),s(e,B,t),s(e,Ce,t),M(w,e,t),s(e,Ae,t),M(R,e,t),s(e,xe,t),s(e,Z,t),s(e,$e,t),s(e,G,t),s(e,ve,t),M(W,e,t),s(e,ke,t),s(e,H,t),s(e,_e,t),M(X,e,t),s(e,Be,t),s(e,N,t),s(e,Re,t),M(V,e,t),s(e,Ze,t),s(e,q,t),s(e,Ge,t),M(Y,e,t),s(e,We,t),s(e,z,t),s(e,He,t),s(e,E,t),s(e,Xe,t),s(e,Q,t),s(e,Ne,t),s(e,F,t),s(e,Ve,t),s(e,S,t),s(e,qe,t),M(L,e,t),s(e,Ye,t),s(e,D,t),s(e,ze,t),M(P,e,t),s(e,Ee,t),s(e,O,t),s(e,Qe,t),M(K,e,t),s(e,Fe,t),s(e,ee,t),s(e,Se,t),M(te,e,t),s(e,Le,t),s(e,ae,t),s(e,De,t),s(e,se,t),s(e,Pe,t),M(le,e,t),s(e,Oe,t),s(e,j,t),s(e,Ke,t),s(e,ne,t),s(e,et,t),s(e,ie,t),s(e,tt,t),s(e,oe,t),s(e,at,t),M(re,e,t),s(e,st,t),s(e,pe,t),s(e,lt,t),M(me,e,t),s(e,nt,t),s(e,Me,t),it=!0},p(e,[t]){const Wt={};t&2&&(Wt.$$scope={dirty:t,ctx:e}),w.$set(Wt)},i(e){it||(u(J.$$.fragment,e),u(b.$$.fragment,e),u(x.$$.fragment,e),u(v.$$.fragment,e),u(_.$$.fragment,e),u(w.$$.fragment,e),u(R.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(me.$$.fragment,e),it=!0)},o(e){h(J.$$.fragment,e),h(b.$$.fragment,e),h(x.$$.fragment,e),h(v.$$.fragment,e),h(_.$$.fragment,e),h(w.$$.fragment,e),h(R.$$.fragment,e),h(W.$$.fragment,e),h(X.$$.fragment,e),h(V.$$.fragment,e),h(Y.$$.fragment,e),h(L.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(me.$$.fragment,e),it=!1},d(e){e&&(a(f),a(T),a(he),a(de),a(U),a(ce),a(g),a(ye),a(fe),a(I),a(we),a(C),a(je),a(A),a(Te),a(Je),a($),a(Ue),a(ge),a(k),a(be),a(Ie),a(B),a(Ce),a(Ae),a(xe),a(Z),a($e),a(G),a(ve),a(ke),a(H),a(_e),a(Be),a(N),a(Re),a(Ze),a(q),a(Ge),a(We),a(z),a(He),a(E),a(Xe),a(Q),a(Ne),a(F),a(Ve),a(S),a(qe),a(Ye),a(D),a(ze),a(Ee),a(O),a(Qe),a(Fe),a(ee),a(Se),a(Le),a(ae),a(De),a(se),a(Pe),a(Oe),a(j),a(Ke),a(ne),a(et),a(ie),a(tt),a(oe),a(at),a(st),a(pe),a(lt),a(nt),a(Me)),a(c),d(J,e),d(b,e),d(x,e),d(v,e),d(_,e),d(w,e),d(R,e),d(W,e),d(X,e),d(V,e),d(Y,e),d(L,e),d(P,e),d(K,e),d(te,e),d(le,e),d(re,e),d(me,e)}}}const Pt='{"title":"Preprocessing an audio dataset","local":"preprocessing-an-audio-dataset","sections":[{"title":"Resampling the audio data","local":"resampling-the-audio-data","sections":[],"depth":2},{"title":"Filtering the dataset","local":"filtering-the-dataset","sections":[],"depth":2},{"title":"Pre-processing audio data","local":"pre-processing-audio-data","sections":[],"depth":2}],"depth":1}';function Ot(ue){return Nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class la extends Vt{constructor(c){super(),qt(this,c,Ot,Dt,Xt,{})}}export{la as component};
