import{s as Qs,o as Ss,n as os}from"../chunks/scheduler.defa9a21.js";import{S as xs,i as Hs,g as c,s as t,r as y,A as Es,h as p,f as a,c as n,j as Fs,u as w,x as d,k as zs,l as $s,y as Ls,a as e,v as J,d as o,t as j,w as r}from"../chunks/index.fe795e71.js";import{T as Js}from"../chunks/Tip.179eb360.js";import{C as U}from"../chunks/CodeBlock.204b6c34.js";import{H as G,E as Ks}from"../chunks/getInferenceSnippets.5b03107e.js";function Ds(I){let M,h='In its current state, this code is not going to perform gradient accumulation efficiently due to a process called gradient synchronization. Read more about that in the <a href="../concept_guides/gradient_synchronization">Concepts tutorial</a>!';return{c(){M=c("p"),M.innerHTML=h},l(i){M=p(i,"P",{"data-svelte-h":!0}),d(M)!=="svelte-s0dec7"&&(M.innerHTML=h)},m(i,m){e(i,M,m)},p:os,d(i){i&&a(M)}}}function qs(I){let M,h=`Typically with gradient accumulation, you would need to adjust the number of steps to reflect the change in total batches you are
training on. Accelerate automagically does this for you by default. Behind the scenes we instantiate a <code>GradientAccumulationPlugin</code> configured to do this.`;return{c(){M=c("p"),M.innerHTML=h},l(i){M=p(i,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1jsd87o"&&(M.innerHTML=h)},m(i,m){e(i,M,m)},p:os,d(i){i&&a(M)}}}function Ps(I){let M,h='The <a href="/docs/accelerate/v1.8.0/en/package_reference/state#accelerate.state.GradientState">state.GradientState</a> is sync’d with the active dataloader being iterated upon. As such it assumes naively that when we have reached the end of the dataloader everything will sync and a step will be performed. To disable this, set <code>sync_with_dataloader</code> to be <code>False</code> in the <code>GradientAccumulationPlugin</code>:',i,m,u;return m=new U({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwR3JhZGllbnRBY2N1bXVsYXRpb25QbHVnaW4lMEElMEFwbHVnaW4lMjAlM0QlMjBHcmFkaWVudEFjY3VtdWxhdGlvblBsdWdpbihzeW5jX3dpdGhfZGF0YWxvYWRlciUzREZhbHNlKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoLi4uJTJDJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3BsdWdpbiUzRHBsdWdpbik=",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import GradientAccumulationPlugin

plugin = GradientAccumulationPlugin(<span class="hljs-attribute">sync_with_dataloader</span>=<span class="hljs-literal">False</span>)
accelerator = Accelerator(<span class="hljs-built_in">..</span>., <span class="hljs-attribute">gradient_accumulation_plugin</span>=plugin)`,wrap:!1}}),{c(){M=c("p"),M.innerHTML=h,i=t(),y(m.$$.fragment)},l(T){M=p(T,"P",{"data-svelte-h":!0}),d(M)!=="svelte-gav6sx"&&(M.innerHTML=h),i=n(T),w(m.$$.fragment,T)},m(T,b){e(T,M,b),e(T,i,b),J(m,T,b),u=!0},p:os,i(T){u||(o(m.$$.fragment,T),u=!0)},o(T){j(m.$$.fragment,T),u=!1},d(T){T&&(a(M),a(i)),r(m,T)}}}function Os(I){let M,h="It’s important that <strong>only one forward/backward</strong> should be done inside the context manager <code>with accelerator.accumulate(model)</code>.";return{c(){M=c("p"),M.innerHTML=h},l(i){M=p(i,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1kw2co7"&&(M.innerHTML=h)},m(i,m){e(i,M,m)},p:os,d(i){i&&a(M)}}}function la(I){let M,h,i,m,u,T,b,js=`Gradient accumulation is a technique where you can train on bigger batch sizes than
your machine would normally be able to fit into memory. This is done by accumulating gradients over
several batches, and only stepping the optimizer after a certain number of batches have been performed.`,ml,X,rs=`While technically standard gradient accumulation code would work fine in a distributed setup, it is not the most efficient
method for doing so and you may experience considerable slowdowns!`,hl,Y,ds=`In this tutorial you will see how to quickly setup gradient accumulation and perform it with the utilities provided in Accelerate,
which can total to adding just one new line of code!`,Ul,A,Ts="This example will use a very simplistic PyTorch training loop that performs gradient accumulation every two batches:",ul,_,bl,V,Il,R,ms="First the code shown earlier will be converted to utilize Accelerate without the special gradient accumulation helper:",Gl,g,Cl,C,Zl,k,Bl,N,hs=`All that is left now is to let Accelerate handle the gradient accumulation for us. To do so you should pass in a <code>gradient_accumulation_steps</code> parameter to <a href="/docs/accelerate/v1.8.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, dictating the number
of steps to perform before each call to <code>step()</code> and how to automatically adjust the loss during the call to <a href="/docs/accelerate/v1.8.0/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a>:`,Wl,v,fl,F,Us=`Alternatively, you can pass in a <code>gradient_accumulation_plugin</code> parameter to the <a href="/docs/accelerate/v1.8.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object’s <code>__init__</code>, which will allow you to further customize the gradient accumulation behavior.
Read more about that in the <a href="../package_reference/accelerator#accelerate.utils.GradientAccumulationPlugin">GradientAccumulationPlugin</a> docs.`,Xl,z,us=`From here you can use the <a href="/docs/accelerate/v1.8.0/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> context manager from inside your training loop to automatically perform the gradient accumulation for you!
You just wrap it around the entire training part of our code:`,Yl,Q,Al,S,bs="You can remove all the special checks for the step number and the loss adjustment:",_l,x,Vl,H,Is='As you can see the <a href="/docs/accelerate/v1.8.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is able to keep track of the batch number you are on and it will automatically know whether to step through the prepared optimizer and how to adjust the loss.',Rl,Z,gl,B,kl,E,Nl,$,Gs="Below is the finished implementation for performing gradient accumulation with Accelerate",vl,L,Fl,W,zl,K,Cs='To learn more about what magic this wraps around, read the <a href="../concept_guides/gradient_synchronization">Gradient Synchronization concept guide</a>',Ql,D,Sl,q,Zs="Here is a self-contained example that you can run to see gradient accumulation in action with Accelerate:",xl,P,Hl,O,El,ll,$l,sl,Bs='As was pointed out in this <a href="https://huggingface.co/blog/gradient_accumulation" rel="nofollow">blog-post</a>, which points out a common error that occurs when performing gradient accumulation on training samples of variable size:',Ll,al,Ws="<p>[…] for gradient accumulation across token-level tasks like causal LM training, the correct loss should be computed by the <strong>total loss across all batches in a gradient accumulation step</strong> divided by the <strong>total number of all non padding tokens in those batches</strong>. This is not the same as the average of the per-batch loss values.</p>",Kl,el,fs="In other words, some adjustements must be made on losses that operate on a token-level basis.",Dl,tl,ql,nl,Pl,Ml,Ol,cl,ls,pl,Xs="Results on a single device - gradient accumulation steps set to 1 and batch_size set to 8:",ss,il,as,yl,Ys="Results on a two devices set-up - gradient accumulation steps set to 2 and batch_size set to 4.",es,wl,ts,Jl,ns,ol,As='Please find a complete example script on a real world training run in the examples folder at the path <a href="https://github.com/huggingface/accelerate/blob/main/examples/by_feature/gradient_accumulation_for_autoregressive_models.py" rel="nofollow"><code>accelerate/examples/by_feature/gradient_accumulation_for_autoregressive_models.py</code></a>.',Ms,jl,_s="Running it on several training configurations with constant global batch size equal to 32 gives the following graph:",cs,f,Vs='<img src="https://huggingface.co/datasets/hf-audio/gradient_accumulation_example/resolve/main/training_losses.png"/>',ps,rl,Rs='Note that the training losses are exactly the same up to training step 20. The small deviation after this training step occurs at the very end of the first epoch, because, by <a href="https://huggingface.co/docs/accelerate/en/package_reference/torch_wrappers#accelerate.data_loader.prepare_data_loader.even_batches" rel="nofollow">default</a>, the dataloader duplicates the samples at the beginning of the dataset when the total batch size doesn’t exactly divide the dataset.',is,dl,ys,Tl,ws;return u=new G({props:{title:"Performing gradient accumulation with Accelerate",local:"performing-gradient-accumulation-with-accelerate",headingTag:"h1"}}),_=new U({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlMjAyJTBBJTBBZm9yJTIwaW5kZXglMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKHRyYWluaW5nX2RhdGFsb2FkZXIpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwaW5wdXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjB0YXJnZXRzJTIwJTNEJTIwdGFyZ2V0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMGlmJTIwKGluZGV4JTIwJTJCJTIwMSklMjAlMjUlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

gradient_accumulation_steps = <span class="hljs-number">2</span>

<span class="hljs-keyword">for</span> index, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(training_dataloader):
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss = loss / gradient_accumulation_steps
    loss.backward()
    <span class="hljs-keyword">if</span> (index + <span class="hljs-number">1</span>) % gradient_accumulation_steps == <span class="hljs-number">0</span>:
        optimizer.step()
        scheduler.step()
        optimizer.zero_grad()`,wrap:!1}}),V=new G({props:{title:"Converting it to Accelerate",local:"converting-it-to-accelerate",headingTag:"h2"}}),g=new U({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUyQiUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTJCJTIwJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBJTJCJTIwKSUwQSUwQSUyMCUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZSh0cmFpbmluZ19kYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQS0lMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbnB1dHMudG8oZGV2aWNlKSUwQS0lMjAlMjAlMjAlMjAlMjB0YXJnZXRzJTIwJTNEJTIwdGFyZ2V0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUwQSUyQiUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAoaW5kZXglMkIxKSUyMCUyNSUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
<span class="hljs-addition">+ accelerator = Accelerator()</span>

<span class="hljs-addition">+ model, optimizer, training_dataloader, scheduler = accelerator.prepare(</span>
<span class="hljs-addition">+     model, optimizer, training_dataloader, scheduler</span>
<span class="hljs-addition">+ )</span>

  for index, batch in enumerate(training_dataloader):
      inputs, targets = batch
<span class="hljs-deletion">-     inputs = inputs.to(device)</span>
<span class="hljs-deletion">-     targets = targets.to(device)</span>
      outputs = model(inputs)
      loss = loss_function(outputs, targets)
      loss = loss / gradient_accumulation_steps
<span class="hljs-addition">+     accelerator.backward(loss)</span>
      if (index+1) % gradient_accumulation_steps == 0:
          optimizer.step()
          scheduler.step()
          optimizer.zero_grad()`,wrap:!1}}),C=new Js({props:{warning:!0,$$slots:{default:[Ds]},$$scope:{ctx:I}}}),k=new G({props:{title:"Letting Accelerate handle gradient accumulation",local:"letting-accelerate-handle-gradient-accumulation",headingTag:"h2"}}),v=new U({props:{code:"JTIwJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQS0lMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEElMkIlMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIp",highlighted:`  from accelerate import Accelerator
<span class="hljs-deletion">- accelerator = Accelerator()</span>
<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_steps=2)</span>`,wrap:!1}}),Q=new U({props:{code:"LSUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZSh0cmFpbmluZ19kYXRhbG9hZGVyKSUzQSUwQSUyQiUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGFjY2VsZXJhdG9yLmFjY3VtdWxhdGUobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyk=",highlighted:`<span class="hljs-deletion">- for index, batch in enumerate(training_dataloader):</span>
<span class="hljs-addition">+ for batch in training_dataloader:</span>
<span class="hljs-addition">+     with accelerator.accumulate(model):</span>
          inputs, targets = batch
          outputs = model(inputs)`,wrap:!1}}),x=new U({props:{code:"LSUyMGxvc3MlMjAlM0QlMjBsb3NzJTIwJTJGJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTBBJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEEtJTIwaWYlMjAoaW5kZXglMkIxKSUyMCUyNSUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-deletion">- loss = loss / gradient_accumulation_steps</span>
  accelerator.backward(loss)
<span class="hljs-deletion">- if (index+1) % gradient_accumulation_steps == 0:</span>
  optimizer.step()
  scheduler.step()
  optimizer.zero_grad()`,wrap:!1}}),Z=new Js({props:{$$slots:{default:[qs]},$$scope:{ctx:I}}}),B=new Js({props:{warning:!0,$$slots:{default:[Ps]},$$scope:{ctx:I}}}),E=new G({props:{title:"The finished code",local:"the-finished-code",headingTag:"h2"}}),L=new U({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMiklMEFtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluaW5nX2RhdGFsb2FkZXIlMkMlMjBzY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUwQSklMEFmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjBhY2NlbGVyYXRvci5hY2N1bXVsYXRlKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerator = Accelerator(gradient_accumulation_steps=<span class="hljs-number">2</span>)
model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        inputs, targets = batch
        outputs = model(inputs)
        loss = loss_function(outputs, targets)
        accelerator.backward(loss)
        optimizer.step()
        scheduler.step()
        optimizer.zero_grad()`,wrap:!1}}),W=new Js({props:{warning:!0,$$slots:{default:[Os]},$$scope:{ctx:I}}}),D=new G({props:{title:"Self-contained example",local:"self-contained-example",headingTag:"h2"}}),P=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> copy
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> TensorDataset, DataLoader

<span class="hljs-comment"># seed</span>
set_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># define toy inputs and labels</span>
x = torch.tensor([<span class="hljs-number">1.</span>, <span class="hljs-number">2.</span>, <span class="hljs-number">3.</span>, <span class="hljs-number">4.</span>, <span class="hljs-number">5.</span>, <span class="hljs-number">6.</span>, <span class="hljs-number">7.</span>, <span class="hljs-number">8.</span>])
y = torch.tensor([<span class="hljs-number">2.</span>, <span class="hljs-number">4.</span>, <span class="hljs-number">6.</span>, <span class="hljs-number">8.</span>, <span class="hljs-number">10.</span>, <span class="hljs-number">12.</span>, <span class="hljs-number">14.</span>, <span class="hljs-number">16.</span>])
gradient_accumulation_steps = <span class="hljs-number">4</span>
per_device_batch_size = <span class="hljs-built_in">len</span>(x) // gradient_accumulation_steps

<span class="hljs-comment"># define dataset and dataloader</span>
dataset = TensorDataset(x, y)
dataloader = DataLoader(dataset, batch_size=per_device_batch_size)

<span class="hljs-comment"># define model, optimizer and loss function</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SimpleLinearModel</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>(SimpleLinearModel, self).__init__()
        self.weight = torch.nn.Parameter(torch.zeros((<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)))

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, inputs</span>):
        <span class="hljs-keyword">return</span> inputs @ self.weight

model = SimpleLinearModel()
model_clone = copy.deepcopy(model)
criterion = torch.nn.MSELoss()
model_optimizer = torch.optim.SGD(model.parameters(), lr=<span class="hljs-number">0.02</span>)
accelerator = Accelerator(gradient_accumulation_steps=gradient_accumulation_steps)
model, model_optimizer, dataloader = accelerator.prepare(model, model_optimizer, dataloader)
model_clone_optimizer = torch.optim.SGD(model_clone.parameters(), lr=<span class="hljs-number">0.02</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;initial model weight is <span class="hljs-subst">{model.weight.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;initial model weight is <span class="hljs-subst">{model_clone.weight.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-keyword">for</span> i, (inputs, labels) <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader):
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        inputs = inputs.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
        <span class="hljs-built_in">print</span>(i, inputs.flatten())
        labels = labels.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
        outputs = model(inputs)
        loss = criterion(outputs, labels)
        accelerator.backward(loss)
        model_optimizer.step()
        model_optimizer.zero_grad()
loss = criterion(x.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) @ model_clone.weight, y.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>))
model_clone_optimizer.zero_grad()
loss.backward()
model_clone_optimizer.step()
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;w/ accumulation, the final model weight is <span class="hljs-subst">{model.weight.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;w/o accumulation, the final model weight is <span class="hljs-subst">{model_clone.weight.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)`,wrap:!1}}),O=new U({props:{code:"aW5pdGlhbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAwLjAwMDAwJTBBaW5pdGlhbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAwLjAwMDAwJTBBMCUyMHRlbnNvciglNUIxLiUyQyUyMDIuJTVEKSUwQTElMjB0ZW5zb3IoJTVCMy4lMkMlMjA0LiU1RCklMEEyJTIwdGVuc29yKCU1QjUuJTJDJTIwNi4lNUQpJTBBMyUyMHRlbnNvciglNUI3LiUyQyUyMDguJTVEKSUwQXclMkYlMjBhY2N1bXVsYXRpb24lMkMlMjB0aGUlMjBmaW5hbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAyLjA0MDAwJTBBdyUyRm8lMjBhY2N1bXVsYXRpb24lMkMlMjB0aGUlMjBmaW5hbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAyLjA0MDAw",highlighted:`<span class="hljs-attribute">initial</span> model weight is <span class="hljs-number">0</span>.<span class="hljs-number">00000</span>
<span class="hljs-attribute">initial</span> model weight is <span class="hljs-number">0</span>.<span class="hljs-number">00000</span>
<span class="hljs-attribute">0</span> tensor([<span class="hljs-number">1</span>., <span class="hljs-number">2</span>.])
<span class="hljs-attribute">1</span> tensor([<span class="hljs-number">3</span>., <span class="hljs-number">4</span>.])
<span class="hljs-attribute">2</span> tensor([<span class="hljs-number">5</span>., <span class="hljs-number">6</span>.])
<span class="hljs-attribute">3</span> tensor([<span class="hljs-number">7</span>., <span class="hljs-number">8</span>.])
<span class="hljs-attribute">w</span>/ accumulation, the final model weight is <span class="hljs-number">2</span>.<span class="hljs-number">04000</span>
<span class="hljs-attribute">w</span>/o accumulation, the final model weight is <span class="hljs-number">2</span>.<span class="hljs-number">04000</span>`,wrap:!1}}),ll=new G({props:{title:"Gradient accumulation on training samples of variable size",local:"gradient-accumulation-on-training-samples-of-variable-size",headingTag:"h2"}}),tl=new G({props:{title:"Skeleton code",local:"skeleton-code",headingTag:"h3"}}),nl=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">import</span> contextlib

gradient_accumulation_steps = <span class="hljs-number">2</span>
accelerator = Accelerator(gradient_accumulation_steps=gradient_accumulation_steps)
model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)

training_iterator = <span class="hljs-built_in">iter</span>(training_dataloader)
num_samples_in_epoch = <span class="hljs-built_in">len</span>(training_dataloader)
remainder = num_samples_in_epoch % gradient_accumulation_steps
remainder = remainder <span class="hljs-keyword">if</span> remainder != <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> gradient_accumulation_steps
total_updates = math.ceil(num_samples_in_epoch / gradient_accumulation_steps)
        

total_batched_samples = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> update_step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(total_updates):
        <span class="hljs-comment"># In order to correctly the total number of non-padded tokens on which we&#x27;ll compute the cross-entropy loss</span>
        <span class="hljs-comment"># we need to pre-load the full local batch - i.e the next per_device_batch_size * accumulation_steps samples</span>
        batch_samples = []
        num_batches_in_step = gradient_accumulation_steps <span class="hljs-keyword">if</span> update_step != (total_updates - <span class="hljs-number">1</span>) <span class="hljs-keyword">else</span> remainder
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_batches_in_step):
            batch_samples += [<span class="hljs-built_in">next</span>(training_iterator)]
            
        <span class="hljs-comment"># get local num items in batch </span>
        num_items_in_batch = <span class="hljs-built_in">sum</span>([(batch[<span class="hljs-string">&quot;labels&quot;</span>].ne(-<span class="hljs-number">100</span>)).<span class="hljs-built_in">sum</span>() <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> batch_samples])
        <span class="hljs-comment"># to compute it correctly in a multi-device DDP training, we need to gather the total number of items in the full batch.</span>
        num_items_in_batch = accelerator.gather(num_items_in_batch).<span class="hljs-built_in">sum</span>().item()
            
        <span class="hljs-keyword">for</span> i, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(batch_samples):
            <span class="hljs-comment"># if we perform gradient accumulation in a multi-devices set-up, we want to avoid unecessary communications when accumulating</span>
            <span class="hljs-comment"># cf: https://muellerzr.github.io/blog/gradient_accumulation.html</span>
            <span class="hljs-keyword">if</span> (i &lt; <span class="hljs-built_in">len</span>(batch_samples) - <span class="hljs-number">1</span> <span class="hljs-keyword">and</span> accelerator.num_processes &gt; <span class="hljs-number">1</span>):
                ctx = model.no_sync
            <span class="hljs-keyword">else</span>:
                ctx = contextlib.nullcontext
            
            total_batched_samples += <span class="hljs-number">1</span>

            <span class="hljs-keyword">with</span> ctx():
                inputs, targets = batch
                outputs = model(inputs)
                loss = loss_function(outputs, targets) <span class="hljs-comment"># the loss function shoud sum over samples rather than averaging</span>
                
                <span class="hljs-comment"># We multiply by num_processes because the DDP calculates the average gradient across all devices whereas dividing by num_items_in_batch already takes into account all devices</span>
                <span class="hljs-comment"># Same reason for gradient_accumulation_steps, but this times it&#x27;s Accelerate that calculate the average gradient across the accumulated steps</span>
                loss = (loss * gradient_accumulation_steps * accelerator.num_processes) / num_items_in_batch
                
                accelerator.backward(loss)

        <span class="hljs-comment"># Sync gradients and perform optimization steps once every gradient_accumulation_steps</span>
        optimizer.step()
        scheduler.step()
        optimizer.zero_grad()`,wrap:!1}}),Ml=new G({props:{title:"Self-contained causal LM example",local:"self-contained-causal-lm-example",headingTag:"h3"}}),cl=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> copy
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed
<span class="hljs-keyword">from</span> accelerate.logging <span class="hljs-keyword">import</span>  get_logger
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> Dataset, DataLoader
<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">import</span> contexlib

<span class="hljs-comment"># seed</span>
set_seed(<span class="hljs-number">0</span>)
logger = get_logger(__name__)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyDataset</span>(<span class="hljs-title class_ inherited__">Dataset</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_samples</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.<span class="hljs-built_in">len</span> = num_samples

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, index</span>):
        input_ids = torch.arange(<span class="hljs-number">1</span>, index+<span class="hljs-number">2</span>, dtype=torch.float32)
        labels = torch.remainder(input_ids, <span class="hljs-number">2</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;input_ids&quot;</span>: input_ids, <span class="hljs-string">&quot;labels&quot;</span>: labels}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> self.<span class="hljs-built_in">len</span>
    
<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">features</span>):
    input_ids = torch.nn.utils.rnn.pad_sequence([f[<span class="hljs-string">&quot;input_ids&quot;</span>] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features], batch_first=<span class="hljs-literal">True</span>, padding_value=-<span class="hljs-number">100</span>)
    labels = torch.nn.utils.rnn.pad_sequence([f[<span class="hljs-string">&quot;labels&quot;</span>] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features], batch_first=<span class="hljs-literal">True</span>, padding_value=-<span class="hljs-number">100</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;input_ids&quot;</span>: input_ids[..., <span class="hljs-literal">None</span>], <span class="hljs-string">&quot;labels&quot;</span>: labels[..., <span class="hljs-literal">None</span>]}

<span class="hljs-comment"># define toy inputs and labels</span>
gradient_accumulation_steps = <span class="hljs-number">2</span>
per_device_batch_size = <span class="hljs-number">4</span>

<span class="hljs-comment"># define accelerator</span>
accelerator = Accelerator(gradient_accumulation_steps=gradient_accumulation_steps)

<span class="hljs-comment"># define dataset and dataloader</span>
<span class="hljs-comment"># for this toy example, we&#x27;ll compute gradient descent over one single global batch</span>
dataset = MyDataset(per_device_batch_size*gradient_accumulation_steps*accelerator.num_processes)
dataloader = DataLoader(dataset, batch_size=per_device_batch_size, collate_fn=collate_fn)

<span class="hljs-comment"># define model, model_optimizer and loss function</span>
model = torch.nn.Linear(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, bias=<span class="hljs-literal">False</span>)
model_clone = copy.deepcopy(model)
criterion = torch.nn.CrossEntropyLoss(reduction=<span class="hljs-string">&quot;sum&quot;</span>) <span class="hljs-comment"># must sum over samples rather than averaging</span>
model_optimizer = torch.optim.SGD(model.parameters(), lr=<span class="hljs-number">0.08</span>)


logger.warning(<span class="hljs-string">f&quot;initial model weight is <span class="hljs-subst">{model.weight.detach().cpu().squeeze()}</span>&quot;</span>)
logger.warning(<span class="hljs-string">f&quot;initial model clone weight is <span class="hljs-subst">{model_clone.weight.detach().cpu().squeeze()}</span>&quot;</span>)

<span class="hljs-comment"># prepare artifacts - accelerator handles device placement and dataloader splitting</span>
model, model_optimizer = accelerator.prepare(model, model_optimizer)
dataloader = accelerator.prepare_data_loader(dataloader, device_placement=<span class="hljs-literal">True</span>)
training_iterator = <span class="hljs-built_in">iter</span>(dataloader)

num_samples_in_epoch = <span class="hljs-built_in">len</span>(dataloader)
remainder = num_samples_in_epoch % gradient_accumulation_steps
remainder = remainder <span class="hljs-keyword">if</span> remainder != <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> gradient_accumulation_steps
total_gradient_updates = math.ceil(num_samples_in_epoch / gradient_accumulation_steps)

total_batched_samples = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> update_step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(total_gradient_updates):
        <span class="hljs-comment"># In order to correctly the total number of non-padded tokens on which we&#x27;ll compute the cross-entropy loss</span>
        <span class="hljs-comment"># we need to pre-load the full local batch - i.e the next per_device_batch_size * accumulation_steps samples</span>
        batch_samples = []
        num_batches_in_step = gradient_accumulation_steps <span class="hljs-keyword">if</span> update_step != (total_gradient_updates - <span class="hljs-number">1</span>) <span class="hljs-keyword">else</span> remainder
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_batches_in_step):
            batch_samples += [<span class="hljs-built_in">next</span>(training_iterator)]
            
        <span class="hljs-comment"># get local num items in batch </span>
        local_num_items_in_batch = <span class="hljs-built_in">sum</span>([(batch[<span class="hljs-string">&quot;labels&quot;</span>].ne(-<span class="hljs-number">100</span>)).<span class="hljs-built_in">sum</span>() <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> batch_samples])
        logger.warning(<span class="hljs-string">f&quot;Step <span class="hljs-subst">{update_step}</span> - Device <span class="hljs-subst">{accelerator.process_index}</span> - num items in the local batch <span class="hljs-subst">{local_num_items_in_batch}</span>&quot;</span>, main_process_only=<span class="hljs-literal">False</span>)

        <span class="hljs-comment"># to compute it correctly in a multi-device DDP training, we need to gather the total number of items in the full batch.</span>
        num_items_in_batch = accelerator.gather(local_num_items_in_batch).<span class="hljs-built_in">sum</span>().item()
        logger.warning(<span class="hljs-string">f&quot;Total num items <span class="hljs-subst">{num_items_in_batch}</span>&quot;</span>)

        <span class="hljs-keyword">for</span> i, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(batch_samples):
            inputs, labels = batch[<span class="hljs-string">&quot;input_ids&quot;</span>], batch[<span class="hljs-string">&quot;labels&quot;</span>]
            total_batched_samples += <span class="hljs-number">1</span>
            <span class="hljs-comment"># if we perform gradient accumulation in a multi-devices set-up, we want to avoid unecessary communications when accumulating</span>
            <span class="hljs-comment"># cf: https://muellerzr.github.io/blog/gradient_accumulation.html</span>
            <span class="hljs-keyword">if</span> (i &lt; <span class="hljs-built_in">len</span>(batch_samples) - <span class="hljs-number">1</span> <span class="hljs-keyword">and</span> accelerator.num_processes &gt; <span class="hljs-number">1</span>):
                ctx = model.no_sync
            <span class="hljs-keyword">else</span>:
                ctx = contextlib.nullcontext
            <span class="hljs-keyword">with</span> ctx():

                outputs = model(inputs)
                loss = criterion(outputs.view(-<span class="hljs-number">1</span>, <span class="hljs-number">2</span>), labels.view(-<span class="hljs-number">1</span>).to(torch.int64))
                
                <span class="hljs-comment"># We multiply by num_processes because the DDP calculates the average gradient across all devices whereas dividing by num_items_in_batch already takes into account all devices</span>
                <span class="hljs-comment"># Same reason for gradient_accumulation_steps, but this times it&#x27;s Accelerate that calculate the average gradient across the accumulated steps </span>
                loss = (loss * gradient_accumulation_steps * accelerator.num_processes) / num_items_in_batch
                accelerator.backward(loss)
        model_optimizer.step()
        model_optimizer.zero_grad()
                

logger.warning(<span class="hljs-string">f&quot;Device <span class="hljs-subst">{accelerator.process_index}</span> - w/ accumulation, the final model weight is <span class="hljs-subst">{accelerator.unwrap_model(model).weight.detach().cpu().squeeze()}</span>&quot;</span>, main_process_only=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># We know do the same operation but on a single device and without gradient accumulation</span>

<span class="hljs-keyword">if</span> accelerator.is_main_process:
    <span class="hljs-comment"># prepare one single entire batch</span>
    dataloader = DataLoader(dataset, batch_size=<span class="hljs-built_in">len</span>(dataset), collate_fn=collate_fn)
    full_batch_without_accum = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataloader))
    total_inputs, total_labels = full_batch_without_accum[<span class="hljs-string">&quot;input_ids&quot;</span>], full_batch_without_accum[<span class="hljs-string">&quot;labels&quot;</span>]
    model_clone_optimizer = torch.optim.SGD(model_clone.parameters(), lr=<span class="hljs-number">0.08</span>)
    
    <span class="hljs-comment"># train the cloned model</span>
    loss = torch.nn.CrossEntropyLoss(reduction=<span class="hljs-string">&quot;mean&quot;</span>)(model_clone(total_inputs).view(-<span class="hljs-number">1</span>, <span class="hljs-number">2</span>), total_labels.view(-<span class="hljs-number">1</span>).to(torch.int64))
    model_clone_optimizer.zero_grad()
    loss.backward()
    model_clone_optimizer.step()
    
    <span class="hljs-comment"># We should have the same final weights.</span>
    logger.warning(<span class="hljs-string">f&quot;w/o accumulation, the final model weight is <span class="hljs-subst">{model_clone.weight.detach().cpu().squeeze()}</span>&quot;</span>)
`,wrap:!1}}),il=new U({props:{code:"aW5pdGlhbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjB0ZW5zb3IoJTVCLTAuMDA3NSUyQyUyMCUyMDAuNTM2NCU1RCklMEFpbml0aWFsJTIwbW9kZWwlMjBjbG9uZSUyMHdlaWdodCUyMGlzJTIwdGVuc29yKCU1Qi0wLjAwNzUlMkMlMjAlMjAwLjUzNjQlNUQpJTBBU3RlcCUyMDAlMjAtJTIwRGV2aWNlJTIwMCUyMC0lMjBudW0lMjBpdGVtcyUyMGluJTIwdGhlJTIwbG9jYWwlMjBiYXRjaCUyMDM2JTBBVG90YWwlMjBudW0lMjBpdGVtcyUyMDM2JTBBRGV2aWNlJTIwMCUyMC0lMjB3JTJGJTIwYWNjdW11bGF0aW9uJTJDJTIwdGhlJTIwZmluYWwlMjBtb2RlbCUyMHdlaWdodCUyMGlzJTIwdGVuc29yKCU1QjAuMDk1MyUyQyUyMDAuNDMzNyU1RCklMEF3JTJGbyUyMGFjY3VtdWxhdGlvbiUyQyUyMHRoZSUyMGZpbmFsJTIwbW9kZWwlMjB3ZWlnaHQlMjBpcyUyMHRlbnNvciglNUIwLjA5NTMlMkMlMjAwLjQzMzclNUQp",highlighted:`<span class="hljs-attribute">initial</span> model weight is tensor([-<span class="hljs-number">0</span>.<span class="hljs-number">0075</span>,  <span class="hljs-number">0</span>.<span class="hljs-number">5364</span>])
<span class="hljs-attribute">initial</span> model clone weight is tensor([-<span class="hljs-number">0</span>.<span class="hljs-number">0075</span>,  <span class="hljs-number">0</span>.<span class="hljs-number">5364</span>])
<span class="hljs-attribute">Step</span> <span class="hljs-number">0</span> - Device <span class="hljs-number">0</span> - num items in the local batch <span class="hljs-number">36</span>
<span class="hljs-attribute">Total</span> num items <span class="hljs-number">36</span>
<span class="hljs-attribute">Device</span> <span class="hljs-number">0</span> - w/ accumulation, the final model weight is tensor([<span class="hljs-number">0</span>.<span class="hljs-number">0953</span>, <span class="hljs-number">0</span>.<span class="hljs-number">4337</span>])
<span class="hljs-attribute">w</span>/o accumulation, the final model weight is tensor([<span class="hljs-number">0</span>.<span class="hljs-number">0953</span>, <span class="hljs-number">0</span>.<span class="hljs-number">4337</span>])`,wrap:!1}}),wl=new U({props:{code:"aW5pdGlhbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjB0ZW5zb3IoJTVCLTAuMDA3NSUyQyUyMCUyMDAuNTM2NCU1RCklMEFpbml0aWFsJTIwbW9kZWwlMjBjbG9uZSUyMHdlaWdodCUyMGlzJTIwdGVuc29yKCU1Qi0wLjAwNzUlMkMlMjAlMjAwLjUzNjQlNUQpJTBBU3RlcCUyMDAlMjAtJTIwRGV2aWNlJTIwMCUyMC0lMjBudW0lMjBpdGVtcyUyMGluJTIwdGhlJTIwbG9jYWwlMjBiYXRjaCUyMDUyJTBBU3RlcCUyMDAlMjAtJTIwRGV2aWNlJTIwMSUyMC0lMjBudW0lMjBpdGVtcyUyMGluJTIwdGhlJTIwbG9jYWwlMjBiYXRjaCUyMDg0JTBBVG90YWwlMjBudW0lMjBpdGVtcyUyMDEzNiUwQURldmljZSUyMDElMjAtJTIwdyUyRiUyMGFjY3VtdWxhdGlvbiUyQyUyMHRoZSUyMGZpbmFsJTIwbW9kZWwlMjB3ZWlnaHQlMjBpcyUyMHRlbnNvciglNUIwLjIxMTclMkMlMjAwLjMxNzIlNUQpJTBBRGV2aWNlJTIwMCUyMC0lMjB3JTJGJTIwYWNjdW11bGF0aW9uJTJDJTIwdGhlJTIwZmluYWwlMjBtb2RlbCUyMHdlaWdodCUyMGlzJTIwdGVuc29yKCU1QjAuMjExNyUyQyUyMDAuMzE3MiU1RCklMEF3JTJGbyUyMGFjY3VtdWxhdGlvbiUyQyUyMHRoZSUyMGZpbmFsJTIwbW9kZWwlMjB3ZWlnaHQlMjBpcyUyMHRlbnNvciglNUIwLjIxMTclMkMlMjAwLjMxNzIlNUQp",highlighted:`<span class="hljs-attribute">initial</span> model weight is tensor([-<span class="hljs-number">0</span>.<span class="hljs-number">0075</span>,  <span class="hljs-number">0</span>.<span class="hljs-number">5364</span>])
<span class="hljs-attribute">initial</span> model clone weight is tensor([-<span class="hljs-number">0</span>.<span class="hljs-number">0075</span>,  <span class="hljs-number">0</span>.<span class="hljs-number">5364</span>])
<span class="hljs-attribute">Step</span> <span class="hljs-number">0</span> - Device <span class="hljs-number">0</span> - num items in the local batch <span class="hljs-number">52</span>
<span class="hljs-attribute">Step</span> <span class="hljs-number">0</span> - Device <span class="hljs-number">1</span> - num items in the local batch <span class="hljs-number">84</span>
<span class="hljs-attribute">Total</span> num items <span class="hljs-number">136</span>
<span class="hljs-attribute">Device</span> <span class="hljs-number">1</span> - w/ accumulation, the final model weight is tensor([<span class="hljs-number">0</span>.<span class="hljs-number">2117</span>, <span class="hljs-number">0</span>.<span class="hljs-number">3172</span>])
<span class="hljs-attribute">Device</span> <span class="hljs-number">0</span> - w/ accumulation, the final model weight is tensor([<span class="hljs-number">0</span>.<span class="hljs-number">2117</span>, <span class="hljs-number">0</span>.<span class="hljs-number">3172</span>])
<span class="hljs-attribute">w</span>/o accumulation, the final model weight is tensor([<span class="hljs-number">0</span>.<span class="hljs-number">2117</span>, <span class="hljs-number">0</span>.<span class="hljs-number">3172</span>])`,wrap:!1}}),Jl=new G({props:{title:"To go further:",local:"to-go-further",headingTag:"h3"}}),dl=new Ks({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/gradient_accumulation.md"}}),{c(){M=c("meta"),h=t(),i=c("p"),m=t(),y(u.$$.fragment),T=t(),b=c("p"),b.textContent=js,ml=t(),X=c("p"),X.textContent=rs,hl=t(),Y=c("p"),Y.textContent=ds,Ul=t(),A=c("p"),A.textContent=Ts,ul=t(),y(_.$$.fragment),bl=t(),y(V.$$.fragment),Il=t(),R=c("p"),R.textContent=ms,Gl=t(),y(g.$$.fragment),Cl=t(),y(C.$$.fragment),Zl=t(),y(k.$$.fragment),Bl=t(),N=c("p"),N.innerHTML=hs,Wl=t(),y(v.$$.fragment),fl=t(),F=c("p"),F.innerHTML=Us,Xl=t(),z=c("p"),z.innerHTML=us,Yl=t(),y(Q.$$.fragment),Al=t(),S=c("p"),S.textContent=bs,_l=t(),y(x.$$.fragment),Vl=t(),H=c("p"),H.innerHTML=Is,Rl=t(),y(Z.$$.fragment),gl=t(),y(B.$$.fragment),kl=t(),y(E.$$.fragment),Nl=t(),$=c("p"),$.textContent=Gs,vl=t(),y(L.$$.fragment),Fl=t(),y(W.$$.fragment),zl=t(),K=c("p"),K.innerHTML=Cs,Ql=t(),y(D.$$.fragment),Sl=t(),q=c("p"),q.textContent=Zs,xl=t(),y(P.$$.fragment),Hl=t(),y(O.$$.fragment),El=t(),y(ll.$$.fragment),$l=t(),sl=c("p"),sl.innerHTML=Bs,Ll=t(),al=c("blockquote"),al.innerHTML=Ws,Kl=t(),el=c("p"),el.textContent=fs,Dl=t(),y(tl.$$.fragment),ql=t(),y(nl.$$.fragment),Pl=t(),y(Ml.$$.fragment),Ol=t(),y(cl.$$.fragment),ls=t(),pl=c("p"),pl.textContent=Xs,ss=t(),y(il.$$.fragment),as=t(),yl=c("p"),yl.textContent=Ys,es=t(),y(wl.$$.fragment),ts=t(),y(Jl.$$.fragment),ns=t(),ol=c("p"),ol.innerHTML=As,Ms=t(),jl=c("p"),jl.textContent=_s,cs=t(),f=c("div"),f.innerHTML=Vs,ps=t(),rl=c("p"),rl.innerHTML=Rs,is=t(),y(dl.$$.fragment),ys=t(),Tl=c("p"),this.h()},l(l){const s=Es("svelte-u9bgzb",document.head);M=p(s,"META",{name:!0,content:!0}),s.forEach(a),h=n(l),i=p(l,"P",{}),Fs(i).forEach(a),m=n(l),w(u.$$.fragment,l),T=n(l),b=p(l,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1762c2w"&&(b.textContent=js),ml=n(l),X=p(l,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1u2vc4p"&&(X.textContent=rs),hl=n(l),Y=p(l,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-dgpyx1"&&(Y.textContent=ds),Ul=n(l),A=p(l,"P",{"data-svelte-h":!0}),d(A)!=="svelte-n9bxrd"&&(A.textContent=Ts),ul=n(l),w(_.$$.fragment,l),bl=n(l),w(V.$$.fragment,l),Il=n(l),R=p(l,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1cm6g3v"&&(R.textContent=ms),Gl=n(l),w(g.$$.fragment,l),Cl=n(l),w(C.$$.fragment,l),Zl=n(l),w(k.$$.fragment,l),Bl=n(l),N=p(l,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1vqf1ns"&&(N.innerHTML=hs),Wl=n(l),w(v.$$.fragment,l),fl=n(l),F=p(l,"P",{"data-svelte-h":!0}),d(F)!=="svelte-1l88uac"&&(F.innerHTML=Us),Xl=n(l),z=p(l,"P",{"data-svelte-h":!0}),d(z)!=="svelte-ewid6y"&&(z.innerHTML=us),Yl=n(l),w(Q.$$.fragment,l),Al=n(l),S=p(l,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1mcvl9w"&&(S.textContent=bs),_l=n(l),w(x.$$.fragment,l),Vl=n(l),H=p(l,"P",{"data-svelte-h":!0}),d(H)!=="svelte-1fd263y"&&(H.innerHTML=Is),Rl=n(l),w(Z.$$.fragment,l),gl=n(l),w(B.$$.fragment,l),kl=n(l),w(E.$$.fragment,l),Nl=n(l),$=p(l,"P",{"data-svelte-h":!0}),d($)!=="svelte-1ynctgg"&&($.textContent=Gs),vl=n(l),w(L.$$.fragment,l),Fl=n(l),w(W.$$.fragment,l),zl=n(l),K=p(l,"P",{"data-svelte-h":!0}),d(K)!=="svelte-aw0h59"&&(K.innerHTML=Cs),Ql=n(l),w(D.$$.fragment,l),Sl=n(l),q=p(l,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1e26tlz"&&(q.textContent=Zs),xl=n(l),w(P.$$.fragment,l),Hl=n(l),w(O.$$.fragment,l),El=n(l),w(ll.$$.fragment,l),$l=n(l),sl=p(l,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-yaf5ek"&&(sl.innerHTML=Bs),Ll=n(l),al=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),d(al)!=="svelte-1dpvjrf"&&(al.innerHTML=Ws),Kl=n(l),el=p(l,"P",{"data-svelte-h":!0}),d(el)!=="svelte-1lfkk1f"&&(el.textContent=fs),Dl=n(l),w(tl.$$.fragment,l),ql=n(l),w(nl.$$.fragment,l),Pl=n(l),w(Ml.$$.fragment,l),Ol=n(l),w(cl.$$.fragment,l),ls=n(l),pl=p(l,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-1oywi83"&&(pl.textContent=Xs),ss=n(l),w(il.$$.fragment,l),as=n(l),yl=p(l,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-1519q1p"&&(yl.textContent=Ys),es=n(l),w(wl.$$.fragment,l),ts=n(l),w(Jl.$$.fragment,l),ns=n(l),ol=p(l,"P",{"data-svelte-h":!0}),d(ol)!=="svelte-14ssh20"&&(ol.innerHTML=As),Ms=n(l),jl=p(l,"P",{"data-svelte-h":!0}),d(jl)!=="svelte-1mi0t6"&&(jl.textContent=_s),cs=n(l),f=p(l,"DIV",{style:!0,"data-svelte-h":!0}),d(f)!=="svelte-11tj8ly"&&(f.innerHTML=Vs),ps=n(l),rl=p(l,"P",{"data-svelte-h":!0}),d(rl)!=="svelte-vzj4yr"&&(rl.innerHTML=Rs),is=n(l),w(dl.$$.fragment,l),ys=n(l),Tl=p(l,"P",{}),Fs(Tl).forEach(a),this.h()},h(){zs(M,"name","hf:doc:metadata"),zs(M,"content",sa),$s(f,"text-align","center")},m(l,s){Ls(document.head,M),e(l,h,s),e(l,i,s),e(l,m,s),J(u,l,s),e(l,T,s),e(l,b,s),e(l,ml,s),e(l,X,s),e(l,hl,s),e(l,Y,s),e(l,Ul,s),e(l,A,s),e(l,ul,s),J(_,l,s),e(l,bl,s),J(V,l,s),e(l,Il,s),e(l,R,s),e(l,Gl,s),J(g,l,s),e(l,Cl,s),J(C,l,s),e(l,Zl,s),J(k,l,s),e(l,Bl,s),e(l,N,s),e(l,Wl,s),J(v,l,s),e(l,fl,s),e(l,F,s),e(l,Xl,s),e(l,z,s),e(l,Yl,s),J(Q,l,s),e(l,Al,s),e(l,S,s),e(l,_l,s),J(x,l,s),e(l,Vl,s),e(l,H,s),e(l,Rl,s),J(Z,l,s),e(l,gl,s),J(B,l,s),e(l,kl,s),J(E,l,s),e(l,Nl,s),e(l,$,s),e(l,vl,s),J(L,l,s),e(l,Fl,s),J(W,l,s),e(l,zl,s),e(l,K,s),e(l,Ql,s),J(D,l,s),e(l,Sl,s),e(l,q,s),e(l,xl,s),J(P,l,s),e(l,Hl,s),J(O,l,s),e(l,El,s),J(ll,l,s),e(l,$l,s),e(l,sl,s),e(l,Ll,s),e(l,al,s),e(l,Kl,s),e(l,el,s),e(l,Dl,s),J(tl,l,s),e(l,ql,s),J(nl,l,s),e(l,Pl,s),J(Ml,l,s),e(l,Ol,s),J(cl,l,s),e(l,ls,s),e(l,pl,s),e(l,ss,s),J(il,l,s),e(l,as,s),e(l,yl,s),e(l,es,s),J(wl,l,s),e(l,ts,s),J(Jl,l,s),e(l,ns,s),e(l,ol,s),e(l,Ms,s),e(l,jl,s),e(l,cs,s),e(l,f,s),e(l,ps,s),e(l,rl,s),e(l,is,s),J(dl,l,s),e(l,ys,s),e(l,Tl,s),ws=!0},p(l,[s]){const gs={};s&2&&(gs.$$scope={dirty:s,ctx:l}),C.$set(gs);const ks={};s&2&&(ks.$$scope={dirty:s,ctx:l}),Z.$set(ks);const Ns={};s&2&&(Ns.$$scope={dirty:s,ctx:l}),B.$set(Ns);const vs={};s&2&&(vs.$$scope={dirty:s,ctx:l}),W.$set(vs)},i(l){ws||(o(u.$$.fragment,l),o(_.$$.fragment,l),o(V.$$.fragment,l),o(g.$$.fragment,l),o(C.$$.fragment,l),o(k.$$.fragment,l),o(v.$$.fragment,l),o(Q.$$.fragment,l),o(x.$$.fragment,l),o(Z.$$.fragment,l),o(B.$$.fragment,l),o(E.$$.fragment,l),o(L.$$.fragment,l),o(W.$$.fragment,l),o(D.$$.fragment,l),o(P.$$.fragment,l),o(O.$$.fragment,l),o(ll.$$.fragment,l),o(tl.$$.fragment,l),o(nl.$$.fragment,l),o(Ml.$$.fragment,l),o(cl.$$.fragment,l),o(il.$$.fragment,l),o(wl.$$.fragment,l),o(Jl.$$.fragment,l),o(dl.$$.fragment,l),ws=!0)},o(l){j(u.$$.fragment,l),j(_.$$.fragment,l),j(V.$$.fragment,l),j(g.$$.fragment,l),j(C.$$.fragment,l),j(k.$$.fragment,l),j(v.$$.fragment,l),j(Q.$$.fragment,l),j(x.$$.fragment,l),j(Z.$$.fragment,l),j(B.$$.fragment,l),j(E.$$.fragment,l),j(L.$$.fragment,l),j(W.$$.fragment,l),j(D.$$.fragment,l),j(P.$$.fragment,l),j(O.$$.fragment,l),j(ll.$$.fragment,l),j(tl.$$.fragment,l),j(nl.$$.fragment,l),j(Ml.$$.fragment,l),j(cl.$$.fragment,l),j(il.$$.fragment,l),j(wl.$$.fragment,l),j(Jl.$$.fragment,l),j(dl.$$.fragment,l),ws=!1},d(l){l&&(a(h),a(i),a(m),a(T),a(b),a(ml),a(X),a(hl),a(Y),a(Ul),a(A),a(ul),a(bl),a(Il),a(R),a(Gl),a(Cl),a(Zl),a(Bl),a(N),a(Wl),a(fl),a(F),a(Xl),a(z),a(Yl),a(Al),a(S),a(_l),a(Vl),a(H),a(Rl),a(gl),a(kl),a(Nl),a($),a(vl),a(Fl),a(zl),a(K),a(Ql),a(Sl),a(q),a(xl),a(Hl),a(El),a($l),a(sl),a(Ll),a(al),a(Kl),a(el),a(Dl),a(ql),a(Pl),a(Ol),a(ls),a(pl),a(ss),a(as),a(yl),a(es),a(ts),a(ns),a(ol),a(Ms),a(jl),a(cs),a(f),a(ps),a(rl),a(is),a(ys),a(Tl)),a(M),r(u,l),r(_,l),r(V,l),r(g,l),r(C,l),r(k,l),r(v,l),r(Q,l),r(x,l),r(Z,l),r(B,l),r(E,l),r(L,l),r(W,l),r(D,l),r(P,l),r(O,l),r(ll,l),r(tl,l),r(nl,l),r(Ml,l),r(cl,l),r(il,l),r(wl,l),r(Jl,l),r(dl,l)}}}const sa='{"title":"Performing gradient accumulation with Accelerate","local":"performing-gradient-accumulation-with-accelerate","sections":[{"title":"Converting it to Accelerate","local":"converting-it-to-accelerate","sections":[],"depth":2},{"title":"Letting Accelerate handle gradient accumulation","local":"letting-accelerate-handle-gradient-accumulation","sections":[],"depth":2},{"title":"The finished code","local":"the-finished-code","sections":[],"depth":2},{"title":"Self-contained example","local":"self-contained-example","sections":[],"depth":2},{"title":"Gradient accumulation on training samples of variable size","local":"gradient-accumulation-on-training-samples-of-variable-size","sections":[{"title":"Skeleton code","local":"skeleton-code","sections":[],"depth":3},{"title":"Self-contained causal LM example","local":"self-contained-causal-lm-example","sections":[],"depth":3},{"title":"To go further:","local":"to-go-further","sections":[],"depth":3}],"depth":2}],"depth":1}';function aa(I){return Ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pa extends xs{constructor(M){super(),Hs(this,M,aa,la,Qs,{})}}export{pa as component};
