import{s as ni,o as Ti,n as pM}from"../chunks/scheduler.6062bdaf.js";import{S as ci,i as oi,g as i,s as M,r as c,A as Ji,h as n,f as t,c as s,j as ii,u as o,x as T,k as mM,y as di,a,v as J,d,t as U,w as h}from"../chunks/index.4bca734e.js";import{T as rM}from"../chunks/Tip.b9ac1f03.js";import{C as I}from"../chunks/CodeBlock.cbbddafc.js";import{H as j,E as Ui}from"../chunks/getInferenceSnippets.f1ebb0af.js";function hi(r){let y,f=`<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a> is the recommended way to store assets but is not mandatory. If
your library already uses its own cache, feel free to use it!`;return{c(){y=i("p"),y.innerHTML=f},l(w){y=n(w,"P",{"data-svelte-h":!0}),T(y)!=="svelte-1d1cydk"&&(y.innerHTML=f)},m(w,m){a(w,y,m)},p:pM,d(w){w&&t(y)}}}function yi(r){let y,f=`Revision hashes are unique across all repositories. This means you don’t need to
provide any <code>repo_id</code> or <code>repo_type</code> when removing revisions.`;return{c(){y=i("p"),y.innerHTML=f},l(w){y=n(w,"P",{"data-svelte-h":!0}),T(y)!=="svelte-pge9b4"&&(y.innerHTML=f)},m(w,m){a(w,y,m)},p:pM,d(w){w&&t(y)}}}function wi(r){let y,f=`If a revision is not found in the cache, it will be silently ignored. Besides, if a file
or folder cannot be found while trying to delete it, a warning will be logged but no
error is thrown. The deletion continues for other paths contained in the
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object.`;return{c(){y=i("p"),y.innerHTML=f},l(w){y=n(w,"P",{"data-svelte-h":!0}),T(y)!=="svelte-y56bqo"&&(y.innerHTML=f)},m(w,m){a(w,y,m)},p:pM,d(w){w&&t(y)}}}function Ii(r){let y,f,w,m,A,zl,g,CM="<code>huggingface_hub</code> utilizes the local disk as two caches, which avoid re-downloading items again. The first cache is a file-based cache, which caches individual files downloaded from the Hub and ensures that the same file is not downloaded again when a repo gets updated. The second cache is a chunk cache, where each chunk represents a byte range from a file and ensures that chunks that are shared across files are only downloaded once.",Hl,Z,Xl,k,uM=`The Hugging Face Hub cache-system is designed to be the central cache shared across libraries
that depend on the Hub. It has been updated in v0.8.0 to prevent re-downloading same files
between revisions.`,Pl,N,bM="The caching system is designed as follows:",ql,Y,Kl,G,AM="The default <code>&lt;CACHE_DIR&gt;</code> is <code>~/.cache/huggingface/hub</code>. However, it is customizable with the <code>cache_dir</code> argument on all methods, or by specifying either <code>HF_HOME</code> or <code>HF_HUB_CACHE</code> environment variable.",et,v,gM=`Models, datasets and spaces share a common root. Each of these repositories contains the
repository type, the namespace (organization or username) if it exists and the
repository name:`,lt,W,tt,L,ZM=`It is within these folders that all files will now be downloaded from the Hub. Caching ensures that
a file isn’t downloaded twice if it already exists and wasn’t updated; but if it was updated,
and you’re asking for the latest file, then it will download the latest file (while keeping
the previous file intact in case you need it again).`,at,R,kM="In order to achieve this, all folders contain the same skeleton:",Mt,S,st,x,NM="Each folder is designed to contain the following:",it,B,nt,Q,YM=`The <code>refs</code> folder contains files which indicates the latest revision of the given reference. For example,
if we have previously fetched a file from the <code>main</code> branch of a repository, the <code>refs</code>
folder will contain a file named <code>main</code>, which will itself contain the commit identifier of the current head.`,Tt,D,GM="If the latest commit of <code>main</code> has <code>aaaaaa</code> as identifier, then it will contain <code>aaaaaa</code>.",ct,F,vM=`If that same branch gets updated with a new commit, that has <code>bbbbbb</code> as an identifier, then
re-downloading a file from that reference will update the <code>refs/main</code> file to contain <code>bbbbbb</code>.`,ot,O,Jt,V,WM="The <code>blobs</code> folder contains the actual files that we have downloaded. The name of each file is their hash.",dt,$,Ut,E,LM=`The <code>snapshots</code> folder contains symlinks to the blobs mentioned above. It is itself made up of several folders:
one per known revision!`,ht,_,RM=`In the explanation above, we had initially fetched a file from the <code>aaaaaa</code> revision, before fetching a file from
the <code>bbbbbb</code> revision. In this situation, we would now have two folders in the <code>snapshots</code> folder: <code>aaaaaa</code>
and <code>bbbbbb</code>.`,yt,z,SM=`In each of these folders, live symlinks that have the names of the files that we have downloaded. For example,
if we had downloaded the <code>README.md</code> file at revision <code>aaaaaa</code>, we would have the following path:`,wt,H,It,X,xM="That <code>README.md</code> file is actually a symlink linking to the blob that has the hash of the file.",jt,P,BM=`By creating the skeleton this way we open the mechanism to file sharing: if the same file was fetched in
revision <code>bbbbbb</code>, it would have the same hash and the file would not need to be re-downloaded.`,ft,q,mt,K,QM=`In addition to the <code>blobs</code>, <code>refs</code> and <code>snapshots</code> folders, you might also find a <code>.no_exist</code> folder
in your cache. This folder keeps track of files that you’ve tried to download once but don’t exist
on the Hub. Its structure is the same as the <code>snapshots</code> folder with 1 subfolder per known revision:`,rt,ee,pt,le,DM=`Unlike the <code>snapshots</code> folder, files are simple empty files (no symlinks). In this example,
the file <code>&quot;config_that_does_not_exist.json&quot;</code> does not exist on the Hub for the revision <code>&quot;aaaaaa&quot;</code>.
As it only stores empty files, this folder is neglectable in term of disk usage.`,Ct,te,FM=`So now you might wonder, why is this information even relevant?
In some cases, a framework tries to load optional files for a model. Saving the non-existence
of optional files makes it faster to load a model as it saves 1 HTTP call per possible optional file.
This is for example the case in <code>transformers</code> where each tokenizer can support additional files.
The first time you load the tokenizer on your machine, it will cache which optional files exist (and
which doesn’t) to make the loading time faster for the next initializations.`,ut,ae,OM=`To test if a file is cached locally (without making any HTTP request), you can use the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.try_to_load_from_cache">try_to_load_from_cache()</a>
helper. It will either return the filepath (if exists and cached), the object <code>_CACHED_NO_EXIST</code> (if non-existence
is cached) or <code>None</code> (if we don’t know).`,bt,Me,At,se,gt,ie,VM="In practice, your cache should look like the following tree:",Zt,ne,kt,Te,Nt,ce,$M=`In order to have an efficient cache-system, <code>huggingface-hub</code> uses symlinks. However,
symlinks are not supported on all machines. This is a known limitation especially on
Windows. When this is the case, <code>huggingface_hub</code> do not use the <code>blobs/</code> directory but
directly stores the files in the <code>snapshots/</code> directory instead. This workaround allows
users to download and cache files from the Hub exactly the same way. Tools to inspect
and delete the cache (see below) are also supported. However, the cache-system is less
efficient as a single file might be downloaded several times if multiple revisions of
the same repo is downloaded.`,Yt,oe,EM=`If you want to benefit from the symlink-based cache-system on a Windows machine, you
either need to <a href="https://docs.microsoft.com/en-us/windows/apps/get-started/enable-your-device-for-development" rel="nofollow">activate Developer Mode</a>
or to run Python as an administrator.`,Gt,Je,_M=`When symlinks are not supported, a warning message is displayed to the user to alert
them they are using a degraded version of the cache-system. This warning can be disabled
by setting the <code>HF_HUB_DISABLE_SYMLINKS_WARNING</code> environment variable to true.`,vt,de,Wt,Ue,zM='To provide more efficient file transfers, <code>hf_xet</code> adds a <code>xet</code> directory to the existing <code>huggingface_hub</code> cache, creating additional caching layer to enable chunk-based deduplication. This cache holds chunks (immutable byte ranges of files ~64KB in size) and shards (a data structure that maps files to chunks). For more information on the Xet Storage system, see this <a href="https://huggingface.co/docs/hub/storage-backends" rel="nofollow">section</a>.',Lt,he,HM="The <code>xet</code> directory, located at <code>~/.cache/huggingface/xet</code> by default, contains two caches, utilized for uploads and downloads. It has the following structure:",Rt,ye,St,we,XM='The <code>environment_identifier</code> directory is an encoded string (it may appear on your machine as <code>https___cas_serv-tGqkUaZf_CBPHQ6h</code>). This is used during development allowing for local and production versions of the cache to exist alongside each other simultaneously. It is also used when downloading from repositories that reside in different <a href="https://huggingface.co/docs/hub/storage-regions" rel="nofollow">storage regions</a>. You may see multiple such entries in the <code>xet</code> directory, each corresponding to a different environment, but their internal structure is the same.',xt,Ie,PM="The internal directories serve the following purposes:",Bt,je,qM="<li><code>chunk-cache</code> contains cached data chunks that are used to speed up downloads.</li> <li><code>shard-cache</code> contains cached shards that are utilized on the upload path.</li> <li><code>staging</code> is a workspace designed to support resumable uploads.</li>",Qt,fe,KM="These are documented below.",Dt,me,es="Note that the <code>xet</code> caching system, like the rest of <code>hf_xet</code> is fully integrated with <code>huggingface_hub</code>.  If you use the existing APIs for interacting with cached assets, there is no need to update your workflow. The <code>xet</code> caches are built as an optimization layer on top of the existing <code>hf_xet</code> chunk-based deduplication and <code>huggingface_hub</code> cache system.",Ft,re,Ot,pe,ls="This cache is used on the download path. The cache directory structure is based on a base-64 encoded hash from the content-addressed store (CAS) that backs each Xet-enabled repository. A CAS hash serves as the key to lookup the offsets of where the data is stored.",Vt,Ce,ts="At the topmost level, the first two letters of the base 64 encoded CAS hash are used to create a subdirectory in the <code>chunk_cache</code> (keys that share these first two letters are grouped here).  The inner levels are comprised of subdirectories with the full key as the directory name. At the base are the cache items which are ranges of blocks that contain the cached chunks.",$t,ue,Et,be,as="When requesting a file, the first thing <code>hf_xet</code> does is communicate with Xet storage’s content addressed store (CAS) for reconstruction information. The reconstruction information contains information about the CAS keys required to download the file in its entirety.",_t,Ae,Ms="Before executing the requests for the CAS keys, the <code>chunk_cache</code> is consulted. If a key in the cache matches a CAS key, then there is no reason to issue a request for that content. <code>hf_xet</code> uses the chunks stored in the directory instead.",zt,ge,ss="As the <code>chunk_cache</code> is purely an optimization, not a guarantee, <code>hf_xet</code> utilizes a computationally efficient eviction policy. When the <code>chunk_cache</code> is full (see <code>Limits and Limitations</code> below), <code>hf_xet</code> implements a random eviction policy when selecting an eviction candidate. This significantly reduces the overhead of managing a robust caching system (e.g., LRU) while still providing most of the benefits of caching chunks.",Ht,Ze,Xt,ke,is="This cache is used when uploading content to the Hub. The directory is flat, comprising only of shard files, each using an ID for the shard name.",Pt,Ne,qt,Ye,ns="The <code>shard_cache</code> contains shards that are:",Kt,Ge,Ts="<li>Locally generated and successfully uploaded to the CAS</li> <li>Downloaded from CAS as part of the global deduplication algorithm</li>",ea,ve,cs="Shards provide a mapping between files and chunks. During uploads, each file is chunked and the hash of the chunk is saved. Every shard in the cache is then consulted. If a shard contains a chunk hash that is present in the local file being uploaded, then that chunk can be discarded as it is already stored in CAS.",la,We,os="All shards have an expiration date of 3-4 weeks from when they are downloaded. Shards that are expired are not loaded during upload and are deleted one week after expiration.",ta,Le,aa,Re,Js="When an upload terminates before the new content has been committed to the repository, you will need to resume the file transfer. However, it is possible that some chunks were successfully uploaded prior to the interruption.",Ma,Se,ds="So that you do not have to restart from the beginning, the <code>staging</code> directory acts as a workspace during uploads, storing metadata for successfully uploaded chunks. The <code>staging</code> directory has the following shape:",sa,xe,Us=`<CACHE_DIR>
├─ xet
│  ├─ staging
│  │  ├─ shard-session
│  │  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  │  ├─ xorb-metadata
│  │  │  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb`,ia,Be,hs="As files are processed and chunks successfully uploaded, their metadata is stored in <code>xorb-metadata</code> as a shard. Upon resuming an upload session, each file is processed again and the shards in this directory are consulted. Any content that was successfully uploaded is skipped, and any new content is uploaded (and its metadata saved).",na,Qe,ys="Meanwhile, <code>shard-session</code> stores file and chunk information for processed files. On successful completion of an upload, the content from these shards is moved to the more persistent <code>shard-cache</code>.",Ta,De,ca,Fe,ws="The <code>chunk_cache</code> is limited to 10GB in size while the <code>shard_cache</code> has a soft limit of 4GB.  By design, both caches are without high-level APIs, although their size is configurable through the <code>HF_XET_CHUNK_CACHE_SIZE_BYTES</code> and <code>HF_XET_SHARD_CACHE_SIZE_LIMIT</code> environment variables.",oa,Oe,Is='These caches are used primarily to facilitate the reconstruction (download) or upload of a file. To interact with the assets themselves, it’s recommended that you use the <a href="https://huggingface.co/docs/huggingface_hub/guides/manage-cache" rel="nofollow"><code>huggingface_hub</code> cache system APIs</a>.',Ja,Ve,js="If you need to reclaim the space utilized by either cache or need to debug any potential cache-related issues, simply remove the <code>xet</code> cache entirely by running <code>rm -rf ~/&lt;cache_dir&gt;/xet</code> where <code>&lt;cache_dir&gt;</code> is the location of your Hugging Face cache, typically <code>~/.cache/huggingface</code>",da,$e,fs="Example full <code>xet</code>cache directory tree:",Ua,Ee,ha,_e,ms='To learn more about Xet Storage, see this <a href="https://huggingface.co/docs/hub/storage-backends" rel="nofollow">section</a>.',ya,ze,wa,He,rs=`In addition to caching files from the Hub, downstream libraries often requires to cache
other files related to HF but not handled directly by <code>huggingface_hub</code> (example: file
downloaded from GitHub, preprocessed data, logs,…). In order to cache those files,
called <code>assets</code>, one can use <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a>. This small helper generates paths
in the HF cache in a unified way based on the name of the library requesting it and
optionally on a namespace and a subfolder name. The goal is to let every downstream
libraries manage its assets its own way (e.g. no rule on the structure) as long as it
stays in the right assets folder. Those libraries can then leverage tools from
<code>huggingface_hub</code> to manage the cache, in particular scanning and deleting parts of the
assets from a CLI command.`,Ia,Xe,ja,p,fa,Pe,ma,qe,ps="In practice, your assets cache should look like the following tree:",ra,Ke,pa,el,Ca,ll,ua,tl,Cs=`At the moment, cached files are never deleted from your local directory: when you download
a new revision of a branch, previous files are kept in case you need them again.
Therefore it can be useful to scan your cache directory in order to know which repos
and revisions are taking the most disk space. <code>huggingface_hub</code> provides an helper to
do so that can be used via <code>huggingface-cli</code> or in a python script.`,ba,al,us="<strong>Scan cache from the terminal</strong>",Aa,Ml,bs=`The easiest way to scan your HF cache-system is to use the <code>scan-cache</code> command from
<code>huggingface-cli</code> tool. This command scans the cache and prints a report with information
like repo id, repo type, disk usage, refs and full local path.`,ga,sl,As=`The snippet below shows a scan report in a folder in which 4 models and 2 datasets are
cached.`,Za,il,ka,nl,gs=`To get a more detailed report, use the <code>--verbose</code> option. For each repo, you get a
list of all revisions that have been downloaded. As explained above, the files that don’t
change between 2 revisions are shared thanks to the symlinks. This means that the size of
the repo on disk is expected to be less than the sum of the size of each of its revisions.
For example, here <code>bert-base-cased</code> has 2 revisions of 1.4G and 1.5G but the total disk
usage is only 1.9G.`,Na,Tl,Ya,cl,Zs="<strong>Grep example</strong>",Ga,ol,ks=`Since the output is in tabular format, you can combine it with any <code>grep</code>-like tools to
filter the entries. Here is an example to filter only revisions from the “t5-small”
model on a Unix-based machine.`,va,Jl,Wa,dl,Ns="<strong>Scan cache from Python</strong>",La,Ul,Ys=`For a more advanced usage, use <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a> which is the python utility called by
the CLI tool.`,Ra,hl,Gs="You can use it to get a detailed report structured around 4 dataclasses:",Sa,yl,vs='<li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a>: complete report returned by <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a></li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedRepoInfo">CachedRepoInfo</a>: information about a cached repo</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedRevisionInfo">CachedRevisionInfo</a>: information about a cached revision (e.g. “snapshot”) inside a repo</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedFileInfo">CachedFileInfo</a>: information about a cached file in a snapshot</li>',xa,wl,Ws="Here is a simple usage example. See reference for details.",Ba,Il,Qa,jl,Da,fl,Ls=`Scanning your cache is interesting but what you really want to do next is usually to
delete some portions to free up some space on your drive. This is possible using the
<code>delete-cache</code> CLI command. One can also programmatically use the
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> helper from <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a> object returned when
scanning the cache.`,Fa,ml,Rs="<strong>Delete strategy</strong>",Oa,rl,Ss=`To delete some cache, you need to pass a list of revisions to delete. The tool will
define a strategy to free up the space based on this list. It returns a
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object that describes which files and folders will be deleted.
The <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> allows give you how much space is expected to be freed.
Once you agree with the deletion, you must execute it to make the deletion effective. In
order to avoid discrepancies, you cannot edit a strategy object manually.`,Va,pl,xs="The strategy to delete revisions is the following:",$a,Cl,Bs="<li>the <code>snapshot</code> folder containing the revision symlinks is deleted.</li> <li>blobs files that are targeted only by revisions to be deleted are deleted as well.</li> <li>if a revision is linked to 1 or more <code>refs</code>, references are deleted.</li> <li>if all revisions from a repo are deleted, the entire cached repository is deleted.</li>",Ea,C,_a,u,za,ul,Qs="<strong>Clean cache from the terminal</strong>",Ha,bl,Ds=`The easiest way to delete some revisions from your HF cache-system is to use the
<code>delete-cache</code> command from <code>huggingface-cli</code> tool. The command has two modes. By
default, a TUI (Terminal User Interface) is displayed to the user to select which
revisions to delete. This TUI is currently in beta as it has not been tested on all
platforms. If the TUI doesn’t work on your machine, you can disable it using the
<code>--disable-tui</code> flag.`,Xa,Al,Fs="<strong>Using the TUI</strong>",Pa,gl,Os=`This is the default mode. To use it, you first need to install extra dependencies by
running the following command:`,qa,Zl,Ka,kl,Vs="Then run the command:",eM,Nl,lM,Yl,$s="You should now see a list of revisions that you can select/deselect:",tM,b,Es='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/delete-cache-tui.png"/>',aM,Gl,_s="Instructions:",MM,vl,zs=`<li>Press keyboard arrow keys <code>&lt;up&gt;</code> and <code>&lt;down&gt;</code> to move the cursor.</li> <li>Press <code>&lt;space&gt;</code> to toggle (select/unselect) an item.</li> <li>When a revision is selected, the first line is updated to show you how much space
will be freed.</li> <li>Press <code>&lt;enter&gt;</code> to confirm your selection.</li> <li>If you want to cancel the operation and quit, you can select the first item
(“None of the following”). If this item is selected, the delete process will be
cancelled, no matter what other items are selected. Otherwise you can also press
<code>&lt;ctrl+c&gt;</code> to quit the TUI.</li>`,sM,Wl,Hs=`Once you’ve selected the revisions you want to delete and pressed <code>&lt;enter&gt;</code>, a last
confirmation message will be prompted. Press <code>&lt;enter&gt;</code> again and the deletion will be
effective. If you want to cancel, enter <code>n</code>.`,iM,Ll,nM,Rl,Xs="<strong>Without TUI</strong>",TM,Sl,Ps=`As mentioned above, the TUI mode is currently in beta and is optional. It may be the
case that it doesn’t work on your machine or that you don’t find it convenient.`,cM,xl,qs=`Another approach is to use the <code>--disable-tui</code> flag. The process is very similar as you
will be asked to manually review the list of revisions to delete. However, this manual
step will not take place in the terminal directly but in a temporary file generated on
the fly and that you can manually edit.`,oM,Bl,Ks=`This file has all the instructions you need in the header. Open it in your favorite text
editor. To select/deselect a revision, simply comment/uncomment it with a <code>#</code>. Once the
manual review is done and the file is edited, you can save it. Go back to your terminal
and press <code>&lt;enter&gt;</code>. By default it will compute how much space would be freed with the
updated list of revisions. You can continue to edit the file or confirm with <code>&quot;y&quot;</code>.`,JM,Ql,dM,Dl,ei="Example of command file:",UM,Fl,hM,Ol,li="<strong>Clean cache from Python</strong>",yM,Vl,ti=`For more flexibility, you can also use the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> method
programmatically. Here is a simple example. See reference for details.`,wM,$l,IM,El,jM,_l,fM;return A=new j({props:{title:"Understand caching",local:"understand-caching",headingTag:"h1"}}),Z=new j({props:{title:"File-based caching",local:"file-based-caching",headingTag:"h2"}}),Y=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDTU9ERUxTJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDREFUQVNFVFMlM0UlMEElRTIlOTQlOUMlRTIlOTQlODAlMjAlM0NTUEFDRVMlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">CACHE_DIR</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">MODELS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">DATASETS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">SPACES</span>&gt;</span>`,wrap:!1}}),W=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwbW9kZWxzLS1qdWxpZW4tYy0tRXNwZXJCRVJUby1zbWFsbCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tbHlzYW5kcmVqaWstLWFyeGl2LW5scCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tYmVydC1iYXNlLWNhc2VkJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlOUMlRTIlOTQlODAlMjBkYXRhc2V0cy0taHVnZ2luZ2ZhY2UtLURhdGFNZWFzdXJlbWVudHNGaWxlcyUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMHNwYWNlcy0tZGFsbGUtbWluaS0tZGFsbGUtbWluaQ==",highlighted:`&lt;<span class="hljs-comment">CACHE_DIR</span>&gt;
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">julien</span><span class="hljs-literal">-</span><span class="hljs-comment">c</span><span class="hljs-literal">--</span><span class="hljs-comment">EsperBERTo</span><span class="hljs-literal">-</span><span class="hljs-comment">small</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">lysandrejik</span><span class="hljs-literal">--</span><span class="hljs-comment">arxiv</span><span class="hljs-literal">-</span><span class="hljs-comment">nlp</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">bert</span><span class="hljs-literal">-</span><span class="hljs-comment">base</span><span class="hljs-literal">-</span><span class="hljs-comment">cased</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">glue</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">huggingface</span><span class="hljs-literal">--</span><span class="hljs-comment">DataMeasurementsFiles</span>
<span class="hljs-comment">├─ spaces</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span>`,wrap:!1}}),S=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjByZWZzJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwYmxvYnMlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzbmFwc2hvdHMlMEEuLi4=",highlighted:`&lt;CACHE_DIR&gt;
├─ datasets<span class="hljs-params">--glue</span>
│  ├─ refs
│  ├─ blobs
│  ├─ snapshots
<span class="hljs-string">...</span>`,wrap:!1}}),B=new j({props:{title:"Refs",local:"refs",headingTag:"h3"}}),O=new j({props:{title:"Blobs",local:"blobs",headingTag:"h3"}}),$=new j({props:{title:"Snapshots",local:"snapshots",headingTag:"h3"}}),H=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGc25hcHNob3RzJTJGYWFhYWFhJTJGUkVBRE1FLm1k",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>snapshots<span class="hljs-regexp">/aaaaaa/</span>README.md',wrap:!1}}),q=new j({props:{title:".no_exist (advanced)",local:"noexist-advanced",headingTag:"h3"}}),ee=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGLm5vX2V4aXN0JTJGYWFhYWFhJTJGY29uZmlnX3RoYXRfZG9lc19ub3RfZXhpc3QuanNvbg==",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>.no_exist<span class="hljs-regexp">/aaaaaa/</span>config_that_does_not_exist.json',wrap:!1}}),Me=new I({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHRyeV90b19sb2FkX2Zyb21fY2FjaGUlMkMlMjBfQ0FDSEVEX05PX0VYSVNUJTBBJTBBZmlsZXBhdGglMjAlM0QlMjB0cnlfdG9fbG9hZF9mcm9tX2NhY2hlKCklMEFpZiUyMGlzaW5zdGFuY2UoZmlsZXBhdGglMkMlMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwZmlsZSUyMGV4aXN0cyUyMGFuZCUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxpZiUyMGZpbGVwYXRoJTIwaXMlMjBfQ0FDSEVEX05PX0VYSVNUJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbm9uLWV4aXN0ZW5jZSUyMG9mJTIwZmlsZSUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGZpbGUlMjBpcyUyMG5vdCUyMGNhY2hlZCUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> try_to_load_from_cache, _CACHED_NO_EXIST

filepath = try_to_load_from_cache()
<span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(filepath, <span class="hljs-built_in">str</span>):
    <span class="hljs-comment"># file exists and is cached</span>
    ...
<span class="hljs-keyword">elif</span> filepath <span class="hljs-keyword">is</span> _CACHED_NO_EXIST:
    <span class="hljs-comment"># non-existence of file is cached</span>
    ...
<span class="hljs-keyword">else</span>:
    <span class="hljs-comment"># file is not cached</span>
    ...`,wrap:!1}}),se=new j({props:{title:"In practice",local:"in-practice",headingTag:"h3"}}),ne=new I({props:{code:"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",highlighted:`    [  96]  .
    └── [ 160]  models--julien-c--EsperBERTo-small
        ├── [ 160]  blobs
        │   ├── [321M]  403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        │   ├── [ 398]  7cb18dc9bafbfcf74629a4b760af1b160957a83e
        │   └── [1.4K]  d7edf6bd2a681fb0175f7735299831ee1b22b812
        ├── [  96]  refs
        │   └── [  40]  main
        └── [ 128]  snapshots
            ├── [ 128]  2439f60ef33a0d46d85da5001d52aeda5b00ce9f
            │   ├── [  52]  README.md -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
            │   └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
            └── [ 128]  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
                ├── [  52]  README.md -&gt; ../../blobs/7cb18dc9bafbfcf74629a4b760af1b160957a83e
                └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),Te=new j({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),de=new j({props:{title:"Chunk-based caching (Xet)",local:"chunk-based-caching-xet",headingTag:"h2"}}),ye=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwZW52aXJvbm1lbnRfaWRlbnRpZmllciUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMGNodW5rX2NhY2hlJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc2hhcmRfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzdGFnaW5n",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ environment_identifier
│  │  ├─ chunk_cache
│  │  ├─ shard_cache
│  │  ├─ staging`,wrap:!1}}),re=new j({props:{title:"chunk_cache",local:"chunkcache",headingTag:"h3"}}),ue=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2h1bmtfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBMSUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMEExR2VyVVJMVWNJU1ZpdmRzZWVvWTFQbllpZllrT2FDQ0o3VjVROWZqZ3hrWldaaGRXeDAlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBQUFBQUFFQUFBQTVEUUFBQUFBQUFJaFJMakRJM1NTNWpZczR5c05LWmlKeTlYRkk4Q043V3cwVXlFQTlLUEQ5JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwQVFBQUFBSUFBQUJ6bmdBQUFBQUFBUE5xUGpkNVpieTVhQnZhYkY3WjFpdEN4MHJ5TXdvQ251UWNEd3E3OWpsQiUwQQ==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ chunk_cache
│  │  ├─ A1
│  │  │  ├─ A1GerURLUcISVivdseeoY1PnYifYkOaCCJ7V5Q9fjgxkZWZhdWx0
│  │  │  │  ├─ AAAAAAEAAAA5DQAAAAAAAIhRLjDI3SS5jYs4ysNKZiJy9XFI8CN7Ww0UyEA9KPD9
│  │  │  │  ├─ AQAAAAIAAABzngAAAAAAAPNqPjd5Zby5aBvabF7Z1itCx0ryMwoCnuQcDwq79jlB
`,wrap:!1}}),Ze=new j({props:{title:"shard_cache",local:"shardcache",headingTag:"h3"}}),Ne=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc2hhcmRfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjAxZmU0ZmZkNWNmMGMzMzc1ZjFlZjlhZWM1MDE2Y2Y3NzNjY2M1Y2EyOTQyOTNkM2Y5MmQ5Mjc3MWRhY2ZjMTVkLm1kYiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMDkwNmVlMTg0ZGMxY2QwNjE1MTY0YTg5ZWQ2NGU4MTQ3YjNmZGNjZDExNjNkODBkNzk0YzY2ODE0YjNiMDk5OTIubWRiJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2VlZWI3ZWE0Y2Y2YzBhOGQzOTVhMmNmOWMwODg3MTIxMWZiYmQxN2I5YjVkYzEwMDU4MTE4NDUzMDdlNmI4Zi5tZGIlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBlODUzNTE1NWIxYjExZWJkODk0YzkwOGU5MWExZTE0ZTM0NjFkZGRkMTM5MjY5NWRkYzkwYWU1NGE1NDhkOGIyLm1kYg==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ shard_cache
│  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb
│  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  ├─ ceeeb7ea4cf6c0a8d395a2cf9c08871211fbbd17b9b5dc1005811845307e6b8f.mdb
│  │  ├─ e8535155b1b11ebd894c908e91a1e14e3461dddd1392695ddc90ae54a548d8b2.mdb`,wrap:!1}}),Le=new j({props:{title:"staging",local:"staging",headingTag:"h3"}}),De=new j({props:{title:"Limits and Limitations",local:"limits-and-limitations",headingTag:"h3"}}),Ee=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2h1bmtfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBMMSUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMEwxR2VyVVJMVWNJU1ZpdmRzZWVvWTFQbllpZllrT2FDQ0o3VjVROWZqZ3hrWldaaGRXeDAlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBQUFBQUFFQUFBQTVEUUFBQUFBQUFJaFJMakRJM1NTNWpZczR5c05LWmlKeTlYRkk4Q043V3cwVXlFQTlLUEQ5JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwQVFBQUFBSUFBQUJ6bmdBQUFBQUFBUE5xUGpkNVpieTVhQnZhYkY3WjFpdEN4MHJ5TXdvQ251UWNEd3E3OWpsQiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMHNoYXJkX2NhY2hlJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwMWZlNGZmZDVjZjBjMzM3NWYxZWY5YWVjNTAxNmNmNzczY2NjNWNhMjk0MjkzZDNmOTJkOTI3NzFkYWNmYzE1ZC5tZGIlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjA5MDZlZTE4NGRjMWNkMDYxNTE2NGE4OWVkNjRlODE0N2IzZmRjY2QxMTYzZDgwZDc5NGM2NjgxNGIzYjA5OTkyLm1kYiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMGNlZWViN2VhNGNmNmMwYThkMzk1YTJjZjljMDg4NzEyMTFmYmJkMTdiOWI1ZGMxMDA1ODExODQ1MzA3ZTZiOGYubWRiJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwZTg1MzUxNTViMWIxMWViZDg5NGM5MDhlOTFhMWUxNGUzNDYxZGRkZDEzOTI2OTVkZGM5MGFlNTRhNTQ4ZDhiMi5tZGIlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzdGFnaW5nJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc2hhcmQtc2Vzc2lvbiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMDkwNmVlMTg0ZGMxY2QwNjE1MTY0YTg5ZWQ2NGU4MTQ3YjNmZGNjZDExNjNkODBkNzk0YzY2ODE0YjNiMDk5OTIubWRiJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIweG9yYi1tZXRhZGF0YSUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMDFmZTRmZmQ1Y2YwYzMzNzVmMWVmOWFlYzUwMTZjZjc3M2NjYzVjYTI5NDI5M2QzZjkyZDkyNzcxZGFjZmMxNWQubWRi",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ chunk_cache
│  │  ├─ L1
│  │  │  ├─ L1GerURLUcISVivdseeoY1PnYifYkOaCCJ7V5Q9fjgxkZWZhdWx0
│  │  │  │  ├─ AAAAAAEAAAA5DQAAAAAAAIhRLjDI3SS5jYs4ysNKZiJy9XFI8CN7Ww0UyEA9KPD9
│  │  │  │  ├─ AQAAAAIAAABzngAAAAAAAPNqPjd5Zby5aBvabF7Z1itCx0ryMwoCnuQcDwq79jlB
│  ├─ shard_cache
│  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb
│  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  ├─ ceeeb7ea4cf6c0a8d395a2cf9c08871211fbbd17b9b5dc1005811845307e6b8f.mdb
│  │  ├─ e8535155b1b11ebd894c908e91a1e14e3461dddd1392695ddc90ae54a548d8b2.mdb
│  ├─ staging
│  │  ├─ shard-session
│  │  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  │  ├─ xorb-metadata
│  │  │  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb`,wrap:!1}}),ze=new j({props:{title:"Caching assets",local:"caching-assets",headingTag:"h2"}}),Xe=new I({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNhY2hlZF9hc3NldHNfcGF0aCUwQSUwQWFzc2V0c19wYXRoJTIwJTNEJTIwY2FjaGVkX2Fzc2V0c19wYXRoKGxpYnJhcnlfbmFtZSUzRCUyMmRhdGFzZXRzJTIyJTJDJTIwbmFtZXNwYWNlJTNEJTIyU1F1QUQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJkb3dubG9hZCUyMiklMEFzb21ldGhpbmdfcGF0aCUyMCUzRCUyMGFzc2V0c19wYXRoJTIwJTJGJTIwJTIyc29tZXRoaW5nLmpzb24lMjIlMjAlMjMlMjBEbyUyMGFueXRoaW5nJTIweW91JTIwbGlrZSUyMGluJTIweW91ciUyMGFzc2V0cyUyMGZvbGRlciUyMCE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cached_assets_path

assets_path = cached_assets_path(library_name=<span class="hljs-string">&quot;datasets&quot;</span>, namespace=<span class="hljs-string">&quot;SQuAD&quot;</span>, subfolder=<span class="hljs-string">&quot;download&quot;</span>)
something_path = assets_path / <span class="hljs-string">&quot;something.json&quot;</span> <span class="hljs-comment"># Do anything you like in your assets folder !</span>`,wrap:!1}}),p=new rM({props:{$$slots:{default:[hi]},$$scope:{ctx:r}}}),Pe=new j({props:{title:"Assets in practice",local:"assets-in-practice",headingTag:"h3"}}),Ke=new I({props:{code:"JTIwJTIwJTIwJTIwYXNzZXRzJTJGJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwZGF0YXNldHMlMkYlMEElMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBTUXVBRCUyRiUwQSUyMCUyMCUyMCUyMCVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGRvd25sb2FkZWQlMkYlMEElMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBleHRyYWN0ZWQlMkYlMEElMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBwcm9jZXNzZWQlMkYlMEElMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBIZWxzaW5raS1OTFAtLXRhdG9lYmFfbXQlMkYlMEElMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBkb3dubG9hZGVkJTJGJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZXh0cmFjdGVkJTJGJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcHJvY2Vzc2VkJTJGJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwdHJhbnNmb3JtZXJzJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGVmYXVsdCUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHNvbWV0aGluZyUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGJlcnQtYmFzZS1jYXNlZCUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGRlZmF1bHQlMkYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjB0cmFpbmluZyUyRiUwQSUyMCUyMCUyMCUyMGh1YiUyRiUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMG1vZGVscy0tanVsaWVuLWMtLUVzcGVyQkVSVG8tc21hbGwlMkYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBibG9icyUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMCguLi4pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwKC4uLiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjByZWZzJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwKC4uLiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjAlNUIlMjAxMjglNUQlMjAlMjBzbmFwc2hvdHMlMkYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjAyNDM5ZjYwZWYzM2EwZDQ2ZDg1ZGE1MDAxZDUyYWVkYTViMDBjZTlmJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwKC4uLiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBiYmM3N2M4MTMyYWYxY2M1Y2Y2NzhkYTNmMWRkZjJkZTQzNjA2ZDQ4JTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwKC4uLik=",highlighted:`    assets/
    └── datasets/
    │   ├── SQuAD/
    │   │   ├── downloaded/
    │   │   ├── extracted/
    │   │   └── processed/
    │   ├── Helsinki-NLP--tatoeba_mt/
    │       ├── downloaded/
    │       ├── extracted/
    │       └── processed/
    └── transformers/
        ├── default/
        │   ├── something/
        ├── bert-base-cased/
        │   ├── default/
        │   └── training/
    hub/
    └── models--julien-c--EsperBERTo-small/
        ├── blobs/
        │   ├── (...)
        │   ├── (...)
        ├── refs/
        │   └── (...)
        └── [ 128]  snapshots/
            ├── 2439f60ef33a0d46d85da5001d52aeda5b00ce9f/
            │   ├── (...)
            └── bbc77c8132af1cc5cf678da3f1ddf2de43606d48/
                └── (...)`,wrap:!1}}),el=new j({props:{title:"Manage your file-based cache",local:"manage-your-file-based-cache",headingTag:"h2"}}),ll=new j({props:{title:"Scan your cache",local:"scan-your-cache",headingTag:"h3"}}),il=new I({props:{code:"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",highlighted:`➜ huggingface-cli scan-cache
REPO ID                     REPO TYPE SIZE ON DISK NB FILES LAST_ACCESSED LAST_MODIFIED REFS                LOCAL PATH
--------------------------- --------- ------------ -------- ------------- ------------- ------------------- -------------------------------------------------------------------------
glue                        dataset         116.3K       15 4 days ago    4 days ago    2.4.0, main, 1.17.0 /home/wauplin/.cache/huggingface/hub/datasets--glue
google/fleurs               dataset          64.9M        6 1 week ago    1 week ago    refs/pr/1, main     /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs
Jean-Baptiste/camembert-ner model           441.0M        7 2 weeks ago   16 hours ago  main                /home/wauplin/.cache/huggingface/hub/models--Jean-Baptiste--camembert-ner
bert-base-cased             model             1.9G       13 1 week ago    2 years ago                       /home/wauplin/.cache/huggingface/hub/models--bert-base-cased
t5-base                     model            10.1K        3 3 months ago  3 months ago  main                /home/wauplin/.cache/huggingface/hub/models--t5-base
t5-small                    model           970.7M       11 3 days ago    3 days ago    refs/pr/1, main     /home/wauplin/.cache/huggingface/hub/models--t5-small

Done in 0.0s. Scanned 6 repo(s) for a total of 3.4G.
Got 1 warning(s) while scanning. Use -vvv to print details.`,wrap:!1}}),Tl=new I({props:{code:"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",highlighted:`➜ huggingface-cli scan-cache -v
REPO ID                     REPO TYPE REVISION                                 SIZE ON DISK NB FILES LAST_MODIFIED REFS        LOCAL PATH
--------------------------- --------- ---------------------------------------- ------------ -------- ------------- ----------- ----------------------------------------------------------------------------------------------------------------------------
glue                        dataset   9338f7b671827df886678df2bdd7cc7b4f36dffd        97.7K       14 4 days ago    main, 2.4.0 /home/wauplin/.cache/huggingface/hub/datasets--glue/snapshots/9338f7b671827df886678df2bdd7cc7b4f36dffd
glue                        dataset   f021ae41c879fcabcf823648ec685e3fead91fe7        97.8K       14 1 week ago    1.17.0      /home/wauplin/.cache/huggingface/hub/datasets--glue/snapshots/f021ae41c879fcabcf823648ec685e3fead91fe7
google/fleurs               dataset   129b6e96cf1967cd5d2b9b6aec75ce6cce7c89e8        25.4K        3 2 weeks ago   refs/pr/1   /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs/snapshots/129b6e96cf1967cd5d2b9b6aec75ce6cce7c89e8
google/fleurs               dataset   24f85a01eb955224ca3946e70050869c56446805        64.9M        4 1 week ago    main        /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs/snapshots/24f85a01eb955224ca3946e70050869c56446805
Jean-Baptiste/camembert-ner model     dbec8489a1c44ecad9da8a9185115bccabd799fe       441.0M        7 16 hours ago  main        /home/wauplin/.cache/huggingface/hub/models--Jean-Baptiste--camembert-ner/snapshots/dbec8489a1c44ecad9da8a9185115bccabd799fe
bert-base-cased             model     378aa1bda6387fd00e824948ebe3488630ad8565         1.5G        9 2 years ago               /home/wauplin/.cache/huggingface/hub/models--bert-base-cased/snapshots/378aa1bda6387fd00e824948ebe3488630ad8565
bert-base-cased             model     a8d257ba9925ef39f3036bfc338acf5283c512d9         1.4G        9 3 days ago    main        /home/wauplin/.cache/huggingface/hub/models--bert-base-cased/snapshots/a8d257ba9925ef39f3036bfc338acf5283c512d9
t5-base                     model     23aa4f41cb7c08d4b05c8f327b22bfa0eb8c7ad9        10.1K        3 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-base/snapshots/23aa4f41cb7c08d4b05c8f327b22bfa0eb8c7ad9
t5-small                    model     98ffebbb27340ec1b1abd7c45da12c253ee1882a       726.2M        6 1 week ago    refs/pr/1   /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/98ffebbb27340ec1b1abd7c45da12c253ee1882a
t5-small                    model     d0a119eedb3718e34c648e594394474cf95e0617       485.8M        6 4 weeks ago               /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d0a119eedb3718e34c648e594394474cf95e0617
t5-small                    model     d78aea13fa7ecd06c29e3e46195d6341255065d5       970.7M        9 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d78aea13fa7ecd06c29e3e46195d6341255065d5

Done in 0.0s. Scanned 6 repo(s) for a total of 3.4G.
Got 1 warning(s) while scanning. Use -vvv to print details.`,wrap:!1}}),Jl=new I({props:{code:"JUUyJTlFJTlDJTIwZXZhbCUyMCUyMmh1Z2dpbmdmYWNlLWNsaSUyMHNjYW4tY2FjaGUlMjAtdiUyMiUyMCU3QyUyMGdyZXAlMjAlMjJ0NS1zbWFsbCUyMiUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjA5OGZmZWJiYjI3MzQwZWMxYjFhYmQ3YzQ1ZGExMmMyNTNlZTE4ODJhJTIwJTIwJTIwJTIwJTIwJTIwJTIwNzI2LjJNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNiUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwcmVmcyUyRnByJTJGMSUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGOThmZmViYmIyNzM0MGVjMWIxYWJkN2M0NWRhMTJjMjUzZWUxODgyYSUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjBkMGExMTllZWRiMzcxOGUzNGM2NDhlNTk0Mzk0NDc0Y2Y5NWUwNjE3JTIwJTIwJTIwJTIwJTIwJTIwJTIwNDg1LjhNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNiUyMDQlMjB3ZWVrcyUyMGFnbyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGZDBhMTE5ZWVkYjM3MThlMzRjNjQ4ZTU5NDM5NDQ3NGNmOTVlMDYxNyUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjBkNzhhZWExM2ZhN2VjZDA2YzI5ZTNlNDYxOTVkNjM0MTI1NTA2NWQ1JTIwJTIwJTIwJTIwJTIwJTIwJTIwOTcwLjdNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwOSUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwbWFpbiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGZDc4YWVhMTNmYTdlY2QwNmMyOWUzZTQ2MTk1ZDYzNDEyNTUwNjVkNQ==",highlighted:`➜ eval &quot;huggingface-cli scan-cache -v&quot; | grep &quot;t5-small&quot;
t5-small                    model     98ffebbb27340ec1b1abd7c45da12c253ee1882a       726.2M        6 1 week ago    refs/pr/1   /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/98ffebbb27340ec1b1abd7c45da12c253ee1882a
t5-small                    model     d0a119eedb3718e34c648e594394474cf95e0617       485.8M        6 4 weeks ago               /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d0a119eedb3718e34c648e594394474cf95e0617
t5-small                    model     d78aea13fa7ecd06c29e3e46195d6341255065d5       970.7M        9 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d78aea13fa7ecd06c29e3e46195d6341255065d5`,wrap:!1}}),Il=new I({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBaGZfY2FjaGVfaW5mbyUyMCUzRCUyMHNjYW5fY2FjaGVfZGlyKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_cache_info = scan_cache_dir()
HFCacheInfo(
    size_on_disk=<span class="hljs-number">3398085269</span>,
    repos=<span class="hljs-built_in">frozenset</span>({
        CachedRepoInfo(
            repo_id=<span class="hljs-string">&#x27;t5-small&#x27;</span>,
            repo_type=<span class="hljs-string">&#x27;model&#x27;</span>,
            repo_path=PosixPath(...),
            size_on_disk=<span class="hljs-number">970726914</span>,
            nb_files=<span class="hljs-number">11</span>,
            last_accessed=<span class="hljs-number">1662971707.3567169</span>,
            last_modified=<span class="hljs-number">1662971107.3567169</span>,
            revisions=<span class="hljs-built_in">frozenset</span>({
                CachedRevisionInfo(
                    commit_hash=<span class="hljs-string">&#x27;d78aea13fa7ecd06c29e3e46195d6341255065d5&#x27;</span>,
                    size_on_disk=<span class="hljs-number">970726339</span>,
                    snapshot_path=PosixPath(...),
                    <span class="hljs-comment"># No \`last_accessed\` as blobs are shared among revisions</span>
                    last_modified=<span class="hljs-number">1662971107.3567169</span>,
                    files=<span class="hljs-built_in">frozenset</span>({
                        CachedFileInfo(
                            file_name=<span class="hljs-string">&#x27;config.json&#x27;</span>,
                            size_on_disk=<span class="hljs-number">1197</span>
                            file_path=PosixPath(...),
                            blob_path=PosixPath(...),
                            blob_last_accessed=<span class="hljs-number">1662971707.3567169</span>,
                            blob_last_modified=<span class="hljs-number">1662971107.3567169</span>,
                        ),
                        CachedFileInfo(...),
                        ...
                    }),
                ),
                CachedRevisionInfo(...),
                ...
            }),
        ),
        CachedRepoInfo(...),
        ...
    }),
    warnings=[
        CorruptedCacheException(<span class="hljs-string">&quot;Snapshots dir doesn&#x27;t exist in cached repo: ...&quot;</span>),
        CorruptedCacheException(...),
        ...
    ],
)`,wrap:!1}}),jl=new j({props:{title:"Clean your cache",local:"clean-your-cache",headingTag:"h3"}}),C=new rM({props:{$$slots:{default:[yi]},$$scope:{ctx:r}}}),u=new rM({props:{warning:!0,$$slots:{default:[wi]},$$scope:{ctx:r}}}),Zl=new I({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1YiU1QiUyMmNsaSUyMiU1RA==",highlighted:'pip <span class="hljs-keyword">install</span> huggingface_hub[<span class="hljs-string">&quot;cli&quot;</span>]',wrap:!1}}),Nl=new I({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hl",highlighted:'huggingface-cli <span class="hljs-keyword">delete</span>-<span class="hljs-keyword">cache</span>',wrap:!1}}),Ll=new I({props:{code:"JUUyJTlDJTk3JTIwaHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hlJTIwLS1kaXIlMjB+JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMEElM0YlMjBTZWxlY3QlMjByZXZpc2lvbnMlMjB0byUyMGRlbGV0ZSUzQSUyMDIlMjByZXZpc2lvbihzKSUyMHNlbGVjdGVkLiUwQSUzRiUyMDIlMjByZXZpc2lvbnMlMjBzZWxlY3RlZCUyMGNvdW50aW5nJTIwZm9yJTIwMy4xRy4lMjBDb25maXJtJTIwZGVsZXRpb24lMjAlM0YlMjBZZXMlMEFTdGFydCUyMGRlbGV0aW9uLiUwQURvbmUuJTIwRGVsZXRlZCUyMDElMjByZXBvKHMpJTIwYW5kJTIwMCUyMHJldmlzaW9uKHMpJTIwZm9yJTIwYSUyMHRvdGFsJTIwb2YlMjAzLjFHLg==",highlighted:`✗ huggingface-cli delete-cache --dir ~/.cache/huggingface/hub
? Select revisions to delete: 2 revision(s) selected.
? 2 revisions selected counting for 3.1G. Confirm deletion ? Yes
Start deletion.
Done. Deleted 1 repo(s) and 0 revision(s) for a total of 3.1G.`,wrap:!1}}),Ql=new I({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hlJTIwLS1kaXNhYmxlLXR1aQ==",highlighted:"huggingface-cli delete-cache --disable-tui",wrap:!1}}),Fl=new I({props:{code:"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",highlighted:`# INSTRUCTIONS
# ------------
# This is a temporary file created by running \`huggingface-cli delete-cache\` with the
# \`--disable-tui\` option. It contains a set of revisions that can be deleted from your
# local cache directory.
#
# Please manually review the revisions you want to delete:
#   - Revision hashes can be commented out with &#x27;#&#x27;.
#   - Only non-commented revisions in this file will be deleted.
#   - Revision hashes that are removed from this file are ignored as well.
#   - If \`CANCEL_DELETION\` line is uncommented, the all cache deletion is cancelled and
#     no changes will be applied.
#
# Once you&#x27;ve manually reviewed this file, please confirm deletion in the terminal. This
# file will be automatically removed once done.
# ------------

# KILL SWITCH
# ------------
# Un-comment following line to completely cancel the deletion process
# CANCEL_DELETION
# ------------

# REVISIONS
# ------------
# Dataset chrisjay/crowd-speech-africa (761.7M, used 5 days ago)
    ebedcd8c55c90d39fd27126d29d8484566cd27ca # Refs: main # modified 5 days ago

# Dataset oscar (3.3M, used 4 days ago)
#    916f956518279c5e60c63902ebdf3ddf9fa9d629 # Refs: main # modified 4 days ago

# Dataset wikiann (804.1K, used 2 weeks ago)
    89d089624b6323d69dcd9e5eb2def0551887a73a # Refs: main # modified 2 weeks ago

# Dataset z-uo/male-LJSpeech-italian (5.5G, used 5 days ago)
#    9cfa5647b32c0a30d0adfca06bf198d82192a0d1 # Refs: main # modified 5 days ago`,wrap:!1}}),$l=new I({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBZGVsZXRlX3N0cmF0ZWd5JTIwJTNEJTIwc2Nhbl9jYWNoZV9kaXIoKS5kZWxldGVfcmV2aXNpb25zKCUwQSUyMCUyMCUyMCUyMCUyMjgxZmQxZDZlNzg0N2M5OWY1ODYyYzlmYjgxMzg3OTU2ZDk5ZWM3YWElMjIlMEElMjAlMjAlMjAlMjAlMjJlMjk4M2IyMzdkY2NmM2FiNDkzN2M5N2ZhNzE3MzE5YTljYTFhOTZkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyNmMwZTYwODA5NTNkYjU2Mzc1NzYwYzA0NzFhOGM1ZjI5MjliYWYxMSUyMiUyQyUwQSklMEFwcmludCglMjJXaWxsJTIwZnJlZSUyMCUyMiUyMCUyQiUyMGRlbGV0ZV9zdHJhdGVneS5leHBlY3RlZF9mcmVlZF9zaXplX3N0ciklMEElMEFkZWxldGVfc3RyYXRlZ3kuZXhlY3V0ZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy = scan_cache_dir().delete_revisions(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;81fd1d6e7847c99f5862c9fb81387956d99ec7aa&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;e2983b237dccf3ab4937c97fa717319a9ca1a96d&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Will free &quot;</span> + delete_strategy.expected_freed_size_str)
Will free <span class="hljs-number">8.6</span>G

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy.execute()
Cache deletion done. Saved <span class="hljs-number">8.6</span>G.`,wrap:!1}}),El=new Ui({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/manage-cache.md"}}),{c(){y=i("meta"),f=M(),w=i("p"),m=M(),c(A.$$.fragment),zl=M(),g=i("p"),g.innerHTML=CM,Hl=M(),c(Z.$$.fragment),Xl=M(),k=i("p"),k.textContent=uM,Pl=M(),N=i("p"),N.textContent=bM,ql=M(),c(Y.$$.fragment),Kl=M(),G=i("p"),G.innerHTML=AM,et=M(),v=i("p"),v.textContent=gM,lt=M(),c(W.$$.fragment),tt=M(),L=i("p"),L.textContent=ZM,at=M(),R=i("p"),R.textContent=kM,Mt=M(),c(S.$$.fragment),st=M(),x=i("p"),x.textContent=NM,it=M(),c(B.$$.fragment),nt=M(),Q=i("p"),Q.innerHTML=YM,Tt=M(),D=i("p"),D.innerHTML=GM,ct=M(),F=i("p"),F.innerHTML=vM,ot=M(),c(O.$$.fragment),Jt=M(),V=i("p"),V.innerHTML=WM,dt=M(),c($.$$.fragment),Ut=M(),E=i("p"),E.innerHTML=LM,ht=M(),_=i("p"),_.innerHTML=RM,yt=M(),z=i("p"),z.innerHTML=SM,wt=M(),c(H.$$.fragment),It=M(),X=i("p"),X.innerHTML=xM,jt=M(),P=i("p"),P.innerHTML=BM,ft=M(),c(q.$$.fragment),mt=M(),K=i("p"),K.innerHTML=QM,rt=M(),c(ee.$$.fragment),pt=M(),le=i("p"),le.innerHTML=DM,Ct=M(),te=i("p"),te.innerHTML=FM,ut=M(),ae=i("p"),ae.innerHTML=OM,bt=M(),c(Me.$$.fragment),At=M(),c(se.$$.fragment),gt=M(),ie=i("p"),ie.textContent=VM,Zt=M(),c(ne.$$.fragment),kt=M(),c(Te.$$.fragment),Nt=M(),ce=i("p"),ce.innerHTML=$M,Yt=M(),oe=i("p"),oe.innerHTML=EM,Gt=M(),Je=i("p"),Je.innerHTML=_M,vt=M(),c(de.$$.fragment),Wt=M(),Ue=i("p"),Ue.innerHTML=zM,Lt=M(),he=i("p"),he.innerHTML=HM,Rt=M(),c(ye.$$.fragment),St=M(),we=i("p"),we.innerHTML=XM,xt=M(),Ie=i("p"),Ie.textContent=PM,Bt=M(),je=i("ul"),je.innerHTML=qM,Qt=M(),fe=i("p"),fe.textContent=KM,Dt=M(),me=i("p"),me.innerHTML=es,Ft=M(),c(re.$$.fragment),Ot=M(),pe=i("p"),pe.textContent=ls,Vt=M(),Ce=i("p"),Ce.innerHTML=ts,$t=M(),c(ue.$$.fragment),Et=M(),be=i("p"),be.innerHTML=as,_t=M(),Ae=i("p"),Ae.innerHTML=Ms,zt=M(),ge=i("p"),ge.innerHTML=ss,Ht=M(),c(Ze.$$.fragment),Xt=M(),ke=i("p"),ke.textContent=is,Pt=M(),c(Ne.$$.fragment),qt=M(),Ye=i("p"),Ye.innerHTML=ns,Kt=M(),Ge=i("ul"),Ge.innerHTML=Ts,ea=M(),ve=i("p"),ve.textContent=cs,la=M(),We=i("p"),We.textContent=os,ta=M(),c(Le.$$.fragment),aa=M(),Re=i("p"),Re.textContent=Js,Ma=M(),Se=i("p"),Se.innerHTML=ds,sa=M(),xe=i("p"),xe.textContent=Us,ia=M(),Be=i("p"),Be.innerHTML=hs,na=M(),Qe=i("p"),Qe.innerHTML=ys,Ta=M(),c(De.$$.fragment),ca=M(),Fe=i("p"),Fe.innerHTML=ws,oa=M(),Oe=i("p"),Oe.innerHTML=Is,Ja=M(),Ve=i("p"),Ve.innerHTML=js,da=M(),$e=i("p"),$e.innerHTML=fs,Ua=M(),c(Ee.$$.fragment),ha=M(),_e=i("p"),_e.innerHTML=ms,ya=M(),c(ze.$$.fragment),wa=M(),He=i("p"),He.innerHTML=rs,Ia=M(),c(Xe.$$.fragment),ja=M(),c(p.$$.fragment),fa=M(),c(Pe.$$.fragment),ma=M(),qe=i("p"),qe.textContent=ps,ra=M(),c(Ke.$$.fragment),pa=M(),c(el.$$.fragment),Ca=M(),c(ll.$$.fragment),ua=M(),tl=i("p"),tl.innerHTML=Cs,ba=M(),al=i("p"),al.innerHTML=us,Aa=M(),Ml=i("p"),Ml.innerHTML=bs,ga=M(),sl=i("p"),sl.textContent=As,Za=M(),c(il.$$.fragment),ka=M(),nl=i("p"),nl.innerHTML=gs,Na=M(),c(Tl.$$.fragment),Ya=M(),cl=i("p"),cl.innerHTML=Zs,Ga=M(),ol=i("p"),ol.innerHTML=ks,va=M(),c(Jl.$$.fragment),Wa=M(),dl=i("p"),dl.innerHTML=Ns,La=M(),Ul=i("p"),Ul.innerHTML=Ys,Ra=M(),hl=i("p"),hl.textContent=Gs,Sa=M(),yl=i("ul"),yl.innerHTML=vs,xa=M(),wl=i("p"),wl.textContent=Ws,Ba=M(),c(Il.$$.fragment),Qa=M(),c(jl.$$.fragment),Da=M(),fl=i("p"),fl.innerHTML=Ls,Fa=M(),ml=i("p"),ml.innerHTML=Rs,Oa=M(),rl=i("p"),rl.innerHTML=Ss,Va=M(),pl=i("p"),pl.textContent=xs,$a=M(),Cl=i("ul"),Cl.innerHTML=Bs,Ea=M(),c(C.$$.fragment),_a=M(),c(u.$$.fragment),za=M(),ul=i("p"),ul.innerHTML=Qs,Ha=M(),bl=i("p"),bl.innerHTML=Ds,Xa=M(),Al=i("p"),Al.innerHTML=Fs,Pa=M(),gl=i("p"),gl.textContent=Os,qa=M(),c(Zl.$$.fragment),Ka=M(),kl=i("p"),kl.textContent=Vs,eM=M(),c(Nl.$$.fragment),lM=M(),Yl=i("p"),Yl.textContent=$s,tM=M(),b=i("div"),b.innerHTML=Es,aM=M(),Gl=i("p"),Gl.textContent=_s,MM=M(),vl=i("ul"),vl.innerHTML=zs,sM=M(),Wl=i("p"),Wl.innerHTML=Hs,iM=M(),c(Ll.$$.fragment),nM=M(),Rl=i("p"),Rl.innerHTML=Xs,TM=M(),Sl=i("p"),Sl.textContent=Ps,cM=M(),xl=i("p"),xl.innerHTML=qs,oM=M(),Bl=i("p"),Bl.innerHTML=Ks,JM=M(),c(Ql.$$.fragment),dM=M(),Dl=i("p"),Dl.textContent=ei,UM=M(),c(Fl.$$.fragment),hM=M(),Ol=i("p"),Ol.innerHTML=li,yM=M(),Vl=i("p"),Vl.innerHTML=ti,wM=M(),c($l.$$.fragment),IM=M(),c(El.$$.fragment),jM=M(),_l=i("p"),this.h()},l(e){const l=Ji("svelte-u9bgzb",document.head);y=n(l,"META",{name:!0,content:!0}),l.forEach(t),f=s(e),w=n(e,"P",{}),ii(w).forEach(t),m=s(e),o(A.$$.fragment,e),zl=s(e),g=n(e,"P",{"data-svelte-h":!0}),T(g)!=="svelte-1s3yler"&&(g.innerHTML=CM),Hl=s(e),o(Z.$$.fragment,e),Xl=s(e),k=n(e,"P",{"data-svelte-h":!0}),T(k)!=="svelte-7434pt"&&(k.textContent=uM),Pl=s(e),N=n(e,"P",{"data-svelte-h":!0}),T(N)!=="svelte-bm5pxs"&&(N.textContent=bM),ql=s(e),o(Y.$$.fragment,e),Kl=s(e),G=n(e,"P",{"data-svelte-h":!0}),T(G)!=="svelte-lw0yzm"&&(G.innerHTML=AM),et=s(e),v=n(e,"P",{"data-svelte-h":!0}),T(v)!=="svelte-1xsylbb"&&(v.textContent=gM),lt=s(e),o(W.$$.fragment,e),tt=s(e),L=n(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-smirw4"&&(L.textContent=ZM),at=s(e),R=n(e,"P",{"data-svelte-h":!0}),T(R)!=="svelte-hxzvg9"&&(R.textContent=kM),Mt=s(e),o(S.$$.fragment,e),st=s(e),x=n(e,"P",{"data-svelte-h":!0}),T(x)!=="svelte-1o80jr1"&&(x.textContent=NM),it=s(e),o(B.$$.fragment,e),nt=s(e),Q=n(e,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-z6cr2z"&&(Q.innerHTML=YM),Tt=s(e),D=n(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-15cx8ge"&&(D.innerHTML=GM),ct=s(e),F=n(e,"P",{"data-svelte-h":!0}),T(F)!=="svelte-1u7b6sn"&&(F.innerHTML=vM),ot=s(e),o(O.$$.fragment,e),Jt=s(e),V=n(e,"P",{"data-svelte-h":!0}),T(V)!=="svelte-9jec47"&&(V.innerHTML=WM),dt=s(e),o($.$$.fragment,e),Ut=s(e),E=n(e,"P",{"data-svelte-h":!0}),T(E)!=="svelte-1mswky"&&(E.innerHTML=LM),ht=s(e),_=n(e,"P",{"data-svelte-h":!0}),T(_)!=="svelte-1f9g1u2"&&(_.innerHTML=RM),yt=s(e),z=n(e,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1ezxfdw"&&(z.innerHTML=SM),wt=s(e),o(H.$$.fragment,e),It=s(e),X=n(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-7nae39"&&(X.innerHTML=xM),jt=s(e),P=n(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-sjd8l1"&&(P.innerHTML=BM),ft=s(e),o(q.$$.fragment,e),mt=s(e),K=n(e,"P",{"data-svelte-h":!0}),T(K)!=="svelte-dxew1x"&&(K.innerHTML=QM),rt=s(e),o(ee.$$.fragment,e),pt=s(e),le=n(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-f64xkc"&&(le.innerHTML=DM),Ct=s(e),te=n(e,"P",{"data-svelte-h":!0}),T(te)!=="svelte-178rlr8"&&(te.innerHTML=FM),ut=s(e),ae=n(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-lua08t"&&(ae.innerHTML=OM),bt=s(e),o(Me.$$.fragment,e),At=s(e),o(se.$$.fragment,e),gt=s(e),ie=n(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-1cw24ss"&&(ie.textContent=VM),Zt=s(e),o(ne.$$.fragment,e),kt=s(e),o(Te.$$.fragment,e),Nt=s(e),ce=n(e,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-1foktgq"&&(ce.innerHTML=$M),Yt=s(e),oe=n(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-x8ev9q"&&(oe.innerHTML=EM),Gt=s(e),Je=n(e,"P",{"data-svelte-h":!0}),T(Je)!=="svelte-1ue61z6"&&(Je.innerHTML=_M),vt=s(e),o(de.$$.fragment,e),Wt=s(e),Ue=n(e,"P",{"data-svelte-h":!0}),T(Ue)!=="svelte-1pw0cpj"&&(Ue.innerHTML=zM),Lt=s(e),he=n(e,"P",{"data-svelte-h":!0}),T(he)!=="svelte-o7am1f"&&(he.innerHTML=HM),Rt=s(e),o(ye.$$.fragment,e),St=s(e),we=n(e,"P",{"data-svelte-h":!0}),T(we)!=="svelte-15i0o7a"&&(we.innerHTML=XM),xt=s(e),Ie=n(e,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-nj5twx"&&(Ie.textContent=PM),Bt=s(e),je=n(e,"UL",{"data-svelte-h":!0}),T(je)!=="svelte-15a5775"&&(je.innerHTML=qM),Qt=s(e),fe=n(e,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-68d6zk"&&(fe.textContent=KM),Dt=s(e),me=n(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-1fqunt1"&&(me.innerHTML=es),Ft=s(e),o(re.$$.fragment,e),Ot=s(e),pe=n(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-jcytje"&&(pe.textContent=ls),Vt=s(e),Ce=n(e,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-im7pgk"&&(Ce.innerHTML=ts),$t=s(e),o(ue.$$.fragment,e),Et=s(e),be=n(e,"P",{"data-svelte-h":!0}),T(be)!=="svelte-gkyc1z"&&(be.innerHTML=as),_t=s(e),Ae=n(e,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-16gi99u"&&(Ae.innerHTML=Ms),zt=s(e),ge=n(e,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-1nna80w"&&(ge.innerHTML=ss),Ht=s(e),o(Ze.$$.fragment,e),Xt=s(e),ke=n(e,"P",{"data-svelte-h":!0}),T(ke)!=="svelte-1shtud2"&&(ke.textContent=is),Pt=s(e),o(Ne.$$.fragment,e),qt=s(e),Ye=n(e,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-h63bo"&&(Ye.innerHTML=ns),Kt=s(e),Ge=n(e,"UL",{"data-svelte-h":!0}),T(Ge)!=="svelte-1sf7fpu"&&(Ge.innerHTML=Ts),ea=s(e),ve=n(e,"P",{"data-svelte-h":!0}),T(ve)!=="svelte-5htz2c"&&(ve.textContent=cs),la=s(e),We=n(e,"P",{"data-svelte-h":!0}),T(We)!=="svelte-imyi1b"&&(We.textContent=os),ta=s(e),o(Le.$$.fragment,e),aa=s(e),Re=n(e,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-1gjzgfe"&&(Re.textContent=Js),Ma=s(e),Se=n(e,"P",{"data-svelte-h":!0}),T(Se)!=="svelte-1ced4p2"&&(Se.innerHTML=ds),sa=s(e),xe=n(e,"P",{"data-svelte-h":!0}),T(xe)!=="svelte-4sdu17"&&(xe.textContent=Us),ia=s(e),Be=n(e,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-wvh9oo"&&(Be.innerHTML=hs),na=s(e),Qe=n(e,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-o4afuj"&&(Qe.innerHTML=ys),Ta=s(e),o(De.$$.fragment,e),ca=s(e),Fe=n(e,"P",{"data-svelte-h":!0}),T(Fe)!=="svelte-1ki79zi"&&(Fe.innerHTML=ws),oa=s(e),Oe=n(e,"P",{"data-svelte-h":!0}),T(Oe)!=="svelte-1qzo8xt"&&(Oe.innerHTML=Is),Ja=s(e),Ve=n(e,"P",{"data-svelte-h":!0}),T(Ve)!=="svelte-yngdyh"&&(Ve.innerHTML=js),da=s(e),$e=n(e,"P",{"data-svelte-h":!0}),T($e)!=="svelte-er0a1o"&&($e.innerHTML=fs),Ua=s(e),o(Ee.$$.fragment,e),ha=s(e),_e=n(e,"P",{"data-svelte-h":!0}),T(_e)!=="svelte-7cx0vv"&&(_e.innerHTML=ms),ya=s(e),o(ze.$$.fragment,e),wa=s(e),He=n(e,"P",{"data-svelte-h":!0}),T(He)!=="svelte-1r0ndhn"&&(He.innerHTML=rs),Ia=s(e),o(Xe.$$.fragment,e),ja=s(e),o(p.$$.fragment,e),fa=s(e),o(Pe.$$.fragment,e),ma=s(e),qe=n(e,"P",{"data-svelte-h":!0}),T(qe)!=="svelte-1lsljsl"&&(qe.textContent=ps),ra=s(e),o(Ke.$$.fragment,e),pa=s(e),o(el.$$.fragment,e),Ca=s(e),o(ll.$$.fragment,e),ua=s(e),tl=n(e,"P",{"data-svelte-h":!0}),T(tl)!=="svelte-1ppewq"&&(tl.innerHTML=Cs),ba=s(e),al=n(e,"P",{"data-svelte-h":!0}),T(al)!=="svelte-1ycn1eb"&&(al.innerHTML=us),Aa=s(e),Ml=n(e,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-18l68mc"&&(Ml.innerHTML=bs),ga=s(e),sl=n(e,"P",{"data-svelte-h":!0}),T(sl)!=="svelte-1ss2857"&&(sl.textContent=As),Za=s(e),o(il.$$.fragment,e),ka=s(e),nl=n(e,"P",{"data-svelte-h":!0}),T(nl)!=="svelte-2cqqt0"&&(nl.innerHTML=gs),Na=s(e),o(Tl.$$.fragment,e),Ya=s(e),cl=n(e,"P",{"data-svelte-h":!0}),T(cl)!=="svelte-4zvnaj"&&(cl.innerHTML=Zs),Ga=s(e),ol=n(e,"P",{"data-svelte-h":!0}),T(ol)!=="svelte-1h7dpll"&&(ol.innerHTML=ks),va=s(e),o(Jl.$$.fragment,e),Wa=s(e),dl=n(e,"P",{"data-svelte-h":!0}),T(dl)!=="svelte-b9d1g2"&&(dl.innerHTML=Ns),La=s(e),Ul=n(e,"P",{"data-svelte-h":!0}),T(Ul)!=="svelte-1bx4n8u"&&(Ul.innerHTML=Ys),Ra=s(e),hl=n(e,"P",{"data-svelte-h":!0}),T(hl)!=="svelte-83019z"&&(hl.textContent=Gs),Sa=s(e),yl=n(e,"UL",{"data-svelte-h":!0}),T(yl)!=="svelte-qwuhrl"&&(yl.innerHTML=vs),xa=s(e),wl=n(e,"P",{"data-svelte-h":!0}),T(wl)!=="svelte-xp69b3"&&(wl.textContent=Ws),Ba=s(e),o(Il.$$.fragment,e),Qa=s(e),o(jl.$$.fragment,e),Da=s(e),fl=n(e,"P",{"data-svelte-h":!0}),T(fl)!=="svelte-1jpuvb3"&&(fl.innerHTML=Ls),Fa=s(e),ml=n(e,"P",{"data-svelte-h":!0}),T(ml)!=="svelte-s9tc9t"&&(ml.innerHTML=Rs),Oa=s(e),rl=n(e,"P",{"data-svelte-h":!0}),T(rl)!=="svelte-1wode1b"&&(rl.innerHTML=Ss),Va=s(e),pl=n(e,"P",{"data-svelte-h":!0}),T(pl)!=="svelte-19y0r7c"&&(pl.textContent=xs),$a=s(e),Cl=n(e,"UL",{"data-svelte-h":!0}),T(Cl)!=="svelte-o7nsmh"&&(Cl.innerHTML=Bs),Ea=s(e),o(C.$$.fragment,e),_a=s(e),o(u.$$.fragment,e),za=s(e),ul=n(e,"P",{"data-svelte-h":!0}),T(ul)!=="svelte-13xgrrb"&&(ul.innerHTML=Qs),Ha=s(e),bl=n(e,"P",{"data-svelte-h":!0}),T(bl)!=="svelte-1arrz5p"&&(bl.innerHTML=Ds),Xa=s(e),Al=n(e,"P",{"data-svelte-h":!0}),T(Al)!=="svelte-vbosxs"&&(Al.innerHTML=Fs),Pa=s(e),gl=n(e,"P",{"data-svelte-h":!0}),T(gl)!=="svelte-yr0mit"&&(gl.textContent=Os),qa=s(e),o(Zl.$$.fragment,e),Ka=s(e),kl=n(e,"P",{"data-svelte-h":!0}),T(kl)!=="svelte-gq4pgy"&&(kl.textContent=Vs),eM=s(e),o(Nl.$$.fragment,e),lM=s(e),Yl=n(e,"P",{"data-svelte-h":!0}),T(Yl)!=="svelte-20gxv"&&(Yl.textContent=$s),tM=s(e),b=n(e,"DIV",{class:!0,"data-svelte-h":!0}),T(b)!=="svelte-17iq48i"&&(b.innerHTML=Es),aM=s(e),Gl=n(e,"P",{"data-svelte-h":!0}),T(Gl)!=="svelte-7awvfp"&&(Gl.textContent=_s),MM=s(e),vl=n(e,"UL",{"data-svelte-h":!0}),T(vl)!=="svelte-76obk"&&(vl.innerHTML=zs),sM=s(e),Wl=n(e,"P",{"data-svelte-h":!0}),T(Wl)!=="svelte-aoo47g"&&(Wl.innerHTML=Hs),iM=s(e),o(Ll.$$.fragment,e),nM=s(e),Rl=n(e,"P",{"data-svelte-h":!0}),T(Rl)!=="svelte-ewwg27"&&(Rl.innerHTML=Xs),TM=s(e),Sl=n(e,"P",{"data-svelte-h":!0}),T(Sl)!=="svelte-ymcz12"&&(Sl.textContent=Ps),cM=s(e),xl=n(e,"P",{"data-svelte-h":!0}),T(xl)!=="svelte-u5k7vk"&&(xl.innerHTML=qs),oM=s(e),Bl=n(e,"P",{"data-svelte-h":!0}),T(Bl)!=="svelte-1baaith"&&(Bl.innerHTML=Ks),JM=s(e),o(Ql.$$.fragment,e),dM=s(e),Dl=n(e,"P",{"data-svelte-h":!0}),T(Dl)!=="svelte-15nmp2q"&&(Dl.textContent=ei),UM=s(e),o(Fl.$$.fragment,e),hM=s(e),Ol=n(e,"P",{"data-svelte-h":!0}),T(Ol)!=="svelte-1ayyols"&&(Ol.innerHTML=li),yM=s(e),Vl=n(e,"P",{"data-svelte-h":!0}),T(Vl)!=="svelte-qm6d3g"&&(Vl.innerHTML=ti),wM=s(e),o($l.$$.fragment,e),IM=s(e),o(El.$$.fragment,e),jM=s(e),_l=n(e,"P",{}),ii(_l).forEach(t),this.h()},h(){mM(y,"name","hf:doc:metadata"),mM(y,"content",ji),mM(b,"class","flex justify-center")},m(e,l){di(document.head,y),a(e,f,l),a(e,w,l),a(e,m,l),J(A,e,l),a(e,zl,l),a(e,g,l),a(e,Hl,l),J(Z,e,l),a(e,Xl,l),a(e,k,l),a(e,Pl,l),a(e,N,l),a(e,ql,l),J(Y,e,l),a(e,Kl,l),a(e,G,l),a(e,et,l),a(e,v,l),a(e,lt,l),J(W,e,l),a(e,tt,l),a(e,L,l),a(e,at,l),a(e,R,l),a(e,Mt,l),J(S,e,l),a(e,st,l),a(e,x,l),a(e,it,l),J(B,e,l),a(e,nt,l),a(e,Q,l),a(e,Tt,l),a(e,D,l),a(e,ct,l),a(e,F,l),a(e,ot,l),J(O,e,l),a(e,Jt,l),a(e,V,l),a(e,dt,l),J($,e,l),a(e,Ut,l),a(e,E,l),a(e,ht,l),a(e,_,l),a(e,yt,l),a(e,z,l),a(e,wt,l),J(H,e,l),a(e,It,l),a(e,X,l),a(e,jt,l),a(e,P,l),a(e,ft,l),J(q,e,l),a(e,mt,l),a(e,K,l),a(e,rt,l),J(ee,e,l),a(e,pt,l),a(e,le,l),a(e,Ct,l),a(e,te,l),a(e,ut,l),a(e,ae,l),a(e,bt,l),J(Me,e,l),a(e,At,l),J(se,e,l),a(e,gt,l),a(e,ie,l),a(e,Zt,l),J(ne,e,l),a(e,kt,l),J(Te,e,l),a(e,Nt,l),a(e,ce,l),a(e,Yt,l),a(e,oe,l),a(e,Gt,l),a(e,Je,l),a(e,vt,l),J(de,e,l),a(e,Wt,l),a(e,Ue,l),a(e,Lt,l),a(e,he,l),a(e,Rt,l),J(ye,e,l),a(e,St,l),a(e,we,l),a(e,xt,l),a(e,Ie,l),a(e,Bt,l),a(e,je,l),a(e,Qt,l),a(e,fe,l),a(e,Dt,l),a(e,me,l),a(e,Ft,l),J(re,e,l),a(e,Ot,l),a(e,pe,l),a(e,Vt,l),a(e,Ce,l),a(e,$t,l),J(ue,e,l),a(e,Et,l),a(e,be,l),a(e,_t,l),a(e,Ae,l),a(e,zt,l),a(e,ge,l),a(e,Ht,l),J(Ze,e,l),a(e,Xt,l),a(e,ke,l),a(e,Pt,l),J(Ne,e,l),a(e,qt,l),a(e,Ye,l),a(e,Kt,l),a(e,Ge,l),a(e,ea,l),a(e,ve,l),a(e,la,l),a(e,We,l),a(e,ta,l),J(Le,e,l),a(e,aa,l),a(e,Re,l),a(e,Ma,l),a(e,Se,l),a(e,sa,l),a(e,xe,l),a(e,ia,l),a(e,Be,l),a(e,na,l),a(e,Qe,l),a(e,Ta,l),J(De,e,l),a(e,ca,l),a(e,Fe,l),a(e,oa,l),a(e,Oe,l),a(e,Ja,l),a(e,Ve,l),a(e,da,l),a(e,$e,l),a(e,Ua,l),J(Ee,e,l),a(e,ha,l),a(e,_e,l),a(e,ya,l),J(ze,e,l),a(e,wa,l),a(e,He,l),a(e,Ia,l),J(Xe,e,l),a(e,ja,l),J(p,e,l),a(e,fa,l),J(Pe,e,l),a(e,ma,l),a(e,qe,l),a(e,ra,l),J(Ke,e,l),a(e,pa,l),J(el,e,l),a(e,Ca,l),J(ll,e,l),a(e,ua,l),a(e,tl,l),a(e,ba,l),a(e,al,l),a(e,Aa,l),a(e,Ml,l),a(e,ga,l),a(e,sl,l),a(e,Za,l),J(il,e,l),a(e,ka,l),a(e,nl,l),a(e,Na,l),J(Tl,e,l),a(e,Ya,l),a(e,cl,l),a(e,Ga,l),a(e,ol,l),a(e,va,l),J(Jl,e,l),a(e,Wa,l),a(e,dl,l),a(e,La,l),a(e,Ul,l),a(e,Ra,l),a(e,hl,l),a(e,Sa,l),a(e,yl,l),a(e,xa,l),a(e,wl,l),a(e,Ba,l),J(Il,e,l),a(e,Qa,l),J(jl,e,l),a(e,Da,l),a(e,fl,l),a(e,Fa,l),a(e,ml,l),a(e,Oa,l),a(e,rl,l),a(e,Va,l),a(e,pl,l),a(e,$a,l),a(e,Cl,l),a(e,Ea,l),J(C,e,l),a(e,_a,l),J(u,e,l),a(e,za,l),a(e,ul,l),a(e,Ha,l),a(e,bl,l),a(e,Xa,l),a(e,Al,l),a(e,Pa,l),a(e,gl,l),a(e,qa,l),J(Zl,e,l),a(e,Ka,l),a(e,kl,l),a(e,eM,l),J(Nl,e,l),a(e,lM,l),a(e,Yl,l),a(e,tM,l),a(e,b,l),a(e,aM,l),a(e,Gl,l),a(e,MM,l),a(e,vl,l),a(e,sM,l),a(e,Wl,l),a(e,iM,l),J(Ll,e,l),a(e,nM,l),a(e,Rl,l),a(e,TM,l),a(e,Sl,l),a(e,cM,l),a(e,xl,l),a(e,oM,l),a(e,Bl,l),a(e,JM,l),J(Ql,e,l),a(e,dM,l),a(e,Dl,l),a(e,UM,l),J(Fl,e,l),a(e,hM,l),a(e,Ol,l),a(e,yM,l),a(e,Vl,l),a(e,wM,l),J($l,e,l),a(e,IM,l),J(El,e,l),a(e,jM,l),a(e,_l,l),fM=!0},p(e,[l]){const ai={};l&2&&(ai.$$scope={dirty:l,ctx:e}),p.$set(ai);const Mi={};l&2&&(Mi.$$scope={dirty:l,ctx:e}),C.$set(Mi);const si={};l&2&&(si.$$scope={dirty:l,ctx:e}),u.$set(si)},i(e){fM||(d(A.$$.fragment,e),d(Z.$$.fragment,e),d(Y.$$.fragment,e),d(W.$$.fragment,e),d(S.$$.fragment,e),d(B.$$.fragment,e),d(O.$$.fragment,e),d($.$$.fragment,e),d(H.$$.fragment,e),d(q.$$.fragment,e),d(ee.$$.fragment,e),d(Me.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(Te.$$.fragment,e),d(de.$$.fragment,e),d(ye.$$.fragment,e),d(re.$$.fragment,e),d(ue.$$.fragment,e),d(Ze.$$.fragment,e),d(Ne.$$.fragment,e),d(Le.$$.fragment,e),d(De.$$.fragment,e),d(Ee.$$.fragment,e),d(ze.$$.fragment,e),d(Xe.$$.fragment,e),d(p.$$.fragment,e),d(Pe.$$.fragment,e),d(Ke.$$.fragment,e),d(el.$$.fragment,e),d(ll.$$.fragment,e),d(il.$$.fragment,e),d(Tl.$$.fragment,e),d(Jl.$$.fragment,e),d(Il.$$.fragment,e),d(jl.$$.fragment,e),d(C.$$.fragment,e),d(u.$$.fragment,e),d(Zl.$$.fragment,e),d(Nl.$$.fragment,e),d(Ll.$$.fragment,e),d(Ql.$$.fragment,e),d(Fl.$$.fragment,e),d($l.$$.fragment,e),d(El.$$.fragment,e),fM=!0)},o(e){U(A.$$.fragment,e),U(Z.$$.fragment,e),U(Y.$$.fragment,e),U(W.$$.fragment,e),U(S.$$.fragment,e),U(B.$$.fragment,e),U(O.$$.fragment,e),U($.$$.fragment,e),U(H.$$.fragment,e),U(q.$$.fragment,e),U(ee.$$.fragment,e),U(Me.$$.fragment,e),U(se.$$.fragment,e),U(ne.$$.fragment,e),U(Te.$$.fragment,e),U(de.$$.fragment,e),U(ye.$$.fragment,e),U(re.$$.fragment,e),U(ue.$$.fragment,e),U(Ze.$$.fragment,e),U(Ne.$$.fragment,e),U(Le.$$.fragment,e),U(De.$$.fragment,e),U(Ee.$$.fragment,e),U(ze.$$.fragment,e),U(Xe.$$.fragment,e),U(p.$$.fragment,e),U(Pe.$$.fragment,e),U(Ke.$$.fragment,e),U(el.$$.fragment,e),U(ll.$$.fragment,e),U(il.$$.fragment,e),U(Tl.$$.fragment,e),U(Jl.$$.fragment,e),U(Il.$$.fragment,e),U(jl.$$.fragment,e),U(C.$$.fragment,e),U(u.$$.fragment,e),U(Zl.$$.fragment,e),U(Nl.$$.fragment,e),U(Ll.$$.fragment,e),U(Ql.$$.fragment,e),U(Fl.$$.fragment,e),U($l.$$.fragment,e),U(El.$$.fragment,e),fM=!1},d(e){e&&(t(f),t(w),t(m),t(zl),t(g),t(Hl),t(Xl),t(k),t(Pl),t(N),t(ql),t(Kl),t(G),t(et),t(v),t(lt),t(tt),t(L),t(at),t(R),t(Mt),t(st),t(x),t(it),t(nt),t(Q),t(Tt),t(D),t(ct),t(F),t(ot),t(Jt),t(V),t(dt),t(Ut),t(E),t(ht),t(_),t(yt),t(z),t(wt),t(It),t(X),t(jt),t(P),t(ft),t(mt),t(K),t(rt),t(pt),t(le),t(Ct),t(te),t(ut),t(ae),t(bt),t(At),t(gt),t(ie),t(Zt),t(kt),t(Nt),t(ce),t(Yt),t(oe),t(Gt),t(Je),t(vt),t(Wt),t(Ue),t(Lt),t(he),t(Rt),t(St),t(we),t(xt),t(Ie),t(Bt),t(je),t(Qt),t(fe),t(Dt),t(me),t(Ft),t(Ot),t(pe),t(Vt),t(Ce),t($t),t(Et),t(be),t(_t),t(Ae),t(zt),t(ge),t(Ht),t(Xt),t(ke),t(Pt),t(qt),t(Ye),t(Kt),t(Ge),t(ea),t(ve),t(la),t(We),t(ta),t(aa),t(Re),t(Ma),t(Se),t(sa),t(xe),t(ia),t(Be),t(na),t(Qe),t(Ta),t(ca),t(Fe),t(oa),t(Oe),t(Ja),t(Ve),t(da),t($e),t(Ua),t(ha),t(_e),t(ya),t(wa),t(He),t(Ia),t(ja),t(fa),t(ma),t(qe),t(ra),t(pa),t(Ca),t(ua),t(tl),t(ba),t(al),t(Aa),t(Ml),t(ga),t(sl),t(Za),t(ka),t(nl),t(Na),t(Ya),t(cl),t(Ga),t(ol),t(va),t(Wa),t(dl),t(La),t(Ul),t(Ra),t(hl),t(Sa),t(yl),t(xa),t(wl),t(Ba),t(Qa),t(Da),t(fl),t(Fa),t(ml),t(Oa),t(rl),t(Va),t(pl),t($a),t(Cl),t(Ea),t(_a),t(za),t(ul),t(Ha),t(bl),t(Xa),t(Al),t(Pa),t(gl),t(qa),t(Ka),t(kl),t(eM),t(lM),t(Yl),t(tM),t(b),t(aM),t(Gl),t(MM),t(vl),t(sM),t(Wl),t(iM),t(nM),t(Rl),t(TM),t(Sl),t(cM),t(xl),t(oM),t(Bl),t(JM),t(dM),t(Dl),t(UM),t(hM),t(Ol),t(yM),t(Vl),t(wM),t(IM),t(jM),t(_l)),t(y),h(A,e),h(Z,e),h(Y,e),h(W,e),h(S,e),h(B,e),h(O,e),h($,e),h(H,e),h(q,e),h(ee,e),h(Me,e),h(se,e),h(ne,e),h(Te,e),h(de,e),h(ye,e),h(re,e),h(ue,e),h(Ze,e),h(Ne,e),h(Le,e),h(De,e),h(Ee,e),h(ze,e),h(Xe,e),h(p,e),h(Pe,e),h(Ke,e),h(el,e),h(ll,e),h(il,e),h(Tl,e),h(Jl,e),h(Il,e),h(jl,e),h(C,e),h(u,e),h(Zl,e),h(Nl,e),h(Ll,e),h(Ql,e),h(Fl,e),h($l,e),h(El,e)}}}const ji='{"title":"Understand caching","local":"understand-caching","sections":[{"title":"File-based caching","local":"file-based-caching","sections":[{"title":"Refs","local":"refs","sections":[],"depth":3},{"title":"Blobs","local":"blobs","sections":[],"depth":3},{"title":"Snapshots","local":"snapshots","sections":[],"depth":3},{"title":".no_exist (advanced)","local":"noexist-advanced","sections":[],"depth":3},{"title":"In practice","local":"in-practice","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"Chunk-based caching (Xet)","local":"chunk-based-caching-xet","sections":[{"title":"chunk_cache","local":"chunkcache","sections":[],"depth":3},{"title":"shard_cache","local":"shardcache","sections":[],"depth":3},{"title":"staging","local":"staging","sections":[],"depth":3},{"title":"Limits and Limitations","local":"limits-and-limitations","sections":[],"depth":3}],"depth":2},{"title":"Caching assets","local":"caching-assets","sections":[{"title":"Assets in practice","local":"assets-in-practice","sections":[],"depth":3}],"depth":2},{"title":"Manage your file-based cache","local":"manage-your-file-based-cache","sections":[{"title":"Scan your cache","local":"scan-your-cache","sections":[],"depth":3},{"title":"Clean your cache","local":"clean-your-cache","sections":[],"depth":3}],"depth":2}],"depth":1}';function fi(r){return Ti(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bi extends ci{constructor(y){super(),oi(this,y,fi,Ii,ni,{})}}export{bi as component};
