import{s as at,o as lt,n as In}from"../chunks/scheduler.6062bdaf.js";import{S as it,i as pt,g as p,s as a,r,A as ct,h as c,f as t,c as l,j as tt,u as g,x as o,k as st,y as ot,a as s,v as u,d as h,t as f,w as d}from"../chunks/index.4bca734e.js";import{T as xn}from"../chunks/Tip.b9ac1f03.js";import{C as _}from"../chunks/CodeBlock.cbbddafc.js";import{H as w,E as rt}from"../chunks/getInferenceSnippets.f1ebb0af.js";function gt($){let i,y='<strong>New:</strong> it is now possible to deploy an Inference Endpoint from the <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">HF model catalog</a> with a simple API call. The catalog is a carefully curated list of models that can be deployed with optimized settings. You don’t need to configure anything, we take all the heavy stuff on us! All models and settings are guaranteed to have been tested to provide best cost/performance balance.  <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint_from_catalog">create_inference_endpoint_from_catalog()</a> works the same as <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>, with much less parameters to pass. You can use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_catalog">list_inference_catalog()</a> to programmatically retrieve the catalog.',m,j,U="Note that this is still an experimental feature. Let us know what you think if you use it!";return{c(){i=p("p"),i.innerHTML=y,m=a(),j=p("p"),j.textContent=U},l(M){i=c(M,"P",{"data-svelte-h":!0}),o(i)!=="svelte-1r7k8zx"&&(i.innerHTML=y),m=l(M),j=c(M,"P",{"data-svelte-h":!0}),o(j)!=="svelte-wky096"&&(j.textContent=U)},m(M,b){s(M,i,b),s(M,m,b),s(M,j,b)},p:In,d(M){M&&(t(i),t(m),t(j))}}}function ut($){let i,y='In this section, we will see methods like <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">delete()</a>. All of those methods are aliases added to <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> for convenience. If you prefer, you can also use the generic methods defined in <code>HfApi</code>: <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a>, and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a>.';return{c(){i=p("p"),i.innerHTML=y},l(m){i=c(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-y1d3wm"&&(i.innerHTML=y)},m(m,j){s(m,i,j)},p:In,d(m){m&&t(i)}}}function ht($){let i,y='An Inference Endpoint that is <em>paused</em> or <em>scaled to zero</em> doesn’t cost anything. The difference between those two is that a <em>paused</em> endpoint needs to be explicitly <em>resumed</em> using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>. On the contrary, a <em>scaled to zero</em> endpoint will automatically start if an inference call is made to it, with an additional cold start delay. An Inference Endpoint can also be configured to scale to zero automatically after a certain period of inactivity.';return{c(){i=p("p"),i.innerHTML=y},l(m){i=c(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-3urxoz"&&(i.innerHTML=y)},m(m,j){s(m,i,j)},p:In,d(m){m&&t(i)}}}function ft($){let i,y="This is a non-revertible action that will completely remove the endpoint, including its configuration, logs and usage metrics. You cannot restore a deleted Inference Endpoint.";return{c(){i=p("p"),i.textContent=y},l(m){i=c(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-lscf4f"&&(i.textContent=y)},m(m,j){s(m,i,j)},p:In,d(m){m&&t(i)}}}function dt($){let i,y,m,j,U,M,b,Tn=`Inference Endpoints provides a secure production solution to easily deploy any <code>transformers</code>, <code>sentence-transformers</code>, and <code>diffusers</code> models on a dedicated and autoscaling infrastructure managed by Hugging Face. An Inference Endpoint is built from a model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a>.
In this guide, we will learn how to programmatically manage Inference Endpoints with <code>huggingface_hub</code>. For more information about the Inference Endpoints product itself, check out its <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">official documentation</a>.`,Ue,C,kn='This guide assumes <code>huggingface_hub</code> is correctly installed and that your machine is logged in. Check out the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#quickstart" rel="nofollow">Quick Start guide</a> if that’s not the case yet. The minimal version supporting Inference Endpoints API is <code>v0.19.0</code>.',xe,x,Ie,E,Te,J,Cn='The first step is to create an Inference Endpoint using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>:',ke,v,Ce,W,En='In this example, we created a <code>protected</code> Inference Endpoint named <code>&quot;my-endpoint-name&quot;</code>, to serve <a href="https://huggingface.co/gpt2" rel="nofollow">gpt2</a> for <code>text-generation</code>. A <code>protected</code> Inference Endpoint means your token is required to access the API. We also need to provide additional information to configure the hardware requirements, such as vendor, region, accelerator, instance type, and size. You can check out the list of available resources <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aprovider/list_vendors" rel="nofollow">here</a>. Alternatively, you can create an Inference Endpoint manually using the <a href="https://ui.endpoints.huggingface.co/new" rel="nofollow">Web interface</a> for convenience. Refer to this <a href="https://huggingface.co/docs/inference-endpoints/guides/advanced" rel="nofollow">guide</a> for details on advanced settings and their usage.',Ee,Z,Jn='The value returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a> is an <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object:',Je,q,ve,A,vn="It’s a dataclass that holds information about the endpoint. You can access important attributes such as <code>name</code>, <code>repository</code>, <code>status</code>, <code>task</code>, <code>created_at</code>, <code>updated_at</code>, etc. If you need it, you can also access the raw response from the server with <code>endpoint.raw</code>.",We,H,Wn='Once your Inference Endpoint is created, you can find it on your <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">personal dashboard</a>.',Ze,Q,Zn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/inference_endpoints_created.png"/>',qe,B,Ae,V,qn='By default the Inference Endpoint is built from a docker image provided by Hugging Face. However, it is possible to specify any docker image using the <code>custom_image</code> parameter. A common use case is to run LLMs using the <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">text-generation-inference</a> framework. This can be done like this:',He,L,Qe,G,An='The value to pass as <code>custom_image</code> is a dictionary containing a url to the docker container and configuration to run it. For more details about it, checkout the <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aendpoint/create_endpoint" rel="nofollow">Swagger documentation</a>.',Be,X,Ve,Y,Hn='In some cases, you might need to manage Inference Endpoints you created previously. If you know the name, you can fetch it using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a>, which returns an <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object. Alternatively, you can use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a> to retrieve a list of all Inference Endpoints. Both methods accept an optional <code>namespace</code> parameter. You can set the <code>namespace</code> to any organization you are a part of. Otherwise, it defaults to your username.',Le,N,Ge,R,Xe,z,Qn='In the rest of this guide, we will assume that we have a <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object called <code>endpoint</code>. You might have noticed that the endpoint has a <code>status</code> attribute of type <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a>. When the Inference Endpoint is deployed and accessible, the status should be <code>&quot;running&quot;</code> and the <code>url</code> attribute is set:',Ye,S,Ne,F,Bn='Before reaching a <code>&quot;running&quot;</code> state, the Inference Endpoint typically goes through an <code>&quot;initializing&quot;</code> or <code>&quot;pending&quot;</code> phase. You can fetch the new state of the endpoint by running <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.fetch">fetch()</a>. Like every other method from <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> that makes a request to the server, the internal attributes of <code>endpoint</code> are mutated in place:',Re,P,ze,K,Vn='Instead of fetching the Inference Endpoint status while waiting for it to run, you can directly call <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.wait">wait()</a>. This helper takes as input a <code>timeout</code> and a <code>fetch_every</code> parameter (in seconds) and will block the thread until the Inference Endpoint is deployed. Default values are respectively <code>None</code> (no timeout) and <code>5</code> seconds.',Se,D,Fe,O,Ln="If <code>timeout</code> is set and the Inference Endpoint takes too much time to load, a <code>InferenceEndpointTimeoutError</code> timeout error is raised.",Pe,ee,Ke,ne,Gn="Once your Inference Endpoint is up and running, you can finally run inference on it!",De,te,Xn='<a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> has two properties <code>client</code> and <code>async_client</code> returning respectively an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> and an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> objects.',Oe,se,en,ae,Yn='If the Inference Endpoint is not running, an <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError">InferenceEndpointError</a> exception is raised:',nn,le,tn,ie,Nn='For more details about how to use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>, check out the <a href="../guides/inference">Inference guide</a>.',sn,pe,an,ce,Rn="Now that we saw how to create an Inference Endpoint and run inference on it, let’s see how to manage its lifecycle.",ln,I,pn,oe,cn,re,zn='To reduce costs when your Inference Endpoint is not in use, you can choose to either pause it using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a> or scale it to zero using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>.',on,T,rn,ge,gn,ue,un,he,Sn='In some cases, you might also want to update your Inference Endpoint without creating a new one. You can either update the hosted model or the hardware requirements to run the model. You can do this using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a>:',hn,fe,fn,de,dn,me,Fn="Finally if you won’t use the Inference Endpoint anymore, you can simply call <code>~InferenceEndpoint.delete()</code>.",mn,k,jn,je,yn,ye,Pn="A typical use case of Inference Endpoints is to process a batch of jobs at once to limit the infrastructure costs. You can automate this process using what we saw in this guide:",Mn,Me,_n,_e,Kn="Or if your Inference Endpoint already exists and is paused:",bn,be,wn,we,$n,$e,Un;return U=new w({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),x=new xn({props:{$$slots:{default:[gt]},$$scope:{ctx:$}}}),E=new w({props:{title:"Create an Inference Endpoint",local:"create-an-inference-endpoint",headingTag:"h2"}}),v=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyaW50ZWwtaWNsJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new _({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),B=new w({props:{title:"Using a custom image",local:"using-a-custom-image",headingTag:"h4"}}),L=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDElMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybnZpZGlhLWExMGclMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running Zephyr-7b-beta on TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)`,wrap:!1}}),X=new w({props:{title:"Get or list existing Inference Endpoints",local:"get-or-list-existing-inference-endpoints",headingTag:"h3"}}),N=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMEElMEFnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMm15LWVuZHBvaW50LW5hbWUlMjIpJTBBJTBBbGlzdF9pbmZlcmVuY2VfZW5kcG9pbnRzKG5hbWVzcGFjZSUzRCUyMmh1Z2dpbmdmYWNlJTIyKSUwQSUwQWxpc3RfaW5mZXJlbmNlX2VuZHBvaW50cyhuYW1lc3BhY2UlM0QlMjIqJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint, list_inference_endpoints

<span class="hljs-comment"># Get one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_inference_endpoint(<span class="hljs-string">&quot;my-endpoint-name&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># List all endpoints from an organization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;huggingface&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]

<span class="hljs-comment"># List all endpoints from all organizations the user belongs to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;*&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]`,wrap:!1}}),R=new w({props:{title:"Check deployment status",local:"check-deployment-status",headingTag:"h2"}}),S=new _({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),P=new _({props:{code:"ZW5kcG9pbnQuZmV0Y2goKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.fetch()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),D=new _({props:{code:"ZW5kcG9pbnQlMEElMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QxMCklMEElMEFlbmRwb2ludC53YWl0KCk=",highlighted:`<span class="hljs-comment"># Pending endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Wait 10s =&gt; raises a InferenceEndpointTimeoutError</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">10</span>)
    <span class="hljs-keyword">raise</span> InferenceEndpointTimeoutError(<span class="hljs-string">&quot;Timeout while waiting for Inference Endpoint to be deployed.&quot;</span>)
huggingface_hub._inference_endpoints.InferenceEndpointTimeoutError: Timeout <span class="hljs-keyword">while</span> waiting <span class="hljs-keyword">for</span> Inference Endpoint to be deployed.

<span class="hljs-comment"># Wait more</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),ee=new w({props:{title:"Run inference",local:"run-inference",headingTag:"h2"}}),se=new _({props:{code:"ZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJJJTIwYW0lMjIpJTBBJTBBYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMkklMjBhbSUyMik=",highlighted:`<span class="hljs-comment"># Run text_generation task:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)
<span class="hljs-string">&#x27; not a fan of the idea of a &quot;big-budget&quot; movie. I think it\\&#x27;s a&#x27;</span>

<span class="hljs-comment"># Or in an asyncio context:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> endpoint.async_client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)`,wrap:!1}}),le=new _({props:{code:"ZW5kcG9pbnQuY2xpZW50",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client\nhuggingface_hub._inference_endpoints.InferenceEndpointError: Cannot create a client <span class="hljs-keyword">for</span> this Inference Endpoint <span class="hljs-keyword">as</span> it <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> yet deployed. Please wait <span class="hljs-keyword">for</span> the Inference Endpoint to be deployed using `endpoint.wait()` <span class="hljs-keyword">and</span> <span class="hljs-keyword">try</span> again.',wrap:!1}}),pe=new w({props:{title:"Manage lifecycle",local:"manage-lifecycle",headingTag:"h2"}}),I=new xn({props:{$$slots:{default:[ut]},$$scope:{ctx:$}}}),oe=new w({props:{title:"Pause or scale to zero",local:"pause-or-scale-to-zero",headingTag:"h3"}}),T=new xn({props:{$$slots:{default:[ht]},$$scope:{ctx:$}}}),ge=new _({props:{code:"ZW5kcG9pbnQucGF1c2UoKSUwQWVuZHBvaW50LnJlc3VtZSgpJTBBZW5kcG9pbnQud2FpdCgpLmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUwQSUwQWVuZHBvaW50LnNjYWxlX3RvX3plcm8oKQ==",highlighted:`<span class="hljs-comment"># Pause and resume endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait().client.text_generation(...)
...

<span class="hljs-comment"># Scale to zero</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.scale_to_zero()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;scaledToZero&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)
<span class="hljs-comment"># Endpoint is not &#x27;running&#x27; but still has a URL and will restart on first call.</span>`,wrap:!1}}),ue=new w({props:{title:"Update model or hardware requirements",local:"update-model-or-hardware-requirements",headingTag:"h3"}}),fe=new _({props:{code:"ZW5kcG9pbnQudXBkYXRlKHJlcG9zaXRvcnklM0QlMjJncHQyLWxhcmdlJTIyKSUwQSUwQWVuZHBvaW50LnVwZGF0ZShtaW5fcmVwbGljYSUzRDIlMkMlMjBtYXhfcmVwbGljYSUzRDYpJTBBJTBBZW5kcG9pbnQudXBkYXRlKGFjY2VsZXJhdG9yJTNEJTIyY3B1JTIyJTJDJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMng0JTIyJTJDJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmludGVsLWljbCUyMik=",highlighted:`<span class="hljs-comment"># Change target model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(repository=<span class="hljs-string">&quot;gpt2-large&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update number of replicas</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(min_replica=<span class="hljs-number">2</span>, max_replica=<span class="hljs-number">6</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update to larger instance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(accelerator=<span class="hljs-string">&quot;cpu&quot;</span>, instance_size=<span class="hljs-string">&quot;x4&quot;</span>, instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),de=new w({props:{title:"Delete the endpoint",local:"delete-the-endpoint",headingTag:"h3"}}),k=new xn({props:{warning:!0,$$slots:{default:[ft]},$$scope:{ctx:$}}}),je=new w({props:{title:"An end-to-end example",local:"an-end-to-end-example",headingTag:"h2"}}),Me=new _({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50KG5hbWUlM0QlMjJiYXRjaC1lbmRwb2ludCUyMiUyQy4uLikud2FpdCgpJTBBJTBBY2xpZW50JTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50JTBBcmVzdWx0cyUyMCUzRCUyMCU1QmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCUwQSUwQWFzeW5jX2NsaWVudCUyMCUzRCUyMGVuZHBvaW50LmFzeW5jX2NsaWVudCUwQXJlc3VsdHMlMjAlM0QlMjBhc3luY2lvLmdhdGhlcigqJTVCYXN5bmNfY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4pJTIwZm9yJTIwam9iJTIwaW4lMjBqb2JzJTVEKSUwQSUwQWVuZHBvaW50LnBhdXNlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-comment"># Start endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(name=<span class="hljs-string">&quot;batch-endpoint&quot;</span>,...).wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = endpoint.client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = [client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs]

<span class="hljs-comment"># Or with asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),be=new _({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMmJhdGNoLWVuZHBvaW50JTIyKS5yZXN1bWUoKS53YWl0KCklMEElMEFhc3luY19jbGllbnQlMjAlM0QlMjBlbmRwb2ludC5hc3luY19jbGllbnQlMEFyZXN1bHRzJTIwJTNEJTIwYXN5bmNpby5nYXRoZXIoKiU1QmFzeW5jX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCklMEElMEFlbmRwb2ludC5wYXVzZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint

<span class="hljs-comment"># Get endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;batch-endpoint&quot;</span>).resume().wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),we=new rt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference_endpoints.md"}}),{c(){i=p("meta"),y=a(),m=p("p"),j=a(),r(U.$$.fragment),M=a(),b=p("p"),b.innerHTML=Tn,Ue=a(),C=p("p"),C.innerHTML=kn,xe=a(),r(x.$$.fragment),Ie=a(),r(E.$$.fragment),Te=a(),J=p("p"),J.innerHTML=Cn,ke=a(),r(v.$$.fragment),Ce=a(),W=p("p"),W.innerHTML=En,Ee=a(),Z=p("p"),Z.innerHTML=Jn,Je=a(),r(q.$$.fragment),ve=a(),A=p("p"),A.innerHTML=vn,We=a(),H=p("p"),H.innerHTML=Wn,Ze=a(),Q=p("p"),Q.innerHTML=Zn,qe=a(),r(B.$$.fragment),Ae=a(),V=p("p"),V.innerHTML=qn,He=a(),r(L.$$.fragment),Qe=a(),G=p("p"),G.innerHTML=An,Be=a(),r(X.$$.fragment),Ve=a(),Y=p("p"),Y.innerHTML=Hn,Le=a(),r(N.$$.fragment),Ge=a(),r(R.$$.fragment),Xe=a(),z=p("p"),z.innerHTML=Qn,Ye=a(),r(S.$$.fragment),Ne=a(),F=p("p"),F.innerHTML=Bn,Re=a(),r(P.$$.fragment),ze=a(),K=p("p"),K.innerHTML=Vn,Se=a(),r(D.$$.fragment),Fe=a(),O=p("p"),O.innerHTML=Ln,Pe=a(),r(ee.$$.fragment),Ke=a(),ne=p("p"),ne.textContent=Gn,De=a(),te=p("p"),te.innerHTML=Xn,Oe=a(),r(se.$$.fragment),en=a(),ae=p("p"),ae.innerHTML=Yn,nn=a(),r(le.$$.fragment),tn=a(),ie=p("p"),ie.innerHTML=Nn,sn=a(),r(pe.$$.fragment),an=a(),ce=p("p"),ce.textContent=Rn,ln=a(),r(I.$$.fragment),pn=a(),r(oe.$$.fragment),cn=a(),re=p("p"),re.innerHTML=zn,on=a(),r(T.$$.fragment),rn=a(),r(ge.$$.fragment),gn=a(),r(ue.$$.fragment),un=a(),he=p("p"),he.innerHTML=Sn,hn=a(),r(fe.$$.fragment),fn=a(),r(de.$$.fragment),dn=a(),me=p("p"),me.innerHTML=Fn,mn=a(),r(k.$$.fragment),jn=a(),r(je.$$.fragment),yn=a(),ye=p("p"),ye.textContent=Pn,Mn=a(),r(Me.$$.fragment),_n=a(),_e=p("p"),_e.textContent=Kn,bn=a(),r(be.$$.fragment),wn=a(),r(we.$$.fragment),$n=a(),$e=p("p"),this.h()},l(e){const n=ct("svelte-u9bgzb",document.head);i=c(n,"META",{name:!0,content:!0}),n.forEach(t),y=l(e),m=c(e,"P",{}),tt(m).forEach(t),j=l(e),g(U.$$.fragment,e),M=l(e),b=c(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-188e6gz"&&(b.innerHTML=Tn),Ue=l(e),C=c(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1ds3okp"&&(C.innerHTML=kn),xe=l(e),g(x.$$.fragment,e),Ie=l(e),g(E.$$.fragment,e),Te=l(e),J=c(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-cqit0a"&&(J.innerHTML=Cn),ke=l(e),g(v.$$.fragment,e),Ce=l(e),W=c(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1stw0yf"&&(W.innerHTML=En),Ee=l(e),Z=c(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1v18sfy"&&(Z.innerHTML=Jn),Je=l(e),g(q.$$.fragment,e),ve=l(e),A=c(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-dxdc75"&&(A.innerHTML=vn),We=l(e),H=c(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1tjw294"&&(H.innerHTML=Wn),Ze=l(e),Q=c(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1tajtyl"&&(Q.innerHTML=Zn),qe=l(e),g(B.$$.fragment,e),Ae=l(e),V=c(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-j6tvxe"&&(V.innerHTML=qn),He=l(e),g(L.$$.fragment,e),Qe=l(e),G=c(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-33b9op"&&(G.innerHTML=An),Be=l(e),g(X.$$.fragment,e),Ve=l(e),Y=c(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1w1xfgf"&&(Y.innerHTML=Hn),Le=l(e),g(N.$$.fragment,e),Ge=l(e),g(R.$$.fragment,e),Xe=l(e),z=c(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-y5xy0k"&&(z.innerHTML=Qn),Ye=l(e),g(S.$$.fragment,e),Ne=l(e),F=c(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-13dlhqv"&&(F.innerHTML=Bn),Re=l(e),g(P.$$.fragment,e),ze=l(e),K=c(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-qtkg7n"&&(K.innerHTML=Vn),Se=l(e),g(D.$$.fragment,e),Fe=l(e),O=c(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1g2lxsg"&&(O.innerHTML=Ln),Pe=l(e),g(ee.$$.fragment,e),Ke=l(e),ne=c(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-un9pgy"&&(ne.textContent=Gn),De=l(e),te=c(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-kz23iw"&&(te.innerHTML=Xn),Oe=l(e),g(se.$$.fragment,e),en=l(e),ae=c(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1p192s5"&&(ae.innerHTML=Yn),nn=l(e),g(le.$$.fragment,e),tn=l(e),ie=c(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-ruirtr"&&(ie.innerHTML=Nn),sn=l(e),g(pe.$$.fragment,e),an=l(e),ce=c(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-16mqpnz"&&(ce.textContent=Rn),ln=l(e),g(I.$$.fragment,e),pn=l(e),g(oe.$$.fragment,e),cn=l(e),re=c(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-iiep7b"&&(re.innerHTML=zn),on=l(e),g(T.$$.fragment,e),rn=l(e),g(ge.$$.fragment,e),gn=l(e),g(ue.$$.fragment,e),un=l(e),he=c(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1s19g4k"&&(he.innerHTML=Sn),hn=l(e),g(fe.$$.fragment,e),fn=l(e),g(de.$$.fragment,e),dn=l(e),me=c(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1j2n6pp"&&(me.innerHTML=Fn),mn=l(e),g(k.$$.fragment,e),jn=l(e),g(je.$$.fragment,e),yn=l(e),ye=c(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-r11tzs"&&(ye.textContent=Pn),Mn=l(e),g(Me.$$.fragment,e),_n=l(e),_e=c(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-u5cd5i"&&(_e.textContent=Kn),bn=l(e),g(be.$$.fragment,e),wn=l(e),g(we.$$.fragment,e),$n=l(e),$e=c(e,"P",{}),tt($e).forEach(t),this.h()},h(){st(i,"name","hf:doc:metadata"),st(i,"content",mt)},m(e,n){ot(document.head,i),s(e,y,n),s(e,m,n),s(e,j,n),u(U,e,n),s(e,M,n),s(e,b,n),s(e,Ue,n),s(e,C,n),s(e,xe,n),u(x,e,n),s(e,Ie,n),u(E,e,n),s(e,Te,n),s(e,J,n),s(e,ke,n),u(v,e,n),s(e,Ce,n),s(e,W,n),s(e,Ee,n),s(e,Z,n),s(e,Je,n),u(q,e,n),s(e,ve,n),s(e,A,n),s(e,We,n),s(e,H,n),s(e,Ze,n),s(e,Q,n),s(e,qe,n),u(B,e,n),s(e,Ae,n),s(e,V,n),s(e,He,n),u(L,e,n),s(e,Qe,n),s(e,G,n),s(e,Be,n),u(X,e,n),s(e,Ve,n),s(e,Y,n),s(e,Le,n),u(N,e,n),s(e,Ge,n),u(R,e,n),s(e,Xe,n),s(e,z,n),s(e,Ye,n),u(S,e,n),s(e,Ne,n),s(e,F,n),s(e,Re,n),u(P,e,n),s(e,ze,n),s(e,K,n),s(e,Se,n),u(D,e,n),s(e,Fe,n),s(e,O,n),s(e,Pe,n),u(ee,e,n),s(e,Ke,n),s(e,ne,n),s(e,De,n),s(e,te,n),s(e,Oe,n),u(se,e,n),s(e,en,n),s(e,ae,n),s(e,nn,n),u(le,e,n),s(e,tn,n),s(e,ie,n),s(e,sn,n),u(pe,e,n),s(e,an,n),s(e,ce,n),s(e,ln,n),u(I,e,n),s(e,pn,n),u(oe,e,n),s(e,cn,n),s(e,re,n),s(e,on,n),u(T,e,n),s(e,rn,n),u(ge,e,n),s(e,gn,n),u(ue,e,n),s(e,un,n),s(e,he,n),s(e,hn,n),u(fe,e,n),s(e,fn,n),u(de,e,n),s(e,dn,n),s(e,me,n),s(e,mn,n),u(k,e,n),s(e,jn,n),u(je,e,n),s(e,yn,n),s(e,ye,n),s(e,Mn,n),u(Me,e,n),s(e,_n,n),s(e,_e,n),s(e,bn,n),u(be,e,n),s(e,wn,n),u(we,e,n),s(e,$n,n),s(e,$e,n),Un=!0},p(e,[n]){const Dn={};n&2&&(Dn.$$scope={dirty:n,ctx:e}),x.$set(Dn);const On={};n&2&&(On.$$scope={dirty:n,ctx:e}),I.$set(On);const et={};n&2&&(et.$$scope={dirty:n,ctx:e}),T.$set(et);const nt={};n&2&&(nt.$$scope={dirty:n,ctx:e}),k.$set(nt)},i(e){Un||(h(U.$$.fragment,e),h(x.$$.fragment,e),h(E.$$.fragment,e),h(v.$$.fragment,e),h(q.$$.fragment,e),h(B.$$.fragment,e),h(L.$$.fragment,e),h(X.$$.fragment,e),h(N.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(pe.$$.fragment,e),h(I.$$.fragment,e),h(oe.$$.fragment,e),h(T.$$.fragment,e),h(ge.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(de.$$.fragment,e),h(k.$$.fragment,e),h(je.$$.fragment,e),h(Me.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),Un=!0)},o(e){f(U.$$.fragment,e),f(x.$$.fragment,e),f(E.$$.fragment,e),f(v.$$.fragment,e),f(q.$$.fragment,e),f(B.$$.fragment,e),f(L.$$.fragment,e),f(X.$$.fragment,e),f(N.$$.fragment,e),f(R.$$.fragment,e),f(S.$$.fragment,e),f(P.$$.fragment,e),f(D.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),f(le.$$.fragment,e),f(pe.$$.fragment,e),f(I.$$.fragment,e),f(oe.$$.fragment,e),f(T.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(de.$$.fragment,e),f(k.$$.fragment,e),f(je.$$.fragment,e),f(Me.$$.fragment,e),f(be.$$.fragment,e),f(we.$$.fragment,e),Un=!1},d(e){e&&(t(y),t(m),t(j),t(M),t(b),t(Ue),t(C),t(xe),t(Ie),t(Te),t(J),t(ke),t(Ce),t(W),t(Ee),t(Z),t(Je),t(ve),t(A),t(We),t(H),t(Ze),t(Q),t(qe),t(Ae),t(V),t(He),t(Qe),t(G),t(Be),t(Ve),t(Y),t(Le),t(Ge),t(Xe),t(z),t(Ye),t(Ne),t(F),t(Re),t(ze),t(K),t(Se),t(Fe),t(O),t(Pe),t(Ke),t(ne),t(De),t(te),t(Oe),t(en),t(ae),t(nn),t(tn),t(ie),t(sn),t(an),t(ce),t(ln),t(pn),t(cn),t(re),t(on),t(rn),t(gn),t(un),t(he),t(hn),t(fn),t(dn),t(me),t(mn),t(jn),t(yn),t(ye),t(Mn),t(_n),t(_e),t(bn),t(wn),t($n),t($e)),t(i),d(U,e),d(x,e),d(E,e),d(v,e),d(q,e),d(B,e),d(L,e),d(X,e),d(N,e),d(R,e),d(S,e),d(P,e),d(D,e),d(ee,e),d(se,e),d(le,e),d(pe,e),d(I,e),d(oe,e),d(T,e),d(ge,e),d(ue,e),d(fe,e),d(de,e),d(k,e),d(je,e),d(Me,e),d(be,e),d(we,e)}}}const mt='{"title":"Inference Endpoints","local":"inference-endpoints","sections":[{"title":"Create an Inference Endpoint","local":"create-an-inference-endpoint","sections":[{"title":"Using a custom image","local":"using-a-custom-image","sections":[],"depth":4},{"title":"Get or list existing Inference Endpoints","local":"get-or-list-existing-inference-endpoints","sections":[],"depth":3}],"depth":2},{"title":"Check deployment status","local":"check-deployment-status","sections":[],"depth":2},{"title":"Run inference","local":"run-inference","sections":[],"depth":2},{"title":"Manage lifecycle","local":"manage-lifecycle","sections":[{"title":"Pause or scale to zero","local":"pause-or-scale-to-zero","sections":[],"depth":3},{"title":"Update model or hardware requirements","local":"update-model-or-hardware-requirements","sections":[],"depth":3},{"title":"Delete the endpoint","local":"delete-the-endpoint","sections":[],"depth":3}],"depth":2},{"title":"An end-to-end example","local":"an-end-to-end-example","sections":[],"depth":2}],"depth":1}';function jt($){return lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $t extends it{constructor(i){super(),pt(this,i,jt,dt,at,{})}}export{$t as component};
