import{s as B0,o as X0,n as H}from"../chunks/scheduler.6062bdaf.js";import{S as Y0,i as z0,g as c,s,r as h,A as Q0,h as l,f as p,c as r,j as q,u as f,x as d,k as M,y as n,a as $,v as m,d as _,t as b,w as y,m as O0,n as K0}from"../chunks/index.4bca734e.js";import{T as I}from"../chunks/Tip.b9ac1f03.js";import{D as j}from"../chunks/Docstring.7569aaac.js";import{C}from"../chunks/CodeBlock.cbbddafc.js";import{E as U}from"../chunks/ExampleCodeBlock.8f8485cb.js";import{H as R,E as eq}from"../chunks/getInferenceSnippets.f1ebb0af.js";function tq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGFkZF9jb2xsZWN0aW9uX2l0ZW0lMEFjb2xsZWN0aW9uJTIwJTNEJTIwYWRkX2NvbGxlY3Rpb25faXRlbSglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX3NsdWclM0QlMjJkYXZhbnN0cmllbiUyRmNsaW1hdGUtNjRmOTlkYzJhNTA2N2Y2YjY1NTMxYmFiJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXRlbV9pZCUzRCUyMnBpZXJyZS1sb2ljJTJGY2xpbWF0ZS1uZXdzLWFydGljbGVzJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXRlbV90eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFjb2xsZWN0aW9uLml0ZW1zJTVCLTElNUQuaXRlbV9pZCUwQSUwQWFkZF9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyZGF2YW5zdHJpZW4lMkZjbGltYXRlLTY0Zjk5ZGMyYTUwNjdmNmI2NTUzMWJhYiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1faWQlM0QlMjJkYXRhc2V0cyUyRmNsaW1hdGVfZmV2ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBpdGVtX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTBBJTIwJTIwJTIwJTIwbm90ZSUzRCUyMlRoaXMlMjBkYXRhc2V0JTIwYWRvcHRzJTIwdGhlJTIwRkVWRVIlMjBtZXRob2RvbG9neSUyMHRoYXQlMjBjb25zaXN0cyUyMG9mJTIwMSUyQzUzNSUyMHJlYWwtd29ybGQlMjBjbGFpbXMlMjByZWdhcmRpbmclMjBjbGltYXRlLWNoYW5nZSUyMGNvbGxlY3RlZCUyMG9uJTIwdGhlJTIwaW50ZXJuZXQuJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> add_collection_item
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = add_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;davanstrien/climate-64f99dc2a5067f6b65531bab&quot;</span>,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;pierre-loic/climate-news-articles&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[-<span class="hljs-number">1</span>].item_id
<span class="hljs-string">&quot;pierre-loic/climate-news-articles&quot;</span>
<span class="hljs-comment"># ^item got added to the collection on last position</span>

<span class="hljs-comment"># Add item with a note</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;davanstrien/climate-64f99dc2a5067f6b65531bab&quot;</span>,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;datasets/climate_fever&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;This dataset adopts the FEVER methodology that consists of 1,535 real-world claims regarding climate-change collected on the internet.&quot;</span>
<span class="hljs-meta">... </span>)
(...)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function nq(T){let o,u="Check if the user has access to a repository:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGF1dGhfY2hlY2slMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnV0aWxzJTIwaW1wb3J0JTIwR2F0ZWRSZXBvRXJyb3IlMkMlMjBSZXBvc2l0b3J5Tm90Rm91bmRFcnJvciUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> auth_check
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.utils <span class="hljs-keyword">import</span> GatedRepoError, RepositoryNotFoundError

<span class="hljs-keyword">try</span>:
    auth_check(<span class="hljs-string">&quot;user/my-cool-model&quot;</span>)
<span class="hljs-keyword">except</span> GatedRepoError:
    <span class="hljs-comment"># Handle gated repository error</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;You do not have permission to access this gated repository.&quot;</span>)
<span class="hljs-keyword">except</span> RepositoryNotFoundError:
    <span class="hljs-comment"># Handle repository not found error</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The repository was not found or you do not have access.&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-12u7bhh"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function oq(T){let o,u="Examples:",i,a,g;return a=new C({props:{code:"bmV3X3RpdGxlJTIwJTNEJTIwJTIyTmV3JTIwdGl0bGUlMkMlMjBmaXhpbmclMjBhJTIwdHlwbyUyMiUwQUhmQXBpKCkucmVuYW1lX2Rpc2N1c3Npb24oJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGcmVwb19uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QzNCUwQSUyMCUyMCUyMCUyMG5ld190aXRsZSUzRG5ld190aXRsZSUwQSklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>new_title = <span class="hljs-string">&quot;New title, fixing a typo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().rename_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    new_title=new_title
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionStatusChange(id=&#x27;deadbeef0000000&#x27;, type=&#x27;status-change&#x27;, ...)</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function aq(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function sq(T){let o,u="Examples:",i,a,g;return a=new C({props:{code:"JTBBY29tbWVudCUyMCUzRCUyMCUyMiUyMiUyMiUwQUhlbGxvJTIwJTQwb3RoZXJ1c2VyISUwQSUyMyUyMFRoaXMlMjBpcyUyMGElMjB0aXRsZSUwQSoqVGhpcyUyMGlzJTIwYm9sZCoqJTJDJTIwKnRoaXMlMjBpcyUyMGl0YWxpYyolMjBhbmQlMjB+dGhpcyUyMGlzJTIwc3RyaWtldGhyb3VnaH4lMEFBbmQlMjAlNUJ0aGlzJTVEKGh0dHAlM0ElMkYlMkZ1cmwpJTIwaXMlMjBhJTIwbGluayUwQSUyMiUyMiUyMiUwQSUwQUhmQXBpKCkuY29tbWVudF9kaXNjdXNzaW9uKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRnJlcG9fbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRpc2N1c3Npb25fbnVtJTNEMzQlMEElMjAlMjAlMjAlMjBjb21tZW50JTNEY29tbWVudCUwQSklMEE=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span>comment = <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>Hello @otheruser!
...
<span class="hljs-meta">... </span># This is a title
...
<span class="hljs-meta">... </span>**This is bold**, *this is italic* and ~this is strikethrough~
<span class="hljs-meta">... </span>And [this](http://url) is a link
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().comment_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    comment=comment
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionComment(id=&#x27;deadbeef0000000&#x27;, type=&#x27;comment&#x27;, ...)</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function rq(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function iq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNyZWF0ZV9jb2xsZWN0aW9uKCUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlBvcnRmb2xpbyUyMG9mJTIwbW9kZWxzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwMjAyMyUyMiUyQyUwQSklMEFjb2xsZWN0aW9uLnNsdWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = create_collection(
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, papers and demos I presented at ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;username/iccv-2023-64f9a55bb3115b4f513ec026&quot;</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function cq(T){let o,u=`The input list of <code>CommitOperation</code> will be mutated during the commit process. Do not reuse the same objects
for multiple commits.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1i3qk8u"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function lq(T){let o,u=`<code>create_commit</code> assumes that the repo already exists on the Hub. If you get a
Client error 404, please make sure you are authenticated and that <code>repo_id</code> and
<code>repo_type</code> are set correctly. If repo does not exist, create it first using
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-f4qclq"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function pq(T){let o,u="<code>create_commit</code> is limited to 25k LFS files and a 1GB payload for regular files.";return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-yun5lq"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function dq(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function gq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyaW50ZWwtaWNsJTIyJTJDJTBBKSUwQWVuZHBvaW50JTBBJTBBZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, status=<span class="hljs-string">&quot;pending&quot;</span>,...)

<span class="hljs-comment"># Run inference on the endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(...)
<span class="hljs-string">&quot;...&quot;</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function uq(T){let o,u;return o=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDElMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybnZpZGlhLWExMGclMjIlMkMlMEElMjAlMjAlMjAlMjBlbnYlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9pbWFnZSUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlYWx0aF9yb3V0ZSUyMiUzQSUyMCUyMiUyRmhlYWx0aCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMHNlY3JldHMlM0QlN0IlMjJNWV9TRUNSRVRfS0VZJTIyJTNBJTIwJTIyc2VjcmV0X3ZhbHVlJTIyJTdEJTJDJTBBJTIwJTIwJTIwdGFncyUzRCU1QiUyMmRldiUyMiUyQyUyMCUyMnRleHQtZ2VuZXJhdGlvbiUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running Zephyr-7b-beta on TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
<span class="hljs-meta">... </span>    env={
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>          <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>   secrets={<span class="hljs-string">&quot;MY_SECRET_KEY&quot;</span>: <span class="hljs-string">&quot;secret_value&quot;</span>},
<span class="hljs-meta">... </span>   tags=[<span class="hljs-string">&quot;dev&quot;</span>, <span class="hljs-string">&quot;text-generation&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){h(o.$$.fragment)},l(i){f(o.$$.fragment,i)},m(i,a){m(o,i,a),u=!0},p:H,i(i){u||(_(o.$$.fragment,i),u=!0)},o(i){b(o.$$.fragment,i),u=!1},d(i){y(o,i)}}}function hq(T){let o,u;return o=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyZmluYmVydC1jbGFzc2lmaWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb3NpdG9yeSUzRCUyMlByb3N1c0FJJTJGZmluYmVydCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZyYW1ld29yayUzRCUyMnB5dG9yY2glMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrJTNEJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1pbl9yZXBsaWNhJTNEMCUyQyUwQSUyMCUyMCUyMCUyMHNjYWxlX3RvX3plcm9fdGltZW91dCUzRDE1JTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IlM0QlMjJjcHUlMjIlMkMlMEElMjAlMjAlMjAlMjB2ZW5kb3IlM0QlMjJhd3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZWdpb24lM0QlMjJ1cy1lYXN0LTElMjIlMkMlMEElMjAlMjAlMjAlMjB0eXBlJTNEJTIycHJvdGVjdGVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMngyJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmludGVsLWljbCUyMiUyQyUwQSklMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QzMDApJTBBZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4p",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running ProsusAI/finbert while scaling to zero in 15 minutes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;finbert-classifier&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;ProsusAI/finbert&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-classification&quot;</span>,
<span class="hljs-meta">... </span>    min_replica=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    scale_to_zero_timeout=<span class="hljs-number">15</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">300</span>)
<span class="hljs-comment"># Run inference on the endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(...)
TextClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.8983615040779114</span>)`,wrap:!1}}),{c(){h(o.$$.fragment)},l(i){f(o.$$.fragment,i)},m(i,a){m(o,i,a),u=!0},p:H,i(i){u||(_(o.$$.fragment,i),u=!0)},o(i){b(o.$$.fragment,i),u=!1},d(i){y(o,i)}}}function fq(T){let o,u=`<code>create_inference_endpoint_from_catalog</code> is experimental. Its API is subject to change in the future. Please provide feedback
if you have any suggestions or requests.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1bm6hf4"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function mq(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function _q(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV93ZWJob29rJTBBcGF5bG9hZCUyMCUzRCUyMGNyZWF0ZV93ZWJob29rKCUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJqdWxpZW4tYyUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIySHVnZ2luZ0ZhY2VINCUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRCUyMmh0dHBzJTNBJTJGJTJGd2ViaG9vay5zaXRlJTJGYTIxNzZlODItNTcyMC00M2VlLTllMDYtZjkxY2I0YzkxNTQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwZG9tYWlucyUzRCU1QiUyMnJlcG8lMjIlMkMlMjAlMjJkaXNjdXNzaW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIybXktc2VjcmV0JTIyJTJDJTBBKSUwQXByaW50KHBheWxvYWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>payload = create_webhook(
<span class="hljs-meta">... </span>    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;julien-c&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HuggingFaceH4&quot;</span>}],
<span class="hljs-meta">... </span>    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
<span class="hljs-meta">... </span>    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
<span class="hljs-meta">... </span>    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(payload)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function bq(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function yq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRlbGV0ZV9jb2xsZWN0aW9uKCUyMnVzZXJuYW1lJTJGdXNlbGVzcy1jb2xsZWN0aW9uLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUyMG1pc3Npbmdfb2slM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = delete_collection(<span class="hljs-string">&quot;username/useless-collection-64f9a55bb3115b4f513ec026&quot;</span>, missing_ok=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function vq(T){let o,u="This is a non-revertible action. A deleted collection cannot be restored.";return{c(){o=c("p"),o.textContent=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1k7dttx"&&(o.textContent=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function xq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwZGVsZXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBnZXRfY29sbGVjdGlvbiglMjJUaGVCbG9rZSUyRnJlY2VudC1tb2RlbHMtNjRmOWE1NWJiMzExNWI0ZjUxM2VjMDI2JTIyKSUwQSUwQWRlbGV0ZV9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyVGhlQmxva2UlMkZyZWNlbnQtbW9kZWxzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1Qi0xJTVELml0ZW1fb2JqZWN0X2lkJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, delete_collection_item

<span class="hljs-comment"># Get collection first</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)

<span class="hljs-comment"># Delete item based on its ID</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    item_object_id=collection.items[-<span class="hljs-number">1</span>].item_object_id,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function $q(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError">EntryNotFoundError</a>
If the file to download cannot be found.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1hfnpzg"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function wq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV93ZWJob29rJTBBZGVsZXRlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function kq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRpc2FibGVfd2ViaG9vayUwQWRpc2FibGVkX3dlYmhvb2slMjAlM0QlMjBkaXNhYmxlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKSUwQWRpc2FibGVkX3dlYmhvb2s=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> disable_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>disabled_webhook = disable_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>disabled_webhook
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Tq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGR1cGxpY2F0ZV9zcGFjZSUwQSUwQWR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMiklMEElMEFkdXBsaWNhdGVfc3BhY2UoJTIybXVsdGltb2RhbGFydCUyRmRyZWFtYm9vdGgtdHJhaW5pbmclMjIlMkMlMjB0b19pZCUzRCUyMm15LWRyZWFtYm9vdGglMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> duplicate_space

<span class="hljs-comment"># Duplicate a Space to your account</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/dreambooth-training&#x27;</span>,...)

<span class="hljs-comment"># Can set custom destination id and visibility flag.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>, to_id=<span class="hljs-string">&quot;my-dreambooth&quot;</span>, private=<span class="hljs-literal">True</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/my-dreambooth&#x27;</span>,...)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function qq(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function Mq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGVuYWJsZV93ZWJob29rJTBBZW5hYmxlZF93ZWJob29rJTIwJTNEJTIwZW5hYmxlX3dlYmhvb2soJTIyNjU0YmJiYzE2ZjJlYzE0ZDc3ZjEwOWNjJTIyKSUwQWVuYWJsZWRfd2ViaG9vaw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> enable_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>enabled_webhook = enable_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>enabled_webhook
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function jq(T){let o,u="Examples:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGZpbGVfZXhpc3RzJTBBZmlsZV9leGlzdHMoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMCUyMmNvbmZpZy5qc29uJTIyKSUwQWZpbGVfZXhpc3RzKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIlMjIlMkMlMjAlMjJub3QtYS1maWxlJTIyKSUwQWZpbGVfZXhpc3RzKCUyMmJpZ2NvZGUlMkZub3QtYS1yZXBvJTIyJTJDJTIwJTIyY29uZmlnLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> file_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, <span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, <span class="hljs-string">&quot;not-a-file&quot;</span>)
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_exists(<span class="hljs-string">&quot;bigcode/not-a-repo&quot;</span>, <span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Hq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKCUyMlRoZUJsb2tlJTJGcmVjZW50LW1vZGVscy02NGY5YTU1YmIzMTE1YjRmNTEzZWMwMjYlMjIpJTBBY29sbGVjdGlvbi50aXRsZSUwQWxlbihjb2xsZWN0aW9uLml0ZW1zKSUwQWNvbGxlY3Rpb24uaXRlbXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.title
<span class="hljs-string">&#x27;Recent models&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(collection.items)
<span class="hljs-number">37</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[<span class="hljs-number">0</span>]
CollectionItem(
    item_object_id=<span class="hljs-string">&#x27;651446103cd773a050bf64c2&#x27;</span>,
    item_id=<span class="hljs-string">&#x27;TheBloke/U-Amethyst-20B-AWQ&#x27;</span>,
    item_type=<span class="hljs-string">&#x27;model&#x27;</span>,
    position=<span class="hljs-number">88</span>,
    note=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Cq(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function Uq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWVuZHBvaW50JTIwJTNEJTIwYXBpLmdldF9pbmZlcmVuY2VfZW5kcG9pbnQoJTIybXktdGV4dC10by1pbWFnZSUyMiklMEFlbmRwb2ludCUwQSUwQWVuZHBvaW50LnN0YXR1cyUwQWVuZHBvaW50LnVybCUwQSUwQWVuZHBvaW50LmNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = api.get_inference_endpoint(<span class="hljs-string">&quot;my-text-to-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-text-to-image&#x27;</span>, ...)

<span class="hljs-comment"># Get status</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.status
<span class="hljs-string">&#x27;running&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.url
<span class="hljs-string">&#x27;https://my-text-to-image.region.vendor.endpoints.huggingface.cloud&#x27;</span>

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Iq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9wYXRoc19pbmZvJTBBcGF0aHNfaW5mbyUyMCUzRCUyMGdldF9wYXRoc19pbmZvKCUyMmFsbGVuYWklMkZjNCUyMiUyQyUyMCU1QiUyMlJFQURNRS5tZCUyMiUyQyUyMCUyMmVuJTIyJTVEJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiklMEFwYXRoc19pbmZv",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_paths_info
<span class="hljs-meta">&gt;&gt;&gt; </span>paths_info = get_paths_info(<span class="hljs-string">&quot;allenai/c4&quot;</span>, [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>], repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>paths_info
[
    RepoFile(path=<span class="hljs-string">&#x27;README.md&#x27;</span>, size=<span class="hljs-number">2379</span>, blob_id=<span class="hljs-string">&#x27;f84cb4c97182890fc1dbdeaf1a6a468fd27b4fff&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFolder(path=<span class="hljs-string">&#x27;en&#x27;</span>, tree_id=<span class="hljs-string">&#x27;dc943c4c40f53d02b31ced1defa7e5f438d5862e&#x27;</span>, last_commit=<span class="hljs-literal">None</span>)
]`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Aq(T){let o,u="Collecting all discussions of a repo in a list:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZGlzY3Vzc2lvbnNfbGlzdCUyMCUzRCUyMGxpc3QoZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span>discussions_list = <span class="hljs-built_in">list</span>(get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>))`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1p6axsk"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Nq(T){let o,u="Iterating over discussions of a repo:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZm9yJTIwZGlzY3Vzc2lvbiUyMGluJTIwZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRpc2N1c3Npb24ubnVtJTJDJTIwZGlzY3Vzc2lvbi50aXRsZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> discussion <span class="hljs-keyword">in</span> get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(discussion.num, discussion.title)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-121l6g4"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Jq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"bWV0YWRhdGElMjAlM0QlMjBnZXRfc2FmZXRlbnNvcnNfbWV0YWRhdGEoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKSUwQW1ldGFkYXRhJTBBbWV0YWRhdGEuZmlsZXNfbWV0YWRhdGElNUIlMjJtb2RlbC5zYWZldGVuc29ycyUyMiU1RC5tZXRhZGF0YSUwQSUwQW1ldGFkYXRhJTIwJTNEJTIwZ2V0X3NhZmV0ZW5zb3JzX21ldGFkYXRhKCUyMmJpZ3NjaWVuY2UlMkZibG9vbSUyMiklMEFtZXRhZGF0YSUwQWxlbihtZXRhZGF0YS5maWxlc19tZXRhZGF0YSklMEElMEFnZXRfc2FmZXRlbnNvcnNfbWV0YWRhdGEoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIp",highlighted:`<span class="hljs-comment"># Parse repo with single weights file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = get_safetensors_metadata(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata
SafetensorsRepoMetadata(
    metadata=<span class="hljs-literal">None</span>,
    sharded=<span class="hljs-literal">False</span>,
    weight_map={<span class="hljs-string">&#x27;h.0.input_layernorm.bias&#x27;</span>: <span class="hljs-string">&#x27;model.safetensors&#x27;</span>, ...},
    files_metadata={<span class="hljs-string">&#x27;model.safetensors&#x27;</span>: SafetensorsFileMetadata(...)}
)
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata.files_metadata[<span class="hljs-string">&quot;model.safetensors&quot;</span>].metadata
{<span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;pt&#x27;</span>}

<span class="hljs-comment"># Parse repo with sharded model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = get_safetensors_metadata(<span class="hljs-string">&quot;bigscience/bloom&quot;</span>)
Parse safetensors files: <span class="hljs-number">100</span>%|██████████████████████████████████████████| <span class="hljs-number">72</span>/<span class="hljs-number">72</span> [<span class="hljs-number">00</span>:<span class="hljs-number">12</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">5.78</span>it/s]
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata
SafetensorsRepoMetadata(metadata={<span class="hljs-string">&#x27;total_size&#x27;</span>: <span class="hljs-number">352494542848</span>}, sharded=<span class="hljs-literal">True</span>, weight_map={...}, files_metadata={...})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(metadata.files_metadata)
<span class="hljs-number">72</span>  <span class="hljs-comment"># All safetensors files have been fetched</span>

<span class="hljs-comment"># Parse repo with sharded model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_safetensors_metadata(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
NotASafetensorsRepoError: <span class="hljs-string">&#x27;runwayml/stable-diffusion-v1-5&#x27;</span> <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> a safetensors repo. Couldn<span class="hljs-string">&#x27;t find &#x27;</span>model.safetensors.index.json<span class="hljs-string">&#x27; or &#x27;</span>model.safetensors<span class="hljs-string">&#x27; files.</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Eq(T){let o,u=`This method is deprecated and will be removed in version 1.0. Permissions are more complex than when
<code>get_token_permission</code> was first introduced. OAuth and fine-grain tokens allows for more detailed permissions.
If you need to know the permissions associated with a token, please use <code>whoami</code> and check the <code>&#39;auth&#39;</code> key.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1uyfywd"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Dq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF93ZWJob29rJTBBd2ViaG9vayUyMCUzRCUyMGdldF93ZWJob29rKCUyMjY1NGJiYmMxNmYyZWMxNGQ3N2YxMDljYyUyMiklMEFwcmludCh3ZWJob29rKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>webhook = get_webhook(<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(webhook)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Rq(T){let o,u;return o=new C({props:{code:"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",highlighted:`<span class="hljs-selector-attr">[  96]</span>  .
└── <span class="hljs-selector-attr">[ 160]</span>  models<span class="hljs-attr">--julien-c--EsperBERTo-small</span>
    ├── <span class="hljs-selector-attr">[ 160]</span>  blobs
    │   ├── <span class="hljs-selector-attr">[321M]</span>  <span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
    │   ├── <span class="hljs-selector-attr">[ 398]</span>  <span class="hljs-number">7</span>cb18dc9bafbfcf74629a4b760af1b160957a83e
    │   └── <span class="hljs-selector-attr">[1.4K]</span>  d7edf6bd2a681fb0175f7735299831ee1b22b812
    ├── <span class="hljs-selector-attr">[  96]</span>  refs
    │   └── <span class="hljs-selector-attr">[  40]</span>  <span class="hljs-selector-tag">main</span>
    └── <span class="hljs-selector-attr">[ 128]</span>  snapshots
        ├── <span class="hljs-selector-attr">[ 128]</span>  <span class="hljs-number">2439</span>f60ef33a0d46d85da5001d52aeda5b00ce9f
        │   ├── <span class="hljs-selector-attr">[  52]</span>  README<span class="hljs-selector-class">.md</span> -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
        │   └── <span class="hljs-selector-attr">[  76]</span>  pytorch_model<span class="hljs-selector-class">.bin</span> -&gt; ../../blobs/<span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        └── <span class="hljs-selector-attr">[ 128]</span>  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
            ├── <span class="hljs-selector-attr">[  52]</span>  README<span class="hljs-selector-class">.md</span> -&gt; ../../blobs/<span class="hljs-number">7</span>cb18dc9bafbfcf74629a4b760af1b160957a83e
            └── <span class="hljs-selector-attr">[  76]</span>  pytorch_model<span class="hljs-selector-class">.bin</span> -&gt; ../../blobs/<span class="hljs-number">403450</span>e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),{c(){h(o.$$.fragment)},l(i){f(o.$$.fragment,i)},m(i,a){m(o,i,a),u=!0},p:H,i(i){u||(_(o.$$.fragment,i),u=!0)},o(i){b(o.$$.fragment,i),u=!1},d(i){y(o,i)}}}function Fq(T){let o;return{c(){o=O0("Hidden comments' content cannot be retrieved anymore. Hiding a comment is irreversible.")},l(u){o=K0(u,"Hidden comments' content cannot be retrieved anymore. Hiding a comment is irreversible.")},m(u,i){$(u,o,i)},d(u){u&&p(o)}}}function Gq(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function Sq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfYWNjZXB0ZWRfYWNjZXNzX3JlcXVlc3RzJTBBJTBBcmVxdWVzdHMlMjAlM0QlMjBsaXN0X2FjY2VwdGVkX2FjY2Vzc19yZXF1ZXN0cyglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiklMEFsZW4ocmVxdWVzdHMpJTBBcmVxdWVzdHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_accepted_access_requests

<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_accepted_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;accepted&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Lq(T){let o,u=`When listing collections, the item list per collection is truncated to 4 items maximum. To retrieve all items
from a collection, you must use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_collection">get_collection()</a>.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-m77nml"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Zq(T){let o,u="Example usage with the <code>filter</code> argument:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKCklMEElMEElMEFhcGkubGlzdF9kYXRhc2V0cyhmaWx0ZXIlM0QlMjJ0YXNrX2NhdGVnb3JpZXMlM0F0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKCUwQSUyMCUyMCUyMCUyMGZpbHRlciUzRCglMjJsYW5ndWFnZSUzQXJ1JTIyJTJDJTIwJTIydGFza19pZHMlM0FsYW5ndWFnZS1tb2RlbGluZyUyMiklMEEpJTBBJTBBYXBpLmxpc3RfZGF0YXNldHModGFncyUzRCUyMmZpZnR5b25lJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all datasets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets()


<span class="hljs-comment"># List only the text classification datasets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;task_categories:text-classification&quot;</span>)


<span class="hljs-comment"># List only the datasets in russian for language modeling</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">filter</span>=(<span class="hljs-string">&quot;language:ru&quot;</span>, <span class="hljs-string">&quot;task_ids:language-modeling&quot;</span>)
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># List FiftyOne datasets (identified by the tag &quot;fiftyone&quot; in dataset card)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(tags=<span class="hljs-string">&quot;fiftyone&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.innerHTML=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1lrmw6w"&&(o.innerHTML=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Vq(T){let o,u="Example usage with the <code>search</code> argument:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X2RhdGFzZXRzKHNlYXJjaCUzRCUyMnRleHQlMjIpJTBBJTBBYXBpLmxpc3RfZGF0YXNldHMoc2VhcmNoJTNEJTIydGV4dCUyMiUyQyUyMGF1dGhvciUzRCUyMmdvb2dsZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all datasets with &quot;text&quot; in their name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(search=<span class="hljs-string">&quot;text&quot;</span>)

<span class="hljs-comment"># List all datasets with &quot;text&quot; in their name made by google</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_datasets(search=<span class="hljs-string">&quot;text&quot;</span>, author=<span class="hljs-string">&quot;google&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.innerHTML=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1oyacuq"&&(o.innerHTML=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Wq(T){let o,u=`<code>list_inference_catalog</code> is experimental. Its API is subject to change in the future. Please provide feedback
if you have any suggestions or requests.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-jn3ftn"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function Pq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X2luZmVyZW5jZV9lbmRwb2ludHMoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_inference_endpoints()
[InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint&#x27;</span>, ...), ...]`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Bq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWxmc19maWxlcyUyMCUzRCUyMGFwaS5saXN0X2xmc19maWxlcyglMjJ1c2VybmFtZSUyRm15LWNvb2wtcmVwbyUyMiklMEElMEFsZnNfZmlsZXNfdG9fZGVsZXRlJTIwJTNEJTIwKGxmc19maWxlJTIwZm9yJTIwbGZzX2ZpbGUlMjBpbiUyMGxmc19maWxlcyUyMGlmJTIwbGZzX2ZpbGUuZmlsZW5hbWUuc3RhcnRzd2l0aCglMjJjaGVja3BvaW50cyUyRiUyMikpJTBBJTBBYXBpLnBlcm1hbmVudGx5X2RlbGV0ZV9sZnNfZmlsZXMoJTIydXNlcm5hbWUlMkZteS1jb29sLXJlcG8lMjIlMkMlMjBsZnNfZmlsZXNfdG9fZGVsZXRlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files = api.list_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>)

<span class="hljs-comment"># Filter files files to delete based on a combination of \`filename\`, \`pushed_at\`, \`ref\` or \`size\`.</span>
<span class="hljs-comment"># e.g. select only LFS files in the &quot;checkpoints&quot; folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files_to_delete = (lfs_file <span class="hljs-keyword">for</span> lfs_file <span class="hljs-keyword">in</span> lfs_files <span class="hljs-keyword">if</span> lfs_file.filename.startswith(<span class="hljs-string">&quot;checkpoints/&quot;</span>))

<span class="hljs-comment"># Permanently delete LFS files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.permanently_delete_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>, lfs_files_to_delete)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Xq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbGlrZWRfcmVwb3MlMEElMEFsaWtlcyUyMCUzRCUyMGxpc3RfbGlrZWRfcmVwb3MoJTIyanVsaWVuLWMlMjIpJTBBJTBBbGlrZXMudXNlciUwQSUwQWxpa2VzLm1vZGVscw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_liked_repos

<span class="hljs-meta">&gt;&gt;&gt; </span>likes = list_liked_repos(<span class="hljs-string">&quot;julien-c&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>likes.user
<span class="hljs-string">&quot;julien-c&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>likes.models
[<span class="hljs-string">&quot;osanseviero/streamlit_1.15&quot;</span>, <span class="hljs-string">&quot;Xhaheen/ChatGPT_HF&quot;</span>, ...]`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Yq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X21vZGVscygpJTBBJTBBYXBpLmxpc3RfbW9kZWxzKGZpbHRlciUzRCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBYXBpLmxpc3RfbW9kZWxzKGZpbHRlciUzRCUyMmtlcmFzLWh1YiUyMiklMEElMEFhcGkubGlzdF9tb2RlbHMoaW5mZXJlbmNlX3Byb3ZpZGVyJTNEJTIyY29oZXJlJTIyKSUwQSUwQWFwaS5saXN0X21vZGVscyhzZWFyY2glM0QlMjJiZXJ0JTIyKSUwQSUwQWFwaS5saXN0X21vZGVscyhzZWFyY2glM0QlMjJiZXJ0JTIyJTJDJTIwYXV0aG9yJTNEJTIyZ29vZ2xlJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models()

<span class="hljs-comment"># List text classification models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;text-classification&quot;</span>)

<span class="hljs-comment"># List models from the KerasHub library</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;keras-hub&quot;</span>)

<span class="hljs-comment"># List models served by Cohere</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(inference_provider=<span class="hljs-string">&quot;cohere&quot;</span>)

<span class="hljs-comment"># List models with &quot;bert&quot; in their name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(search=<span class="hljs-string">&quot;bert&quot;</span>)

<span class="hljs-comment"># List models with &quot;bert&quot; in their name and pushed by google</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_models(search=<span class="hljs-string">&quot;bert&quot;</span>, author=<span class="hljs-string">&quot;google&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function zq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5saXN0X3BhcGVycyhxdWVyeSUzRCUyMmF0dGVudGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># List all papers with &quot;attention&quot; in their title</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_papers(query=<span class="hljs-string">&quot;attention&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Qq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcGVuZGluZ19hY2Nlc3NfcmVxdWVzdHMlMkMlMjBhY2NlcHRfYWNjZXNzX3JlcXVlc3QlMEElMEFyZXF1ZXN0cyUyMCUzRCUyMGxpc3RfcGVuZGluZ19hY2Nlc3NfcmVxdWVzdHMoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2IlMjIpJTBBbGVuKHJlcXVlc3RzKSUwQXJlcXVlc3RzJTVCMCU1RCUwQSUwQWFjY2VwdF9hY2Nlc3NfcmVxdWVzdCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiUyQyUyMCUyMmNsZW0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_pending_access_requests, accept_access_request

<span class="hljs-comment"># List pending requests</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_pending_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;pending&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]

<span class="hljs-comment"># Accept Clem&#x27;s request</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>accept_access_request(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>, <span class="hljs-string">&quot;clem&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Oq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVqZWN0ZWRfYWNjZXNzX3JlcXVlc3RzJTBBJTBBcmVxdWVzdHMlMjAlM0QlMjBsaXN0X3JlamVjdGVkX2FjY2Vzc19yZXF1ZXN0cyglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03YiUyMiklMEFsZW4ocmVxdWVzdHMpJTBBcmVxdWVzdHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_rejected_access_requests

<span class="hljs-meta">&gt;&gt;&gt; </span>requests = list_rejected_access_requests(<span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(requests)
<span class="hljs-number">411</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>requests[<span class="hljs-number">0</span>]
[
    AccessRequest(
        username=<span class="hljs-string">&#x27;clem&#x27;</span>,
        fullname=<span class="hljs-string">&#x27;Clem 🤗&#x27;</span>,
        email=<span class="hljs-string">&#x27;***&#x27;</span>,
        timestamp=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">11</span>, <span class="hljs-number">23</span>, <span class="hljs-number">18</span>, <span class="hljs-number">4</span>, <span class="hljs-number">53</span>, <span class="hljs-number">828000</span>, tzinfo=datetime.timezone.utc),
        status=<span class="hljs-string">&#x27;rejected&#x27;</span>,
        fields=<span class="hljs-literal">None</span>,
    ),
    ...
]`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function Kq(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWluaXRpYWxfY29tbWl0JTIwJTNEJTIwYXBpLmxpc3RfcmVwb19jb21taXRzKCUyMmdwdDIlMjIpJTVCLTElNUQlMEElMEFpbml0aWFsX2NvbW1pdCUwQSUwQWFwaS5jcmVhdGVfYnJhbmNoKCUyMmdwdDIlMjIlMkMlMjAlMjJuZXdfZW1wdHlfYnJhbmNoJTIyJTJDJTIwcmV2aXNpb24lM0Rpbml0aWFsX2NvbW1pdC5jb21taXRfaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Commits are sorted by date (last commit first)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>initial_commit = api.list_repo_commits(<span class="hljs-string">&quot;gpt2&quot;</span>)[-<span class="hljs-number">1</span>]

<span class="hljs-comment"># Initial commit is always a system commit containing the \`.gitattributes\` file.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>initial_commit
GitCommitInfo(
    commit_id=<span class="hljs-string">&#x27;9b865efde13a30c13e0a33e536cf3e4a5a9d71d8&#x27;</span>,
    authors=[<span class="hljs-string">&#x27;system&#x27;</span>],
    created_at=datetime.datetime(<span class="hljs-number">2019</span>, <span class="hljs-number">2</span>, <span class="hljs-number">18</span>, <span class="hljs-number">10</span>, <span class="hljs-number">36</span>, <span class="hljs-number">15</span>, tzinfo=datetime.timezone.utc),
    title=<span class="hljs-string">&#x27;initial commit&#x27;</span>,
    message=<span class="hljs-string">&#x27;&#x27;</span>,
    formatted_title=<span class="hljs-literal">None</span>,
    formatted_message=<span class="hljs-literal">None</span>
)

<span class="hljs-comment"># Create an empty branch by deriving from initial commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_branch(<span class="hljs-string">&quot;gpt2&quot;</span>, <span class="hljs-string">&quot;new_empty_branch&quot;</span>, revision=initial_commit.commit_id)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function eM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5saXN0X3JlcG9fcmVmcyglMjJncHQyJTIyKSUwQSUwQWFwaS5saXN0X3JlcG9fcmVmcyglMjJiaWdjb2RlJTJGdGhlLXN0YWNrJTIyJTJDJTIwcmVwb190eXBlJTNEJ2RhdGFzZXQnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;gpt2&quot;</span>)
GitRefs(branches=[GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&#x27;</span>)], converts=[], tags=[])

<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>)
GitRefs(
    branches=[
        GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;18edc1591d9ce72aa82f56c4431b3c969b210ae3&#x27;</span>),
        GitRefInfo(name=<span class="hljs-string">&#x27;v1.1.a1&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/v1.1.a1&#x27;</span>, target_commit=<span class="hljs-string">&#x27;f9826b862d1567f3822d3d25649b0d6d22ace714&#x27;</span>)
    ],
    converts=[],
    tags=[
        GitRefInfo(name=<span class="hljs-string">&#x27;v1.0&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/tags/v1.0&#x27;</span>, target_commit=<span class="hljs-string">&#x27;c37a8cd1e382064d8aced5e05543c5f7753834da&#x27;</span>)
    ]
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function tM(T){let o,u;return o=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb190cmVlJTBBcmVwb190cmVlJTIwJTNEJTIwbGlzdF9yZXBvX3RyZWUoJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIpJTBBcmVwb190cmVlJTBBbGlzdChyZXBvX3RyZWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_tree
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree = list_repo_tree(<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree
&lt;generator <span class="hljs-built_in">object</span> HfApi.list_repo_tree at <span class="hljs-number">0x7fa4088e1ac0</span>&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(repo_tree)
[
    RepoFile(path=<span class="hljs-string">&#x27;.gitattributes&#x27;</span>, size=<span class="hljs-number">391</span>, blob_id=<span class="hljs-string">&#x27;ae8c63daedbd4206d7d40126955d4e6ab1c80f8f&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(path=<span class="hljs-string">&#x27;README.md&#x27;</span>, size=<span class="hljs-number">391</span>, blob_id=<span class="hljs-string">&#x27;43bd404b159de6fba7c2f4d3264347668d43af25&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(path=<span class="hljs-string">&#x27;config.json&#x27;</span>, size=<span class="hljs-number">554</span>, blob_id=<span class="hljs-string">&#x27;2f9618c3a19b9a61add74f70bfb121335aeef666&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(
        path=<span class="hljs-string">&#x27;flax_model.msgpack&#x27;</span>, size=<span class="hljs-number">497764107</span>, blob_id=<span class="hljs-string">&#x27;8095a62ccb4d806da7666fcda07467e2d150218e&#x27;</span>,
        lfs={<span class="hljs-string">&#x27;size&#x27;</span>: <span class="hljs-number">497764107</span>, <span class="hljs-string">&#x27;sha256&#x27;</span>: <span class="hljs-string">&#x27;d88b0d6a6ff9c3f8151f9d3228f57092aaea997f09af009eefd7373a77b5abb9&#x27;</span>, <span class="hljs-string">&#x27;pointer_size&#x27;</span>: <span class="hljs-number">134</span>}, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>
    ),
    RepoFile(path=<span class="hljs-string">&#x27;merges.txt&#x27;</span>, size=<span class="hljs-number">456318</span>, blob_id=<span class="hljs-string">&#x27;226b0752cac7789c48f0cb3ec53eda48b7be36cc&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>),
    RepoFile(
        path=<span class="hljs-string">&#x27;pytorch_model.bin&#x27;</span>, size=<span class="hljs-number">548123560</span>, blob_id=<span class="hljs-string">&#x27;64eaa9c526867e404b68f2c5d66fd78e27026523&#x27;</span>,
        lfs={<span class="hljs-string">&#x27;size&#x27;</span>: <span class="hljs-number">548123560</span>, <span class="hljs-string">&#x27;sha256&#x27;</span>: <span class="hljs-string">&#x27;9be78edb5b928eba33aa88f431551348f7466ba9f5ef3daf1d552398722a5436&#x27;</span>, <span class="hljs-string">&#x27;pointer_size&#x27;</span>: <span class="hljs-number">134</span>}, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>
    ),
    RepoFile(path=<span class="hljs-string">&#x27;vocab.json&#x27;</span>, size=<span class="hljs-number">898669</span>, blob_id=<span class="hljs-string">&#x27;b00361fece0387ca34b4b8b8539ed830d644dbeb&#x27;</span>, lfs=<span class="hljs-literal">None</span>, last_commit=<span class="hljs-literal">None</span>, security=<span class="hljs-literal">None</span>)]
]`,wrap:!1}}),{c(){h(o.$$.fragment)},l(i){f(o.$$.fragment,i)},m(i,a){m(o,i,a),u=!0},p:H,i(i){u||(_(o.$$.fragment,i),u=!0)},o(i){b(o.$$.fragment,i),u=!1},d(i){y(o,i)}}}function nM(T){let o,u;return o=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb190cmVlJTBBcmVwb190cmVlJTIwJTNEJTIwbGlzdF9yZXBvX3RyZWUoJTIycHJvbXB0aGVybyUyRm9wZW5qb3VybmV5LXY0JTIyJTJDJTIwZXhwYW5kJTNEVHJ1ZSklMEFsaXN0KHJlcG9fdHJlZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_tree
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_tree = list_repo_tree(<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>, expand=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(repo_tree)
[
    RepoFolder(
        path=<span class="hljs-string">&#x27;feature_extractor&#x27;</span>,
        tree_id=<span class="hljs-string">&#x27;aa536c4ea18073388b5b0bc791057a7296a00398&#x27;</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;47b62b20b20e06b9de610e840282b7e6c3d51190&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Upload diffusers weights (#48)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">3</span>, <span class="hljs-number">21</span>, <span class="hljs-number">9</span>, <span class="hljs-number">5</span>, <span class="hljs-number">27</span>, tzinfo=datetime.timezone.utc)
        }
    ),
    RepoFolder(
        path=<span class="hljs-string">&#x27;safety_checker&#x27;</span>,
        tree_id=<span class="hljs-string">&#x27;65aef9d787e5557373fdf714d6c34d4fcdd70440&#x27;</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;47b62b20b20e06b9de610e840282b7e6c3d51190&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Upload diffusers weights (#48)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">3</span>, <span class="hljs-number">21</span>, <span class="hljs-number">9</span>, <span class="hljs-number">5</span>, <span class="hljs-number">27</span>, tzinfo=datetime.timezone.utc)
        }
    ),
    RepoFile(
        path=<span class="hljs-string">&#x27;model_index.json&#x27;</span>,
        size=<span class="hljs-number">582</span>,
        blob_id=<span class="hljs-string">&#x27;d3d7c1e8c3e78eeb1640b8e2041ee256e24c9ee1&#x27;</span>,
        lfs=<span class="hljs-literal">None</span>,
        last_commit={
            <span class="hljs-string">&#x27;oid&#x27;</span>: <span class="hljs-string">&#x27;b195ed2d503f3eb29637050a886d77bd81d35f0e&#x27;</span>,
            <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Fix deprecation warning by changing \`CLIPFeatureExtractor\` to \`CLIPImageProcessor\`. (#54)&#x27;</span>,
            <span class="hljs-string">&#x27;date&#x27;</span>: datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">5</span>, <span class="hljs-number">15</span>, <span class="hljs-number">21</span>, <span class="hljs-number">41</span>, <span class="hljs-number">59</span>, tzinfo=datetime.timezone.utc)
        },
        security={
            <span class="hljs-string">&#x27;safe&#x27;</span>: <span class="hljs-literal">True</span>,
            <span class="hljs-string">&#x27;av_scan&#x27;</span>: {<span class="hljs-string">&#x27;virusFound&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;virusNames&#x27;</span>: <span class="hljs-literal">None</span>},
            <span class="hljs-string">&#x27;pickle_import_scan&#x27;</span>: <span class="hljs-literal">None</span>
        }
    )
    ...
]`,wrap:!1}}),{c(){h(o.$$.fragment)},l(i){f(o.$$.fragment,i)},m(i,a){m(o,i,a),u=!0},p:H,i(i){u||(_(o.$$.fragment,i),u=!0)},o(i){b(o.$$.fragment,i),u=!1},d(i){y(o,i)}}}function oM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfd2ViaG9va3MlMEF3ZWJob29rcyUyMCUzRCUyMGxpc3Rfd2ViaG9va3MoKSUwQWxlbih3ZWJob29rcyklMEF3ZWJob29rcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_webhooks
<span class="hljs-meta">&gt;&gt;&gt; </span>webhooks = list_webhooks()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(webhooks)
<span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>webhooks[<span class="hljs-number">0</span>]
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    url=<span class="hljs-string">&quot;https://webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    disabled=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function aM(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function sM(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function rM(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-hjndn0"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function iM(T){let o,u=`This is a permanent action that will affect all commits referencing the deleted files and might corrupt your
repository. This is a non-revertible operation. Use it only if you know what you are doing.`;return{c(){o=c("p"),o.textContent=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1tduvyk"&&(o.textContent=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function cM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWxmc19maWxlcyUyMCUzRCUyMGFwaS5saXN0X2xmc19maWxlcyglMjJ1c2VybmFtZSUyRm15LWNvb2wtcmVwbyUyMiklMEElMEFsZnNfZmlsZXNfdG9fZGVsZXRlJTIwJTNEJTIwKGxmc19maWxlJTIwZm9yJTIwbGZzX2ZpbGUlMjBpbiUyMGxmc19maWxlcyUyMGlmJTIwbGZzX2ZpbGUuZmlsZW5hbWUuc3RhcnRzd2l0aCglMjJjaGVja3BvaW50cyUyRiUyMikpJTBBJTBBYXBpLnBlcm1hbmVudGx5X2RlbGV0ZV9sZnNfZmlsZXMoJTIydXNlcm5hbWUlMkZteS1jb29sLXJlcG8lMjIlMkMlMjBsZnNfZmlsZXNfdG9fZGVsZXRlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files = api.list_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>)

<span class="hljs-comment"># Filter files files to delete based on a combination of \`filename\`, \`pushed_at\`, \`ref\` or \`size\`.</span>
<span class="hljs-comment"># e.g. select only LFS files in the &quot;checkpoints&quot; folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lfs_files_to_delete = (lfs_file <span class="hljs-keyword">for</span> lfs_file <span class="hljs-keyword">in</span> lfs_files <span class="hljs-keyword">if</span> lfs_file.filename.startswith(<span class="hljs-string">&quot;checkpoints/&quot;</span>))

<span class="hljs-comment"># Permanently delete LFS files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.permanently_delete_lfs_files(<span class="hljs-string">&quot;username/my-cool-repo&quot;</span>, lfs_files_to_delete)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function lM(T){let o,u=`This is a power-user method. You shouldn’t need to call it directly to make a normal commit.
Use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> directly instead.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1vdjdxz"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function pM(T){let o,u=`Commit operations will be mutated during the process. In particular, the attached <code>path_or_fileobj</code> will be
removed after the upload to save memory (and replaced by an empty <code>bytes</code> object). Do not reuse the same
objects except to pass them to <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>. If you don’t want to remove the attached content from the
commit operation object, pass <code>free_memory=False</code>.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-xfsqok"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function dM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdE9wZXJhdGlvbkFkZCUyQyUyMHByZXVwbG9hZF9sZnNfZmlsZXMlMkMlMjBjcmVhdGVfY29tbWl0JTJDJTIwY3JlYXRlX3JlcG8lMEElMEFyZXBvX2lkJTIwJTNEJTIwY3JlYXRlX3JlcG8oJTIydGVzdF9wcmV1cGxvYWQlMjIpLnJlcG9faWQlMEElMEFvcGVyYXRpb25zJTIwJTNEJTIwJTVCJTVEJTIwJTIzJTIwTGlzdCUyMG9mJTIwYWxsJTIwJTYwQ29tbWl0T3BlcmF0aW9uQWRkJTYwJTIwb2JqZWN0cyUyMHRoYXQlMjB3aWxsJTIwYmUlMjBnZW5lcmF0ZWQlMEFmb3IlMjBpJTIwaW4lMjByYW5nZSg1KSUzQSUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlMjAlM0QlMjAuLi4lMjAlMjMlMjBnZW5lcmF0ZSUyMGJpbmFyeSUyMGNvbnRlbnQlMEElMjAlMjAlMjAlMjBhZGRpdGlvbiUyMCUzRCUyMENvbW1pdE9wZXJhdGlvbkFkZChwYXRoX2luX3JlcG8lM0RmJTIyc2hhcmRfJTdCaSU3RF9vZl81LmJpbiUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGNvbnRlbnQpJTBBJTIwJTIwJTIwJTIwcHJldXBsb2FkX2xmc19maWxlcyhyZXBvX2lkJTJDJTIwYWRkaXRpb25zJTNEJTVCYWRkaXRpb24lNUQpJTIwJTIzJTIwdXBsb2FkJTIwJTJCJTIwZnJlZSUyMG1lbW9yeSUwQSUyMCUyMCUyMCUyMG9wZXJhdGlvbnMuYXBwZW5kKGFkZGl0aW9uKSUwQSUwQWNyZWF0ZV9jb21taXQocmVwb19pZCUyQyUyMG9wZXJhdGlvbnMlM0RvcGVyYXRpb25zJTJDJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJDb21taXQlMjBhbGwlMjBzaGFyZHMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitOperationAdd, preupload_lfs_files, create_commit, create_repo

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = create_repo(<span class="hljs-string">&quot;test_preupload&quot;</span>).repo_id

<span class="hljs-comment"># Generate and preupload LFS files one by one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [] <span class="hljs-comment"># List of all \`CommitOperationAdd\` objects that will be generated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
<span class="hljs-meta">... </span>    content = ... <span class="hljs-comment"># generate binary content</span>
<span class="hljs-meta">... </span>    addition = CommitOperationAdd(path_in_repo=<span class="hljs-string">f&quot;shard_<span class="hljs-subst">{i}</span>_of_5.bin&quot;</span>, path_or_fileobj=content)
<span class="hljs-meta">... </span>    preupload_lfs_files(repo_id, additions=[addition]) <span class="hljs-comment"># upload + free memory</span>
<span class="hljs-meta">... </span>    operations.append(addition)

<span class="hljs-comment"># Create commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_commit(repo_id, operations=operations, commit_message=<span class="hljs-string">&quot;Commit all shards&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function gM(T){let o,u="Examples:",i,a,g;return a=new C({props:{code:"bmV3X3RpdGxlJTIwJTNEJTIwJTIyTmV3JTIwdGl0bGUlMkMlMjBmaXhpbmclMjBhJTIwdHlwbyUyMiUwQUhmQXBpKCkucmVuYW1lX2Rpc2N1c3Npb24oJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGcmVwb19uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QzNCUwQSUyMCUyMCUyMCUyMG5ld190aXRsZSUzRG5ld190aXRsZSUwQSklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>new_title = <span class="hljs-string">&quot;New title, fixing a typo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi().rename_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">34</span>
<span class="hljs-meta">... </span>    new_title=new_title
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># DiscussionTitleChange(id=&#x27;deadbeef0000000&#x27;, type=&#x27;title-change&#x27;, ...)</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function uM(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1oggadp"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function hM(T){let o,u="Examples:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJlcG9fZXhpc3RzJTBBcmVwb19leGlzdHMoJTIyZ29vZ2xlJTJGZ2VtbWEtN2IlMjIpJTBBcmVwb19leGlzdHMoJTIyZ29vZ2xlJTJGbm90LWEtcmVwbyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> repo_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_exists(<span class="hljs-string">&quot;google/not-a-repo&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function fM(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function mM(T){let o,u='It is also possible to request hardware directly when creating the Space repo! See <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> for details.';return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-752acu"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function _M(T){let o,u=`It is not possible to decrease persistent storage after its granted. To do so, you must delete it
via <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_space_storage">delete_space_storage()</a>.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-w6dccp"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function bM(T){let o,u="Examples:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJldmlzaW9uX2V4aXN0cyUwQXJldmlzaW9uX2V4aXN0cyglMjJnb29nbGUlMkZnZW1tYS03YiUyMiUyQyUyMCUyMmZsb2F0MTYlMjIpJTBBcmV2aXNpb25fZXhpc3RzKCUyMmdvb2dsZSUyRmdlbW1hLTdiJTIyJTJDJTIwJTIybm90LWEtcmV2aXNpb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> revision_exists
<span class="hljs-meta">&gt;&gt;&gt; </span>revision_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>, <span class="hljs-string">&quot;float16&quot;</span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>revision_exists(<span class="hljs-string">&quot;google/gemma-7b&quot;</span>, <span class="hljs-string">&quot;not-a-revision&quot;</span>)
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kvfsh7"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function yM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWZ1dHVyZSUyMCUzRCUyMGFwaS5ydW5fYXNfZnV0dXJlKGFwaS53aG9hbWkpJTIwJTIzJTIwaW5zdGFudCUwQWZ1dHVyZS5kb25lKCklMEFmdXR1cmUucmVzdWx0KCklMjAlMjMlMjB3YWl0JTIwdW50aWwlMjBjb21wbGV0ZSUyMGFuZCUyMHJldHVybiUyMHJlc3VsdCUwQWZ1dHVyZS5kb25lKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>future = api.run_as_future(api.whoami) <span class="hljs-comment"># instant</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.result() <span class="hljs-comment"># wait until complete and return result</span>
(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function vM(T){let o,u='It is also possible to set a custom sleep time when requesting hardware with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.request_space_hardware">request_space_hardware()</a>.';return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1k7k0vb"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function xM(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-117o2wk"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function $M(T){let o,u="Once squashed, the commit history cannot be retrieved. This is a non-revertible operation.";return{c(){o=c("p"),o.textContent=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-16nd2e3"&&(o.textContent=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function wM(T){let o,u=`Once the history of a branch has been squashed, it is not possible to merge it back into another branch since
their history will have diverged.`;return{c(){o=c("p"),o.textContent=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-qbmppr"&&(o.textContent=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function kM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQXJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8oJTIydGVzdC1zcXVhc2glMjIpLnJlcG9faWQlMEElMEFhcGkudXBsb2FkX2ZpbGUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjJmaWxlLnR4dCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGIlMjJjb250ZW50JTIyKSUwQWFwaS51cGxvYWRfZmlsZShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHBhdGhfaW5fcmVwbyUzRCUyMmxmcy5iaW4lMjIlMkMlMjBwYXRoX29yX2ZpbGVvYmolM0RiJTIyY29udGVudCUyMiklMEFhcGkudXBsb2FkX2ZpbGUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjJmaWxlLnR4dCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGIlMjJhbm90aGVyX2NvbnRlbnQlMjIpJTBBJTBBYXBpLnN1cGVyX3NxdWFzaF9oaXN0b3J5KHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Create repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = api.create_repo(<span class="hljs-string">&quot;test-squash&quot;</span>).repo_id

<span class="hljs-comment"># Make a lot of commits.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;content&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;lfs.bin&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;content&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(repo_id=repo_id, path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>, path_or_fileobj=<span class="hljs-string">b&quot;another_content&quot;</span>)

<span class="hljs-comment"># Squash history</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.super_squash_history(repo_id=repo_id)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function TM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbGlrZWRfcmVwb3MlMkMlMjB1bmxpa2UlMEElMjJncHQyJTIyJTIwaW4lMjBsaXN0X2xpa2VkX3JlcG9zKCkubW9kZWxzJTIwJTIzJTIwd2UlMjBhc3N1bWUlMjB5b3UlMjBoYXZlJTIwYWxyZWFkeSUyMGxpa2VkJTIwZ3B0MiUwQXVubGlrZSglMjJncHQyJTIyKSUwQSUyMmdwdDIlMjIlMjBpbiUyMGxpc3RfbGlrZWRfcmVwb3MoKS5tb2RlbHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_liked_repos, unlike
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;gpt2&quot;</span> <span class="hljs-keyword">in</span> list_liked_repos().models <span class="hljs-comment"># we assume you have already liked gpt2</span>
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>unlike(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;gpt2&quot;</span> <span class="hljs-keyword">in</span> list_liked_repos().models
<span class="hljs-literal">False</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function qM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwdXBkYXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBnZXRfY29sbGVjdGlvbiglMjJUaGVCbG9rZSUyRnJlY2VudC1tb2RlbHMtNjRmOWE1NWJiMzExNWI0ZjUxM2VjMDI2JTIyKSUwQSUwQXVwZGF0ZV9jb2xsZWN0aW9uX2l0ZW0oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyVGhlQmxva2UlMkZyZWNlbnQtbW9kZWxzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1Qi0xJTVELml0ZW1fb2JqZWN0X2lkJTJDJTBBJTIwJTIwJTIwJTIwbm90ZSUzRCUyMk5ld2x5JTIwdXBkYXRlZCUyMG1vZGVsISUyMiUwQSUyMCUyMCUyMCUyMHBvc2l0aW9uJTNEMCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, update_collection_item

<span class="hljs-comment"># Get collection first</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)

<span class="hljs-comment"># Update item based on its ID (add note + update position)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>update_collection_item(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    item_object_id=collection.items[-<span class="hljs-number">1</span>].item_object_id,
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;Newly updated model!&quot;</span>
<span class="hljs-meta">... </span>    position=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function MM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV9jb2xsZWN0aW9uX21ldGFkYXRhJTBBY29sbGVjdGlvbiUyMCUzRCUyMHVwZGF0ZV9jb2xsZWN0aW9uX21ldGFkYXRhKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMnVzZXJuYW1lJTJGaWNjdi0yMDIzLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyME9jdC4lMjAyMDIzJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJQb3J0Zm9saW8lMjBvZiUyMG1vZGVscyUyQyUyMGRhdGFzZXRzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwT2N0LiUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBwcml2YXRlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aGVtZSUzRCUyMnBpbmslMjIlMkMlMEEpJTBBY29sbGVjdGlvbi5zbHVn",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_collection_metadata
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = update_collection_metadata(
<span class="hljs-meta">... </span>    collection_slug=<span class="hljs-string">&quot;username/iccv-2023-64f9a55bb3115b4f513ec026&quot;</span>,
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV Oct. 2023&quot;</span>
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, datasets, papers and demos I presented at ICCV Oct. 2023&quot;</span>,
<span class="hljs-meta">... </span>    private=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    theme=<span class="hljs-string">&quot;pink&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;username/iccv-oct-2023-64f9a55bb3115b4f513ec026&quot;</span>
<span class="hljs-comment"># ^collection slug got updated but not the trailing ID</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function jM(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-hjndn0"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function HM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV93ZWJob29rJTBBdXBkYXRlZF9wYXlsb2FkJTIwJTNEJTIwdXBkYXRlX3dlYmhvb2soJTBBJTIwJTIwJTIwJTIwd2ViaG9va19pZCUzRCUyMjY1NGJiYmMxNmYyZWMxNGQ3N2YxMDljYyUyMiUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRCUyMmh0dHBzJTNBJTJGJTJGbmV3LndlYmhvb2suc2l0ZSUyRmEyMTc2ZTgyLTU3MjAtNDNlZS05ZTA2LWY5MWNiNGM5MTU0OCUyMiUyQyUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJqdWxpZW4tYyUyMiU3RCUyQyUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJvcmclMjIlMkMlMjAlMjJuYW1lJTIyJTNBJTIwJTIySHVnZ2luZ0ZhY2VINCUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGRvbWFpbnMlM0QlNUIlMjJyZXBvJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIybXktc2VjcmV0JTIyJTJDJTBBKSUwQXByaW50KHVwZGF0ZWRfcGF5bG9hZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_webhook
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_payload = update_webhook(
<span class="hljs-meta">... </span>    webhook_id=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
<span class="hljs-meta">... </span>    url=<span class="hljs-string">&quot;https://new.webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
<span class="hljs-meta">... </span>    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;julien-c&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HuggingFaceH4&quot;</span>}],
<span class="hljs-meta">... </span>    domains=[<span class="hljs-string">&quot;repo&quot;</span>],
<span class="hljs-meta">... </span>    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(updated_payload)
WebhookInfo(
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;654bbbc16f2ec14d77f109cc&quot;</span>,
    url=<span class="hljs-string">&quot;https://new.webhook.site/a2176e82-5720-43ee-9e06-f91cb4c91548&quot;</span>,
    watched=[WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;user&quot;</span>, name=<span class="hljs-string">&quot;julien-c&quot;</span>), WebhookWatchedItem(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;org&quot;</span>, name=<span class="hljs-string">&quot;HuggingFaceH4&quot;</span>)],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>],
    secret=<span class="hljs-string">&quot;my-secret&quot;</span>,
    disabled=<span class="hljs-literal">False</span>,`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function CM(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError">RepositoryNotFoundError</a>
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li> <li><a href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError">RevisionNotFoundError</a>
If the revision to download from cannot be found.</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-qqcg2t"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function UM(T){let o,u=`<code>upload_file</code> assumes that the repo already exists on the Hub. If you get a
Client error 404, please make sure you are authenticated and that <code>repo_id</code> and
<code>repo_type</code> are set correctly. If repo does not exist, create it first using
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-gqeru2"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function IM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwbG9hZF9maWxlJTBBJTBBd2l0aCUyMG9wZW4oJTIyLiUyRmxvY2FsJTJGZmlsZXBhdGglMjIlMkMlMjAlMjJyYiUyMiklMjBhcyUyMGZvYmolM0ElMEElMjAlMjAlMjAlMjB1cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0RmaWxlb2JqJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIycmVtb3RlJTJGZmlsZSUyRnBhdGguaDUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuJTNEJTIybXlfdG9rZW4lMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBdXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEJTIyLiU1QyU1Q2xvY2FsJTVDJTVDZmlsZSU1QyU1Q3BhdGglMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZmaWxlJTJGcGF0aC5oNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRm15LW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0QlMjJteV90b2tlbiUyMiUyQyUwQSklMEElMEF1cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIuJTVDJTVDbG9jYWwlNUMlNUNmaWxlJTVDJTVDcGF0aCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMnJlbW90ZSUyRmZpbGUlMkZwYXRoLmg1JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> upload_file

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;./local/filepath&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> fobj:
<span class="hljs-meta">... </span>    upload_file(
<span class="hljs-meta">... </span>        path_or_fileobj=fileobj,
<span class="hljs-meta">... </span>        path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>        repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>        repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>        token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    )
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/blob/main/remote/file/path.h5&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;.\\\\local\\\\file\\\\path&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/username/my-model/blob/main/remote/file/path.h5&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;.\\\\local\\\\file\\\\path&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/file/path.h5&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/username/my-model/blob/refs%2Fpr%2F1/remote/file/path.h5&quot;</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function AM(T){let o,u="Raises the following errors:",i,a,g=`<li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the HuggingFace API returned an error</li> <li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if some parameter value is invalid</li>`;return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-182te9i"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1l6tbi1"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function NM(T){let o,u=`<code>upload_folder</code> assumes that the repo already exists on the Hub. If you get a Client error 404, please make
sure you are authenticated and that <code>repo_id</code> and <code>repo_type</code> are set correctly. If repo does not exist, create
it first using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1ofwh3e"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function JM(T){let o,u='When dealing with a large folder (thousands of files or hundreds of GB), we recommend using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_large_folder">upload_large_folder()</a> instead.';return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1n31r9o"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function EM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"dXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaWdub3JlX3BhdHRlcm5zJTNEJTIyKiolMkZsb2dzJTJGKi50eHQlMjIlMkMlMEEpJTBBJTBBdXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVsZXRlX3BhdHRlcm5zJTNEJTIyKiolMkZsb2dzJTJGKi50eHQlMjIlMkMlMEEpJTBBJTBBdXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJyZW1vdGUlMkZleHBlcmltZW50JTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMm15X3Rva2VuJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSklMEE=",highlighted:`<span class="hljs-comment"># Upload checkpoints folder except the log files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    ignore_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># &quot;https://huggingface.co/datasets/username/my-dataset/tree/main/remote/experiment/checkpoints&quot;</span>

<span class="hljs-comment"># Upload checkpoints folder including logs while deleting existing logs from the repo</span>
<span class="hljs-comment"># Useful if you don&#x27;t know exactly which log files have already being pushed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    delete_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/tree/main/remote/experiment/checkpoints&quot;</span>

<span class="hljs-comment"># Upload checkpoints folder while creating a PR</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;remote/experiment/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;datasets&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;my_token&quot;</span>,
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;https://huggingface.co/datasets/username/my-dataset/tree/refs%2Fpr%2F1/remote/experiment/checkpoints&quot;</span>
`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function DM(T){let o,u="A few things to keep in mind:",i,a,g='<li>Repository limits still apply: <a href="https://huggingface.co/docs/hub/repositories-recommendations" rel="nofollow">https://huggingface.co/docs/hub/repositories-recommendations</a></li> <li>Do not start several processes in parallel.</li> <li>You can interrupt and resume the process at any time.</li> <li>Do not upload the same folder to several repositories. If you need to do so, you must delete the local <code>.cache/.huggingface/</code> folder first.</li>';return{c(){o=c("p"),o.textContent=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-vnn6d1"&&(o.textContent=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-1iweq7b"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function RM(T){let o,u='While being much more robust to upload large folders, <code>upload_large_folder</code> is more limited than <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> feature-wise. In practice:',i,a,g='<li>you cannot set a custom <code>path_in_repo</code>. If you want to upload to a subfolder, you need to set the proper structure locally.</li> <li>you cannot set a custom <code>commit_message</code> and <code>commit_description</code> since multiple commits are created.</li> <li>you cannot delete from the repo while uploading. Please make a separate commit first.</li> <li>you cannot create a PR directly. Please create a PR first (from the UI or using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_pull_request">create_pull_request()</a>) and then commit to it by passing <code>revision</code>.</li>';return{c(){o=c("p"),o.innerHTML=u,i=s(),a=c("ul"),a.innerHTML=g},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1n7ws7"&&(o.innerHTML=u),i=r(e),a=l(e,"UL",{"data-svelte-h":!0}),d(a)!=="svelte-gxpink"&&(a.innerHTML=g)},m(e,x){$(e,o,x),$(e,i,x),$(e,a,x)},p:H,d(e){e&&(p(o),p(i),p(a))}}}function FM(T){let o,u=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing datasets
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a> only a subset of the attributes are returned.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-fx9t9d"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function GM(T){let o,u=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing models
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a> only a subset of the attributes are returned.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1bvqy32"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function SM(T){let o,u=`All attributes of this class are optional except <code>rfilename</code>. This is because only the file names are returned when
listing repositories on the Hub (with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a>). If you need more
information like file size, blob id or lfs details, you must request them specifically from one repo at a time
(using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a>) as it adds more constraints on the backend server to
retrieve these.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1y8shbz"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function LM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"UmVwb1VybCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmdwdDInKSUwQSUwQVJlcG9VcmwoJ2h0dHBzJTNBJTJGJTJGaHViLWNpLmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkdW1teV91c2VyJTJGZHVtbXlfZGF0YXNldCclMkMlMjBlbmRwb2ludCUzRCdodHRwcyUzQSUyRiUyRmh1Yi1jaS5odWdnaW5nZmFjZS5jbycpJTBBJTBBUmVwb1VybCgnaGYlM0ElMkYlMkZkYXRhc2V0cyUyRm15LXVzZXIlMkZteS1kYXRhc2V0JyklMEElMEFIZkFwaS5jcmVhdGVfcmVwbyglMjJkdW1teV9tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/gpt2&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/gpt2&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;model&#x27;</span>, repo_id=<span class="hljs-string">&#x27;gpt2&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;https://hub-ci.huggingface.co/datasets/dummy_user/dummy_dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://hub-ci.huggingface.co&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://hub-ci.huggingface.co/datasets/dummy_user/dummy_dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://hub-ci.huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>, repo_id=<span class="hljs-string">&#x27;dummy_user/dummy_dataset&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>RepoUrl(<span class="hljs-string">&#x27;hf://datasets/my-user/my-dataset&#x27;</span>)
RepoUrl(<span class="hljs-string">&#x27;hf://datasets/my-user/my-dataset&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;dataset&#x27;</span>, repo_id=<span class="hljs-string">&#x27;user/dataset&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>HfApi.create_repo(<span class="hljs-string">&quot;dummy_model&quot;</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/Wauplin/dummy_model&#x27;</span>, endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, repo_type=<span class="hljs-string">&#x27;model&#x27;</span>, repo_id=<span class="hljs-string">&#x27;Wauplin/dummy_model&#x27;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function ZM(T){let o,u=`Most attributes of this class are optional. This is because the data returned by the Hub depends on the query made.
In general, the more specific the query, the more information is returned. On the contrary, when listing spaces
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a> only a subset of the attributes are returned.`;return{c(){o=c("p"),o.innerHTML=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-vi95sv"&&(o.innerHTML=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function VM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"b3BlcmF0aW9uJTIwJTNEJTIwQ29tbWl0T3BlcmF0aW9uQWRkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMnJlbW90ZSUyRmRpciUyRndlaWdodHMuaDUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIuJTJGbG9jYWwlMkZ3ZWlnaHRzLmg1JTIyJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVyYXRpb24uYXNfZmlsZSgpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwY29udGVudCUyMCUzRCUyMGZpbGUucmVhZCgpJTBBJTBBd2l0aCUyMG9wZXJhdGlvbi5hc19maWxlKHdpdGhfdHFkbSUzRFRydWUpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMCUzRCUyMGZpbGUucmVhZCgxMDI0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm90JTIwZGF0YSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBd2l0aCUyMG9wZXJhdGlvbi5hc19maWxlKHdpdGhfdHFkbSUzRFRydWUpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwcmVxdWVzdHMucHV0KC4uLiUyQyUyMGRhdGElM0RmaWxlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>operation = CommitOperationAdd(
<span class="hljs-meta">... </span>       path_in_repo=<span class="hljs-string">&quot;remote/dir/weights.h5&quot;</span>,
<span class="hljs-meta">... </span>       path_or_fileobj=<span class="hljs-string">&quot;./local/weights.h5&quot;</span>,
<span class="hljs-meta">... </span>)
CommitOperationAdd(path_in_repo=<span class="hljs-string">&#x27;remote/dir/weights.h5&#x27;</span>, path_or_fileobj=<span class="hljs-string">&#x27;./local/weights.h5&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file() <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    content = file.read()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file(with_tqdm=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
<span class="hljs-meta">... </span>        data = file.read(<span class="hljs-number">1024</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> data:
<span class="hljs-meta">... </span>             <span class="hljs-keyword">break</span>
config.json: <span class="hljs-number">100</span>%|█████████████████████████| <span class="hljs-number">8.19</span>k/<span class="hljs-number">8.19</span>k [<span class="hljs-number">00</span>:02&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">3.72</span>kB/s]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> operation.as_file(with_tqdm=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    requests.put(..., data=file)
config.json: <span class="hljs-number">100</span>%|█████████████████████████| <span class="hljs-number">8.19</span>k/<span class="hljs-number">8.19</span>k [<span class="hljs-number">00</span>:02&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">3.72</span>kB/s]`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function WM(T){let o,u="Example:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQWNzdl9wYXRoJTIwJTNEJTIwUGF0aCglMjJ3YXRjaGVkX2ZvbGRlciUyRmRhdGEuY3N2JTIyKSUwQUNvbW1pdFNjaGVkdWxlcihyZXBvX2lkJTNEJTIydGVzdF9zY2hlZHVsZXIlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTJDJTIwZm9sZGVyX3BhdGglM0Rjc3ZfcGF0aC5wYXJlbnQlMkMlMjBldmVyeSUzRDEwKSUwQSUwQXdpdGglMjBjc3ZfcGF0aC5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJmaXJzdCUyMGxpbmUlMjIpJTBBJTBBd2l0aCUyMGNzdl9wYXRoLm9wZW4oJTIyYSUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMnNlY29uZCUyMGxpbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-comment"># Scheduler uploads every 10 minutes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>csv_path = Path(<span class="hljs-string">&quot;watched_folder/data.csv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>CommitScheduler(repo_id=<span class="hljs-string">&quot;test_scheduler&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, folder_path=csv_path.parent, every=<span class="hljs-number">10</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;first line&quot;</span>)

<span class="hljs-comment"># Some time later (...)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;second line&quot;</span>)`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-11lpom8"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function PM(T){let o,u="Example using a context manager:",i,a,g;return a=new C({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQXdpdGglMjBDb21taXRTY2hlZHVsZXIocmVwb19pZCUzRCUyMnRlc3Rfc2NoZWR1bGVyJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMGZvbGRlcl9wYXRoJTNEJTIyd2F0Y2hlZF9mb2xkZXIlMjIlMkMlMjBldmVyeSUzRDEwKSUyMGFzJTIwc2NoZWR1bGVyJTNBJTBBJTIwJTIwJTIwJTIwY3N2X3BhdGglMjAlM0QlMjBQYXRoKCUyMndhdGNoZWRfZm9sZGVyJTJGZGF0YS5jc3YlMjIpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGNzdl9wYXRoLm9wZW4oJTIyYSUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmLndyaXRlKCUyMmZpcnN0JTIwbGluZSUyMiklMEElMjAlMjAlMjAlMjAoLi4uKSUwQSUyMCUyMCUyMCUyMHdpdGglMjBjc3ZfcGF0aC5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZSglMjJzZWNvbmQlMjBsaW5lJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> CommitScheduler(repo_id=<span class="hljs-string">&quot;test_scheduler&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, folder_path=<span class="hljs-string">&quot;watched_folder&quot;</span>, every=<span class="hljs-number">10</span>) <span class="hljs-keyword">as</span> scheduler:
<span class="hljs-meta">... </span>    csv_path = Path(<span class="hljs-string">&quot;watched_folder/data.csv&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(<span class="hljs-string">&quot;first line&quot;</span>)
<span class="hljs-meta">... </span>    (...)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> csv_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(<span class="hljs-string">&quot;second line&quot;</span>)

<span class="hljs-comment"># Scheduler is now stopped and last commit have been triggered</span>`,wrap:!1}}),{c(){o=c("p"),o.textContent=u,i=s(),h(a.$$.fragment)},l(e){o=l(e,"P",{"data-svelte-h":!0}),d(o)!=="svelte-k44prv"&&(o.textContent=u),i=r(e),f(a.$$.fragment,e)},m(e,x){$(e,o,x),$(e,i,x),m(a,e,x),g=!0},p:H,i(e){g||(_(a.$$.fragment,e),g=!0)},o(e){b(a.$$.fragment,e),g=!1},d(e){e&&(p(o),p(i)),y(a,e)}}}function BM(T){let o,u=`This method is not meant to be called directly. It is run in the background by the scheduler, respecting a
queue mechanism to avoid concurrent commits. Making a direct call to the method might lead to concurrency
issues.`;return{c(){o=c("p"),o.textContent=u},l(i){o=l(i,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1oh5a50"&&(o.textContent=u)},m(i,a){$(i,o,a)},p:H,d(i){i&&p(o)}}}function XM(T){let o,u,i,a,g,e,x,n1="아래는 허깅 페이스 Hub의 API를 위한 파이썬 래퍼인 <code>HfApi</code> 클래스에 대한 문서입니다.",dh,Vs,o1="<code>HfApi</code>의 모든 메서드는 패키지의 루트에서 직접 접근할 수 있습니다. 두 접근 방식은 아래에서 자세히 설명합니다.",gh,Ws,a1=`루트 메서드를 사용하는 것이 더 간단하지만 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> 클래스를 사용하면 더 유연하게 사용할 수 있습니다.
특히 모든 HTTP 호출에서 재사용할 토큰을 전달할 수 있습니다.
이 방식은 토큰이 머신에 유지되지 않기 때문에 <code>huggingface-cli login</code> 또는 <a href="/docs/huggingface_hub/main/ko/package_reference/login#huggingface_hub.login">login()</a>를 사용하는 방식과는 다르며,
다른 엔드포인트를 제공하거나 사용자정의 에이전트를 구성할 수도 있습니다.`,uh,Ps,hh,Bs,fh,w,Xs,hf,ll,s1="Client to interact with the Hugging Face Hub via HTTP.",ff,pl,r1=`The client is initialized with some high-level settings used in all requests
made to the Hub (HF endpoint, authentication, user agents…). Using the <code>HfApi</code>
client is preferred but not mandatory as all of its public methods are exposed
directly at the root of <code>huggingface_hub</code>.`,mf,Ce,Ys,_f,dl,i1="Accept an access request from a user for a given gated repo.",bf,gl,c1=`Once the request is accepted, the user will be able to download any file of the repo and access the community
tab. If the approval mode is automatic, you don’t have to accept requests manually. An accepted request can be
cancelled or rejected at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,yf,ul,l1='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',vf,Ue,zs,xf,hl,p1="Add an item to a collection on the Hub.",$f,fl,d1='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',wf,qo,kf,Xt,Qs,Tf,ml,g1="Adds or updates a secret in a Space.",qf,_l,u1=`Secrets allow to set secret keys or tokens to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,Mf,Yt,Os,jf,bl,h1="Adds or updates a variable in a Space.",Hf,yl,f1=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,Cf,F,Ks,Uf,vl,m1="Check if the provided user token has access to a specific repository on the Hugging Face Hub.",If,xl,_1=`This method verifies whether the user, authenticated via the provided token, has access to the specified
repository. If the repository is not found or if the user lacks the required permissions to access it,
the method raises an appropriate exception.`,Af,$l,b1="Example:",Nf,Mo,Jf,wl,y1="In this example:",Ef,kl,v1=`<li>If the user has access, the method completes successfully.</li> <li>If the repository is gated or does not exist, appropriate exceptions are raised, allowing the user
to handle them accordingly.</li>`,Df,Ie,er,Rf,Tl,x1="Cancel an access request from a user for a given gated repo.",Ff,ql,$1="A cancelled request will go back to the pending list and the user will lose access to the repo.",Gf,Ml,w1='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Sf,Ae,tr,Lf,jl,k1="Closes or re-opens a Discussion or Pull Request.",Zf,jo,Vf,Ho,Wf,Ne,nr,Pf,Hl,T1="Creates a new comment on the given Discussion.",Bf,Co,Xf,Uo,Yf,Io,or,zf,Cl,q1=`Create a new branch for a repo on the Hub, starting from the specified revision (defaults to <code>main</code>).
To find a revision suiting your needs, you can use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_commits">list_repo_commits()</a>.`,Qf,Je,ar,Of,Ul,M1="Create a new Collection on the Hub.",Kf,Il,j1='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',em,Ao,tm,se,sr,nm,Al,H1="Creates a commit in the given repo, deleting & uploading files as needed.",om,No,am,Jo,sm,Eo,rm,Z,rr,im,Nl,C1="Creates a Discussion or Pull Request.",cm,Jl,U1="Pull Requests created programmatically will be in <code>&quot;draft&quot;</code> status.",lm,El,I1='Creating a Pull Request with changes can also be done at once with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">HfApi.create_commit()</a>.',pm,Dl,A1='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',dm,Do,gm,re,ir,um,Rl,N1="Create a new Inference Endpoint.",hm,Ro,fm,Fo,mm,Go,_m,Ee,cr,bm,Fl,J1="Create a new Inference Endpoint from a model in the Hugging Face Inference Catalog.",ym,Gl,E1=`The goal of the Inference Catalog is to provide a curated list of models that are optimized for inference
and for which default configurations have been tested. See <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">https://endpoints.huggingface.co/catalog</a> for a list
of available models in the catalog.`,vm,So,xm,V,lr,$m,Sl,D1="Creates a Pull Request . Pull Requests created programmatically will be in <code>&quot;draft&quot;</code> status.",wm,Ll,R1='Creating a Pull Request with changes can also be done at once with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">HfApi.create_commit()</a>;',km,Zl,F1='This is a wrapper around <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_discussion">HfApi.create_discussion()</a>.',Tm,Vl,G1='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',qm,Lo,Mm,Zo,pr,jm,Wl,S1="Create an empty repo on the HuggingFace Hub.",Hm,Vo,dr,Cm,Pl,L1="Tag a given commit of a repo on the Hub.",Um,zt,gr,Im,Bl,Z1="Create a new webhook.",Am,Wo,Nm,De,ur,Jm,Xl,V1="Get info on one specific dataset on huggingface.co.",Em,Yl,W1="Dataset can be private if you pass an acceptable token.",Dm,Po,Rm,Bo,hr,Fm,zl,P1="Delete a branch from a repo on the Hub.",Gm,Re,fr,Sm,Ql,B1="Delete a collection on the Hub.",Lm,Xo,Zm,Yo,Vm,Qt,mr,Wm,Ol,X1="Delete an item from a collection.",Pm,zo,Bm,Ot,_r,Xm,Kl,Y1="Deletes a file in the given repo.",Ym,Qo,zm,Kt,br,Qm,ep,z1="Delete files from a repository on the Hub.",Om,tp,Q1=`If a folder path is provided, the entire folder is deleted as well as
all files it contained.`,Km,en,yr,e_,np,O1="Deletes a folder in the given repo.",t_,op,K1='Simple wrapper around <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> method.',n_,Fe,vr,o_,ap,ew="Delete an Inference Endpoint.",a_,sp,tw=`This operation is not reversible. If you don’t want to be charged for an Inference Endpoint, it is preferable
to pause it with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a> or scale it to zero with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>.`,s_,rp,nw='For convenience, you can also delete an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">InferenceEndpoint.delete()</a>.',r_,Oo,xr,i_,ip,ow="Delete a repo from the HuggingFace Hub. CAUTION: this is irreversible.",c_,tn,$r,l_,cp,aw="Deletes a secret from a Space.",p_,lp,sw=`Secrets allow to set secret keys or tokens to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,d_,Ko,wr,g_,pp,rw="Delete persistent storage for a Space.",u_,nn,kr,h_,dp,iw="Deletes a variable from a Space.",f_,gp,cw=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,m_,ea,Tr,__,up,lw="Delete a tag from a repo on the Hub.",b_,on,qr,y_,hp,pw="Delete a webhook.",v_,ta,x_,an,Mr,$_,fp,dw="Disable a webhook (makes it “disabled”).",w_,na,k_,Ge,jr,T_,mp,gw="Duplicate a Space.",q_,_p,uw=`Programmatically duplicate a Space. The new Space will be created in your account and will be in the same state
as the original Space (running or paused). You can duplicate a Space no matter the current state of a Space.`,M_,oa,j_,sn,Hr,H_,bp,hw="Edits a comment on a Discussion / Pull Request.",C_,aa,U_,rn,Cr,I_,yp,fw="Enable a webhook (makes it “active”).",A_,sa,N_,cn,Ur,J_,vp,mw="Checks if a file exists in a repository on the Hugging Face Hub.",E_,ra,D_,Se,Ir,R_,xp,_w="Gets information about a Collection on the Hub.",F_,$p,bw='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',G_,ia,S_,ca,Ar,L_,wp,yw="List all valid dataset tags as a nested namespace object.",Z_,Le,Nr,V_,kp,vw="Fetches a Discussion’s / Pull Request ‘s details from the Hub.",W_,Tp,xw='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a>',P_,la,B_,pa,Jr,X_,qp,$w=`Returns the repository name for a given model ID and optional
organization.`,Y_,da,Er,z_,Mp,ww="Fetch metadata of a file versioned on the Hub for a given url.",Q_,ln,Dr,O_,jp,kw="Get information about an Inference Endpoint.",K_,ga,eb,ua,Rr,tb,Hp,Tw="List all valid model tags as a nested namespace object",nb,pn,Fr,ob,Cp,qw="Get information about a repo’s paths.",ab,ha,sb,ie,Gr,rb,Up,Mw="Fetches Discussions and Pull Requests for the given repo.",ib,Ip,jw="Example:",cb,fa,lb,ma,pb,W,Sr,db,Ap,Hw="Parse metadata for a safetensors repo on the Hub.",gb,Np,Cw=`We first check if the repo has a single safetensors file or a sharded safetensors repo. If it’s a single
safetensors file, we parse the metadata from this file. If it’s a sharded safetensors repo, we parse the
metadata from the index file and then parse the metadata from each shard.`,ub,Jp,Uw='To parse metadata from a single safetensors file, use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.parse_safetensors_file_metadata">parse_safetensors_file_metadata()</a>.',hb,Ep,Iw='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',fb,_a,mb,ba,Lr,_b,Dp,Aw="Gets runtime information about a Space.",bb,dn,Zr,yb,Rp,Nw="Gets all variables from a Space.",vb,Fp,Jw=`Variables allow to set environment variables to a Space without hardcoding them.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>`,xb,Ze,Vr,$b,Gp,Ew="Check if a given <code>token</code> is valid and return its permissions.",wb,ya,kb,Sp,Dw='For more details about tokens, please refer to <a href="https://huggingface.co/docs/hub/security-tokens#what-are-user-access-tokens" rel="nofollow">https://huggingface.co/docs/hub/security-tokens#what-are-user-access-tokens</a>.',Tb,va,Wr,qb,Lp,Rw="Get an overview of a user on the Hub.",Mb,gn,Pr,jb,Zp,Fw="Get a webhook by its id.",Hb,xa,Cb,Ve,Br,Ub,Vp,Gw="Grant access to a user for a given gated repo.",Ib,Wp,Sw=`Granting access don’t require for the user to send an access request by themselves. The user is automatically
added to the accepted list meaning they can download the files You can revoke the granted access at any time
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,Ab,Pp,Lw='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Nb,P,Xr,Jb,Bp,Zw="Download a given file if it’s not already present in the local cache.",Eb,Xp,Vw="The new cache file layout looks like this:",Db,Yp,Ww=`<li>The cache directory contains one subfolder per repo_id (namespaced by repo type)</li> <li>inside each repo folder:<ul><li>refs is a list of the latest known revision =&gt; commit_hash pairs</li> <li>blobs contains the actual file blobs (identified by their git-sha or sha256, depending on
whether they’re LFS files or not)</li> <li>snapshots contains one subfolder per commit, each “commit” contains the subset of the files
that have been resolved at that particular commit. Each filename is a symlink to the blob
at that particular commit.</li></ul></li>`,Rb,$a,Fb,zp,Pw=`If <code>local_dir</code> is provided, the file structure from the repo will be replicated in this location. When using this
option, the <code>cache_dir</code> will not be used and a <code>.cache/huggingface/</code> folder will be created at the root of <code>local_dir</code>
to store some metadata related to the downloaded files. While this mechanism is not as robust as the main
cache-system, it’s optimized for regularly pulling the latest version of a repository.`,Gb,We,Yr,Sb,Qp,Bw="Hides a comment on a Discussion / Pull Request.",Lb,wa,Zb,ka,Vb,ce,zr,Wb,Op,Xw="Get accepted access requests for a given gated repo.",Pb,Kp,Yw=`An accepted request means the user has requested access to the repo and the request has been accepted. The user
can download any file of the repo. If the approval mode is automatic, this list should contains by default all
requests. Accepted requests can be cancelled or rejected at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a> and
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>. A cancelled request will go back to the pending list while a rejected request will
go to the rejected list. In both cases, the user will lose access to the repo.`,Bb,ed,zw='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Xb,Ta,Yb,un,Qr,zb,td,Qw="List collections on the Huggingface Hub, given some filters.",Qb,qa,Ob,Pe,Or,Kb,nd,Ow="List datasets hosted on the Huggingface Hub, given some filters.",ey,Ma,ty,ja,ny,le,Kr,oy,od,Kw="List models available in the Hugging Face Inference Catalog.",ay,ad,ek=`The goal of the Inference Catalog is to provide a curated list of models that are optimized for inference
and for which default configurations have been tested. See <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">https://endpoints.huggingface.co/catalog</a> for a list
of available models in the catalog.`,sy,sd,tk='Use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint_from_catalog">create_inference_endpoint_from_catalog()</a> to deploy a model from the catalog.',ry,Ha,iy,hn,ei,cy,rd,nk="Lists all inference endpoints for the given namespace.",ly,Ca,py,Be,ti,dy,id,ok="List all LFS files in a repo on the Hub.",gy,cd,ak=`This is primarily useful to count how much storage a repo is using and to eventually clean up large files
with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.permanently_delete_lfs_files">permanently_delete_lfs_files()</a>. Note that this would be a permanent action that will affect all commits
referencing this deleted files and that cannot be undone.`,uy,Ua,hy,pe,ni,fy,ld,sk="List all public repos liked by a user on huggingface.co.",my,pd,rk=`This list is public so token is optional. If <code>user</code> is not passed, it defaults to
the logged in user.`,_y,dd,ik='See also <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.unlike">unlike()</a>.',by,Ia,yy,fn,oi,vy,gd,ck="List models hosted on the Huggingface Hub, given some filters.",xy,Aa,$y,Na,ai,wy,ud,lk="List of members of an organization on the Hub.",ky,mn,si,Ty,hd,pk="List daily papers on the Hugging Face Hub given a search query.",qy,Ja,My,de,ri,jy,fd,dk="Get pending access requests for a given gated repo.",Hy,md,gk=`A pending request means the user has requested access to the repo but the request has not been processed yet.
If the approval mode is automatic, this list should be empty. Pending requests can be accepted or rejected
using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.reject_access_request">reject_access_request()</a>.`,Cy,_d,uk='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Uy,Ea,Iy,ge,ii,Ay,bd,hk="Get rejected access requests for a given gated repo.",Ny,yd,fk=`A rejected request means the user has requested access to the repo and the request has been explicitly rejected
by a repo owner (either you or another user from your organization). The user cannot download any file of the
repo. Rejected requests can be accepted or cancelled at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a>. A cancelled request will go back to the pending list while an accepted request will
go to the accepted list.`,Jy,vd,mk='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',Ey,Da,Dy,Xe,ci,Ry,xd,_k="Get the list of commits of a given revision for a repo on the Hub.",Fy,$d,bk="Commits are sorted by date (last commit first).",Gy,Ra,Sy,Fa,li,Ly,wd,yk="Get the list of files in a given repo.",Zy,_n,pi,Vy,kd,vk="List all users who liked a given repo on the hugging Face Hub.",Wy,Td,xk='See also <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_liked_repos">list_liked_repos()</a>.',Py,bn,di,By,qd,$k="Get the list of refs of a given repo (both tags and branches).",Xy,Ga,Yy,G,gi,zy,Md,wk="List a repo tree’s files and folders and get information about them.",Qy,jd,kk="Examples:",Oy,Hd,Tk="Get information about a repo’s tree.",Ky,Sa,ev,Cd,qk="Get even more information about a repo’s tree (last commit and files’ security scan results)",tv,La,nv,Za,ui,ov,Ud,Mk="List spaces hosted on the Huggingface Hub, given some filters.",av,Va,hi,sv,Id,jk="Get the list of followers of a user on the Hub.",rv,Wa,fi,iv,Ad,Hk="Get the list of users followed by a user on the Hub.",cv,yn,mi,lv,Nd,Ck="List all configured webhooks.",pv,Pa,dv,vn,_i,gv,Jd,Uk="Merges a Pull Request.",uv,Ba,hv,Ye,bi,fv,Ed,Ik="Get info on one specific model on huggingface.co",mv,Dd,Ak="Model can be private if you pass an acceptable token or are logged in.",_v,Xa,bv,ze,yi,yv,Rd,Nk="Moving a repository from namespace1/repo_name1 to namespace2/repo_name2",vv,Fd,Jk=`Note there are certain limitations. For more information about moving
repositories, please see
<a href="https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo" rel="nofollow">https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo</a>.`,xv,Ya,$v,za,vi,wv,Gd,Ek="Get information for a paper on the Hub.",kv,Qe,xi,Tv,Sd,Dk="Parse metadata from a safetensors file on the Hub.",qv,Ld,Rk='To parse metadata from all safetensors files in a repo at once, use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_safetensors_metadata">get_safetensors_metadata()</a>.',Mv,Zd,Fk='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',jv,Oe,$i,Hv,Vd,Gk="Pause an Inference Endpoint.",Cv,Wd,Sk=`A paused Inference Endpoint will not be charged. It can be resumed at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>.
This is different than scaling the Inference Endpoint to zero with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, which
would be automatically restarted when a request is made to it.`,Uv,Pd,Lk='For convenience, you can also pause an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>.',Iv,Ke,wi,Av,Bd,Zk="Pause your Space.",Nv,Xd,Vk=`A paused Space stops executing until manually restarted by its owner. This is different from the sleeping
state in which free Spaces go after 48h of inactivity. Paused time is not billed to your account, no matter the
hardware you’ve selected. To restart your Space, use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.restart_space">restart_space()</a> and go to your Space settings page.`,Jv,Yd,Wk='For more details, please visit <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">the docs</a>.',Ev,et,ki,Dv,zd,Pk="Permanently delete LFS files from a repo on the Hub.",Rv,Qa,Fv,Oa,Gv,B,Ti,Sv,Qd,Bk="Pre-upload LFS files to S3 in preparation on a future commit.",Lv,Od,Xk=`This method is useful if you are generating the files to upload on-the-fly and you don’t want to store them
in memory before uploading them all at once.`,Zv,Ka,Vv,es,Wv,ts,Pv,tt,qi,Bv,Kd,Yk="Reject an access request from a user for a given gated repo.",Xv,eg,zk=`A rejected request will go to the rejected list. The user cannot download any file of the repo. Rejected
requests can be accepted or cancelled at any time using <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.accept_access_request">accept_access_request()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.cancel_access_request">cancel_access_request()</a>.
A cancelled request will go back to the pending list while an accepted request will go to the accepted list.`,Yv,tg,Qk='For more info about gated repos, see <a href="https://huggingface.co/docs/hub/models-gated" rel="nofollow">https://huggingface.co/docs/hub/models-gated</a>.',zv,nt,Mi,Qv,ng,Ok="Renames a Discussion.",Ov,ns,Kv,os,ex,xn,ji,tx,og,Kk="Checks if a repository exists on the Hugging Face Hub.",nx,as,ox,$n,Hi,ax,ag,eT="Get the info object for a given repo of a given type.",sx,ss,rx,wn,Ci,ix,sg,tT="Request new hardware for a Space.",cx,rs,lx,kn,Ui,px,rg,nT="Request persistent storage for a Space.",dx,is,gx,ot,Ii,ux,ig,oT="Restart your Space.",hx,cg,aT=`This is the only way to programmatically restart a Space if you’ve put it on Pause (see <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_space">pause_space()</a>). You
must be the owner of the Space to restart it. If you are using an upgraded hardware, your account will be
billed as soon as the Space is restarted. You can trigger a restart no matter the current state of a Space.`,fx,lg,sT='For more details, please visit <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">the docs</a>.',mx,Tn,Ai,_x,pg,rT="Resume an Inference Endpoint.",bx,dg,iT='For convenience, you can also resume an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.',yx,qn,Ni,vx,gg,cT="Checks if a specific revision exists on a repo on the Hugging Face Hub.",xx,cs,$x,ue,Ji,wx,ug,lT="Run a method in the background and return a Future instance.",kx,hg,pT=`The main goal is to run methods without blocking the main thread (e.g. to push data during a training).
Background jobs are queued to preserve order but are not ran in parallel. If you need to speed-up your scripts
by parallelizing lots of call to the API, you must setup and use your own <a href="https://docs.python.org/3/library/concurrent.futures.html#threadpoolexecutor" rel="nofollow">ThreadPoolExecutor</a>.`,Tx,fg,dT=`Note: Most-used methods like <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> have a <code>run_as_future: bool</code>
argument to directly call them in the background. This is equivalent to calling <code>api.run_as_future(...)</code> on them
but less verbose.`,qx,ls,Mx,at,Ei,jx,mg,gT="Scale Inference Endpoint to zero.",Hx,_g,uT=`An Inference Endpoint scaled to zero will not be charged. It will be resume on the next request to it, with a
cold start delay. This is different than pausing the Inference Endpoint with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, which
would require a manual resume with <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>.`,Cx,bg,hT='For convenience, you can also scale an Inference Endpoint to zero using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>.',Ux,st,Di,Ix,yg,fT="Set a custom sleep time for a Space running on upgraded hardware..",Ax,vg,mT=`Your Space will go to sleep after X seconds of inactivity. You are not billed when your Space is in “sleep”
mode. If a new visitor lands on your Space, it will “wake it up”. Only upgraded hardware can have a
configurable sleep time. To know more about the sleep stage, please refer to
<a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a>.`,Nx,ps,Jx,he,Ri,Ex,xg,_T="Download repo files.",Dx,$g,bT=`Download a whole snapshot of a repo’s files at the specified revision. This is useful when you want all files from
a repo, because you don’t know which ones you will need a priori. All files are nested inside a folder in order
to keep their actual filename relative to that folder. You can also filter which files to download using
<code>allow_patterns</code> and <code>ignore_patterns</code>.`,Rx,wg,yT=`If <code>local_dir</code> is provided, the file structure from the repo will be replicated in this location. When using this
option, the <code>cache_dir</code> will not be used and a <code>.cache/huggingface/</code> folder will be created at the root of <code>local_dir</code>
to store some metadata related to the downloaded files.While this mechanism is not as robust as the main
cache-system, it’s optimized for regularly pulling the latest version of a repository.`,Fx,kg,vT=`An alternative would be to clone the repo but this requires git and git-lfs to be installed and properly
configured. It is also not possible to filter which files to download when cloning a repository using git.`,Gx,rt,Fi,Sx,Tg,xT="Get info on one specific Space on huggingface.co.",Lx,qg,$T="Space can be private if you pass an acceptable token.",Zx,ds,Vx,X,Gi,Wx,Mg,wT="Squash commit history on a branch for a repo on the Hub.",Px,jg,kT=`Squashing the repo history is useful when you know you’ll make hundreds of commits and you don’t want to
clutter the history. Squashing commits can only be performed from the head of a branch.`,Bx,gs,Xx,us,Yx,hs,zx,fe,Si,Qx,Hg,TT="Unlike a given repo on the Hub (e.g. remove from favorite list).",Ox,Cg,qT="To prevent spam usage, it is not possible to <code>like</code> a repository from a script.",Kx,Ug,MT='See also <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_liked_repos">list_liked_repos()</a>.',e$,fs,t$,Mn,Li,n$,Ig,jT="Update an item in a collection.",o$,ms,a$,me,Zi,s$,Ag,HT="Update metadata of a collection on the Hub.",r$,Ng,CT="All arguments are optional. Only provided metadata will be updated.",i$,Jg,UT='Returns: <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection">Collection</a>',c$,_s,l$,it,Vi,p$,Eg,IT="Update an Inference Endpoint.",d$,Dg,AT=`This method allows the update of either the compute configuration, the deployed model, the route, or any combination.
All arguments are optional but at least one must be provided.`,g$,Rg,NT='For convenience, you can also update an Inference Endpoint using <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">InferenceEndpoint.update()</a>.',u$,jn,Wi,h$,Fg,JT="Update the settings of a repository, including gated access and visibility.",f$,Gg,ET=`To give more control over how repos are used, the Hub allows repo authors to enable
access requests for their repos, and also to set the visibility of the repo to private.`,m$,ct,Pi,_$,Sg,DT="Update the visibility setting of a repository.",b$,Lg,RT="Deprecated. Use <code>update_repo_settings</code> instead.",y$,bs,v$,Hn,Bi,x$,Zg,FT="Update an existing webhook.",$$,ys,w$,_e,Xi,k$,Vg,GT=`Upload a local file (up to 50 GB) to the given repo. The upload is done
through a HTTP post request, and doesn’t require git or git-lfs to be
installed.`,T$,vs,q$,xs,M$,$s,j$,N,Yi,H$,Wg,ST=`Upload a local folder to the given repo. The upload is done through a HTTP requests, and doesn’t require git or
git-lfs to be installed.`,C$,Pg,LT=`The structure of the folder will be preserved. Files with the same name already present in the repository will
be overwritten. Others will be left untouched.`,U$,Bg,ZT=`Use the <code>allow_patterns</code> and <code>ignore_patterns</code> arguments to specify which files to upload. These parameters
accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing patterns) as
documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. If both <code>allow_patterns</code> and
<code>ignore_patterns</code> are provided, both constraints apply. By default, all files from the folder are uploaded.`,I$,Xg,VT=`Use the <code>delete_patterns</code> argument to specify remote files you want to delete. Input type is the same as for
<code>allow_patterns</code> (see above). If <code>path_in_repo</code> is also provided, the patterns are matched against paths
relative to this folder. For example, <code>upload_folder(..., path_in_repo=&quot;experiment&quot;, delete_patterns=&quot;logs/*&quot;)</code>
will delete any remote file under <code>./experiment/logs/</code>. Note that the <code>.gitattributes</code> file will not be deleted
even if it matches the patterns.`,A$,Yg,WT=`Any <code>.git/</code> folder present in any subdirectory will be ignored. However, please be aware that the <code>.gitignore</code>
file is not taken into account.`,N$,zg,PT="Uses <code>HfApi.create_commit</code> under the hood.",J$,ws,E$,ks,D$,Ts,R$,qs,F$,A,zi,G$,Qg,BT="Upload a large folder to the Hub in the most resilient way possible.",S$,Og,XT=`Several workers are started to upload files in an optimized way. Before being committed to a repo, files must be
hashed and be pre-uploaded if they are LFS files. Workers will perform these tasks for each file in the folder.
At each step, some metadata information about the upload process is saved in the folder under <code>.cache/.huggingface/</code>
to be able to resume the process if interrupted. The whole process might result in several commits.`,L$,Ms,Z$,js,V$,Kg,YT="<strong>Technical details:</strong>",W$,eu,zT="<code>upload_large_folder</code> process is as follow:",P$,tu,QT=`<li>(Check parameters and setup.)</li> <li>Create repo if missing.</li> <li>List local files to upload.</li> <li>Start workers. Workers can perform the following tasks:<ul><li>Hash a file.</li> <li>Get upload mode (regular or LFS) for a list of files.</li> <li>Pre-upload an LFS file.</li> <li>Commit a bunch of files.
Once a worker finishes a task, it will move on to the next task based on the priority list (see below) until
all files are uploaded and committed.</li></ul></li> <li>While workers are up, regularly print a report to sys.stdout.</li>`,B$,nu,OT="Order of priority:",X$,ou,KT="<li>Commit if more than 5 minutes since last commit attempt (and at least 1 file).</li> <li>Commit if at least 150 files are ready to commit.</li> <li>Get upload mode if at least 10 files have been hashed.</li> <li>Pre-upload LFS file if at least 1 file and no worker is pre-uploading.</li> <li>Hash file if at least 1 file and no worker is hashing.</li> <li>Get upload mode if at least 1 file and no worker is getting upload mode.</li> <li>Pre-upload LFS file if at least 1 file (exception: if hf_transfer is enabled, only 1 worker can preupload LFS at a time).</li> <li>Hash file if at least 1 file to hash.</li> <li>Get upload mode if at least 1 file to get upload mode.</li> <li>Commit if at least 1 file to commit and at least 1 min since last commit attempt.</li> <li>Commit if at least 1 file to commit and all other queues are empty.</li>",Y$,au,e0="Special rules:",z$,su,t0="<li>If <code>hf_transfer</code> is enabled, only 1 LFS uploader at a time. Otherwise the CPU would be bloated by <code>hf_transfer</code>.</li> <li>Only one worker can commit at a time.</li> <li>If no tasks are available, the worker waits for 10 seconds before checking again.</li>",Q$,Hs,Qi,O$,ru,n0="Call HF API to know “whoami”.",mh,Oi,_h,Ki,bh,Gn,ec,K$,iu,o0="Data structure containing information about a user access request.",yh,tc,vh,pt,nc,e2,cu,a0="Data structure containing information about a newly created commit.",t2,lu,s0=`Returned by any method that creates a commit on the Hub: <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>,
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_file">delete_file()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_folder">delete_folder()</a>. It inherits from <code>str</code> for backward compatibility but using methods specific
to <code>str</code> is deprecated.`,xh,oc,$h,dt,ac,n2,pu,r0='Contains information about a dataset on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_datasets">list_datasets()</a>.',o2,Cs,wh,sc,kh,Sn,rc,a2,du,i0="Contains information about a git reference for a repo on the Hub.",Th,ic,qh,Ln,cc,s2,gu,c0='Contains information about a git commit for a repo on the Hub. Check out <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_commits">list_repo_commits()</a> for more details.',Mh,lc,jh,gt,pc,r2,uu,l0="Contains information about all git references for a repo on the Hub.",i2,hu,p0='Object is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a>.',Hh,dc,Ch,ut,gc,c2,fu,d0='Contains information about a model on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_models">list_models()</a>.',l2,Us,Uh,uc,Ih,ht,hc,p2,mu,g0="Contains basic information about a repo file inside a repo on the Hub.",d2,Is,Ah,fc,Nh,Zn,mc,g2,_u,u0="Contains information about a file on the Hub.",Jh,_c,Eh,z,bc,u2,bu,h0="Subclass of <code>str</code> describing a repo URL on the Hub.",h2,yu,f0=`<code>RepoUrl</code> is returned by <code>HfApi.create_repo</code>. It inherits from <code>str</code> for backward
compatibility. At initialization, the URL is parsed to populate properties:`,f2,vu,m0="<li>endpoint (<code>str</code>)</li> <li>namespace (<code>Optional[str]</code>)</li> <li>repo_name (<code>str</code>)</li> <li>repo_id (<code>str</code>)</li> <li>repo_type (<code>Literal[&quot;model&quot;, &quot;dataset&quot;, &quot;space&quot;]</code>)</li> <li>url (<code>str</code>)</li>",m2,As,Dh,yc,Rh,Q,vc,_2,xu,_0="Metadata for a Safetensors repo.",b2,$u,b0=`A repo is considered to be a Safetensors repo if it contains either a ‘model.safetensors’ weight file (non-shared
model) or a ‘model.safetensors.index.json’ index file (sharded model) at its root.`,y2,wu,y0='This class is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_safetensors_metadata">get_safetensors_metadata()</a>.',v2,ku,v0='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Fh,xc,Gh,be,$c,x2,Tu,x0="Metadata for a Safetensors file hosted on the Hub.",$2,qu,$0='This class is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.parse_safetensors_file_metadata">parse_safetensors_file_metadata()</a>.',w2,Mu,w0='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Sh,wc,Lh,ft,kc,k2,ju,k0='Contains information about a Space on the Hub. This object is returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_spaces">list_spaces()</a>.',T2,Ns,Zh,Tc,Vh,mt,qc,q2,Hu,T0="Information about a tensor.",M2,Cu,q0='For more details regarding the safetensors format, check out <a href="https://huggingface.co/docs/safetensors/index#format" rel="nofollow">https://huggingface.co/docs/safetensors/index#format</a>.',Wh,Mc,Ph,Vn,jc,j2,Uu,M0="Contains information about a user on the Hub.",Bh,Hc,Xh,Wn,Cc,H2,Iu,j0="Contains information about a user likes on the Hub.",Yh,Uc,zh,Ic,H0="<code>CommitOperation()</code>에 지원되는 값은 다음과 같습니다:",Qh,ye,Ac,C2,Au,C0="Data structure holding necessary info to upload a file to a repository on the Hub.",U2,Cn,Nc,I2,Nu,U0=`A context manager that yields a file-like object allowing to read the underlying
data behind <code>path_or_fileobj</code>.`,A2,Js,N2,Un,Jc,J2,Ju,I0="The base64-encoded content of <code>path_or_fileobj</code>",E2,Eu,A0="Returns: <code>bytes</code>",Oh,Pn,Ec,D2,Du,N0=`Data structure holding necessary info to delete a file or a folder from a repository
on the Hub.`,Kh,O,Dc,R2,Ru,J0="Data structure holding necessary info to copy a file in a repository on the Hub.",F2,Fu,E0="Limitations:",G2,Gu,D0="<li>Only LFS files can be copied. To copy a regular file, you need to download it locally and re-upload it</li> <li>Cross-repository copies are not supported.</li>",S2,Su,R0='Note: you can combine a <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> and a <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> to rename an LFS file on the Hub.',ef,Rc,tf,D,Fc,L2,Lu,F0="Scheduler to upload a local folder to the Hub at regular intervals (e.g. push to hub every 5 minutes).",Z2,Zu,G0=`The recommended way to use the scheduler is to use it as a context manager. This ensures that the scheduler is
properly stopped and the last commit is triggered when the script ends. The scheduler can also be stopped manually
with the <code>stop</code> method. Checkout the <a href="https://huggingface.co/docs/huggingface_hub/guides/upload#scheduled-uploads" rel="nofollow">upload guide</a>
to learn more about how to use it.`,V2,Es,W2,Ds,P2,lt,Gc,B2,Vu,S0="Push folder to the Hub and return the commit info.",X2,Rs,Y2,Wu,L0=`The default behavior of <code>push_to_hub</code> is to assume an append-only folder. It lists all files in the folder and
uploads only changed files. If no changes are found, the method returns without committing anything. If you want
to change this behavior, you can inherit from <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> and override this method. This can be useful
for example to compress data together in a single file before committing. For more details and examples, check
out our <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/upload#scheduled-uploads" rel="nofollow">integration guide</a>.`,z2,In,Sc,Q2,Pu,Z0="Stop the scheduler.",O2,Bu,V0="A stopped scheduler cannot be restarted. Mostly for tests purposes.",K2,An,Lc,e1,Xu,W0="Trigger a <code>push_to_hub</code> and return a future.",t1,Yu,P0=`This method is automatically called every <code>every</code> minutes. You can also call it manually to trigger a commit
immediately, without waiting for the next scheduled commit.`,nf,Zc,of,ph,af;return g=new R({props:{title:"HfApi Client",local:"hfapi-client",headingTag:"h1"}}),Ps=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwbGlzdF9tb2RlbHMlMEElMEElMjMlMjAlRUIlQTMlQTglRUQlOEElQjglMjAlRUIlQTklOTQlRUMlODQlOUMlRUIlOTMlOUMlRUIlQTUlQkMlMjAlRUMlODIlQUMlRUMlOUElQTklRUQlOTUlOTglRUMlODQlQjglRUMlOUElOTQuJTBBbW9kZWxzJTIwJTNEJTIwbGlzdF9tb2RlbHMoKSUwQSUwQSUyMyUyMCVFQiU5OCU5MCVFQiU4QSU5NCUyMEhmQXBpJTIwY2xpZW50JUVCJUE1JUJDJTIwJUVBJUI1JUFDJUVDJTg0JUIxJUVEJTk1JTk4JUVDJTg0JUI4JUVDJTlBJTk0LiUwQWhmX2FwaSUyMCUzRCUyMEhmQXBpKCUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyMiUyQyUyMCUyMyUyMCVFQiVCOSU4NCVFQSVCMyVCNSVFQSVCMCU5QyUyMEh1YiUyMCVFQyU5NyU5NCVFQiU5MyU5QyVFRCU4RiVBQyVFQyU5RCVCOCVFRCU4QSVCOCVFQiVBNSVCQyUyMCVFQyVBNyU4MCVFQyVBMCU5NSVFRCU5NSVBMCUyMCVFQyU4OCU5OCUyMCVFQyU5RSU4OCVFQyU4QSVCNSVFQiU4QiU4OCVFQiU4QiVBNC4lMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMmhmX3h4eCUyMiUyQyUyMCUyMyUyMCVFRCU4NiVBMCVFRCU4MSVCMCVFQyU5RCU4MCUyMCVFQiVBOCVCOCVFQyU4QiVBMCVFQyU5NyU5MCUyMCVFQyU5QyVBMCVFQyVBNyU4MCVFQiU5MCU5OCVFQyVBNyU4MCUyMCVFQyU5NSU4QSVFQyU4QSVCNSVFQiU4QiU4OCVFQiU4QiVBNC4lMEEpJTBBbW9kZWxzJTIwJTNEJTIwaGZfYXBpLmxpc3RfbW9kZWxzKCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, list_models

<span class="hljs-comment"># 루트 메서드를 사용하세요.</span>
models = list_models()

<span class="hljs-comment"># 또는 HfApi client를 구성하세요.</span>
hf_api = HfApi(
    endpoint=<span class="hljs-string">&quot;https://huggingface.co&quot;</span>, <span class="hljs-comment"># 비공개 Hub 엔드포인트를 지정할 수 있습니다.</span>
    token=<span class="hljs-string">&quot;hf_xxx&quot;</span>, <span class="hljs-comment"># 토큰은 머신에 유지되지 않습니다.</span>
)
models = hf_api.list_models()`,wrap:!1}}),Bs=new R({props:{title:"HfApi",local:"huggingface_hub.HfApi ][ huggingface_hub.HfApi",headingTag:"h2"}}),Xs=new j({props:{name:"class huggingface_hub.HfApi",anchor:"huggingface_hub.HfApi",parameters:[{name:"endpoint",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"library_name",val:": Optional[str] = None"},{name:"library_version",val:": Optional[str] = None"},{name:"user_agent",val:": Union[Dict, str, None] = None"},{name:"headers",val:": Optional[Dict[str, str]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.endpoint",description:`<strong>endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Endpoint of the Hub. Defaults to <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a>.`,name:"endpoint"},{anchor:"huggingface_hub.HfApi.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the library that is making the HTTP request. Will be added to
the user-agent header. Example: <code>&quot;transformers&quot;</code>.`,name:"library_name"},{anchor:"huggingface_hub.HfApi.library_version",description:`<strong>library_version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The version of the library that is making the HTTP request. Will be added
to the user-agent header. Example: <code>&quot;4.24.0&quot;</code>.`,name:"library_version"},{anchor:"huggingface_hub.HfApi.user_agent",description:`<strong>user_agent</strong> (<code>str</code>, <code>dict</code>, <em>optional</em>) &#x2014;
The user agent info in the form of a dictionary or a single string. It will
be completed with information about the installed packages.`,name:"user_agent"},{anchor:"huggingface_hub.HfApi.headers",description:`<strong>headers</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional headers to be sent with each request. Example: <code>{&quot;X-My-Header&quot;: &quot;value&quot;}</code>.
Headers passed here are taking precedence over the default headers.`,name:"headers"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1668"}}),Ys=new j({props:{name:"accept_access_request",anchor:"huggingface_hub.HfApi.accept_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.accept_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to accept access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.accept_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be accepted.`,name:"user"},{anchor:"huggingface_hub.HfApi.accept_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to accept access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.accept_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8971",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the accepted list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),zs=new j({props:{name:"add_collection_item",anchor:"huggingface_hub.HfApi.add_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_id",val:": str"},{name:"item_type",val:": CollectionItemType_T"},{name:"note",val:": Optional[str] = None"},{name:"exists_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.add_collection_item.item_id",description:`<strong>item_id</strong> (<code>str</code>) &#x2014;
ID of the item to add to the collection. It can be the ID of a repo on the Hub (e.g. <code>&quot;facebook/bart-large-mnli&quot;</code>)
or a paper id (e.g. <code>&quot;2307.09288&quot;</code>).`,name:"item_id"},{anchor:"huggingface_hub.HfApi.add_collection_item.item_type",description:`<strong>item_type</strong> (<code>str</code>) &#x2014;
Type of the item to add. Can be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code>, <code>&quot;space&quot;</code> or <code>&quot;paper&quot;</code>.`,name:"item_type"},{anchor:"huggingface_hub.HfApi.add_collection_item.note",description:`<strong>note</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A note to attach to the item in the collection. The maximum size for a note is 500 characters.`,name:"note"},{anchor:"huggingface_hub.HfApi.add_collection_item.exists_ok",description:`<strong>exists_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if item already exists.`,name:"exists_ok"},{anchor:"huggingface_hub.HfApi.add_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8523",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the item you try to add to the collection does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 409 if the item you try to add to the collection is already in the collection (and exists_ok=False)</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),qo=new U({props:{anchor:"huggingface_hub.HfApi.add_collection_item.example",$$slots:{default:[tq]},$$scope:{ctx:T}}}),Qs=new j({props:{name:"add_space_secret",anchor:"huggingface_hub.HfApi.add_space_secret",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"value",val:": str"},{name:"description",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_space_secret.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.add_space_secret.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Secret key. Example: <code>&quot;GITHUB_API_KEY&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.add_space_secret.value",description:`<strong>value</strong> (<code>str</code>) &#x2014;
Secret value. Example: <code>&quot;your_github_api_key&quot;</code>.`,name:"value"},{anchor:"huggingface_hub.HfApi.add_space_secret.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Secret description. Example: <code>&quot;Github API key to access the Github API&quot;</code>.`,name:"description"},{anchor:"huggingface_hub.HfApi.add_space_secret.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6972"}}),Os=new j({props:{name:"add_space_variable",anchor:"huggingface_hub.HfApi.add_space_variable",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"value",val:": str"},{name:"description",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.add_space_variable.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.add_space_variable.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Variable key. Example: <code>&quot;MODEL_REPO_ID&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.add_space_variable.value",description:`<strong>value</strong> (<code>str</code>) &#x2014;
Variable value. Example: <code>&quot;the_model_repo_id&quot;</code>.`,name:"value"},{anchor:"huggingface_hub.HfApi.add_space_variable.description",description:`<strong>description</strong> (<code>str</code>) &#x2014;
Description of the variable. Example: <code>&quot;Model Repo ID of the implemented model&quot;</code>.`,name:"description"},{anchor:"huggingface_hub.HfApi.add_space_variable.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7060"}}),Ks=new j({props:{name:"auth_check",anchor:"huggingface_hub.HfApi.auth_check",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.auth_check.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to check for access. Format should be <code>&quot;user/repo_name&quot;</code>.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.auth_check.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository. Should be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code>, or <code>&quot;space&quot;</code>.
If not specified, the default is <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.auth_check.token",description:`<strong>token</strong> <code>(Union[bool, str, None]</code>, <em>optional</em>) &#x2014;
A valid user access token. If not provided, the locally saved token will be used, which is the
recommended authentication method. Set to <code>False</code> to disable authentication.
Refer to: <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9879",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>
<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
Raised if the repository does not exist, is private, or the user does not have access. This can
occur if the <code>repo_id</code> or <code>repo_type</code> is incorrect or if the repository is private but the user
is not authenticated.</p>
</li>
<li>
<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.GatedRepoError"
>GatedRepoError</a> —
Raised if the repository exists but is gated and the user is not authorized to access it.</p>
</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.GatedRepoError"
>GatedRepoError</a></p>
`}}),Mo=new U({props:{anchor:"huggingface_hub.HfApi.auth_check.example",$$slots:{default:[nq]},$$scope:{ctx:T}}}),er=new j({props:{name:"cancel_access_request",anchor:"huggingface_hub.HfApi.cancel_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.cancel_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to cancel access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.cancel_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be cancelled.`,name:"user"},{anchor:"huggingface_hub.HfApi.cancel_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to cancel access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.cancel_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8931",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the pending list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),tr=new j({props:{name:"change_discussion_status",anchor:"huggingface_hub.HfApi.change_discussion_status",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"new_status",val:": Literal['open', 'closed']"},{name:"token",val:": Union[bool, str, None] = None"},{name:"comment",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.change_discussion_status.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.change_discussion_status.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.change_discussion_status.new_status",description:`<strong>new_status</strong> (<code>str</code>) &#x2014;
The new status for the discussion, either <code>&quot;open&quot;</code> or <code>&quot;closed&quot;</code>.`,name:"new_status"},{anchor:"huggingface_hub.HfApi.change_discussion_status.comment",description:`<strong>comment</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional comment to post with the status change.`,name:"comment"},{anchor:"huggingface_hub.HfApi.change_discussion_status.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.change_discussion_status.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6714",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the status change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionStatusChange"
>DiscussionStatusChange</a></p>
`}}),jo=new U({props:{anchor:"huggingface_hub.HfApi.change_discussion_status.example",$$slots:{default:[oq]},$$scope:{ctx:T}}}),Ho=new I({props:{$$slots:{default:[aq]},$$scope:{ctx:T}}}),nr=new j({props:{name:"comment_discussion",anchor:"huggingface_hub.HfApi.comment_discussion",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.comment_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.comment_discussion.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.comment_discussion.comment",description:`<strong>comment</strong> (<code>str</code>) &#x2014;
The content of the comment to create. Comments support markdown formatting.`,name:"comment"},{anchor:"huggingface_hub.HfApi.comment_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.comment_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6565",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the newly created comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),Co=new U({props:{anchor:"huggingface_hub.HfApi.comment_discussion.example",$$slots:{default:[sq]},$$scope:{ctx:T}}}),Uo=new I({props:{$$slots:{default:[rq]},$$scope:{ctx:T}}}),or=new j({props:{name:"create_branch",anchor:"huggingface_hub.HfApi.create_branch",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_branch.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which the branch will be created.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_branch.branch",description:`<strong>branch</strong> (<code>str</code>) &#x2014;
The name of the branch to create.`,name:"branch"},{anchor:"huggingface_hub.HfApi.create_branch.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to create the branch from. It can be a branch name or
the OID/SHA of a commit, as a hexadecimal string. Defaults to the head
of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_branch.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_branch.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if creating a branch on a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_branch.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if branch already exists.`,name:"exist_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5906",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If invalid reference for a branch. Ex: <code>refs/pr/5</code> or ‘refs/foo/bar’.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the branch already exists on the repo (error 409) and <code>exist_ok</code> is
set to <code>False</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),ar=new j({props:{name:"create_collection",anchor:"huggingface_hub.HfApi.create_collection",parameters:[{name:"title",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"description",val:": Optional[str] = None"},{name:"private",val:": bool = False"},{name:"exists_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_collection.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the collection to create. Example: <code>&quot;Recent models&quot;</code>.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_collection.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Namespace of the collection to create (username or org). Will default to the owner name.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_collection.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Description of the collection to create.`,name:"description"},{anchor:"huggingface_hub.HfApi.create_collection.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the collection should be private or not. Defaults to <code>False</code> (i.e. public collection).`,name:"private"},{anchor:"huggingface_hub.HfApi.create_collection.exists_ok",description:`<strong>exists_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if collection already exists.`,name:"exists_ok"},{anchor:"huggingface_hub.HfApi.create_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8346"}}),Ao=new U({props:{anchor:"huggingface_hub.HfApi.create_collection.example",$$slots:{default:[iq]},$$scope:{ctx:T}}}),sr=new j({props:{name:"create_commit",anchor:"huggingface_hub.HfApi.create_commit",parameters:[{name:"repo_id",val:": str"},{name:"operations",val:": Iterable[CommitOperation]"},{name:"commit_message",val:": str"},{name:"commit_description",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"num_threads",val:": int = 5"},{name:"parent_commit",val:": Optional[str] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_commit.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which the commit will be created, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_commit.operations",description:`<strong>operations</strong> (<code>Iterable</code> of <code>CommitOperation()</code>) &#x2014;
An iterable of operations to include in the commit, either:</p>
<ul>
<li><a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a> to upload a file</li>
<li><a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> to delete a file</li>
<li><a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> to copy a file</li>
</ul>
<p>Operation objects will be mutated to include information relative to the upload. Do not reuse the
same objects for multiple commits.`,name:"operations"},{anchor:"huggingface_hub.HfApi.create_commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
The summary (first line) of the commit that will be created.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.create_commit.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.create_commit.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_commit.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_commit.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_commit.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.create_commit.num_threads",description:`<strong>num_threads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads for uploading files. Defaults to 5.
Setting it to 2 means at most 2 files will be uploaded concurrently.`,name:"num_threads"},{anchor:"huggingface_hub.HfApi.create_commit.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string.
Shorthands (7 first characters) are also supported. If specified and <code>create_pr</code> is <code>False</code>,
the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>. If specified and <code>create_pr</code>
is <code>True</code>, the pull request will be created from <code>parent_commit</code>. Specifying <code>parent_commit</code>
ensures the repo has not changed before committing the changes, and can be especially useful
if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.create_commit.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4051",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If commit message is empty.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If parent commit is not a valid commit OID.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If a README.md file with an invalid metadata section is committed. In this case, the commit will fail
early, before trying to upload any file.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>create_pr</code> is <code>True</code> and revision is neither <code>None</code> nor <code>"main"</code>.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),No=new I({props:{warning:!0,$$slots:{default:[cq]},$$scope:{ctx:T}}}),Jo=new I({props:{warning:!0,$$slots:{default:[lq]},$$scope:{ctx:T}}}),Eo=new I({props:{warning:!0,$$slots:{default:[pq]},$$scope:{ctx:T}}}),rr=new j({props:{name:"create_discussion",anchor:"huggingface_hub.HfApi.create_discussion",parameters:[{name:"repo_id",val:": str"},{name:"title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"description",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"pull_request",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_discussion.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
The title of the discussion. It can be up to 200 characters long,
and must be at least 3 characters long. Leading and trailing whitespaces
will be stripped.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_discussion.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional description for the Pull Request.
Defaults to <code>&quot;Discussion opened with the huggingface_hub Python library&quot;</code>`,name:"description"},{anchor:"huggingface_hub.HfApi.create_discussion.pull_request",description:`<strong>pull_request</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to create a Pull Request or discussion. If <code>True</code>, creates a Pull Request.
If <code>False</code>, creates a discussion. Defaults to <code>False</code>.`,name:"pull_request"},{anchor:"huggingface_hub.HfApi.create_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6386"}}),Do=new I({props:{$$slots:{default:[dq]},$$scope:{ctx:T}}}),ir=new j({props:{name:"create_inference_endpoint",anchor:"huggingface_hub.HfApi.create_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"repository",val:": str"},{name:"framework",val:": str"},{name:"accelerator",val:": str"},{name:"instance_size",val:": str"},{name:"instance_type",val:": str"},{name:"region",val:": str"},{name:"vendor",val:": str"},{name:"account_id",val:": Optional[str] = None"},{name:"min_replica",val:": int = 1"},{name:"max_replica",val:": int = 1"},{name:"scale_to_zero_timeout",val:": Optional[int] = None"},{name:"revision",val:": Optional[str] = None"},{name:"task",val:": Optional[str] = None"},{name:"custom_image",val:": Optional[Dict] = None"},{name:"env",val:": Optional[Dict[str, str]] = None"},{name:"secrets",val:": Optional[Dict[str, str]] = None"},{name:"type",val:": InferenceEndpointType = <InferenceEndpointType.PROTECTED: 'protected'>"},{name:"domain",val:": Optional[str] = None"},{name:"path",val:": Optional[str] = None"},{name:"cache_http_responses",val:": Optional[bool] = None"},{name:"tags",val:": Optional[List[str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The unique name for the new Inference Endpoint.`,name:"name"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.repository",description:`<strong>repository</strong> (<code>str</code>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.accelerator",description:`<strong>accelerator</strong> (<code>str</code>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.instance_size",description:`<strong>instance_size</strong> (<code>str</code>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;x4&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.instance_type",description:`<strong>instance_type</strong> (<code>str</code>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;intel-icl&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.region",description:`<strong>region</strong> (<code>str</code>) &#x2014;
The cloud region in which the Inference Endpoint will be created (e.g. <code>&quot;us-east-1&quot;</code>).`,name:"region"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.vendor",description:`<strong>vendor</strong> (<code>str</code>) &#x2014;
The cloud provider or vendor where the Inference Endpoint will be hosted (e.g. <code>&quot;aws&quot;</code>).`,name:"vendor"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.account_id",description:`<strong>account_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The account ID used to link a VPC to a private Inference Endpoint (if applicable).`,name:"account_id"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint. To enable
scaling to zero, set this value to 0 and adjust <code>scale_to_zero_timeout</code> accordingly. Defaults to 1.`,name:"min_replica"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint. Defaults to 1.`,name:"max_replica"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.scale_to_zero_timeout",description:`<strong>scale_to_zero_timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The duration in minutes before an inactive endpoint is scaled to zero, or no scaling to zero if
set to None and <code>min_replica</code> is not 0. Defaults to None.`,name:"scale_to_zero_timeout"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.custom_image",description:`<strong>custom_image</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A custom Docker image to use for the Inference Endpoint. This is useful if you want to deploy an
Inference Endpoint running on the <code>text-generation-inference</code> (TGI) framework (see examples).`,name:"custom_image"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.env",description:`<strong>env</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Non-secret environment variables to inject in the container environment.`,name:"env"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.secrets",description:`<strong>secrets</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Secret values to inject in the container environment.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.type",description:"<strong>type</strong> ([`InferenceEndpointType]<code>, *optional*) -- The type of the Inference Endpoint, which can be </code>&#x201C;protected&#x201D;<code>(default),</code>&#x201C;public&#x201D;<code>or</code>&#x201C;private&#x201D;`.",name:"type"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.domain",description:`<strong>domain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom domain for the Inference Endpoint deployment, if setup the inference endpoint will be available at this domain (e.g. <code>&quot;my-new-domain.cool-website.woof&quot;</code>).`,name:"domain"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.path",description:`<strong>path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom path to the deployed model, should start with a <code>/</code> (e.g. <code>&quot;/models/google-bert/bert-base-uncased&quot;</code>).`,name:"path"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.cache_http_responses",description:`<strong>cache_http_responses</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to cache HTTP responses from the Inference Endpoint. Defaults to <code>False</code>.`,name:"cache_http_responses"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of tags to associate with the Inference Endpoint.`,name:"tags"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7589",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the updated Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Ro=new U({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example",$$slots:{default:[gq]},$$scope:{ctx:T}}}),Fo=new U({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example-2",$$slots:{default:[uq]},$$scope:{ctx:T}}}),Go=new U({props:{anchor:"huggingface_hub.HfApi.create_inference_endpoint.example-3",$$slots:{default:[hq]},$$scope:{ctx:T}}}),cr=new j({props:{name:"create_inference_endpoint_from_catalog",anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog",parameters:[{name:"repo_id",val:": str"},{name:"name",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"namespace",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The ID of the model in the catalog to deploy as an Inference Endpoint.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.name",description:`<strong>name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The unique name for the new Inference Endpoint. If not provided, a random name will be generated.`,name:"name"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).`,name:"token"},{anchor:"huggingface_hub.HfApi.create_inference_endpoint_from_catalog.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be created. Defaults to the current user&#x2019;s namespace.`,name:"namespace"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7818",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the new Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),So=new I({props:{warning:!0,$$slots:{default:[fq]},$$scope:{ctx:T}}}),lr=new j({props:{name:"create_pull_request",anchor:"huggingface_hub.HfApi.create_pull_request",parameters:[{name:"repo_id",val:": str"},{name:"title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"description",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_pull_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_pull_request.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
The title of the discussion. It can be up to 200 characters long,
and must be at least 3 characters long. Leading and trailing whitespaces
will be stripped.`,name:"title"},{anchor:"huggingface_hub.HfApi.create_pull_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_pull_request.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional description for the Pull Request.
Defaults to <code>&quot;Discussion opened with the huggingface_hub Python library&quot;</code>`,name:"description"},{anchor:"huggingface_hub.HfApi.create_pull_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6478"}}),Lo=new I({props:{$$slots:{default:[mq]},$$scope:{ctx:T}}}),pr=new j({props:{name:"create_repo",anchor:"huggingface_hub.HfApi.create_repo",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"private",val:": Optional[bool] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"},{name:"resource_group_id",val:": Optional[str] = None"},{name:"space_sdk",val:": Optional[str] = None"},{name:"space_hardware",val:": Optional[SpaceHardware] = None"},{name:"space_storage",val:": Optional[SpaceStorage] = None"},{name:"space_sleep_time",val:": Optional[int] = None"},{name:"space_secrets",val:": Optional[List[Dict[str, str]]] = None"},{name:"space_variables",val:": Optional[List[Dict[str, str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_repo.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_repo.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"huggingface_hub.HfApi.create_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_repo.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo already exists.`,name:"exist_ok"},{anchor:"huggingface_hub.HfApi.create_repo.resource_group_id",description:`<strong>resource_group_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Resource group in which to create the repo. Resource groups is only available for Enterprise Hub organizations and
allow to define which members of the organization can access the resource. The ID of a resource group
can be found in the URL of the resource&#x2019;s page on the Hub (e.g. <code>&quot;66670e5163145ca562cb1988&quot;</code>).
To learn more about resource groups, see <a href="https://huggingface.co/docs/hub/en/security-resource-groups" rel="nofollow">https://huggingface.co/docs/hub/en/security-resource-groups</a>.`,name:"resource_group_id"},{anchor:"huggingface_hub.HfApi.create_repo.space_sdk",description:`<strong>space_sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Choice of SDK to use if repo_type is &#x201C;space&#x201D;. Can be &#x201C;streamlit&#x201D;, &#x201C;gradio&#x201D;, &#x201C;docker&#x201D;, or &#x201C;static&#x201D;.`,name:"space_sdk"},{anchor:"huggingface_hub.HfApi.create_repo.space_hardware",description:`<strong>space_hardware</strong> (<code>SpaceHardware</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of Hardware if repo_type is &#x201C;space&#x201D;. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for a complete list.`,name:"space_hardware"},{anchor:"huggingface_hub.HfApi.create_repo.space_storage",description:`<strong>space_storage</strong> (<code>SpaceStorage</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of persistent storage tier. Example: <code>&quot;small&quot;</code>. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a> for a complete list.`,name:"space_storage"},{anchor:"huggingface_hub.HfApi.create_repo.space_sleep_time",description:`<strong>space_sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"space_sleep_time"},{anchor:"huggingface_hub.HfApi.create_repo.space_secrets",description:`<strong>space_secrets</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of secret keys to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,name:"space_secrets"},{anchor:"huggingface_hub.HfApi.create_repo.space_variables",description:`<strong>space_variables</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of public environment variables to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>.`,name:"space_variables"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3617",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL to the newly created repo. Value is a subclass of <code>str</code> containing
attributes like <code>endpoint</code>, <code>repo_type</code> and <code>repo_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.RepoUrl"
>RepoUrl</a></p>
`}}),dr=new j({props:{name:"create_tag",anchor:"huggingface_hub.HfApi.create_tag",parameters:[{name:"repo_id",val:": str"},{name:"tag",val:": str"},{name:"tag_message",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"exist_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_tag.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a commit will be tagged.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.create_tag.tag",description:`<strong>tag</strong> (<code>str</code>) &#x2014;
The name of the tag to create.`,name:"tag"},{anchor:"huggingface_hub.HfApi.create_tag.tag_message",description:`<strong>tag_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the tag to create.`,name:"tag_message"},{anchor:"huggingface_hub.HfApi.create_tag.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to tag. It can be a branch name or the OID/SHA of a
commit, as a hexadecimal string. Shorthands (7 first characters) are
also supported. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.create_tag.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.create_tag.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if tagging a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.create_tag.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if tag already exists.`,name:"exist_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6038",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the branch already exists on the repo (error 409) and <code>exist_ok</code> is
set to <code>False</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),gr=new j({props:{name:"create_webhook",anchor:"huggingface_hub.HfApi.create_webhook",parameters:[{name:"url",val:": str"},{name:"watched",val:": List[Union[Dict, WebhookWatchedItem]]"},{name:"domains",val:": Optional[List[constants.WEBHOOK_DOMAIN_T]] = None"},{name:"secret",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.create_webhook.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
URL to send the payload to.`,name:"url"},{anchor:"huggingface_hub.HfApi.create_webhook.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>) &#x2014;
List of <code>WebhookWatchedItem</code> to be watched by the webhook. It can be users, orgs, models, datasets or spaces.
Watched items can also be provided as plain dictionaries.`,name:"watched"},{anchor:"huggingface_hub.HfApi.create_webhook.domains",description:`<strong>domains</strong> (<code>List[Literal[&quot;repo&quot;, &quot;discussion&quot;]]</code>, optional) &#x2014;
List of domains to watch. It can be &#x201C;repo&#x201D;, &#x201C;discussion&#x201D; or both.`,name:"domains"},{anchor:"huggingface_hub.HfApi.create_webhook.secret",description:`<strong>secret</strong> (<code>str</code>, optional) &#x2014;
A secret to sign the payload with.`,name:"secret"},{anchor:"huggingface_hub.HfApi.create_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9250",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the newly created webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),Wo=new U({props:{anchor:"huggingface_hub.HfApi.create_webhook.example",$$slots:{default:[_q]},$$scope:{ctx:T}}}),ur=new j({props:{name:"dataset_info",anchor:"huggingface_hub.HfApi.dataset_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandDatasetProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.dataset_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.dataset_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the dataset repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.dataset_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.dataset_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.dataset_info.expand",description:`<strong>expand</strong> (<code>List[ExpandDatasetProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>files_metadata</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;citation&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;description&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;paperswithcode_id&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>,<code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.dataset_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2633",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dataset repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.DatasetInfo"
>hf_api.DatasetInfo</a></p>
`}}),Po=new I({props:{$$slots:{default:[bq]},$$scope:{ctx:T}}}),hr=new j({props:{name:"delete_branch",anchor:"huggingface_hub.HfApi.delete_branch",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_branch.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a branch will be deleted.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_branch.branch",description:`<strong>branch</strong> (<code>str</code>) &#x2014;
The name of the branch to delete.`,name:"branch"},{anchor:"huggingface_hub.HfApi.delete_branch.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_branch.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if creating a branch on a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5986",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If trying to delete a protected branch. Ex: <code>main</code> cannot be deleted.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If trying to delete a branch that does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a></p>
`}}),fr=new j({props:{name:"delete_collection",anchor:"huggingface_hub.HfApi.delete_collection",parameters:[{name:"collection_slug",val:": str"},{name:"missing_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_collection.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to delete. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.delete_collection.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if collection doesn&#x2019;t exists.`,name:"missing_ok"},{anchor:"huggingface_hub.HfApi.delete_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8482"}}),Xo=new U({props:{anchor:"huggingface_hub.HfApi.delete_collection.example",$$slots:{default:[yq]},$$scope:{ctx:T}}}),Yo=new I({props:{warning:!0,$$slots:{default:[vq]},$$scope:{ctx:T}}}),mr=new j({props:{name:"delete_collection_item",anchor:"huggingface_hub.HfApi.delete_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_object_id",val:": str"},{name:"missing_ok",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.delete_collection_item.item_object_id",description:`<strong>item_object_id</strong> (<code>str</code>) &#x2014;
ID of the item in the collection. This is not the id of the item on the Hub (repo_id or paper id).
It must be retrieved from a <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> object. Example: <code>collection.items[0].item_object_id</code>.`,name:"item_object_id"},{anchor:"huggingface_hub.HfApi.delete_collection_item.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, do not raise an error if item doesn&#x2019;t exists.`,name:"missing_ok"},{anchor:"huggingface_hub.HfApi.delete_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8658"}}),zo=new U({props:{anchor:"huggingface_hub.HfApi.delete_collection_item.example",$$slots:{default:[xq]},$$scope:{ctx:T}}}),_r=new j({props:{name:"delete_file",anchor:"huggingface_hub.HfApi.delete_file",parameters:[{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_file.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example:
<code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.delete_file.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the file will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_file.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_file.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if in a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_file.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Delete {path_in_repo} with huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_file.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_file.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_file.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5003"}}),Qo=new I({props:{$$slots:{default:[$q]},$$scope:{ctx:T}}}),br=new j({props:{name:"delete_files",anchor:"huggingface_hub.HfApi.delete_files",parameters:[{name:"repo_id",val:": str"},{name:"delete_patterns",val:": List[str]"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the folder will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_files.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code>) &#x2014;
List of files or folders to delete. Each string can either be
a file path, a folder path or a Unix shell-style wildcard.
E.g. <code>[&quot;file.txt&quot;, &quot;folder/&quot;, &quot;data/*.parquet&quot;]</code>`,name:"delete_patterns"},{anchor:"huggingface_hub.HfApi.delete_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.
to the stored token.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of the repo to delete files from. Can be <code>&quot;model&quot;</code>,
<code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>. Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_files.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary (first line) of the generated commit. Defaults to
<code>f&quot;Delete files using huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_files.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_files.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_files.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5093"}}),yr=new j({props:{name:"delete_folder",anchor:"huggingface_hub.HfApi.delete_folder",parameters:[{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_folder.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative folder path in the repo, for example: <code>&quot;checkpoints/1fec34a&quot;</code>.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.delete_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository from which the folder will be deleted, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_folder.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.
to the stored token.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the folder is in a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if in a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.delete_folder.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Delete folder {path_in_repo} with huggingface_hub&quot;</code>.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.delete_folder.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.delete_folder.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.delete_folder.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5169"}}),vr=new j({props:{name:"delete_inference_endpoint",anchor:"huggingface_hub.HfApi.delete_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to delete.`,name:"name"},{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.delete_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8090"}}),xr=new j({props:{name:"delete_repo",anchor:"huggingface_hub.HfApi.delete_repo",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"missing_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_repo.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.delete_repo.missing_ok",description:`<strong>missing_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo does not exist.`,name:"missing_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3766",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to delete from cannot be found and <code>missing_ok</code> is set to False (default).</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),$r=new j({props:{name:"delete_space_secret",anchor:"huggingface_hub.HfApi.delete_space_secret",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_secret.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_secret.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Secret key. Example: <code>&quot;GITHUB_API_KEY&quot;</code>.`,name:"key"},{anchor:"huggingface_hub.HfApi.delete_space_secret.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7012"}}),wr=new j({props:{name:"delete_space_storage",anchor:"huggingface_hub.HfApi.delete_space_storage",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_storage.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to update. Example: <code>&quot;open-llm-leaderboard/open_llm_leaderboard&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_storage.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7496",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>BadRequestError</code> —
If space has no persistent storage.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>BadRequestError</code></p>
`}}),kr=new j({props:{name:"delete_space_variable",anchor:"huggingface_hub.HfApi.delete_space_variable",parameters:[{name:"repo_id",val:": str"},{name:"key",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_space_variable.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_space_variable.key",description:`<strong>key</strong> (<code>str</code>) &#x2014;
Variable key. Example: <code>&quot;MODEL_REPO_ID&quot;</code>`,name:"key"},{anchor:"huggingface_hub.HfApi.delete_space_variable.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7101"}}),Tr=new j({props:{name:"delete_tag",anchor:"huggingface_hub.HfApi.delete_tag",parameters:[{name:"repo_id",val:": str"},{name:"tag",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_tag.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which a tag will be deleted.
Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.delete_tag.tag",description:`<strong>tag</strong> (<code>str</code>) &#x2014;
The name of the tag to delete.`,name:"tag"},{anchor:"huggingface_hub.HfApi.delete_tag.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.delete_tag.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if tagging a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if tagging a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6112",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If tag is not found.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),qr=new j({props:{name:"delete_webhook",anchor:"huggingface_hub.HfApi.delete_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.delete_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to delete.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.delete_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9504",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>None</code></p>
`}}),ta=new U({props:{anchor:"huggingface_hub.HfApi.delete_webhook.example",$$slots:{default:[wq]},$$scope:{ctx:T}}}),Mr=new j({props:{name:"disable_webhook",anchor:"huggingface_hub.HfApi.disable_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.disable_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to disable.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.disable_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9453",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the disabled webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),na=new U({props:{anchor:"huggingface_hub.HfApi.disable_webhook.example",$$slots:{default:[kq]},$$scope:{ctx:T}}}),jr=new j({props:{name:"duplicate_space",anchor:"huggingface_hub.HfApi.duplicate_space",parameters:[{name:"from_id",val:": str"},{name:"to_id",val:": Optional[str] = None"},{name:"private",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"exist_ok",val:": bool = False"},{name:"hardware",val:": Optional[SpaceHardware] = None"},{name:"storage",val:": Optional[SpaceStorage] = None"},{name:"sleep_time",val:": Optional[int] = None"},{name:"secrets",val:": Optional[List[Dict[str, str]]] = None"},{name:"variables",val:": Optional[List[Dict[str, str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.duplicate_space.from_id",description:`<strong>from_id</strong> (<code>str</code>) &#x2014;
ID of the Space to duplicate. Example: <code>&quot;pharma/CLIP-Interrogator&quot;</code>.`,name:"from_id"},{anchor:"huggingface_hub.HfApi.duplicate_space.to_id",description:`<strong>to_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the new Space. Example: <code>&quot;dog/CLIP-Interrogator&quot;</code>. If not provided, the new Space will have the same
name as the original Space, but in your account.`,name:"to_id"},{anchor:"huggingface_hub.HfApi.duplicate_space.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the new Space should be private or not. Defaults to the same privacy as the original Space.`,name:"private"},{anchor:"huggingface_hub.HfApi.duplicate_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.duplicate_space.exist_ok",description:`<strong>exist_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, do not raise an error if repo already exists.`,name:"exist_ok"},{anchor:"huggingface_hub.HfApi.duplicate_space.hardware",description:`<strong>hardware</strong> (<code>SpaceHardware</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of Hardware. Example: <code>&quot;t4-medium&quot;</code>. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a> for a complete list.`,name:"hardware"},{anchor:"huggingface_hub.HfApi.duplicate_space.storage",description:`<strong>storage</strong> (<code>SpaceStorage</code> or <code>str</code>, <em>optional</em>) &#x2014;
Choice of persistent storage tier. Example: <code>&quot;small&quot;</code>. See <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a> for a complete list.`,name:"storage"},{anchor:"huggingface_hub.HfApi.duplicate_space.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"},{anchor:"huggingface_hub.HfApi.duplicate_space.secrets",description:`<strong>secrets</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of secret keys to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets</a>.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.duplicate_space.variables",description:`<strong>variables</strong> (<code>List[Dict[str, str]]</code>, <em>optional</em>) &#x2014;
A list of public environment variables to set in your Space. Each item is in the form <code>{&quot;key&quot;: ..., &quot;value&quot;: ..., &quot;description&quot;: ...}</code> where description is optional.
For more details, see <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables" rel="nofollow">https://huggingface.co/docs/hub/spaces-overview#managing-secrets-and-environment-variables</a>.`,name:"variables"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7339",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL to the newly created repo. Value is a subclass of <code>str</code> containing
attributes like <code>endpoint</code>, <code>repo_type</code> and <code>repo_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.RepoUrl"
>RepoUrl</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If one of <code>from_id</code> or <code>to_id</code> cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
If the HuggingFace API returned an error</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <code>HTTPError</code></p>
`}}),oa=new U({props:{anchor:"huggingface_hub.HfApi.duplicate_space.example",$$slots:{default:[Tq]},$$scope:{ctx:T}}}),Hr=new j({props:{name:"edit_discussion_comment",anchor:"huggingface_hub.HfApi.edit_discussion_comment",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment_id",val:": str"},{name:"new_content",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.edit_discussion_comment.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.comment_id",description:`<strong>comment_id</strong> (<code>str</code>) &#x2014;
The ID of the comment to edit.`,name:"comment_id"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.new_content",description:`<strong>new_content</strong> (<code>str</code>) &#x2014;
The new content of the comment. Comments support markdown formatting.`,name:"new_content"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.edit_discussion_comment.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6848",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the edited comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),aa=new I({props:{$$slots:{default:[qq]},$$scope:{ctx:T}}}),Cr=new j({props:{name:"enable_webhook",anchor:"huggingface_hub.HfApi.enable_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.enable_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to enable.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.enable_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9402",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the enabled webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),sa=new U({props:{anchor:"huggingface_hub.HfApi.enable_webhook.example",$$slots:{default:[Mq]},$$scope:{ctx:T}}}),Ur=new j({props:{name:"file_exists",anchor:"huggingface_hub.HfApi.file_exists",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.file_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.file_exists.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file to check, for example:
<code>&quot;config.json&quot;</code>`,name:"filename"},{anchor:"huggingface_hub.HfApi.file_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.file_exists.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.file_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2944",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the file exists, False otherwise.</p>
`}}),ra=new U({props:{anchor:"huggingface_hub.HfApi.file_exists.example",$$slots:{default:[jq]},$$scope:{ctx:T}}}),Ir=new j({props:{name:"get_collection",anchor:"huggingface_hub.HfApi.get_collection",parameters:[{name:"collection_slug",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_collection.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection of the Hub. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.get_collection.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8307"}}),ia=new U({props:{anchor:"huggingface_hub.HfApi.get_collection.example",$$slots:{default:[Hq]},$$scope:{ctx:T}}}),Ar=new j({props:{name:"get_dataset_tags",anchor:"huggingface_hub.HfApi.get_dataset_tags",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1840"}}),Nr=new j({props:{name:"get_discussion_details",anchor:"huggingface_hub.HfApi.get_discussion_details",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_discussion_details.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_discussion_details.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.get_discussion_details.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_discussion_details.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6307"}}),la=new I({props:{$$slots:{default:[Cq]},$$scope:{ctx:T}}}),Jr=new j({props:{name:"get_full_repo_name",anchor:"huggingface_hub.HfApi.get_full_repo_name",parameters:[{name:"model_id",val:": str"},{name:"organization",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_full_repo_name.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
The name of the model.`,name:"model_id"},{anchor:"huggingface_hub.HfApi.get_full_repo_name.organization",description:`<strong>organization</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If passed, the repository name will be in the organization
namespace instead of the user namespace.`,name:"organization"},{anchor:"huggingface_hub.HfApi.get_full_repo_name.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6161",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The repository name in the user’s namespace
({username}/{model_id}) if no organization is passed, and under the
organization namespace ({organization}/{model_id}) otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Er=new j({props:{name:"get_hf_file_metadata",anchor:"huggingface_hub.HfApi.get_hf_file_metadata",parameters:[{name:"url",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"proxies",val:": Optional[Dict] = None"},{name:"timeout",val:": Optional[float] = 10"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.url",description:`<strong>url</strong> (<code>str</code>) &#x2014;
File url, for example returned by <code>hf_hub_url()</code>.`,name:"url"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to <code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.get_hf_file_metadata.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>, defaults to 10) &#x2014;
How many seconds to wait for the server to send metadata before giving up.`,name:"timeout"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5356",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>HfFileMetadata</code> object containing metadata such as location, etag, size and commit_hash.</p>
`}}),Dr=new j({props:{name:"get_inference_endpoint",anchor:"huggingface_hub.HfApi.get_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to retrieve information about.`,name:"name"},{anchor:"huggingface_hub.HfApi.get_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.get_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7906",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the requested Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ga=new U({props:{anchor:"huggingface_hub.HfApi.get_inference_endpoint.example",$$slots:{default:[Uq]},$$scope:{ctx:T}}}),Rr=new j({props:{name:"get_model_tags",anchor:"huggingface_hub.HfApi.get_model_tags",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1831"}}),Fr=new j({props:{name:"get_paths_info",anchor:"huggingface_hub.HfApi.get_paths_info",parameters:[{name:"repo_id",val:": str"},{name:"paths",val:": Union[List[str], str]"},{name:"expand",val:": bool = False"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_paths_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_paths_info.paths",description:`<strong>paths</strong> (<code>Union[List[str], str]</code>, <em>optional</em>) &#x2014;
The paths to get information about. If a path do not exist, it is ignored without raising
an exception.`,name:"paths"},{anchor:"huggingface_hub.HfApi.get_paths_info.expand",description:`<strong>expand</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch more information about the paths (e.g. last commit and files&#x2019; security scan results). This
operation is more expensive for the server so only 50 results are returned per page (instead of 1000).
As pagination is implemented in <code>huggingface_hub</code>, this is transparent for you except for the time it
takes to get the results.`,name:"expand"},{anchor:"huggingface_hub.HfApi.get_paths_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.get_paths_info.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository from which to get the information (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_paths_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3329",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The information about the paths, as a list of <code>RepoFile</code> and <code>RepoFolder</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Union[RepoFile, RepoFolder]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),ha=new U({props:{anchor:"huggingface_hub.HfApi.get_paths_info.example",$$slots:{default:[Iq]},$$scope:{ctx:T}}}),Gr=new j({props:{name:"get_repo_discussions",anchor:"huggingface_hub.HfApi.get_repo_discussions",parameters:[{name:"repo_id",val:": str"},{name:"author",val:": Optional[str] = None"},{name:"discussion_type",val:": Optional[constants.DiscussionTypeFilter] = None"},{name:"discussion_status",val:": Optional[constants.DiscussionStatusFilter] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_repo_discussions.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass a value to filter by discussion author. <code>None</code> means no filter.
Default is <code>None</code>.`,name:"author"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.discussion_type",description:`<strong>discussion_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;pull_request&quot;</code> to fetch only pull requests, <code>&quot;discussion&quot;</code>
to fetch only discussions. Set to <code>&quot;all&quot;</code> or <code>None</code> to fetch both.
Default is <code>None</code>.`,name:"discussion_type"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.discussion_status",description:`<strong>discussion_status</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;open&quot;</code> (respectively <code>&quot;closed&quot;</code>) to fetch only open
(respectively closed) discussions. Set to <code>&quot;all&quot;</code> or <code>None</code>
to fetch both.
Default is <code>None</code>.`,name:"discussion_status"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if fetching from a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if fetching from a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_repo_discussions.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6199",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An iterator of <a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.Discussion"
>Discussion</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterator[Discussion]</code></p>
`}}),fa=new U({props:{anchor:"huggingface_hub.HfApi.get_repo_discussions.example",$$slots:{default:[Aq]},$$scope:{ctx:T}}}),ma=new U({props:{anchor:"huggingface_hub.HfApi.get_repo_discussions.example-2",$$slots:{default:[Nq]},$$scope:{ctx:T}}}),Sr=new j({props:{name:"get_safetensors_metadata",anchor:"huggingface_hub.HfApi.get_safetensors_metadata",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if in a
model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to fetch the file from. Can be a branch name, a tag, or a commit hash. Defaults to the
head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5663",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information related to safetensors repo.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>SafetensorsRepoMetadata</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>NotASafetensorsRepoError</code> —
If the repo is not a safetensors repo i.e. doesn’t have either a
<code>model.safetensors</code> or a <code>model.safetensors.index.json</code> file.</li>
<li><code>SafetensorsParsingError</code> —
If a safetensors file header couldn’t be parsed correctly.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>NotASafetensorsRepoError</code> or <code>SafetensorsParsingError</code></p>
`}}),_a=new U({props:{anchor:"huggingface_hub.HfApi.get_safetensors_metadata.example",$$slots:{default:[Jq]},$$scope:{ctx:T}}}),Lr=new j({props:{name:"get_space_runtime",anchor:"huggingface_hub.HfApi.get_space_runtime",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_space_runtime.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_space_runtime.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7129",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),Zr=new j({props:{name:"get_space_variables",anchor:"huggingface_hub.HfApi.get_space_variables",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_space_variables.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to query. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.get_space_variables.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7037"}}),Vr=new j({props:{name:"get_token_permission",anchor:"huggingface_hub.HfApi.get_token_permission",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_token_permission.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1791",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Permission granted by the token (“read” or “write”). Returns <code>None</code> if no
token passed, if token is invalid or if role is not returned by the server. This typically happens when the token is an OAuth token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Literal["read", "write", "fineGrained", None]</code></p>
`}}),ya=new I({props:{warning:!0,$$slots:{default:[Eq]},$$scope:{ctx:T}}}),Wr=new j({props:{name:"get_user_overview",anchor:"huggingface_hub.HfApi.get_user_overview",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_user_overview.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get an overview of.`,name:"username"},{anchor:"huggingface_hub.HfApi.get_user_overview.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9703",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> object with the user’s overview.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>User</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Pr=new j({props:{name:"get_webhook",anchor:"huggingface_hub.HfApi.get_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.get_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to get.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.get_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9149",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),xa=new U({props:{anchor:"huggingface_hub.HfApi.get_webhook.example",$$slots:{default:[Dq]},$$scope:{ctx:T}}}),Br=new j({props:{name:"grant_access",anchor:"huggingface_hub.HfApi.grant_access",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.grant_access.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to grant access to.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.grant_access.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user to grant access.`,name:"user"},{anchor:"huggingface_hub.HfApi.grant_access.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to grant access to. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.grant_access.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9094",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the user already has access to the repo.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Xr=new j({props:{name:"hf_hub_download",anchor:"huggingface_hub.HfApi.hf_hub_download",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"subfolder",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"cache_dir",val:": Union[str, Path, None] = None"},{name:"local_dir",val:": Union[str, Path, None] = None"},{name:"force_download",val:": bool = False"},{name:"proxies",val:": Optional[Dict] = None"},{name:"etag_timeout",val:": float = 10"},{name:"token",val:": Union[bool, str, None] = None"},{name:"local_files_only",val:": bool = False"},{name:"resume_download",val:": Optional[bool] = None"},{name:"force_filename",val:": Optional[str] = None"},{name:"local_dir_use_symlinks",val:": Union[bool, Literal['auto']] = 'auto'"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.hf_hub_download.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.hf_hub_download.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file in the repo.`,name:"filename"},{anchor:"huggingface_hub.HfApi.hf_hub_download.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional value corresponding to a folder inside the repository.`,name:"subfolder"},{anchor:"huggingface_hub.HfApi.hf_hub_download.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if downloading from a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if downloading from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.hf_hub_download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional Git revision id which can be a branch name, a tag, or a
commit hash.`,name:"revision"},{anchor:"huggingface_hub.HfApi.hf_hub_download.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.HfApi.hf_hub_download.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
If provided, the downloaded file will be placed under this directory.`,name:"local_dir"},{anchor:"huggingface_hub.HfApi.hf_hub_download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the file should be downloaded even if it already exists in
the local cache.`,name:"force_download"},{anchor:"huggingface_hub.HfApi.hf_hub_download.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to
<code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.hf_hub_download.etag_timeout",description:`<strong>etag_timeout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10</code>) &#x2014;
When fetching ETag, how many seconds to wait for the server to send
data before giving up which is passed to <code>requests.request</code>.`,name:"etag_timeout"},{anchor:"huggingface_hub.HfApi.hf_hub_download.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.hf_hub_download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the
local cached file if it exists.`,name:"local_files_only"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5398",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Local path of file or if networking is off, last version of file cached on disk.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the revision to download from cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> —
If the file to download cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.LocalEntryNotFoundError"
>LocalEntryNotFoundError</a> —
If network is disabled or unavailable and file is not found in cache.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If <code>token=True</code> but the token cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#OSError"
  rel="nofollow"
><code>OSError</code></a> —
If ETag cannot be determined.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If some parameter value is invalid.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.LocalEntryNotFoundError"
>LocalEntryNotFoundError</a> or <code>EnvironmentError</code> or <code>OSError</code> or <code>ValueError</code></p>
`}}),$a=new U({props:{anchor:"huggingface_hub.HfApi.hf_hub_download.example",$$slots:{default:[Rq]},$$scope:{ctx:T}}}),Yr=new j({props:{name:"hide_discussion_comment",anchor:"huggingface_hub.HfApi.hide_discussion_comment",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"comment_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.hide_discussion_comment.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.comment_id",description:`<strong>comment_id</strong> (<code>str</code>) &#x2014;
The ID of the comment to edit.`,name:"comment_id"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.hide_discussion_comment.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6908",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the hidden comment</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionComment"
>DiscussionComment</a></p>
`}}),wa=new I({props:{warning:!0,$$slots:{default:[Fq]},$$scope:{ctx:T}}}),ka=new I({props:{$$slots:{default:[Gq]},$$scope:{ctx:T}}}),zr=new j({props:{name:"list_accepted_access_requests",anchor:"huggingface_hub.HfApi.list_accepted_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8778",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Ta=new U({props:{anchor:"huggingface_hub.HfApi.list_accepted_access_requests.example",$$slots:{default:[Sq]},$$scope:{ctx:T}}}),Qr=new j({props:{name:"list_collections",anchor:"huggingface_hub.HfApi.list_collections",parameters:[{name:"owner",val:": Union[List[str], str, None] = None"},{name:"item",val:": Union[List[str], str, None] = None"},{name:"sort",val:": Optional[Literal['lastModified', 'trending', 'upvotes']] = None"},{name:"limit",val:": Optional[int] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_collections.owner",description:`<strong>owner</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
Filter by owner&#x2019;s username.`,name:"owner"},{anchor:"huggingface_hub.HfApi.list_collections.item",description:`<strong>item</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
Filter collections containing a particular items. Example: <code>&quot;models/teknium/OpenHermes-2.5-Mistral-7B&quot;</code>, <code>&quot;datasets/squad&quot;</code> or <code>&quot;papers/2311.12983&quot;</code>.`,name:"item"},{anchor:"huggingface_hub.HfApi.list_collections.sort",description:`<strong>sort</strong> (<code>Literal[&quot;lastModified&quot;, &quot;trending&quot;, &quot;upvotes&quot;]</code>, <em>optional</em>) &#x2014;
Sort collections by last modified, trending or upvotes.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_collections.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of collections to be returned.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_collections.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8248",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.Collection"
>Collection</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[Collection]</code></p>
`}}),qa=new I({props:{warning:!0,$$slots:{default:[Lq]},$$scope:{ctx:T}}}),Or=new j({props:{name:"list_datasets",anchor:"huggingface_hub.HfApi.list_datasets",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"benchmark",val:": Optional[Union[str, List[str]]] = None"},{name:"dataset_name",val:": Optional[str] = None"},{name:"gated",val:": Optional[bool] = None"},{name:"language_creators",val:": Optional[Union[str, List[str]]] = None"},{name:"language",val:": Optional[Union[str, List[str]]] = None"},{name:"multilinguality",val:": Optional[Union[str, List[str]]] = None"},{name:"size_categories",val:": Optional[Union[str, List[str]]] = None"},{name:"tags",val:": Optional[Union[str, List[str]]] = None"},{name:"task_categories",val:": Optional[Union[str, List[str]]] = None"},{name:"task_ids",val:": Optional[Union[str, List[str]]] = None"},{name:"search",val:": Optional[str] = None"},{name:"sort",val:": Optional[Union[Literal['last_modified'], str]] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandDatasetProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_datasets.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable[str]</code>, <em>optional</em>) &#x2014;
A string or list of string to filter datasets on the hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_datasets.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author of the returned datasets.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_datasets.benchmark",description:`<strong>benchmark</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by their official benchmark.`,name:"benchmark"},{anchor:"huggingface_hub.HfApi.list_datasets.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by its name, such as <code>SQAC</code> or <code>wikineural</code>`,name:"dataset_name"},{anchor:"huggingface_hub.HfApi.list_datasets.gated",description:`<strong>gated</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A boolean to filter datasets on the Hub that are gated or not. By default, all datasets are returned.
If <code>gated=True</code> is passed, only gated datasets are returned.
If <code>gated=False</code> is passed, only non-gated datasets are returned.`,name:"gated"},{anchor:"huggingface_hub.HfApi.list_datasets.language_creators",description:`<strong>language_creators</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub with how the data was curated, such as <code>crowdsourced</code> or
<code>machine_generated</code>.`,name:"language_creators"},{anchor:"huggingface_hub.HfApi.list_datasets.language",description:`<strong>language</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings representing a two-character language to
filter datasets by on the Hub.`,name:"language"},{anchor:"huggingface_hub.HfApi.list_datasets.multilinguality",description:`<strong>multilinguality</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings representing a filter for datasets that
contain multiple languages.`,name:"multilinguality"},{anchor:"huggingface_hub.HfApi.list_datasets.size_categories",description:`<strong>size_categories</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the size of the dataset such as <code>100K&lt;n&lt;1M</code> or
<code>1M&lt;n&lt;10M</code>.`,name:"size_categories"},{anchor:"huggingface_hub.HfApi.list_datasets.tags",description:`<strong>tags</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string tag or a list of tags to filter datasets on the Hub.`,name:"tags"},{anchor:"huggingface_hub.HfApi.list_datasets.task_categories",description:`<strong>task_categories</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the designed task, such as <code>audio_classification</code> or
<code>named_entity_recognition</code>.`,name:"task_categories"},{anchor:"huggingface_hub.HfApi.list_datasets.task_ids",description:`<strong>task_ids</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings that can be used to identify datasets on
the Hub by the specific task such as <code>speech_emotion_recognition</code> or
<code>paraphrase</code>.`,name:"task_ids"},{anchor:"huggingface_hub.HfApi.list_datasets.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned datasets.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_datasets.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D;, &#x201C;downloads&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_datasets.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_datasets.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of datasets fetched. Leaving this option
to <code>None</code> fetches all datasets.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_datasets.expand",description:`<strong>expand</strong> (<code>List[ExpandDatasetProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;citation&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;description&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;paperswithcode_id&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_datasets.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all dataset data, including the <code>last_modified</code>,
the <code>card_data</code> and  the files. Can contain useful information such as the
PapersWithCode ID.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_datasets.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2068",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.DatasetInfo"
>huggingface_hub.hf_api.DatasetInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[DatasetInfo]</code></p>
`}}),Ma=new U({props:{anchor:"huggingface_hub.HfApi.list_datasets.example",$$slots:{default:[Zq]},$$scope:{ctx:T}}}),ja=new U({props:{anchor:"huggingface_hub.HfApi.list_datasets.example-2",$$slots:{default:[Vq]},$$scope:{ctx:T}}}),Kr=new j({props:{name:"list_inference_catalog",anchor:"huggingface_hub.HfApi.list_inference_catalog",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_inference_catalog.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7873",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of model IDs available in the catalog.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<code>str</code></p>
`}}),Ha=new I({props:{warning:!0,$$slots:{default:[Wq]},$$scope:{ctx:T}}}),ei=new j({props:{name:"list_inference_endpoints",anchor:"huggingface_hub.HfApi.list_inference_endpoints",parameters:[{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_inference_endpoints.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace to list endpoints for. Defaults to the current user. Set to <code>&quot;*&quot;</code> to list all endpoints
from all namespaces (i.e. personal namespace and all orgs the user belongs to).`,name:"namespace"},{anchor:"huggingface_hub.HfApi.list_inference_endpoints.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7531",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of all inference endpoints for the given namespace.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Ca=new U({props:{anchor:"huggingface_hub.HfApi.list_inference_endpoints.example",$$slots:{default:[Pq]},$$scope:{ctx:T}}}),ti=new j({props:{name:"list_lfs_files",anchor:"huggingface_hub.HfApi.list_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository for which you are listing LFS files.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of repository. Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing from a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3492",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An iterator of <code>LFSFileInfo</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[LFSFileInfo]</code></p>
`}}),Ua=new U({props:{anchor:"huggingface_hub.HfApi.list_lfs_files.example",$$slots:{default:[Bq]},$$scope:{ctx:T}}}),ni=new j({props:{name:"list_liked_repos",anchor:"huggingface_hub.HfApi.list_liked_repos",parameters:[{name:"user",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_liked_repos.user",description:`<strong>user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the user for which you want to fetch the likes.`,name:"user"},{anchor:"huggingface_hub.HfApi.list_liked_repos.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2440",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>object containing the user name and 3 lists of repo ids (1 for
models, 1 for datasets and 1 for Spaces).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.UserLikes"
>UserLikes</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>user</code> is not passed and no token found (either from argument or from machine).</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Ia=new U({props:{anchor:"huggingface_hub.HfApi.list_liked_repos.example",$$slots:{default:[Xq]},$$scope:{ctx:T}}}),oi=new j({props:{name:"list_models",anchor:"huggingface_hub.HfApi.list_models",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"gated",val:": Optional[bool] = None"},{name:"inference",val:": Optional[Literal['warm']] = None"},{name:"inference_provider",val:": Optional[Union[Literal['all'], 'PROVIDER_T', List['PROVIDER_T']]] = None"},{name:"library",val:": Optional[Union[str, List[str]]] = None"},{name:"language",val:": Optional[Union[str, List[str]]] = None"},{name:"model_name",val:": Optional[str] = None"},{name:"task",val:": Optional[Union[str, List[str]]] = None"},{name:"trained_dataset",val:": Optional[Union[str, List[str]]] = None"},{name:"tags",val:": Optional[Union[str, List[str]]] = None"},{name:"search",val:": Optional[str] = None"},{name:"pipeline_tag",val:": Optional[str] = None"},{name:"emissions_thresholds",val:": Optional[Tuple[float, float]] = None"},{name:"sort",val:": Union[Literal['last_modified'], str, None] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandModelProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"cardData",val:": bool = False"},{name:"fetch_config",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_models.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable[str]</code>, <em>optional</em>) &#x2014;
A string or list of string to filter models on the Hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_models.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author (user or organization) of the
returned models.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_models.gated",description:`<strong>gated</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A boolean to filter models on the Hub that are gated or not. By default, all models are returned.
If <code>gated=True</code> is passed, only gated models are returned.
If <code>gated=False</code> is passed, only non-gated models are returned.`,name:"gated"},{anchor:"huggingface_hub.HfApi.list_models.inference",description:`<strong>inference</strong> (<code>Literal[&quot;warm&quot;]</code>, <em>optional</em>) &#x2014;
If &#x201C;warm&#x201D;, filter models on the Hub currently served by at least one provider.`,name:"inference"},{anchor:"huggingface_hub.HfApi.list_models.inference_provider",description:`<strong>inference_provider</strong> (<code>Literal[&quot;all&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
A string to filter models on the Hub that are served by a specific provider.
Pass <code>&quot;all&quot;</code> to get all models served by at least one provider.`,name:"inference_provider"},{anchor:"huggingface_hub.HfApi.list_models.library",description:`<strong>library</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings of foundational libraries models were
originally trained from, such as pytorch, tensorflow, or allennlp.`,name:"library"},{anchor:"huggingface_hub.HfApi.list_models.language",description:`<strong>language</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings of languages, both by name and country
code, such as &#x201C;en&#x201D; or &#x201C;English&#x201D;`,name:"language"},{anchor:"huggingface_hub.HfApi.list_models.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that contain complete or partial names for models on the
Hub, such as &#x201C;bert&#x201D; or &#x201C;bert-base-cased&#x201D;`,name:"model_name"},{anchor:"huggingface_hub.HfApi.list_models.task",description:`<strong>task</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string or list of strings of tasks models were designed for, such
as: &#x201C;fill-mask&#x201D; or &#x201C;automatic-speech-recognition&#x201D;`,name:"task"},{anchor:"huggingface_hub.HfApi.list_models.trained_dataset",description:`<strong>trained_dataset</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string tag or a list of string tags of the trained dataset for a
model on the Hub.`,name:"trained_dataset"},{anchor:"huggingface_hub.HfApi.list_models.tags",description:`<strong>tags</strong> (<code>str</code> or <code>List</code>, <em>optional</em>) &#x2014;
A string tag or a list of tags to filter models on the Hub by, such
as <code>text-generation</code> or <code>spacy</code>.`,name:"tags"},{anchor:"huggingface_hub.HfApi.list_models.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned model ids.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_models.pipeline_tag",description:`<strong>pipeline_tag</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string pipeline tag to filter models on the Hub by, such as <code>summarization</code>.`,name:"pipeline_tag"},{anchor:"huggingface_hub.HfApi.list_models.emissions_thresholds",description:`<strong>emissions_thresholds</strong> (<code>Tuple</code>, <em>optional</em>) &#x2014;
A tuple of two ints or floats representing a minimum and maximum
carbon footprint to filter the resulting models with in grams.`,name:"emissions_thresholds"},{anchor:"huggingface_hub.HfApi.list_models.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D;, &#x201C;downloads&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_models.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_models.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of models fetched. Leaving this option
to <code>None</code> fetches all models.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_models.expand",description:`<strong>expand</strong> (<code>List[ExpandModelProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code>, <code>cardData</code> or <code>fetch_config</code> are passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;config&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;gguf&quot;</code>, <code>&quot;inference&quot;</code>, <code>&quot;inferenceProviderMapping&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;library_name&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;mask_token&quot;</code>, <code>&quot;model-index&quot;</code>, <code>&quot;pipeline_tag&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;safetensors&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;spaces&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;transformersInfo&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;widgetData&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_models.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all model data, including the <code>last_modified</code>,
the <code>sha</code>, the files and the <code>tags</code>. This is set to <code>True</code> by
default when using a filter.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_models.cardData",description:`<strong>cardData</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to grab the metadata for the model as well. Can contain
useful information such as carbon emissions, metrics, and
datasets trained on.`,name:"cardData"},{anchor:"huggingface_hub.HfApi.list_models.fetch_config",description:`<strong>fetch_config</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch the model configs as well. This is not included
in <code>full</code> due to its size.`,name:"fetch_config"},{anchor:"huggingface_hub.HfApi.list_models.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1849",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[ModelInfo]</code></p>
`}}),Aa=new U({props:{anchor:"huggingface_hub.HfApi.list_models.example",$$slots:{default:[Yq]},$$scope:{ctx:T}}}),ai=new j({props:{name:"list_organization_members",anchor:"huggingface_hub.HfApi.list_organization_members",parameters:[{name:"organization",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_organization_members.organization",description:`<strong>organization</strong> (<code>str</code>) &#x2014;
Name of the organization to get the members of.`,name:"organization"},{anchor:"huggingface_hub.HfApi.list_organization_members.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9729",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the members of the organization.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the organization does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),si=new j({props:{name:"list_papers",anchor:"huggingface_hub.HfApi.list_papers",parameters:[{name:"query",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_papers.query",description:`<strong>query</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A search query string to find papers.
If provided, returns papers that match the query.`,name:"query"},{anchor:"huggingface_hub.HfApi.list_papers.token",description:`<strong>token</strong> (Union[bool, str, None], <em>optional</em>) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9813",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <code>huggingface_hub.hf_api.PaperInfo</code> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[PaperInfo]</code></p>
`}}),Ja=new U({props:{anchor:"huggingface_hub.HfApi.list_papers.example",$$slots:{default:[zq]},$$scope:{ctx:T}}}),ri=new j({props:{name:"list_pending_access_requests",anchor:"huggingface_hub.HfApi.list_pending_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_pending_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_pending_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_pending_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8714",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Ea=new U({props:{anchor:"huggingface_hub.HfApi.list_pending_access_requests.example",$$slots:{default:[Qq]},$$scope:{ctx:T}}}),ii=new j({props:{name:"list_rejected_access_requests",anchor:"huggingface_hub.HfApi.list_rejected_access_requests",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to get access requests for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to get access requests for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8840",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <code>AccessRequest</code> objects. Each time contains a <code>username</code>, <code>email</code>,
<code>status</code> and <code>timestamp</code> attribute. If the gated repo has a custom form, the <code>fields</code> attribute will
be populated with user’s answers.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AccessRequest]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Da=new U({props:{anchor:"huggingface_hub.HfApi.list_rejected_access_requests.example",$$slots:{default:[Oq]},$$scope:{ctx:T}}}),ci=new j({props:{name:"list_repo_commits",anchor:"huggingface_hub.HfApi.list_repo_commits",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"},{name:"revision",val:": Optional[str] = None"},{name:"formatted",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_commits.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_commits.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing commits from a dataset or a Space, <code>None</code> or <code>&quot;model&quot;</code> if
listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_commits.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.list_repo_commits.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_commits.formatted",description:`<strong>formatted</strong> (<code>bool</code>) &#x2014;
Whether to return the HTML-formatted title and description of the commits. Defaults to False.`,name:"formatted"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3243",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of objects containing information about the commits for a repo on the Hub.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List[<a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitCommitInfo"
>GitCommitInfo</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a></p>
`}}),Ra=new U({props:{anchor:"huggingface_hub.HfApi.list_repo_commits.example",$$slots:{default:[Kq]},$$scope:{ctx:T}}}),li=new j({props:{name:"list_repo_files",anchor:"huggingface_hub.HfApi.list_repo_files",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to
a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3002",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the list of files in a given repository.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),pi=new j({props:{name:"list_repo_likers",anchor:"huggingface_hub.HfApi.list_repo_likers",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_likers.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to retrieve . Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_likers.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.list_repo_likers.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2516",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>huggingface_hub.hf_api.User</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`}}),di=new j({props:{name:"list_repo_refs",anchor:"huggingface_hub.HfApi.list_repo_refs",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"include_pull_requests",val:": bool = False"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_refs.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_refs.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing refs from a dataset or a Space,
<code>None</code> or <code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_refs.include_pull_requests",description:`<strong>include_pull_requests</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to include refs from pull requests in the list. Defaults to <code>False</code>.`,name:"include_pull_requests"},{anchor:"huggingface_hub.HfApi.list_repo_refs.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3171",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>object containing all information about branches and tags for a
repo on the Hub.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefs"
>GitRefs</a></p>
`}}),Ga=new U({props:{anchor:"huggingface_hub.HfApi.list_repo_refs.example",$$slots:{default:[eM]},$$scope:{ctx:T}}}),gi=new j({props:{name:"list_repo_tree",anchor:"huggingface_hub.HfApi.list_repo_tree",parameters:[{name:"repo_id",val:": str"},{name:"path_in_repo",val:": Optional[str] = None"},{name:"recursive",val:": bool = False"},{name:"expand",val:": bool = False"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_repo_tree.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.list_repo_tree.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the tree (folder) in the repo, for example:
<code>&quot;checkpoints/1fec34a/results&quot;</code>. Will default to the root tree (folder) of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.list_repo_tree.recursive",description:`<strong>recursive</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to list tree&#x2019;s files and folders recursively.`,name:"recursive"},{anchor:"huggingface_hub.HfApi.list_repo_tree.expand",description:`<strong>expand</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch more information about the tree&#x2019;s files and folders (e.g. last commit and files&#x2019; security scan results). This
operation is more expensive for the server so only 50 results are returned per page (instead of 1000).
As pagination is implemented in <code>huggingface_hub</code>, this is transparent for you except for the time it
takes to get the results.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_repo_tree.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the tree. Defaults to <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.list_repo_tree.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository from which to get the tree (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.list_repo_tree.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3039",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The information about the tree’s files and folders, as an iterable of <code>RepoFile</code> and <code>RepoFolder</code> objects. The order of the files and folders is
not guaranteed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[Union[RepoFile, RepoFolder]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If revision is not found (error 404) on the repo.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a> —
If the tree (folder) does not exist (error 404) on the repo.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError"
>EntryNotFoundError</a></p>
`}}),Sa=new U({props:{anchor:"huggingface_hub.HfApi.list_repo_tree.example",$$slots:{default:[tM]},$$scope:{ctx:T}}}),La=new U({props:{anchor:"huggingface_hub.HfApi.list_repo_tree.example-2",$$slots:{default:[nM]},$$scope:{ctx:T}}}),ui=new j({props:{name:"list_spaces",anchor:"huggingface_hub.HfApi.list_spaces",parameters:[{name:"filter",val:": Union[str, Iterable[str], None] = None"},{name:"author",val:": Optional[str] = None"},{name:"search",val:": Optional[str] = None"},{name:"datasets",val:": Union[str, Iterable[str], None] = None"},{name:"models",val:": Union[str, Iterable[str], None] = None"},{name:"linked",val:": bool = False"},{name:"sort",val:": Union[Literal['last_modified'], str, None] = None"},{name:"direction",val:": Optional[Literal[-1]] = None"},{name:"limit",val:": Optional[int] = None"},{name:"expand",val:": Optional[List[ExpandSpaceProperty_T]] = None"},{name:"full",val:": Optional[bool] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_spaces.filter",description:`<strong>filter</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
A string tag or list of tags that can be used to identify Spaces on the Hub.`,name:"filter"},{anchor:"huggingface_hub.HfApi.list_spaces.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string which identify the author of the returned Spaces.`,name:"author"},{anchor:"huggingface_hub.HfApi.list_spaces.search",description:`<strong>search</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string that will be contained in the returned Spaces.`,name:"search"},{anchor:"huggingface_hub.HfApi.list_spaces.datasets",description:`<strong>datasets</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of a dataset.
The name of a specific dataset can be passed as a string.`,name:"datasets"},{anchor:"huggingface_hub.HfApi.list_spaces.models",description:`<strong>models</strong> (<code>str</code> or <code>Iterable</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of a model.
The name of a specific model can be passed as a string.`,name:"models"},{anchor:"huggingface_hub.HfApi.list_spaces.linked",description:`<strong>linked</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return Spaces that make use of either a model or a dataset.`,name:"linked"},{anchor:"huggingface_hub.HfApi.list_spaces.sort",description:`<strong>sort</strong> (<code>Literal[&quot;last_modified&quot;]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The key with which to sort the resulting models. Possible values are &#x201C;last_modified&#x201D;, &#x201C;trending_score&#x201D;,
&#x201C;created_at&#x201D; and &#x201C;likes&#x201D;.`,name:"sort"},{anchor:"huggingface_hub.HfApi.list_spaces.direction",description:`<strong>direction</strong> (<code>Literal[-1]</code> or <code>int</code>, <em>optional</em>) &#x2014;
Direction in which to sort. The value <code>-1</code> sorts by descending
order while all other values sort by ascending order.`,name:"direction"},{anchor:"huggingface_hub.HfApi.list_spaces.limit",description:`<strong>limit</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The limit on the number of Spaces fetched. Leaving this option
to <code>None</code> fetches all Spaces.`,name:"limit"},{anchor:"huggingface_hub.HfApi.list_spaces.expand",description:`<strong>expand</strong> (<code>List[ExpandSpaceProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;datasets&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;models&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;runtime&quot;</code>, <code>&quot;sdk&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;subdomain&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.list_spaces.full",description:`<strong>full</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to fetch all Spaces data, including the <code>last_modified</code>, <code>siblings</code>
and <code>card_data</code> fields.`,name:"full"},{anchor:"huggingface_hub.HfApi.list_spaces.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2279",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.SpaceInfo"
>huggingface_hub.hf_api.SpaceInfo</a> objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[SpaceInfo]</code></p>
`}}),hi=new j({props:{name:"list_user_followers",anchor:"huggingface_hub.HfApi.list_user_followers",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_user_followers.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get the followers of.`,name:"username"},{anchor:"huggingface_hub.HfApi.list_user_followers.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9757",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the followers of the user.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),fi=new j({props:{name:"list_user_following",anchor:"huggingface_hub.HfApi.list_user_following",parameters:[{name:"username",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_user_following.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user to get the users followed by.`,name:"username"},{anchor:"huggingface_hub.HfApi.list_user_following.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9785",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.User"
>User</a> objects with the users followed by the user.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterable[User]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the user does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),mi=new j({props:{name:"list_webhooks",anchor:"huggingface_hub.HfApi.list_webhooks",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.list_webhooks.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9200",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of webhook info objects.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[WebhookInfo]</code></p>
`}}),Pa=new U({props:{anchor:"huggingface_hub.HfApi.list_webhooks.example",$$slots:{default:[oM]},$$scope:{ctx:T}}}),_i=new j({props:{name:"merge_pull_request",anchor:"huggingface_hub.HfApi.merge_pull_request",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"token",val:": Union[bool, str, None] = None"},{name:"comment",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.merge_pull_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.merge_pull_request.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.merge_pull_request.comment",description:`<strong>comment</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional comment to post with the status change.`,name:"comment"},{anchor:"huggingface_hub.HfApi.merge_pull_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.merge_pull_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6792",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the status change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionStatusChange"
>DiscussionStatusChange</a></p>
`}}),Ba=new I({props:{$$slots:{default:[aM]},$$scope:{ctx:T}}}),bi=new j({props:{name:"model_info",anchor:"huggingface_hub.HfApi.model_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"securityStatus",val:": Optional[bool] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandModelProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.model_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.model_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the model repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.model_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.model_info.securityStatus",description:`<strong>securityStatus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to retrieve the security status from the model
repository as well. The security status will be returned in the <code>security_repo_status</code> field.`,name:"securityStatus"},{anchor:"huggingface_hub.HfApi.model_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.model_info.expand",description:`<strong>expand</strong> (<code>List[ExpandModelProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>securityStatus</code> or <code>files_metadata</code> are passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;baseModels&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;childrenModelCount&quot;</code>, <code>&quot;config&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;downloads&quot;</code>, <code>&quot;downloadsAllTime&quot;</code>, <code>&quot;gated&quot;</code>, <code>&quot;gguf&quot;</code>, <code>&quot;inference&quot;</code>, <code>&quot;inferenceProviderMapping&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;library_name&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;mask_token&quot;</code>, <code>&quot;model-index&quot;</code>, <code>&quot;pipeline_tag&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;safetensors&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;spaces&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;transformersInfo&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;widgetData&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.model_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2555",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The model repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a></p>
`}}),Xa=new I({props:{$$slots:{default:[sM]},$$scope:{ctx:T}}}),yi=new j({props:{name:"move_repo",anchor:"huggingface_hub.HfApi.move_repo",parameters:[{name:"from_id",val:": str"},{name:"to_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.move_repo.from_id",description:`<strong>from_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>. Original repository identifier.`,name:"from_id"},{anchor:"huggingface_hub.HfApi.move_repo.to_id",description:`<strong>to_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>. Final repository identifier.`,name:"to_id"},{anchor:"huggingface_hub.HfApi.move_repo.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.move_repo.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3952"}}),Ya=new I({props:{$$slots:{default:[rM]},$$scope:{ctx:T}}}),vi=new j({props:{name:"paper_info",anchor:"huggingface_hub.HfApi.paper_info",parameters:[{name:"id",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.paper_info.id",description:`<strong>id</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
ArXiv id of the paper.`,name:"id"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9859",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>PaperInfo</code> object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PaperInfo</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 If the paper does not exist on the Hub.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),xi=new j({props:{name:"parse_safetensors_file_metadata",anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata",parameters:[{name:"repo_id",val:": str"},{name:"filename",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.filename",description:`<strong>filename</strong> (<code>str</code>) &#x2014;
The name of the file in the repo.`,name:"filename"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if the file is in a dataset or space, <code>None</code> or <code>&quot;model&quot;</code> if in a
model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to fetch the file from. Can be a branch name, a tag, or a commit hash. Defaults to the
head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.parse_safetensors_file_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5803",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information related to a safetensors file.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>SafetensorsFileMetadata</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>NotASafetensorsRepoError</code> —
If the repo is not a safetensors repo i.e. doesn’t have either a
<code>model.safetensors</code> or a <code>model.safetensors.index.json</code> file.</li>
<li><code>SafetensorsParsingError</code> —
If a safetensors file header couldn’t be parsed correctly.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>NotASafetensorsRepoError</code> or <code>SafetensorsParsingError</code></p>
`}}),$i=new j({props:{name:"pause_inference_endpoint",anchor:"huggingface_hub.HfApi.pause_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to pause.`,name:"name"},{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.pause_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8118",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the paused Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),wi=new j({props:{name:"pause_space",anchor:"huggingface_hub.HfApi.pause_space",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.pause_space.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to pause. Example: <code>&quot;Salesforce/BLIP2&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.pause_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7254",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about your Space including <code>stage=PAUSED</code> and requested hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If your Space is not found (error 404). Most probably wrong repo_id or your space is private but you
are not authenticated.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
403 Forbidden: only the owner of a Space can pause it. If you want to manage a Space that you don’t
own, either ask the owner by opening a Discussion or duplicate the Space.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If your Space is a static Space. Static Spaces are always running and never billed. If you want to hide
a static Space, you can set it to private.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),ki=new j({props:{name:"permanently_delete_lfs_files",anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"lfs_files",val:": Iterable[LFSFileInfo]"},{name:"rewrite_history",val:": bool = True"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository for which you are listing LFS files.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.lfs_files",description:`<strong>lfs_files</strong> (<code>Iterable[LFSFileInfo]</code>) &#x2014;
An iterable of <code>LFSFileInfo</code> items to permanently delete from the repo. Use <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_lfs_files">list_lfs_files()</a> to list
all LFS files from a repo.`,name:"lfs_files"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.rewrite_history",description:`<strong>rewrite_history</strong> (<code>bool</code>, <em>optional</em>, default to <code>True</code>) &#x2014;
Whether to rewrite repository history to remove file pointers referencing the deleted LFS files (recommended).`,name:"rewrite_history"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of repository. Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing from a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3546"}}),Qa=new I({props:{warning:!0,$$slots:{default:[iM]},$$scope:{ctx:T}}}),Oa=new U({props:{anchor:"huggingface_hub.HfApi.permanently_delete_lfs_files.example",$$slots:{default:[cM]},$$scope:{ctx:T}}}),Ti=new j({props:{name:"preupload_lfs_files",anchor:"huggingface_hub.HfApi.preupload_lfs_files",parameters:[{name:"repo_id",val:": str"},{name:"additions",val:": Iterable[CommitOperationAdd]"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"num_threads",val:": int = 5"},{name:"free_memory",val:": bool = True"},{name:"gitignore_content",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.preupload_lfs_files.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository in which you will commit the files, for example: <code>&quot;username/custom_transformers&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.operations",description:`<strong>operations</strong> (<code>Iterable</code> of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a>) &#x2014;
The list of files to upload. Warning: the objects in this list will be mutated to include information
relative to the upload. Do not reuse the same objects for multiple commits.`,name:"operations"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of repository to upload to (e.g. <code>&quot;model&quot;</code> -default-, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>).`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not you plan to create a Pull Request with that commit. Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.num_threads",description:`<strong>num_threads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads for uploading files. Defaults to 5.
Setting it to 2 means at most 2 files will be uploaded concurrently.`,name:"num_threads"},{anchor:"huggingface_hub.HfApi.preupload_lfs_files.gitignore_content",description:`<strong>gitignore_content</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The content of the <code>.gitignore</code> file to know which files should be ignored. The order of priority
is to first check if <code>gitignore_content</code> is passed, then check if the <code>.gitignore</code> file is present
in the list of files to commit and finally default to the <code>.gitignore</code> file already hosted on the Hub
(if any).`,name:"gitignore_content"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4347"}}),Ka=new I({props:{warning:!0,$$slots:{default:[lM]},$$scope:{ctx:T}}}),es=new I({props:{warning:!0,$$slots:{default:[pM]},$$scope:{ctx:T}}}),ts=new U({props:{anchor:"huggingface_hub.HfApi.preupload_lfs_files.example",$$slots:{default:[dM]},$$scope:{ctx:T}}}),qi=new j({props:{name:"reject_access_request",anchor:"huggingface_hub.HfApi.reject_access_request",parameters:[{name:"repo_id",val:": str"},{name:"user",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"rejection_reason",val:": Optional[str]"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.reject_access_request.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to reject access request for.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.reject_access_request.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
The username of the user which access request should be rejected.`,name:"user"},{anchor:"huggingface_hub.HfApi.reject_access_request.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to reject access request for. Must be one of <code>model</code>, <code>dataset</code> or <code>space</code>.
Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.reject_access_request.rejection_reason",description:`<strong>rejection_reason</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Optional rejection reason that will be visible to the user (max 200 characters).`,name:"rejection_reason"},{anchor:"huggingface_hub.HfApi.reject_access_request.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9013",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 400 if the repo is not gated.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 403 if you only have read-only access to the repo. This can be the case if you don’t have <code>write</code>
or <code>admin</code> role in the organization the repo belongs to or if you passed a <code>read</code> token.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user does not exist on the Hub.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request cannot be found.</li>
<li><a
  href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError"
  rel="nofollow"
><code>HTTPError</code></a> —
HTTP 404 if the user access request is already in the rejected list.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HTTPError</code></p>
`}}),Mi=new j({props:{name:"rename_discussion",anchor:"huggingface_hub.HfApi.rename_discussion",parameters:[{name:"repo_id",val:": str"},{name:"discussion_num",val:": int"},{name:"new_title",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.rename_discussion.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.rename_discussion.discussion_num",description:`<strong>discussion_num</strong> (<code>int</code>) &#x2014;
The number of the Discussion or Pull Request . Must be a strictly positive integer.`,name:"discussion_num"},{anchor:"huggingface_hub.HfApi.rename_discussion.new_title",description:`<strong>new_title</strong> (<code>str</code>) &#x2014;
The new title for the discussion`,name:"new_title"},{anchor:"huggingface_hub.HfApi.rename_discussion.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.rename_discussion.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L6644",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the title change event</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/community#huggingface_hub.DiscussionTitleChange"
>DiscussionTitleChange</a></p>
`}}),ns=new U({props:{anchor:"huggingface_hub.HfApi.rename_discussion.example",$$slots:{default:[gM]},$$scope:{ctx:T}}}),os=new I({props:{$$slots:{default:[uM]},$$scope:{ctx:T}}}),ji=new j({props:{name:"repo_exists",anchor:"huggingface_hub.HfApi.repo_exists",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.repo_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.repo_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.repo_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2853",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the repository exists, False otherwise.</p>
`}}),as=new U({props:{anchor:"huggingface_hub.HfApi.repo_exists.example",$$slots:{default:[hM]},$$scope:{ctx:T}}}),Hi=new j({props:{name:"repo_info",anchor:"huggingface_hub.HfApi.repo_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[Union[ExpandModelProperty_T, ExpandDatasetProperty_T, ExpandSpaceProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.repo_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.repo_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.repo_info.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.repo_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.repo_info.expand",description:`<strong>expand</strong> (<code>ExpandModelProperty_T</code> or <code>ExpandDatasetProperty_T</code> or <code>ExpandSpaceProperty_T</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>files_metadata</code> is passed.
For an exhaustive list of available properties, check out <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.model_info">model_info()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.dataset_info">dataset_info()</a> or <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.space_info">space_info()</a>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.repo_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.repo_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2779",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The repository information, as a
<a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.DatasetInfo"
>huggingface_hub.hf_api.DatasetInfo</a>, <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.ModelInfo"
>huggingface_hub.hf_api.ModelInfo</a>
or <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.SpaceInfo"
>huggingface_hub.hf_api.SpaceInfo</a> object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[SpaceInfo, DatasetInfo, ModelInfo]</code></p>
`}}),ss=new I({props:{$$slots:{default:[fM]},$$scope:{ctx:T}}}),Ci=new j({props:{name:"request_space_hardware",anchor:"huggingface_hub.HfApi.request_space_hardware",parameters:[{name:"repo_id",val:": str"},{name:"hardware",val:": SpaceHardware"},{name:"token",val:": Union[bool, str, None] = None"},{name:"sleep_time",val:": Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.request_space_hardware.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.request_space_hardware.hardware",description:`<strong>hardware</strong> (<code>str</code> or <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceHardware">SpaceHardware</a>) &#x2014;
Hardware on which to run the Space. Example: <code>&quot;t4-medium&quot;</code>.`,name:"hardware"},{anchor:"huggingface_hub.HfApi.request_space_hardware.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.request_space_hardware.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to sleep (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7150",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),rs=new I({props:{$$slots:{default:[mM]},$$scope:{ctx:T}}}),Ui=new j({props:{name:"request_space_storage",anchor:"huggingface_hub.HfApi.request_space_storage",parameters:[{name:"repo_id",val:": str"},{name:"storage",val:": SpaceStorage"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.request_space_storage.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to update. Example: <code>&quot;open-llm-leaderboard/open_llm_leaderboard&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.request_space_storage.storage",description:`<strong>storage</strong> (<code>str</code> or <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceStorage">SpaceStorage</a>) &#x2014;
Storage tier. Either &#x2018;small&#x2019;, &#x2018;medium&#x2019;, or &#x2018;large&#x2019;.`,name:"storage"},{anchor:"huggingface_hub.HfApi.request_space_storage.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7457",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),is=new I({props:{$$slots:{default:[_M]},$$scope:{ctx:T}}}),Ii=new j({props:{name:"restart_space",anchor:"huggingface_hub.HfApi.restart_space",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"factory_reboot",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.restart_space.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the Space to restart. Example: <code>&quot;Salesforce/BLIP2&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.restart_space.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.restart_space.factory_reboot",description:`<strong>factory_reboot</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the Space will be rebuilt from scratch without caching any requirements.`,name:"factory_reboot"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7293",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about your Space.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If your Space is not found (error 404). Most probably wrong repo_id or your space is private but you
are not authenticated.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
403 Forbidden: only the owner of a Space can restart it. If you want to restart a Space that you don’t
own, either ask the owner by opening a Discussion or duplicate the Space.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If your Space is a static Space. Static Spaces are always running and never billed. If you want to hide
a static Space, you can set it to private.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),Ai=new j({props:{name:"resume_inference_endpoint",anchor:"huggingface_hub.HfApi.resume_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"running_ok",val:": bool = True"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to resume.`,name:"name"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.running_ok",description:`<strong>running_ok</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, the method will not raise an error if the Inference Endpoint is already running. Defaults to
<code>True</code>.`,name:"running_ok"},{anchor:"huggingface_hub.HfApi.resume_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8153",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the resumed Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Ni=new j({props:{name:"revision_exists",anchor:"huggingface_hub.HfApi.revision_exists",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.revision_exists.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.revision_exists.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The revision of the repository to check.`,name:"revision"},{anchor:"huggingface_hub.HfApi.revision_exists.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if getting repository info from a dataset or a space,
<code>None</code> or <code>&quot;model&quot;</code> if getting repository info from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.revision_exists.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2897",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if the repository and the revision exists, False otherwise.</p>
`}}),cs=new U({props:{anchor:"huggingface_hub.HfApi.revision_exists.example",$$slots:{default:[bM]},$$scope:{ctx:T}}}),Ji=new j({props:{name:"run_as_future",anchor:"huggingface_hub.HfApi.run_as_future",parameters:[{name:"fn",val:": Callable[..., R]"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfApi.run_as_future.fn",description:`<strong>fn</strong> (<code>Callable</code>) &#x2014;
The method to run in the background.`,name:"fn"},{anchor:"huggingface_hub.HfApi.run_as_future.*args,",description:`<strong>*args,</strong> **kwargs &#x2014;
Arguments with which the method will be called.`,name:"*args,"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1716",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a <a
  href="https://docs.python.org/3/library/concurrent.futures.html#future-objects"
  rel="nofollow"
>Future</a> instance to
get the result of the task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Future</code></p>
`}}),ls=new U({props:{anchor:"huggingface_hub.HfApi.run_as_future.example",$$slots:{default:[yM]},$$scope:{ctx:T}}}),Ei=new j({props:{name:"scale_to_zero_inference_endpoint",anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to scale to zero.`,name:"name"},{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace in which the Inference Endpoint is located. Defaults to the current user.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.scale_to_zero_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8199",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the scaled-to-zero Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Di=new j({props:{name:"set_space_sleep_time",anchor:"huggingface_hub.HfApi.set_space_sleep_time",parameters:[{name:"repo_id",val:": str"},{name:"sleep_time",val:": int"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.set_space_sleep_time.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repo to update. Example: <code>&quot;bigcode/in-the-stack&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.set_space_sleep_time.sleep_time",description:`<strong>sleep_time</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of seconds of inactivity to wait before a Space is put to sleep. Set to <code>-1</code> if you don&#x2019;t want
your Space to pause (default behavior for upgraded hardware). For free hardware, you can&#x2019;t configure
the sleep time (value is fixed to 48 hours of inactivity).
See <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">https://huggingface.co/docs/hub/spaces-gpus#sleep-time</a> for more details.`,name:"sleep_time"},{anchor:"huggingface_hub.HfApi.set_space_sleep_time.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7203",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Runtime information about a Space including Space stage and hardware.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime"
>SpaceRuntime</a></p>
`}}),ps=new I({props:{$$slots:{default:[vM]},$$scope:{ctx:T}}}),Ri=new j({props:{name:"snapshot_download",anchor:"huggingface_hub.HfApi.snapshot_download",parameters:[{name:"repo_id",val:": str"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"cache_dir",val:": Union[str, Path, None] = None"},{name:"local_dir",val:": Union[str, Path, None] = None"},{name:"proxies",val:": Optional[Dict] = None"},{name:"etag_timeout",val:": float = 10"},{name:"force_download",val:": bool = False"},{name:"token",val:": Union[bool, str, None] = None"},{name:"local_files_only",val:": bool = False"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"max_workers",val:": int = 8"},{name:"tqdm_class",val:": Optional[Type[base_tqdm]] = None"},{name:"local_dir_use_symlinks",val:": Union[bool, Literal['auto']] = 'auto'"},{name:"resume_download",val:": Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.snapshot_download.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A user or an organization name and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.snapshot_download.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if downloading from a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if downloading from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.snapshot_download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional Git revision id which can be a branch name, a tag, or a
commit hash.`,name:"revision"},{anchor:"huggingface_hub.HfApi.snapshot_download.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.HfApi.snapshot_download.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
If provided, the downloaded files will be placed under this directory.`,name:"local_dir"},{anchor:"huggingface_hub.HfApi.snapshot_download.proxies",description:`<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary mapping protocol to the URL of the proxy passed to
<code>requests.request</code>.`,name:"proxies"},{anchor:"huggingface_hub.HfApi.snapshot_download.etag_timeout",description:`<strong>etag_timeout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10</code>) &#x2014;
When fetching ETag, how many seconds to wait for the server to send
data before giving up which is passed to <code>requests.request</code>.`,name:"etag_timeout"},{anchor:"huggingface_hub.HfApi.snapshot_download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the file should be downloaded even if it already exists in the local cache.`,name:"force_download"},{anchor:"huggingface_hub.HfApi.snapshot_download.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.snapshot_download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the
local cached file if it exists.`,name:"local_files_only"},{anchor:"huggingface_hub.HfApi.snapshot_download.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are downloaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.snapshot_download.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not downloaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.snapshot_download.max_workers",description:`<strong>max_workers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of concurrent threads to download files (1 thread = 1 file download).
Defaults to 8.`,name:"max_workers"},{anchor:"huggingface_hub.HfApi.snapshot_download.tqdm_class",description:`<strong>tqdm_class</strong> (<code>tqdm</code>, <em>optional</em>) &#x2014;
If provided, overwrites the default behavior for the progress bar. Passed
argument must inherit from <code>tqdm.auto.tqdm</code> or at least mimic its behavior.
Note that the <code>tqdm_class</code> is not passed to each individual download.
Defaults to the custom HF progress bar that can be disabled by setting
<code>HF_HUB_DISABLE_PROGRESS_BARS</code> environment variable.`,name:"tqdm_class"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5538",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>folder path of the repo snapshot.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the revision to download from cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a> —
If <code>token=True</code> and the token cannot be found.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#OSError"
  rel="nofollow"
><code>OSError</code></a> — if
ETag cannot be determined.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
if some parameter value is invalid.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <code>EnvironmentError</code> or <code>OSError</code> or <code>ValueError</code></p>
`}}),Fi=new j({props:{name:"space_info",anchor:"huggingface_hub.HfApi.space_info",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"timeout",val:": Optional[float] = None"},{name:"files_metadata",val:": bool = False"},{name:"expand",val:": Optional[List[ExpandSpaceProperty_T]] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.space_info.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated
by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.space_info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the space repository from which to get the
information.`,name:"revision"},{anchor:"huggingface_hub.HfApi.space_info.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Whether to set a timeout for the request to the Hub.`,name:"timeout"},{anchor:"huggingface_hub.HfApi.space_info.files_metadata",description:`<strong>files_metadata</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to retrieve metadata for files in the repository
(size, LFS metadata, etc). Defaults to <code>False</code>.`,name:"files_metadata"},{anchor:"huggingface_hub.HfApi.space_info.expand",description:`<strong>expand</strong> (<code>List[ExpandSpaceProperty_T]</code>, <em>optional</em>) &#x2014;
List properties to return in the response. When used, only the properties in the list will be returned.
This parameter cannot be used if <code>full</code> is passed.
Possible values are <code>&quot;author&quot;</code>, <code>&quot;cardData&quot;</code>, <code>&quot;createdAt&quot;</code>, <code>&quot;datasets&quot;</code>, <code>&quot;disabled&quot;</code>, <code>&quot;lastModified&quot;</code>, <code>&quot;likes&quot;</code>, <code>&quot;models&quot;</code>, <code>&quot;private&quot;</code>, <code>&quot;runtime&quot;</code>, <code>&quot;sdk&quot;</code>, <code>&quot;siblings&quot;</code>, <code>&quot;sha&quot;</code>, <code>&quot;subdomain&quot;</code>, <code>&quot;tags&quot;</code>, <code>&quot;trendingScore&quot;</code>, <code>&quot;usedStorage&quot;</code>, <code>&quot;resourceGroup&quot;</code> and <code>&quot;xetEnabled&quot;</code>.`,name:"expand"},{anchor:"huggingface_hub.HfApi.space_info.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2706",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The space repository information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.SpaceInfo"
>SpaceInfo</a></p>
`}}),ds=new I({props:{$$slots:{default:[xM]},$$scope:{ctx:T}}}),Gi=new j({props:{name:"super_squash_history",anchor:"huggingface_hub.HfApi.super_squash_history",parameters:[{name:"repo_id",val:": str"},{name:"branch",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.super_squash_history.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.super_squash_history.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The branch to squash. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"branch"},{anchor:"huggingface_hub.HfApi.super_squash_history.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The commit message to use for the squashed commit.`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.super_squash_history.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if listing commits from a dataset or a Space, <code>None</code> or <code>&quot;model&quot;</code> if
listing from a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.super_squash_history.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3406",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private but not authenticated or repo
does not exist.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> —
If the branch to squash cannot be found.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a> —
If invalid reference for a branch. You cannot squash history on tags.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError"
>RevisionNotFoundError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError"
>BadRequestError</a></p>
`}}),gs=new I({props:{warning:!0,$$slots:{default:[$M]},$$scope:{ctx:T}}}),us=new I({props:{warning:!0,$$slots:{default:[wM]},$$scope:{ctx:T}}}),hs=new U({props:{anchor:"huggingface_hub.HfApi.super_squash_history.example",$$slots:{default:[kM]},$$scope:{ctx:T}}}),Si=new j({props:{name:"unlike",anchor:"huggingface_hub.HfApi.unlike",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Union[bool, str, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.unlike.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to unlike. Example: <code>&quot;user/my-cool-model&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.unlike.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.unlike.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if unliking a dataset or space, <code>None</code> or
<code>&quot;model&quot;</code> if unliking a model. Default is <code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L2389",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If repository is not found (error 404): wrong repo_id/repo_type, private
but not authenticated or repo does not exist.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),fs=new U({props:{anchor:"huggingface_hub.HfApi.unlike.example",$$slots:{default:[TM]},$$scope:{ctx:T}}}),Li=new j({props:{name:"update_collection_item",anchor:"huggingface_hub.HfApi.update_collection_item",parameters:[{name:"collection_slug",val:": str"},{name:"item_object_id",val:": str"},{name:"note",val:": Optional[str] = None"},{name:"position",val:": Optional[int] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_collection_item.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.update_collection_item.item_object_id",description:`<strong>item_object_id</strong> (<code>str</code>) &#x2014;
ID of the item in the collection. This is not the id of the item on the Hub (repo_id or paper id).
It must be retrieved from a <a href="/docs/huggingface_hub/main/ko/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> object. Example: <code>collection.items[0].item_object_id</code>.`,name:"item_object_id"},{anchor:"huggingface_hub.HfApi.update_collection_item.note",description:`<strong>note</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A note to attach to the item in the collection. The maximum size for a note is 500 characters.`,name:"note"},{anchor:"huggingface_hub.HfApi.update_collection_item.position",description:`<strong>position</strong> (<code>int</code>, <em>optional</em>) &#x2014;
New position of the item in the collection.`,name:"position"},{anchor:"huggingface_hub.HfApi.update_collection_item.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8605"}}),ms=new U({props:{anchor:"huggingface_hub.HfApi.update_collection_item.example",$$slots:{default:[qM]},$$scope:{ctx:T}}}),Zi=new j({props:{name:"update_collection_metadata",anchor:"huggingface_hub.HfApi.update_collection_metadata",parameters:[{name:"collection_slug",val:": str"},{name:"title",val:": Optional[str] = None"},{name:"description",val:": Optional[str] = None"},{name:"position",val:": Optional[int] = None"},{name:"private",val:": Optional[bool] = None"},{name:"theme",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_collection_metadata.collection_slug",description:`<strong>collection_slug</strong> (<code>str</code>) &#x2014;
Slug of the collection to update. Example: <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>.`,name:"collection_slug"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the collection to update.`,name:"title"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Description of the collection to update.`,name:"description"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.position",description:`<strong>position</strong> (<code>int</code>, <em>optional</em>) &#x2014;
New position of the collection in the list of collections of the user.`,name:"position"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the collection should be private or not.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.theme",description:`<strong>theme</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Theme of the collection on the Hub.`,name:"theme"},{anchor:"huggingface_hub.HfApi.update_collection_metadata.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L8414"}}),_s=new U({props:{anchor:"huggingface_hub.HfApi.update_collection_metadata.example",$$slots:{default:[MM]},$$scope:{ctx:T}}}),Vi=new j({props:{name:"update_inference_endpoint",anchor:"huggingface_hub.HfApi.update_inference_endpoint",parameters:[{name:"name",val:": str"},{name:"accelerator",val:": Optional[str] = None"},{name:"instance_size",val:": Optional[str] = None"},{name:"instance_type",val:": Optional[str] = None"},{name:"min_replica",val:": Optional[int] = None"},{name:"max_replica",val:": Optional[int] = None"},{name:"scale_to_zero_timeout",val:": Optional[int] = None"},{name:"repository",val:": Optional[str] = None"},{name:"framework",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"task",val:": Optional[str] = None"},{name:"custom_image",val:": Optional[Dict] = None"},{name:"env",val:": Optional[Dict[str, str]] = None"},{name:"secrets",val:": Optional[Dict[str, str]] = None"},{name:"domain",val:": Optional[str] = None"},{name:"path",val:": Optional[str] = None"},{name:"cache_http_responses",val:": Optional[bool] = None"},{name:"tags",val:": Optional[List[str]] = None"},{name:"namespace",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_inference_endpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of the Inference Endpoint to update.`,name:"name"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.accelerator",description:`<strong>accelerator</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.instance_size",description:`<strong>instance_size</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;x4&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.instance_type",description:`<strong>instance_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;intel-icl&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint.`,name:"min_replica"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint.`,name:"max_replica"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.scale_to_zero_timeout",description:`<strong>scale_to_zero_timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The duration in minutes before an inactive endpoint is scaled to zero.`,name:"scale_to_zero_timeout"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.repository",description:`<strong>repository</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.custom_image",description:`<strong>custom_image</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A custom Docker image to use for the Inference Endpoint. This is useful if you want to deploy an
Inference Endpoint running on the <code>text-generation-inference</code> (TGI) framework (see examples).`,name:"custom_image"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.env",description:`<strong>env</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Non-secret environment variables to inject in the container environment`,name:"env"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.secrets",description:`<strong>secrets</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Secret values to inject in the container environment.`,name:"secrets"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.domain",description:`<strong>domain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom domain for the Inference Endpoint deployment, if setup the inference endpoint will be available at this domain (e.g. <code>&quot;my-new-domain.cool-website.woof&quot;</code>).`,name:"domain"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.path",description:`<strong>path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The custom path to the deployed model, should start with a <code>/</code> (e.g. <code>&quot;/models/google-bert/bert-base-uncased&quot;</code>).`,name:"path"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.cache_http_responses",description:`<strong>cache_http_responses</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to cache HTTP responses from the Inference Endpoint.`,name:"cache_http_responses"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of tags to associate with the Inference Endpoint.`,name:"tags"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The namespace where the Inference Endpoint will be updated. Defaults to the current user&#x2019;s namespace.`,name:"namespace"},{anchor:"huggingface_hub.HfApi.update_inference_endpoint.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L7953",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>information about the updated Inference Endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),Wi=new j({props:{name:"update_repo_settings",anchor:"huggingface_hub.HfApi.update_repo_settings",parameters:[{name:"repo_id",val:": str"},{name:"gated",val:": Optional[Literal['auto', 'manual', False]] = None"},{name:"private",val:": Optional[bool] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"xet_enabled",val:": Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_repo_settings.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
A namespace (user or an organization) and a repo name separated by a /.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.update_repo_settings.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
The gated status for the repository. If set to <code>None</code> (default), the <code>gated</code> setting of the repository won&#x2019;t be updated.<ul>
<li>&#x201C;auto&#x201D;: The repository is gated, and access requests are automatically approved or denied based on predefined criteria.</li>
<li>&#x201C;manual&#x201D;: The repository is gated, and access requests require manual approval.</li>
<li>False : The repository is not gated, and anyone can access it.</li>
</ul>`,name:"gated"},{anchor:"huggingface_hub.HfApi.update_repo_settings.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the repository should be private.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_repo_settings.token",description:`<strong>token</strong> (<code>Union[str, bool, None]</code>, <em>optional</em>) &#x2014;
A valid user access token (string). Defaults to the locally saved token,
which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass False.`,name:"token"},{anchor:"huggingface_hub.HfApi.update_repo_settings.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repository to update settings from (<code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>).
Defaults to <code>&quot;model&quot;</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.update_repo_settings.xet_enabled",description:`<strong>xet_enabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the repository should be enabled for Xet Storage.`,name:"xet_enabled"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3871",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If gated is not one of “auto”, “manual”, or False.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If repo_type is not one of the values in constants.REPO_TYPES.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> —
If the request to the Hugging Face Hub API fails.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a> —
If the repository to download from cannot be found. This may be because it doesn’t exist,
or because it is set to <code>private</code> and you do not have access.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError"
>HfHubHTTPError</a> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError"
>RepositoryNotFoundError</a></p>
`}}),Pi=new j({props:{name:"update_repo_visibility",anchor:"huggingface_hub.HfApi.update_repo_visibility",parameters:[{name:"repo_id",val:": str"},{name:"private",val:": bool = False"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_repo_visibility.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A namespace (user or an organization) and a repo name separated by a <code>/</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the repository should be private.`,name:"private"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.update_repo_visibility.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L3816",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The HTTP response in json.</p>
`}}),bs=new I({props:{$$slots:{default:[jM]},$$scope:{ctx:T}}}),Bi=new j({props:{name:"update_webhook",anchor:"huggingface_hub.HfApi.update_webhook",parameters:[{name:"webhook_id",val:": str"},{name:"url",val:": Optional[str] = None"},{name:"watched",val:": Optional[List[Union[Dict, WebhookWatchedItem]]] = None"},{name:"domains",val:": Optional[List[constants.WEBHOOK_DOMAIN_T]] = None"},{name:"secret",val:": Optional[str] = None"},{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.update_webhook.webhook_id",description:`<strong>webhook_id</strong> (<code>str</code>) &#x2014;
The unique identifier of the webhook to be updated.`,name:"webhook_id"},{anchor:"huggingface_hub.HfApi.update_webhook.url",description:`<strong>url</strong> (<code>str</code>, optional) &#x2014;
The URL to which the payload will be sent.`,name:"url"},{anchor:"huggingface_hub.HfApi.update_webhook.watched",description:`<strong>watched</strong> (<code>List[WebhookWatchedItem]</code>, optional) &#x2014;
List of items to watch. It can be users, orgs, models, datasets, or spaces.
Refer to <code>WebhookWatchedItem</code> for more details. Watched items can also be provided as plain dictionaries.`,name:"watched"},{anchor:"huggingface_hub.HfApi.update_webhook.domains",description:`<strong>domains</strong> (<code>List[Literal[&quot;repo&quot;, &quot;discussion&quot;]]</code>, optional) &#x2014;
The domains to watch. This can include &#x201C;repo&#x201D;, &#x201C;discussion&#x201D;, or both.`,name:"domains"},{anchor:"huggingface_hub.HfApi.update_webhook.secret",description:`<strong>secret</strong> (<code>str</code>, optional) &#x2014;
A secret to sign the payload with, providing an additional layer of security.`,name:"secret"},{anchor:"huggingface_hub.HfApi.update_webhook.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved token, which is the recommended
method for authentication (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L9323",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Info about the updated webhook.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WebhookInfo</code></p>
`}}),ys=new U({props:{anchor:"huggingface_hub.HfApi.update_webhook.example",$$slots:{default:[HM]},$$scope:{ctx:T}}}),Xi=new j({props:{name:"upload_file",anchor:"huggingface_hub.HfApi.upload_file",parameters:[{name:"path_or_fileobj",val:": Union[str, Path, bytes, BinaryIO]"},{name:"path_in_repo",val:": str"},{name:"repo_id",val:": str"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_file.path_or_fileobj",description:`<strong>path_or_fileobj</strong> (<code>str</code>, <code>Path</code>, <code>bytes</code>, or <code>IO</code>) &#x2014;
Path to a file on the local machine or binary data stream /
fileobj / buffer.`,name:"path_or_fileobj"},{anchor:"huggingface_hub.HfApi.upload_file.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example:
<code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.upload_file.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_file.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.upload_file.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_file.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.upload_file.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.upload_file.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>.
If <code>revision</code> is not set, PR is opened against the <code>&quot;main&quot;</code> branch. If
<code>revision</code> is set and is a branch, PR is opened against this branch. If
<code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.upload_file.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.upload_file.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4562",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`}}),vs=new I({props:{$$slots:{default:[CM]},$$scope:{ctx:T}}}),xs=new I({props:{warning:!0,$$slots:{default:[UM]},$$scope:{ctx:T}}}),$s=new U({props:{anchor:"huggingface_hub.HfApi.upload_file.example",$$slots:{default:[IM]},$$scope:{ctx:T}}}),Yi=new j({props:{name:"upload_folder",anchor:"huggingface_hub.HfApi.upload_folder",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": Union[str, Path]"},{name:"path_in_repo",val:": Optional[str] = None"},{name:"commit_message",val:": Optional[str] = None"},{name:"commit_description",val:": Optional[str] = None"},{name:"token",val:": Union[str, bool, None] = None"},{name:"repo_type",val:": Optional[str] = None"},{name:"revision",val:": Optional[str] = None"},{name:"create_pr",val:": Optional[bool] = None"},{name:"parent_commit",val:": Optional[str] = None"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"delete_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"run_as_future",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded, for example:
<code>&quot;username/custom_transformers&quot;</code>`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_folder.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the folder to upload on the local file system`,name:"folder_path"},{anchor:"huggingface_hub.HfApi.upload_folder.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the directory in the repo, for example:
<code>&quot;checkpoints/1fec34a/results&quot;</code>. Will default to the root folder of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.HfApi.upload_folder.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfApi.upload_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if uploading to a dataset or
space, <code>None</code> or <code>&quot;model&quot;</code> if uploading to a model. Default is
<code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_folder.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to:
<code>f&quot;Upload {path_in_repo} with huggingface_hub&quot;</code>`,name:"commit_message"},{anchor:"huggingface_hub.HfApi.upload_folder.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.HfApi.upload_folder.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with that commit. Defaults to <code>False</code>. If <code>revision</code> is not
set, PR is opened against the <code>&quot;main&quot;</code> branch. If <code>revision</code> is set and is a branch, PR is opened
against this branch. If <code>revision</code> is set and is not a branch name (example: a commit oid), an
<code>RevisionNotFoundError</code> is returned by the server.`,name:"create_pr"},{anchor:"huggingface_hub.HfApi.upload_folder.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"},{anchor:"huggingface_hub.HfApi.upload_folder.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo while committing
new files. This is useful if you don&#x2019;t know which files have already been uploaded.
Note: to avoid discrepancies the <code>.gitattributes</code> file is not deleted even if it matches the pattern.`,name:"delete_patterns"},{anchor:"huggingface_hub.HfApi.upload_folder.run_as_future",description:`<strong>run_as_future</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to run this method in the background. Background jobs are run sequentially without
blocking the main thread. Passing <code>run_as_future=True</code> will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow">Future</a>
object. Defaults to <code>False</code>.`,name:"run_as_future"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L4770",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of <a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> containing information about the newly created commit (commit hash, commit
url, pr url, commit message,…). If <code>run_as_future=True</code> is passed, returns a Future object which will
contain the result when executed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.CommitInfo"
>CommitInfo</a> or <code>Future</code></p>
`}}),ws=new I({props:{$$slots:{default:[AM]},$$scope:{ctx:T}}}),ks=new I({props:{warning:!0,$$slots:{default:[NM]},$$scope:{ctx:T}}}),Ts=new I({props:{$$slots:{default:[JM]},$$scope:{ctx:T}}}),qs=new U({props:{anchor:"huggingface_hub.HfApi.upload_folder.example",$$slots:{default:[EM]},$$scope:{ctx:T}}}),zi=new j({props:{name:"upload_large_folder",anchor:"huggingface_hub.HfApi.upload_large_folder",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": Union[str, Path]"},{name:"repo_type",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"private",val:": Optional[bool] = None"},{name:"allow_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"ignore_patterns",val:": Optional[Union[List[str], str]] = None"},{name:"num_workers",val:": Optional[int] = None"},{name:"print_report",val:": bool = True"},{name:"print_report_every",val:": int = 60"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.upload_large_folder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repository to which the file will be uploaded.
E.g. <code>&quot;HuggingFaceTB/smollm-corpus&quot;</code>.`,name:"repo_id"},{anchor:"huggingface_hub.HfApi.upload_large_folder.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the folder to upload on the local file system.`,name:"folder_path"},{anchor:"huggingface_hub.HfApi.upload_large_folder.repo_type",description:`<strong>repo_type</strong> (<code>str</code>) &#x2014;
Type of the repository. Must be one of <code>&quot;model&quot;</code>, <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code>.
Unlike in all other <code>HfApi</code> methods, <code>repo_type</code> is explicitly required here. This is to avoid
any mistake when uploading a large folder to the Hub, and therefore prevent from having to re-upload
everything.`,name:"repo_type"},{anchor:"huggingface_hub.HfApi.upload_large_folder.revision",description:`<strong>revision</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The branch to commit to. If not provided, the <code>main</code> branch will be used.`,name:"revision"},{anchor:"huggingface_hub.HfApi.upload_large_folder.private",description:`<strong>private</strong> (<code>bool</code>, <code>optional</code>) &#x2014;
Whether the repository should be private.
If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private.`,name:"private"},{anchor:"huggingface_hub.HfApi.upload_large_folder.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.HfApi.upload_large_folder.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.HfApi.upload_large_folder.num_workers",description:`<strong>num_workers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of workers to start. Defaults to <code>os.cpu_count() - 2</code> (minimum 2).
A higher number of workers may speed up the process if your machine allows it. However, on machines with a
slower connection, it is recommended to keep the number of workers low to ensure better resumability.
Indeed, partially uploaded files will have to be completely re-uploaded if the process is interrupted.`,name:"num_workers"},{anchor:"huggingface_hub.HfApi.upload_large_folder.print_report",description:`<strong>print_report</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to print a report of the upload progress. Defaults to True.
Report is printed to <code>sys.stdout</code> every X seconds (60 by defaults) and overwrites the previous report.`,name:"print_report"},{anchor:"huggingface_hub.HfApi.upload_large_folder.print_report_every",description:`<strong>print_report_every</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Frequency at which the report is printed. Defaults to 60 seconds.`,name:"print_report_every"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L5237"}}),Ms=new I({props:{$$slots:{default:[DM]},$$scope:{ctx:T}}}),js=new I({props:{warning:!0,$$slots:{default:[RM]},$$scope:{ctx:T}}}),Qi=new j({props:{name:"whoami",anchor:"huggingface_hub.HfApi.whoami",parameters:[{name:"token",val:": Union[bool, str, None] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfApi.whoami.token",description:`<strong>token</strong> (Union[bool, str, None], optional) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1756"}}),Oi=new R({props:{title:"API Dataclasses",local:"api-dataclasses",headingTag:"h2"}}),Ki=new R({props:{title:"AccessRequest",local:"huggingface_hub.hf_api.AccessRequest ][ huggingface_hub.hf_api.AccessRequest",headingTag:"h3"}}),ec=new j({props:{name:"class huggingface_hub.hf_api.AccessRequest",anchor:"huggingface_hub.hf_api.AccessRequest",parameters:[{name:"username",val:": str"},{name:"fullname",val:": str"},{name:"email",val:": Optional[str]"},{name:"timestamp",val:": datetime"},{name:"status",val:": Literal['pending', 'accepted', 'rejected']"},{name:"fields",val:": Optional[Dict[str, Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.hf_api.AccessRequest.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Username of the user who requested access.`,name:"username"},{anchor:"huggingface_hub.hf_api.AccessRequest.fullname",description:`<strong>fullname</strong> (<code>str</code>) &#x2014;
Fullname of the user who requested access.`,name:"fullname"},{anchor:"huggingface_hub.hf_api.AccessRequest.email",description:`<strong>email</strong> (<code>Optional[str]</code>) &#x2014;
Email of the user who requested access.
Can only be <code>None</code> in the /accepted list if the user was granted access manually.`,name:"email"},{anchor:"huggingface_hub.hf_api.AccessRequest.timestamp",description:`<strong>timestamp</strong> (<code>datetime</code>) &#x2014;
Timestamp of the request.`,name:"timestamp"},{anchor:"huggingface_hub.hf_api.AccessRequest.status",description:`<strong>status</strong> (<code>Literal[&quot;pending&quot;, &quot;accepted&quot;, &quot;rejected&quot;]</code>) &#x2014;
Status of the request. Can be one of <code>[&quot;pending&quot;, &quot;accepted&quot;, &quot;rejected&quot;]</code>.`,name:"status"},{anchor:"huggingface_hub.hf_api.AccessRequest.fields",description:`<strong>fields</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional fields filled by the user in the gate form.`,name:"fields"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L457"}}),tc=new R({props:{title:"CommitInfo",local:"huggingface_hub.CommitInfo ][ huggingface_hub.CommitInfo",headingTag:"h3"}}),nc=new j({props:{name:"class huggingface_hub.CommitInfo",anchor:"huggingface_hub.CommitInfo",parameters:[{name:"*args",val:""},{name:"commit_url",val:": str"},{name:"_url",val:": Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.CommitInfo.commit_url",description:`<strong>commit_url</strong> (<code>str</code>) &#x2014;
Url where to find the commit.`,name:"commit_url"},{anchor:"huggingface_hub.CommitInfo.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
The summary (first line) of the commit that has been created.`,name:"commit_message"},{anchor:"huggingface_hub.CommitInfo.commit_description",description:`<strong>commit_description</strong> (<code>str</code>) &#x2014;
Description of the commit that has been created. Can be empty.`,name:"commit_description"},{anchor:"huggingface_hub.CommitInfo.oid",description:`<strong>oid</strong> (<code>str</code>) &#x2014;
Commit hash id. Example: <code>&quot;91c54ad1727ee830252e457677f467be0bfd8a57&quot;</code>.`,name:"oid"},{anchor:"huggingface_hub.CommitInfo.pr_url",description:`<strong>pr_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Url to the PR that has been created, if any. Populated when <code>create_pr=True</code>
is passed.`,name:"pr_url"},{anchor:"huggingface_hub.CommitInfo.pr_revision",description:`<strong>pr_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the PR that has been created, if any. Populated when
<code>create_pr=True</code> is passed. Example: <code>&quot;refs/pr/1&quot;</code>.`,name:"pr_revision"},{anchor:"huggingface_hub.CommitInfo.pr_num",description:`<strong>pr_num</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of the PR discussion that has been created, if any. Populated when
<code>create_pr=True</code> is passed. Can be passed as <code>discussion_num</code> in
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_discussion_details">get_discussion_details()</a>. Example: <code>1</code>.`,name:"pr_num"},{anchor:"huggingface_hub.CommitInfo.repo_url",description:`<strong>repo_url</strong> (<code>RepoUrl</code>) &#x2014;
Repo URL of the commit containing info like repo_id, repo_type, etc.`,name:"repo_url"},{anchor:"huggingface_hub.CommitInfo._url",description:`<strong>_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Legacy url for <code>str</code> compatibility. Can be the url to the uploaded file on the Hub (if returned by
<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>), to the uploaded folder on the Hub (if returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>) or to the commit on
the Hub (if returned by <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>). Defaults to <code>commit_url</code>. It is deprecated to use this
attribute. Please use <code>commit_url</code> instead.`,name:"_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L377"}}),oc=new R({props:{title:"DatasetInfo",local:"huggingface_hub.hf_api.DatasetInfo ][ huggingface_hub.DatasetInfo",headingTag:"h3"}}),ac=new j({props:{name:"class huggingface_hub.DatasetInfo",anchor:"huggingface_hub.DatasetInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.DatasetInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of dataset.`,name:"id"},{anchor:"huggingface_hub.DatasetInfo.author",description:`<strong>author</strong> (<code>str</code>) &#x2014;
Author of the dataset.`,name:"author"},{anchor:"huggingface_hub.DatasetInfo.sha",description:`<strong>sha</strong> (<code>str</code>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.DatasetInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.DatasetInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.DatasetInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.DatasetInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the repo disabled.`,name:"disabled"},{anchor:"huggingface_hub.DatasetInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.DatasetInfo.downloads",description:`<strong>downloads</strong> (<code>int</code>) &#x2014;
Number of downloads of the dataset over the last 30 days.`,name:"downloads"},{anchor:"huggingface_hub.DatasetInfo.downloads_all_time",description:`<strong>downloads_all_time</strong> (<code>int</code>) &#x2014;
Cumulated number of downloads of the model since its creation.`,name:"downloads_all_time"},{anchor:"huggingface_hub.DatasetInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the dataset.`,name:"likes"},{anchor:"huggingface_hub.DatasetInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the dataset.`,name:"tags"},{anchor:"huggingface_hub.DatasetInfo.card_data",description:`<strong>card_data</strong> (<code>DatasetCardData</code>, <em>optional</em>) &#x2014;
Model Card Metadata  as a <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.DatasetCardData">huggingface_hub.repocard_data.DatasetCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.DatasetInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the dataset.`,name:"siblings"},{anchor:"huggingface_hub.DatasetInfo.paperswithcode_id",description:`<strong>paperswithcode_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Papers with code ID of the dataset.`,name:"paperswithcode_id"},{anchor:"huggingface_hub.DatasetInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the dataset.`,name:"trending_score"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L938"}}),Cs=new I({props:{$$slots:{default:[FM]},$$scope:{ctx:T}}}),sc=new R({props:{title:"GitRefInfo",local:"huggingface_hub.GitRefInfo ][ huggingface_hub.GitRefInfo",headingTag:"h3"}}),rc=new j({props:{name:"class huggingface_hub.GitRefInfo",anchor:"huggingface_hub.GitRefInfo",parameters:[{name:"name",val:": str"},{name:"ref",val:": str"},{name:"target_commit",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.GitRefInfo.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
Name of the reference (e.g. tag name or branch name).`,name:"name"},{anchor:"huggingface_hub.GitRefInfo.ref",description:`<strong>ref</strong> (<code>str</code>) &#x2014;
Full git ref on the Hub (e.g. <code>&quot;refs/heads/main&quot;</code> or <code>&quot;refs/tags/v1.0&quot;</code>).`,name:"ref"},{anchor:"huggingface_hub.GitRefInfo.target_commit",description:`<strong>target_commit</strong> (<code>str</code>) &#x2014;
OID of the target commit for the ref (e.g. <code>&quot;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&quot;</code>)`,name:"target_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1296"}}),ic=new R({props:{title:"GitCommitInfo",local:"huggingface_hub.GitCommitInfo ][ huggingface_hub.GitCommitInfo",headingTag:"h3"}}),cc=new j({props:{name:"class huggingface_hub.GitCommitInfo",anchor:"huggingface_hub.GitCommitInfo",parameters:[{name:"commit_id",val:": str"},{name:"authors",val:": List[str]"},{name:"created_at",val:": datetime"},{name:"title",val:": str"},{name:"message",val:": str"},{name:"formatted_title",val:": Optional[str]"},{name:"formatted_message",val:": Optional[str]"}],parametersDescription:[{anchor:"huggingface_hub.GitCommitInfo.commit_id",description:`<strong>commit_id</strong> (<code>str</code>) &#x2014;
OID of the commit (e.g. <code>&quot;e7da7f221d5bf496a48136c0cd264e630fe9fcc8&quot;</code>)`,name:"commit_id"},{anchor:"huggingface_hub.GitCommitInfo.authors",description:`<strong>authors</strong> (<code>List[str]</code>) &#x2014;
List of authors of the commit.`,name:"authors"},{anchor:"huggingface_hub.GitCommitInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>) &#x2014;
Datetime when the commit was created.`,name:"created_at"},{anchor:"huggingface_hub.GitCommitInfo.title",description:`<strong>title</strong> (<code>str</code>) &#x2014;
Title of the commit. This is a free-text value entered by the authors.`,name:"title"},{anchor:"huggingface_hub.GitCommitInfo.message",description:`<strong>message</strong> (<code>str</code>) &#x2014;
Description of the commit. This is a free-text value entered by the authors.`,name:"message"},{anchor:"huggingface_hub.GitCommitInfo.formatted_title",description:`<strong>formatted_title</strong> (<code>str</code>) &#x2014;
Title of the commit formatted as HTML. Only returned if <code>formatted=True</code> is set.`,name:"formatted_title"},{anchor:"huggingface_hub.GitCommitInfo.formatted_message",description:`<strong>formatted_message</strong> (<code>str</code>) &#x2014;
Description of the commit formatted as HTML. Only returned if <code>formatted=True</code> is set.`,name:"formatted_message"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1341"}}),lc=new R({props:{title:"GitRefs",local:"huggingface_hub.GitRefs ][ huggingface_hub.GitRefs",headingTag:"h3"}}),pc=new j({props:{name:"class huggingface_hub.GitRefs",anchor:"huggingface_hub.GitRefs",parameters:[{name:"branches",val:": List[GitRefInfo]"},{name:"converts",val:": List[GitRefInfo]"},{name:"tags",val:": List[GitRefInfo]"},{name:"pull_requests",val:": Optional[List[GitRefInfo]] = None"}],parametersDescription:[{anchor:"huggingface_hub.GitRefs.branches",description:`<strong>branches</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about branches on the repo.`,name:"branches"},{anchor:"huggingface_hub.GitRefs.converts",description:`<strong>converts</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about &#x201C;convert&#x201D; refs on the repo.
Converts are refs used (internally) to push preprocessed data in Dataset repos.`,name:"converts"},{anchor:"huggingface_hub.GitRefs.tags",description:`<strong>tags</strong> (<code>List[GitRefInfo]</code>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about tags on the repo.`,name:"tags"},{anchor:"huggingface_hub.GitRefs.pull_requests",description:`<strong>pull_requests</strong> (<code>List[GitRefInfo]</code>, <em>optional</em>) &#x2014;
A list of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.GitRefInfo">GitRefInfo</a> containing information about pull requests on the repo.
Only returned if <code>include_prs=True</code> is set.`,name:"pull_requests"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1315"}}),dc=new R({props:{title:"ModelInfo",local:"huggingface_hub.hf_api.ModelInfo ][ huggingface_hub.ModelInfo",headingTag:"h3"}}),gc=new j({props:{name:"class huggingface_hub.ModelInfo",anchor:"huggingface_hub.ModelInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of model.`,name:"id"},{anchor:"huggingface_hub.ModelInfo.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Author of the model.`,name:"author"},{anchor:"huggingface_hub.ModelInfo.sha",description:`<strong>sha</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.ModelInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.ModelInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.ModelInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.ModelInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the repo disabled.`,name:"disabled"},{anchor:"huggingface_hub.ModelInfo.downloads",description:`<strong>downloads</strong> (<code>int</code>) &#x2014;
Number of downloads of the model over the last 30 days.`,name:"downloads"},{anchor:"huggingface_hub.ModelInfo.downloads_all_time",description:`<strong>downloads_all_time</strong> (<code>int</code>) &#x2014;
Cumulated number of downloads of the model since its creation.`,name:"downloads_all_time"},{anchor:"huggingface_hub.ModelInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.ModelInfo.gguf",description:`<strong>gguf</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
GGUF information of the model.`,name:"gguf"},{anchor:"huggingface_hub.ModelInfo.inference",description:`<strong>inference</strong> (<code>Literal[&quot;warm&quot;]</code>, <em>optional</em>) &#x2014;
Status of the model on Inference Providers. Warm if the model is served by at least one provider.`,name:"inference"},{anchor:"huggingface_hub.ModelInfo.inference_provider_mapping",description:`<strong>inference_provider_mapping</strong> (<code>List[InferenceProviderMapping]</code>, <em>optional</em>) &#x2014;
A list of <code>InferenceProviderMapping</code> ordered after the user&#x2019;s provider order.`,name:"inference_provider_mapping"},{anchor:"huggingface_hub.ModelInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the model.`,name:"likes"},{anchor:"huggingface_hub.ModelInfo.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Library associated with the model.`,name:"library_name"},{anchor:"huggingface_hub.ModelInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the model. Compared to <code>card_data.tags</code>, contains extra tags computed by the Hub
(e.g. supported libraries, model&#x2019;s arXiv).`,name:"tags"},{anchor:"huggingface_hub.ModelInfo.pipeline_tag",description:`<strong>pipeline_tag</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pipeline tag associated with the model.`,name:"pipeline_tag"},{anchor:"huggingface_hub.ModelInfo.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mask token used by the model.`,name:"mask_token"},{anchor:"huggingface_hub.ModelInfo.widget_data",description:`<strong>widget_data</strong> (<code>Any</code>, <em>optional</em>) &#x2014;
Widget data associated with the model.`,name:"widget_data"},{anchor:"huggingface_hub.ModelInfo.model_index",description:`<strong>model_index</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model index for evaluation.`,name:"model_index"},{anchor:"huggingface_hub.ModelInfo.config",description:`<strong>config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model configuration.`,name:"config"},{anchor:"huggingface_hub.ModelInfo.transformers_info",description:`<strong>transformers_info</strong> (<code>TransformersInfo</code>, <em>optional</em>) &#x2014;
Transformers-specific info (auto class, processor, etc.) associated with the model.`,name:"transformers_info"},{anchor:"huggingface_hub.ModelInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the model.`,name:"trending_score"},{anchor:"huggingface_hub.ModelInfo.card_data",description:`<strong>card_data</strong> (<code>ModelCardData</code>, <em>optional</em>) &#x2014;
Model Card Metadata  as a <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.ModelCardData">huggingface_hub.repocard_data.ModelCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.ModelInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the model.`,name:"siblings"},{anchor:"huggingface_hub.ModelInfo.spaces",description:`<strong>spaces</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of spaces using the model.`,name:"spaces"},{anchor:"huggingface_hub.ModelInfo.safetensors",description:`<strong>safetensors</strong> (<code>SafeTensorsInfo</code>, <em>optional</em>) &#x2014;
Model&#x2019;s safetensors information.`,name:"safetensors"},{anchor:"huggingface_hub.ModelInfo.security_repo_status",description:`<strong>security_repo_status</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Model&#x2019;s security scan status.`,name:"security_repo_status"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L739"}}),Us=new I({props:{$$slots:{default:[GM]},$$scope:{ctx:T}}}),uc=new R({props:{title:"RepoSibling",local:"huggingface_hub.hf_api.RepoSibling ][ huggingface_hub.hf_api.RepoSibling",headingTag:"h3"}}),hc=new j({props:{name:"class huggingface_hub.hf_api.RepoSibling",anchor:"huggingface_hub.hf_api.RepoSibling",parameters:[{name:"rfilename",val:": str"},{name:"size",val:": Optional[int] = None"},{name:"blob_id",val:": Optional[str] = None"},{name:"lfs",val:": Optional[BlobLfsInfo] = None"}],parametersDescription:[{anchor:"huggingface_hub.hf_api.RepoSibling.rfilename",description:`<strong>rfilename</strong> (str) &#x2014;
file name, relative to the repo root.`,name:"rfilename"},{anchor:"huggingface_hub.hf_api.RepoSibling.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The file&#x2019;s size, in bytes. This attribute is defined when <code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set
to <code>True</code>. It&#x2019;s <code>None</code> otherwise.`,name:"size"},{anchor:"huggingface_hub.hf_api.RepoSibling.blob_id",description:`<strong>blob_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The file&#x2019;s git OID. This attribute is defined when <code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set to
<code>True</code>. It&#x2019;s <code>None</code> otherwise.`,name:"blob_id"},{anchor:"huggingface_hub.hf_api.RepoSibling.lfs",description:`<strong>lfs</strong> (<code>BlobLfsInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s LFS metadata. This attribute is defined when<code>files_metadata</code> argument of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.repo_info">repo_info()</a> is set to
<code>True</code> and the file is stored with Git LFS. It&#x2019;s <code>None</code> otherwise.`,name:"lfs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L590"}}),Is=new I({props:{$$slots:{default:[SM]},$$scope:{ctx:T}}}),fc=new R({props:{title:"RepoFile",local:"huggingface_hub.hf_api.RepoFile ][ huggingface_hub.hf_api.RepoFile",headingTag:"h3"}}),mc=new j({props:{name:"class huggingface_hub.hf_api.RepoFile",anchor:"huggingface_hub.hf_api.RepoFile",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.hf_api.RepoFile.path",description:`<strong>path</strong> (str) &#x2014;
file path relative to the repo root.`,name:"path"},{anchor:"huggingface_hub.hf_api.RepoFile.size",description:`<strong>size</strong> (<code>int</code>) &#x2014;
The file&#x2019;s size, in bytes.`,name:"size"},{anchor:"huggingface_hub.hf_api.RepoFile.blob_id",description:`<strong>blob_id</strong> (<code>str</code>) &#x2014;
The file&#x2019;s git OID.`,name:"blob_id"},{anchor:"huggingface_hub.hf_api.RepoFile.lfs",description:`<strong>lfs</strong> (<code>BlobLfsInfo</code>) &#x2014;
The file&#x2019;s LFS metadata.`,name:"lfs"},{anchor:"huggingface_hub.hf_api.RepoFile.last_commit",description:`<strong>last_commit</strong> (<code>LastCommitInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s last commit metadata. Only defined if <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_tree">list_repo_tree()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_paths_info">get_paths_info()</a>
are called with <code>expand=True</code>.`,name:"last_commit"},{anchor:"huggingface_hub.hf_api.RepoFile.security",description:`<strong>security</strong> (<code>BlobSecurityInfo</code>, <em>optional</em>) &#x2014;
The file&#x2019;s security scan metadata. Only defined if <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_repo_tree">list_repo_tree()</a> and <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_paths_info">get_paths_info()</a>
are called with <code>expand=True</code>.`,name:"security"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L625"}}),_c=new R({props:{title:"RepoUrl",local:"huggingface_hub.RepoUrl ][ huggingface_hub.RepoUrl",headingTag:"h3"}}),bc=new j({props:{name:"class huggingface_hub.RepoUrl",anchor:"huggingface_hub.RepoUrl",parameters:[{name:"url",val:": Any"},{name:"endpoint",val:": Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.RepoUrl.url",description:`<strong>url</strong> (<code>Any</code>) &#x2014;
String value of the repo url.`,name:"url"},{anchor:"huggingface_hub.RepoUrl.endpoint",description:`<strong>endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Endpoint of the Hub. Defaults to <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a>.`,name:"endpoint"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L529",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If URL cannot be parsed.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>repo_type</code> is unknown.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),As=new U({props:{anchor:"huggingface_hub.RepoUrl.example",$$slots:{default:[LM]},$$scope:{ctx:T}}}),yc=new R({props:{title:"SafetensorsRepoMetadata",local:"huggingface_hub.utils.SafetensorsRepoMetadata ][ huggingface_hub.utils.SafetensorsRepoMetadata",headingTag:"h3"}}),vc=new j({props:{name:"class huggingface_hub.utils.SafetensorsRepoMetadata",anchor:"huggingface_hub.utils.SafetensorsRepoMetadata",parameters:[{name:"metadata",val:": typing.Optional[typing.Dict]"},{name:"sharded",val:": bool"},{name:"weight_map",val:": typing.Dict[str, str]"},{name:"files_metadata",val:": typing.Dict[str, huggingface_hub.utils._safetensors.SafetensorsFileMetadata]"}],parametersDescription:[{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.metadata",description:`<strong>metadata</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The metadata contained in the &#x2018;model.safetensors.index.json&#x2019; file, if it exists. Only populated for sharded
models.`,name:"metadata"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.sharded",description:`<strong>sharded</strong> (<code>bool</code>) &#x2014;
Whether the repo contains a sharded model or not.`,name:"sharded"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.weight_map",description:`<strong>weight_map</strong> (<code>Dict[str, str]</code>) &#x2014;
A map of all weights. Keys are tensor names and values are filenames of the files containing the tensors.`,name:"weight_map"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.files_metadata",description:`<strong>files_metadata</strong> (<code>Dict[str, SafetensorsFileMetadata]</code>) &#x2014;
A map of all files metadata. Keys are filenames and values are the metadata of the corresponding file, as
a <code>SafetensorsFileMetadata</code> object.`,name:"files_metadata"},{anchor:"huggingface_hub.utils.SafetensorsRepoMetadata.parameter_count",description:`<strong>parameter_count</strong> (<code>Dict[str, int]</code>) &#x2014;
A map of the number of parameters per data type. Keys are data types and values are the number of parameters
of that data type.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L73"}}),xc=new R({props:{title:"SafetensorsFileMetadata",local:"huggingface_hub.utils.SafetensorsFileMetadata ][ huggingface_hub.utils.SafetensorsFileMetadata",headingTag:"h3"}}),$c=new j({props:{name:"class huggingface_hub.utils.SafetensorsFileMetadata",anchor:"huggingface_hub.utils.SafetensorsFileMetadata",parameters:[{name:"metadata",val:": typing.Dict[str, str]"},{name:"tensors",val:": typing.Dict[str, huggingface_hub.utils._safetensors.TensorInfo]"}],parametersDescription:[{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.metadata",description:`<strong>metadata</strong> (<code>Dict</code>) &#x2014;
The metadata contained in the file.`,name:"metadata"},{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.tensors",description:`<strong>tensors</strong> (<code>Dict[str, TensorInfo]</code>) &#x2014;
A map of all tensors. Keys are tensor names and values are information about the corresponding tensor, as a
<code>TensorInfo</code> object.`,name:"tensors"},{anchor:"huggingface_hub.utils.SafetensorsFileMetadata.parameter_count",description:`<strong>parameter_count</strong> (<code>Dict[str, int]</code>) &#x2014;
A map of the number of parameters per data type. Keys are data types and values are the number of parameters
of that data type.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L43"}}),wc=new R({props:{title:"SpaceInfo",local:"huggingface_hub.hf_api.SpaceInfo ][ huggingface_hub.SpaceInfo",headingTag:"h3"}}),kc=new j({props:{name:"class huggingface_hub.SpaceInfo",anchor:"huggingface_hub.SpaceInfo",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.SpaceInfo.id",description:`<strong>id</strong> (<code>str</code>) &#x2014;
ID of the Space.`,name:"id"},{anchor:"huggingface_hub.SpaceInfo.author",description:`<strong>author</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Author of the Space.`,name:"author"},{anchor:"huggingface_hub.SpaceInfo.sha",description:`<strong>sha</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Repo SHA at this particular revision.`,name:"sha"},{anchor:"huggingface_hub.SpaceInfo.created_at",description:`<strong>created_at</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of creation of the repo on the Hub. Note that the lowest value is <code>2022-03-02T23:29:04.000Z</code>,
corresponding to the date when we began to store creation dates.`,name:"created_at"},{anchor:"huggingface_hub.SpaceInfo.last_modified",description:`<strong>last_modified</strong> (<code>datetime</code>, <em>optional</em>) &#x2014;
Date of last commit to the repo.`,name:"last_modified"},{anchor:"huggingface_hub.SpaceInfo.private",description:`<strong>private</strong> (<code>bool</code>) &#x2014;
Is the repo private.`,name:"private"},{anchor:"huggingface_hub.SpaceInfo.gated",description:`<strong>gated</strong> (<code>Literal[&quot;auto&quot;, &quot;manual&quot;, False]</code>, <em>optional</em>) &#x2014;
Is the repo gated.
If so, whether there is manual or automatic approval.`,name:"gated"},{anchor:"huggingface_hub.SpaceInfo.disabled",description:`<strong>disabled</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Is the Space disabled.`,name:"disabled"},{anchor:"huggingface_hub.SpaceInfo.host",description:`<strong>host</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Host URL of the Space.`,name:"host"},{anchor:"huggingface_hub.SpaceInfo.subdomain",description:`<strong>subdomain</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Subdomain of the Space.`,name:"subdomain"},{anchor:"huggingface_hub.SpaceInfo.likes",description:`<strong>likes</strong> (<code>int</code>) &#x2014;
Number of likes of the Space.`,name:"likes"},{anchor:"huggingface_hub.SpaceInfo.tags",description:`<strong>tags</strong> (<code>List[str]</code>) &#x2014;
List of tags of the Space.`,name:"tags"},{anchor:"huggingface_hub.SpaceInfo.siblings",description:`<strong>siblings</strong> (<code>List[RepoSibling]</code>) &#x2014;
List of <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.hf_api.RepoSibling">huggingface_hub.hf_api.RepoSibling</a> objects that constitute the Space.`,name:"siblings"},{anchor:"huggingface_hub.SpaceInfo.card_data",description:`<strong>card_data</strong> (<code>SpaceCardData</code>, <em>optional</em>) &#x2014;
Space Card Metadata  as a <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.SpaceCardData">huggingface_hub.repocard_data.SpaceCardData</a> object.`,name:"card_data"},{anchor:"huggingface_hub.SpaceInfo.runtime",description:`<strong>runtime</strong> (<code>SpaceRuntime</code>, <em>optional</em>) &#x2014;
Space runtime information as a <a href="/docs/huggingface_hub/main/ko/package_reference/space_runtime#huggingface_hub.SpaceRuntime">huggingface_hub.hf_api.SpaceRuntime</a> object.`,name:"runtime"},{anchor:"huggingface_hub.SpaceInfo.sdk",description:`<strong>sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
SDK used by the Space.`,name:"sdk"},{anchor:"huggingface_hub.SpaceInfo.models",description:`<strong>models</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of models used by the Space.`,name:"models"},{anchor:"huggingface_hub.SpaceInfo.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of datasets used by the Space.`,name:"datasets"},{anchor:"huggingface_hub.SpaceInfo.trending_score",description:`<strong>trending_score</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Trending score of the Space.`,name:"trending_score"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1057"}}),Ns=new I({props:{$$slots:{default:[ZM]},$$scope:{ctx:T}}}),Tc=new R({props:{title:"TensorInfo",local:"huggingface_hub.utils.TensorInfo ][ huggingface_hub.utils.TensorInfo",headingTag:"h3"}}),qc=new j({props:{name:"class huggingface_hub.utils.TensorInfo",anchor:"huggingface_hub.utils.TensorInfo",parameters:[{name:"dtype",val:": typing.Literal['F64', 'F32', 'F16', 'BF16', 'I64', 'I32', 'I16', 'I8', 'U8', 'BOOL']"},{name:"shape",val:": typing.List[int]"},{name:"data_offsets",val:": typing.Tuple[int, int]"}],parametersDescription:[{anchor:"huggingface_hub.utils.TensorInfo.dtype",description:`<strong>dtype</strong> (<code>str</code>) &#x2014;
The data type of the tensor (&#x201C;F64&#x201D;, &#x201C;F32&#x201D;, &#x201C;F16&#x201D;, &#x201C;BF16&#x201D;, &#x201C;I64&#x201D;, &#x201C;I32&#x201D;, &#x201C;I16&#x201D;, &#x201C;I8&#x201D;, &#x201C;U8&#x201D;, &#x201C;BOOL&#x201D;).`,name:"dtype"},{anchor:"huggingface_hub.utils.TensorInfo.shape",description:`<strong>shape</strong> (<code>List[int]</code>) &#x2014;
The shape of the tensor.`,name:"shape"},{anchor:"huggingface_hub.utils.TensorInfo.data_offsets",description:`<strong>data_offsets</strong> (<code>Tuple[int, int]</code>) &#x2014;
The offsets of the data in the file as a tuple <code>[BEGIN, END]</code>.`,name:"data_offsets"},{anchor:"huggingface_hub.utils.TensorInfo.parameter_count",description:`<strong>parameter_count</strong> (<code>int</code>) &#x2014;
The number of parameters in the tensor.`,name:"parameter_count"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_safetensors.py#L13"}}),Mc=new R({props:{title:"User",local:"huggingface_hub.User ][ huggingface_hub.User",headingTag:"h3"}}),jc=new j({props:{name:"class huggingface_hub.User",anchor:"huggingface_hub.User",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.User.username",description:`<strong>username</strong> (<code>str</code>) &#x2014;
Name of the user on the Hub (unique).`,name:"username"},{anchor:"huggingface_hub.User.fullname",description:`<strong>fullname</strong> (<code>str</code>) &#x2014;
User&#x2019;s full name.`,name:"fullname"},{anchor:"huggingface_hub.User.avatar_url",description:`<strong>avatar_url</strong> (<code>str</code>) &#x2014;
URL of the user&#x2019;s avatar.`,name:"avatar_url"},{anchor:"huggingface_hub.User.details",description:`<strong>details</strong> (<code>str</code>, <em>optional</em>) &#x2014;
User&#x2019;s details.`,name:"details"},{anchor:"huggingface_hub.User.is_following",description:`<strong>is_following</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the authenticated user is following this user.`,name:"is_following"},{anchor:"huggingface_hub.User.is_pro",description:`<strong>is_pro</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the user is a pro user.`,name:"is_pro"},{anchor:"huggingface_hub.User.num_models",description:`<strong>num_models</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of models created by the user.`,name:"num_models"},{anchor:"huggingface_hub.User.num_datasets",description:`<strong>num_datasets</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of datasets created by the user.`,name:"num_datasets"},{anchor:"huggingface_hub.User.num_spaces",description:`<strong>num_spaces</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of spaces created by the user.`,name:"num_spaces"},{anchor:"huggingface_hub.User.num_discussions",description:`<strong>num_discussions</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of discussions initiated by the user.`,name:"num_discussions"},{anchor:"huggingface_hub.User.num_papers",description:`<strong>num_papers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of papers authored by the user.`,name:"num_papers"},{anchor:"huggingface_hub.User.num_upvotes",description:`<strong>num_upvotes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of upvotes received by the user.`,name:"num_upvotes"},{anchor:"huggingface_hub.User.num_likes",description:`<strong>num_likes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of likes given by the user.`,name:"num_likes"},{anchor:"huggingface_hub.User.num_following",description:`<strong>num_following</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of users this user is following.`,name:"num_following"},{anchor:"huggingface_hub.User.num_followers",description:`<strong>num_followers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of users following this user.`,name:"num_followers"},{anchor:"huggingface_hub.User.orgs",description:`<strong>orgs</strong> (list of <code>Organization</code>) &#x2014;
List of organizations the user is part of.`,name:"orgs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1429"}}),Hc=new R({props:{title:"UserLikes",local:"huggingface_hub.UserLikes ][ huggingface_hub.UserLikes",headingTag:"h3"}}),Cc=new j({props:{name:"class huggingface_hub.UserLikes",anchor:"huggingface_hub.UserLikes",parameters:[{name:"user",val:": str"},{name:"total",val:": int"},{name:"datasets",val:": List[str]"},{name:"models",val:": List[str]"},{name:"spaces",val:": List[str]"}],parametersDescription:[{anchor:"huggingface_hub.UserLikes.user",description:`<strong>user</strong> (<code>str</code>) &#x2014;
Name of the user for which we fetched the likes.`,name:"user"},{anchor:"huggingface_hub.UserLikes.total",description:`<strong>total</strong> (<code>int</code>) &#x2014;
Total number of likes.`,name:"total"},{anchor:"huggingface_hub.UserLikes.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>) &#x2014;
List of datasets liked by the user (as repo_ids).`,name:"datasets"},{anchor:"huggingface_hub.UserLikes.models",description:`<strong>models</strong> (<code>List[str]</code>) &#x2014;
List of models liked by the user (as repo_ids).`,name:"models"},{anchor:"huggingface_hub.UserLikes.spaces",description:`<strong>spaces</strong> (<code>List[str]</code>) &#x2014;
List of spaces liked by the user (as repo_ids).`,name:"spaces"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1374"}}),Uc=new R({props:{title:"CommitOperation",local:"huggingface_hub.CommitOperationAdd ][ huggingface_hub.CommitOperationAdd",headingTag:"h2"}}),Ac=new j({props:{name:"class huggingface_hub.CommitOperationAdd",anchor:"huggingface_hub.CommitOperationAdd",parameters:[{name:"path_in_repo",val:": str"},{name:"path_or_fileobj",val:": typing.Union[str, pathlib.Path, bytes, typing.BinaryIO]"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationAdd.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example: <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationAdd.path_or_fileobj",description:`<strong>path_or_fileobj</strong> (<code>str</code>, <code>Path</code>, <code>bytes</code>, or <code>BinaryIO</code>) &#x2014;
Either:<ul>
<li>a path to a local file (as <code>str</code> or <code>pathlib.Path</code>) to upload</li>
<li>a buffer of bytes (<code>bytes</code>) holding the content of the file to upload</li>
<li>a &#x201C;file object&#x201D; (subclass of <code>io.BufferedIOBase</code>), typically obtained
with <code>open(path, &quot;rb&quot;)</code>. It must support <code>seek()</code> and <code>tell()</code> methods.</li>
</ul>`,name:"path_or_fileobj"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L123",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is not one of <code>str</code>, <code>Path</code>, <code>bytes</code> or <code>io.BufferedIOBase</code>.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is a <code>str</code> or <code>Path</code> but not a path to an existing file.</li>
<li><a
  href="https://docs.python.org/3/library/exceptions.html#ValueError"
  rel="nofollow"
><code>ValueError</code></a> —
If <code>path_or_fileobj</code> is a <code>io.BufferedIOBase</code> but it doesn’t support both
<code>seek()</code> and <code>tell()</code>.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Nc=new j({props:{name:"as_file",anchor:"huggingface_hub.CommitOperationAdd.as_file",parameters:[{name:"with_tqdm",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationAdd.as_file.with_tqdm",description:`<strong>with_tqdm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, iterating over the file object will display a progress bar. Only
works if the file-like object is a path to a file. Pure bytes and buffers
are not supported.`,name:"with_tqdm"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L206"}}),Js=new U({props:{anchor:"huggingface_hub.CommitOperationAdd.as_file.example",$$slots:{default:[VM]},$$scope:{ctx:T}}}),Jc=new j({props:{name:"b64content",anchor:"huggingface_hub.CommitOperationAdd.b64content",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L256"}}),Ec=new j({props:{name:"class huggingface_hub.CommitOperationDelete",anchor:"huggingface_hub.CommitOperationDelete",parameters:[{name:"path_in_repo",val:": str"},{name:"is_folder",val:": typing.Union[bool, typing.Literal['auto']] = 'auto'"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationDelete.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo, for example: <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>
for a file or <code>&quot;checkpoints/1fec34a/&quot;</code> for a folder.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationDelete.is_folder",description:`<strong>is_folder</strong> (<code>bool</code> or <code>Literal[&quot;auto&quot;]</code>, <em>optional</em>) &#x2014;
Whether the Delete Operation applies to a folder or not. If &#x201C;auto&#x201D;, the path
type (file or folder) is guessed automatically by looking if path ends with
a &#x201D;/&#x201D; (folder) or not (file). To explicitly set the path type, you can set
<code>is_folder=True</code> or <code>is_folder=False</code>.`,name:"is_folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L56"}}),Dc=new j({props:{name:"class huggingface_hub.CommitOperationCopy",anchor:"huggingface_hub.CommitOperationCopy",parameters:[{name:"src_path_in_repo",val:": str"},{name:"path_in_repo",val:": str"},{name:"src_revision",val:": typing.Optional[str] = None"},{name:"_src_oid",val:": typing.Optional[str] = None"},{name:"_dest_oid",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.CommitOperationCopy.src_path_in_repo",description:`<strong>src_path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo of the file to be copied, e.g. <code>&quot;checkpoints/1fec34a/weights.bin&quot;</code>.`,name:"src_path_in_repo"},{anchor:"huggingface_hub.CommitOperationCopy.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>) &#x2014;
Relative filepath in the repo where to copy the file, e.g. <code>&quot;checkpoints/1fec34a/weights_copy.bin&quot;</code>.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitOperationCopy.src_revision",description:`<strong>src_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision of the file to be copied. Can be any valid git revision.
Default to the target commit revision.`,name:"src_revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_api.py#L87"}}),Rc=new R({props:{title:"CommitScheduler",local:"huggingface_hub.CommitScheduler ][ huggingface_hub.CommitScheduler",headingTag:"h2"}}),Fc=new j({props:{name:"class huggingface_hub.CommitScheduler",anchor:"huggingface_hub.CommitScheduler",parameters:[{name:"repo_id",val:": str"},{name:"folder_path",val:": typing.Union[str, pathlib.Path]"},{name:"every",val:": typing.Union[int, float] = 5"},{name:"path_in_repo",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"allow_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"ignore_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"squash_history",val:": bool = False"},{name:"hf_api",val:": typing.Optional[ForwardRef('HfApi')] = None"}],parametersDescription:[{anchor:"huggingface_hub.CommitScheduler.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The id of the repo to commit to.`,name:"repo_id"},{anchor:"huggingface_hub.CommitScheduler.folder_path",description:`<strong>folder_path</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to the local folder to upload regularly.`,name:"folder_path"},{anchor:"huggingface_hub.CommitScheduler.every",description:`<strong>every</strong> (<code>int</code> or <code>float</code>, <em>optional</em>) &#x2014;
The number of minutes between each commit. Defaults to 5 minutes.`,name:"every"},{anchor:"huggingface_hub.CommitScheduler.path_in_repo",description:`<strong>path_in_repo</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Relative path of the directory in the repo, for example: <code>&quot;checkpoints/&quot;</code>. Defaults to the root folder
of the repository.`,name:"path_in_repo"},{anchor:"huggingface_hub.CommitScheduler.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of the repo to commit to. Defaults to <code>model</code>.`,name:"repo_type"},{anchor:"huggingface_hub.CommitScheduler.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repo to commit to. Defaults to <code>main</code>.`,name:"revision"},{anchor:"huggingface_hub.CommitScheduler.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"huggingface_hub.CommitScheduler.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use to commit to the repo. Defaults to the token saved on the machine.`,name:"token"},{anchor:"huggingface_hub.CommitScheduler.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are uploaded.`,name:"allow_patterns"},{anchor:"huggingface_hub.CommitScheduler.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not uploaded.`,name:"ignore_patterns"},{anchor:"huggingface_hub.CommitScheduler.squash_history",description:`<strong>squash_history</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to squash the history of the repo after each commit. Defaults to <code>False</code>. Squashing commits is
useful to avoid degraded performances on the repo when it grows too large.`,name:"squash_history"},{anchor:"huggingface_hub.CommitScheduler.hf_api",description:`<strong>hf_api</strong> (<code>HfApi</code>, <em>optional</em>) &#x2014;
The <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> client to use to commit to the Hub. Can be set with custom settings (user agent, token,&#x2026;).`,name:"hf_api"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L29"}}),Es=new U({props:{anchor:"huggingface_hub.CommitScheduler.example",$$slots:{default:[WM]},$$scope:{ctx:T}}}),Ds=new U({props:{anchor:"huggingface_hub.CommitScheduler.example-2",$$slots:{default:[PM]},$$scope:{ctx:T}}}),Gc=new j({props:{name:"push_to_hub",anchor:"huggingface_hub.CommitScheduler.push_to_hub",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L204"}}),Rs=new I({props:{warning:!0,$$slots:{default:[BM]},$$scope:{ctx:T}}}),Sc=new j({props:{name:"stop",anchor:"huggingface_hub.CommitScheduler.stop",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L157"}}),Lc=new j({props:{name:"trigger",anchor:"huggingface_hub.CommitScheduler.trigger",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_commit_scheduler.py#L181"}}),Zc=new eq({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/hf_api.md"}}),{c(){o=c("meta"),u=s(),i=c("p"),a=s(),h(g.$$.fragment),e=s(),x=c("p"),x.innerHTML=n1,dh=s(),Vs=c("p"),Vs.innerHTML=o1,gh=s(),Ws=c("p"),Ws.innerHTML=a1,uh=s(),h(Ps.$$.fragment),hh=s(),h(Bs.$$.fragment),fh=s(),w=c("div"),h(Xs.$$.fragment),hf=s(),ll=c("p"),ll.textContent=s1,ff=s(),pl=c("p"),pl.innerHTML=r1,mf=s(),Ce=c("div"),h(Ys.$$.fragment),_f=s(),dl=c("p"),dl.textContent=i1,bf=s(),gl=c("p"),gl.innerHTML=c1,yf=s(),ul=c("p"),ul.innerHTML=l1,vf=s(),Ue=c("div"),h(zs.$$.fragment),xf=s(),hl=c("p"),hl.textContent=p1,$f=s(),fl=c("p"),fl.innerHTML=d1,wf=s(),h(qo.$$.fragment),kf=s(),Xt=c("div"),h(Qs.$$.fragment),Tf=s(),ml=c("p"),ml.textContent=g1,qf=s(),_l=c("p"),_l.innerHTML=u1,Mf=s(),Yt=c("div"),h(Os.$$.fragment),jf=s(),bl=c("p"),bl.textContent=h1,Hf=s(),yl=c("p"),yl.innerHTML=f1,Cf=s(),F=c("div"),h(Ks.$$.fragment),Uf=s(),vl=c("p"),vl.textContent=m1,If=s(),xl=c("p"),xl.textContent=_1,Af=s(),$l=c("p"),$l.textContent=b1,Nf=s(),h(Mo.$$.fragment),Jf=s(),wl=c("p"),wl.textContent=y1,Ef=s(),kl=c("ul"),kl.innerHTML=v1,Df=s(),Ie=c("div"),h(er.$$.fragment),Rf=s(),Tl=c("p"),Tl.textContent=x1,Ff=s(),ql=c("p"),ql.textContent=$1,Gf=s(),Ml=c("p"),Ml.innerHTML=w1,Sf=s(),Ae=c("div"),h(tr.$$.fragment),Lf=s(),jl=c("p"),jl.textContent=k1,Zf=s(),h(jo.$$.fragment),Vf=s(),h(Ho.$$.fragment),Wf=s(),Ne=c("div"),h(nr.$$.fragment),Pf=s(),Hl=c("p"),Hl.textContent=T1,Bf=s(),h(Co.$$.fragment),Xf=s(),h(Uo.$$.fragment),Yf=s(),Io=c("div"),h(or.$$.fragment),zf=s(),Cl=c("p"),Cl.innerHTML=q1,Qf=s(),Je=c("div"),h(ar.$$.fragment),Of=s(),Ul=c("p"),Ul.textContent=M1,Kf=s(),Il=c("p"),Il.innerHTML=j1,em=s(),h(Ao.$$.fragment),tm=s(),se=c("div"),h(sr.$$.fragment),nm=s(),Al=c("p"),Al.textContent=H1,om=s(),h(No.$$.fragment),am=s(),h(Jo.$$.fragment),sm=s(),h(Eo.$$.fragment),rm=s(),Z=c("div"),h(rr.$$.fragment),im=s(),Nl=c("p"),Nl.textContent=C1,cm=s(),Jl=c("p"),Jl.innerHTML=U1,lm=s(),El=c("p"),El.innerHTML=I1,pm=s(),Dl=c("p"),Dl.innerHTML=A1,dm=s(),h(Do.$$.fragment),gm=s(),re=c("div"),h(ir.$$.fragment),um=s(),Rl=c("p"),Rl.textContent=N1,hm=s(),h(Ro.$$.fragment),fm=s(),h(Fo.$$.fragment),mm=s(),h(Go.$$.fragment),_m=s(),Ee=c("div"),h(cr.$$.fragment),bm=s(),Fl=c("p"),Fl.textContent=J1,ym=s(),Gl=c("p"),Gl.innerHTML=E1,vm=s(),h(So.$$.fragment),xm=s(),V=c("div"),h(lr.$$.fragment),$m=s(),Sl=c("p"),Sl.innerHTML=D1,wm=s(),Ll=c("p"),Ll.innerHTML=R1,km=s(),Zl=c("p"),Zl.innerHTML=F1,Tm=s(),Vl=c("p"),Vl.innerHTML=G1,qm=s(),h(Lo.$$.fragment),Mm=s(),Zo=c("div"),h(pr.$$.fragment),jm=s(),Wl=c("p"),Wl.textContent=S1,Hm=s(),Vo=c("div"),h(dr.$$.fragment),Cm=s(),Pl=c("p"),Pl.textContent=L1,Um=s(),zt=c("div"),h(gr.$$.fragment),Im=s(),Bl=c("p"),Bl.textContent=Z1,Am=s(),h(Wo.$$.fragment),Nm=s(),De=c("div"),h(ur.$$.fragment),Jm=s(),Xl=c("p"),Xl.textContent=V1,Em=s(),Yl=c("p"),Yl.textContent=W1,Dm=s(),h(Po.$$.fragment),Rm=s(),Bo=c("div"),h(hr.$$.fragment),Fm=s(),zl=c("p"),zl.textContent=P1,Gm=s(),Re=c("div"),h(fr.$$.fragment),Sm=s(),Ql=c("p"),Ql.textContent=B1,Lm=s(),h(Xo.$$.fragment),Zm=s(),h(Yo.$$.fragment),Vm=s(),Qt=c("div"),h(mr.$$.fragment),Wm=s(),Ol=c("p"),Ol.textContent=X1,Pm=s(),h(zo.$$.fragment),Bm=s(),Ot=c("div"),h(_r.$$.fragment),Xm=s(),Kl=c("p"),Kl.textContent=Y1,Ym=s(),h(Qo.$$.fragment),zm=s(),Kt=c("div"),h(br.$$.fragment),Qm=s(),ep=c("p"),ep.textContent=z1,Om=s(),tp=c("p"),tp.textContent=Q1,Km=s(),en=c("div"),h(yr.$$.fragment),e_=s(),np=c("p"),np.textContent=O1,t_=s(),op=c("p"),op.innerHTML=K1,n_=s(),Fe=c("div"),h(vr.$$.fragment),o_=s(),ap=c("p"),ap.textContent=ew,a_=s(),sp=c("p"),sp.innerHTML=tw,s_=s(),rp=c("p"),rp.innerHTML=nw,r_=s(),Oo=c("div"),h(xr.$$.fragment),i_=s(),ip=c("p"),ip.textContent=ow,c_=s(),tn=c("div"),h($r.$$.fragment),l_=s(),cp=c("p"),cp.textContent=aw,p_=s(),lp=c("p"),lp.innerHTML=sw,d_=s(),Ko=c("div"),h(wr.$$.fragment),g_=s(),pp=c("p"),pp.textContent=rw,u_=s(),nn=c("div"),h(kr.$$.fragment),h_=s(),dp=c("p"),dp.textContent=iw,f_=s(),gp=c("p"),gp.innerHTML=cw,m_=s(),ea=c("div"),h(Tr.$$.fragment),__=s(),up=c("p"),up.textContent=lw,b_=s(),on=c("div"),h(qr.$$.fragment),y_=s(),hp=c("p"),hp.textContent=pw,v_=s(),h(ta.$$.fragment),x_=s(),an=c("div"),h(Mr.$$.fragment),$_=s(),fp=c("p"),fp.textContent=dw,w_=s(),h(na.$$.fragment),k_=s(),Ge=c("div"),h(jr.$$.fragment),T_=s(),mp=c("p"),mp.textContent=gw,q_=s(),_p=c("p"),_p.textContent=uw,M_=s(),h(oa.$$.fragment),j_=s(),sn=c("div"),h(Hr.$$.fragment),H_=s(),bp=c("p"),bp.textContent=hw,C_=s(),h(aa.$$.fragment),U_=s(),rn=c("div"),h(Cr.$$.fragment),I_=s(),yp=c("p"),yp.textContent=fw,A_=s(),h(sa.$$.fragment),N_=s(),cn=c("div"),h(Ur.$$.fragment),J_=s(),vp=c("p"),vp.textContent=mw,E_=s(),h(ra.$$.fragment),D_=s(),Se=c("div"),h(Ir.$$.fragment),R_=s(),xp=c("p"),xp.textContent=_w,F_=s(),$p=c("p"),$p.innerHTML=bw,G_=s(),h(ia.$$.fragment),S_=s(),ca=c("div"),h(Ar.$$.fragment),L_=s(),wp=c("p"),wp.textContent=yw,Z_=s(),Le=c("div"),h(Nr.$$.fragment),V_=s(),kp=c("p"),kp.textContent=vw,W_=s(),Tp=c("p"),Tp.innerHTML=xw,P_=s(),h(la.$$.fragment),B_=s(),pa=c("div"),h(Jr.$$.fragment),X_=s(),qp=c("p"),qp.textContent=$w,Y_=s(),da=c("div"),h(Er.$$.fragment),z_=s(),Mp=c("p"),Mp.textContent=ww,Q_=s(),ln=c("div"),h(Dr.$$.fragment),O_=s(),jp=c("p"),jp.textContent=kw,K_=s(),h(ga.$$.fragment),eb=s(),ua=c("div"),h(Rr.$$.fragment),tb=s(),Hp=c("p"),Hp.textContent=Tw,nb=s(),pn=c("div"),h(Fr.$$.fragment),ob=s(),Cp=c("p"),Cp.textContent=qw,ab=s(),h(ha.$$.fragment),sb=s(),ie=c("div"),h(Gr.$$.fragment),rb=s(),Up=c("p"),Up.textContent=Mw,ib=s(),Ip=c("p"),Ip.textContent=jw,cb=s(),h(fa.$$.fragment),lb=s(),h(ma.$$.fragment),pb=s(),W=c("div"),h(Sr.$$.fragment),db=s(),Ap=c("p"),Ap.textContent=Hw,gb=s(),Np=c("p"),Np.textContent=Cw,ub=s(),Jp=c("p"),Jp.innerHTML=Uw,hb=s(),Ep=c("p"),Ep.innerHTML=Iw,fb=s(),h(_a.$$.fragment),mb=s(),ba=c("div"),h(Lr.$$.fragment),_b=s(),Dp=c("p"),Dp.textContent=Aw,bb=s(),dn=c("div"),h(Zr.$$.fragment),yb=s(),Rp=c("p"),Rp.textContent=Nw,vb=s(),Fp=c("p"),Fp.innerHTML=Jw,xb=s(),Ze=c("div"),h(Vr.$$.fragment),$b=s(),Gp=c("p"),Gp.innerHTML=Ew,wb=s(),h(ya.$$.fragment),kb=s(),Sp=c("p"),Sp.innerHTML=Dw,Tb=s(),va=c("div"),h(Wr.$$.fragment),qb=s(),Lp=c("p"),Lp.textContent=Rw,Mb=s(),gn=c("div"),h(Pr.$$.fragment),jb=s(),Zp=c("p"),Zp.textContent=Fw,Hb=s(),h(xa.$$.fragment),Cb=s(),Ve=c("div"),h(Br.$$.fragment),Ub=s(),Vp=c("p"),Vp.textContent=Gw,Ib=s(),Wp=c("p"),Wp.innerHTML=Sw,Ab=s(),Pp=c("p"),Pp.innerHTML=Lw,Nb=s(),P=c("div"),h(Xr.$$.fragment),Jb=s(),Bp=c("p"),Bp.textContent=Zw,Eb=s(),Xp=c("p"),Xp.textContent=Vw,Db=s(),Yp=c("ul"),Yp.innerHTML=Ww,Rb=s(),h($a.$$.fragment),Fb=s(),zp=c("p"),zp.innerHTML=Pw,Gb=s(),We=c("div"),h(Yr.$$.fragment),Sb=s(),Qp=c("p"),Qp.textContent=Bw,Lb=s(),h(wa.$$.fragment),Zb=s(),h(ka.$$.fragment),Vb=s(),ce=c("div"),h(zr.$$.fragment),Wb=s(),Op=c("p"),Op.textContent=Xw,Pb=s(),Kp=c("p"),Kp.innerHTML=Yw,Bb=s(),ed=c("p"),ed.innerHTML=zw,Xb=s(),h(Ta.$$.fragment),Yb=s(),un=c("div"),h(Qr.$$.fragment),zb=s(),td=c("p"),td.textContent=Qw,Qb=s(),h(qa.$$.fragment),Ob=s(),Pe=c("div"),h(Or.$$.fragment),Kb=s(),nd=c("p"),nd.textContent=Ow,ey=s(),h(Ma.$$.fragment),ty=s(),h(ja.$$.fragment),ny=s(),le=c("div"),h(Kr.$$.fragment),oy=s(),od=c("p"),od.textContent=Kw,ay=s(),ad=c("p"),ad.innerHTML=ek,sy=s(),sd=c("p"),sd.innerHTML=tk,ry=s(),h(Ha.$$.fragment),iy=s(),hn=c("div"),h(ei.$$.fragment),cy=s(),rd=c("p"),rd.textContent=nk,ly=s(),h(Ca.$$.fragment),py=s(),Be=c("div"),h(ti.$$.fragment),dy=s(),id=c("p"),id.textContent=ok,gy=s(),cd=c("p"),cd.innerHTML=ak,uy=s(),h(Ua.$$.fragment),hy=s(),pe=c("div"),h(ni.$$.fragment),fy=s(),ld=c("p"),ld.textContent=sk,my=s(),pd=c("p"),pd.innerHTML=rk,_y=s(),dd=c("p"),dd.innerHTML=ik,by=s(),h(Ia.$$.fragment),yy=s(),fn=c("div"),h(oi.$$.fragment),vy=s(),gd=c("p"),gd.textContent=ck,xy=s(),h(Aa.$$.fragment),$y=s(),Na=c("div"),h(ai.$$.fragment),wy=s(),ud=c("p"),ud.textContent=lk,ky=s(),mn=c("div"),h(si.$$.fragment),Ty=s(),hd=c("p"),hd.textContent=pk,qy=s(),h(Ja.$$.fragment),My=s(),de=c("div"),h(ri.$$.fragment),jy=s(),fd=c("p"),fd.textContent=dk,Hy=s(),md=c("p"),md.innerHTML=gk,Cy=s(),_d=c("p"),_d.innerHTML=uk,Uy=s(),h(Ea.$$.fragment),Iy=s(),ge=c("div"),h(ii.$$.fragment),Ay=s(),bd=c("p"),bd.textContent=hk,Ny=s(),yd=c("p"),yd.innerHTML=fk,Jy=s(),vd=c("p"),vd.innerHTML=mk,Ey=s(),h(Da.$$.fragment),Dy=s(),Xe=c("div"),h(ci.$$.fragment),Ry=s(),xd=c("p"),xd.textContent=_k,Fy=s(),$d=c("p"),$d.textContent=bk,Gy=s(),h(Ra.$$.fragment),Sy=s(),Fa=c("div"),h(li.$$.fragment),Ly=s(),wd=c("p"),wd.textContent=yk,Zy=s(),_n=c("div"),h(pi.$$.fragment),Vy=s(),kd=c("p"),kd.textContent=vk,Wy=s(),Td=c("p"),Td.innerHTML=xk,Py=s(),bn=c("div"),h(di.$$.fragment),By=s(),qd=c("p"),qd.textContent=$k,Xy=s(),h(Ga.$$.fragment),Yy=s(),G=c("div"),h(gi.$$.fragment),zy=s(),Md=c("p"),Md.textContent=wk,Qy=s(),jd=c("p"),jd.textContent=kk,Oy=s(),Hd=c("p"),Hd.textContent=Tk,Ky=s(),h(Sa.$$.fragment),ev=s(),Cd=c("p"),Cd.textContent=qk,tv=s(),h(La.$$.fragment),nv=s(),Za=c("div"),h(ui.$$.fragment),ov=s(),Ud=c("p"),Ud.textContent=Mk,av=s(),Va=c("div"),h(hi.$$.fragment),sv=s(),Id=c("p"),Id.textContent=jk,rv=s(),Wa=c("div"),h(fi.$$.fragment),iv=s(),Ad=c("p"),Ad.textContent=Hk,cv=s(),yn=c("div"),h(mi.$$.fragment),lv=s(),Nd=c("p"),Nd.textContent=Ck,pv=s(),h(Pa.$$.fragment),dv=s(),vn=c("div"),h(_i.$$.fragment),gv=s(),Jd=c("p"),Jd.textContent=Uk,uv=s(),h(Ba.$$.fragment),hv=s(),Ye=c("div"),h(bi.$$.fragment),fv=s(),Ed=c("p"),Ed.textContent=Ik,mv=s(),Dd=c("p"),Dd.textContent=Ak,_v=s(),h(Xa.$$.fragment),bv=s(),ze=c("div"),h(yi.$$.fragment),yv=s(),Rd=c("p"),Rd.textContent=Nk,vv=s(),Fd=c("p"),Fd.innerHTML=Jk,xv=s(),h(Ya.$$.fragment),$v=s(),za=c("div"),h(vi.$$.fragment),wv=s(),Gd=c("p"),Gd.textContent=Ek,kv=s(),Qe=c("div"),h(xi.$$.fragment),Tv=s(),Sd=c("p"),Sd.textContent=Dk,qv=s(),Ld=c("p"),Ld.innerHTML=Rk,Mv=s(),Zd=c("p"),Zd.innerHTML=Fk,jv=s(),Oe=c("div"),h($i.$$.fragment),Hv=s(),Vd=c("p"),Vd.textContent=Gk,Cv=s(),Wd=c("p"),Wd.innerHTML=Sk,Uv=s(),Pd=c("p"),Pd.innerHTML=Lk,Iv=s(),Ke=c("div"),h(wi.$$.fragment),Av=s(),Bd=c("p"),Bd.textContent=Zk,Nv=s(),Xd=c("p"),Xd.innerHTML=Vk,Jv=s(),Yd=c("p"),Yd.innerHTML=Wk,Ev=s(),et=c("div"),h(ki.$$.fragment),Dv=s(),zd=c("p"),zd.textContent=Pk,Rv=s(),h(Qa.$$.fragment),Fv=s(),h(Oa.$$.fragment),Gv=s(),B=c("div"),h(Ti.$$.fragment),Sv=s(),Qd=c("p"),Qd.textContent=Bk,Lv=s(),Od=c("p"),Od.textContent=Xk,Zv=s(),h(Ka.$$.fragment),Vv=s(),h(es.$$.fragment),Wv=s(),h(ts.$$.fragment),Pv=s(),tt=c("div"),h(qi.$$.fragment),Bv=s(),Kd=c("p"),Kd.textContent=Yk,Xv=s(),eg=c("p"),eg.innerHTML=zk,Yv=s(),tg=c("p"),tg.innerHTML=Qk,zv=s(),nt=c("div"),h(Mi.$$.fragment),Qv=s(),ng=c("p"),ng.textContent=Ok,Ov=s(),h(ns.$$.fragment),Kv=s(),h(os.$$.fragment),ex=s(),xn=c("div"),h(ji.$$.fragment),tx=s(),og=c("p"),og.textContent=Kk,nx=s(),h(as.$$.fragment),ox=s(),$n=c("div"),h(Hi.$$.fragment),ax=s(),ag=c("p"),ag.textContent=eT,sx=s(),h(ss.$$.fragment),rx=s(),wn=c("div"),h(Ci.$$.fragment),ix=s(),sg=c("p"),sg.textContent=tT,cx=s(),h(rs.$$.fragment),lx=s(),kn=c("div"),h(Ui.$$.fragment),px=s(),rg=c("p"),rg.textContent=nT,dx=s(),h(is.$$.fragment),gx=s(),ot=c("div"),h(Ii.$$.fragment),ux=s(),ig=c("p"),ig.textContent=oT,hx=s(),cg=c("p"),cg.innerHTML=aT,fx=s(),lg=c("p"),lg.innerHTML=sT,mx=s(),Tn=c("div"),h(Ai.$$.fragment),_x=s(),pg=c("p"),pg.textContent=rT,bx=s(),dg=c("p"),dg.innerHTML=iT,yx=s(),qn=c("div"),h(Ni.$$.fragment),vx=s(),gg=c("p"),gg.textContent=cT,xx=s(),h(cs.$$.fragment),$x=s(),ue=c("div"),h(Ji.$$.fragment),wx=s(),ug=c("p"),ug.textContent=lT,kx=s(),hg=c("p"),hg.innerHTML=pT,Tx=s(),fg=c("p"),fg.innerHTML=dT,qx=s(),h(ls.$$.fragment),Mx=s(),at=c("div"),h(Ei.$$.fragment),jx=s(),mg=c("p"),mg.textContent=gT,Hx=s(),_g=c("p"),_g.innerHTML=uT,Cx=s(),bg=c("p"),bg.innerHTML=hT,Ux=s(),st=c("div"),h(Di.$$.fragment),Ix=s(),yg=c("p"),yg.textContent=fT,Ax=s(),vg=c("p"),vg.innerHTML=mT,Nx=s(),h(ps.$$.fragment),Jx=s(),he=c("div"),h(Ri.$$.fragment),Ex=s(),xg=c("p"),xg.textContent=_T,Dx=s(),$g=c("p"),$g.innerHTML=bT,Rx=s(),wg=c("p"),wg.innerHTML=yT,Fx=s(),kg=c("p"),kg.textContent=vT,Gx=s(),rt=c("div"),h(Fi.$$.fragment),Sx=s(),Tg=c("p"),Tg.textContent=xT,Lx=s(),qg=c("p"),qg.textContent=$T,Zx=s(),h(ds.$$.fragment),Vx=s(),X=c("div"),h(Gi.$$.fragment),Wx=s(),Mg=c("p"),Mg.textContent=wT,Px=s(),jg=c("p"),jg.textContent=kT,Bx=s(),h(gs.$$.fragment),Xx=s(),h(us.$$.fragment),Yx=s(),h(hs.$$.fragment),zx=s(),fe=c("div"),h(Si.$$.fragment),Qx=s(),Hg=c("p"),Hg.textContent=TT,Ox=s(),Cg=c("p"),Cg.innerHTML=qT,Kx=s(),Ug=c("p"),Ug.innerHTML=MT,e$=s(),h(fs.$$.fragment),t$=s(),Mn=c("div"),h(Li.$$.fragment),n$=s(),Ig=c("p"),Ig.textContent=jT,o$=s(),h(ms.$$.fragment),a$=s(),me=c("div"),h(Zi.$$.fragment),s$=s(),Ag=c("p"),Ag.textContent=HT,r$=s(),Ng=c("p"),Ng.textContent=CT,i$=s(),Jg=c("p"),Jg.innerHTML=UT,c$=s(),h(_s.$$.fragment),l$=s(),it=c("div"),h(Vi.$$.fragment),p$=s(),Eg=c("p"),Eg.textContent=IT,d$=s(),Dg=c("p"),Dg.textContent=AT,g$=s(),Rg=c("p"),Rg.innerHTML=NT,u$=s(),jn=c("div"),h(Wi.$$.fragment),h$=s(),Fg=c("p"),Fg.textContent=JT,f$=s(),Gg=c("p"),Gg.textContent=ET,m$=s(),ct=c("div"),h(Pi.$$.fragment),_$=s(),Sg=c("p"),Sg.textContent=DT,b$=s(),Lg=c("p"),Lg.innerHTML=RT,y$=s(),h(bs.$$.fragment),v$=s(),Hn=c("div"),h(Bi.$$.fragment),x$=s(),Zg=c("p"),Zg.textContent=FT,$$=s(),h(ys.$$.fragment),w$=s(),_e=c("div"),h(Xi.$$.fragment),k$=s(),Vg=c("p"),Vg.textContent=GT,T$=s(),h(vs.$$.fragment),q$=s(),h(xs.$$.fragment),M$=s(),h($s.$$.fragment),j$=s(),N=c("div"),h(Yi.$$.fragment),H$=s(),Wg=c("p"),Wg.textContent=ST,C$=s(),Pg=c("p"),Pg.textContent=LT,U$=s(),Bg=c("p"),Bg.innerHTML=ZT,I$=s(),Xg=c("p"),Xg.innerHTML=VT,A$=s(),Yg=c("p"),Yg.innerHTML=WT,N$=s(),zg=c("p"),zg.innerHTML=PT,J$=s(),h(ws.$$.fragment),E$=s(),h(ks.$$.fragment),D$=s(),h(Ts.$$.fragment),R$=s(),h(qs.$$.fragment),F$=s(),A=c("div"),h(zi.$$.fragment),G$=s(),Qg=c("p"),Qg.textContent=BT,S$=s(),Og=c("p"),Og.innerHTML=XT,L$=s(),h(Ms.$$.fragment),Z$=s(),h(js.$$.fragment),V$=s(),Kg=c("p"),Kg.innerHTML=YT,W$=s(),eu=c("p"),eu.innerHTML=zT,P$=s(),tu=c("ol"),tu.innerHTML=QT,B$=s(),nu=c("p"),nu.textContent=OT,X$=s(),ou=c("ol"),ou.innerHTML=KT,Y$=s(),au=c("p"),au.textContent=e0,z$=s(),su=c("ul"),su.innerHTML=t0,Q$=s(),Hs=c("div"),h(Qi.$$.fragment),O$=s(),ru=c("p"),ru.textContent=n0,mh=s(),h(Oi.$$.fragment),_h=s(),h(Ki.$$.fragment),bh=s(),Gn=c("div"),h(ec.$$.fragment),K$=s(),iu=c("p"),iu.textContent=o0,yh=s(),h(tc.$$.fragment),vh=s(),pt=c("div"),h(nc.$$.fragment),e2=s(),cu=c("p"),cu.textContent=a0,t2=s(),lu=c("p"),lu.innerHTML=s0,xh=s(),h(oc.$$.fragment),$h=s(),dt=c("div"),h(ac.$$.fragment),n2=s(),pu=c("p"),pu.innerHTML=r0,o2=s(),h(Cs.$$.fragment),wh=s(),h(sc.$$.fragment),kh=s(),Sn=c("div"),h(rc.$$.fragment),a2=s(),du=c("p"),du.textContent=i0,Th=s(),h(ic.$$.fragment),qh=s(),Ln=c("div"),h(cc.$$.fragment),s2=s(),gu=c("p"),gu.innerHTML=c0,Mh=s(),h(lc.$$.fragment),jh=s(),gt=c("div"),h(pc.$$.fragment),r2=s(),uu=c("p"),uu.textContent=l0,i2=s(),hu=c("p"),hu.innerHTML=p0,Hh=s(),h(dc.$$.fragment),Ch=s(),ut=c("div"),h(gc.$$.fragment),c2=s(),fu=c("p"),fu.innerHTML=d0,l2=s(),h(Us.$$.fragment),Uh=s(),h(uc.$$.fragment),Ih=s(),ht=c("div"),h(hc.$$.fragment),p2=s(),mu=c("p"),mu.textContent=g0,d2=s(),h(Is.$$.fragment),Ah=s(),h(fc.$$.fragment),Nh=s(),Zn=c("div"),h(mc.$$.fragment),g2=s(),_u=c("p"),_u.textContent=u0,Jh=s(),h(_c.$$.fragment),Eh=s(),z=c("div"),h(bc.$$.fragment),u2=s(),bu=c("p"),bu.innerHTML=h0,h2=s(),yu=c("p"),yu.innerHTML=f0,f2=s(),vu=c("ul"),vu.innerHTML=m0,m2=s(),h(As.$$.fragment),Dh=s(),h(yc.$$.fragment),Rh=s(),Q=c("div"),h(vc.$$.fragment),_2=s(),xu=c("p"),xu.textContent=_0,b2=s(),$u=c("p"),$u.textContent=b0,y2=s(),wu=c("p"),wu.innerHTML=y0,v2=s(),ku=c("p"),ku.innerHTML=v0,Fh=s(),h(xc.$$.fragment),Gh=s(),be=c("div"),h($c.$$.fragment),x2=s(),Tu=c("p"),Tu.textContent=x0,$2=s(),qu=c("p"),qu.innerHTML=$0,w2=s(),Mu=c("p"),Mu.innerHTML=w0,Sh=s(),h(wc.$$.fragment),Lh=s(),ft=c("div"),h(kc.$$.fragment),k2=s(),ju=c("p"),ju.innerHTML=k0,T2=s(),h(Ns.$$.fragment),Zh=s(),h(Tc.$$.fragment),Vh=s(),mt=c("div"),h(qc.$$.fragment),q2=s(),Hu=c("p"),Hu.textContent=T0,M2=s(),Cu=c("p"),Cu.innerHTML=q0,Wh=s(),h(Mc.$$.fragment),Ph=s(),Vn=c("div"),h(jc.$$.fragment),j2=s(),Uu=c("p"),Uu.textContent=M0,Bh=s(),h(Hc.$$.fragment),Xh=s(),Wn=c("div"),h(Cc.$$.fragment),H2=s(),Iu=c("p"),Iu.textContent=j0,Yh=s(),h(Uc.$$.fragment),zh=s(),Ic=c("p"),Ic.innerHTML=H0,Qh=s(),ye=c("div"),h(Ac.$$.fragment),C2=s(),Au=c("p"),Au.textContent=C0,U2=s(),Cn=c("div"),h(Nc.$$.fragment),I2=s(),Nu=c("p"),Nu.innerHTML=U0,A2=s(),h(Js.$$.fragment),N2=s(),Un=c("div"),h(Jc.$$.fragment),J2=s(),Ju=c("p"),Ju.innerHTML=I0,E2=s(),Eu=c("p"),Eu.innerHTML=A0,Oh=s(),Pn=c("div"),h(Ec.$$.fragment),D2=s(),Du=c("p"),Du.textContent=N0,Kh=s(),O=c("div"),h(Dc.$$.fragment),R2=s(),Ru=c("p"),Ru.textContent=J0,F2=s(),Fu=c("p"),Fu.textContent=E0,G2=s(),Gu=c("ul"),Gu.innerHTML=D0,S2=s(),Su=c("p"),Su.innerHTML=R0,ef=s(),h(Rc.$$.fragment),tf=s(),D=c("div"),h(Fc.$$.fragment),L2=s(),Lu=c("p"),Lu.textContent=F0,Z2=s(),Zu=c("p"),Zu.innerHTML=G0,V2=s(),h(Es.$$.fragment),W2=s(),h(Ds.$$.fragment),P2=s(),lt=c("div"),h(Gc.$$.fragment),B2=s(),Vu=c("p"),Vu.textContent=S0,X2=s(),h(Rs.$$.fragment),Y2=s(),Wu=c("p"),Wu.innerHTML=L0,z2=s(),In=c("div"),h(Sc.$$.fragment),Q2=s(),Pu=c("p"),Pu.textContent=Z0,O2=s(),Bu=c("p"),Bu.textContent=V0,K2=s(),An=c("div"),h(Lc.$$.fragment),e1=s(),Xu=c("p"),Xu.innerHTML=W0,t1=s(),Yu=c("p"),Yu.innerHTML=P0,nf=s(),h(Zc.$$.fragment),of=s(),ph=c("p"),this.h()},l(t){const v=Q0("svelte-u9bgzb",document.head);o=l(v,"META",{name:!0,content:!0}),v.forEach(p),u=r(t),i=l(t,"P",{}),q(i).forEach(p),a=r(t),f(g.$$.fragment,t),e=r(t),x=l(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-6ncsww"&&(x.innerHTML=n1),dh=r(t),Vs=l(t,"P",{"data-svelte-h":!0}),d(Vs)!=="svelte-fytuye"&&(Vs.innerHTML=o1),gh=r(t),Ws=l(t,"P",{"data-svelte-h":!0}),d(Ws)!=="svelte-2nagd6"&&(Ws.innerHTML=a1),uh=r(t),f(Ps.$$.fragment,t),hh=r(t),f(Bs.$$.fragment,t),fh=r(t),w=l(t,"DIV",{class:!0});var k=q(w);f(Xs.$$.fragment,k),hf=r(k),ll=l(k,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-868tea"&&(ll.textContent=s1),ff=r(k),pl=l(k,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-mq1mm2"&&(pl.innerHTML=r1),mf=r(k),Ce=l(k,"DIV",{class:!0});var _t=q(Ce);f(Ys.$$.fragment,_t),_f=r(_t),dl=l(_t,"P",{"data-svelte-h":!0}),d(dl)!=="svelte-nwim5u"&&(dl.textContent=i1),bf=r(_t),gl=l(_t,"P",{"data-svelte-h":!0}),d(gl)!=="svelte-jkya6j"&&(gl.innerHTML=c1),yf=r(_t),ul=l(_t,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-xxbgtf"&&(ul.innerHTML=l1),_t.forEach(p),vf=r(k),Ue=l(k,"DIV",{class:!0});var bt=q(Ue);f(zs.$$.fragment,bt),xf=r(bt),hl=l(bt,"P",{"data-svelte-h":!0}),d(hl)!=="svelte-pl69v6"&&(hl.textContent=p1),$f=r(bt),fl=l(bt,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-17aw16u"&&(fl.innerHTML=d1),wf=r(bt),f(qo.$$.fragment,bt),bt.forEach(p),kf=r(k),Xt=l(k,"DIV",{class:!0});var Bn=q(Xt);f(Qs.$$.fragment,Bn),Tf=r(Bn),ml=l(Bn,"P",{"data-svelte-h":!0}),d(ml)!=="svelte-p5bez4"&&(ml.textContent=g1),qf=r(Bn),_l=l(Bn,"P",{"data-svelte-h":!0}),d(_l)!=="svelte-eb77qn"&&(_l.innerHTML=u1),Bn.forEach(p),Mf=r(k),Yt=l(k,"DIV",{class:!0});var Xn=q(Yt);f(Os.$$.fragment,Xn),jf=r(Xn),bl=l(Xn,"P",{"data-svelte-h":!0}),d(bl)!=="svelte-1ck64b0"&&(bl.textContent=h1),Hf=r(Xn),yl=l(Xn,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-xt39ay"&&(yl.innerHTML=f1),Xn.forEach(p),Cf=r(k),F=l(k,"DIV",{class:!0});var S=q(F);f(Ks.$$.fragment,S),Uf=r(S),vl=l(S,"P",{"data-svelte-h":!0}),d(vl)!=="svelte-1ryj8c0"&&(vl.textContent=m1),If=r(S),xl=l(S,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-vnh51y"&&(xl.textContent=_1),Af=r(S),$l=l(S,"P",{"data-svelte-h":!0}),d($l)!=="svelte-11lpom8"&&($l.textContent=b1),Nf=r(S),f(Mo.$$.fragment,S),Jf=r(S),wl=l(S,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-15bi1il"&&(wl.textContent=y1),Ef=r(S),kl=l(S,"UL",{"data-svelte-h":!0}),d(kl)!=="svelte-1cixf91"&&(kl.innerHTML=v1),S.forEach(p),Df=r(k),Ie=l(k,"DIV",{class:!0});var yt=q(Ie);f(er.$$.fragment,yt),Rf=r(yt),Tl=l(yt,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-1v3ljxo"&&(Tl.textContent=x1),Ff=r(yt),ql=l(yt,"P",{"data-svelte-h":!0}),d(ql)!=="svelte-zq4mwt"&&(ql.textContent=$1),Gf=r(yt),Ml=l(yt,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-xxbgtf"&&(Ml.innerHTML=w1),yt.forEach(p),Sf=r(k),Ae=l(k,"DIV",{class:!0});var vt=q(Ae);f(tr.$$.fragment,vt),Lf=r(vt),jl=l(vt,"P",{"data-svelte-h":!0}),d(jl)!=="svelte-16mfbn3"&&(jl.textContent=k1),Zf=r(vt),f(jo.$$.fragment,vt),Vf=r(vt),f(Ho.$$.fragment,vt),vt.forEach(p),Wf=r(k),Ne=l(k,"DIV",{class:!0});var xt=q(Ne);f(nr.$$.fragment,xt),Pf=r(xt),Hl=l(xt,"P",{"data-svelte-h":!0}),d(Hl)!=="svelte-1xtlk3i"&&(Hl.textContent=T1),Bf=r(xt),f(Co.$$.fragment,xt),Xf=r(xt),f(Uo.$$.fragment,xt),xt.forEach(p),Yf=r(k),Io=l(k,"DIV",{class:!0});var Vc=q(Io);f(or.$$.fragment,Vc),zf=r(Vc),Cl=l(Vc,"P",{"data-svelte-h":!0}),d(Cl)!=="svelte-1eopmb2"&&(Cl.innerHTML=q1),Vc.forEach(p),Qf=r(k),Je=l(k,"DIV",{class:!0});var $t=q(Je);f(ar.$$.fragment,$t),Of=r($t),Ul=l($t,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-8lce12"&&(Ul.textContent=M1),Kf=r($t),Il=l($t,"P",{"data-svelte-h":!0}),d(Il)!=="svelte-17aw16u"&&(Il.innerHTML=j1),em=r($t),f(Ao.$$.fragment,$t),$t.forEach(p),tm=r(k),se=l(k,"DIV",{class:!0});var ve=q(se);f(sr.$$.fragment,ve),nm=r(ve),Al=l(ve,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-pth6mb"&&(Al.textContent=H1),om=r(ve),f(No.$$.fragment,ve),am=r(ve),f(Jo.$$.fragment,ve),sm=r(ve),f(Eo.$$.fragment,ve),ve.forEach(p),rm=r(k),Z=l(k,"DIV",{class:!0});var K=q(Z);f(rr.$$.fragment,K),im=r(K),Nl=l(K,"P",{"data-svelte-h":!0}),d(Nl)!=="svelte-1g87pq3"&&(Nl.textContent=C1),cm=r(K),Jl=l(K,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-1gunwzz"&&(Jl.innerHTML=U1),lm=r(K),El=l(K,"P",{"data-svelte-h":!0}),d(El)!=="svelte-1bbedq1"&&(El.innerHTML=I1),pm=r(K),Dl=l(K,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-zi6kpu"&&(Dl.innerHTML=A1),dm=r(K),f(Do.$$.fragment,K),K.forEach(p),gm=r(k),re=l(k,"DIV",{class:!0});var xe=q(re);f(ir.$$.fragment,xe),um=r(xe),Rl=l(xe,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-aoy5wl"&&(Rl.textContent=N1),hm=r(xe),f(Ro.$$.fragment,xe),fm=r(xe),f(Fo.$$.fragment,xe),mm=r(xe),f(Go.$$.fragment,xe),xe.forEach(p),_m=r(k),Ee=l(k,"DIV",{class:!0});var wt=q(Ee);f(cr.$$.fragment,wt),bm=r(wt),Fl=l(wt,"P",{"data-svelte-h":!0}),d(Fl)!=="svelte-1mk48gz"&&(Fl.textContent=J1),ym=r(wt),Gl=l(wt,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-s9x0iz"&&(Gl.innerHTML=E1),vm=r(wt),f(So.$$.fragment,wt),wt.forEach(p),xm=r(k),V=l(k,"DIV",{class:!0});var ee=q(V);f(lr.$$.fragment,ee),$m=r(ee),Sl=l(ee,"P",{"data-svelte-h":!0}),d(Sl)!=="svelte-1hp36yr"&&(Sl.innerHTML=D1),wm=r(ee),Ll=l(ee,"P",{"data-svelte-h":!0}),d(Ll)!=="svelte-194f5ee"&&(Ll.innerHTML=R1),km=r(ee),Zl=l(ee,"P",{"data-svelte-h":!0}),d(Zl)!=="svelte-14j81b7"&&(Zl.innerHTML=F1),Tm=r(ee),Vl=l(ee,"P",{"data-svelte-h":!0}),d(Vl)!=="svelte-zi6kpu"&&(Vl.innerHTML=G1),qm=r(ee),f(Lo.$$.fragment,ee),ee.forEach(p),Mm=r(k),Zo=l(k,"DIV",{class:!0});var Wc=q(Zo);f(pr.$$.fragment,Wc),jm=r(Wc),Wl=l(Wc,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-12go647"&&(Wl.textContent=S1),Wc.forEach(p),Hm=r(k),Vo=l(k,"DIV",{class:!0});var Pc=q(Vo);f(dr.$$.fragment,Pc),Cm=r(Pc),Pl=l(Pc,"P",{"data-svelte-h":!0}),d(Pl)!=="svelte-14fvvbg"&&(Pl.textContent=L1),Pc.forEach(p),Um=r(k),zt=l(k,"DIV",{class:!0});var Yn=q(zt);f(gr.$$.fragment,Yn),Im=r(Yn),Bl=l(Yn,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-1g6e2ay"&&(Bl.textContent=Z1),Am=r(Yn),f(Wo.$$.fragment,Yn),Yn.forEach(p),Nm=r(k),De=l(k,"DIV",{class:!0});var kt=q(De);f(ur.$$.fragment,kt),Jm=r(kt),Xl=l(kt,"P",{"data-svelte-h":!0}),d(Xl)!=="svelte-15pbnj8"&&(Xl.textContent=V1),Em=r(kt),Yl=l(kt,"P",{"data-svelte-h":!0}),d(Yl)!=="svelte-1fg5f6l"&&(Yl.textContent=W1),Dm=r(kt),f(Po.$$.fragment,kt),kt.forEach(p),Rm=r(k),Bo=l(k,"DIV",{class:!0});var Bc=q(Bo);f(hr.$$.fragment,Bc),Fm=r(Bc),zl=l(Bc,"P",{"data-svelte-h":!0}),d(zl)!=="svelte-1n7quvg"&&(zl.textContent=P1),Bc.forEach(p),Gm=r(k),Re=l(k,"DIV",{class:!0});var Tt=q(Re);f(fr.$$.fragment,Tt),Sm=r(Tt),Ql=l(Tt,"P",{"data-svelte-h":!0}),d(Ql)!=="svelte-1s6a009"&&(Ql.textContent=B1),Lm=r(Tt),f(Xo.$$.fragment,Tt),Zm=r(Tt),f(Yo.$$.fragment,Tt),Tt.forEach(p),Vm=r(k),Qt=l(k,"DIV",{class:!0});var zn=q(Qt);f(mr.$$.fragment,zn),Wm=r(zn),Ol=l(zn,"P",{"data-svelte-h":!0}),d(Ol)!=="svelte-gmiayq"&&(Ol.textContent=X1),Pm=r(zn),f(zo.$$.fragment,zn),zn.forEach(p),Bm=r(k),Ot=l(k,"DIV",{class:!0});var Qn=q(Ot);f(_r.$$.fragment,Qn),Xm=r(Qn),Kl=l(Qn,"P",{"data-svelte-h":!0}),d(Kl)!=="svelte-l8j8qy"&&(Kl.textContent=Y1),Ym=r(Qn),f(Qo.$$.fragment,Qn),Qn.forEach(p),zm=r(k),Kt=l(k,"DIV",{class:!0});var On=q(Kt);f(br.$$.fragment,On),Qm=r(On),ep=l(On,"P",{"data-svelte-h":!0}),d(ep)!=="svelte-eigln8"&&(ep.textContent=z1),Om=r(On),tp=l(On,"P",{"data-svelte-h":!0}),d(tp)!=="svelte-11xoqkr"&&(tp.textContent=Q1),On.forEach(p),Km=r(k),en=l(k,"DIV",{class:!0});var Kn=q(en);f(yr.$$.fragment,Kn),e_=r(Kn),np=l(Kn,"P",{"data-svelte-h":!0}),d(np)!=="svelte-1gp9ysc"&&(np.textContent=O1),t_=r(Kn),op=l(Kn,"P",{"data-svelte-h":!0}),d(op)!=="svelte-1xdeyn5"&&(op.innerHTML=K1),Kn.forEach(p),n_=r(k),Fe=l(k,"DIV",{class:!0});var qt=q(Fe);f(vr.$$.fragment,qt),o_=r(qt),ap=l(qt,"P",{"data-svelte-h":!0}),d(ap)!=="svelte-xvin3w"&&(ap.textContent=ew),a_=r(qt),sp=l(qt,"P",{"data-svelte-h":!0}),d(sp)!=="svelte-w611kl"&&(sp.innerHTML=tw),s_=r(qt),rp=l(qt,"P",{"data-svelte-h":!0}),d(rp)!=="svelte-txc80x"&&(rp.innerHTML=nw),qt.forEach(p),r_=r(k),Oo=l(k,"DIV",{class:!0});var Xc=q(Oo);f(xr.$$.fragment,Xc),i_=r(Xc),ip=l(Xc,"P",{"data-svelte-h":!0}),d(ip)!=="svelte-17rezgl"&&(ip.textContent=ow),Xc.forEach(p),c_=r(k),tn=l(k,"DIV",{class:!0});var eo=q(tn);f($r.$$.fragment,eo),l_=r(eo),cp=l(eo,"P",{"data-svelte-h":!0}),d(cp)!=="svelte-1lh7ib8"&&(cp.textContent=aw),p_=r(eo),lp=l(eo,"P",{"data-svelte-h":!0}),d(lp)!=="svelte-eb77qn"&&(lp.innerHTML=sw),eo.forEach(p),d_=r(k),Ko=l(k,"DIV",{class:!0});var Yc=q(Ko);f(wr.$$.fragment,Yc),g_=r(Yc),pp=l(Yc,"P",{"data-svelte-h":!0}),d(pp)!=="svelte-2wnalp"&&(pp.textContent=rw),Yc.forEach(p),u_=r(k),nn=l(k,"DIV",{class:!0});var to=q(nn);f(kr.$$.fragment,to),h_=r(to),dp=l(to,"P",{"data-svelte-h":!0}),d(dp)!=="svelte-idifvk"&&(dp.textContent=iw),f_=r(to),gp=l(to,"P",{"data-svelte-h":!0}),d(gp)!=="svelte-xt39ay"&&(gp.innerHTML=cw),to.forEach(p),m_=r(k),ea=l(k,"DIV",{class:!0});var zc=q(ea);f(Tr.$$.fragment,zc),__=r(zc),up=l(zc,"P",{"data-svelte-h":!0}),d(up)!=="svelte-1k595hs"&&(up.textContent=lw),zc.forEach(p),b_=r(k),on=l(k,"DIV",{class:!0});var no=q(on);f(qr.$$.fragment,no),y_=r(no),hp=l(no,"P",{"data-svelte-h":!0}),d(hp)!=="svelte-odm3i5"&&(hp.textContent=pw),v_=r(no),f(ta.$$.fragment,no),no.forEach(p),x_=r(k),an=l(k,"DIV",{class:!0});var oo=q(an);f(Mr.$$.fragment,oo),$_=r(oo),fp=l(oo,"P",{"data-svelte-h":!0}),d(fp)!=="svelte-u3qpxi"&&(fp.textContent=dw),w_=r(oo),f(na.$$.fragment,oo),oo.forEach(p),k_=r(k),Ge=l(k,"DIV",{class:!0});var Mt=q(Ge);f(jr.$$.fragment,Mt),T_=r(Mt),mp=l(Mt,"P",{"data-svelte-h":!0}),d(mp)!=="svelte-106oizm"&&(mp.textContent=gw),q_=r(Mt),_p=l(Mt,"P",{"data-svelte-h":!0}),d(_p)!=="svelte-1tfv4hv"&&(_p.textContent=uw),M_=r(Mt),f(oa.$$.fragment,Mt),Mt.forEach(p),j_=r(k),sn=l(k,"DIV",{class:!0});var ao=q(sn);f(Hr.$$.fragment,ao),H_=r(ao),bp=l(ao,"P",{"data-svelte-h":!0}),d(bp)!=="svelte-13117mw"&&(bp.textContent=hw),C_=r(ao),f(aa.$$.fragment,ao),ao.forEach(p),U_=r(k),rn=l(k,"DIV",{class:!0});var so=q(rn);f(Cr.$$.fragment,so),I_=r(so),yp=l(so,"P",{"data-svelte-h":!0}),d(yp)!=="svelte-isyqd"&&(yp.textContent=fw),A_=r(so),f(sa.$$.fragment,so),so.forEach(p),N_=r(k),cn=l(k,"DIV",{class:!0});var ro=q(cn);f(Ur.$$.fragment,ro),J_=r(ro),vp=l(ro,"P",{"data-svelte-h":!0}),d(vp)!=="svelte-sivey2"&&(vp.textContent=mw),E_=r(ro),f(ra.$$.fragment,ro),ro.forEach(p),D_=r(k),Se=l(k,"DIV",{class:!0});var jt=q(Se);f(Ir.$$.fragment,jt),R_=r(jt),xp=l(jt,"P",{"data-svelte-h":!0}),d(xp)!=="svelte-1niezvm"&&(xp.textContent=_w),F_=r(jt),$p=l(jt,"P",{"data-svelte-h":!0}),d($p)!=="svelte-17aw16u"&&($p.innerHTML=bw),G_=r(jt),f(ia.$$.fragment,jt),jt.forEach(p),S_=r(k),ca=l(k,"DIV",{class:!0});var Qc=q(ca);f(Ar.$$.fragment,Qc),L_=r(Qc),wp=l(Qc,"P",{"data-svelte-h":!0}),d(wp)!=="svelte-1o179eo"&&(wp.textContent=yw),Qc.forEach(p),Z_=r(k),Le=l(k,"DIV",{class:!0});var Ht=q(Le);f(Nr.$$.fragment,Ht),V_=r(Ht),kp=l(Ht,"P",{"data-svelte-h":!0}),d(kp)!=="svelte-1av5ht1"&&(kp.textContent=vw),W_=r(Ht),Tp=l(Ht,"P",{"data-svelte-h":!0}),d(Tp)!=="svelte-zi6kpu"&&(Tp.innerHTML=xw),P_=r(Ht),f(la.$$.fragment,Ht),Ht.forEach(p),B_=r(k),pa=l(k,"DIV",{class:!0});var Oc=q(pa);f(Jr.$$.fragment,Oc),X_=r(Oc),qp=l(Oc,"P",{"data-svelte-h":!0}),d(qp)!=="svelte-1a5sg0y"&&(qp.textContent=$w),Oc.forEach(p),Y_=r(k),da=l(k,"DIV",{class:!0});var Kc=q(da);f(Er.$$.fragment,Kc),z_=r(Kc),Mp=l(Kc,"P",{"data-svelte-h":!0}),d(Mp)!=="svelte-13tt6xv"&&(Mp.textContent=ww),Kc.forEach(p),Q_=r(k),ln=l(k,"DIV",{class:!0});var io=q(ln);f(Dr.$$.fragment,io),O_=r(io),jp=l(io,"P",{"data-svelte-h":!0}),d(jp)!=="svelte-oj23bg"&&(jp.textContent=kw),K_=r(io),f(ga.$$.fragment,io),io.forEach(p),eb=r(k),ua=l(k,"DIV",{class:!0});var el=q(ua);f(Rr.$$.fragment,el),tb=r(el),Hp=l(el,"P",{"data-svelte-h":!0}),d(Hp)!=="svelte-d99h9l"&&(Hp.textContent=Tw),el.forEach(p),nb=r(k),pn=l(k,"DIV",{class:!0});var co=q(pn);f(Fr.$$.fragment,co),ob=r(co),Cp=l(co,"P",{"data-svelte-h":!0}),d(Cp)!=="svelte-fasffe"&&(Cp.textContent=qw),ab=r(co),f(ha.$$.fragment,co),co.forEach(p),sb=r(k),ie=l(k,"DIV",{class:!0});var $e=q(ie);f(Gr.$$.fragment,$e),rb=r($e),Up=l($e,"P",{"data-svelte-h":!0}),d(Up)!=="svelte-1ipows8"&&(Up.textContent=Mw),ib=r($e),Ip=l($e,"P",{"data-svelte-h":!0}),d(Ip)!=="svelte-11lpom8"&&(Ip.textContent=jw),cb=r($e),f(fa.$$.fragment,$e),lb=r($e),f(ma.$$.fragment,$e),$e.forEach(p),pb=r(k),W=l(k,"DIV",{class:!0});var te=q(W);f(Sr.$$.fragment,te),db=r(te),Ap=l(te,"P",{"data-svelte-h":!0}),d(Ap)!=="svelte-1d865z6"&&(Ap.textContent=Hw),gb=r(te),Np=l(te,"P",{"data-svelte-h":!0}),d(Np)!=="svelte-vb94yg"&&(Np.textContent=Cw),ub=r(te),Jp=l(te,"P",{"data-svelte-h":!0}),d(Jp)!=="svelte-1vhvhde"&&(Jp.innerHTML=Uw),hb=r(te),Ep=l(te,"P",{"data-svelte-h":!0}),d(Ep)!=="svelte-ndzof3"&&(Ep.innerHTML=Iw),fb=r(te),f(_a.$$.fragment,te),te.forEach(p),mb=r(k),ba=l(k,"DIV",{class:!0});var tl=q(ba);f(Lr.$$.fragment,tl),_b=r(tl),Dp=l(tl,"P",{"data-svelte-h":!0}),d(Dp)!=="svelte-130dnbj"&&(Dp.textContent=Aw),tl.forEach(p),bb=r(k),dn=l(k,"DIV",{class:!0});var lo=q(dn);f(Zr.$$.fragment,lo),yb=r(lo),Rp=l(lo,"P",{"data-svelte-h":!0}),d(Rp)!=="svelte-20b1wq"&&(Rp.textContent=Nw),vb=r(lo),Fp=l(lo,"P",{"data-svelte-h":!0}),d(Fp)!=="svelte-xt39ay"&&(Fp.innerHTML=Jw),lo.forEach(p),xb=r(k),Ze=l(k,"DIV",{class:!0});var Ct=q(Ze);f(Vr.$$.fragment,Ct),$b=r(Ct),Gp=l(Ct,"P",{"data-svelte-h":!0}),d(Gp)!=="svelte-1vu5uho"&&(Gp.innerHTML=Ew),wb=r(Ct),f(ya.$$.fragment,Ct),kb=r(Ct),Sp=l(Ct,"P",{"data-svelte-h":!0}),d(Sp)!=="svelte-65kopl"&&(Sp.innerHTML=Dw),Ct.forEach(p),Tb=r(k),va=l(k,"DIV",{class:!0});var nl=q(va);f(Wr.$$.fragment,nl),qb=r(nl),Lp=l(nl,"P",{"data-svelte-h":!0}),d(Lp)!=="svelte-i5g6s6"&&(Lp.textContent=Rw),nl.forEach(p),Mb=r(k),gn=l(k,"DIV",{class:!0});var po=q(gn);f(Pr.$$.fragment,po),jb=r(po),Zp=l(po,"P",{"data-svelte-h":!0}),d(Zp)!=="svelte-1qqa7u0"&&(Zp.textContent=Fw),Hb=r(po),f(xa.$$.fragment,po),po.forEach(p),Cb=r(k),Ve=l(k,"DIV",{class:!0});var Ut=q(Ve);f(Br.$$.fragment,Ut),Ub=r(Ut),Vp=l(Ut,"P",{"data-svelte-h":!0}),d(Vp)!=="svelte-19fc6id"&&(Vp.textContent=Gw),Ib=r(Ut),Wp=l(Ut,"P",{"data-svelte-h":!0}),d(Wp)!=="svelte-fnfmvb"&&(Wp.innerHTML=Sw),Ab=r(Ut),Pp=l(Ut,"P",{"data-svelte-h":!0}),d(Pp)!=="svelte-xxbgtf"&&(Pp.innerHTML=Lw),Ut.forEach(p),Nb=r(k),P=l(k,"DIV",{class:!0});var ne=q(P);f(Xr.$$.fragment,ne),Jb=r(ne),Bp=l(ne,"P",{"data-svelte-h":!0}),d(Bp)!=="svelte-gsbehr"&&(Bp.textContent=Zw),Eb=r(ne),Xp=l(ne,"P",{"data-svelte-h":!0}),d(Xp)!=="svelte-1rkm1l0"&&(Xp.textContent=Vw),Db=r(ne),Yp=l(ne,"UL",{"data-svelte-h":!0}),d(Yp)!=="svelte-1t8qnom"&&(Yp.innerHTML=Ww),Rb=r(ne),f($a.$$.fragment,ne),Fb=r(ne),zp=l(ne,"P",{"data-svelte-h":!0}),d(zp)!=="svelte-mwwpv9"&&(zp.innerHTML=Pw),ne.forEach(p),Gb=r(k),We=l(k,"DIV",{class:!0});var It=q(We);f(Yr.$$.fragment,It),Sb=r(It),Qp=l(It,"P",{"data-svelte-h":!0}),d(Qp)!=="svelte-1ia1m9g"&&(Qp.textContent=Bw),Lb=r(It),f(wa.$$.fragment,It),Zb=r(It),f(ka.$$.fragment,It),It.forEach(p),Vb=r(k),ce=l(k,"DIV",{class:!0});var we=q(ce);f(zr.$$.fragment,we),Wb=r(we),Op=l(we,"P",{"data-svelte-h":!0}),d(Op)!=="svelte-1a7k7d"&&(Op.textContent=Xw),Pb=r(we),Kp=l(we,"P",{"data-svelte-h":!0}),d(Kp)!=="svelte-ajfhh0"&&(Kp.innerHTML=Yw),Bb=r(we),ed=l(we,"P",{"data-svelte-h":!0}),d(ed)!=="svelte-xxbgtf"&&(ed.innerHTML=zw),Xb=r(we),f(Ta.$$.fragment,we),we.forEach(p),Yb=r(k),un=l(k,"DIV",{class:!0});var go=q(un);f(Qr.$$.fragment,go),zb=r(go),td=l(go,"P",{"data-svelte-h":!0}),d(td)!=="svelte-1rbvjim"&&(td.textContent=Qw),Qb=r(go),f(qa.$$.fragment,go),go.forEach(p),Ob=r(k),Pe=l(k,"DIV",{class:!0});var At=q(Pe);f(Or.$$.fragment,At),Kb=r(At),nd=l(At,"P",{"data-svelte-h":!0}),d(nd)!=="svelte-f61qi5"&&(nd.textContent=Ow),ey=r(At),f(Ma.$$.fragment,At),ty=r(At),f(ja.$$.fragment,At),At.forEach(p),ny=r(k),le=l(k,"DIV",{class:!0});var ke=q(le);f(Kr.$$.fragment,ke),oy=r(ke),od=l(ke,"P",{"data-svelte-h":!0}),d(od)!=="svelte-5021cf"&&(od.textContent=Kw),ay=r(ke),ad=l(ke,"P",{"data-svelte-h":!0}),d(ad)!=="svelte-s9x0iz"&&(ad.innerHTML=ek),sy=r(ke),sd=l(ke,"P",{"data-svelte-h":!0}),d(sd)!=="svelte-1vlqxmj"&&(sd.innerHTML=tk),ry=r(ke),f(Ha.$$.fragment,ke),ke.forEach(p),iy=r(k),hn=l(k,"DIV",{class:!0});var uo=q(hn);f(ei.$$.fragment,uo),cy=r(uo),rd=l(uo,"P",{"data-svelte-h":!0}),d(rd)!=="svelte-omx1g3"&&(rd.textContent=nk),ly=r(uo),f(Ca.$$.fragment,uo),uo.forEach(p),py=r(k),Be=l(k,"DIV",{class:!0});var Nt=q(Be);f(ti.$$.fragment,Nt),dy=r(Nt),id=l(Nt,"P",{"data-svelte-h":!0}),d(id)!=="svelte-1wmqeve"&&(id.textContent=ok),gy=r(Nt),cd=l(Nt,"P",{"data-svelte-h":!0}),d(cd)!=="svelte-11exy9j"&&(cd.innerHTML=ak),uy=r(Nt),f(Ua.$$.fragment,Nt),Nt.forEach(p),hy=r(k),pe=l(k,"DIV",{class:!0});var Te=q(pe);f(ni.$$.fragment,Te),fy=r(Te),ld=l(Te,"P",{"data-svelte-h":!0}),d(ld)!=="svelte-lufmym"&&(ld.textContent=sk),my=r(Te),pd=l(Te,"P",{"data-svelte-h":!0}),d(pd)!=="svelte-517n25"&&(pd.innerHTML=rk),_y=r(Te),dd=l(Te,"P",{"data-svelte-h":!0}),d(dd)!=="svelte-4np1w2"&&(dd.innerHTML=ik),by=r(Te),f(Ia.$$.fragment,Te),Te.forEach(p),yy=r(k),fn=l(k,"DIV",{class:!0});var ho=q(fn);f(oi.$$.fragment,ho),vy=r(ho),gd=l(ho,"P",{"data-svelte-h":!0}),d(gd)!=="svelte-7xr8du"&&(gd.textContent=ck),xy=r(ho),f(Aa.$$.fragment,ho),ho.forEach(p),$y=r(k),Na=l(k,"DIV",{class:!0});var ol=q(Na);f(ai.$$.fragment,ol),wy=r(ol),ud=l(ol,"P",{"data-svelte-h":!0}),d(ud)!=="svelte-1lk5pt4"&&(ud.textContent=lk),ol.forEach(p),ky=r(k),mn=l(k,"DIV",{class:!0});var fo=q(mn);f(si.$$.fragment,fo),Ty=r(fo),hd=l(fo,"P",{"data-svelte-h":!0}),d(hd)!=="svelte-1qh0k4h"&&(hd.textContent=pk),qy=r(fo),f(Ja.$$.fragment,fo),fo.forEach(p),My=r(k),de=l(k,"DIV",{class:!0});var qe=q(de);f(ri.$$.fragment,qe),jy=r(qe),fd=l(qe,"P",{"data-svelte-h":!0}),d(fd)!=="svelte-1tc2fi9"&&(fd.textContent=dk),Hy=r(qe),md=l(qe,"P",{"data-svelte-h":!0}),d(md)!=="svelte-1vz216g"&&(md.innerHTML=gk),Cy=r(qe),_d=l(qe,"P",{"data-svelte-h":!0}),d(_d)!=="svelte-xxbgtf"&&(_d.innerHTML=uk),Uy=r(qe),f(Ea.$$.fragment,qe),qe.forEach(p),Iy=r(k),ge=l(k,"DIV",{class:!0});var Me=q(ge);f(ii.$$.fragment,Me),Ay=r(Me),bd=l(Me,"P",{"data-svelte-h":!0}),d(bd)!=="svelte-eo3dek"&&(bd.textContent=hk),Ny=r(Me),yd=l(Me,"P",{"data-svelte-h":!0}),d(yd)!=="svelte-rh9cjt"&&(yd.innerHTML=fk),Jy=r(Me),vd=l(Me,"P",{"data-svelte-h":!0}),d(vd)!=="svelte-xxbgtf"&&(vd.innerHTML=mk),Ey=r(Me),f(Da.$$.fragment,Me),Me.forEach(p),Dy=r(k),Xe=l(k,"DIV",{class:!0});var Jt=q(Xe);f(ci.$$.fragment,Jt),Ry=r(Jt),xd=l(Jt,"P",{"data-svelte-h":!0}),d(xd)!=="svelte-1vpgi7z"&&(xd.textContent=_k),Fy=r(Jt),$d=l(Jt,"P",{"data-svelte-h":!0}),d($d)!=="svelte-11ohrqa"&&($d.textContent=bk),Gy=r(Jt),f(Ra.$$.fragment,Jt),Jt.forEach(p),Sy=r(k),Fa=l(k,"DIV",{class:!0});var al=q(Fa);f(li.$$.fragment,al),Ly=r(al),wd=l(al,"P",{"data-svelte-h":!0}),d(wd)!=="svelte-wnw53w"&&(wd.textContent=yk),al.forEach(p),Zy=r(k),_n=l(k,"DIV",{class:!0});var mo=q(_n);f(pi.$$.fragment,mo),Vy=r(mo),kd=l(mo,"P",{"data-svelte-h":!0}),d(kd)!=="svelte-b4yhj"&&(kd.textContent=vk),Wy=r(mo),Td=l(mo,"P",{"data-svelte-h":!0}),d(Td)!=="svelte-cotkoa"&&(Td.innerHTML=xk),mo.forEach(p),Py=r(k),bn=l(k,"DIV",{class:!0});var _o=q(bn);f(di.$$.fragment,_o),By=r(_o),qd=l(_o,"P",{"data-svelte-h":!0}),d(qd)!=="svelte-12l2ojn"&&(qd.textContent=$k),Xy=r(_o),f(Ga.$$.fragment,_o),_o.forEach(p),Yy=r(k),G=l(k,"DIV",{class:!0});var L=q(G);f(gi.$$.fragment,L),zy=r(L),Md=l(L,"P",{"data-svelte-h":!0}),d(Md)!=="svelte-ihiuvu"&&(Md.textContent=wk),Qy=r(L),jd=l(L,"P",{"data-svelte-h":!0}),d(jd)!=="svelte-kvfsh7"&&(jd.textContent=kk),Oy=r(L),Hd=l(L,"P",{"data-svelte-h":!0}),d(Hd)!=="svelte-cs4ah2"&&(Hd.textContent=Tk),Ky=r(L),f(Sa.$$.fragment,L),ev=r(L),Cd=l(L,"P",{"data-svelte-h":!0}),d(Cd)!=="svelte-1pnedrv"&&(Cd.textContent=qk),tv=r(L),f(La.$$.fragment,L),L.forEach(p),nv=r(k),Za=l(k,"DIV",{class:!0});var sl=q(Za);f(ui.$$.fragment,sl),ov=r(sl),Ud=l(sl,"P",{"data-svelte-h":!0}),d(Ud)!=="svelte-uowooj"&&(Ud.textContent=Mk),sl.forEach(p),av=r(k),Va=l(k,"DIV",{class:!0});var rl=q(Va);f(hi.$$.fragment,rl),sv=r(rl),Id=l(rl,"P",{"data-svelte-h":!0}),d(Id)!=="svelte-apiozp"&&(Id.textContent=jk),rl.forEach(p),rv=r(k),Wa=l(k,"DIV",{class:!0});var il=q(Wa);f(fi.$$.fragment,il),iv=r(il),Ad=l(il,"P",{"data-svelte-h":!0}),d(Ad)!=="svelte-1qehg6u"&&(Ad.textContent=Hk),il.forEach(p),cv=r(k),yn=l(k,"DIV",{class:!0});var bo=q(yn);f(mi.$$.fragment,bo),lv=r(bo),Nd=l(bo,"P",{"data-svelte-h":!0}),d(Nd)!=="svelte-zuangp"&&(Nd.textContent=Ck),pv=r(bo),f(Pa.$$.fragment,bo),bo.forEach(p),dv=r(k),vn=l(k,"DIV",{class:!0});var yo=q(vn);f(_i.$$.fragment,yo),gv=r(yo),Jd=l(yo,"P",{"data-svelte-h":!0}),d(Jd)!=="svelte-tnvivq"&&(Jd.textContent=Uk),uv=r(yo),f(Ba.$$.fragment,yo),yo.forEach(p),hv=r(k),Ye=l(k,"DIV",{class:!0});var Et=q(Ye);f(bi.$$.fragment,Et),fv=r(Et),Ed=l(Et,"P",{"data-svelte-h":!0}),d(Ed)!=="svelte-1qa90id"&&(Ed.textContent=Ik),mv=r(Et),Dd=l(Et,"P",{"data-svelte-h":!0}),d(Dd)!=="svelte-1knrefm"&&(Dd.textContent=Ak),_v=r(Et),f(Xa.$$.fragment,Et),Et.forEach(p),bv=r(k),ze=l(k,"DIV",{class:!0});var Dt=q(ze);f(yi.$$.fragment,Dt),yv=r(Dt),Rd=l(Dt,"P",{"data-svelte-h":!0}),d(Rd)!=="svelte-3q13qo"&&(Rd.textContent=Nk),vv=r(Dt),Fd=l(Dt,"P",{"data-svelte-h":!0}),d(Fd)!=="svelte-1p5ibr4"&&(Fd.innerHTML=Jk),xv=r(Dt),f(Ya.$$.fragment,Dt),Dt.forEach(p),$v=r(k),za=l(k,"DIV",{class:!0});var cl=q(za);f(vi.$$.fragment,cl),wv=r(cl),Gd=l(cl,"P",{"data-svelte-h":!0}),d(Gd)!=="svelte-15c9e8d"&&(Gd.textContent=Ek),cl.forEach(p),kv=r(k),Qe=l(k,"DIV",{class:!0});var Rt=q(Qe);f(xi.$$.fragment,Rt),Tv=r(Rt),Sd=l(Rt,"P",{"data-svelte-h":!0}),d(Sd)!=="svelte-cs1v9f"&&(Sd.textContent=Dk),qv=r(Rt),Ld=l(Rt,"P",{"data-svelte-h":!0}),d(Ld)!=="svelte-hmt9ht"&&(Ld.innerHTML=Rk),Mv=r(Rt),Zd=l(Rt,"P",{"data-svelte-h":!0}),d(Zd)!=="svelte-ndzof3"&&(Zd.innerHTML=Fk),Rt.forEach(p),jv=r(k),Oe=l(k,"DIV",{class:!0});var Ft=q(Oe);f($i.$$.fragment,Ft),Hv=r(Ft),Vd=l(Ft,"P",{"data-svelte-h":!0}),d(Vd)!=="svelte-16tls2x"&&(Vd.textContent=Gk),Cv=r(Ft),Wd=l(Ft,"P",{"data-svelte-h":!0}),d(Wd)!=="svelte-80m3eg"&&(Wd.innerHTML=Sk),Uv=r(Ft),Pd=l(Ft,"P",{"data-svelte-h":!0}),d(Pd)!=="svelte-5ptavr"&&(Pd.innerHTML=Lk),Ft.forEach(p),Iv=r(k),Ke=l(k,"DIV",{class:!0});var Gt=q(Ke);f(wi.$$.fragment,Gt),Av=r(Gt),Bd=l(Gt,"P",{"data-svelte-h":!0}),d(Bd)!=="svelte-keb9bv"&&(Bd.textContent=Zk),Nv=r(Gt),Xd=l(Gt,"P",{"data-svelte-h":!0}),d(Xd)!=="svelte-15wjl3y"&&(Xd.innerHTML=Vk),Jv=r(Gt),Yd=l(Gt,"P",{"data-svelte-h":!0}),d(Yd)!=="svelte-12do56u"&&(Yd.innerHTML=Wk),Gt.forEach(p),Ev=r(k),et=l(k,"DIV",{class:!0});var St=q(et);f(ki.$$.fragment,St),Dv=r(St),zd=l(St,"P",{"data-svelte-h":!0}),d(zd)!=="svelte-10xq13g"&&(zd.textContent=Pk),Rv=r(St),f(Qa.$$.fragment,St),Fv=r(St),f(Oa.$$.fragment,St),St.forEach(p),Gv=r(k),B=l(k,"DIV",{class:!0});var oe=q(B);f(Ti.$$.fragment,oe),Sv=r(oe),Qd=l(oe,"P",{"data-svelte-h":!0}),d(Qd)!=="svelte-13c8xg2"&&(Qd.textContent=Bk),Lv=r(oe),Od=l(oe,"P",{"data-svelte-h":!0}),d(Od)!=="svelte-5htwml"&&(Od.textContent=Xk),Zv=r(oe),f(Ka.$$.fragment,oe),Vv=r(oe),f(es.$$.fragment,oe),Wv=r(oe),f(ts.$$.fragment,oe),oe.forEach(p),Pv=r(k),tt=l(k,"DIV",{class:!0});var Lt=q(tt);f(qi.$$.fragment,Lt),Bv=r(Lt),Kd=l(Lt,"P",{"data-svelte-h":!0}),d(Kd)!=="svelte-1o1ui5j"&&(Kd.textContent=Yk),Xv=r(Lt),eg=l(Lt,"P",{"data-svelte-h":!0}),d(eg)!=="svelte-ptggg8"&&(eg.innerHTML=zk),Yv=r(Lt),tg=l(Lt,"P",{"data-svelte-h":!0}),d(tg)!=="svelte-xxbgtf"&&(tg.innerHTML=Qk),Lt.forEach(p),zv=r(k),nt=l(k,"DIV",{class:!0});var Zt=q(nt);f(Mi.$$.fragment,Zt),Qv=r(Zt),ng=l(Zt,"P",{"data-svelte-h":!0}),d(ng)!=="svelte-vjmct2"&&(ng.textContent=Ok),Ov=r(Zt),f(ns.$$.fragment,Zt),Kv=r(Zt),f(os.$$.fragment,Zt),Zt.forEach(p),ex=r(k),xn=l(k,"DIV",{class:!0});var vo=q(xn);f(ji.$$.fragment,vo),tx=r(vo),og=l(vo,"P",{"data-svelte-h":!0}),d(og)!=="svelte-1h0ufuc"&&(og.textContent=Kk),nx=r(vo),f(as.$$.fragment,vo),vo.forEach(p),ox=r(k),$n=l(k,"DIV",{class:!0});var xo=q($n);f(Hi.$$.fragment,xo),ax=r(xo),ag=l(xo,"P",{"data-svelte-h":!0}),d(ag)!=="svelte-1my46uo"&&(ag.textContent=eT),sx=r(xo),f(ss.$$.fragment,xo),xo.forEach(p),rx=r(k),wn=l(k,"DIV",{class:!0});var $o=q(wn);f(Ci.$$.fragment,$o),ix=r($o),sg=l($o,"P",{"data-svelte-h":!0}),d(sg)!=="svelte-5pcxuz"&&(sg.textContent=tT),cx=r($o),f(rs.$$.fragment,$o),$o.forEach(p),lx=r(k),kn=l(k,"DIV",{class:!0});var wo=q(kn);f(Ui.$$.fragment,wo),px=r(wo),rg=l(wo,"P",{"data-svelte-h":!0}),d(rg)!=="svelte-10aqzwl"&&(rg.textContent=nT),dx=r(wo),f(is.$$.fragment,wo),wo.forEach(p),gx=r(k),ot=l(k,"DIV",{class:!0});var Vt=q(ot);f(Ii.$$.fragment,Vt),ux=r(Vt),ig=l(Vt,"P",{"data-svelte-h":!0}),d(ig)!=="svelte-38gi4y"&&(ig.textContent=oT),hx=r(Vt),cg=l(Vt,"P",{"data-svelte-h":!0}),d(cg)!=="svelte-zwgc7q"&&(cg.innerHTML=aT),fx=r(Vt),lg=l(Vt,"P",{"data-svelte-h":!0}),d(lg)!=="svelte-12do56u"&&(lg.innerHTML=sT),Vt.forEach(p),mx=r(k),Tn=l(k,"DIV",{class:!0});var ko=q(Tn);f(Ai.$$.fragment,ko),_x=r(ko),pg=l(ko,"P",{"data-svelte-h":!0}),d(pg)!=="svelte-o2dz8s"&&(pg.textContent=rT),bx=r(ko),dg=l(ko,"P",{"data-svelte-h":!0}),d(dg)!=="svelte-1drucw9"&&(dg.innerHTML=iT),ko.forEach(p),yx=r(k),qn=l(k,"DIV",{class:!0});var To=q(qn);f(Ni.$$.fragment,To),vx=r(To),gg=l(To,"P",{"data-svelte-h":!0}),d(gg)!=="svelte-kx7a2l"&&(gg.textContent=cT),xx=r(To),f(cs.$$.fragment,To),To.forEach(p),$x=r(k),ue=l(k,"DIV",{class:!0});var je=q(ue);f(Ji.$$.fragment,je),wx=r(je),ug=l(je,"P",{"data-svelte-h":!0}),d(ug)!=="svelte-i4rj9b"&&(ug.textContent=lT),kx=r(je),hg=l(je,"P",{"data-svelte-h":!0}),d(hg)!=="svelte-15iw2gd"&&(hg.innerHTML=pT),Tx=r(je),fg=l(je,"P",{"data-svelte-h":!0}),d(fg)!=="svelte-1f3ta7h"&&(fg.innerHTML=dT),qx=r(je),f(ls.$$.fragment,je),je.forEach(p),Mx=r(k),at=l(k,"DIV",{class:!0});var Wt=q(at);f(Ei.$$.fragment,Wt),jx=r(Wt),mg=l(Wt,"P",{"data-svelte-h":!0}),d(mg)!=="svelte-6vx93v"&&(mg.textContent=gT),Hx=r(Wt),_g=l(Wt,"P",{"data-svelte-h":!0}),d(_g)!=="svelte-153amg4"&&(_g.innerHTML=uT),Cx=r(Wt),bg=l(Wt,"P",{"data-svelte-h":!0}),d(bg)!=="svelte-dx5ct"&&(bg.innerHTML=hT),Wt.forEach(p),Ux=r(k),st=l(k,"DIV",{class:!0});var Pt=q(st);f(Di.$$.fragment,Pt),Ix=r(Pt),yg=l(Pt,"P",{"data-svelte-h":!0}),d(yg)!=="svelte-h8ye5s"&&(yg.textContent=fT),Ax=r(Pt),vg=l(Pt,"P",{"data-svelte-h":!0}),d(vg)!=="svelte-1u14fwi"&&(vg.innerHTML=mT),Nx=r(Pt),f(ps.$$.fragment,Pt),Pt.forEach(p),Jx=r(k),he=l(k,"DIV",{class:!0});var He=q(he);f(Ri.$$.fragment,He),Ex=r(He),xg=l(He,"P",{"data-svelte-h":!0}),d(xg)!=="svelte-t9d1pp"&&(xg.textContent=_T),Dx=r(He),$g=l(He,"P",{"data-svelte-h":!0}),d($g)!=="svelte-xxyl9g"&&($g.innerHTML=bT),Rx=r(He),wg=l(He,"P",{"data-svelte-h":!0}),d(wg)!=="svelte-1v8h65f"&&(wg.innerHTML=yT),Fx=r(He),kg=l(He,"P",{"data-svelte-h":!0}),d(kg)!=="svelte-k7g81c"&&(kg.textContent=vT),He.forEach(p),Gx=r(k),rt=l(k,"DIV",{class:!0});var Bt=q(rt);f(Fi.$$.fragment,Bt),Sx=r(Bt),Tg=l(Bt,"P",{"data-svelte-h":!0}),d(Tg)!=="svelte-1lgtcoe"&&(Tg.textContent=xT),Lx=r(Bt),qg=l(Bt,"P",{"data-svelte-h":!0}),d(qg)!=="svelte-zugpyn"&&(qg.textContent=$T),Zx=r(Bt),f(ds.$$.fragment,Bt),Bt.forEach(p),Vx=r(k),X=l(k,"DIV",{class:!0});var ae=q(X);f(Gi.$$.fragment,ae),Wx=r(ae),Mg=l(ae,"P",{"data-svelte-h":!0}),d(Mg)!=="svelte-1j5taqn"&&(Mg.textContent=wT),Px=r(ae),jg=l(ae,"P",{"data-svelte-h":!0}),d(jg)!=="svelte-1oloczu"&&(jg.textContent=kT),Bx=r(ae),f(gs.$$.fragment,ae),Xx=r(ae),f(us.$$.fragment,ae),Yx=r(ae),f(hs.$$.fragment,ae),ae.forEach(p),zx=r(k),fe=l(k,"DIV",{class:!0});var Nn=q(fe);f(Si.$$.fragment,Nn),Qx=r(Nn),Hg=l(Nn,"P",{"data-svelte-h":!0}),d(Hg)!=="svelte-z82c1y"&&(Hg.textContent=TT),Ox=r(Nn),Cg=l(Nn,"P",{"data-svelte-h":!0}),d(Cg)!=="svelte-w9m9bs"&&(Cg.innerHTML=qT),Kx=r(Nn),Ug=l(Nn,"P",{"data-svelte-h":!0}),d(Ug)!=="svelte-cotkoa"&&(Ug.innerHTML=MT),e$=r(Nn),f(fs.$$.fragment,Nn),Nn.forEach(p),t$=r(k),Mn=l(k,"DIV",{class:!0});var zu=q(Mn);f(Li.$$.fragment,zu),n$=r(zu),Ig=l(zu,"P",{"data-svelte-h":!0}),d(Ig)!=="svelte-klf1wz"&&(Ig.textContent=jT),o$=r(zu),f(ms.$$.fragment,zu),zu.forEach(p),a$=r(k),me=l(k,"DIV",{class:!0});var Jn=q(me);f(Zi.$$.fragment,Jn),s$=r(Jn),Ag=l(Jn,"P",{"data-svelte-h":!0}),d(Ag)!=="svelte-6tdefx"&&(Ag.textContent=HT),r$=r(Jn),Ng=l(Jn,"P",{"data-svelte-h":!0}),d(Ng)!=="svelte-sjutdt"&&(Ng.textContent=CT),i$=r(Jn),Jg=l(Jn,"P",{"data-svelte-h":!0}),d(Jg)!=="svelte-17aw16u"&&(Jg.innerHTML=UT),c$=r(Jn),f(_s.$$.fragment,Jn),Jn.forEach(p),l$=r(k),it=l(k,"DIV",{class:!0});var Fs=q(it);f(Vi.$$.fragment,Fs),p$=r(Fs),Eg=l(Fs,"P",{"data-svelte-h":!0}),d(Eg)!=="svelte-tgkk8q"&&(Eg.textContent=IT),d$=r(Fs),Dg=l(Fs,"P",{"data-svelte-h":!0}),d(Dg)!=="svelte-1yeoh0w"&&(Dg.textContent=AT),g$=r(Fs),Rg=l(Fs,"P",{"data-svelte-h":!0}),d(Rg)!=="svelte-1xddutv"&&(Rg.innerHTML=NT),Fs.forEach(p),u$=r(k),jn=l(k,"DIV",{class:!0});var Qu=q(jn);f(Wi.$$.fragment,Qu),h$=r(Qu),Fg=l(Qu,"P",{"data-svelte-h":!0}),d(Fg)!=="svelte-1xslq7e"&&(Fg.textContent=JT),f$=r(Qu),Gg=l(Qu,"P",{"data-svelte-h":!0}),d(Gg)!=="svelte-zgmljc"&&(Gg.textContent=ET),Qu.forEach(p),m$=r(k),ct=l(k,"DIV",{class:!0});var Gs=q(ct);f(Pi.$$.fragment,Gs),_$=r(Gs),Sg=l(Gs,"P",{"data-svelte-h":!0}),d(Sg)!=="svelte-1icdi1y"&&(Sg.textContent=DT),b$=r(Gs),Lg=l(Gs,"P",{"data-svelte-h":!0}),d(Lg)!=="svelte-1b93kvt"&&(Lg.innerHTML=RT),y$=r(Gs),f(bs.$$.fragment,Gs),Gs.forEach(p),v$=r(k),Hn=l(k,"DIV",{class:!0});var Ou=q(Hn);f(Bi.$$.fragment,Ou),x$=r(Ou),Zg=l(Ou,"P",{"data-svelte-h":!0}),d(Zg)!=="svelte-1a9paom"&&(Zg.textContent=FT),$$=r(Ou),f(ys.$$.fragment,Ou),Ou.forEach(p),w$=r(k),_e=l(k,"DIV",{class:!0});var En=q(_e);f(Xi.$$.fragment,En),k$=r(En),Vg=l(En,"P",{"data-svelte-h":!0}),d(Vg)!=="svelte-kukbcr"&&(Vg.textContent=GT),T$=r(En),f(vs.$$.fragment,En),q$=r(En),f(xs.$$.fragment,En),M$=r(En),f($s.$$.fragment,En),En.forEach(p),j$=r(k),N=l(k,"DIV",{class:!0});var E=q(N);f(Yi.$$.fragment,E),H$=r(E),Wg=l(E,"P",{"data-svelte-h":!0}),d(Wg)!=="svelte-1nvey1d"&&(Wg.textContent=ST),C$=r(E),Pg=l(E,"P",{"data-svelte-h":!0}),d(Pg)!=="svelte-1vu0l4l"&&(Pg.textContent=LT),U$=r(E),Bg=l(E,"P",{"data-svelte-h":!0}),d(Bg)!=="svelte-adrskp"&&(Bg.innerHTML=ZT),I$=r(E),Xg=l(E,"P",{"data-svelte-h":!0}),d(Xg)!=="svelte-1m6fudm"&&(Xg.innerHTML=VT),A$=r(E),Yg=l(E,"P",{"data-svelte-h":!0}),d(Yg)!=="svelte-nojwu3"&&(Yg.innerHTML=WT),N$=r(E),zg=l(E,"P",{"data-svelte-h":!0}),d(zg)!=="svelte-90ewc6"&&(zg.innerHTML=PT),J$=r(E),f(ws.$$.fragment,E),E$=r(E),f(ks.$$.fragment,E),D$=r(E),f(Ts.$$.fragment,E),R$=r(E),f(qs.$$.fragment,E),E.forEach(p),F$=r(k),A=l(k,"DIV",{class:!0});var J=q(A);f(zi.$$.fragment,J),G$=r(J),Qg=l(J,"P",{"data-svelte-h":!0}),d(Qg)!=="svelte-1a1ittk"&&(Qg.textContent=BT),S$=r(J),Og=l(J,"P",{"data-svelte-h":!0}),d(Og)!=="svelte-3l9535"&&(Og.innerHTML=XT),L$=r(J),f(Ms.$$.fragment,J),Z$=r(J),f(js.$$.fragment,J),V$=r(J),Kg=l(J,"P",{"data-svelte-h":!0}),d(Kg)!=="svelte-8c4beu"&&(Kg.innerHTML=YT),W$=r(J),eu=l(J,"P",{"data-svelte-h":!0}),d(eu)!=="svelte-25734v"&&(eu.innerHTML=zT),P$=r(J),tu=l(J,"OL",{"data-svelte-h":!0}),d(tu)!=="svelte-1ewi7og"&&(tu.innerHTML=QT),B$=r(J),nu=l(J,"P",{"data-svelte-h":!0}),d(nu)!=="svelte-59ei85"&&(nu.textContent=OT),X$=r(J),ou=l(J,"OL",{"data-svelte-h":!0}),d(ou)!=="svelte-1igkyl7"&&(ou.innerHTML=KT),Y$=r(J),au=l(J,"P",{"data-svelte-h":!0}),d(au)!=="svelte-w718ua"&&(au.textContent=e0),z$=r(J),su=l(J,"UL",{"data-svelte-h":!0}),d(su)!=="svelte-c57nbb"&&(su.innerHTML=t0),J.forEach(p),Q$=r(k),Hs=l(k,"DIV",{class:!0});var sf=q(Hs);f(Qi.$$.fragment,sf),O$=r(sf),ru=l(sf,"P",{"data-svelte-h":!0}),d(ru)!=="svelte-l7gr50"&&(ru.textContent=n0),sf.forEach(p),k.forEach(p),mh=r(t),f(Oi.$$.fragment,t),_h=r(t),f(Ki.$$.fragment,t),bh=r(t),Gn=l(t,"DIV",{class:!0});var rf=q(Gn);f(ec.$$.fragment,rf),K$=r(rf),iu=l(rf,"P",{"data-svelte-h":!0}),d(iu)!=="svelte-frgpd7"&&(iu.textContent=o0),rf.forEach(p),yh=r(t),f(tc.$$.fragment,t),vh=r(t),pt=l(t,"DIV",{class:!0});var Ku=q(pt);f(nc.$$.fragment,Ku),e2=r(Ku),cu=l(Ku,"P",{"data-svelte-h":!0}),d(cu)!=="svelte-n4j72f"&&(cu.textContent=a0),t2=r(Ku),lu=l(Ku,"P",{"data-svelte-h":!0}),d(lu)!=="svelte-92iwcm"&&(lu.innerHTML=s0),Ku.forEach(p),xh=r(t),f(oc.$$.fragment,t),$h=r(t),dt=l(t,"DIV",{class:!0});var eh=q(dt);f(ac.$$.fragment,eh),n2=r(eh),pu=l(eh,"P",{"data-svelte-h":!0}),d(pu)!=="svelte-1g7on68"&&(pu.innerHTML=r0),o2=r(eh),f(Cs.$$.fragment,eh),eh.forEach(p),wh=r(t),f(sc.$$.fragment,t),kh=r(t),Sn=l(t,"DIV",{class:!0});var cf=q(Sn);f(rc.$$.fragment,cf),a2=r(cf),du=l(cf,"P",{"data-svelte-h":!0}),d(du)!=="svelte-1dp8z99"&&(du.textContent=i0),cf.forEach(p),Th=r(t),f(ic.$$.fragment,t),qh=r(t),Ln=l(t,"DIV",{class:!0});var lf=q(Ln);f(cc.$$.fragment,lf),s2=r(lf),gu=l(lf,"P",{"data-svelte-h":!0}),d(gu)!=="svelte-17whmxr"&&(gu.innerHTML=c0),lf.forEach(p),Mh=r(t),f(lc.$$.fragment,t),jh=r(t),gt=l(t,"DIV",{class:!0});var th=q(gt);f(pc.$$.fragment,th),r2=r(th),uu=l(th,"P",{"data-svelte-h":!0}),d(uu)!=="svelte-8pkqdq"&&(uu.textContent=l0),i2=r(th),hu=l(th,"P",{"data-svelte-h":!0}),d(hu)!=="svelte-1c8qold"&&(hu.innerHTML=p0),th.forEach(p),Hh=r(t),f(dc.$$.fragment,t),Ch=r(t),ut=l(t,"DIV",{class:!0});var nh=q(ut);f(gc.$$.fragment,nh),c2=r(nh),fu=l(nh,"P",{"data-svelte-h":!0}),d(fu)!=="svelte-1yho2x9"&&(fu.innerHTML=d0),l2=r(nh),f(Us.$$.fragment,nh),nh.forEach(p),Uh=r(t),f(uc.$$.fragment,t),Ih=r(t),ht=l(t,"DIV",{class:!0});var oh=q(ht);f(hc.$$.fragment,oh),p2=r(oh),mu=l(oh,"P",{"data-svelte-h":!0}),d(mu)!=="svelte-pzc88f"&&(mu.textContent=g0),d2=r(oh),f(Is.$$.fragment,oh),oh.forEach(p),Ah=r(t),f(fc.$$.fragment,t),Nh=r(t),Zn=l(t,"DIV",{class:!0});var pf=q(Zn);f(mc.$$.fragment,pf),g2=r(pf),_u=l(pf,"P",{"data-svelte-h":!0}),d(_u)!=="svelte-1eicjbk"&&(_u.textContent=u0),pf.forEach(p),Jh=r(t),f(_c.$$.fragment,t),Eh=r(t),z=l(t,"DIV",{class:!0});var Dn=q(z);f(bc.$$.fragment,Dn),u2=r(Dn),bu=l(Dn,"P",{"data-svelte-h":!0}),d(bu)!=="svelte-1v78htg"&&(bu.innerHTML=h0),h2=r(Dn),yu=l(Dn,"P",{"data-svelte-h":!0}),d(yu)!=="svelte-murgw9"&&(yu.innerHTML=f0),f2=r(Dn),vu=l(Dn,"UL",{"data-svelte-h":!0}),d(vu)!=="svelte-1mrng5l"&&(vu.innerHTML=m0),m2=r(Dn),f(As.$$.fragment,Dn),Dn.forEach(p),Dh=r(t),f(yc.$$.fragment,t),Rh=r(t),Q=l(t,"DIV",{class:!0});var Rn=q(Q);f(vc.$$.fragment,Rn),_2=r(Rn),xu=l(Rn,"P",{"data-svelte-h":!0}),d(xu)!=="svelte-ovnxfi"&&(xu.textContent=_0),b2=r(Rn),$u=l(Rn,"P",{"data-svelte-h":!0}),d($u)!=="svelte-afv8fv"&&($u.textContent=b0),y2=r(Rn),wu=l(Rn,"P",{"data-svelte-h":!0}),d(wu)!=="svelte-1pzb93s"&&(wu.innerHTML=y0),v2=r(Rn),ku=l(Rn,"P",{"data-svelte-h":!0}),d(ku)!=="svelte-ndzof3"&&(ku.innerHTML=v0),Rn.forEach(p),Fh=r(t),f(xc.$$.fragment,t),Gh=r(t),be=l(t,"DIV",{class:!0});var Ss=q(be);f($c.$$.fragment,Ss),x2=r(Ss),Tu=l(Ss,"P",{"data-svelte-h":!0}),d(Tu)!=="svelte-2ejdv8"&&(Tu.textContent=x0),$2=r(Ss),qu=l(Ss,"P",{"data-svelte-h":!0}),d(qu)!=="svelte-1t8oovk"&&(qu.innerHTML=$0),w2=r(Ss),Mu=l(Ss,"P",{"data-svelte-h":!0}),d(Mu)!=="svelte-ndzof3"&&(Mu.innerHTML=w0),Ss.forEach(p),Sh=r(t),f(wc.$$.fragment,t),Lh=r(t),ft=l(t,"DIV",{class:!0});var ah=q(ft);f(kc.$$.fragment,ah),k2=r(ah),ju=l(ah,"P",{"data-svelte-h":!0}),d(ju)!=="svelte-7afg0a"&&(ju.innerHTML=k0),T2=r(ah),f(Ns.$$.fragment,ah),ah.forEach(p),Zh=r(t),f(Tc.$$.fragment,t),Vh=r(t),mt=l(t,"DIV",{class:!0});var sh=q(mt);f(qc.$$.fragment,sh),q2=r(sh),Hu=l(sh,"P",{"data-svelte-h":!0}),d(Hu)!=="svelte-by9v9h"&&(Hu.textContent=T0),M2=r(sh),Cu=l(sh,"P",{"data-svelte-h":!0}),d(Cu)!=="svelte-ndzof3"&&(Cu.innerHTML=q0),sh.forEach(p),Wh=r(t),f(Mc.$$.fragment,t),Ph=r(t),Vn=l(t,"DIV",{class:!0});var df=q(Vn);f(jc.$$.fragment,df),j2=r(df),Uu=l(df,"P",{"data-svelte-h":!0}),d(Uu)!=="svelte-f10xp"&&(Uu.textContent=M0),df.forEach(p),Bh=r(t),f(Hc.$$.fragment,t),Xh=r(t),Wn=l(t,"DIV",{class:!0});var gf=q(Wn);f(Cc.$$.fragment,gf),H2=r(gf),Iu=l(gf,"P",{"data-svelte-h":!0}),d(Iu)!=="svelte-s36het"&&(Iu.textContent=j0),gf.forEach(p),Yh=r(t),f(Uc.$$.fragment,t),zh=r(t),Ic=l(t,"P",{"data-svelte-h":!0}),d(Ic)!=="svelte-141kvtu"&&(Ic.innerHTML=H0),Qh=r(t),ye=l(t,"DIV",{class:!0});var Ls=q(ye);f(Ac.$$.fragment,Ls),C2=r(Ls),Au=l(Ls,"P",{"data-svelte-h":!0}),d(Au)!=="svelte-1nyzeix"&&(Au.textContent=C0),U2=r(Ls),Cn=l(Ls,"DIV",{class:!0});var rh=q(Cn);f(Nc.$$.fragment,rh),I2=r(rh),Nu=l(rh,"P",{"data-svelte-h":!0}),d(Nu)!=="svelte-1d7s5nc"&&(Nu.innerHTML=U0),A2=r(rh),f(Js.$$.fragment,rh),rh.forEach(p),N2=r(Ls),Un=l(Ls,"DIV",{class:!0});var ih=q(Un);f(Jc.$$.fragment,ih),J2=r(ih),Ju=l(ih,"P",{"data-svelte-h":!0}),d(Ju)!=="svelte-1o44akx"&&(Ju.innerHTML=I0),E2=r(ih),Eu=l(ih,"P",{"data-svelte-h":!0}),d(Eu)!=="svelte-huzhzj"&&(Eu.innerHTML=A0),ih.forEach(p),Ls.forEach(p),Oh=r(t),Pn=l(t,"DIV",{class:!0});var uf=q(Pn);f(Ec.$$.fragment,uf),D2=r(uf),Du=l(uf,"P",{"data-svelte-h":!0}),d(Du)!=="svelte-1cij9yu"&&(Du.textContent=N0),uf.forEach(p),Kh=r(t),O=l(t,"DIV",{class:!0});var Fn=q(O);f(Dc.$$.fragment,Fn),R2=r(Fn),Ru=l(Fn,"P",{"data-svelte-h":!0}),d(Ru)!=="svelte-bx32lj"&&(Ru.textContent=J0),F2=r(Fn),Fu=l(Fn,"P",{"data-svelte-h":!0}),d(Fu)!=="svelte-1a6nwfz"&&(Fu.textContent=E0),G2=r(Fn),Gu=l(Fn,"UL",{"data-svelte-h":!0}),d(Gu)!=="svelte-1wreq5n"&&(Gu.innerHTML=D0),S2=r(Fn),Su=l(Fn,"P",{"data-svelte-h":!0}),d(Su)!=="svelte-fipu1x"&&(Su.innerHTML=R0),Fn.forEach(p),ef=r(t),f(Rc.$$.fragment,t),tf=r(t),D=l(t,"DIV",{class:!0});var Y=q(D);f(Fc.$$.fragment,Y),L2=r(Y),Lu=l(Y,"P",{"data-svelte-h":!0}),d(Lu)!=="svelte-1wfz9hx"&&(Lu.textContent=F0),Z2=r(Y),Zu=l(Y,"P",{"data-svelte-h":!0}),d(Zu)!=="svelte-10g22je"&&(Zu.innerHTML=G0),V2=r(Y),f(Es.$$.fragment,Y),W2=r(Y),f(Ds.$$.fragment,Y),P2=r(Y),lt=l(Y,"DIV",{class:!0});var Zs=q(lt);f(Gc.$$.fragment,Zs),B2=r(Zs),Vu=l(Zs,"P",{"data-svelte-h":!0}),d(Vu)!=="svelte-e95u7k"&&(Vu.textContent=S0),X2=r(Zs),f(Rs.$$.fragment,Zs),Y2=r(Zs),Wu=l(Zs,"P",{"data-svelte-h":!0}),d(Wu)!=="svelte-ulgg79"&&(Wu.innerHTML=L0),Zs.forEach(p),z2=r(Y),In=l(Y,"DIV",{class:!0});var ch=q(In);f(Sc.$$.fragment,ch),Q2=r(ch),Pu=l(ch,"P",{"data-svelte-h":!0}),d(Pu)!=="svelte-t1x1k0"&&(Pu.textContent=Z0),O2=r(ch),Bu=l(ch,"P",{"data-svelte-h":!0}),d(Bu)!=="svelte-1jdo3t2"&&(Bu.textContent=V0),ch.forEach(p),K2=r(Y),An=l(Y,"DIV",{class:!0});var lh=q(An);f(Lc.$$.fragment,lh),e1=r(lh),Xu=l(lh,"P",{"data-svelte-h":!0}),d(Xu)!=="svelte-m2dnyn"&&(Xu.innerHTML=W0),t1=r(lh),Yu=l(lh,"P",{"data-svelte-h":!0}),d(Yu)!=="svelte-aasb0o"&&(Yu.innerHTML=P0),lh.forEach(p),Y.forEach(p),nf=r(t),f(Zc.$$.fragment,t),of=r(t),ph=l(t,"P",{}),q(ph).forEach(p),this.h()},h(){M(o,"name","hf:doc:metadata"),M(o,"content",YM),M(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Io,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ko,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ea,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ca,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(da,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ua,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ba,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(va,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Na,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Za,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Va,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(za,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(An,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,v){n(document.head,o),$(t,u,v),$(t,i,v),$(t,a,v),m(g,t,v),$(t,e,v),$(t,x,v),$(t,dh,v),$(t,Vs,v),$(t,gh,v),$(t,Ws,v),$(t,uh,v),m(Ps,t,v),$(t,hh,v),m(Bs,t,v),$(t,fh,v),$(t,w,v),m(Xs,w,null),n(w,hf),n(w,ll),n(w,ff),n(w,pl),n(w,mf),n(w,Ce),m(Ys,Ce,null),n(Ce,_f),n(Ce,dl),n(Ce,bf),n(Ce,gl),n(Ce,yf),n(Ce,ul),n(w,vf),n(w,Ue),m(zs,Ue,null),n(Ue,xf),n(Ue,hl),n(Ue,$f),n(Ue,fl),n(Ue,wf),m(qo,Ue,null),n(w,kf),n(w,Xt),m(Qs,Xt,null),n(Xt,Tf),n(Xt,ml),n(Xt,qf),n(Xt,_l),n(w,Mf),n(w,Yt),m(Os,Yt,null),n(Yt,jf),n(Yt,bl),n(Yt,Hf),n(Yt,yl),n(w,Cf),n(w,F),m(Ks,F,null),n(F,Uf),n(F,vl),n(F,If),n(F,xl),n(F,Af),n(F,$l),n(F,Nf),m(Mo,F,null),n(F,Jf),n(F,wl),n(F,Ef),n(F,kl),n(w,Df),n(w,Ie),m(er,Ie,null),n(Ie,Rf),n(Ie,Tl),n(Ie,Ff),n(Ie,ql),n(Ie,Gf),n(Ie,Ml),n(w,Sf),n(w,Ae),m(tr,Ae,null),n(Ae,Lf),n(Ae,jl),n(Ae,Zf),m(jo,Ae,null),n(Ae,Vf),m(Ho,Ae,null),n(w,Wf),n(w,Ne),m(nr,Ne,null),n(Ne,Pf),n(Ne,Hl),n(Ne,Bf),m(Co,Ne,null),n(Ne,Xf),m(Uo,Ne,null),n(w,Yf),n(w,Io),m(or,Io,null),n(Io,zf),n(Io,Cl),n(w,Qf),n(w,Je),m(ar,Je,null),n(Je,Of),n(Je,Ul),n(Je,Kf),n(Je,Il),n(Je,em),m(Ao,Je,null),n(w,tm),n(w,se),m(sr,se,null),n(se,nm),n(se,Al),n(se,om),m(No,se,null),n(se,am),m(Jo,se,null),n(se,sm),m(Eo,se,null),n(w,rm),n(w,Z),m(rr,Z,null),n(Z,im),n(Z,Nl),n(Z,cm),n(Z,Jl),n(Z,lm),n(Z,El),n(Z,pm),n(Z,Dl),n(Z,dm),m(Do,Z,null),n(w,gm),n(w,re),m(ir,re,null),n(re,um),n(re,Rl),n(re,hm),m(Ro,re,null),n(re,fm),m(Fo,re,null),n(re,mm),m(Go,re,null),n(w,_m),n(w,Ee),m(cr,Ee,null),n(Ee,bm),n(Ee,Fl),n(Ee,ym),n(Ee,Gl),n(Ee,vm),m(So,Ee,null),n(w,xm),n(w,V),m(lr,V,null),n(V,$m),n(V,Sl),n(V,wm),n(V,Ll),n(V,km),n(V,Zl),n(V,Tm),n(V,Vl),n(V,qm),m(Lo,V,null),n(w,Mm),n(w,Zo),m(pr,Zo,null),n(Zo,jm),n(Zo,Wl),n(w,Hm),n(w,Vo),m(dr,Vo,null),n(Vo,Cm),n(Vo,Pl),n(w,Um),n(w,zt),m(gr,zt,null),n(zt,Im),n(zt,Bl),n(zt,Am),m(Wo,zt,null),n(w,Nm),n(w,De),m(ur,De,null),n(De,Jm),n(De,Xl),n(De,Em),n(De,Yl),n(De,Dm),m(Po,De,null),n(w,Rm),n(w,Bo),m(hr,Bo,null),n(Bo,Fm),n(Bo,zl),n(w,Gm),n(w,Re),m(fr,Re,null),n(Re,Sm),n(Re,Ql),n(Re,Lm),m(Xo,Re,null),n(Re,Zm),m(Yo,Re,null),n(w,Vm),n(w,Qt),m(mr,Qt,null),n(Qt,Wm),n(Qt,Ol),n(Qt,Pm),m(zo,Qt,null),n(w,Bm),n(w,Ot),m(_r,Ot,null),n(Ot,Xm),n(Ot,Kl),n(Ot,Ym),m(Qo,Ot,null),n(w,zm),n(w,Kt),m(br,Kt,null),n(Kt,Qm),n(Kt,ep),n(Kt,Om),n(Kt,tp),n(w,Km),n(w,en),m(yr,en,null),n(en,e_),n(en,np),n(en,t_),n(en,op),n(w,n_),n(w,Fe),m(vr,Fe,null),n(Fe,o_),n(Fe,ap),n(Fe,a_),n(Fe,sp),n(Fe,s_),n(Fe,rp),n(w,r_),n(w,Oo),m(xr,Oo,null),n(Oo,i_),n(Oo,ip),n(w,c_),n(w,tn),m($r,tn,null),n(tn,l_),n(tn,cp),n(tn,p_),n(tn,lp),n(w,d_),n(w,Ko),m(wr,Ko,null),n(Ko,g_),n(Ko,pp),n(w,u_),n(w,nn),m(kr,nn,null),n(nn,h_),n(nn,dp),n(nn,f_),n(nn,gp),n(w,m_),n(w,ea),m(Tr,ea,null),n(ea,__),n(ea,up),n(w,b_),n(w,on),m(qr,on,null),n(on,y_),n(on,hp),n(on,v_),m(ta,on,null),n(w,x_),n(w,an),m(Mr,an,null),n(an,$_),n(an,fp),n(an,w_),m(na,an,null),n(w,k_),n(w,Ge),m(jr,Ge,null),n(Ge,T_),n(Ge,mp),n(Ge,q_),n(Ge,_p),n(Ge,M_),m(oa,Ge,null),n(w,j_),n(w,sn),m(Hr,sn,null),n(sn,H_),n(sn,bp),n(sn,C_),m(aa,sn,null),n(w,U_),n(w,rn),m(Cr,rn,null),n(rn,I_),n(rn,yp),n(rn,A_),m(sa,rn,null),n(w,N_),n(w,cn),m(Ur,cn,null),n(cn,J_),n(cn,vp),n(cn,E_),m(ra,cn,null),n(w,D_),n(w,Se),m(Ir,Se,null),n(Se,R_),n(Se,xp),n(Se,F_),n(Se,$p),n(Se,G_),m(ia,Se,null),n(w,S_),n(w,ca),m(Ar,ca,null),n(ca,L_),n(ca,wp),n(w,Z_),n(w,Le),m(Nr,Le,null),n(Le,V_),n(Le,kp),n(Le,W_),n(Le,Tp),n(Le,P_),m(la,Le,null),n(w,B_),n(w,pa),m(Jr,pa,null),n(pa,X_),n(pa,qp),n(w,Y_),n(w,da),m(Er,da,null),n(da,z_),n(da,Mp),n(w,Q_),n(w,ln),m(Dr,ln,null),n(ln,O_),n(ln,jp),n(ln,K_),m(ga,ln,null),n(w,eb),n(w,ua),m(Rr,ua,null),n(ua,tb),n(ua,Hp),n(w,nb),n(w,pn),m(Fr,pn,null),n(pn,ob),n(pn,Cp),n(pn,ab),m(ha,pn,null),n(w,sb),n(w,ie),m(Gr,ie,null),n(ie,rb),n(ie,Up),n(ie,ib),n(ie,Ip),n(ie,cb),m(fa,ie,null),n(ie,lb),m(ma,ie,null),n(w,pb),n(w,W),m(Sr,W,null),n(W,db),n(W,Ap),n(W,gb),n(W,Np),n(W,ub),n(W,Jp),n(W,hb),n(W,Ep),n(W,fb),m(_a,W,null),n(w,mb),n(w,ba),m(Lr,ba,null),n(ba,_b),n(ba,Dp),n(w,bb),n(w,dn),m(Zr,dn,null),n(dn,yb),n(dn,Rp),n(dn,vb),n(dn,Fp),n(w,xb),n(w,Ze),m(Vr,Ze,null),n(Ze,$b),n(Ze,Gp),n(Ze,wb),m(ya,Ze,null),n(Ze,kb),n(Ze,Sp),n(w,Tb),n(w,va),m(Wr,va,null),n(va,qb),n(va,Lp),n(w,Mb),n(w,gn),m(Pr,gn,null),n(gn,jb),n(gn,Zp),n(gn,Hb),m(xa,gn,null),n(w,Cb),n(w,Ve),m(Br,Ve,null),n(Ve,Ub),n(Ve,Vp),n(Ve,Ib),n(Ve,Wp),n(Ve,Ab),n(Ve,Pp),n(w,Nb),n(w,P),m(Xr,P,null),n(P,Jb),n(P,Bp),n(P,Eb),n(P,Xp),n(P,Db),n(P,Yp),n(P,Rb),m($a,P,null),n(P,Fb),n(P,zp),n(w,Gb),n(w,We),m(Yr,We,null),n(We,Sb),n(We,Qp),n(We,Lb),m(wa,We,null),n(We,Zb),m(ka,We,null),n(w,Vb),n(w,ce),m(zr,ce,null),n(ce,Wb),n(ce,Op),n(ce,Pb),n(ce,Kp),n(ce,Bb),n(ce,ed),n(ce,Xb),m(Ta,ce,null),n(w,Yb),n(w,un),m(Qr,un,null),n(un,zb),n(un,td),n(un,Qb),m(qa,un,null),n(w,Ob),n(w,Pe),m(Or,Pe,null),n(Pe,Kb),n(Pe,nd),n(Pe,ey),m(Ma,Pe,null),n(Pe,ty),m(ja,Pe,null),n(w,ny),n(w,le),m(Kr,le,null),n(le,oy),n(le,od),n(le,ay),n(le,ad),n(le,sy),n(le,sd),n(le,ry),m(Ha,le,null),n(w,iy),n(w,hn),m(ei,hn,null),n(hn,cy),n(hn,rd),n(hn,ly),m(Ca,hn,null),n(w,py),n(w,Be),m(ti,Be,null),n(Be,dy),n(Be,id),n(Be,gy),n(Be,cd),n(Be,uy),m(Ua,Be,null),n(w,hy),n(w,pe),m(ni,pe,null),n(pe,fy),n(pe,ld),n(pe,my),n(pe,pd),n(pe,_y),n(pe,dd),n(pe,by),m(Ia,pe,null),n(w,yy),n(w,fn),m(oi,fn,null),n(fn,vy),n(fn,gd),n(fn,xy),m(Aa,fn,null),n(w,$y),n(w,Na),m(ai,Na,null),n(Na,wy),n(Na,ud),n(w,ky),n(w,mn),m(si,mn,null),n(mn,Ty),n(mn,hd),n(mn,qy),m(Ja,mn,null),n(w,My),n(w,de),m(ri,de,null),n(de,jy),n(de,fd),n(de,Hy),n(de,md),n(de,Cy),n(de,_d),n(de,Uy),m(Ea,de,null),n(w,Iy),n(w,ge),m(ii,ge,null),n(ge,Ay),n(ge,bd),n(ge,Ny),n(ge,yd),n(ge,Jy),n(ge,vd),n(ge,Ey),m(Da,ge,null),n(w,Dy),n(w,Xe),m(ci,Xe,null),n(Xe,Ry),n(Xe,xd),n(Xe,Fy),n(Xe,$d),n(Xe,Gy),m(Ra,Xe,null),n(w,Sy),n(w,Fa),m(li,Fa,null),n(Fa,Ly),n(Fa,wd),n(w,Zy),n(w,_n),m(pi,_n,null),n(_n,Vy),n(_n,kd),n(_n,Wy),n(_n,Td),n(w,Py),n(w,bn),m(di,bn,null),n(bn,By),n(bn,qd),n(bn,Xy),m(Ga,bn,null),n(w,Yy),n(w,G),m(gi,G,null),n(G,zy),n(G,Md),n(G,Qy),n(G,jd),n(G,Oy),n(G,Hd),n(G,Ky),m(Sa,G,null),n(G,ev),n(G,Cd),n(G,tv),m(La,G,null),n(w,nv),n(w,Za),m(ui,Za,null),n(Za,ov),n(Za,Ud),n(w,av),n(w,Va),m(hi,Va,null),n(Va,sv),n(Va,Id),n(w,rv),n(w,Wa),m(fi,Wa,null),n(Wa,iv),n(Wa,Ad),n(w,cv),n(w,yn),m(mi,yn,null),n(yn,lv),n(yn,Nd),n(yn,pv),m(Pa,yn,null),n(w,dv),n(w,vn),m(_i,vn,null),n(vn,gv),n(vn,Jd),n(vn,uv),m(Ba,vn,null),n(w,hv),n(w,Ye),m(bi,Ye,null),n(Ye,fv),n(Ye,Ed),n(Ye,mv),n(Ye,Dd),n(Ye,_v),m(Xa,Ye,null),n(w,bv),n(w,ze),m(yi,ze,null),n(ze,yv),n(ze,Rd),n(ze,vv),n(ze,Fd),n(ze,xv),m(Ya,ze,null),n(w,$v),n(w,za),m(vi,za,null),n(za,wv),n(za,Gd),n(w,kv),n(w,Qe),m(xi,Qe,null),n(Qe,Tv),n(Qe,Sd),n(Qe,qv),n(Qe,Ld),n(Qe,Mv),n(Qe,Zd),n(w,jv),n(w,Oe),m($i,Oe,null),n(Oe,Hv),n(Oe,Vd),n(Oe,Cv),n(Oe,Wd),n(Oe,Uv),n(Oe,Pd),n(w,Iv),n(w,Ke),m(wi,Ke,null),n(Ke,Av),n(Ke,Bd),n(Ke,Nv),n(Ke,Xd),n(Ke,Jv),n(Ke,Yd),n(w,Ev),n(w,et),m(ki,et,null),n(et,Dv),n(et,zd),n(et,Rv),m(Qa,et,null),n(et,Fv),m(Oa,et,null),n(w,Gv),n(w,B),m(Ti,B,null),n(B,Sv),n(B,Qd),n(B,Lv),n(B,Od),n(B,Zv),m(Ka,B,null),n(B,Vv),m(es,B,null),n(B,Wv),m(ts,B,null),n(w,Pv),n(w,tt),m(qi,tt,null),n(tt,Bv),n(tt,Kd),n(tt,Xv),n(tt,eg),n(tt,Yv),n(tt,tg),n(w,zv),n(w,nt),m(Mi,nt,null),n(nt,Qv),n(nt,ng),n(nt,Ov),m(ns,nt,null),n(nt,Kv),m(os,nt,null),n(w,ex),n(w,xn),m(ji,xn,null),n(xn,tx),n(xn,og),n(xn,nx),m(as,xn,null),n(w,ox),n(w,$n),m(Hi,$n,null),n($n,ax),n($n,ag),n($n,sx),m(ss,$n,null),n(w,rx),n(w,wn),m(Ci,wn,null),n(wn,ix),n(wn,sg),n(wn,cx),m(rs,wn,null),n(w,lx),n(w,kn),m(Ui,kn,null),n(kn,px),n(kn,rg),n(kn,dx),m(is,kn,null),n(w,gx),n(w,ot),m(Ii,ot,null),n(ot,ux),n(ot,ig),n(ot,hx),n(ot,cg),n(ot,fx),n(ot,lg),n(w,mx),n(w,Tn),m(Ai,Tn,null),n(Tn,_x),n(Tn,pg),n(Tn,bx),n(Tn,dg),n(w,yx),n(w,qn),m(Ni,qn,null),n(qn,vx),n(qn,gg),n(qn,xx),m(cs,qn,null),n(w,$x),n(w,ue),m(Ji,ue,null),n(ue,wx),n(ue,ug),n(ue,kx),n(ue,hg),n(ue,Tx),n(ue,fg),n(ue,qx),m(ls,ue,null),n(w,Mx),n(w,at),m(Ei,at,null),n(at,jx),n(at,mg),n(at,Hx),n(at,_g),n(at,Cx),n(at,bg),n(w,Ux),n(w,st),m(Di,st,null),n(st,Ix),n(st,yg),n(st,Ax),n(st,vg),n(st,Nx),m(ps,st,null),n(w,Jx),n(w,he),m(Ri,he,null),n(he,Ex),n(he,xg),n(he,Dx),n(he,$g),n(he,Rx),n(he,wg),n(he,Fx),n(he,kg),n(w,Gx),n(w,rt),m(Fi,rt,null),n(rt,Sx),n(rt,Tg),n(rt,Lx),n(rt,qg),n(rt,Zx),m(ds,rt,null),n(w,Vx),n(w,X),m(Gi,X,null),n(X,Wx),n(X,Mg),n(X,Px),n(X,jg),n(X,Bx),m(gs,X,null),n(X,Xx),m(us,X,null),n(X,Yx),m(hs,X,null),n(w,zx),n(w,fe),m(Si,fe,null),n(fe,Qx),n(fe,Hg),n(fe,Ox),n(fe,Cg),n(fe,Kx),n(fe,Ug),n(fe,e$),m(fs,fe,null),n(w,t$),n(w,Mn),m(Li,Mn,null),n(Mn,n$),n(Mn,Ig),n(Mn,o$),m(ms,Mn,null),n(w,a$),n(w,me),m(Zi,me,null),n(me,s$),n(me,Ag),n(me,r$),n(me,Ng),n(me,i$),n(me,Jg),n(me,c$),m(_s,me,null),n(w,l$),n(w,it),m(Vi,it,null),n(it,p$),n(it,Eg),n(it,d$),n(it,Dg),n(it,g$),n(it,Rg),n(w,u$),n(w,jn),m(Wi,jn,null),n(jn,h$),n(jn,Fg),n(jn,f$),n(jn,Gg),n(w,m$),n(w,ct),m(Pi,ct,null),n(ct,_$),n(ct,Sg),n(ct,b$),n(ct,Lg),n(ct,y$),m(bs,ct,null),n(w,v$),n(w,Hn),m(Bi,Hn,null),n(Hn,x$),n(Hn,Zg),n(Hn,$$),m(ys,Hn,null),n(w,w$),n(w,_e),m(Xi,_e,null),n(_e,k$),n(_e,Vg),n(_e,T$),m(vs,_e,null),n(_e,q$),m(xs,_e,null),n(_e,M$),m($s,_e,null),n(w,j$),n(w,N),m(Yi,N,null),n(N,H$),n(N,Wg),n(N,C$),n(N,Pg),n(N,U$),n(N,Bg),n(N,I$),n(N,Xg),n(N,A$),n(N,Yg),n(N,N$),n(N,zg),n(N,J$),m(ws,N,null),n(N,E$),m(ks,N,null),n(N,D$),m(Ts,N,null),n(N,R$),m(qs,N,null),n(w,F$),n(w,A),m(zi,A,null),n(A,G$),n(A,Qg),n(A,S$),n(A,Og),n(A,L$),m(Ms,A,null),n(A,Z$),m(js,A,null),n(A,V$),n(A,Kg),n(A,W$),n(A,eu),n(A,P$),n(A,tu),n(A,B$),n(A,nu),n(A,X$),n(A,ou),n(A,Y$),n(A,au),n(A,z$),n(A,su),n(w,Q$),n(w,Hs),m(Qi,Hs,null),n(Hs,O$),n(Hs,ru),$(t,mh,v),m(Oi,t,v),$(t,_h,v),m(Ki,t,v),$(t,bh,v),$(t,Gn,v),m(ec,Gn,null),n(Gn,K$),n(Gn,iu),$(t,yh,v),m(tc,t,v),$(t,vh,v),$(t,pt,v),m(nc,pt,null),n(pt,e2),n(pt,cu),n(pt,t2),n(pt,lu),$(t,xh,v),m(oc,t,v),$(t,$h,v),$(t,dt,v),m(ac,dt,null),n(dt,n2),n(dt,pu),n(dt,o2),m(Cs,dt,null),$(t,wh,v),m(sc,t,v),$(t,kh,v),$(t,Sn,v),m(rc,Sn,null),n(Sn,a2),n(Sn,du),$(t,Th,v),m(ic,t,v),$(t,qh,v),$(t,Ln,v),m(cc,Ln,null),n(Ln,s2),n(Ln,gu),$(t,Mh,v),m(lc,t,v),$(t,jh,v),$(t,gt,v),m(pc,gt,null),n(gt,r2),n(gt,uu),n(gt,i2),n(gt,hu),$(t,Hh,v),m(dc,t,v),$(t,Ch,v),$(t,ut,v),m(gc,ut,null),n(ut,c2),n(ut,fu),n(ut,l2),m(Us,ut,null),$(t,Uh,v),m(uc,t,v),$(t,Ih,v),$(t,ht,v),m(hc,ht,null),n(ht,p2),n(ht,mu),n(ht,d2),m(Is,ht,null),$(t,Ah,v),m(fc,t,v),$(t,Nh,v),$(t,Zn,v),m(mc,Zn,null),n(Zn,g2),n(Zn,_u),$(t,Jh,v),m(_c,t,v),$(t,Eh,v),$(t,z,v),m(bc,z,null),n(z,u2),n(z,bu),n(z,h2),n(z,yu),n(z,f2),n(z,vu),n(z,m2),m(As,z,null),$(t,Dh,v),m(yc,t,v),$(t,Rh,v),$(t,Q,v),m(vc,Q,null),n(Q,_2),n(Q,xu),n(Q,b2),n(Q,$u),n(Q,y2),n(Q,wu),n(Q,v2),n(Q,ku),$(t,Fh,v),m(xc,t,v),$(t,Gh,v),$(t,be,v),m($c,be,null),n(be,x2),n(be,Tu),n(be,$2),n(be,qu),n(be,w2),n(be,Mu),$(t,Sh,v),m(wc,t,v),$(t,Lh,v),$(t,ft,v),m(kc,ft,null),n(ft,k2),n(ft,ju),n(ft,T2),m(Ns,ft,null),$(t,Zh,v),m(Tc,t,v),$(t,Vh,v),$(t,mt,v),m(qc,mt,null),n(mt,q2),n(mt,Hu),n(mt,M2),n(mt,Cu),$(t,Wh,v),m(Mc,t,v),$(t,Ph,v),$(t,Vn,v),m(jc,Vn,null),n(Vn,j2),n(Vn,Uu),$(t,Bh,v),m(Hc,t,v),$(t,Xh,v),$(t,Wn,v),m(Cc,Wn,null),n(Wn,H2),n(Wn,Iu),$(t,Yh,v),m(Uc,t,v),$(t,zh,v),$(t,Ic,v),$(t,Qh,v),$(t,ye,v),m(Ac,ye,null),n(ye,C2),n(ye,Au),n(ye,U2),n(ye,Cn),m(Nc,Cn,null),n(Cn,I2),n(Cn,Nu),n(Cn,A2),m(Js,Cn,null),n(ye,N2),n(ye,Un),m(Jc,Un,null),n(Un,J2),n(Un,Ju),n(Un,E2),n(Un,Eu),$(t,Oh,v),$(t,Pn,v),m(Ec,Pn,null),n(Pn,D2),n(Pn,Du),$(t,Kh,v),$(t,O,v),m(Dc,O,null),n(O,R2),n(O,Ru),n(O,F2),n(O,Fu),n(O,G2),n(O,Gu),n(O,S2),n(O,Su),$(t,ef,v),m(Rc,t,v),$(t,tf,v),$(t,D,v),m(Fc,D,null),n(D,L2),n(D,Lu),n(D,Z2),n(D,Zu),n(D,V2),m(Es,D,null),n(D,W2),m(Ds,D,null),n(D,P2),n(D,lt),m(Gc,lt,null),n(lt,B2),n(lt,Vu),n(lt,X2),m(Rs,lt,null),n(lt,Y2),n(lt,Wu),n(D,z2),n(D,In),m(Sc,In,null),n(In,Q2),n(In,Pu),n(In,O2),n(In,Bu),n(D,K2),n(D,An),m(Lc,An,null),n(An,e1),n(An,Xu),n(An,t1),n(An,Yu),$(t,nf,v),m(Zc,t,v),$(t,of,v),$(t,ph,v),af=!0},p(t,[v]){const k={};v&2&&(k.$$scope={dirty:v,ctx:t}),qo.$set(k);const _t={};v&2&&(_t.$$scope={dirty:v,ctx:t}),Mo.$set(_t);const bt={};v&2&&(bt.$$scope={dirty:v,ctx:t}),jo.$set(bt);const Bn={};v&2&&(Bn.$$scope={dirty:v,ctx:t}),Ho.$set(Bn);const Xn={};v&2&&(Xn.$$scope={dirty:v,ctx:t}),Co.$set(Xn);const S={};v&2&&(S.$$scope={dirty:v,ctx:t}),Uo.$set(S);const yt={};v&2&&(yt.$$scope={dirty:v,ctx:t}),Ao.$set(yt);const vt={};v&2&&(vt.$$scope={dirty:v,ctx:t}),No.$set(vt);const xt={};v&2&&(xt.$$scope={dirty:v,ctx:t}),Jo.$set(xt);const Vc={};v&2&&(Vc.$$scope={dirty:v,ctx:t}),Eo.$set(Vc);const $t={};v&2&&($t.$$scope={dirty:v,ctx:t}),Do.$set($t);const ve={};v&2&&(ve.$$scope={dirty:v,ctx:t}),Ro.$set(ve);const K={};v&2&&(K.$$scope={dirty:v,ctx:t}),Fo.$set(K);const xe={};v&2&&(xe.$$scope={dirty:v,ctx:t}),Go.$set(xe);const wt={};v&2&&(wt.$$scope={dirty:v,ctx:t}),So.$set(wt);const ee={};v&2&&(ee.$$scope={dirty:v,ctx:t}),Lo.$set(ee);const Wc={};v&2&&(Wc.$$scope={dirty:v,ctx:t}),Wo.$set(Wc);const Pc={};v&2&&(Pc.$$scope={dirty:v,ctx:t}),Po.$set(Pc);const Yn={};v&2&&(Yn.$$scope={dirty:v,ctx:t}),Xo.$set(Yn);const kt={};v&2&&(kt.$$scope={dirty:v,ctx:t}),Yo.$set(kt);const Bc={};v&2&&(Bc.$$scope={dirty:v,ctx:t}),zo.$set(Bc);const Tt={};v&2&&(Tt.$$scope={dirty:v,ctx:t}),Qo.$set(Tt);const zn={};v&2&&(zn.$$scope={dirty:v,ctx:t}),ta.$set(zn);const Qn={};v&2&&(Qn.$$scope={dirty:v,ctx:t}),na.$set(Qn);const On={};v&2&&(On.$$scope={dirty:v,ctx:t}),oa.$set(On);const Kn={};v&2&&(Kn.$$scope={dirty:v,ctx:t}),aa.$set(Kn);const qt={};v&2&&(qt.$$scope={dirty:v,ctx:t}),sa.$set(qt);const Xc={};v&2&&(Xc.$$scope={dirty:v,ctx:t}),ra.$set(Xc);const eo={};v&2&&(eo.$$scope={dirty:v,ctx:t}),ia.$set(eo);const Yc={};v&2&&(Yc.$$scope={dirty:v,ctx:t}),la.$set(Yc);const to={};v&2&&(to.$$scope={dirty:v,ctx:t}),ga.$set(to);const zc={};v&2&&(zc.$$scope={dirty:v,ctx:t}),ha.$set(zc);const no={};v&2&&(no.$$scope={dirty:v,ctx:t}),fa.$set(no);const oo={};v&2&&(oo.$$scope={dirty:v,ctx:t}),ma.$set(oo);const Mt={};v&2&&(Mt.$$scope={dirty:v,ctx:t}),_a.$set(Mt);const ao={};v&2&&(ao.$$scope={dirty:v,ctx:t}),ya.$set(ao);const so={};v&2&&(so.$$scope={dirty:v,ctx:t}),xa.$set(so);const ro={};v&2&&(ro.$$scope={dirty:v,ctx:t}),$a.$set(ro);const jt={};v&2&&(jt.$$scope={dirty:v,ctx:t}),wa.$set(jt);const Qc={};v&2&&(Qc.$$scope={dirty:v,ctx:t}),ka.$set(Qc);const Ht={};v&2&&(Ht.$$scope={dirty:v,ctx:t}),Ta.$set(Ht);const Oc={};v&2&&(Oc.$$scope={dirty:v,ctx:t}),qa.$set(Oc);const Kc={};v&2&&(Kc.$$scope={dirty:v,ctx:t}),Ma.$set(Kc);const io={};v&2&&(io.$$scope={dirty:v,ctx:t}),ja.$set(io);const el={};v&2&&(el.$$scope={dirty:v,ctx:t}),Ha.$set(el);const co={};v&2&&(co.$$scope={dirty:v,ctx:t}),Ca.$set(co);const $e={};v&2&&($e.$$scope={dirty:v,ctx:t}),Ua.$set($e);const te={};v&2&&(te.$$scope={dirty:v,ctx:t}),Ia.$set(te);const tl={};v&2&&(tl.$$scope={dirty:v,ctx:t}),Aa.$set(tl);const lo={};v&2&&(lo.$$scope={dirty:v,ctx:t}),Ja.$set(lo);const Ct={};v&2&&(Ct.$$scope={dirty:v,ctx:t}),Ea.$set(Ct);const nl={};v&2&&(nl.$$scope={dirty:v,ctx:t}),Da.$set(nl);const po={};v&2&&(po.$$scope={dirty:v,ctx:t}),Ra.$set(po);const Ut={};v&2&&(Ut.$$scope={dirty:v,ctx:t}),Ga.$set(Ut);const ne={};v&2&&(ne.$$scope={dirty:v,ctx:t}),Sa.$set(ne);const It={};v&2&&(It.$$scope={dirty:v,ctx:t}),La.$set(It);const we={};v&2&&(we.$$scope={dirty:v,ctx:t}),Pa.$set(we);const go={};v&2&&(go.$$scope={dirty:v,ctx:t}),Ba.$set(go);const At={};v&2&&(At.$$scope={dirty:v,ctx:t}),Xa.$set(At);const ke={};v&2&&(ke.$$scope={dirty:v,ctx:t}),Ya.$set(ke);const uo={};v&2&&(uo.$$scope={dirty:v,ctx:t}),Qa.$set(uo);const Nt={};v&2&&(Nt.$$scope={dirty:v,ctx:t}),Oa.$set(Nt);const Te={};v&2&&(Te.$$scope={dirty:v,ctx:t}),Ka.$set(Te);const ho={};v&2&&(ho.$$scope={dirty:v,ctx:t}),es.$set(ho);const ol={};v&2&&(ol.$$scope={dirty:v,ctx:t}),ts.$set(ol);const fo={};v&2&&(fo.$$scope={dirty:v,ctx:t}),ns.$set(fo);const qe={};v&2&&(qe.$$scope={dirty:v,ctx:t}),os.$set(qe);const Me={};v&2&&(Me.$$scope={dirty:v,ctx:t}),as.$set(Me);const Jt={};v&2&&(Jt.$$scope={dirty:v,ctx:t}),ss.$set(Jt);const al={};v&2&&(al.$$scope={dirty:v,ctx:t}),rs.$set(al);const mo={};v&2&&(mo.$$scope={dirty:v,ctx:t}),is.$set(mo);const _o={};v&2&&(_o.$$scope={dirty:v,ctx:t}),cs.$set(_o);const L={};v&2&&(L.$$scope={dirty:v,ctx:t}),ls.$set(L);const sl={};v&2&&(sl.$$scope={dirty:v,ctx:t}),ps.$set(sl);const rl={};v&2&&(rl.$$scope={dirty:v,ctx:t}),ds.$set(rl);const il={};v&2&&(il.$$scope={dirty:v,ctx:t}),gs.$set(il);const bo={};v&2&&(bo.$$scope={dirty:v,ctx:t}),us.$set(bo);const yo={};v&2&&(yo.$$scope={dirty:v,ctx:t}),hs.$set(yo);const Et={};v&2&&(Et.$$scope={dirty:v,ctx:t}),fs.$set(Et);const Dt={};v&2&&(Dt.$$scope={dirty:v,ctx:t}),ms.$set(Dt);const cl={};v&2&&(cl.$$scope={dirty:v,ctx:t}),_s.$set(cl);const Rt={};v&2&&(Rt.$$scope={dirty:v,ctx:t}),bs.$set(Rt);const Ft={};v&2&&(Ft.$$scope={dirty:v,ctx:t}),ys.$set(Ft);const Gt={};v&2&&(Gt.$$scope={dirty:v,ctx:t}),vs.$set(Gt);const St={};v&2&&(St.$$scope={dirty:v,ctx:t}),xs.$set(St);const oe={};v&2&&(oe.$$scope={dirty:v,ctx:t}),$s.$set(oe);const Lt={};v&2&&(Lt.$$scope={dirty:v,ctx:t}),ws.$set(Lt);const Zt={};v&2&&(Zt.$$scope={dirty:v,ctx:t}),ks.$set(Zt);const vo={};v&2&&(vo.$$scope={dirty:v,ctx:t}),Ts.$set(vo);const xo={};v&2&&(xo.$$scope={dirty:v,ctx:t}),qs.$set(xo);const $o={};v&2&&($o.$$scope={dirty:v,ctx:t}),Ms.$set($o);const wo={};v&2&&(wo.$$scope={dirty:v,ctx:t}),js.$set(wo);const Vt={};v&2&&(Vt.$$scope={dirty:v,ctx:t}),Cs.$set(Vt);const ko={};v&2&&(ko.$$scope={dirty:v,ctx:t}),Us.$set(ko);const To={};v&2&&(To.$$scope={dirty:v,ctx:t}),Is.$set(To);const je={};v&2&&(je.$$scope={dirty:v,ctx:t}),As.$set(je);const Wt={};v&2&&(Wt.$$scope={dirty:v,ctx:t}),Ns.$set(Wt);const Pt={};v&2&&(Pt.$$scope={dirty:v,ctx:t}),Js.$set(Pt);const He={};v&2&&(He.$$scope={dirty:v,ctx:t}),Es.$set(He);const Bt={};v&2&&(Bt.$$scope={dirty:v,ctx:t}),Ds.$set(Bt);const ae={};v&2&&(ae.$$scope={dirty:v,ctx:t}),Rs.$set(ae)},i(t){af||(_(g.$$.fragment,t),_(Ps.$$.fragment,t),_(Bs.$$.fragment,t),_(Xs.$$.fragment,t),_(Ys.$$.fragment,t),_(zs.$$.fragment,t),_(qo.$$.fragment,t),_(Qs.$$.fragment,t),_(Os.$$.fragment,t),_(Ks.$$.fragment,t),_(Mo.$$.fragment,t),_(er.$$.fragment,t),_(tr.$$.fragment,t),_(jo.$$.fragment,t),_(Ho.$$.fragment,t),_(nr.$$.fragment,t),_(Co.$$.fragment,t),_(Uo.$$.fragment,t),_(or.$$.fragment,t),_(ar.$$.fragment,t),_(Ao.$$.fragment,t),_(sr.$$.fragment,t),_(No.$$.fragment,t),_(Jo.$$.fragment,t),_(Eo.$$.fragment,t),_(rr.$$.fragment,t),_(Do.$$.fragment,t),_(ir.$$.fragment,t),_(Ro.$$.fragment,t),_(Fo.$$.fragment,t),_(Go.$$.fragment,t),_(cr.$$.fragment,t),_(So.$$.fragment,t),_(lr.$$.fragment,t),_(Lo.$$.fragment,t),_(pr.$$.fragment,t),_(dr.$$.fragment,t),_(gr.$$.fragment,t),_(Wo.$$.fragment,t),_(ur.$$.fragment,t),_(Po.$$.fragment,t),_(hr.$$.fragment,t),_(fr.$$.fragment,t),_(Xo.$$.fragment,t),_(Yo.$$.fragment,t),_(mr.$$.fragment,t),_(zo.$$.fragment,t),_(_r.$$.fragment,t),_(Qo.$$.fragment,t),_(br.$$.fragment,t),_(yr.$$.fragment,t),_(vr.$$.fragment,t),_(xr.$$.fragment,t),_($r.$$.fragment,t),_(wr.$$.fragment,t),_(kr.$$.fragment,t),_(Tr.$$.fragment,t),_(qr.$$.fragment,t),_(ta.$$.fragment,t),_(Mr.$$.fragment,t),_(na.$$.fragment,t),_(jr.$$.fragment,t),_(oa.$$.fragment,t),_(Hr.$$.fragment,t),_(aa.$$.fragment,t),_(Cr.$$.fragment,t),_(sa.$$.fragment,t),_(Ur.$$.fragment,t),_(ra.$$.fragment,t),_(Ir.$$.fragment,t),_(ia.$$.fragment,t),_(Ar.$$.fragment,t),_(Nr.$$.fragment,t),_(la.$$.fragment,t),_(Jr.$$.fragment,t),_(Er.$$.fragment,t),_(Dr.$$.fragment,t),_(ga.$$.fragment,t),_(Rr.$$.fragment,t),_(Fr.$$.fragment,t),_(ha.$$.fragment,t),_(Gr.$$.fragment,t),_(fa.$$.fragment,t),_(ma.$$.fragment,t),_(Sr.$$.fragment,t),_(_a.$$.fragment,t),_(Lr.$$.fragment,t),_(Zr.$$.fragment,t),_(Vr.$$.fragment,t),_(ya.$$.fragment,t),_(Wr.$$.fragment,t),_(Pr.$$.fragment,t),_(xa.$$.fragment,t),_(Br.$$.fragment,t),_(Xr.$$.fragment,t),_($a.$$.fragment,t),_(Yr.$$.fragment,t),_(wa.$$.fragment,t),_(ka.$$.fragment,t),_(zr.$$.fragment,t),_(Ta.$$.fragment,t),_(Qr.$$.fragment,t),_(qa.$$.fragment,t),_(Or.$$.fragment,t),_(Ma.$$.fragment,t),_(ja.$$.fragment,t),_(Kr.$$.fragment,t),_(Ha.$$.fragment,t),_(ei.$$.fragment,t),_(Ca.$$.fragment,t),_(ti.$$.fragment,t),_(Ua.$$.fragment,t),_(ni.$$.fragment,t),_(Ia.$$.fragment,t),_(oi.$$.fragment,t),_(Aa.$$.fragment,t),_(ai.$$.fragment,t),_(si.$$.fragment,t),_(Ja.$$.fragment,t),_(ri.$$.fragment,t),_(Ea.$$.fragment,t),_(ii.$$.fragment,t),_(Da.$$.fragment,t),_(ci.$$.fragment,t),_(Ra.$$.fragment,t),_(li.$$.fragment,t),_(pi.$$.fragment,t),_(di.$$.fragment,t),_(Ga.$$.fragment,t),_(gi.$$.fragment,t),_(Sa.$$.fragment,t),_(La.$$.fragment,t),_(ui.$$.fragment,t),_(hi.$$.fragment,t),_(fi.$$.fragment,t),_(mi.$$.fragment,t),_(Pa.$$.fragment,t),_(_i.$$.fragment,t),_(Ba.$$.fragment,t),_(bi.$$.fragment,t),_(Xa.$$.fragment,t),_(yi.$$.fragment,t),_(Ya.$$.fragment,t),_(vi.$$.fragment,t),_(xi.$$.fragment,t),_($i.$$.fragment,t),_(wi.$$.fragment,t),_(ki.$$.fragment,t),_(Qa.$$.fragment,t),_(Oa.$$.fragment,t),_(Ti.$$.fragment,t),_(Ka.$$.fragment,t),_(es.$$.fragment,t),_(ts.$$.fragment,t),_(qi.$$.fragment,t),_(Mi.$$.fragment,t),_(ns.$$.fragment,t),_(os.$$.fragment,t),_(ji.$$.fragment,t),_(as.$$.fragment,t),_(Hi.$$.fragment,t),_(ss.$$.fragment,t),_(Ci.$$.fragment,t),_(rs.$$.fragment,t),_(Ui.$$.fragment,t),_(is.$$.fragment,t),_(Ii.$$.fragment,t),_(Ai.$$.fragment,t),_(Ni.$$.fragment,t),_(cs.$$.fragment,t),_(Ji.$$.fragment,t),_(ls.$$.fragment,t),_(Ei.$$.fragment,t),_(Di.$$.fragment,t),_(ps.$$.fragment,t),_(Ri.$$.fragment,t),_(Fi.$$.fragment,t),_(ds.$$.fragment,t),_(Gi.$$.fragment,t),_(gs.$$.fragment,t),_(us.$$.fragment,t),_(hs.$$.fragment,t),_(Si.$$.fragment,t),_(fs.$$.fragment,t),_(Li.$$.fragment,t),_(ms.$$.fragment,t),_(Zi.$$.fragment,t),_(_s.$$.fragment,t),_(Vi.$$.fragment,t),_(Wi.$$.fragment,t),_(Pi.$$.fragment,t),_(bs.$$.fragment,t),_(Bi.$$.fragment,t),_(ys.$$.fragment,t),_(Xi.$$.fragment,t),_(vs.$$.fragment,t),_(xs.$$.fragment,t),_($s.$$.fragment,t),_(Yi.$$.fragment,t),_(ws.$$.fragment,t),_(ks.$$.fragment,t),_(Ts.$$.fragment,t),_(qs.$$.fragment,t),_(zi.$$.fragment,t),_(Ms.$$.fragment,t),_(js.$$.fragment,t),_(Qi.$$.fragment,t),_(Oi.$$.fragment,t),_(Ki.$$.fragment,t),_(ec.$$.fragment,t),_(tc.$$.fragment,t),_(nc.$$.fragment,t),_(oc.$$.fragment,t),_(ac.$$.fragment,t),_(Cs.$$.fragment,t),_(sc.$$.fragment,t),_(rc.$$.fragment,t),_(ic.$$.fragment,t),_(cc.$$.fragment,t),_(lc.$$.fragment,t),_(pc.$$.fragment,t),_(dc.$$.fragment,t),_(gc.$$.fragment,t),_(Us.$$.fragment,t),_(uc.$$.fragment,t),_(hc.$$.fragment,t),_(Is.$$.fragment,t),_(fc.$$.fragment,t),_(mc.$$.fragment,t),_(_c.$$.fragment,t),_(bc.$$.fragment,t),_(As.$$.fragment,t),_(yc.$$.fragment,t),_(vc.$$.fragment,t),_(xc.$$.fragment,t),_($c.$$.fragment,t),_(wc.$$.fragment,t),_(kc.$$.fragment,t),_(Ns.$$.fragment,t),_(Tc.$$.fragment,t),_(qc.$$.fragment,t),_(Mc.$$.fragment,t),_(jc.$$.fragment,t),_(Hc.$$.fragment,t),_(Cc.$$.fragment,t),_(Uc.$$.fragment,t),_(Ac.$$.fragment,t),_(Nc.$$.fragment,t),_(Js.$$.fragment,t),_(Jc.$$.fragment,t),_(Ec.$$.fragment,t),_(Dc.$$.fragment,t),_(Rc.$$.fragment,t),_(Fc.$$.fragment,t),_(Es.$$.fragment,t),_(Ds.$$.fragment,t),_(Gc.$$.fragment,t),_(Rs.$$.fragment,t),_(Sc.$$.fragment,t),_(Lc.$$.fragment,t),_(Zc.$$.fragment,t),af=!0)},o(t){b(g.$$.fragment,t),b(Ps.$$.fragment,t),b(Bs.$$.fragment,t),b(Xs.$$.fragment,t),b(Ys.$$.fragment,t),b(zs.$$.fragment,t),b(qo.$$.fragment,t),b(Qs.$$.fragment,t),b(Os.$$.fragment,t),b(Ks.$$.fragment,t),b(Mo.$$.fragment,t),b(er.$$.fragment,t),b(tr.$$.fragment,t),b(jo.$$.fragment,t),b(Ho.$$.fragment,t),b(nr.$$.fragment,t),b(Co.$$.fragment,t),b(Uo.$$.fragment,t),b(or.$$.fragment,t),b(ar.$$.fragment,t),b(Ao.$$.fragment,t),b(sr.$$.fragment,t),b(No.$$.fragment,t),b(Jo.$$.fragment,t),b(Eo.$$.fragment,t),b(rr.$$.fragment,t),b(Do.$$.fragment,t),b(ir.$$.fragment,t),b(Ro.$$.fragment,t),b(Fo.$$.fragment,t),b(Go.$$.fragment,t),b(cr.$$.fragment,t),b(So.$$.fragment,t),b(lr.$$.fragment,t),b(Lo.$$.fragment,t),b(pr.$$.fragment,t),b(dr.$$.fragment,t),b(gr.$$.fragment,t),b(Wo.$$.fragment,t),b(ur.$$.fragment,t),b(Po.$$.fragment,t),b(hr.$$.fragment,t),b(fr.$$.fragment,t),b(Xo.$$.fragment,t),b(Yo.$$.fragment,t),b(mr.$$.fragment,t),b(zo.$$.fragment,t),b(_r.$$.fragment,t),b(Qo.$$.fragment,t),b(br.$$.fragment,t),b(yr.$$.fragment,t),b(vr.$$.fragment,t),b(xr.$$.fragment,t),b($r.$$.fragment,t),b(wr.$$.fragment,t),b(kr.$$.fragment,t),b(Tr.$$.fragment,t),b(qr.$$.fragment,t),b(ta.$$.fragment,t),b(Mr.$$.fragment,t),b(na.$$.fragment,t),b(jr.$$.fragment,t),b(oa.$$.fragment,t),b(Hr.$$.fragment,t),b(aa.$$.fragment,t),b(Cr.$$.fragment,t),b(sa.$$.fragment,t),b(Ur.$$.fragment,t),b(ra.$$.fragment,t),b(Ir.$$.fragment,t),b(ia.$$.fragment,t),b(Ar.$$.fragment,t),b(Nr.$$.fragment,t),b(la.$$.fragment,t),b(Jr.$$.fragment,t),b(Er.$$.fragment,t),b(Dr.$$.fragment,t),b(ga.$$.fragment,t),b(Rr.$$.fragment,t),b(Fr.$$.fragment,t),b(ha.$$.fragment,t),b(Gr.$$.fragment,t),b(fa.$$.fragment,t),b(ma.$$.fragment,t),b(Sr.$$.fragment,t),b(_a.$$.fragment,t),b(Lr.$$.fragment,t),b(Zr.$$.fragment,t),b(Vr.$$.fragment,t),b(ya.$$.fragment,t),b(Wr.$$.fragment,t),b(Pr.$$.fragment,t),b(xa.$$.fragment,t),b(Br.$$.fragment,t),b(Xr.$$.fragment,t),b($a.$$.fragment,t),b(Yr.$$.fragment,t),b(wa.$$.fragment,t),b(ka.$$.fragment,t),b(zr.$$.fragment,t),b(Ta.$$.fragment,t),b(Qr.$$.fragment,t),b(qa.$$.fragment,t),b(Or.$$.fragment,t),b(Ma.$$.fragment,t),b(ja.$$.fragment,t),b(Kr.$$.fragment,t),b(Ha.$$.fragment,t),b(ei.$$.fragment,t),b(Ca.$$.fragment,t),b(ti.$$.fragment,t),b(Ua.$$.fragment,t),b(ni.$$.fragment,t),b(Ia.$$.fragment,t),b(oi.$$.fragment,t),b(Aa.$$.fragment,t),b(ai.$$.fragment,t),b(si.$$.fragment,t),b(Ja.$$.fragment,t),b(ri.$$.fragment,t),b(Ea.$$.fragment,t),b(ii.$$.fragment,t),b(Da.$$.fragment,t),b(ci.$$.fragment,t),b(Ra.$$.fragment,t),b(li.$$.fragment,t),b(pi.$$.fragment,t),b(di.$$.fragment,t),b(Ga.$$.fragment,t),b(gi.$$.fragment,t),b(Sa.$$.fragment,t),b(La.$$.fragment,t),b(ui.$$.fragment,t),b(hi.$$.fragment,t),b(fi.$$.fragment,t),b(mi.$$.fragment,t),b(Pa.$$.fragment,t),b(_i.$$.fragment,t),b(Ba.$$.fragment,t),b(bi.$$.fragment,t),b(Xa.$$.fragment,t),b(yi.$$.fragment,t),b(Ya.$$.fragment,t),b(vi.$$.fragment,t),b(xi.$$.fragment,t),b($i.$$.fragment,t),b(wi.$$.fragment,t),b(ki.$$.fragment,t),b(Qa.$$.fragment,t),b(Oa.$$.fragment,t),b(Ti.$$.fragment,t),b(Ka.$$.fragment,t),b(es.$$.fragment,t),b(ts.$$.fragment,t),b(qi.$$.fragment,t),b(Mi.$$.fragment,t),b(ns.$$.fragment,t),b(os.$$.fragment,t),b(ji.$$.fragment,t),b(as.$$.fragment,t),b(Hi.$$.fragment,t),b(ss.$$.fragment,t),b(Ci.$$.fragment,t),b(rs.$$.fragment,t),b(Ui.$$.fragment,t),b(is.$$.fragment,t),b(Ii.$$.fragment,t),b(Ai.$$.fragment,t),b(Ni.$$.fragment,t),b(cs.$$.fragment,t),b(Ji.$$.fragment,t),b(ls.$$.fragment,t),b(Ei.$$.fragment,t),b(Di.$$.fragment,t),b(ps.$$.fragment,t),b(Ri.$$.fragment,t),b(Fi.$$.fragment,t),b(ds.$$.fragment,t),b(Gi.$$.fragment,t),b(gs.$$.fragment,t),b(us.$$.fragment,t),b(hs.$$.fragment,t),b(Si.$$.fragment,t),b(fs.$$.fragment,t),b(Li.$$.fragment,t),b(ms.$$.fragment,t),b(Zi.$$.fragment,t),b(_s.$$.fragment,t),b(Vi.$$.fragment,t),b(Wi.$$.fragment,t),b(Pi.$$.fragment,t),b(bs.$$.fragment,t),b(Bi.$$.fragment,t),b(ys.$$.fragment,t),b(Xi.$$.fragment,t),b(vs.$$.fragment,t),b(xs.$$.fragment,t),b($s.$$.fragment,t),b(Yi.$$.fragment,t),b(ws.$$.fragment,t),b(ks.$$.fragment,t),b(Ts.$$.fragment,t),b(qs.$$.fragment,t),b(zi.$$.fragment,t),b(Ms.$$.fragment,t),b(js.$$.fragment,t),b(Qi.$$.fragment,t),b(Oi.$$.fragment,t),b(Ki.$$.fragment,t),b(ec.$$.fragment,t),b(tc.$$.fragment,t),b(nc.$$.fragment,t),b(oc.$$.fragment,t),b(ac.$$.fragment,t),b(Cs.$$.fragment,t),b(sc.$$.fragment,t),b(rc.$$.fragment,t),b(ic.$$.fragment,t),b(cc.$$.fragment,t),b(lc.$$.fragment,t),b(pc.$$.fragment,t),b(dc.$$.fragment,t),b(gc.$$.fragment,t),b(Us.$$.fragment,t),b(uc.$$.fragment,t),b(hc.$$.fragment,t),b(Is.$$.fragment,t),b(fc.$$.fragment,t),b(mc.$$.fragment,t),b(_c.$$.fragment,t),b(bc.$$.fragment,t),b(As.$$.fragment,t),b(yc.$$.fragment,t),b(vc.$$.fragment,t),b(xc.$$.fragment,t),b($c.$$.fragment,t),b(wc.$$.fragment,t),b(kc.$$.fragment,t),b(Ns.$$.fragment,t),b(Tc.$$.fragment,t),b(qc.$$.fragment,t),b(Mc.$$.fragment,t),b(jc.$$.fragment,t),b(Hc.$$.fragment,t),b(Cc.$$.fragment,t),b(Uc.$$.fragment,t),b(Ac.$$.fragment,t),b(Nc.$$.fragment,t),b(Js.$$.fragment,t),b(Jc.$$.fragment,t),b(Ec.$$.fragment,t),b(Dc.$$.fragment,t),b(Rc.$$.fragment,t),b(Fc.$$.fragment,t),b(Es.$$.fragment,t),b(Ds.$$.fragment,t),b(Gc.$$.fragment,t),b(Rs.$$.fragment,t),b(Sc.$$.fragment,t),b(Lc.$$.fragment,t),b(Zc.$$.fragment,t),af=!1},d(t){t&&(p(u),p(i),p(a),p(e),p(x),p(dh),p(Vs),p(gh),p(Ws),p(uh),p(hh),p(fh),p(w),p(mh),p(_h),p(bh),p(Gn),p(yh),p(vh),p(pt),p(xh),p($h),p(dt),p(wh),p(kh),p(Sn),p(Th),p(qh),p(Ln),p(Mh),p(jh),p(gt),p(Hh),p(Ch),p(ut),p(Uh),p(Ih),p(ht),p(Ah),p(Nh),p(Zn),p(Jh),p(Eh),p(z),p(Dh),p(Rh),p(Q),p(Fh),p(Gh),p(be),p(Sh),p(Lh),p(ft),p(Zh),p(Vh),p(mt),p(Wh),p(Ph),p(Vn),p(Bh),p(Xh),p(Wn),p(Yh),p(zh),p(Ic),p(Qh),p(ye),p(Oh),p(Pn),p(Kh),p(O),p(ef),p(tf),p(D),p(nf),p(of),p(ph)),p(o),y(g,t),y(Ps,t),y(Bs,t),y(Xs),y(Ys),y(zs),y(qo),y(Qs),y(Os),y(Ks),y(Mo),y(er),y(tr),y(jo),y(Ho),y(nr),y(Co),y(Uo),y(or),y(ar),y(Ao),y(sr),y(No),y(Jo),y(Eo),y(rr),y(Do),y(ir),y(Ro),y(Fo),y(Go),y(cr),y(So),y(lr),y(Lo),y(pr),y(dr),y(gr),y(Wo),y(ur),y(Po),y(hr),y(fr),y(Xo),y(Yo),y(mr),y(zo),y(_r),y(Qo),y(br),y(yr),y(vr),y(xr),y($r),y(wr),y(kr),y(Tr),y(qr),y(ta),y(Mr),y(na),y(jr),y(oa),y(Hr),y(aa),y(Cr),y(sa),y(Ur),y(ra),y(Ir),y(ia),y(Ar),y(Nr),y(la),y(Jr),y(Er),y(Dr),y(ga),y(Rr),y(Fr),y(ha),y(Gr),y(fa),y(ma),y(Sr),y(_a),y(Lr),y(Zr),y(Vr),y(ya),y(Wr),y(Pr),y(xa),y(Br),y(Xr),y($a),y(Yr),y(wa),y(ka),y(zr),y(Ta),y(Qr),y(qa),y(Or),y(Ma),y(ja),y(Kr),y(Ha),y(ei),y(Ca),y(ti),y(Ua),y(ni),y(Ia),y(oi),y(Aa),y(ai),y(si),y(Ja),y(ri),y(Ea),y(ii),y(Da),y(ci),y(Ra),y(li),y(pi),y(di),y(Ga),y(gi),y(Sa),y(La),y(ui),y(hi),y(fi),y(mi),y(Pa),y(_i),y(Ba),y(bi),y(Xa),y(yi),y(Ya),y(vi),y(xi),y($i),y(wi),y(ki),y(Qa),y(Oa),y(Ti),y(Ka),y(es),y(ts),y(qi),y(Mi),y(ns),y(os),y(ji),y(as),y(Hi),y(ss),y(Ci),y(rs),y(Ui),y(is),y(Ii),y(Ai),y(Ni),y(cs),y(Ji),y(ls),y(Ei),y(Di),y(ps),y(Ri),y(Fi),y(ds),y(Gi),y(gs),y(us),y(hs),y(Si),y(fs),y(Li),y(ms),y(Zi),y(_s),y(Vi),y(Wi),y(Pi),y(bs),y(Bi),y(ys),y(Xi),y(vs),y(xs),y($s),y(Yi),y(ws),y(ks),y(Ts),y(qs),y(zi),y(Ms),y(js),y(Qi),y(Oi,t),y(Ki,t),y(ec),y(tc,t),y(nc),y(oc,t),y(ac),y(Cs),y(sc,t),y(rc),y(ic,t),y(cc),y(lc,t),y(pc),y(dc,t),y(gc),y(Us),y(uc,t),y(hc),y(Is),y(fc,t),y(mc),y(_c,t),y(bc),y(As),y(yc,t),y(vc),y(xc,t),y($c),y(wc,t),y(kc),y(Ns),y(Tc,t),y(qc),y(Mc,t),y(jc),y(Hc,t),y(Cc),y(Uc,t),y(Ac),y(Nc),y(Js),y(Jc),y(Ec),y(Dc),y(Rc,t),y(Fc),y(Es),y(Ds),y(Gc),y(Rs),y(Sc),y(Lc),y(Zc,t)}}}const YM='{"title":"HfApi Client","local":"hfapi-client","sections":[{"title":"HfApi","local":"huggingface_hub.HfApi ][ huggingface_hub.HfApi","sections":[],"depth":2},{"title":"API Dataclasses","local":"api-dataclasses","sections":[{"title":"AccessRequest","local":"huggingface_hub.hf_api.AccessRequest ][ huggingface_hub.hf_api.AccessRequest","sections":[],"depth":3},{"title":"CommitInfo","local":"huggingface_hub.CommitInfo ][ huggingface_hub.CommitInfo","sections":[],"depth":3},{"title":"DatasetInfo","local":"huggingface_hub.hf_api.DatasetInfo ][ huggingface_hub.DatasetInfo","sections":[],"depth":3},{"title":"GitRefInfo","local":"huggingface_hub.GitRefInfo ][ huggingface_hub.GitRefInfo","sections":[],"depth":3},{"title":"GitCommitInfo","local":"huggingface_hub.GitCommitInfo ][ huggingface_hub.GitCommitInfo","sections":[],"depth":3},{"title":"GitRefs","local":"huggingface_hub.GitRefs ][ huggingface_hub.GitRefs","sections":[],"depth":3},{"title":"ModelInfo","local":"huggingface_hub.hf_api.ModelInfo ][ huggingface_hub.ModelInfo","sections":[],"depth":3},{"title":"RepoSibling","local":"huggingface_hub.hf_api.RepoSibling ][ huggingface_hub.hf_api.RepoSibling","sections":[],"depth":3},{"title":"RepoFile","local":"huggingface_hub.hf_api.RepoFile ][ huggingface_hub.hf_api.RepoFile","sections":[],"depth":3},{"title":"RepoUrl","local":"huggingface_hub.RepoUrl ][ huggingface_hub.RepoUrl","sections":[],"depth":3},{"title":"SafetensorsRepoMetadata","local":"huggingface_hub.utils.SafetensorsRepoMetadata ][ huggingface_hub.utils.SafetensorsRepoMetadata","sections":[],"depth":3},{"title":"SafetensorsFileMetadata","local":"huggingface_hub.utils.SafetensorsFileMetadata ][ huggingface_hub.utils.SafetensorsFileMetadata","sections":[],"depth":3},{"title":"SpaceInfo","local":"huggingface_hub.hf_api.SpaceInfo ][ huggingface_hub.SpaceInfo","sections":[],"depth":3},{"title":"TensorInfo","local":"huggingface_hub.utils.TensorInfo ][ huggingface_hub.utils.TensorInfo","sections":[],"depth":3},{"title":"User","local":"huggingface_hub.User ][ huggingface_hub.User","sections":[],"depth":3},{"title":"UserLikes","local":"huggingface_hub.UserLikes ][ huggingface_hub.UserLikes","sections":[],"depth":3}],"depth":2},{"title":"CommitOperation","local":"huggingface_hub.CommitOperationAdd ][ huggingface_hub.CommitOperationAdd","sections":[],"depth":2},{"title":"CommitScheduler","local":"huggingface_hub.CommitScheduler ][ huggingface_hub.CommitScheduler","sections":[],"depth":2}],"depth":1}';function zM(T){return X0(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class aj extends Y0{constructor(o){super(),z0(this,o,zM,XM,B0,{})}}export{aj as component};
