import{s as sn,o as ln,n as $t}from"../chunks/scheduler.2427eaa0.js";import{S as an,i as nn,g as i,s as a,r as M,A as pn,h as p,f as s,c as n,j as tn,u,x as o,k as At,y as on,a as l,v as c,d as y,t as h,w as d}from"../chunks/index.cf54e274.js";import{T as vt}from"../chunks/Tip.ba8beabf.js";import{C as w}from"../chunks/CodeBlock.1a8c1d5b.js";import{H as J,E as rn}from"../chunks/getInferenceSnippets.f04a0048.js";function Mn(j){let r,U='Want to be listed as an Inference Provider on the Hugging Face Hub? Please reach out to us on social networks or <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">here on the Hub</a>.';return{c(){r=i("p"),r.innerHTML=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-3qkokv"&&(r.innerHTML=U)},m(m,T){l(m,r,T)},p:$t,d(m){m&&s(r)}}}function un(j){let r,U='If your implementation strictly follows the OpenAI API for LLMs and VLMs, you may be able to skip most of this section. In that case, simply open a PR on <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> to register.';return{c(){r=i("p"),r.innerHTML=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-90vl22"&&(r.innerHTML=U)},m(m,T){l(m,r,T)},p:$t,d(m){m&&s(r)}}}function cn(j){let r,U=`Note that <code>chatCompletion</code> is an exception as it is not a pipeline_tag, per se. Instead, it
includes models with either <code>pipeline_tag=&quot;text-generation&quot;</code> or <code>pipeline_tag=&quot;image-text-to-text&quot;</code>
which are tagged as “conversational”.`;return{c(){r=i("p"),r.innerHTML=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-19q0jcc"&&(r.innerHTML=U)},m(m,T){l(m,r,T)},p:$t,d(m){m&&s(r)}}}function yn(j){let r,U="To proceed with this step, we have to enable your account server-side. Make sure you have an organization on the Hub for your enterprise.";return{c(){r=i("p"),r.textContent=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-1letj1o"&&(r.textContent=U)},m(m,T){l(m,r,T)},p:$t,d(m){m&&s(r)}}}function hn(j){let r,U='Important: Make sure that the JS client library can handle LoRA weights for your provider. Check out <a href="https://github.com/huggingface/huggingface.js/blob/904964c9f8cd10ed67114ccb88b9028e89fd6cad/packages/inference/src/providers/fal-ai.ts#L78-L124" rel="nofollow">fal’s implementation</a> for more details.';return{c(){r=i("p"),r.innerHTML=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-1c6mi2m"&&(r.innerHTML=U)},m(m,T){l(m,r,T)},p:$t,d(m){m&&s(r)}}}function dn(j){let r,U="This is publicly accessible. It’s useful to be transparent by default and it helps debug client SDKs, etc.";return{c(){r=i("p"),r.textContent=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-94fcay"&&(r.textContent=U)},m(m,T){l(m,r,T)},p:$t,d(m){m&&s(r)}}}function mn(j){let r,U="Before adding a new provider to the <code>huggingface_hub</code> Python library, make sure that all the previous steps have been completed and everything is working on the Hub. Support in the Python library comes as a second step.";return{c(){r=i("p"),r.innerHTML=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-33g0sl"&&(r.innerHTML=U)},m(m,T){l(m,r,T)},p:$t,d(m){m&&s(r)}}}function Jn(j){let r,U,m,T,q,kt,f,qt,B,_l="This guide details the steps for registering as an inference provider on the Hub and provides implementation guidance.",Bt,H,Rl='<li><strong>Implement standard task APIs</strong> - Follow our task API schemas for compatibility (see <a href="#1-prerequisites">Prerequisites</a>).</li> <li><strong>Submit a PR for JS client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> (see <a href="#2-js-client-integration">JS Client Integration</a>).</li> <li><strong>Register model mappings</strong> - Use our Model Mapping API to link your models to Hub models (see <a href="#3-model-mapping-api">Model Mapping API</a>).</li> <li><strong>Implement a billing endpoint</strong> - Provide an API for billing (see <a href="#4-billing">Billing</a>).</li> <li><strong>Submit a PR for Python client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> (see <a href="#5-python-client-integration">Python client integration</a>).</li> <li><strong>Register your provider server-side and provide an icon</strong> - Reach out to us to add your provider server-side and provide your SVG icon.</li> <li><strong>Create documentation on your side</strong> - Add documentation and do a lot of communication on your side.</li> <li><strong>Add a documentation page</strong> - Open a Pull Request in this repo (huggingface/hub-docs) to add a provider-specific page in the documentation.</li> <li><strong>Share share share</strong> do a lot of comms so that your integration is as successful as possible!</li>',Ht,G,Gt,g,Zt,Z,Sl=`The first step to understand the integration is to take a look at the JS inference client that lives
inside the <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> repo.`,_t,_,Wl=`This is the client that powers our Inference widgets on model pages, and is the blueprint
implementation downstream (for Python SDK, to generate code snippets, etc.).`,Rt,R,St,S,Vl=`You will see that inference methods (<code>textToImage</code>, <code>chatCompletion</code>, etc.) have names that closely
mirror the task names. A task, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of
model (basically which types of inputs and outputs the model has), for instance “text-generation”
or “text-to-image”. It is indicated prominently on model pages, here:`,Wt,I,Xl='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-dark.png"/></picture>',Vt,W,Ql='The list of all possible tasks can be found at <a href="https://huggingface.co/tasks" rel="nofollow">https://huggingface.co/tasks</a> and the list of JS method names is documented in the README at <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">https://github.com/huggingface/huggingface.js/tree/main/packages/inference</a>.',Xt,C,Qt,V,Yt,X,Yl=`For each task type, we enforce an API schema to make it easier for end users to use different
models interchangeably. To be compatible, your third-party API must adhere to a “standard” shape API we expect on HF model pages for each pipeline task type.`,Et,Q,El=`This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be
more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there
exists no standard API.`,Ft,Y,Fl='For example, you can find the expected schema for Text to Speech here: <a href="https://github.com/huggingface/huggingface.js/blob/0a690a14d52041a872dc103846225603599f4a33/packages/tasks/src/tasks/text-to-speech/spec/input.json#L4" rel="nofollow">https://github.com/huggingface/huggingface.js/packages/src/tasks/text-to-speech/spec/input.json#L4</a>, and similarly for other supported tasks. If your API for a given task is different from HF’s, it is not an issue: you can tweak the code in <code>huggingface.js</code> to be able to call your models, i.e., provide some kind of “translation” of parameter names and output names. However, API specs should not be model-specific, only task-specific. Run the JS code and add some <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/test/HfInference.spec.ts" rel="nofollow">tests</a> to make sure it works well. We can help with this step!',Pt,E,Nt,F,Pl="Before proceeding with the next steps, ensure you’ve implemented the necessary code to integrate with the JS client and thoroughly tested your implementation. Here are the steps to follow:",zt,P,Lt,N,Nl="Create a new file under <code>packages/inference/src/providers/{provider_name}.ts</code> and copy-paste the following snippet.",Dt,z,Ot,L,zl="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. You have to define at least <code>makeRoute</code>, <code>preparePayload</code> and <code>getResponse</code>.",Kt,D,Ll='If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern used in the existing providers implementation, e.g. <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/together.ts" rel="nofollow">Together AI provider implementation</a>.',es,O,Dl='For text-generation and conversational tasks, you can just inherit from <code>BaseTextGenerationTask</code> and <code>BaseConversationalTask</code> respectively (defined in <a href="(https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/providerHelper.ts)">providerHelper.ts</a>) and override the methods if needed. Examples can be found in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/cerebras.ts" rel="nofollow">Cerebras</a> or <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/fireworks.ts" rel="nofollow">Fireworks</a> provider implementations.',ts,K,ss,ee,Ol='Go to <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/lib/getProviderHelper.ts" rel="nofollow">packages/inference/src/lib/getProviderHelper.ts</a> and add your provider to <code>PROVIDERS</code>. You will need to add your provider to the <code>INFERENCE_PROVIDERS</code> list as well in <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/types.ts" rel="nofollow">packages/inference/src/types.ts</a>. Please try to respect alphabetical order.',ls,te,Kl='Update the <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/README.md" rel="nofollow">README.md</a> in the <code>packages/inference</code> directory to include your provider in the list of supported providers and the list of supported models links.',as,se,ns,le,ea="Congratulations! You now have a JS implementation to successfully make inference calls on your infra! Time to integrate with the Hub!",is,ae,ta="First step is to use the Model Mapping API to register which HF models are supported.",ps,b,os,ne,rs,ie,Ms,pe,sa="Create a new mapping item, with the following body (JSON-encoded):",us,oe,cs,re,la=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>hfModel</code> is the model id on the Hub’s side.</li> <li><code>providerModel</code> is the model id on your side (can be the same or different).</li>`,ys,Me,aa="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",hs,ue,ds,ce,na=`We also support mapping HF models based on their <code>tags</code>. Using tag filters, you can automatically map multiple HF models to a single inference endpoint on your side.
For example, any model tagged with both <code>lora</code> and <code>base_model:adapter:black-forest-labs/FLUX.1-dev</code> can be mapped to your Flux-dev LoRA inference endpoint.`,ms,v,Js,ye,ia="The API is as follows:",Us,he,Ts,de,pa="Create a new mapping item, with the following body (JSON-encoded):",js,me,ws,Je,oa=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>tags</code> is the set of model tags to match. For example, to match all LoRAs of Flux, you can use: <code>[&quot;lora&quot;, &quot;base_model:adapter:black-forest-labs/FLUX.1-dev&quot;]</code></li> <li><code>providerModel</code> is the model ID on your side (can be the same or different from the HF model ID).</li> <li><code>adapterType</code> is a literal value that helps client libraries interpret how to call your API. The only supported value at the moment is <code>&quot;lora&quot;</code>.</li>`,fs,Ue,ra="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",gs,Te,Is,je,Ma=`You need to be in the <em>provider</em> Hub organization (e.g. <a href="https://huggingface.co/togethercomputer" rel="nofollow">https://huggingface.co/togethercomputer</a>
for TogetherAI) with <strong>Write</strong> permissions to be able to access this endpoint.`,Cs,we,bs,fe,ua="The endpoint validates that:",vs,ge,ca=`<li><code>hfModel</code> is indeed of <code>pipeline_tag == task</code> OR <code>task</code> is “conversational” and the model is
compatible (i.e. the <code>pipeline_tag</code> is either “text-generation” or “image-text-to-text” AND the model is tagged as “conversational”).</li> <li>(in the future) we auto-test that the Partner’s API successfully responds to a
huggingface.js/inference call of the corresponding task i.e. the API specs are valid.</li>`,$s,Ie,xs,Ce,As,be,ya=`Where <code>mapping ID</code> is the mapping’s id obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,ks,ve,qs,$e,ha="Call this HTTP PUT endpoint:",Bs,xe,Hs,Ae,da="With the following body (JSON-encoded):",Gs,ke,Zs,qe,ma=`Where <code>mapping ID</code> is the mapping’s id obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,_s,Be,Rs,He,Ss,Ge,Ja="This gets all mapping items from the DB. For clarity, the output is grouped by task.",Ws,$,Vs,Ze,Ua="Here is an example of response:",Xs,_e,Qs,Re,Ys,Se,Ta="Once a mapping is created through the API, Hugging Face performs periodic automated tests to ensure the mapped endpoint functions correctly.",Es,We,ja="Each model is tested every 6 hours by making API calls to your service. If the test is successful, the model remains active and continues to be tested periodically. However, if the test fails (e.g., your service returns an HTTP error status during an inference request), the provider will be temporarily removed from the list of active providers.",Fs,x,wa='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/automatic-validation-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/automatic-validation-dark.png"/></picture>',Ps,Ve,fa="A failed mapping undergoes retesting every hour. Additionally, updating the status of a model mapping triggers an immediate validation test.",Ns,Xe,ga="The validation process checks the following:",zs,Qe,Ia="<li>The Inference API is reachable, and the HTTP call succeeds.</li> <li>The output format is compatible with the Hugging Face JavaScript Inference Client.</li> <li>Latency requirements are met:<ul><li>For conversational and text models: under 5 seconds (time to first token in streaming mode).</li> <li>For other tasks: under 30 seconds.</li></ul></li>",Ls,Ye,Ca="For large language models (LLMs), additional behavioral tests are conducted:",Ds,Ee,ba="<li>Tool calling support.</li> <li>Structured output support.</li>",Os,Fe,va="These tests involve sending specific inference requests to the model and verifying that the responses meet the expected format.",Ks,Pe,el,Ne,$a=`For routed requests (see figure below), i.e. when users authenticate via HF, our intent is that
our users only pay the standard provider API rates. There’s no additional markup from us, we
just pass through the provider costs directly.
More details about the pricing structure can be found on the <a href="./pricing">pricing page</a>.`,tl,A,xa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/types_of_billing.png"/>',sl,ze,Aa=`We propose an easier way to figure out this cost and charge it to our users, by asking you to
provide the cost for each request via an HTTP API you host on your end.`,ll,Le,al,De,ka=`We ask that you expose an API that supports a HTTP POST request.
The body of the request is a JSON-encoded object containing a list of request IDs for which we
request the cost.
The authentication system should be the same as your Inference service; for example, a bearer token.`,nl,Oe,il,Ke,qa=`The response is also JSON-encoded. The response contains an array of objects specifying the
request’s ID and its cost in nano-USD (10^-9 USD).`,pl,et,ol,tt,rl,st,Ba="We require the price to be a <strong>non-negative integer</strong> number of <strong>nano-USDs</strong> (10^-9 USD).",Ml,lt,ul,at,Ha=`For each request/generation you serve, you should define a unique request (or response) ID,
and provide it as a response Header. We will use this ID as the request ID for the billing API
above.`,cl,nt,Ga="As part of those requirements, please let us know your Header name. If you don’t already have one, we suggest the <code>Inference-Id</code> name for instance, and it should contain a UUID character string.",yl,it,Za="<strong>Example</strong>: Defining an <code>Inference-Id</code> header in your inference response.",hl,pt,dl,ot,ml,k,Jl,rt,Ul,Mt,_a="Create a new file under <code>src/huggingface_hub/inference/_providers/{provider_name}.py</code> and copy-paste the following snippet.",Tl,ut,Ra="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. At least one of <code>_prepare_payload_as_dict</code> or <code>_prepare_payload_as_bytes</code> must be overwritten.",jl,ct,Sa="If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern shown in fal_ai.py.",wl,yt,Wa="For text-generation and conversational tasks, one can just inherit from BaseTextGenerationTask and BaseConversationalTask respectively (defined in _common.py) and override the methods if needed. Examples can be found in fireworks_ai.py and together.py.",fl,ht,gl,dt,Il,mt,Va='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_providers/__init__.py" rel="nofollow">src/huggingface_hub/inference/_providers/<strong>init</strong>.py</a> and add your provider to <code>PROVIDER_T</code> and <code>PROVIDERS</code>. Please try to respect alphabetical order.</li> <li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py" rel="nofollow">src/huggingface_hub/inference/_client.py</a> and update docstring in <code>InferenceClient.__init__</code> to document your provider.</li>',Cl,Jt,bl,Ut,Xa='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/tests/test_inference_providers.py" rel="nofollow">tests/test_inference_providers.py</a> and add static tests for overridden methods.</li>',vl,Tt,$l,jt,Qa="Create a dedicated documentation page for your provider within the Hugging Face documentation. This page should contain a concise description of your provider services, highlight the benefits for users, set expectations regarding performance or features, and include any relevant details such as pricing models or data retention policies. Essentially, provide any information that would be valuable to end users.",xl,wt,Ya="Here’s how to add your documentation page:",Al,ft,Ea='<li>Provide Your Logo: You can send your logo files (separate light and dark mode versions) directly to us. This is often the simplest way. Alternatively, if you prefer, you can open a PR in the <a href="https://huggingface.co/datasets/huggingface/documentation-images/tree/main/inference-providers/logos" rel="nofollow">huggingface/documentation-images</a> repository. If you choose to open a PR:<ul><li>Logos must be in <code>.png</code> format.</li> <li>Name them <code>{provider-name}-light.png</code> and <code>{provider-name}-dark.png</code>.</li> <li>Please ping <code>@Wauplin</code> and <code>@celinah</code> on the PR.</li></ul></li> <li>Create the Documentation File:<ul><li>Use an existing provider page as a template. For example, check out the template for <a href="https://github.com/huggingface/hub-docs/blob/main/scripts/inference-providers/templates/providers/fal-ai.handlebars" rel="nofollow">Fal AI</a>.</li> <li>The file should be located under <code>scripts/inference-providers/templates/providers/{your-provider-name}.handlebars</code>.</li></ul></li> <li>Submit the Documentation PR:<ul><li>Add your new <code>{provider-name}.handlebars</code> file.</li> <li>Update the <a href="./index#partners">partners table</a> to include your company or product.</li> <li>Update the <code>_toctree.yml</code> file in the <code>docs/inference-providers/</code> directory to include your new documentation page in the “Providers” section, maintaining alphabetical order.</li> <li>Update the <code>scripts/inference-providers/scripts/generate.ts</code> file to include your provider in the <code>PROVIDERS_HUB_ORGS</code> and <code>PROVIDERS_URLS</code> constants, maintaining alphabetical order.</li> <li>Run <code>pnpm install</code> (if you haven’t already) and then <code>pnpm run generate</code> at the root of the <code>scripts/inference-providers</code> repository to generate the documentation.</li> <li>Commit all your changes, including the manually edited files (provider page, <code>_toctree.yml</code>, partners table) and the files generated by the script.</li> <li>When you open the PR, please ping @Wauplin, @SBrandeis, @julien-c, and @hanouticelina for a review. If you need any assistance with these steps, please reach out – we’re here to help you!</li></ul></li>',kl,gt,ql,It,Fa="<strong>Question:</strong> By default, in which order do we list providers in the settings page?",Bl,Ct,Pa="<strong>Answer:</strong> The default sort is by total number of requests routed by HF over the last 7 days. This order defines which provider will be used in priority by the widget on the model page (but the user’s order takes precedence).",Hl,bt,Gl,xt,Zl;return q=new J({props:{title:"How to be registered as an inference provider on the Hub?",local:"how-to-be-registered-as-an-inference-provider-on-the-hub",headingTag:"h1"}}),f=new vt({props:{$$slots:{default:[Mn]},$$scope:{ctx:j}}}),G=new J({props:{title:"1. Prerequisites",local:"1-prerequisites",headingTag:"h2"}}),g=new vt({props:{$$slots:{default:[un]},$$scope:{ctx:j}}}),R=new J({props:{title:"What is a Task",local:"what-is-a-task",headingTag:"h3"}}),C=new vt({props:{$$slots:{default:[cn]},$$scope:{ctx:j}}}),V=new J({props:{title:"Task API schema",local:"task-api-schema",headingTag:"h3"}}),E=new J({props:{title:"2. JS Client Integration",local:"2-js-client-integration",headingTag:"h2"}}),P=new J({props:{title:"Implement the provider helper (JS)",local:"implement-the-provider-helper-js",headingTag:"h3"}}),z=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">TaskProviderHelper</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;./providerHelper&quot;</span>;

<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTask</span> <span class="hljs-keyword">extends</span> <span class="hljs-title class_ inherited__">TaskProviderHelper</span> {

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params"></span>) {
		<span class="hljs-variable language_">super</span>(<span class="hljs-string">&quot;your-provider-name&quot;</span>, <span class="hljs-string">&quot;your-api-base-url&quot;</span>, <span class="hljs-string">&quot;task-name&quot;</span>);
	}

    <span class="hljs-keyword">override</span> <span class="hljs-title function_">prepareHeaders</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">HeaderParams</span>, <span class="hljs-attr">binary</span>: <span class="hljs-built_in">boolean</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">string</span>&gt; {
        <span class="hljs-comment">// Override the headers to use for the request.</span>
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">super</span>.<span class="hljs-title function_">prepareHeaders</span>(params, binary);
    }

	<span class="hljs-title function_">makeRoute</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">UrlParams</span>): <span class="hljs-built_in">string</span> {
        <span class="hljs-comment">// Return the route to use for the request. e.g. /v1/chat/completions route is commonly use for chat completion.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">preparePayload</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">BodyParams</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">unknown</span>&gt; {
        <span class="hljs-comment">// Return the payload to use for the request, as a dict.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">getResponse</span>(<span class="hljs-attr">response</span>: <span class="hljs-built_in">unknown</span>, outputType?: <span class="hljs-string">&quot;url&quot;</span> | <span class="hljs-string">&quot;blob&quot;</span>): <span class="hljs-built_in">string</span> | <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-title class_">Blob</span>&gt;{
		<span class="hljs-comment">// Return the response in the expected format.</span>
        <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
    }
}`,wrap:!1}}),K=new J({props:{title:"Register the provider",local:"register-the-provider",headingTag:"h3"}}),se=new J({props:{title:"3. Model Mapping API",local:"3-model-mapping-api",headingTag:"h2"}}),b=new vt({props:{$$slots:{default:[yn]},$$scope:{ctx:j}}}),ne=new J({props:{title:"Register a mapping item",local:"register-a-mapping-item",headingTag:"h3"}}),ie=new w({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),oe=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMldpZGdldFR5cGUlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMmhmTW9kZWwlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwb24lMjBIRiUzQSUyMG5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMEElMjAlMjAlMjAlMjAlMjJwcm92aWRlck1vZGVsJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjB0aGUlMjBwYXJ0bmVyJ3MlMjAlMjJtb2RlbCUyMGlkJTIyJTIwaS5lLiUyMGlkJTIwb24lMjB5b3VyJTIwc2lkZSUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the name of the model on HF: namespace/model-name</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ue=new J({props:{title:"Using a tag-filter to map several HF models to a single inference endpoint",local:"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint",headingTag:"h3"}}),v=new vt({props:{$$slots:{default:[hn]},$$scope:{ctx:j}}}),he=new w({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),me=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnRhZy1maWx0ZXIlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMnRhc2slMjIlM0ElMjAlMjJXaWRnZXRUeXBlJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlMEElMjAlMjAlMjAlMjAlMjJ0YWdzJTIyJTNBJTIwJTVCJTIyc3RyaW5nJTIyJTVEJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjBhbnklMjBIRiUyMG1vZGVsJTIwd2l0aCUyMGFsbCUyMG9mJTIwdGhvc2UlMjB0YWdzJTIwd2lsbCUyMGJlJTIwbWFwcGVkJTIwdG8lMjBwcm92aWRlck1vZGVsJTBBJTIwJTIwJTIwJTIwJTIycHJvdmlkZXJNb2RlbCUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUyMCUyRiUyRiUyMHJlcXVpcmVkJTNBJTIwdGhlJTIwcGFydG5lcidzJTIwJTIybW9kZWwlMjBpZCUyMiUyMGkuZS4lMjBpZCUyMG9uJTIweW91ciUyMHNpZGUlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyVHlwZSUyMiUzQSUyMCUyMmxvcmElMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMG9ubHklMjAlMjJsb3JhJTIyJTIwaXMlMjBzdXBwb3J0ZWQlMjBhdCUyMHRoZSUyMG1vbWVudCUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tag-filter&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: any HF model with all of those tags will be mapped to providerModel</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: only &quot;lora&quot; is supported at the moment</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Te=new J({props:{title:"Authentication",local:"authentication",headingTag:"h4"}}),we=new J({props:{title:"Validation",local:"validation",headingTag:"h4"}}),Ie=new J({props:{title:"Delete a mapping item",local:"delete-a-mapping-item",headingTag:"h3"}}),Ce=new w({props:{code:"REVMRVRFJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RA==",highlighted:"DELETE /api/partners/{provider}/models/{mapping ID}",wrap:!1}}),ve=new J({props:{title:"Update a mapping item’s status",local:"update-a-mapping-items-status",headingTag:"h3"}}),xe=new w({props:{code:"UFVUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RCUyRnN0YXR1cw==",highlighted:"PUT /api/partners/{provider}/models/{mapping ID}/status",wrap:!1}}),ke=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIybGl2ZSUyMiUyMCU3QyUyMCUyMnN0YWdpbmclMjIlMjAlMkYlMkYlMjBUaGUlMjBuZXclMjBzdGF0dXMlMkMlMjBvbmUlMjBvZiUyMCUyMnN0YWdpbmclMjIlMjBvciUyMCUyMmxpdmUlMjIlMEElN0QlMjAlMjAlMjA=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// The new status, one of &quot;staging&quot; or &quot;live&quot;</span>
<span class="hljs-punctuation">}</span>   `,wrap:!1}}),Be=new J({props:{title:"List the whole mapping",local:"list-the-whole-mapping",headingTag:"h3"}}),He=new w({props:{code:"R0VUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRnN0YXR1cyUzRHN0YWdpbmclN0NsaXZl",highlighted:"GET /api/partners/{provider}/models?status=staging|live",wrap:!1}}),$=new vt({props:{warning:!0,$$slots:{default:[dn]},$$scope:{ctx:j}}}),_e=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydGV4dC10by1pbWFnZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLUNhbm55LWRldiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMl9pZCUyMiUzQSUyMCUyMnh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnByb3ZpZGVySWQlMjIlM0ElMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1jYW5ueSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1EZXB0aC1kZXYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJfaWQlMjIlM0ElMjAlMjJ4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwcm92aWRlcklkJTIyJTNBJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGVwdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGF0dXMlMjIlM0ElMjAlMjJsaXZlJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGFnLWZpbHRlciUzRGJhc2VfbW9kZWwlM0FhZGFwdGVyJTNBc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTJDbG9yYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMl9pZCUyMiUzQSUyMCUyMnh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwcm92aWRlcklkJTIyJTNBJTIwJTIyc2R4bC1sb3JhLW11dHVhbGl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGFwdGVyVHlwZSUyMiUzQSUyMCUyMmxvcmElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YWdzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmFzZV9tb2RlbCUzQWFkYXB0ZXIlM0FzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3JhJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udmVyc2F0aW9uYWwlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZWVwc2Vlay1haSUyRkRlZXBTZWVrLVIxJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyX2lkJTIyJTNBJTIwJTIyeHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvdmlkZXJJZCUyMiUzQSUyMCUyMmRlZXBzZWVrLWFpJTJGRGVlcFNlZWstUjElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGF0dXMlMjIlM0ElMjAlMjJsaXZlJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydGV4dC1nZW5lcmF0aW9uJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItNzBiLWhmJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyX2lkJTIyJTNBJTIwJTIyeHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvdmlkZXJJZCUyMiUzQSUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0yLTcwYi1oZiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtaXN0cmFsYWklMkZNaXh0cmFsLTh4N0ItdjAuMSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMl9pZCUyMiUzQSUyMCUyMnh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnByb3ZpZGVySWQlMjIlM0ElMjAlMjJtaXN0cmFsYWklMkZNaXh0cmFsLTh4N0ItdjAuMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;text-to-image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-canny&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-depth&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;tag-filter=base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0,lora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sdxl-lora-mutualized&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
                <span class="hljs-string">&quot;base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-string">&quot;lora&quot;</span>
            <span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;conversational&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;text-generation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Re=new J({props:{title:"Automatic validation",local:"automatic-validation",headingTag:"h3"}}),Pe=new J({props:{title:"4. Billing",local:"4-billing",headingTag:"h2"}}),Le=new J({props:{title:"HTTP API Specs",local:"http-api-specs",headingTag:"h3"}}),Oe=new w({props:{code:"UE9TVCUyMCU3QnlvdXIlMjBVUkwlMjBoZXJlJTdEJTBBQXV0aG9yaXphdGlvbiUzQSUyMCU3QmF1dGhlbnRpY2F0aW9uJTIwaW5mbyUyMC0lMjBlZyUyMCUyMkJlYXJlciUyMHRva2VuJTIyJTdEJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdElkcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMyUyMiUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`POST {your URL here}
<span class="hljs-attribute">Authorization</span><span class="hljs-punctuation">: </span>{authentication info - eg &quot;Bearer token&quot;}
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

{
    &quot;requestIds&quot;: [
        &quot;deadbeef0&quot;,
        &quot;deadbeef1&quot;,
        &quot;deadbeef2&quot;,
        &quot;deadbeef3&quot;
    ]
}`,wrap:!1}}),et=new w({props:{code:"SFRUUCUyRjEuMSUyMDIwMCUyME9LJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjAlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnJlcXVlc3RJZCUyMiUzQSUyMCUyMmRlYWRiZWVmMSUyMiUyQyUyMCUyMmNvc3ROYW5vVXNkJTIyJTNBJTIwMTAwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIycmVxdWVzdElkJTIyJTNBJTIwJTIyZGVhZGJlZWYyJTIyJTJDJTIwJTIyY29zdE5hbm9Vc2QlMjIlM0ElMjAxMDAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjMlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

<span class="language-prolog">{
    <span class="hljs-string">&quot;requests&quot;</span>: [
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef0&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef1&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef2&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef3&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> }
    ]
}</span>`,wrap:!1}}),tt=new J({props:{title:"Price Unit",local:"price-unit",headingTag:"h3"}}),lt=new J({props:{title:"How to define the request ID",local:"how-to-define-the-request-id",headingTag:"h3"}}),pt=new w({props:{code:"UE9TVCUyMCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTVCcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEElNUJyZXF1ZXN0JTIwYm9keSU1RCUwQS0tLS0tLSUwQUhUVFAlMkYxLjElMjAyMDAlMjBPSyUwQUNvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUwQSU1Qm90aGVyJTIwcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEFJbmZlcmVuY2UtSWQlM0ElMjB1bmlxdWUtaWQtMDAxMzElMEElNUJyZXNwb25zZSUyMGJvZHklNUQ=",highlighted:`POST /v1/chat/completions
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[request headers]
[request body]
------
<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[other request headers]
<span class="hljs-attribute">Inference-Id</span><span class="hljs-punctuation">: </span>unique-id-00131
[response body]`,wrap:!1}}),ot=new J({props:{title:"5. Python client integration",local:"5-python-client-integration",headingTag:"h2"}}),k=new vt({props:{$$slots:{default:[mn]},$$scope:{ctx:j}}}),rt=new J({props:{title:"Implement the provider helper (Python)",local:"implement-the-provider-helper-python",headingTag:"h3"}}),ht=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>

<span class="hljs-keyword">from</span> ._common <span class="hljs-keyword">import</span> TaskProviderHelper


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTaskProviderHelper</span>(<span class="hljs-title class_ inherited__">TaskProviderHelper</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Define high-level parameters.&quot;&quot;&quot;</span>
        <span class="hljs-built_in">super</span>().__init__(provider=..., base_url=..., task=...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_response</span>(<span class="hljs-params">
        self,
        response: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bytes</span>, <span class="hljs-type">Dict</span>],
        request_params: <span class="hljs-type">Optional</span>[RequestParameters] = <span class="hljs-literal">None</span>,
    </span>) -&gt; <span class="hljs-type">Any</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return the response in the expected format.

        Override this method in subclasses for customized response handling.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>().get_response(response)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_headers</span>(<span class="hljs-params">self, headers: <span class="hljs-type">Dict</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the headers to use for the request.

        Override this method in subclasses for customized headers.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_headers(headers, api_key)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_route</span>(<span class="hljs-params">self, mapped_model: <span class="hljs-built_in">str</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the route to use for the request.

        Override this method in subclasses for customized routes.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_route(mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_dict</span>(<span class="hljs-params">self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the payload to use for the request, as a dict.

        Override this method in subclasses for customized payloads.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_dict(inputs, parameters, mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_bytes</span>(<span class="hljs-params">
        self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span>, extra_payload: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]
    </span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bytes</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the body to use for the request, as bytes.

        Override this method in subclasses for customized body data.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_bytes(inputs, parameters, mapped_model, extra_payload)`,wrap:!1}}),dt=new J({props:{title:"Register the Provider",local:"register-the-provider",headingTag:"h3"}}),Jt=new J({props:{title:"Add tests",local:"add-tests",headingTag:"h3"}}),Tt=new J({props:{title:"6. Add provider documentation",local:"6-add-provider-documentation",headingTag:"h2"}}),gt=new J({props:{title:"FAQ",local:"faq",headingTag:"h2"}}),bt=new rn({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/inference-providers/register-as-a-provider.md"}}),{c(){r=i("meta"),U=a(),m=i("p"),T=a(),M(q.$$.fragment),kt=a(),M(f.$$.fragment),qt=a(),B=i("p"),B.textContent=_l,Bt=a(),H=i("ol"),H.innerHTML=Rl,Ht=a(),M(G.$$.fragment),Gt=a(),M(g.$$.fragment),Zt=a(),Z=i("p"),Z.innerHTML=Sl,_t=a(),_=i("p"),_.textContent=Wl,Rt=a(),M(R.$$.fragment),St=a(),S=i("p"),S.innerHTML=Vl,Wt=a(),I=i("div"),I.innerHTML=Xl,Vt=a(),W=i("p"),W.innerHTML=Ql,Xt=a(),M(C.$$.fragment),Qt=a(),M(V.$$.fragment),Yt=a(),X=i("p"),X.textContent=Yl,Et=a(),Q=i("p"),Q.textContent=El,Ft=a(),Y=i("p"),Y.innerHTML=Fl,Pt=a(),M(E.$$.fragment),Nt=a(),F=i("p"),F.textContent=Pl,zt=a(),M(P.$$.fragment),Lt=a(),N=i("p"),N.innerHTML=Nl,Dt=a(),M(z.$$.fragment),Ot=a(),L=i("p"),L.innerHTML=zl,Kt=a(),D=i("p"),D.innerHTML=Ll,es=a(),O=i("p"),O.innerHTML=Dl,ts=a(),M(K.$$.fragment),ss=a(),ee=i("p"),ee.innerHTML=Ol,ls=a(),te=i("p"),te.innerHTML=Kl,as=a(),M(se.$$.fragment),ns=a(),le=i("p"),le.textContent=ea,is=a(),ae=i("p"),ae.textContent=ta,ps=a(),M(b.$$.fragment),os=a(),M(ne.$$.fragment),rs=a(),M(ie.$$.fragment),Ms=a(),pe=i("p"),pe.textContent=sa,us=a(),M(oe.$$.fragment),cs=a(),re=i("ul"),re.innerHTML=la,ys=a(),Me=i("p"),Me.textContent=aa,hs=a(),M(ue.$$.fragment),ds=a(),ce=i("p"),ce.innerHTML=na,ms=a(),M(v.$$.fragment),Js=a(),ye=i("p"),ye.textContent=ia,Us=a(),M(he.$$.fragment),Ts=a(),de=i("p"),de.textContent=pa,js=a(),M(me.$$.fragment),ws=a(),Je=i("ul"),Je.innerHTML=oa,fs=a(),Ue=i("p"),Ue.textContent=ra,gs=a(),M(Te.$$.fragment),Is=a(),je=i("p"),je.innerHTML=Ma,Cs=a(),M(we.$$.fragment),bs=a(),fe=i("p"),fe.textContent=ua,vs=a(),ge=i("ul"),ge.innerHTML=ca,$s=a(),M(Ie.$$.fragment),xs=a(),M(Ce.$$.fragment),As=a(),be=i("p"),be.innerHTML=ya,ks=a(),M(ve.$$.fragment),qs=a(),$e=i("p"),$e.textContent=ha,Bs=a(),M(xe.$$.fragment),Hs=a(),Ae=i("p"),Ae.textContent=da,Gs=a(),M(ke.$$.fragment),Zs=a(),qe=i("p"),qe.innerHTML=ma,_s=a(),M(Be.$$.fragment),Rs=a(),M(He.$$.fragment),Ss=a(),Ge=i("p"),Ge.textContent=Ja,Ws=a(),M($.$$.fragment),Vs=a(),Ze=i("p"),Ze.textContent=Ua,Xs=a(),M(_e.$$.fragment),Qs=a(),M(Re.$$.fragment),Ys=a(),Se=i("p"),Se.textContent=Ta,Es=a(),We=i("p"),We.textContent=ja,Fs=a(),x=i("div"),x.innerHTML=wa,Ps=a(),Ve=i("p"),Ve.textContent=fa,Ns=a(),Xe=i("p"),Xe.textContent=ga,zs=a(),Qe=i("ul"),Qe.innerHTML=Ia,Ls=a(),Ye=i("p"),Ye.textContent=Ca,Ds=a(),Ee=i("ul"),Ee.innerHTML=ba,Os=a(),Fe=i("p"),Fe.textContent=va,Ks=a(),M(Pe.$$.fragment),el=a(),Ne=i("p"),Ne.innerHTML=$a,tl=a(),A=i("div"),A.innerHTML=xa,sl=a(),ze=i("p"),ze.textContent=Aa,ll=a(),M(Le.$$.fragment),al=a(),De=i("p"),De.textContent=ka,nl=a(),M(Oe.$$.fragment),il=a(),Ke=i("p"),Ke.textContent=qa,pl=a(),M(et.$$.fragment),ol=a(),M(tt.$$.fragment),rl=a(),st=i("p"),st.innerHTML=Ba,Ml=a(),M(lt.$$.fragment),ul=a(),at=i("p"),at.textContent=Ha,cl=a(),nt=i("p"),nt.innerHTML=Ga,yl=a(),it=i("p"),it.innerHTML=Za,hl=a(),M(pt.$$.fragment),dl=a(),M(ot.$$.fragment),ml=a(),M(k.$$.fragment),Jl=a(),M(rt.$$.fragment),Ul=a(),Mt=i("p"),Mt.innerHTML=_a,Tl=a(),ut=i("p"),ut.innerHTML=Ra,jl=a(),ct=i("p"),ct.textContent=Sa,wl=a(),yt=i("p"),yt.textContent=Wa,fl=a(),M(ht.$$.fragment),gl=a(),M(dt.$$.fragment),Il=a(),mt=i("ul"),mt.innerHTML=Va,Cl=a(),M(Jt.$$.fragment),bl=a(),Ut=i("ul"),Ut.innerHTML=Xa,vl=a(),M(Tt.$$.fragment),$l=a(),jt=i("p"),jt.textContent=Qa,xl=a(),wt=i("p"),wt.textContent=Ya,Al=a(),ft=i("ul"),ft.innerHTML=Ea,kl=a(),M(gt.$$.fragment),ql=a(),It=i("p"),It.innerHTML=Fa,Bl=a(),Ct=i("p"),Ct.innerHTML=Pa,Hl=a(),M(bt.$$.fragment),Gl=a(),xt=i("p"),this.h()},l(e){const t=pn("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(s),U=n(e),m=p(e,"P",{}),tn(m).forEach(s),T=n(e),u(q.$$.fragment,e),kt=n(e),u(f.$$.fragment,e),qt=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-eo2v07"&&(B.textContent=_l),Bt=n(e),H=p(e,"OL",{"data-svelte-h":!0}),o(H)!=="svelte-8emskd"&&(H.innerHTML=Rl),Ht=n(e),u(G.$$.fragment,e),Gt=n(e),u(g.$$.fragment,e),Zt=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-iwney4"&&(Z.innerHTML=Sl),_t=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1xoupob"&&(_.textContent=Wl),Rt=n(e),u(R.$$.fragment,e),St=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-hjt0h1"&&(S.innerHTML=Vl),Wt=n(e),I=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-1cxy3tx"&&(I.innerHTML=Xl),Vt=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-vmhaok"&&(W.innerHTML=Ql),Xt=n(e),u(C.$$.fragment,e),Qt=n(e),u(V.$$.fragment,e),Yt=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-epfhsj"&&(X.textContent=Yl),Et=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-n5dyw"&&(Q.textContent=El),Ft=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-qm2nt8"&&(Y.innerHTML=Fl),Pt=n(e),u(E.$$.fragment,e),Nt=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-aqaw0f"&&(F.textContent=Pl),zt=n(e),u(P.$$.fragment,e),Lt=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1ccsiy1"&&(N.innerHTML=Nl),Dt=n(e),u(z.$$.fragment,e),Ot=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-qutua8"&&(L.innerHTML=zl),Kt=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-uj5o95"&&(D.innerHTML=Ll),es=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1ozzcb1"&&(O.innerHTML=Dl),ts=n(e),u(K.$$.fragment,e),ss=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-dq2kwm"&&(ee.innerHTML=Ol),ls=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-kajnqt"&&(te.innerHTML=Kl),as=n(e),u(se.$$.fragment,e),ns=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1vjzmk"&&(le.textContent=ea),is=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1147onl"&&(ae.textContent=ta),ps=n(e),u(b.$$.fragment,e),os=n(e),u(ne.$$.fragment,e),rs=n(e),u(ie.$$.fragment,e),Ms=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-f1hll8"&&(pe.textContent=sa),us=n(e),u(oe.$$.fragment,e),cs=n(e),re=p(e,"UL",{"data-svelte-h":!0}),o(re)!=="svelte-u6m976"&&(re.innerHTML=la),ys=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-khk897"&&(Me.textContent=aa),hs=n(e),u(ue.$$.fragment,e),ds=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1s9oaze"&&(ce.innerHTML=na),ms=n(e),u(v.$$.fragment,e),Js=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-m8oll3"&&(ye.textContent=ia),Us=n(e),u(he.$$.fragment,e),Ts=n(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-f1hll8"&&(de.textContent=pa),js=n(e),u(me.$$.fragment,e),ws=n(e),Je=p(e,"UL",{"data-svelte-h":!0}),o(Je)!=="svelte-amxywc"&&(Je.innerHTML=oa),fs=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-khk897"&&(Ue.textContent=ra),gs=n(e),u(Te.$$.fragment,e),Is=n(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1avk6lq"&&(je.innerHTML=Ma),Cs=n(e),u(we.$$.fragment,e),bs=n(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-pwj71q"&&(fe.textContent=ua),vs=n(e),ge=p(e,"UL",{"data-svelte-h":!0}),o(ge)!=="svelte-1i002r6"&&(ge.innerHTML=ca),$s=n(e),u(Ie.$$.fragment,e),xs=n(e),u(Ce.$$.fragment,e),As=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-ojjbo0"&&(be.innerHTML=ya),ks=n(e),u(ve.$$.fragment,e),qs=n(e),$e=p(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-18yjufw"&&($e.textContent=ha),Bs=n(e),u(xe.$$.fragment,e),Hs=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1ar1qn2"&&(Ae.textContent=da),Gs=n(e),u(ke.$$.fragment,e),Zs=n(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-ojjbo0"&&(qe.innerHTML=ma),_s=n(e),u(Be.$$.fragment,e),Rs=n(e),u(He.$$.fragment,e),Ss=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-16sv3hm"&&(Ge.textContent=Ja),Ws=n(e),u($.$$.fragment,e),Vs=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1ovcz13"&&(Ze.textContent=Ua),Xs=n(e),u(_e.$$.fragment,e),Qs=n(e),u(Re.$$.fragment,e),Ys=n(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-aop9q6"&&(Se.textContent=Ta),Es=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-11lkosy"&&(We.textContent=ja),Fs=n(e),x=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(x)!=="svelte-32c4s1"&&(x.innerHTML=wa),Ps=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1s4io98"&&(Ve.textContent=fa),Ns=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-2tk9q6"&&(Xe.textContent=ga),zs=n(e),Qe=p(e,"UL",{"data-svelte-h":!0}),o(Qe)!=="svelte-1t9sco3"&&(Qe.innerHTML=Ia),Ls=n(e),Ye=p(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-kzwdhh"&&(Ye.textContent=Ca),Ds=n(e),Ee=p(e,"UL",{"data-svelte-h":!0}),o(Ee)!=="svelte-ao16pi"&&(Ee.innerHTML=ba),Os=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1rp1v84"&&(Fe.textContent=va),Ks=n(e),u(Pe.$$.fragment,e),el=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-lf5sv5"&&(Ne.innerHTML=$a),tl=n(e),A=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(A)!=="svelte-1roilif"&&(A.innerHTML=xa),sl=n(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1072wo1"&&(ze.textContent=Aa),ll=n(e),u(Le.$$.fragment,e),al=n(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-ogq2gt"&&(De.textContent=ka),nl=n(e),u(Oe.$$.fragment,e),il=n(e),Ke=p(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-krncuc"&&(Ke.textContent=qa),pl=n(e),u(et.$$.fragment,e),ol=n(e),u(tt.$$.fragment,e),rl=n(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-bpbibl"&&(st.innerHTML=Ba),Ml=n(e),u(lt.$$.fragment,e),ul=n(e),at=p(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-speu7d"&&(at.textContent=Ha),cl=n(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-13ler1d"&&(nt.innerHTML=Ga),yl=n(e),it=p(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-ub059v"&&(it.innerHTML=Za),hl=n(e),u(pt.$$.fragment,e),dl=n(e),u(ot.$$.fragment,e),ml=n(e),u(k.$$.fragment,e),Jl=n(e),u(rt.$$.fragment,e),Ul=n(e),Mt=p(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-102eqn3"&&(Mt.innerHTML=_a),Tl=n(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-lavds"&&(ut.innerHTML=Ra),jl=n(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-f0qt8k"&&(ct.textContent=Sa),wl=n(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-w9ft7n"&&(yt.textContent=Wa),fl=n(e),u(ht.$$.fragment,e),gl=n(e),u(dt.$$.fragment,e),Il=n(e),mt=p(e,"UL",{"data-svelte-h":!0}),o(mt)!=="svelte-117ozzs"&&(mt.innerHTML=Va),Cl=n(e),u(Jt.$$.fragment,e),bl=n(e),Ut=p(e,"UL",{"data-svelte-h":!0}),o(Ut)!=="svelte-vl7c7p"&&(Ut.innerHTML=Xa),vl=n(e),u(Tt.$$.fragment,e),$l=n(e),jt=p(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-ccionj"&&(jt.textContent=Qa),xl=n(e),wt=p(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1dt3smc"&&(wt.textContent=Ya),Al=n(e),ft=p(e,"UL",{"data-svelte-h":!0}),o(ft)!=="svelte-1n9xyev"&&(ft.innerHTML=Ea),kl=n(e),u(gt.$$.fragment,e),ql=n(e),It=p(e,"P",{"data-svelte-h":!0}),o(It)!=="svelte-1yfr1yr"&&(It.innerHTML=Fa),Bl=n(e),Ct=p(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-1duzsqa"&&(Ct.innerHTML=Pa),Hl=n(e),u(bt.$$.fragment,e),Gl=n(e),xt=p(e,"P",{}),tn(xt).forEach(s),this.h()},h(){At(r,"name","hf:doc:metadata"),At(r,"content",Un),At(I,"class","flex justify-center"),At(x,"class","flex justify-center"),At(A,"class","flex justify-center")},m(e,t){on(document.head,r),l(e,U,t),l(e,m,t),l(e,T,t),c(q,e,t),l(e,kt,t),c(f,e,t),l(e,qt,t),l(e,B,t),l(e,Bt,t),l(e,H,t),l(e,Ht,t),c(G,e,t),l(e,Gt,t),c(g,e,t),l(e,Zt,t),l(e,Z,t),l(e,_t,t),l(e,_,t),l(e,Rt,t),c(R,e,t),l(e,St,t),l(e,S,t),l(e,Wt,t),l(e,I,t),l(e,Vt,t),l(e,W,t),l(e,Xt,t),c(C,e,t),l(e,Qt,t),c(V,e,t),l(e,Yt,t),l(e,X,t),l(e,Et,t),l(e,Q,t),l(e,Ft,t),l(e,Y,t),l(e,Pt,t),c(E,e,t),l(e,Nt,t),l(e,F,t),l(e,zt,t),c(P,e,t),l(e,Lt,t),l(e,N,t),l(e,Dt,t),c(z,e,t),l(e,Ot,t),l(e,L,t),l(e,Kt,t),l(e,D,t),l(e,es,t),l(e,O,t),l(e,ts,t),c(K,e,t),l(e,ss,t),l(e,ee,t),l(e,ls,t),l(e,te,t),l(e,as,t),c(se,e,t),l(e,ns,t),l(e,le,t),l(e,is,t),l(e,ae,t),l(e,ps,t),c(b,e,t),l(e,os,t),c(ne,e,t),l(e,rs,t),c(ie,e,t),l(e,Ms,t),l(e,pe,t),l(e,us,t),c(oe,e,t),l(e,cs,t),l(e,re,t),l(e,ys,t),l(e,Me,t),l(e,hs,t),c(ue,e,t),l(e,ds,t),l(e,ce,t),l(e,ms,t),c(v,e,t),l(e,Js,t),l(e,ye,t),l(e,Us,t),c(he,e,t),l(e,Ts,t),l(e,de,t),l(e,js,t),c(me,e,t),l(e,ws,t),l(e,Je,t),l(e,fs,t),l(e,Ue,t),l(e,gs,t),c(Te,e,t),l(e,Is,t),l(e,je,t),l(e,Cs,t),c(we,e,t),l(e,bs,t),l(e,fe,t),l(e,vs,t),l(e,ge,t),l(e,$s,t),c(Ie,e,t),l(e,xs,t),c(Ce,e,t),l(e,As,t),l(e,be,t),l(e,ks,t),c(ve,e,t),l(e,qs,t),l(e,$e,t),l(e,Bs,t),c(xe,e,t),l(e,Hs,t),l(e,Ae,t),l(e,Gs,t),c(ke,e,t),l(e,Zs,t),l(e,qe,t),l(e,_s,t),c(Be,e,t),l(e,Rs,t),c(He,e,t),l(e,Ss,t),l(e,Ge,t),l(e,Ws,t),c($,e,t),l(e,Vs,t),l(e,Ze,t),l(e,Xs,t),c(_e,e,t),l(e,Qs,t),c(Re,e,t),l(e,Ys,t),l(e,Se,t),l(e,Es,t),l(e,We,t),l(e,Fs,t),l(e,x,t),l(e,Ps,t),l(e,Ve,t),l(e,Ns,t),l(e,Xe,t),l(e,zs,t),l(e,Qe,t),l(e,Ls,t),l(e,Ye,t),l(e,Ds,t),l(e,Ee,t),l(e,Os,t),l(e,Fe,t),l(e,Ks,t),c(Pe,e,t),l(e,el,t),l(e,Ne,t),l(e,tl,t),l(e,A,t),l(e,sl,t),l(e,ze,t),l(e,ll,t),c(Le,e,t),l(e,al,t),l(e,De,t),l(e,nl,t),c(Oe,e,t),l(e,il,t),l(e,Ke,t),l(e,pl,t),c(et,e,t),l(e,ol,t),c(tt,e,t),l(e,rl,t),l(e,st,t),l(e,Ml,t),c(lt,e,t),l(e,ul,t),l(e,at,t),l(e,cl,t),l(e,nt,t),l(e,yl,t),l(e,it,t),l(e,hl,t),c(pt,e,t),l(e,dl,t),c(ot,e,t),l(e,ml,t),c(k,e,t),l(e,Jl,t),c(rt,e,t),l(e,Ul,t),l(e,Mt,t),l(e,Tl,t),l(e,ut,t),l(e,jl,t),l(e,ct,t),l(e,wl,t),l(e,yt,t),l(e,fl,t),c(ht,e,t),l(e,gl,t),c(dt,e,t),l(e,Il,t),l(e,mt,t),l(e,Cl,t),c(Jt,e,t),l(e,bl,t),l(e,Ut,t),l(e,vl,t),c(Tt,e,t),l(e,$l,t),l(e,jt,t),l(e,xl,t),l(e,wt,t),l(e,Al,t),l(e,ft,t),l(e,kl,t),c(gt,e,t),l(e,ql,t),l(e,It,t),l(e,Bl,t),l(e,Ct,t),l(e,Hl,t),c(bt,e,t),l(e,Gl,t),l(e,xt,t),Zl=!0},p(e,[t]){const Na={};t&2&&(Na.$$scope={dirty:t,ctx:e}),f.$set(Na);const za={};t&2&&(za.$$scope={dirty:t,ctx:e}),g.$set(za);const La={};t&2&&(La.$$scope={dirty:t,ctx:e}),C.$set(La);const Da={};t&2&&(Da.$$scope={dirty:t,ctx:e}),b.$set(Da);const Oa={};t&2&&(Oa.$$scope={dirty:t,ctx:e}),v.$set(Oa);const Ka={};t&2&&(Ka.$$scope={dirty:t,ctx:e}),$.$set(Ka);const en={};t&2&&(en.$$scope={dirty:t,ctx:e}),k.$set(en)},i(e){Zl||(y(q.$$.fragment,e),y(f.$$.fragment,e),y(G.$$.fragment,e),y(g.$$.fragment,e),y(R.$$.fragment,e),y(C.$$.fragment,e),y(V.$$.fragment,e),y(E.$$.fragment,e),y(P.$$.fragment,e),y(z.$$.fragment,e),y(K.$$.fragment,e),y(se.$$.fragment,e),y(b.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(oe.$$.fragment,e),y(ue.$$.fragment,e),y(v.$$.fragment,e),y(he.$$.fragment,e),y(me.$$.fragment,e),y(Te.$$.fragment,e),y(we.$$.fragment,e),y(Ie.$$.fragment,e),y(Ce.$$.fragment,e),y(ve.$$.fragment,e),y(xe.$$.fragment,e),y(ke.$$.fragment,e),y(Be.$$.fragment,e),y(He.$$.fragment,e),y($.$$.fragment,e),y(_e.$$.fragment,e),y(Re.$$.fragment,e),y(Pe.$$.fragment,e),y(Le.$$.fragment,e),y(Oe.$$.fragment,e),y(et.$$.fragment,e),y(tt.$$.fragment,e),y(lt.$$.fragment,e),y(pt.$$.fragment,e),y(ot.$$.fragment,e),y(k.$$.fragment,e),y(rt.$$.fragment,e),y(ht.$$.fragment,e),y(dt.$$.fragment,e),y(Jt.$$.fragment,e),y(Tt.$$.fragment,e),y(gt.$$.fragment,e),y(bt.$$.fragment,e),Zl=!0)},o(e){h(q.$$.fragment,e),h(f.$$.fragment,e),h(G.$$.fragment,e),h(g.$$.fragment,e),h(R.$$.fragment,e),h(C.$$.fragment,e),h(V.$$.fragment,e),h(E.$$.fragment,e),h(P.$$.fragment,e),h(z.$$.fragment,e),h(K.$$.fragment,e),h(se.$$.fragment,e),h(b.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(ue.$$.fragment,e),h(v.$$.fragment,e),h(he.$$.fragment,e),h(me.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(Ie.$$.fragment,e),h(Ce.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(ke.$$.fragment,e),h(Be.$$.fragment,e),h(He.$$.fragment,e),h($.$$.fragment,e),h(_e.$$.fragment,e),h(Re.$$.fragment,e),h(Pe.$$.fragment,e),h(Le.$$.fragment,e),h(Oe.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(lt.$$.fragment,e),h(pt.$$.fragment,e),h(ot.$$.fragment,e),h(k.$$.fragment,e),h(rt.$$.fragment,e),h(ht.$$.fragment,e),h(dt.$$.fragment,e),h(Jt.$$.fragment,e),h(Tt.$$.fragment,e),h(gt.$$.fragment,e),h(bt.$$.fragment,e),Zl=!1},d(e){e&&(s(U),s(m),s(T),s(kt),s(qt),s(B),s(Bt),s(H),s(Ht),s(Gt),s(Zt),s(Z),s(_t),s(_),s(Rt),s(St),s(S),s(Wt),s(I),s(Vt),s(W),s(Xt),s(Qt),s(Yt),s(X),s(Et),s(Q),s(Ft),s(Y),s(Pt),s(Nt),s(F),s(zt),s(Lt),s(N),s(Dt),s(Ot),s(L),s(Kt),s(D),s(es),s(O),s(ts),s(ss),s(ee),s(ls),s(te),s(as),s(ns),s(le),s(is),s(ae),s(ps),s(os),s(rs),s(Ms),s(pe),s(us),s(cs),s(re),s(ys),s(Me),s(hs),s(ds),s(ce),s(ms),s(Js),s(ye),s(Us),s(Ts),s(de),s(js),s(ws),s(Je),s(fs),s(Ue),s(gs),s(Is),s(je),s(Cs),s(bs),s(fe),s(vs),s(ge),s($s),s(xs),s(As),s(be),s(ks),s(qs),s($e),s(Bs),s(Hs),s(Ae),s(Gs),s(Zs),s(qe),s(_s),s(Rs),s(Ss),s(Ge),s(Ws),s(Vs),s(Ze),s(Xs),s(Qs),s(Ys),s(Se),s(Es),s(We),s(Fs),s(x),s(Ps),s(Ve),s(Ns),s(Xe),s(zs),s(Qe),s(Ls),s(Ye),s(Ds),s(Ee),s(Os),s(Fe),s(Ks),s(el),s(Ne),s(tl),s(A),s(sl),s(ze),s(ll),s(al),s(De),s(nl),s(il),s(Ke),s(pl),s(ol),s(rl),s(st),s(Ml),s(ul),s(at),s(cl),s(nt),s(yl),s(it),s(hl),s(dl),s(ml),s(Jl),s(Ul),s(Mt),s(Tl),s(ut),s(jl),s(ct),s(wl),s(yt),s(fl),s(gl),s(Il),s(mt),s(Cl),s(bl),s(Ut),s(vl),s($l),s(jt),s(xl),s(wt),s(Al),s(ft),s(kl),s(ql),s(It),s(Bl),s(Ct),s(Hl),s(Gl),s(xt)),s(r),d(q,e),d(f,e),d(G,e),d(g,e),d(R,e),d(C,e),d(V,e),d(E,e),d(P,e),d(z,e),d(K,e),d(se,e),d(b,e),d(ne,e),d(ie,e),d(oe,e),d(ue,e),d(v,e),d(he,e),d(me,e),d(Te,e),d(we,e),d(Ie,e),d(Ce,e),d(ve,e),d(xe,e),d(ke,e),d(Be,e),d(He,e),d($,e),d(_e,e),d(Re,e),d(Pe,e),d(Le,e),d(Oe,e),d(et,e),d(tt,e),d(lt,e),d(pt,e),d(ot,e),d(k,e),d(rt,e),d(ht,e),d(dt,e),d(Jt,e),d(Tt,e),d(gt,e),d(bt,e)}}}const Un='{"title":"How to be registered as an inference provider on the Hub?","local":"how-to-be-registered-as-an-inference-provider-on-the-hub","sections":[{"title":"1. Prerequisites","local":"1-prerequisites","sections":[{"title":"What is a Task","local":"what-is-a-task","sections":[],"depth":3},{"title":"Task API schema","local":"task-api-schema","sections":[],"depth":3}],"depth":2},{"title":"2. JS Client Integration","local":"2-js-client-integration","sections":[{"title":"Implement the provider helper (JS)","local":"implement-the-provider-helper-js","sections":[],"depth":3},{"title":"Register the provider","local":"register-the-provider","sections":[],"depth":3}],"depth":2},{"title":"3. Model Mapping API","local":"3-model-mapping-api","sections":[{"title":"Register a mapping item","local":"register-a-mapping-item","sections":[],"depth":3},{"title":"Using a tag-filter to map several HF models to a single inference endpoint","local":"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint","sections":[{"title":"Authentication","local":"authentication","sections":[],"depth":4},{"title":"Validation","local":"validation","sections":[],"depth":4}],"depth":3},{"title":"Delete a mapping item","local":"delete-a-mapping-item","sections":[],"depth":3},{"title":"Update a mapping item’s status","local":"update-a-mapping-items-status","sections":[],"depth":3},{"title":"List the whole mapping","local":"list-the-whole-mapping","sections":[],"depth":3},{"title":"Automatic validation","local":"automatic-validation","sections":[],"depth":3}],"depth":2},{"title":"4. Billing","local":"4-billing","sections":[{"title":"HTTP API Specs","local":"http-api-specs","sections":[],"depth":3},{"title":"Price Unit","local":"price-unit","sections":[],"depth":3},{"title":"How to define the request ID","local":"how-to-define-the-request-id","sections":[],"depth":3}],"depth":2},{"title":"5. Python client integration","local":"5-python-client-integration","sections":[{"title":"Implement the provider helper (Python)","local":"implement-the-provider-helper-python","sections":[],"depth":3},{"title":"Register the Provider","local":"register-the-provider","sections":[],"depth":3},{"title":"Add tests","local":"add-tests","sections":[],"depth":3}],"depth":2},{"title":"6. Add provider documentation","local":"6-add-provider-documentation","sections":[],"depth":2},{"title":"FAQ","local":"faq","sections":[],"depth":2}],"depth":1}';function Tn(j){return ln(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cn extends an{constructor(r){super(),nn(this,r,Tn,Jn,sn,{})}}export{Cn as component};
