import{s as Et,o as Gt,n as _t}from"../chunks/scheduler.d627b047.js";import{S as kt,i as vt,g as o,s,r,A as Wt,h as J,f as t,c as n,j as gt,u as i,x as w,k as Zt,y as Xt,a,v as p,d as U,t as c,w as M}from"../chunks/index.d48c4817.js";import{T as Ct}from"../chunks/Tip.9bd3babf.js";import{C as T}from"../chunks/CodeBlock.5da89496.js";import{H as j}from"../chunks/Heading.47e562a9.js";function Ft(ve){let y,m='💡 Read the <a href="https://arxiv.org/abs/2208.07339" rel="nofollow">LLM.int8(): 8-bit Matrix Multiplication for Transformers at Scale</a> paper to learn more, or you can take a look at the corresponding <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blog post</a> for a gentler introduction.';return{c(){y=o("p"),y.innerHTML=m},l(d){y=J(d,"P",{"data-svelte-h":!0}),w(y)!=="svelte-vnrnwq"&&(y.innerHTML=m)},m(d,u){a(d,y,u)},p:_t,d(d){d&&t(y)}}}function Bt(ve){let y,m="💡 The weight matrix is scaled by <code>lora_alpha/r</code>, and a higher <code>lora_alpha</code> value assigns more weight to the LoRA activations. For performance, we recommend setting bias to <code>None</code> first, and then <code>lora_only</code>, before trying <code>all</code>.";return{c(){y=o("p"),y.innerHTML=m},l(d){y=J(d,"P",{"data-svelte-h":!0}),w(y)!=="svelte-1r9uo30"&&(y.innerHTML=m)},m(d,u){a(d,y,u)},p:_t,d(d){d&&t(y)}}}function Nt(ve){let y,m,d,u,b,Xe,I,Sl="Quantization reduces the precision of floating point data types, decreasing the memory required to store model weights. However, quantization degrades inference performance because you lose information when you reduce the precision. 8-bit or <code>int8</code> quantization uses only a quarter precision, but it does not degrade performance because it doesn’t just drop the bits or data. Instead, <code>int8</code> quantization <em>rounds</em> from one data type to another.",Fe,h,Be,g,Hl='This guide will show you how to train a <a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow"><code>openai/whisper-large-v2</code></a> model for multilingual automatic speech recognition (ASR) using a combination of <code>int8</code> quantization and LoRA. You’ll train Whisper for multilingual ASR on Marathi from the <a href="https://huggingface.co/datasets/mozilla-foundation/common_voice_11_0" rel="nofollow">Common Voice 11.0</a> dataset.',Ne,Z,xl="Before you start, make sure you have all the necessary libraries installed:",Re,C,Ve,_,Ye,E,Ll="Let’s take care of some of the setup first so you can start training faster later. Set the <code>CUDA_VISIBLE_DEVICES</code> to <code>0</code> to use the first GPU on your machine. Then you can specify the model name (either a Hub model repository id or a path to a directory containing the model), language and language abbreviation to train on, the task type, and the dataset name:",$e,G,Qe,k,Dl="You can also log in to your Hugging Face account to save and share your trained model on the Hub if you’d like:",Ae,v,qe,W,ze,X,Pl='The <a href="https://huggingface.co/datasets/mozilla-foundation/common_voice_11_0" rel="nofollow">Common Voice 11.0</a> dataset contains many hours of recorded speech in many different languages. This guide uses the <a href="https://huggingface.co/datasets/mozilla-foundation/common_voice_11_0/viewer/mr/train" rel="nofollow">Marathi</a> language as an example, but feel free to use any other language you’re interested in.',Se,F,Kl='Initialize a <a href="https://huggingface.co/docs/datasets/v2.16.1/en/package_reference/main_classes#datasets.DatasetDict" rel="nofollow">DatasetDict</a> structure, and load the <code>train</code> (load both the <code>train+validation</code> split into <code>train</code>) and <code>test</code> splits from the dataset into it:',He,B,xe,N,Le,R,Ol="Let’s prepare the dataset for training. Load a feature extractor, tokenizer, and processor. You should also pass the language and task to the tokenizer and processor so they know how to process the inputs:",De,V,Pe,Y,et='You’ll only be training on the <code>sentence</code> and <code>audio</code> columns, so you can remove the rest of the metadata with <a href="https://huggingface.co/docs/datasets/v2.16.1/en/package_reference/main_classes#datasets.Dataset.remove_columns" rel="nofollow">remove_columns</a>:',Ke,$,Oe,Q,lt='If you look at the <code>sampling_rate</code>, you’ll see the audio was sampled at 48kHz. The Whisper model was pretrained on audio inputs at 16kHZ which means you’ll need to downsample the audio inputs to match what the model was pretrained on. Downsample the audio by using the <a href="https://huggingface.co/docs/datasets/v2.16.1/en/package_reference/main_classes#datasets.Dataset.cast_column" rel="nofollow">cast_column</a> method on the <code>audio</code> column, and set the <code>sampling_rate</code> to 16kHz. The audio input is resampled on the fly the next time you call it:',el,A,ll,q,tt="Once you’ve cleaned up the dataset, you can write a function to generate the correct model inputs. The function should:",tl,z,at="<li>Resample the audio inputs to 16kHZ by loading the <code>audio</code> column.</li> <li>Compute the input features from the audio <code>array</code> using the feature extractor.</li> <li>Tokenize the <code>sentence</code> column to the input labels.</li>",al,S,sl,H,st='Apply the <code>prepare_dataset</code> function to the dataset with the <a href="https://huggingface.co/docs/datasets/v2.16.1/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> function, and set the <code>num_proc</code> argument to <code>2</code> to enable multiprocessing (if <code>map</code> hangs, then set <code>num_proc=1</code>):',nl,x,ol,L,nt="Finally, create a <code>DataCollator</code> class to pad the labels in each batch to the maximum length, and replace padding with <code>-100</code> so they’re ignored by the loss function. Then initialize an instance of the data collator:",Jl,D,rl,P,il,K,ot='Now that the dataset is ready, you can turn your attention to the model. Start by loading the pretrained <a href=""><code>openai/whisper-large-v2</code></a> model from <a href="https://huggingface.co/docs/transformers/v4.37.2/en/model_doc/auto#transformers.AutoModelForSpeechSeq2Seq" rel="nofollow">AutoModelForSpeechSeq2Seq</a>, and make sure to set the <code>load_in_8bit</code> argument to <code>True</code> to enable <code>int8</code> quantization. The <code>device_map=auto</code> argument automatically determines how to load and store the model weights:',pl,O,Ul,ee,Jt="You should configure <code>forced_decoder_ids=None</code> because no tokens are used before sampling, and you won’t need to suppress any tokens during generation either:",cl,le,Ml,te,rt='To get the model ready for <code>int8</code> quantization, use the utility function <a href="https://github.com/huggingface/peft/blob/34027fe813756897767b9a6f19ae7f1c4c7b418c/src/peft/utils/other.py#L35" rel="nofollow"><code>prepare_model_for_int8_training</code></a> to handle the following:',wl,ae,it="<li>casts all the non <code>int8</code> modules to full precision (<code>fp32</code>) for stability</li> <li>adds a forward hook to the input embedding layer to calculate the gradients of the input hidden states</li> <li>enables gradient checkpointing for more memory-efficient training</li>",yl,se,Tl,ne,pt='Let’s also apply LoRA to the training to make it even more efficient. Load a <a href="/docs/peft/v0.8.1/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and configure the following parameters:',dl,oe,Ut="<li><code>r</code>, the dimension of the low-rank matrices</li> <li><code>lora_alpha</code>, scaling factor for the weight matrices</li> <li><code>target_modules</code>, the name of the attention matrices to apply LoRA to (<code>q_proj</code> and <code>v_proj</code>, or query and value in this case)</li> <li><code>lora_dropout</code>, dropout probability of the LoRA layers</li> <li><code>bias</code>, set to <code>none</code></li>",ml,f,ul,Je,hl,re,ct='After you set up the <a href="/docs/peft/v0.8.1/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>, wrap it and the base model with the <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>. Print out the number of trainable parameters to see how much more efficient LoRA is compared to fully training the model!',fl,ie,jl,pe,Mt='Now you’re ready to define some training hyperparameters in the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Seq2SeqTrainingArguments" rel="nofollow">Seq2SeqTrainingArguments</a> class, such as where to save the model to, batch size, learning rate, and number of epochs to train for. The <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> doesn’t have the same signature as the base model, so you’ll need to explicitly set <code>remove_unused_columns=False</code> and <code>label_names=[&quot;labels&quot;]</code>.',bl,Ue,Il,ce,wt='It is also a good idea to write a custom <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/callback#transformers.TrainerCallback" rel="nofollow">TrainerCallback</a> to save model checkpoints during training:',gl,Me,Zl,we,yt='Pass the <code>Seq2SeqTrainingArguments</code>, model, datasets, data collator, tokenizer, and callback to the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Seq2SeqTrainer" rel="nofollow">Seq2SeqTrainer</a>. You can optionally set <code>model.config.use_cache = False</code> to silence any warnings. Once everything is ready, call <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a> to start training!',Cl,ye,_l,Te,El,de,Tt='<a href="https://huggingface.co/spaces/evaluate-metric/wer" rel="nofollow">Word error rate</a> (WER) is a common metric for evaluating ASR models. Load the WER metric from 🤗 Evaluate:',Gl,me,kl,ue,dt='Write a loop to evaluate the model performance. Set the model to evaluation mode first, and write the loop with <a href="https://pytorch.org/docs/stable/amp.html" rel="nofollow"><code>torch.cuda.amp.autocast()</code></a> because <code>int8</code> training requires autocasting. Then, pass a batch of examples to the model to evaluate. Get the decoded predictions and labels, and add them as a batch to the WER metric before calling <code>compute</code> to get the final WER score:',vl,he,Wl,fe,Xl,je,mt='Once you’re happy with your results, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method:',Fl,be,Bl,Ie,Nl,ge,ut="Let’s test the model out now!",Rl,Ze,ht='Instantiate the model configuration from <a href="/docs/peft/v0.8.1/en/package_reference/config#peft.PeftConfig">PeftConfig</a>, and from here, you can use the configuration to load the base and <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>, tokenizer, processor, and feature extractor. Remember to define the <code>language</code> and <code>task</code> in the tokenizer, processor, and <code>forced_decoder_ids</code>:',Vl,Ce,Yl,_e,ft='Load an audio sample (you can listen to it in the <a href="https://huggingface.co/datasets/stevhliu/dummy" rel="nofollow">Dataset Preview</a>) to transcribe, and the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline" rel="nofollow">AutomaticSpeechRecognitionPipeline</a>:',$l,Ee,Ql,Ge,jt="Then use the pipeline with autocast as a context manager on the audio sample:",Al,ke,ql,We,zl;return b=new j({props:{title:"int8 training for automatic speech recognition",local:"int8-training-for-automatic-speech-recognition",headingTag:"h1"}}),h=new Ct({props:{$$slots:{default:[Ft]},$$scope:{ctx:ve}}}),C=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHBlZnQlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cyUyMGFjY2VsZXJhdGUlMjBldmFsdWF0ZSUyMGppd2VyJTIwYml0c2FuZGJ5dGVz",highlighted:"!pip install -q peft transformers datasets accelerate evaluate jiwer bitsandbytes",wrap:!1}}),_=new j({props:{title:"Setup",local:"setup",headingTag:"h2"}}),G=new T({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5lbnZpcm9uJTVCJTIyQ1VEQV9WSVNJQkxFX0RFVklDRVMlMjIlNUQlMjAlM0QlMjAlMjIwJTIyJTBBbW9kZWxfbmFtZV9vcl9wYXRoJTIwJTNEJTIwJTIyb3BlbmFpJTJGd2hpc3Blci1sYXJnZS12MiUyMiUwQWxhbmd1YWdlJTIwJTNEJTIwJTIyTWFyYXRoaSUyMiUwQWxhbmd1YWdlX2FiYnIlMjAlM0QlMjAlMjJtciUyMiUwQXRhc2slMjAlM0QlMjAlMjJ0cmFuc2NyaWJlJTIyJTBBZGF0YXNldF9uYW1lJTIwJTNEJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzExXzAlMjI=",highlighted:`<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;CUDA_VISIBLE_DEVICES&quot;</span>] = <span class="hljs-string">&quot;0&quot;</span>
model_name_or_path = <span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>
language = <span class="hljs-string">&quot;Marathi&quot;</span>
language_abbr = <span class="hljs-string">&quot;mr&quot;</span>
task = <span class="hljs-string">&quot;transcribe&quot;</span>
dataset_name = <span class="hljs-string">&quot;mozilla-foundation/common_voice_11_0&quot;</span>`,wrap:!1}}),v=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),W=new j({props:{title:"Load dataset and metric",local:"load-dataset-and-metric",headingTag:"h2"}}),B=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwRGF0YXNldERpY3QlMEElMEFjb21tb25fdm9pY2UlMjAlM0QlMjBEYXRhc2V0RGljdCgpJTBBJTBBY29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9uYW1lJTJDJTIwbGFuZ3VhZ2VfYWJiciUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMkJ2YWxpZGF0aW9uJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9uYW1lJTJDJTIwbGFuZ3VhZ2VfYWJiciUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSklMEFjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, DatasetDict

common_voice = DatasetDict()

common_voice[<span class="hljs-string">&quot;train&quot;</span>] = load_dataset(dataset_name, language_abbr, split=<span class="hljs-string">&quot;train+validation&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)
common_voice[<span class="hljs-string">&quot;test&quot;</span>] = load_dataset(dataset_name, language_abbr, split=<span class="hljs-string">&quot;test&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)
common_voice[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),N=new j({props:{title:"Preprocess dataset",local:"preprocess-dataset",headingTag:"h2"}}),V=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Qcm9jZXNzb3IlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lX29yX3BhdGgpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwbGFuZ3VhZ2UlM0RsYW5ndWFnZSUyQyUyMHRhc2slM0R0YXNrKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWVfb3JfcGF0aCUyQyUyMGxhbmd1YWdlJTNEbGFuZ3VhZ2UlMkMlMjB0YXNrJTNEdGFzayk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, AutoTokenizer, AutoProcessor

feature_extractor = AutoFeatureExtractor.from_pretrained(model_name_or_path)
tokenizer = AutoTokenizer.from_pretrained(model_name_or_path, language=language, task=task)
processor = AutoProcessor.from_pretrained(model_name_or_path, language=language, task=task)`,wrap:!1}}),$=new T({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLnJlbW92ZV9jb2x1bW5zKCUwQSUyMCUyMCUyMCUyMCU1QiUyMmFjY2VudCUyMiUyQyUyMCUyMmFnZSUyMiUyQyUyMCUyMmNsaWVudF9pZCUyMiUyQyUyMCUyMmRvd25fdm90ZXMlMjIlMkMlMjAlMjJnZW5kZXIlMjIlMkMlMjAlMjJsb2NhbGUlMjIlMkMlMjAlMjJwYXRoJTIyJTJDJTIwJTIyc2VnbWVudCUyMiUyQyUyMCUyMnVwX3ZvdGVzJTIyJTVEJTBBKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCUwQSU3QiUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjdlMWVmNmEyZDE0ZjIwMTk0OTk5YWFkNTA0MGM1ZDRiYjNlYWQxMzc3ZGUzZTFiYmM2ZTlkYmEzNGQxOGE4YSUyRmNvbW1vbl92b2ljZV9tcl8zMDU4NTYxMy5tcDMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhcnJheSUyMiUzQSUyMGFycmF5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjEuMTM2ODY4MzhlLTEzJTJDJTIwLTEuNDIxMDg1NDdlLTEzJTJDJTIwLTEuOTg5NTE5NjZlLTEzJTJDJTIwLi4uJTJDJTIwNC44MzQ3MjQyMmUtMDYlMkMlMjAzLjU0Nzk4NzAzZS0wNiUyQyUyMDEuNjMyMzE3NDNlLTA2JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNhbXBsaW5nX3JhdGUlMjIlM0ElMjA0ODAwMCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnNlbnRlbmNlJTIyJTNBJTIwJTIyJUUwJUE0JTg2JUUwJUE0JTg4JUUwJUE0JTlBJUUwJUE1JTg3JTIwJUUwJUE0JTg2JUUwJUE0JTlDJUUwJUE0JUJFJUUwJUE0JUIwJUUwJUE0JUFBJUUwJUE0JUEzJTIwJUUwJUE0JUI1JUUwJUE0JUJFJUUwJUE0JUEyJUUwJUE0JUE0JTIwJUUwJUE0JTlBJUUwJUE0JUJFJUUwJUE0JUIyJUUwJUE0JUIyJUUwJUE1JTg3JTJDJTIwJUUwJUE0JUE0JUUwJUE0JUI4JUUwJUE0JUE0JUUwJUE0JUI2JUUwJUE1JTgwJTIwJUUwJUE0JUFFJUUwJUE0JUE1JUUwJUE1JTgwJUUwJUE0JUI5JUUwJUE1JTgwJTIwJUUwJUE0JUE4JUUwJUE1JTgwJUUwJUE0JTlGJTIwJUUwJUE0JTk2JUUwJUE0JUJFJUUwJUE0JUE0JUUwJUE0JUFBJUUwJUE1JTgwJUUwJUE0JUE0JUUwJUE0JUE4JUUwJUE0JUJFJUUwJUE0JUI2JUUwJUE1JTgwJTIwJUUwJUE0JTlEJUUwJUE0JUJFJUUwJUE0JUIyJUUwJUE1JTgwLiUyMiUyQyUwQSU3RA==",highlighted:`common_voice = common_voice.remove_columns(
    [<span class="hljs-string">&quot;accent&quot;</span>, <span class="hljs-string">&quot;age&quot;</span>, <span class="hljs-string">&quot;client_id&quot;</span>, <span class="hljs-string">&quot;down_votes&quot;</span>, <span class="hljs-string">&quot;gender&quot;</span>, <span class="hljs-string">&quot;locale&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;segment&quot;</span>, <span class="hljs-string">&quot;up_votes&quot;</span>]
)
common_voice[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{
    <span class="hljs-string">&quot;audio&quot;</span>: {
        <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f7e1ef6a2d14f20194999aad5040c5d4bb3ead1377de3e1bbc6e9dba34d18a8a/common_voice_mr_30585613.mp3&quot;</span>,
        <span class="hljs-string">&quot;array&quot;</span>: array(
            [<span class="hljs-number">1.13686838e-13</span>, -<span class="hljs-number">1.42108547e-13</span>, -<span class="hljs-number">1.98951966e-13</span>, ..., <span class="hljs-number">4.83472422e-06</span>, <span class="hljs-number">3.54798703e-06</span>, <span class="hljs-number">1.63231743e-06</span>]
        ),
        <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">48000</span>,
    },
    <span class="hljs-string">&quot;sentence&quot;</span>: <span class="hljs-string">&quot;आईचे आजारपण वाढत चालले, तसतशी मथीही नीट खातपीतनाशी झाली.&quot;</span>,
}`,wrap:!1}}),A=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFjb21tb25fdm9pY2UlMjAlM0QlMjBjb21tb25fdm9pY2UuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCUwQSU3QiUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjdlMWVmNmEyZDE0ZjIwMTk0OTk5YWFkNTA0MGM1ZDRiYjNlYWQxMzc3ZGUzZTFiYmM2ZTlkYmEzNGQxOGE4YSUyRmNvbW1vbl92b2ljZV9tcl8zMDU4NTYxMy5tcDMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhcnJheSUyMiUzQSUyMGFycmF5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qi0zLjA2OTU0NDYyZS0xMiUyQyUyMC0zLjYzNzk3ODgxZS0xMiUyQyUyMC00LjU0NzQ3MzUxZS0xMiUyQyUyMC4uLiUyQyUyMC03Ljc0ODAwOTAxZS0wNiUyQyUyMC0xLjc0NzM4MTI1ZS0wNiUyQyUyMDQuMzYzMTI0MzllLTA2JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNhbXBsaW5nX3JhdGUlMjIlM0ElMjAxNjAwMCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnNlbnRlbmNlJTIyJTNBJTIwJTIyJUUwJUE0JTg2JUUwJUE0JTg4JUUwJUE0JTlBJUUwJUE1JTg3JTIwJUUwJUE0JTg2JUUwJUE0JTlDJUUwJUE0JUJFJUUwJUE0JUIwJUUwJUE0JUFBJUUwJUE0JUEzJTIwJUUwJUE0JUI1JUUwJUE0JUJFJUUwJUE0JUEyJUUwJUE0JUE0JTIwJUUwJUE0JTlBJUUwJUE0JUJFJUUwJUE0JUIyJUUwJUE0JUIyJUUwJUE1JTg3JTJDJTIwJUUwJUE0JUE0JUUwJUE0JUI4JUUwJUE0JUE0JUUwJUE0JUI2JUUwJUE1JTgwJTIwJUUwJUE0JUFFJUUwJUE0JUE1JUUwJUE1JTgwJUUwJUE0JUI5JUUwJUE1JTgwJTIwJUUwJUE0JUE4JUUwJUE1JTgwJUUwJUE0JTlGJTIwJUUwJUE0JTk2JUUwJUE0JUJFJUUwJUE0JUE0JUUwJUE0JUFBJUUwJUE1JTgwJUUwJUE0JUE0JUUwJUE0JUE4JUUwJUE0JUJFJUUwJUE0JUI2JUUwJUE1JTgwJTIwJUUwJUE0JTlEJUUwJUE0JUJFJUUwJUE0JUIyJUUwJUE1JTgwLiUyMiUyQyUwQSU3RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

common_voice = common_voice.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
common_voice[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{
    <span class="hljs-string">&quot;audio&quot;</span>: {
        <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f7e1ef6a2d14f20194999aad5040c5d4bb3ead1377de3e1bbc6e9dba34d18a8a/common_voice_mr_30585613.mp3&quot;</span>,
        <span class="hljs-string">&quot;array&quot;</span>: array(
            [-<span class="hljs-number">3.06954462e-12</span>, -<span class="hljs-number">3.63797881e-12</span>, -<span class="hljs-number">4.54747351e-12</span>, ..., -<span class="hljs-number">7.74800901e-06</span>, -<span class="hljs-number">1.74738125e-06</span>, <span class="hljs-number">4.36312439e-06</span>]
        ),
        <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-string">&quot;sentence&quot;</span>: <span class="hljs-string">&quot;आईचे आजारपण वाढत चालले, तसतशी मथीही नीट खातपीतनाशी झाली.&quot;</span>,
}`,wrap:!1}}),S=new T({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwYmF0Y2glNUIlMjJhdWRpbyUyMiU1RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIyaW5wdXRfZmVhdHVyZXMlMjIlNUQlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvcihhdWRpbyU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCkuaW5wdXRfZmVhdHVyZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjB0b2tlbml6ZXIoYmF0Y2glNUIlMjJzZW50ZW5jZSUyMiU1RCkuaW5wdXRfaWRzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2g=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">batch</span>):
    audio = batch[<span class="hljs-string">&quot;audio&quot;</span>]
    batch[<span class="hljs-string">&quot;input_features&quot;</span>] = feature_extractor(audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>]).input_features[<span class="hljs-number">0</span>]
    batch[<span class="hljs-string">&quot;labels&quot;</span>] = tokenizer(batch[<span class="hljs-string">&quot;sentence&quot;</span>]).input_ids
    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),x=new T({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLm1hcChwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRGNvbW1vbl92b2ljZS5jb2x1bW5fbmFtZXMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMG51bV9wcm9jJTNEMik=",highlighted:'common_voice = common_voice.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=common_voice.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">2</span>)',wrap:!1}}),D=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwQW55JTJDJTIwRGljdCUyQyUyMExpc3QlMkMlMjBVbmlvbiUwQSUwQSUwQSU0MGRhdGFjbGFzcyUwQWNsYXNzJTIwRGF0YUNvbGxhdG9yU3BlZWNoU2VxMlNlcVdpdGhQYWRkaW5nJTNBJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29yJTNBJTIwQW55JTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGZlYXR1cmVzJTNBJTIwTGlzdCU1QkRpY3QlNUJzdHIlMkMlMjBVbmlvbiU1Qkxpc3QlNUJpbnQlNUQlMkMlMjB0b3JjaC5UZW5zb3IlNUQlNUQlNUQpJTIwLSUzRSUyMERpY3QlNUJzdHIlMkMlMjB0b3JjaC5UZW5zb3IlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9mZWF0dXJlcyUyMCUzRCUyMCU1QiU3QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTNBJTIwZmVhdHVyZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTdEJTIwZm9yJTIwZmVhdHVyZSUyMGluJTIwZmVhdHVyZXMlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMHNlbGYucHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yLnBhZChpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxfZmVhdHVyZXMlMjAlM0QlMjAlNUIlN0IlMjJpbnB1dF9pZHMlMjIlM0ElMjBmZWF0dXJlJTVCJTIybGFiZWxzJTIyJTVEJTdEJTIwZm9yJTIwZmVhdHVyZSUyMGluJTIwZmVhdHVyZXMlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbHNfYmF0Y2glMjAlM0QlMjBzZWxmLnByb2Nlc3Nvci50b2tlbml6ZXIucGFkKGxhYmVsX2ZlYXR1cmVzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjBsYWJlbHNfYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQubWFza2VkX2ZpbGwobGFiZWxzX2JhdGNoLmF0dGVudGlvbl9tYXNrLm5lKDEpJTJDJTIwLTEwMCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMChsYWJlbHMlNUIlM0ElMkMlMjAwJTVEJTIwJTNEJTNEJTIwc2VsZi5wcm9jZXNzb3IudG9rZW5pemVyLmJvc190b2tlbl9pZCkuYWxsKCkuY3B1KCkuaXRlbSgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwbGFiZWxzJTVCJTNBJTJDJTIwMSUzQSU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwbGFiZWxzJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2glMEElMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yU3BlZWNoU2VxMlNlcVdpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorSpeechSeq2SeqWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_features = [{<span class="hljs-string">&quot;input_features&quot;</span>: feature[<span class="hljs-string">&quot;input_features&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        batch = self.processor.feature_extractor.pad(input_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        labels_batch = self.processor.tokenizer.pad(label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>)

        <span class="hljs-keyword">if</span> (labels[:, <span class="hljs-number">0</span>] == self.processor.tokenizer.bos_token_id).<span class="hljs-built_in">all</span>().cpu().item():
            labels = labels[:, <span class="hljs-number">1</span>:]

        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

        <span class="hljs-keyword">return</span> batch


data_collator = DataCollatorSpeechSeq2SeqWithPadding(processor=processor)`,wrap:!1}}),P=new j({props:{title:"Train",local:"train",headingTag:"h2"}}),O=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXElMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWVfb3JfcGF0aCUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSpeechSeq2Seq

model = AutoModelForSpeechSeq2Seq.from_pretrained(model_name_or_path, load_in_8bit=<span class="hljs-literal">True</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),le=new T({props:{code:"bW9kZWwuY29uZmlnLmZvcmNlZF9kZWNvZGVyX2lkcyUyMCUzRCUyME5vbmUlMEFtb2RlbC5jb25maWcuc3VwcHJlc3NfdG9rZW5zJTIwJTNEJTIwJTVCJTVE",highlighted:`model.config.forced_decoder_ids = <span class="hljs-literal">None</span>
model.config.suppress_tokens = []`,wrap:!1}}),se=new T({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9pbnQ4X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9pbnQ4X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_int8_training

model = prepare_model_for_int8_training(model)`,wrap:!1}}),f=new Ct({props:{$$slots:{default:[Bt]},$$scope:{ctx:ve}}}),Je=new T({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwUGVmdE1vZGVsJTJDJTIwTG9yYU1vZGVsJTJDJTIwTG9yYUNvbmZpZyUyQyUyMGdldF9wZWZ0X21vZGVsJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhyJTNEMzIlMkMlMjBsb3JhX2FscGhhJTNENjQlMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnFfcHJvaiUyMiUyQyUyMCUyMnZfcHJvaiUyMiU1RCUyQyUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMjBiaWFzJTNEJTIybm9uZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, PeftModel, LoraModel, LoraConfig, get_peft_model

config = LoraConfig(r=<span class="hljs-number">32</span>, lora_alpha=<span class="hljs-number">64</span>, target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>], lora_dropout=<span class="hljs-number">0.05</span>, bias=<span class="hljs-string">&quot;none&quot;</span>)`,wrap:!1}}),ie=new T({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMTU3Mjg2NDAlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjAxNTU5MDMzNjAwJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS4wMDg4NzExMzY1ODEwMjAzJTIy",highlighted:`model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 15728640 || all params: 1559033600 || trainable%: 1.0088711365810203&quot;</span>`,wrap:!1}}),Ue=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnlvdXItbmFtZSUyRmludDgtd2hpc3Blci1sYXJnZS12Mi1hc3IlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS0zJTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMyUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9tYXhfbGVuZ3RoJTNEMTI4JTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX3VudXNlZF9jb2x1bW5zJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;your-name/int8-whisper-large-v2-asr&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">8</span>,
    gradient_accumulation_steps=<span class="hljs-number">1</span>,
    learning_rate=<span class="hljs-number">1e-3</span>,
    warmup_steps=<span class="hljs-number">50</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    fp16=<span class="hljs-literal">True</span>,
    per_device_eval_batch_size=<span class="hljs-number">8</span>,
    generation_max_length=<span class="hljs-number">128</span>,
    logging_steps=<span class="hljs-number">25</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
)`,wrap:!1}}),Me=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy50cmFpbmVyX3V0aWxzJTIwaW1wb3J0JTIwUFJFRklYX0NIRUNLUE9JTlRfRElSJTBBJTBBJTBBY2xhc3MlMjBTYXZlUGVmdE1vZGVsQ2FsbGJhY2soVHJhaW5lckNhbGxiYWNrKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMG9uX3NhdmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFyZ3MlM0ElMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlJTNBJTIwVHJhaW5lclN0YXRlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udHJvbCUzQSUyMFRyYWluZXJDb250cm9sJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKiprd2FyZ3MlMkMlMEElMjAlMjAlMjAlMjApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2hlY2twb2ludF9mb2xkZXIlMjAlM0QlMjBvcy5wYXRoLmpvaW4oYXJncy5vdXRwdXRfZGlyJTJDJTIwZiUyMiU3QlBSRUZJWF9DSEVDS1BPSU5UX0RJUiU3RC0lN0JzdGF0ZS5nbG9iYWxfc3RlcCU3RCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwZWZ0X21vZGVsX3BhdGglMjAlM0QlMjBvcy5wYXRoLmpvaW4oY2hlY2twb2ludF9mb2xkZXIlMkMlMjAlMjJhZGFwdGVyX21vZGVsJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGt3YXJncyU1QiUyMm1vZGVsJTIyJTVELnNhdmVfcHJldHJhaW5lZChwZWZ0X21vZGVsX3BhdGgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0b3JjaF9tb2RlbF9wYXRoJTIwJTNEJTIwb3MucGF0aC5qb2luKGNoZWNrcG9pbnRfZm9sZGVyJTJDJTIwJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBvcy5wYXRoLmV4aXN0cyhweXRvcmNoX21vZGVsX3BhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3MucmVtb3ZlKHB5dG9yY2hfbW9kZWxfcGF0aCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBjb250cm9s",highlighted:`<span class="hljs-keyword">from</span> transformers.trainer_utils <span class="hljs-keyword">import</span> PREFIX_CHECKPOINT_DIR


<span class="hljs-keyword">class</span> <span class="hljs-title class_">SavePeftModelCallback</span>(<span class="hljs-title class_ inherited__">TrainerCallback</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_save</span>(<span class="hljs-params">
        self,
        args: TrainingArguments,
        state: TrainerState,
        control: TrainerControl,
        **kwargs,
    </span>):
        checkpoint_folder = os.path.join(args.output_dir, <span class="hljs-string">f&quot;<span class="hljs-subst">{PREFIX_CHECKPOINT_DIR}</span>-<span class="hljs-subst">{state.global_step}</span>&quot;</span>)

        peft_model_path = os.path.join(checkpoint_folder, <span class="hljs-string">&quot;adapter_model&quot;</span>)
        kwargs[<span class="hljs-string">&quot;model&quot;</span>].save_pretrained(peft_model_path)

        pytorch_model_path = os.path.join(checkpoint_folder, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
        <span class="hljs-keyword">if</span> os.path.exists(pytorch_model_path):
            os.remove(pytorch_model_path)
        <span class="hljs-keyword">return</span> control`,wrap:!1}}),ye=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTJDJTIwVHJhaW5lckNhbGxiYWNrJTJDJTIwU2VxMlNlcVRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lclN0YXRlJTJDJTIwVHJhaW5lckNvbnRyb2wlMEElMEF0cmFpbmVyJTIwJTNEJTIwU2VxMlNlcVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGNvbW1vbl92b2ljZSU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEY29tbW9uX3ZvaWNlJTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yJTJDJTBBJTIwJTIwJTIwJTIwY2FsbGJhY2tzJTNEJTVCU2F2ZVBlZnRNb2RlbENhbGxiYWNrJTVEJTJDJTBBKSUwQW1vZGVsLmNvbmZpZy51c2VfY2FjaGUlMjAlM0QlMjBGYWxzZSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer, TrainerCallback, Seq2SeqTrainingArguments, TrainerState, TrainerControl

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=common_voice[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=common_voice[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor.feature_extractor,
    callbacks=[SavePeftModelCallback],
)
model.config.use_cache = <span class="hljs-literal">False</span>
trainer.train()`,wrap:!1}}),Te=new j({props:{title:"Evaluate",local:"evaluate",headingTag:"h2"}}),me=new T({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`,wrap:!1}}),he=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gc

eval_dataloader = DataLoader(common_voice[<span class="hljs-string">&quot;test&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator)

model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
    <span class="hljs-keyword">with</span> torch.cuda.amp.autocast():
        <span class="hljs-keyword">with</span> torch.no_grad():
            generated_tokens = (
                model.generate(
                    input_features=batch[<span class="hljs-string">&quot;input_features&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>),
                    decoder_input_ids=batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :<span class="hljs-number">4</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>),
                    max_new_tokens=<span class="hljs-number">255</span>,
                )
                .cpu()
                .numpy()
            )
            labels = batch[<span class="hljs-string">&quot;labels&quot;</span>].cpu().numpy()
            labels = np.where(labels != -<span class="hljs-number">100</span>, labels, tokenizer.pad_token_id)
            decoded_preds = tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
            decoded_labels = tokenizer.batch_decode(labels, skip_special_tokens=<span class="hljs-literal">True</span>)
            metric.add_batch(
                predictions=decoded_preds,
                references=decoded_labels,
            )
    <span class="hljs-keyword">del</span> generated_tokens, labels, batch
    gc.collect()
wer = <span class="hljs-number">100</span> * metric.compute()
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{wer=}</span>&quot;</span>)`,wrap:!1}}),fe=new j({props:{title:"Share model",local:"share-model",headingTag:"h2"}}),be=new T({props:{code:"bW9kZWwucHVzaF90b19odWIoJTIyeW91ci1uYW1lJTJGaW50OC13aGlzcGVyLWxhcmdlLXYyLWFzciUyMik=",highlighted:'model.push_to_hub(<span class="hljs-string">&quot;your-name/int8-whisper-large-v2-asr&quot;</span>)',wrap:!1}}),Ie=new j({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Ce=new T({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMnNtYW5ncnVsJTJGb3BlbmFpLXdoaXNwZXItbGFyZ2UtdjItTE9SQS1jb2xhYiUyMiUwQWxhbmd1YWdlJTIwJTNEJTIwJTIyTWFyYXRoaSUyMiUwQXRhc2slMjAlM0QlMjAlMjJ0cmFuc2NyaWJlJTIyJTBBcGVmdF9jb25maWclMjAlM0QlMjBQZWZ0Q29uZmlnLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWcuYmFzZV9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCklMEF0b2tlbml6ZXIlMjAlM0QlMjBXaGlzcGVyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChwZWZ0X2NvbmZpZy5iYXNlX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMGxhbmd1YWdlJTNEbGFuZ3VhZ2UlMkMlMjB0YXNrJTNEdGFzayklMEFwcm9jZXNzb3IlMjAlM0QlMjBXaGlzcGVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChwZWZ0X2NvbmZpZy5iYXNlX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMGxhbmd1YWdlJTNEbGFuZ3VhZ2UlMkMlMjB0YXNrJTNEdGFzayklMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciUwQWZvcmNlZF9kZWNvZGVyX2lkcyUyMCUzRCUyMHByb2Nlc3Nvci5nZXRfZGVjb2Rlcl9wcm9tcHRfaWRzKGxhbmd1YWdlJTNEbGFuZ3VhZ2UlMkMlMjB0YXNrJTNEdGFzayk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

peft_model_id = <span class="hljs-string">&quot;smangrul/openai-whisper-large-v2-LORA-colab&quot;</span>
language = <span class="hljs-string">&quot;Marathi&quot;</span>
task = <span class="hljs-string">&quot;transcribe&quot;</span>
peft_config = PeftConfig.from_pretrained(peft_model_id)
model = WhisperForConditionalGeneration.from_pretrained(
    peft_config.base_model_name_or_path, load_in_8bit=<span class="hljs-literal">True</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)
model = PeftModel.from_pretrained(model, peft_model_id)
tokenizer = WhisperTokenizer.from_pretrained(peft_config.base_model_name_or_path, language=language, task=task)
processor = WhisperProcessor.from_pretrained(peft_config.base_model_name_or_path, language=language, task=task)
feature_extractor = processor.feature_extractor
forced_decoder_ids = processor.get_decoder_prompt_ids(language=language, task=task)`,wrap:!1}}),Ee=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9tYXRpY1NwZWVjaFJlY29nbml0aW9uUGlwZWxpbmUlMEElMEFhdWRpbyUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnN0ZXZobGl1JTJGZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1ydF8wMTUyM18wMDAyODU0ODIwMy53YXYlMjIlMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9tYXRpY1NwZWVjaFJlY29nbml0aW9uUGlwZWxpbmUobW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutomaticSpeechRecognitionPipeline

audio = <span class="hljs-string">&quot;https://huggingface.co/datasets/stevhliu/dummy/resolve/main/mrt_01523_00028548203.wav&quot;</span>
pipeline = AutomaticSpeechRecognitionPipeline(model=model, tokenizer=tokenizer, feature_extractor=feature_extractor)`,wrap:!1}}),ke=new T({props:{code:"d2l0aCUyMHRvcmNoLmN1ZGEuYW1wLmF1dG9jYXN0KCklM0ElMEElMjAlMjAlMjAlMjB0ZXh0JTIwJTNEJTIwcGlwZShhdWRpbyUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMmZvcmNlZF9kZWNvZGVyX2lkcyUyMiUzQSUyMGZvcmNlZF9kZWNvZGVyX2lkcyU3RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU1KSU1QiUyMnRleHQlMjIlNUQlMEF0ZXh0JTBBJTIyJUUwJUE0JUFFJUUwJUE1JTgwJTIwJUUwJUE0JUE0JUUwJUE1JTgxJUUwJUE0JUFFJUUwJUE0JTlBJUUwJUE1JThEJUUwJUE0JUFGJUUwJUE0JUJFJUUwJUE0JUI4JUUwJUE0JUJFJUUwJUE0JUEwJUUwJUE1JTgwJTIwJUUwJUE0JTk1JUUwJUE0JUJFJUUwJUE0JUI5JUUwJUE1JTgwJTIwJUUwJUE0JTk1JUUwJUE0JUIwJUUwJUE1JTgyJTIwJUUwJUE0JUI2JUUwJUE0JTk1JUUwJUE0JUE0JUUwJUE1JThCJTIwJUUwJUE0JTk1JUUwJUE0JUJFJTNGJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.cuda.amp.autocast():
    text = pipe(audio, generate_kwargs={<span class="hljs-string">&quot;forced_decoder_ids&quot;</span>: forced_decoder_ids}, max_new_tokens=<span class="hljs-number">255</span>)[<span class="hljs-string">&quot;text&quot;</span>]
text
<span class="hljs-string">&quot;मी तुमच्यासाठी काही करू शकतो का?&quot;</span>`,wrap:!1}}),{c(){y=o("meta"),m=s(),d=o("p"),u=s(),r(b.$$.fragment),Xe=s(),I=o("p"),I.innerHTML=Sl,Fe=s(),r(h.$$.fragment),Be=s(),g=o("p"),g.innerHTML=Hl,Ne=s(),Z=o("p"),Z.textContent=xl,Re=s(),r(C.$$.fragment),Ve=s(),r(_.$$.fragment),Ye=s(),E=o("p"),E.innerHTML=Ll,$e=s(),r(G.$$.fragment),Qe=s(),k=o("p"),k.textContent=Dl,Ae=s(),r(v.$$.fragment),qe=s(),r(W.$$.fragment),ze=s(),X=o("p"),X.innerHTML=Pl,Se=s(),F=o("p"),F.innerHTML=Kl,He=s(),r(B.$$.fragment),xe=s(),r(N.$$.fragment),Le=s(),R=o("p"),R.textContent=Ol,De=s(),r(V.$$.fragment),Pe=s(),Y=o("p"),Y.innerHTML=et,Ke=s(),r($.$$.fragment),Oe=s(),Q=o("p"),Q.innerHTML=lt,el=s(),r(A.$$.fragment),ll=s(),q=o("p"),q.textContent=tt,tl=s(),z=o("ol"),z.innerHTML=at,al=s(),r(S.$$.fragment),sl=s(),H=o("p"),H.innerHTML=st,nl=s(),r(x.$$.fragment),ol=s(),L=o("p"),L.innerHTML=nt,Jl=s(),r(D.$$.fragment),rl=s(),r(P.$$.fragment),il=s(),K=o("p"),K.innerHTML=ot,pl=s(),r(O.$$.fragment),Ul=s(),ee=o("p"),ee.innerHTML=Jt,cl=s(),r(le.$$.fragment),Ml=s(),te=o("p"),te.innerHTML=rt,wl=s(),ae=o("ul"),ae.innerHTML=it,yl=s(),r(se.$$.fragment),Tl=s(),ne=o("p"),ne.innerHTML=pt,dl=s(),oe=o("ul"),oe.innerHTML=Ut,ml=s(),r(f.$$.fragment),ul=s(),r(Je.$$.fragment),hl=s(),re=o("p"),re.innerHTML=ct,fl=s(),r(ie.$$.fragment),jl=s(),pe=o("p"),pe.innerHTML=Mt,bl=s(),r(Ue.$$.fragment),Il=s(),ce=o("p"),ce.innerHTML=wt,gl=s(),r(Me.$$.fragment),Zl=s(),we=o("p"),we.innerHTML=yt,Cl=s(),r(ye.$$.fragment),_l=s(),r(Te.$$.fragment),El=s(),de=o("p"),de.innerHTML=Tt,Gl=s(),r(me.$$.fragment),kl=s(),ue=o("p"),ue.innerHTML=dt,vl=s(),r(he.$$.fragment),Wl=s(),r(fe.$$.fragment),Xl=s(),je=o("p"),je.innerHTML=mt,Fl=s(),r(be.$$.fragment),Bl=s(),r(Ie.$$.fragment),Nl=s(),ge=o("p"),ge.textContent=ut,Rl=s(),Ze=o("p"),Ze.innerHTML=ht,Vl=s(),r(Ce.$$.fragment),Yl=s(),_e=o("p"),_e.innerHTML=ft,$l=s(),r(Ee.$$.fragment),Ql=s(),Ge=o("p"),Ge.textContent=jt,Al=s(),r(ke.$$.fragment),ql=s(),We=o("p"),this.h()},l(e){const l=Wt("svelte-u9bgzb",document.head);y=J(l,"META",{name:!0,content:!0}),l.forEach(t),m=n(e),d=J(e,"P",{}),gt(d).forEach(t),u=n(e),i(b.$$.fragment,e),Xe=n(e),I=J(e,"P",{"data-svelte-h":!0}),w(I)!=="svelte-a7qabg"&&(I.innerHTML=Sl),Fe=n(e),i(h.$$.fragment,e),Be=n(e),g=J(e,"P",{"data-svelte-h":!0}),w(g)!=="svelte-14ydkbq"&&(g.innerHTML=Hl),Ne=n(e),Z=J(e,"P",{"data-svelte-h":!0}),w(Z)!=="svelte-1989ute"&&(Z.textContent=xl),Re=n(e),i(C.$$.fragment,e),Ve=n(e),i(_.$$.fragment,e),Ye=n(e),E=J(e,"P",{"data-svelte-h":!0}),w(E)!=="svelte-x5ywax"&&(E.innerHTML=Ll),$e=n(e),i(G.$$.fragment,e),Qe=n(e),k=J(e,"P",{"data-svelte-h":!0}),w(k)!=="svelte-19vl57o"&&(k.textContent=Dl),Ae=n(e),i(v.$$.fragment,e),qe=n(e),i(W.$$.fragment,e),ze=n(e),X=J(e,"P",{"data-svelte-h":!0}),w(X)!=="svelte-19qf1b0"&&(X.innerHTML=Pl),Se=n(e),F=J(e,"P",{"data-svelte-h":!0}),w(F)!=="svelte-60ttqc"&&(F.innerHTML=Kl),He=n(e),i(B.$$.fragment,e),xe=n(e),i(N.$$.fragment,e),Le=n(e),R=J(e,"P",{"data-svelte-h":!0}),w(R)!=="svelte-pakqel"&&(R.textContent=Ol),De=n(e),i(V.$$.fragment,e),Pe=n(e),Y=J(e,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-1dqokry"&&(Y.innerHTML=et),Ke=n(e),i($.$$.fragment,e),Oe=n(e),Q=J(e,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-v4huwn"&&(Q.innerHTML=lt),el=n(e),i(A.$$.fragment,e),ll=n(e),q=J(e,"P",{"data-svelte-h":!0}),w(q)!=="svelte-1g9oe3a"&&(q.textContent=tt),tl=n(e),z=J(e,"OL",{"data-svelte-h":!0}),w(z)!=="svelte-1dwhqxo"&&(z.innerHTML=at),al=n(e),i(S.$$.fragment,e),sl=n(e),H=J(e,"P",{"data-svelte-h":!0}),w(H)!=="svelte-k03hh6"&&(H.innerHTML=st),nl=n(e),i(x.$$.fragment,e),ol=n(e),L=J(e,"P",{"data-svelte-h":!0}),w(L)!=="svelte-vw2h1e"&&(L.innerHTML=nt),Jl=n(e),i(D.$$.fragment,e),rl=n(e),i(P.$$.fragment,e),il=n(e),K=J(e,"P",{"data-svelte-h":!0}),w(K)!=="svelte-1dwsa83"&&(K.innerHTML=ot),pl=n(e),i(O.$$.fragment,e),Ul=n(e),ee=J(e,"P",{"data-svelte-h":!0}),w(ee)!=="svelte-1iidk8s"&&(ee.innerHTML=Jt),cl=n(e),i(le.$$.fragment,e),Ml=n(e),te=J(e,"P",{"data-svelte-h":!0}),w(te)!=="svelte-1asc9q4"&&(te.innerHTML=rt),wl=n(e),ae=J(e,"UL",{"data-svelte-h":!0}),w(ae)!=="svelte-fpn3h1"&&(ae.innerHTML=it),yl=n(e),i(se.$$.fragment,e),Tl=n(e),ne=J(e,"P",{"data-svelte-h":!0}),w(ne)!=="svelte-1gctrjp"&&(ne.innerHTML=pt),dl=n(e),oe=J(e,"UL",{"data-svelte-h":!0}),w(oe)!=="svelte-1j971f8"&&(oe.innerHTML=Ut),ml=n(e),i(f.$$.fragment,e),ul=n(e),i(Je.$$.fragment,e),hl=n(e),re=J(e,"P",{"data-svelte-h":!0}),w(re)!=="svelte-10ir9qp"&&(re.innerHTML=ct),fl=n(e),i(ie.$$.fragment,e),jl=n(e),pe=J(e,"P",{"data-svelte-h":!0}),w(pe)!=="svelte-1esfe1f"&&(pe.innerHTML=Mt),bl=n(e),i(Ue.$$.fragment,e),Il=n(e),ce=J(e,"P",{"data-svelte-h":!0}),w(ce)!=="svelte-syqfq8"&&(ce.innerHTML=wt),gl=n(e),i(Me.$$.fragment,e),Zl=n(e),we=J(e,"P",{"data-svelte-h":!0}),w(we)!=="svelte-3tm5hr"&&(we.innerHTML=yt),Cl=n(e),i(ye.$$.fragment,e),_l=n(e),i(Te.$$.fragment,e),El=n(e),de=J(e,"P",{"data-svelte-h":!0}),w(de)!=="svelte-9hq5n5"&&(de.innerHTML=Tt),Gl=n(e),i(me.$$.fragment,e),kl=n(e),ue=J(e,"P",{"data-svelte-h":!0}),w(ue)!=="svelte-yqzxz6"&&(ue.innerHTML=dt),vl=n(e),i(he.$$.fragment,e),Wl=n(e),i(fe.$$.fragment,e),Xl=n(e),je=J(e,"P",{"data-svelte-h":!0}),w(je)!=="svelte-108yfy9"&&(je.innerHTML=mt),Fl=n(e),i(be.$$.fragment,e),Bl=n(e),i(Ie.$$.fragment,e),Nl=n(e),ge=J(e,"P",{"data-svelte-h":!0}),w(ge)!=="svelte-1ak2210"&&(ge.textContent=ut),Rl=n(e),Ze=J(e,"P",{"data-svelte-h":!0}),w(Ze)!=="svelte-1h52jwb"&&(Ze.innerHTML=ht),Vl=n(e),i(Ce.$$.fragment,e),Yl=n(e),_e=J(e,"P",{"data-svelte-h":!0}),w(_e)!=="svelte-13oqvq0"&&(_e.innerHTML=ft),$l=n(e),i(Ee.$$.fragment,e),Ql=n(e),Ge=J(e,"P",{"data-svelte-h":!0}),w(Ge)!=="svelte-1y0o8mq"&&(Ge.textContent=jt),Al=n(e),i(ke.$$.fragment,e),ql=n(e),We=J(e,"P",{}),gt(We).forEach(t),this.h()},h(){Zt(y,"name","hf:doc:metadata"),Zt(y,"content",Rt)},m(e,l){Xt(document.head,y),a(e,m,l),a(e,d,l),a(e,u,l),p(b,e,l),a(e,Xe,l),a(e,I,l),a(e,Fe,l),p(h,e,l),a(e,Be,l),a(e,g,l),a(e,Ne,l),a(e,Z,l),a(e,Re,l),p(C,e,l),a(e,Ve,l),p(_,e,l),a(e,Ye,l),a(e,E,l),a(e,$e,l),p(G,e,l),a(e,Qe,l),a(e,k,l),a(e,Ae,l),p(v,e,l),a(e,qe,l),p(W,e,l),a(e,ze,l),a(e,X,l),a(e,Se,l),a(e,F,l),a(e,He,l),p(B,e,l),a(e,xe,l),p(N,e,l),a(e,Le,l),a(e,R,l),a(e,De,l),p(V,e,l),a(e,Pe,l),a(e,Y,l),a(e,Ke,l),p($,e,l),a(e,Oe,l),a(e,Q,l),a(e,el,l),p(A,e,l),a(e,ll,l),a(e,q,l),a(e,tl,l),a(e,z,l),a(e,al,l),p(S,e,l),a(e,sl,l),a(e,H,l),a(e,nl,l),p(x,e,l),a(e,ol,l),a(e,L,l),a(e,Jl,l),p(D,e,l),a(e,rl,l),p(P,e,l),a(e,il,l),a(e,K,l),a(e,pl,l),p(O,e,l),a(e,Ul,l),a(e,ee,l),a(e,cl,l),p(le,e,l),a(e,Ml,l),a(e,te,l),a(e,wl,l),a(e,ae,l),a(e,yl,l),p(se,e,l),a(e,Tl,l),a(e,ne,l),a(e,dl,l),a(e,oe,l),a(e,ml,l),p(f,e,l),a(e,ul,l),p(Je,e,l),a(e,hl,l),a(e,re,l),a(e,fl,l),p(ie,e,l),a(e,jl,l),a(e,pe,l),a(e,bl,l),p(Ue,e,l),a(e,Il,l),a(e,ce,l),a(e,gl,l),p(Me,e,l),a(e,Zl,l),a(e,we,l),a(e,Cl,l),p(ye,e,l),a(e,_l,l),p(Te,e,l),a(e,El,l),a(e,de,l),a(e,Gl,l),p(me,e,l),a(e,kl,l),a(e,ue,l),a(e,vl,l),p(he,e,l),a(e,Wl,l),p(fe,e,l),a(e,Xl,l),a(e,je,l),a(e,Fl,l),p(be,e,l),a(e,Bl,l),p(Ie,e,l),a(e,Nl,l),a(e,ge,l),a(e,Rl,l),a(e,Ze,l),a(e,Vl,l),p(Ce,e,l),a(e,Yl,l),a(e,_e,l),a(e,$l,l),p(Ee,e,l),a(e,Ql,l),a(e,Ge,l),a(e,Al,l),p(ke,e,l),a(e,ql,l),a(e,We,l),zl=!0},p(e,[l]){const bt={};l&2&&(bt.$$scope={dirty:l,ctx:e}),h.$set(bt);const It={};l&2&&(It.$$scope={dirty:l,ctx:e}),f.$set(It)},i(e){zl||(U(b.$$.fragment,e),U(h.$$.fragment,e),U(C.$$.fragment,e),U(_.$$.fragment,e),U(G.$$.fragment,e),U(v.$$.fragment,e),U(W.$$.fragment,e),U(B.$$.fragment,e),U(N.$$.fragment,e),U(V.$$.fragment,e),U($.$$.fragment,e),U(A.$$.fragment,e),U(S.$$.fragment,e),U(x.$$.fragment,e),U(D.$$.fragment,e),U(P.$$.fragment,e),U(O.$$.fragment,e),U(le.$$.fragment,e),U(se.$$.fragment,e),U(f.$$.fragment,e),U(Je.$$.fragment,e),U(ie.$$.fragment,e),U(Ue.$$.fragment,e),U(Me.$$.fragment,e),U(ye.$$.fragment,e),U(Te.$$.fragment,e),U(me.$$.fragment,e),U(he.$$.fragment,e),U(fe.$$.fragment,e),U(be.$$.fragment,e),U(Ie.$$.fragment,e),U(Ce.$$.fragment,e),U(Ee.$$.fragment,e),U(ke.$$.fragment,e),zl=!0)},o(e){c(b.$$.fragment,e),c(h.$$.fragment,e),c(C.$$.fragment,e),c(_.$$.fragment,e),c(G.$$.fragment,e),c(v.$$.fragment,e),c(W.$$.fragment,e),c(B.$$.fragment,e),c(N.$$.fragment,e),c(V.$$.fragment,e),c($.$$.fragment,e),c(A.$$.fragment,e),c(S.$$.fragment,e),c(x.$$.fragment,e),c(D.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(f.$$.fragment,e),c(Je.$$.fragment,e),c(ie.$$.fragment,e),c(Ue.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(Te.$$.fragment,e),c(me.$$.fragment,e),c(he.$$.fragment,e),c(fe.$$.fragment,e),c(be.$$.fragment,e),c(Ie.$$.fragment,e),c(Ce.$$.fragment,e),c(Ee.$$.fragment,e),c(ke.$$.fragment,e),zl=!1},d(e){e&&(t(m),t(d),t(u),t(Xe),t(I),t(Fe),t(Be),t(g),t(Ne),t(Z),t(Re),t(Ve),t(Ye),t(E),t($e),t(Qe),t(k),t(Ae),t(qe),t(ze),t(X),t(Se),t(F),t(He),t(xe),t(Le),t(R),t(De),t(Pe),t(Y),t(Ke),t(Oe),t(Q),t(el),t(ll),t(q),t(tl),t(z),t(al),t(sl),t(H),t(nl),t(ol),t(L),t(Jl),t(rl),t(il),t(K),t(pl),t(Ul),t(ee),t(cl),t(Ml),t(te),t(wl),t(ae),t(yl),t(Tl),t(ne),t(dl),t(oe),t(ml),t(ul),t(hl),t(re),t(fl),t(jl),t(pe),t(bl),t(Il),t(ce),t(gl),t(Zl),t(we),t(Cl),t(_l),t(El),t(de),t(Gl),t(kl),t(ue),t(vl),t(Wl),t(Xl),t(je),t(Fl),t(Bl),t(Nl),t(ge),t(Rl),t(Ze),t(Vl),t(Yl),t(_e),t($l),t(Ql),t(Ge),t(Al),t(ql),t(We)),t(y),M(b,e),M(h,e),M(C,e),M(_,e),M(G,e),M(v,e),M(W,e),M(B,e),M(N,e),M(V,e),M($,e),M(A,e),M(S,e),M(x,e),M(D,e),M(P,e),M(O,e),M(le,e),M(se,e),M(f,e),M(Je,e),M(ie,e),M(Ue,e),M(Me,e),M(ye,e),M(Te,e),M(me,e),M(he,e),M(fe,e),M(be,e),M(Ie,e),M(Ce,e),M(Ee,e),M(ke,e)}}}const Rt='{"title":"int8 training for automatic speech recognition","local":"int8-training-for-automatic-speech-recognition","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Load dataset and metric","local":"load-dataset-and-metric","sections":[],"depth":2},{"title":"Preprocess dataset","local":"preprocess-dataset","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Evaluate","local":"evaluate","sections":[],"depth":2},{"title":"Share model","local":"share-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Vt(ve){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends kt{constructor(y){super(),vt(this,y,Vt,Nt,Et,{})}}export{zt as component};
