import{s as rl,n as cl,o as hl}from"../chunks/scheduler.b9285784.js";import{S as dl,i as pl,e as s,s as i,c,h as ml,a as o,d as l,b as n,f as Ct,g as h,j as r,k as f,l as vt,m as a,n as d,t as p,o as m,p as u}from"../chunks/index.26bc89a1.js";import{C as ul,H as y,E as fl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.69b6a109.js";import{C as Me}from"../chunks/CodeBlock.969d3a54.js";function yl(jt){let g,xe,be,$e,k,_e,J,Ue,G,kt="This guide will cover basics of using context parallelism in 🤗<code>accelerate</code>, for the more curious readers, we will also cover some technicalities in the later sections.",Ce,H,ve,I,Jt=`With the advent of large language models, and recently reasoning models, the sequence length has been growing rapidly. This, combined with quadratic memory complexity of attention, has led to a need for more efficient ways to train models with long sequences.
With sequence length of 128k, the memory requirement of the attention matrix is <code>128k * 128k * 2 bytes * num_heads = ~32 GB * num_heads</code> for <code>bf16</code> precision, given vanilla attention implementation. Granted, with usage of <code>flash attention</code> or <code>SDPA</code> which do not materialize these attention weights, this decreases drastically, but the growth in memory requirements is still considerable.`,je,L,Gt="Context parallelism allows us to shard the inputs to the attention computation along the sequence dimension and compute the attention in parallel on multiple GPUs. With this, we can train models with long sequences, scaling potentially to 1M+ sequence length.",ke,q,Je,W,Ge,B,Ht=`As with any other feature in 🤗<code>accelerate</code>, you can enable context parallelism also by passing the corresponding flags to <code>accelerate launch</code>.
In this case, it’s no different:`,He,V,Ie,M,It="<p>You can also set the <code>cp_size</code> and <code>cp_comm_strategy</code> in the <code>accelerate config</code> command, which will save them in your <code>accelerate</code> configuration file, so you don’t have to pass them every time you launch your script.</p>",Le,b,Lt=`<p>Context parallelism is compatible with other parallelism strategies, such as data parallelism, tensor parallelism and FSDP2.
You can simply combine them by setting your parallelism sizes to the desired values, e.g. <code>--parallelism-config-dp-size 8 --parallelism-config-tp-size 2 --parallelism-config-cp-size 8</code>. Or you can use the <code>ParallelismConfig</code> class to set them programmatically.</p>`,qe,T,qt=`<p>Context parallelism is tightly coupled  with <code>FSDP2</code>, which you can learn more about in the <a href="fsdp1_vs_fsdp2.md">FSDP2 introduction</a>. Meaning, context parallelism only works if you use <code>FullyShardedDataParallelPlugin</code> or <code>--use-fsdp</code> with version set to 2 to your
program. If no <code>FSDP2</code> is used, error will be raised.</p>`,We,x,Wt='<p>Context parallelism works only with <a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">SDPA</a> and only with no mask or causal mask. We can’t properly detect this for you, so it’s your responsibility to ensure that you are using <code>SDPA</code> with no mask or causal mask. If you use any other attention implementation, it will raise an error.</p>',Be,z,Bt=`After enabling context parallelism with the methods mentioned above, you can then apply it to your training loop. We provide a thin wrapper around <a href="https://docs.pytorch.org/docs/stable/distributed.tensor.html#torch.distributed.tensor.experimental.context_parallel" rel="nofollow"><code>torch.distributed.tensor.experimental.context_parallel</code></a> that you can use in your training loop, that abstracts some of the complexity of using it (more on this later). To minimize the changes you have to do in your training loop, we provide a context manager that is a <code>noop</code> if context parallelism is not enabled, and applies the context parallelism if it is enabled. This way, you can use it in your training loop without changing any code based on your parallelism configuration.
You can use it as follows:`,Ve,F,ze,$,Vt="<p>This context manager has to be recreated with each training step, as shown in the example above. It’s crucial to do so.</p>",Fe,P,zt="This can scale your context size to 1M+ sequence length potentially. Below, we showcase speed and memory usage of context parallelism for up-to 256k context size. We can see that when we double the context size and number of GPUs, we can achieve consistent memory usage, potentially enabling endless context length scaling.",Pe,_,Ft='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/accelerate/examples/fsdp2/cp_perf.png" alt="context parallelism memory usage"/> <br/> <em>Figure 1: Memory usage and speed of context parallelism for up-to 256k context size.</em>',Qe,w,we,Pt='These examples were created with a script you can find <a href="https://github.com/huggingface/accelerate/blob/main/examples/fsdp2/nd_parallel.py" rel="nofollow">in the examples folder</a>. To run the example on 8 H100 GPUs (128k sequence length), you can use the following command:',Ut,Q,Ye,Y,Ae,A,Qt="The context manager takes a few arguments, that are used to configure the context parallelism.",Se,S,Yt=`<li><code>buffers</code>: This is a list of tensors that are to be sharded across the sequence dimension. These tensors are usually input ids, labels and attention mask.</li> <li><code>buffer_seq_dims</code>: This is a list of integers, that specify the sequence dimension of the buffers, in the order of the <code>buffers</code> list. If you pass <code>buffers=[input_ids, shift_labels]</code> with both having shape <code>[batch_size, sequence_length]</code>, you would pass <code>buffer_seq_dims=[1, 1]</code>.
as the sequence dimension is the second dimension of the tensors. This is required for correct computation of the model outputs.</li> <li><code>no_restore_buffers</code>: The implementation of context parallelism modifies the buffers in-place, converting them to <code>torch.distributed.tensor.Dtensor</code>s. After the context manager exits, a communication kernel would need to be launched to restore the buffers to their original state (usually all-gather). This takes some time, so it is recommended to pass the same tensors as in the <code>buffers</code> argument, to avoid unnecessary communication, unless you are sure that you need to use the buffers after the context manager exits.</li>`,Ze,U,At=`<p>Context parallelism is not compatible with <code>labels</code> that are a copy of <code>input_ids</code>, which models from 🤗 transformers can shift to enable causal language modeling themselves.
Imagine this case:
labels = [l1, l2, l3, l4, … li]
if we apply context parallelism, each rank would end up with a part of labels, such as this:
labels_rank_0 = [l1, l2], labels_rank_1 = [l3, l4], …
after transformers modelling code shifts the labels, it would end up with:
labels_rank_0 = [l2, PAD], labels_rank_1 = [l3, PAD], …
where <code>PAD</code> is a padding token. This would result in incorrect loss computation, as the labels are not aligned with the inputs anymore.
Because of this, you need to manually shift the labels before passing them in the model</p>`,Ee,Z,Ne,E,St="Accelerate provides only a single option to configure context parallelism (except for <code>cp_size</code>)",Xe,N,Zt="<li><code>cp_comm_strategy</code>: The rotation method to use for the shards. We strongly recommend keeping this as <code>&quot;allgather&quot;</code>, as it’s very likely it will outperform <code>&quot;alltoall&quot;</code> in most cases.</li>",Re,X,Et=`Context parallel size is rather self-explanatory, it’s the number of ranks across which the inputs are to be-sharded.
Context parallel shard rotation defines how the shards of the inputs are rotated across ranks. We’ll cover the 2 options in more detail in the next section.`,De,R,Nt='You can see an end-to-end example in the <a href="https://github.com/huggingface/accelerate/blob/main/examples/fsdp2/nd_parallel.py" rel="nofollow">ND parallel example</a> file, where you can train an 8B model with up-to 128k context length on a single 8xH100 node. Using multi-node training, you can scale this to 1M+ sequence length on multiple GPUs. You can also seamlessly combine it with other parallelism strategies to fit your needs.',Ke,D,Oe,C,Xt="<p>This section is fairly technical, so if you don’t need to learn the internals of context parallelism, you can skip it and start building 🚀</p>",et,K,Rt="We’re going to be using word <code>shard</code> extensively in the following sections, so let’s define it first. If we call tensor <code>sharded</code> across <code>Dth</code> dimension, across <code>N</code> ranks, we mean that this tensor is split into <code>N</code> parts, where each part of the tensor has shape <code>[..., D//N, ...]</code>.",tt,O,lt,ee,Dt=`Context parallelism works on sharding the <code>Q, K and V</code> matrices across the sequence dimension. Each rank has its assigned shard of <code>Q</code>, let’s call it <code>Q_i</code>. This matrix stays only on this rank, during the whole computation. Similarly, each rank has its own shard of <code>K</code> and <code>V</code>, let’s call them <code>K_i</code> and <code>V_i</code>. Then, each rank calculates attention with its own shard of <code>Q_i</code>, <code>K_i</code> and <code>V_i</code>, let’s call it <code>attn_i</code>. During this computation, a communication kernel is launched to gather the <code>Ks</code> and <code>Vs</code> from all other ranks. What communication primitive is used, depends on the <code>context_parallel_shard_rotation</code> option.
This way, each rank gets to calculate local attention, first with <code>Q_i</code>, <code>K_i</code> and <code>V_i</code>, then with <code>K_j</code> and <code>V_j</code> from all other ranks. As each rank holds <code>Q, K and V</code> matrices that are sharded across the sequence dimension, the resulting matrices are smaller and can fit on a single GPU.`,at,te,Kt="We can formalize this in the following pseudocode:",it,le,nt,ae,st,ie,ot,ne,Ot=`So what’s the difference between all-to-all and all-gather? With all-gather, the communication is very simple. After (well, before, as it usually takes longer) we compute the local attention <code>attn_i</code> we launch an all-gather to gather all other <code>Ks</code> and <code>Vs</code> from all other ranks. As this communication is done, each rank has all the <code>Ks</code> and <code>Vs</code> from all other ranks, and can compute the attention with them sequentially.
In ideal scenario, all-gather finishes in the exact moment as the calculation of <code>attn_i</code> is done. However, this never happens in practice, so the ideal real overlap is achieved when the full <code>attn_i</code> is overlapped with a part of the communication, then to start the computation with <code>K_j</code> and <code>V_j</code>, we wait for the all-gather to finish.`,rt,se,ct,oe,el="All-to-all, or sometimes called <code>ring-rotation</code> utilizes a ring-like communication pattern. After concluding <code>attn_i</code> computation, an all-to-all is launched to send <code>K_i</code> and <code>V_i</code> to the neighbouring ranks. We then repeat this <code>context_parallel_size-1</code> times, so that each rank sees all the shards of <code>K</code> and <code>V</code> from all other ranks once. In ideal scenario, we prefetch shards <code>K_i+1</code> and <code>V_i+1</code> from the neighbouring rank and this communication is exactly overlapped with computation of our current <code>attn_i</code>. Again, realistically, this perfect overlap doesn’t ever happen. Given the nature of this approach, if we don’t achieve perfect overlap, the penalty is way larger than with all-gather.",ht,re,dt,ce,tl='In theory, all-to-all should be the better choice. Though in practice, it rarely is. Therefore, we default to all-gather, as it’s more likely to achieve better performance. Extensive <a href="https://discuss.pytorch.org/t/distributed-w-torchtitan-breaking-barriers-training-long-context-llms-with-1m-sequence-length-in-pytorch-using-context-parallel/215082" rel="nofollow">benchmarks</a> from the <code>torchtitan</code> team also show that all-to-all rarely outperforms all-gather. Though, we still provide both options, as you might find one to be better for your use case.',pt,he,ll="You can directly see this issue in the profiler output in the image below:",mt,v,al='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/accelerate/examples/fsdp2/cp_all_to_all.png" alt="all-to-all profiler output"/> <br/> <em>Figure 1: In red you can see the idle time, while we wait for the all-to-all kernel to finish. Highlighted in the first blue bar, you can see that it takes ~250us to finish, which is repeated N-1 times for each attention call, where N is the context parallel size.</em>',ut,de,ft,pe,il=`We only support context parallelism with <code>FSDP2</code>, as we create a joint mesh of <code>context_parallel_size</code> and <code>dp_shard_size</code> to
utilize its full potential.
How it works is: we shard the model across the joint mesh of size <code>cp_size*dp_shard_size</code>, which maximizes the memory savings.
This is a “free lunch” of sorts, as <code>FSDP</code> communication is fully overlapped with the computation of attention, as shown in the images below.`,yt,j,nl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/accelerate/examples/fsdp2/cp_why_fsdp2.png" alt="why FSDP2+CP"/> <br/> <em>Figure 2: In blue rectangles (Stream 23), you can see that the pre-fetch of `FSDP` shard is fully overlapped with the computation of attention (Stream 7), while in red rectangles (Stream 24), you can see that the all-gather kernel results in a bubble of idle time, in which our compute stream (7) is idle.</em>',gt,me,sl="In the figure above, you can also note the difference between all-to-all and all-gather. While in all-to-all (Figure 1), we launch a communication kernel N-1 times for each attention call, in all-gather (Figure 2), we launch a communication kernel only once. This results in a bigger bubble, but it only happens once per attention call, while in all-to-all, it happens N-1 times.",wt,ue,Mt,fe,ol=`We make sure to dispatch the same batch of data to the whole <code>cp</code> subgroup, so that the results are correct. (Meaning each rank in <code>cp</code> subgroup gets the same batch of data.) However, we also dispatch different batches to each rank of <code>dp_shard</code> group.
Imagine it like this:`,bt,ye,Tt,ge,xt,Te,$t;return k=new ul({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new y({props:{title:"Context Parallel in 🤗 accelerate",local:"context-parallel-in--accelerate",headingTag:"h1"}}),H=new y({props:{title:"Why context parallelism?",local:"why-context-parallelism",headingTag:"h2"}}),q=new y({props:{title:"How to use context parallelism?",local:"how-to-use-context-parallelism",headingTag:"h2"}}),W=new Me({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBQYXJhbGxlbGlzbUNvbmZpZyUyQyUyMFRvcmNoQ29udGV4dFBhcmFsbGVsQ29uZmlnJTBBJTBBJTJCJTIwY3BfY29uZmlnJTIwJTNEJTIwVG9yY2hDb250ZXh0UGFyYWxsZWxDb25maWcoJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3BfY29tbV9zdHJhdGVneSUzRCUyMmFsbHRvYWxsJTIyJTJDJTIwJTIzJTIwbm8lMjBuZWVkJTIwdG8lMjB1c2UlMjBjcF9jb25maWclMjBhdCUyMGFsbCUyQyUyMGlmJTIweW91JTIwd2FudCUyMHRvJTIwdXNlJTIwdGhlJTIwZGVmYXVsdCUyMCUyMmFsbGdhdGhlciUyMiUwQSUyQiUyMCklMEElMEElMkIlMjBwYXJhbGxlbGlzbV9jb25maWclMjAlM0QlMjBQYXJhbGxlbGlzbUNvbmZpZyglMEElMkIlMjAlMjAlMjAlMjAlMjBjcF9zaXplJTNEOCUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMGNwX2hhbmRsZXIlM0RjcF9jb25maWclMkMlMjAlMjAlMjMlMjBvciUyMGp1c3QlMjBjcF9zaXplJTNEOCUyQyUyMGlmJTIweW91JTIwd2FudCUyMHRvJTIwdXNlJTIwdGhlJTIwZGVmYXVsdCUyMCUyMmFsbGdhdGhlciUyMiUwQSUyQiUyMCklMEElMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHBhcmFsbGVsaXNtX2NvbmZpZyUzRHBhcmFsbGVsaXNtX2NvbmZpZyUyQyUwQSk=",highlighted:`from accelerate.utils import ParallelismConfig, TorchContextParallelConfig

<span class="hljs-addition">+ cp_config = TorchContextParallelConfig(</span>
<span class="hljs-addition">+       cp_comm_strategy=&quot;alltoall&quot;, # no need to use cp_config at all, if you want to use the default &quot;allgather&quot;</span>
<span class="hljs-addition">+ )</span>

<span class="hljs-addition">+ parallelism_config = ParallelismConfig(</span>
<span class="hljs-addition">+     cp_size=8,</span>
<span class="hljs-addition">+     cp_handler=cp_config,  # or just cp_size=8, if you want to use the default &quot;allgather&quot;</span>
<span class="hljs-addition">+ )</span>

accelerator = Accelerator(
    ...,
    parallelism_config=parallelism_config,
)`,wrap:!1}}),V=new Me({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tcGFyYWxsZWxpc20tY29uZmlnLWNwLXNpemUlMjA4JTIwLS1wYXJhbGxlbGlzbS1jb25maWctY3AtY29tbS1zdHJhdGVneSUyMCU1QmFsbGdhdGhlciU3Q2FsbHRvYWxsJTVEJTIwLi4u",highlighted:"accelerate launch --parallelism-config-cp-size 8 --parallelism-config-cp-comm-strategy [allgather|alltoall] ...",wrap:!1}}),F=new Me({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMGRhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwYWNjZWxlcmF0b3IubWF5YmVfY29udGV4dF9wYXJhbGxlbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBidWZmZXJzJTNEJTVCYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBiYXRjaCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVmZmVyX3NlcV9kaW1zJTNEJTVCMSUyQyUyMDElNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub19yZXN0b3JlX2J1ZmZlcnMlM0QlN0JiYXRjaCU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
    <span class="hljs-keyword">with</span> accelerator.maybe_context_parallel(
        buffers=[batch[<span class="hljs-string">&quot;input_ids&quot;</span>], batch[<span class="hljs-string">&quot;attention_mask&quot;</span>]],
        buffer_seq_dims=[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
        no_restore_buffers={batch[<span class="hljs-string">&quot;input_ids&quot;</span>], batch[<span class="hljs-string">&quot;labels&quot;</span>]},
    ):
        outputs = model(**batch)
        ...`,wrap:!1}}),Q=new Me({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tdXNlLWZzZHAlMjAtLWZzZHAtYWN0aXZhdGlvbi1jaGVja3BvaW50aW5nJTNEVFJVRSUyMGV4YW1wbGVzJTJGZnNkcDIlMkZuZF9wYXJhbGxlbC5weSUyMC0tY3Atc2l6ZSUzRDglMjAtLXNlcXVlbmNlLWxlbmd0aCUzRDEyODAwMA==",highlighted:"accelerate launch --use-fsdp --fsdp-activation-checkpointing=TRUE examples/fsdp2/nd_parallel.py --cp-size=8 --sequence-length=128000",wrap:!1}}),Y=new y({props:{title:"Accelerate’s interface",local:"accelerates-interface",headingTag:"h2"}}),Z=new y({props:{title:"Configurable options",local:"configurable-options",headingTag:"h2"}}),D=new y({props:{title:"Technical details",local:"technical-details",headingTag:"h2"}}),O=new y({props:{title:"So how does it work?",local:"so-how-does-it-work",headingTag:"h2"}}),le=new Me({props:{code:"Y29tbV9rZXJuZWwlMjAlM0QlMjAlN0IlMjJhbGxnYXRoZXIlMjIlM0ElMjBhbGxnYXRoZXIlMkMlMjAlMjJhbGx0b2FsbCUyMiUzQSUyMGFsbHRvYWxsJTdEJTVCY29udGV4dF9wYXJhbGxlbF9zaGFyZF9yb3RhdGlvbiU1RCUwQVFpJTJDJTIwS2klMkMlMjBWaSUyMCUzRCUyMHNoYXJkKFElMkMlMjBLJTJDJTIwViUyQyUyMHNlcV9kaW0pJTBBYXR0biU1QmklNUQlMjAlM0QlMjBhdHRuKFFpJTJDJTIwS2klMkMlMjBWaSklMEFmb3IlMjBqJTIwaW4lMjByYW5nZShjb250ZXh0X3BhcmFsbGVsX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwS2olMkMlMjBWaiUyMCUzRCUyMGNvbW1fa2VybmVsKCklMEElMjAlMjAlMjAlMjBhdHRuJTVCaiU1RCUyMCUzRCUyMGF0dG4oUWklMkMlMjBLaiUyQyUyMFZqKSUyMCUyMyUyMCU1QmJhdGNoJTJDJTIwbnVtX2hlYWRzJTJDJTIwc2VxX2xlbiUyMCUyRiUyRiUyMGNvbnRleHRfcGFyYWxsZWxfc2l6ZSUyQyUyMGhlYWRfZGltJTVEJTBBJTBBZmluYWxfYXR0biUyMCUzRCUyMGNvbWJpbmUoYXR0bik=",highlighted:`comm_kernel = {<span class="hljs-string">&quot;allgather&quot;</span>: allgather, <span class="hljs-string">&quot;alltoall&quot;</span>: alltoall}[context_parallel_shard_rotation]
Qi, Ki, Vi = shard(Q, K, V, seq_dim)
attn[i] = attn(Qi, Ki, Vi)
<span class="hljs-keyword">for</span> j <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(context_parallel_size):
    Kj, Vj = comm_kernel()
    attn[j] = attn(Qi, Kj, Vj) <span class="hljs-comment"># [batch, num_heads, seq_len // context_parallel_size, head_dim]</span>

final_attn = combine(attn)`,wrap:!1}}),ae=new y({props:{title:"all-to-all vs all-gather",local:"all-to-all-vs-all-gather",headingTag:"h2"}}),ie=new y({props:{title:"all-gather",local:"all-gather",headingTag:"h3"}}),se=new y({props:{title:"all-to-all",local:"all-to-all",headingTag:"h3"}}),re=new y({props:{title:"How to choose the right rotation method?",local:"how-to-choose-the-right-rotation-method",headingTag:"h2"}}),de=new y({props:{title:"Why only FSDP2?",local:"why-only-fsdp2",headingTag:"h2"}}),ue=new y({props:{title:"Data dispatching in joint mesh",local:"data-dispatching-in-joint-mesh",headingTag:"h2"}}),ye=new Me({props:{code:"YW5kJTIwc28lMjBvbi4=",highlighted:`<span class="hljs-comment"># 8 GPUS, --dp_shard_size 4, --cp_size 2</span>
<span class="hljs-comment"># mesh = [[0, 1], [2, 3], [4, 5], [6, 7]]</span>
<span class="hljs-comment"># model is sharded across the whole mesh (each GPU holds 1/8 of the model)</span>
<span class="hljs-comment"># GPUs 0,1 = batch 0</span>
<span class="hljs-comment"># GPUs 2,3 = batch 1</span>
... <span class="hljs-keyword">and</span> so <span class="hljs-keyword">on</span>.`,wrap:!1}}),ge=new fl({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/concept_guides/context_parallelism.md"}}),{c(){g=s("meta"),xe=i(),be=s("p"),$e=i(),c(k.$$.fragment),_e=i(),c(J.$$.fragment),Ue=i(),G=s("p"),G.innerHTML=kt,Ce=i(),c(H.$$.fragment),ve=i(),I=s("p"),I.innerHTML=Jt,je=i(),L=s("p"),L.textContent=Gt,ke=i(),c(q.$$.fragment),Je=i(),c(W.$$.fragment),Ge=i(),B=s("p"),B.innerHTML=Ht,He=i(),c(V.$$.fragment),Ie=i(),M=s("blockquote"),M.innerHTML=It,Le=i(),b=s("blockquote"),b.innerHTML=Lt,qe=i(),T=s("blockquote"),T.innerHTML=qt,We=i(),x=s("blockquote"),x.innerHTML=Wt,Be=i(),z=s("p"),z.innerHTML=Bt,Ve=i(),c(F.$$.fragment),ze=i(),$=s("blockquote"),$.innerHTML=Vt,Fe=i(),P=s("p"),P.textContent=zt,Pe=i(),_=s("p"),_.innerHTML=Ft,Qe=i(),w=s("blockquote"),we=s("p"),we.innerHTML=Pt,Ut=i(),c(Q.$$.fragment),Ye=i(),c(Y.$$.fragment),Ae=i(),A=s("p"),A.textContent=Qt,Se=i(),S=s("ul"),S.innerHTML=Yt,Ze=i(),U=s("blockquote"),U.innerHTML=At,Ee=i(),c(Z.$$.fragment),Ne=i(),E=s("p"),E.innerHTML=St,Xe=i(),N=s("ul"),N.innerHTML=Zt,Re=i(),X=s("p"),X.textContent=Et,De=i(),R=s("p"),R.innerHTML=Nt,Ke=i(),c(D.$$.fragment),Oe=i(),C=s("blockquote"),C.innerHTML=Xt,et=i(),K=s("p"),K.innerHTML=Rt,tt=i(),c(O.$$.fragment),lt=i(),ee=s("p"),ee.innerHTML=Dt,at=i(),te=s("p"),te.textContent=Kt,it=i(),c(le.$$.fragment),nt=i(),c(ae.$$.fragment),st=i(),c(ie.$$.fragment),ot=i(),ne=s("p"),ne.innerHTML=Ot,rt=i(),c(se.$$.fragment),ct=i(),oe=s("p"),oe.innerHTML=el,ht=i(),c(re.$$.fragment),dt=i(),ce=s("p"),ce.innerHTML=tl,pt=i(),he=s("p"),he.textContent=ll,mt=i(),v=s("p"),v.innerHTML=al,ut=i(),c(de.$$.fragment),ft=i(),pe=s("p"),pe.innerHTML=il,yt=i(),j=s("p"),j.innerHTML=nl,gt=i(),me=s("p"),me.textContent=sl,wt=i(),c(ue.$$.fragment),Mt=i(),fe=s("p"),fe.innerHTML=ol,bt=i(),c(ye.$$.fragment),Tt=i(),c(ge.$$.fragment),xt=i(),Te=s("p"),this.h()},l(e){const t=ml("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(l),xe=n(e),be=o(e,"P",{}),Ct(be).forEach(l),$e=n(e),h(k.$$.fragment,e),_e=n(e),h(J.$$.fragment,e),Ue=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1vuwxvs"&&(G.innerHTML=kt),Ce=n(e),h(H.$$.fragment,e),ve=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-2sleob"&&(I.innerHTML=Jt),je=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1u7kh92"&&(L.textContent=Gt),ke=n(e),h(q.$$.fragment,e),Je=n(e),h(W.$$.fragment,e),Ge=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1e2e60n"&&(B.innerHTML=Ht),He=n(e),h(V.$$.fragment,e),Ie=n(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1ncmwz6"&&(M.innerHTML=It),Le=n(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1io1dbt"&&(b.innerHTML=Lt),qe=n(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1ww4gnq"&&(T.innerHTML=qt),We=n(e),x=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-1vriq5e"&&(x.innerHTML=Wt),Be=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-q27r1v"&&(z.innerHTML=Bt),Ve=n(e),h(F.$$.fragment,e),ze=n(e),$=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r($)!=="svelte-1git15w"&&($.innerHTML=Vt),Fe=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-l1hp35"&&(P.textContent=zt),Pe=n(e),_=o(e,"P",{align:!0,"data-svelte-h":!0}),r(_)!=="svelte-zw16sw"&&(_.innerHTML=Ft),Qe=n(e),w=o(e,"BLOCKQUOTE",{class:!0});var _t=Ct(w);we=o(_t,"P",{"data-svelte-h":!0}),r(we)!=="svelte-7kbx6m"&&(we.innerHTML=Pt),Ut=n(_t),h(Q.$$.fragment,_t),_t.forEach(l),Ye=n(e),h(Y.$$.fragment,e),Ae=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-jcewir"&&(A.textContent=Qt),Se=n(e),S=o(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1npdv1z"&&(S.innerHTML=Yt),Ze=n(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-1kfcjij"&&(U.innerHTML=At),Ee=n(e),h(Z.$$.fragment,e),Ne=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-tidq8o"&&(E.innerHTML=St),Xe=n(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-19ddlaf"&&(N.innerHTML=Zt),Re=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-pt2d1o"&&(X.textContent=Et),De=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-8bfpem"&&(R.innerHTML=Nt),Ke=n(e),h(D.$$.fragment,e),Oe=n(e),C=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(C)!=="svelte-1f1d7d3"&&(C.innerHTML=Xt),et=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-5gcsxu"&&(K.innerHTML=Rt),tt=n(e),h(O.$$.fragment,e),lt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1q8d3hy"&&(ee.innerHTML=Dt),at=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-17jpam7"&&(te.textContent=Kt),it=n(e),h(le.$$.fragment,e),nt=n(e),h(ae.$$.fragment,e),st=n(e),h(ie.$$.fragment,e),ot=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-6a32kj"&&(ne.innerHTML=Ot),rt=n(e),h(se.$$.fragment,e),ct=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-jzgpzc"&&(oe.innerHTML=el),ht=n(e),h(re.$$.fragment,e),dt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1kj70ku"&&(ce.innerHTML=tl),pt=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1ldmtvt"&&(he.textContent=ll),mt=n(e),v=o(e,"P",{align:!0,"data-svelte-h":!0}),r(v)!=="svelte-1c3ofsn"&&(v.innerHTML=al),ut=n(e),h(de.$$.fragment,e),ft=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1ikc9rn"&&(pe.innerHTML=il),yt=n(e),j=o(e,"P",{align:!0,"data-svelte-h":!0}),r(j)!=="svelte-1jnhmn3"&&(j.innerHTML=nl),gt=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-10ujnkx"&&(me.textContent=sl),wt=n(e),h(ue.$$.fragment,e),Mt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-14bdjd0"&&(fe.innerHTML=ol),bt=n(e),h(ye.$$.fragment,e),Tt=n(e),h(ge.$$.fragment,e),xt=n(e),Te=o(e,"P",{}),Ct(Te).forEach(l),this.h()},h(){f(g,"name","hf:doc:metadata"),f(g,"content",gl),f(M,"class","tip"),f(b,"class","tip"),f(T,"class","warning"),f(x,"class","warning"),f($,"class","warning"),f(_,"align","center"),f(w,"class","tip"),f(U,"class","warning"),f(C,"class","tip"),f(v,"align","center"),f(j,"align","center")},m(e,t){vt(document.head,g),a(e,xe,t),a(e,be,t),a(e,$e,t),d(k,e,t),a(e,_e,t),d(J,e,t),a(e,Ue,t),a(e,G,t),a(e,Ce,t),d(H,e,t),a(e,ve,t),a(e,I,t),a(e,je,t),a(e,L,t),a(e,ke,t),d(q,e,t),a(e,Je,t),d(W,e,t),a(e,Ge,t),a(e,B,t),a(e,He,t),d(V,e,t),a(e,Ie,t),a(e,M,t),a(e,Le,t),a(e,b,t),a(e,qe,t),a(e,T,t),a(e,We,t),a(e,x,t),a(e,Be,t),a(e,z,t),a(e,Ve,t),d(F,e,t),a(e,ze,t),a(e,$,t),a(e,Fe,t),a(e,P,t),a(e,Pe,t),a(e,_,t),a(e,Qe,t),a(e,w,t),vt(w,we),vt(w,Ut),d(Q,w,null),a(e,Ye,t),d(Y,e,t),a(e,Ae,t),a(e,A,t),a(e,Se,t),a(e,S,t),a(e,Ze,t),a(e,U,t),a(e,Ee,t),d(Z,e,t),a(e,Ne,t),a(e,E,t),a(e,Xe,t),a(e,N,t),a(e,Re,t),a(e,X,t),a(e,De,t),a(e,R,t),a(e,Ke,t),d(D,e,t),a(e,Oe,t),a(e,C,t),a(e,et,t),a(e,K,t),a(e,tt,t),d(O,e,t),a(e,lt,t),a(e,ee,t),a(e,at,t),a(e,te,t),a(e,it,t),d(le,e,t),a(e,nt,t),d(ae,e,t),a(e,st,t),d(ie,e,t),a(e,ot,t),a(e,ne,t),a(e,rt,t),d(se,e,t),a(e,ct,t),a(e,oe,t),a(e,ht,t),d(re,e,t),a(e,dt,t),a(e,ce,t),a(e,pt,t),a(e,he,t),a(e,mt,t),a(e,v,t),a(e,ut,t),d(de,e,t),a(e,ft,t),a(e,pe,t),a(e,yt,t),a(e,j,t),a(e,gt,t),a(e,me,t),a(e,wt,t),d(ue,e,t),a(e,Mt,t),a(e,fe,t),a(e,bt,t),d(ye,e,t),a(e,Tt,t),d(ge,e,t),a(e,xt,t),a(e,Te,t),$t=!0},p:cl,i(e){$t||(p(k.$$.fragment,e),p(J.$$.fragment,e),p(H.$$.fragment,e),p(q.$$.fragment,e),p(W.$$.fragment,e),p(V.$$.fragment,e),p(F.$$.fragment,e),p(Q.$$.fragment,e),p(Y.$$.fragment,e),p(Z.$$.fragment,e),p(D.$$.fragment,e),p(O.$$.fragment,e),p(le.$$.fragment,e),p(ae.$$.fragment,e),p(ie.$$.fragment,e),p(se.$$.fragment,e),p(re.$$.fragment,e),p(de.$$.fragment,e),p(ue.$$.fragment,e),p(ye.$$.fragment,e),p(ge.$$.fragment,e),$t=!0)},o(e){m(k.$$.fragment,e),m(J.$$.fragment,e),m(H.$$.fragment,e),m(q.$$.fragment,e),m(W.$$.fragment,e),m(V.$$.fragment,e),m(F.$$.fragment,e),m(Q.$$.fragment,e),m(Y.$$.fragment,e),m(Z.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(se.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(ye.$$.fragment,e),m(ge.$$.fragment,e),$t=!1},d(e){e&&(l(xe),l(be),l($e),l(_e),l(Ue),l(G),l(Ce),l(ve),l(I),l(je),l(L),l(ke),l(Je),l(Ge),l(B),l(He),l(Ie),l(M),l(Le),l(b),l(qe),l(T),l(We),l(x),l(Be),l(z),l(Ve),l(ze),l($),l(Fe),l(P),l(Pe),l(_),l(Qe),l(w),l(Ye),l(Ae),l(A),l(Se),l(S),l(Ze),l(U),l(Ee),l(Ne),l(E),l(Xe),l(N),l(Re),l(X),l(De),l(R),l(Ke),l(Oe),l(C),l(et),l(K),l(tt),l(lt),l(ee),l(at),l(te),l(it),l(nt),l(st),l(ot),l(ne),l(rt),l(ct),l(oe),l(ht),l(dt),l(ce),l(pt),l(he),l(mt),l(v),l(ut),l(ft),l(pe),l(yt),l(j),l(gt),l(me),l(wt),l(Mt),l(fe),l(bt),l(Tt),l(xt),l(Te)),l(g),u(k,e),u(J,e),u(H,e),u(q,e),u(W,e),u(V,e),u(F,e),u(Q),u(Y,e),u(Z,e),u(D,e),u(O,e),u(le,e),u(ae,e),u(ie,e),u(se,e),u(re,e),u(de,e),u(ue,e),u(ye,e),u(ge,e)}}}const gl='{"title":"Context Parallel in 🤗 accelerate","local":"context-parallel-in--accelerate","sections":[{"title":"Why context parallelism?","local":"why-context-parallelism","sections":[],"depth":2},{"title":"How to use context parallelism?","local":"how-to-use-context-parallelism","sections":[],"depth":2},{"title":"Accelerate’s interface","local":"accelerates-interface","sections":[],"depth":2},{"title":"Configurable options","local":"configurable-options","sections":[],"depth":2},{"title":"Technical details","local":"technical-details","sections":[],"depth":2},{"title":"So how does it work?","local":"so-how-does-it-work","sections":[],"depth":2},{"title":"all-to-all vs all-gather","local":"all-to-all-vs-all-gather","sections":[{"title":"all-gather","local":"all-gather","sections":[],"depth":3},{"title":"all-to-all","local":"all-to-all","sections":[],"depth":3}],"depth":2},{"title":"How to choose the right rotation method?","local":"how-to-choose-the-right-rotation-method","sections":[],"depth":2},{"title":"Why only FSDP2?","local":"why-only-fsdp2","sections":[],"depth":2},{"title":"Data dispatching in joint mesh","local":"data-dispatching-in-joint-mesh","sections":[],"depth":2}],"depth":1}';function wl(jt){return hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $l extends dl{constructor(g){super(),pl(this,g,wl,yl,rl,{})}}export{$l as component};
