# Logging[[accelerate.logging.get_logger]]

Refer to the [Troubleshooting guide](../usage_guides/troubleshooting#logging) or to the example below to learn 
how to use Accelerate's logger. 

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>accelerate.logging.get_logger</name><anchor>accelerate.logging.get_logger</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/logging.py#L86</source><parameters>[{"name": "name", "val": ": str"}, {"name": "log_level", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **name** (`str`) --
  The name for the logger, such as `__file__`
- **log_level** (`str`, *optional*) --
  The log level to use. If not passed, will default to the `LOG_LEVEL` environment variable, or `INFO` if not</paramsdesc><paramgroups>0</paramgroups></docstring>

Returns a `logging.Logger` for `name` that can handle multiprocessing.

If a log should be called on all processes, pass `main_process_only=False` If a log should be called on all
processes and in order, also pass `in_order=True`



<ExampleCodeBlock anchor="accelerate.logging.get_logger.example">

Example:

```python
>>> from accelerate.logging import get_logger
>>> from accelerate import Accelerator

>>> logger = get_logger(__name__)

>>> accelerator = Accelerator()
>>> logger.info("My log", main_process_only=False)
>>> logger.debug("My log", main_process_only=True)

>>> logger = get_logger(__name__, log_level="DEBUG")
>>> logger.info("My log")
>>> logger.debug("My second log")

>>> array = ["a", "b", "c", "d"]
>>> letter_at_rank = array[accelerator.process_index]
>>> logger.info(letter_at_rank, in_order=True)
```

</ExampleCodeBlock>


</div>

<EditOnGithub source="https://github.com/huggingface/accelerate/blob/main/docs/source/package_reference/logging.md" />